/* Based on CPU DB MC9RS08KA2_8, version 2.87.057 (RegistersPrg V2.11) */
/*
** ###################################################################
**
** ###################################################################
*/

#ifndef _MAIN_H
#define _MAIN_H

#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */


#define DEBUG    FALSE       /* TRUE / FALSE */

#define WAIT()    __asm  wait
#define NOP()     __asm  nop

/*;=========================================================================
; Application Definition
;========================================================================= */

#define OUTPUT   PTAD_PTAD3
                 

typedef enum  CHANNEL_SWITCH  {
    CHANNEL_POT = 0,
    CHANNEL_THERM

} CHANNEL;



/* Application Status and Control Register */
typedef union {
  uchar Byte;
  struct {
    uchar bPmax         :1;    /* flag for saturation of integration factor in regulator module */
    uchar bSatFlag      :1;    /* flag for saturation of integration factor in regulator module - inside  F */
    uchar bChange       :1;    /* desired temperature was changed              */
    uchar bit3          :1;    /*             */
    uchar bit4          :1;    /*             */
    uchar bit5          :1;    /*             */
    uchar bit6          :1;    /*             */
    uchar bit7          :1;    /*             */ 
  } Bits;
} APPSCSTR;

extern volatile APPSCSTR   _APPSC;

#define APPSC                      _APPSC.Byte
#define APPSC_bPmax                _APPSC.Bits.bPmax
#define APPSC_bSatFlag             _APPSC.Bits.bSatFlag
#define APPSC_bChange              _APPSC.Bits.bChange
#define APPSC_3                    _APPSC.Bits.3
#define APPSC_4                    _APPSC.Bits.4
#define APPSC_5                    _APPSC.Bits.4
#define APPSC_6                    _APPSC.Bits.5
#define APPSC_7                    _APPSC.Bits.6


#define APPSC_bPmax_MASK          0
#define APPSC_bSatFlag_MASK       1

#endif  /* _MAIN_H */
