/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2005 Freescale Semiconductor, Inc.
* (c) Copyright 2001-2004 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file      sci.c
*
* @author    r79251
* 
* @version   1.1.0.0
* 
* @date      Sep-20-2007
* 
* @brief     Function sends characters over serial line.
*
*******************************************************************************/


#include "derivative.h"

#include "sci_cfg.h"
#include "sci.h"


#if defined(SCI_BAUDRATE)
    #if (SCI_BAUDRATE   == 38400)
        #define BIT_DURATION  28       /* SCI baudrate 38.4 kbps  */
    #elif (SCI_BAUDRATE == 19200)                    
        #define BIT_DURATION  56       /* SCI baudrate 19.2 kbps  */
    #elif (SCI_BAUDRATE == 9600)
        #define BIT_DURATION  112      /* SCI baudrate  9.6 kbps  */
    #else
        #error "Selected SCI_BAUDRATE is not supported. Choose just from the values  (38400, 19200, 9600)"    

    #endif
#else
    #error "The SCI_BAUDRATE is not defined in sci_cfg.h"
#endif





/*****************************************************************************
*
* @brief  Function sends characters over serial line.
*
* @param  ch - character to be transmited over emulated SCI
*
* @return Nothing
*
******************************************************************************
*
* Function <b>SCI_putc</b> 
* <LOW><b7><b6><b5><b4><b3><b2><b1><b0><HIGH>
*
******************************************************************************/ 

void SCI_putc (char ch)  
{

    char bitCount;
    char delay;

    if (ch == 0);   /* Disable the message C5703 "Parameter 'ch' 
                       declared in function 'SCI_putc' but not referenced */

    __asm {      
                    MOV #8, bitCount
                    BCLR  SCI_TXPIN, PTAD
          
        
        NEXT_BIT:     
                    MOV   #BIT_DURATION, delay   //4
                 
        W1:         DBNZ  delay,W1               //7
                    LSRA                         //1
                    BCC   CLEAR_PIN              //3
                    BSET  SCI_TXPIN, PTAD        //5
                    BRA   BIT_END                //3
        CLEAR_PIN:
                    BCLR  SCI_TXPIN, PTAD        //5                
     
        BIT_END:
                    DBNZ  bitCount, NEXT_BIT     //7
                
        BYTE_END:
                    MOV #BIT_DURATION, delay     //4
        W2:         DBNZ  delay,W2               //7
                    BSET  SCI_TXPIN, PTAD        //5 End bit    
                    MOV #BIT_DURATION, delay
        W3:         DBNZ  delay,W3
                    
    }
}