;** ###################################################################
;**     This code is generated by the Device Initialization Tool.
;**     It is overwritten during code generation.
;**     USER MODIFICATION ARE PRESERVED ONLY INSIDE INTERRUPT SERVICE ROUTINES
;**
;**     Project   : iron
;**     Processor : MC9RS08KA2CSC
;**     Version   : Bean 01.059, Driver 01.00, CPU db: 2.87.060
;**     Datasheet : MC9RS08KA2 Rev. 2 12/2006
;**     Date/Time : 9.11.2007, 14:14
;**     Abstract  :
;**         This module contains device initialization code 
;**         for selected on-chip peripherals.
;**     Contents  :
;**         Function "MCU_init" initializes selected peripherals
;**
;**     (c) Copyright UNIS, spol. s r.o. 1997-2006
;**     UNIS, spol s r.o.
;**     Jundrovska 33
;**     624 00 Brno
;**     Czech Republic
;**     http      : www.processorexpert.com
;**     mail      : info@processorexpert.com
;** ###################################################################

        INCLUDE MC9RS08KA2.inc         ; I/O map for MC9RS08KA2CSC

CODE_SECT:      SECTION

        XDEF    MCU_init
;** ===================================================================
;**     Method      :  MCU_init (bean MC9RS08KA2_8)
;**
;**     Description :
;**         Device initialization code for selected peripherals.
;** ===================================================================
MCU_init:
  ; ### MC9RS08KA2_8 "Cpu" init code ... 
  ; Common initialization of the write once registers 
        ; SOPT: COPE=0,COPT=1,STOPE=0,BKGDPE=0,RSTPE=0 
        MOV     #HIGH_6_13(SOPT),PAGESEL ; Set page register
        MOV     #$40,MAP_ADDR_6(SOPT)                          
        ; SPMSC1: LVDF=0,LVDACK=0,LVDIE=0,LVDRE=1,LVDSE=0,LVDE=1,BGBE=1 
        MOV     #HIGH_6_13(SPMSC1),PAGESEL ; Set page register
        MOV     #$15,MAP_ADDR_6(SPMSC1)                          
  ;  System clock initialization 
        ; ICSTRM: Initialize internal clock trim from a non volatile memory 
        MOV     #$FF,PAGESEL           ; Set page register
        LDA     $FA                    ; constant address $3FFA
        STA     ICSTRM
        ; ICSSC: Initialize internal clock trim from a non volatile memory 
        MOV     #$FF,PAGESEL           ; Set page register
        LDA     $FB                    ; constant address $3FFB
        STA     ICSSC
        ; ICSC1: CLKS=0,IREFSTEN=0 
        CLR     ICSC1                  ; Initialization of the ICS control register 1 
        ; ICSC2: BDIV=0,LP=0 
        CLR     ICSC2                  ; Initialization of the ICS control register 2 
  ; Common initialization of the CPU registers 
        ; PTASE: PTASE5=1,PTASE4=1,PTASE3=1,PTASE1=1,PTASE0=0 
        MOV     #HIGH_6_13(PTASE),PAGESEL ; Set page register
        LDA     MAP_ADDR_6(PTASE)
        AND     #$FE
        ORA     #$3A
        STA     MAP_ADDR_6(PTASE)
  ; ### Init_ACMP init code 
        ; ACMPSC: ACME=0,ACBGS=1,ACF=1,ACIE=1,ACO=0,ACOPE=0,ACMOD1=0,ACMOD0=0 
        MOV     #$70,ACMPSC                          
  ; ### Init_MTIM init code 
        ; MTIMMOD: MOD=0 
        CLR     MTIMMOD                                
        ; MTIMCLK: CLKS=0,PS=0 
        CLR     MTIMCLK                                
        ; MTIMSC: TOF=0,TOIE=0,TRST=0,TSTP=0 
        CLR     MTIMSC                                
  ; ### Init_KBI init code 
        ; KBISC: KBIE=0 
        BCLR    $01,KBISC
        ; KBIES: KBEDG5=0,KBEDG4=0,KBEDG2=1,KBEDG1=0,KBEDG0=0 
        MOV     #$04,KBIES                          
        ; KBISC: KBIMOD=0 
        BCLR    $00,KBISC
        ; KBIPE: KBIPE5=0,KBIPE4=0,KBIPE2=1,KBIPE1=0,KBIPE0=0 
        MOV     #$04,KBIPE                          
        ; KBISC: KBACK=1 
        BSET    $02,KBISC
        ; KBISC: KBIE=1 
        BSET    $01,KBISC
  ; ### Init_GPIO init code 
        ; PTAD: PTAD4=0,PTAD3=1,PTAD0=0 
        LDA     PTAD
        AND     #$EE
        ORA     #$08
        STA     PTAD
        ; PTADD: PTADD5=0,PTADD4=0,PTADD0=1 
        LDA     PTADD
        AND     #$CF
        ORA     #$01
        STA     PTADD
  ; ### Init_COP init code 
        MOV     #HIGH_6_13(SRS),PAGESEL ; Set page register
        MOV     #$FF,MAP_ADDR_6(SRS)   ; Clear WatchDog counter 
  ; ### 
        RTS



; Initialization of the CPU registers in FLASH 

        ; NVOPT: SECD=1 
        ORG     NVOPT
        DC.B    $FF


; Reset vector is JUMP instruction 
        XREF    _Startup
        ORG     $3FFD                  ; MCU after reset point
        JMP     _Startup               ; reset vector

        END

;** ###################################################################
;**
;**     This file was created by UNIS Processor Expert 3.00 [03.89]
;**     for the Freescale RS08 series of microcontrollers.
;**
;** ###################################################################
