#ifndef __INCsystemh
#define __INCsystemh

/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/system/system.h 2.5.1.8 2004/12/07 15:20:51 jdabbraccio Exp $
*
* Copyright Freescale Semiconductor, Inc. 2000-2004.  All rights reserved.
*
* Description:	System wide definitions, data types, and macros.
*
*----------------------------------------------------------------------------*/


#if defined(__MWERKS__)
#define MWERKS	1
#define GCC		0
#elif defined(__GNUC__)			/* && defined(__embedded__) */
#define MWERKS	0
#define GCC		1
#else
#error Unsupported Tool Chain
#endif /* Compiler switch */


#ifndef byte
typedef unsigned char byte;		/* generic byte memory                 */
#endif
typedef signed char int8;		/*  8 bit signed integer.              */
typedef unsigned char int8u;	/*  8 bit unsigned integer.            */
typedef short signed int int16;	/* 16 bit signed integer.              */
typedef unsigned short int int16u;	/* 16 bit unsigned integer.        */
typedef signed int int32;		/* 32 bit signed integer.              */
typedef unsigned int int32u;	/* 32 bit unsigned integer.            */
typedef int32u ADDRESS;
typedef int16u ADDR_ALIGN;

typedef volatile int8 Vint8;	/* volatile versions of specific size int's */
typedef volatile int8u Vint8u;
typedef volatile int16 Vint16;
typedef volatile int16u Vint16u;
typedef volatile int32 Vint32;
typedef volatile int32u Vint32u;

typedef int8u Boolean;			/* smallest memory element for Boolean */

#define FALSE	0
#define TRUE	1

typedef void (*PFN) (void);		/* generic pointer to a function             */
typedef void *Handle;			/* generic pointer to objects                */


/* OS Abstraction layer header */
#include "xx.h"


#if DEBUG || MWERKS

/* Debug facilities */
/* Levels
		Highest Level (Always Printed if Debug Build)
1		Revision control message and system-is-alive messages
2		Critical errors that will most likely cause a system machine fault
3		Errors that may still allows us to continue to run
4		Unexpected faults that are not handled in a specific manner
5		Unexpected faults that are handled
6		Expected faults that are handled
7		Program flow messages
8		General information
9		Detailed Program flow messages
10		Detailed general information
		Lowest Level (Only Printed if Level = 10)
*/
#define DBGL_SYSALIVE	1
#define DBGL_CERROR		2
#define DBGL_ERROR		3
#define DBGL_UNHFAULT	4
#define DBGL_UHFAULT	5
#define DBGL_EHFAULT	6
#define DBGL_INIT		DBGL_EHFAULT
#define DBGL_PFLOW		7
#define DBGL_GINFO		8
#define DBGL_DPFLOW		9
#define DBGL_DGINFO		10
#define DBGL_MAX		10

#endif

#if DEBUG

#define DBG_ALL_MODULES	0xffffffff

#ifndef DBG_MODULES
#define DBG_MODULES		DBG_ALL_MODULES
#endif

#ifndef DBG_LEVEL
#define DBG_LEVEL		DBGL_MAX
#endif

extern int dbg_modules;
extern int8u dbg_level;

#define Define_dbgmodule(module, module_name, string)	\
int (module);											\
char module_name[] = string

#define Declare_dbgmodule(module)						\
extern int module

#define dbg_addmodule(module, module_name)	(module = dbg_addmodulefn(module_name))

int dbg_addmodulefn(char module[]);
void dbg_rmmodulelast(void);
char *dbg_getmodule(int module);
void dbg_getmodulelevel(int *pmodule, int8u * pdbglevel);
void dbg_setmodulelevel(int module, int8u dbglevel);
void dbg_printmoduleslevels(void);
char *dbg_getversion(const char verNumbers[], char version[]);

#if MWERKS
inline void dbgprintisr(int module, int8u dbglevel, const char *a, ...)
{
	return;
}
inline void dbgprint(int module, int8u dbglevel, const char *a, ...)
{
	va_list ap;

	if ((module & dbg_modules) && (dbglevel <= dbg_level))
	{
		XF_printf("%s: ", dbg_getmodule(module));
		va_start(ap, a);
		vfprintf(stdout, a, ap);
		va_end(ap);
	}
	return;
}

#define WAIT(module)									\
				dbgprint(module, DBGL_SYSALIVE,			\
						"Press Enter to continue\n");	\
				XF_getchar()
#else

#define dbgprint(module, dbglevel, a...);			\
if ((module&dbg_modules)&&(dbglevel<=dbg_level))	\
{													\
	XF_printf("%s: ", dbg_getmodule(module));			\
	XF_printf(a);										\
}else;

#if !__KERNEL__

#define dbgprintisr(module, dbglevel, a...)
#define WAIT(module)									\
				dbgprint(module, DBGL_SYSALIVE,			\
						"Press Enter to continue\n");	\
				XF_getchar()

#else

#define dbgprintisr	dbgprint
#define WAIT(module)

#endif

#endif /* MWERKS */


#else /* !DEBUG */

#if MWERKS
#define Define_dbgmodule(module, module_name, string) \
int module=0
#define Declare_dbgmodule(module) \
extern int module
#else
#define Define_dbgmodule(module, module_name, string)
#define Declare_dbgmodule(module)
#endif /* MWERKS */

#define dbg_addmodule(module, module_name)
#define dbg_rmmodulelast()
#define dbg_getmodule(module)
#define dbg_getmodulelevel(pmodule, pdbglevel)
#define dbg_setmodulelevel(module, dbglevel)
#define dbg_printmoduleslevels()
#define dbg_getversion(verNumbers, version)	("\0")

#if MWERKS
inline void dbgprintisr(int module, int8u dbglevel, const char *a, ...)
{
	return;
}
inline void dbgprint(int module, int8u dbglevel, const char *a, ...)
{
	return;
}
#else
#define dbgprintisr(module, dbglevel, a...)
#define dbgprint(module, dbglevel, a...)
#endif /* MWERKS */

#define WAIT(module);

#endif /* DEBUG */


/*
	NOSA API Functions
*/
void NOSA_Init(void);
void NOSA_InterruptInit(ADDRESS internal_memory_map);
void NOSA_Background(void);
void NOSA_Cleanup(void);


#endif /* __INCsystemh */
