/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/headers/mpq_se.h 0.0.1.2 2004/07/26 15:37:01 jdabbraccio Exp $
*
* Copyright Freescale Semiconductor, Inc. 2004.  All rights reserved.
*
* Description:	Security Engine (SE) Registers.
*
*----------------------------------------------------------------------------*/


typedef _Packed struct
{
	byte _reserved0[0x08];
}
_PackedType crypto_bd;

typedef _Packed struct
{
	byte _reserved0[0x08];
	reg64 cccr;
	reg64 ccpsr;
	byte _reserved1[0x28];
	reg64 cdpr;
	reg64 ff;
	byte _reserved2[0x30];
	crypto_bd bd[8];
	byte _reserved3[0x40];
}
_PackedType crypto_ch;

typedef _Packed struct
{
	byte _reserved0[0x08];
	reg64 imr;
	reg64 isr;
	reg64 icr;
	reg64 id;
	reg64 euasr;
	reg64 mcr;
	byte _reserved1[0xC8];
	crypto_ch ch[4];
	byte _reserved2[0xB00];

	reg64 deumr;
	reg64 deuksr;
	reg64 deudsr;
	reg64 deurcr;
	byte _reserved3[0x08];
	reg64 deusr;
	reg64 deuisr;
	reg64 deuicr;
	byte _reserved4[0x10];
	reg64 deueug;
	byte _reserved5[0xA8];
	reg64 deuiv;
	byte _reserved6[0x2F8];
	reg64 deuk1;
	reg64 deuk2;
	reg64 deuk3;
	byte _reserved7[0x3E8];
	reg08 deufifo[0x800];
	byte _reserved8[0x1000];

	reg64 aesumr;
	reg64 aesuksr;
	reg64 aesudsr;
	reg64 aesurcr;
	byte _reserved9[0x08];
	reg64 aesusr;
	reg64 aesuisr;
	reg64 aesuicr;
	byte _reserved10[0x10];
	reg64 aesuemr;
	byte _reserved11[0xA8];
	reg64 aesucmr;
	byte _reserved12[0x2F8];
	reg64 aesuk1;
	reg64 aesuk2;
	byte _reserved13[0x3F0];
	reg08 aesufifo[0x800];
	byte _reserved14[0x1000];

	reg64 mdeumr;
	reg64 mdeuksr;
	reg64 mdeudsr;
	reg64 mdeurcr;
	byte _reserved15[0x08];
	reg64 mdeusr;
	reg64 mdeuisr;
	reg64 mdeuicr;
	byte _reserved16[0x10];
	reg64 mdeueug;
	byte _reserved17[0xA8];
	reg64 mdeucmr;
	byte _reserved18[0x2F8];
	reg64 mdeukm;
	byte _reserved19[0x3F8];
	reg08 mdeufifo[0x800];
	byte _reserved20[0x1000];

	reg64 afeumr;
	reg64 afeuksr;
	reg64 afeudsr;
	reg64 afeurcr;
	byte _reserved21[0x08];
	reg64 afeusr;
	reg64 afeuisr;
	reg64 afeuicr;
	byte _reserved22[0x10];
	reg64 afeuemr;
	byte _reserved23[0xA8];
	reg64 afeucmr;
	byte _reserved24[0xF8];
	reg64 afeucmp;
	byte _reserved25[0x1F8];
	reg64 afeukr0;
	reg64 afeukr1;
	byte _reserved26[0x3F0];
	reg08 afeufifo[0x800];
	byte _reserved27[0x1000];

	reg64 rngmr;
	byte _reserved28[0x08];
	reg64 rngdsr;
	reg64 rngrcr;
	byte _reserved29[0x08];
	reg64 rngsr;
	reg64 rngisr;
	reg64 rngicr;
	byte _reserved30[0x10];
	reg64 rngeug;
	byte _reserved31[0x7A8];
	reg08 rngfifo[0x800];
	byte _reserved32[0x1000];

	reg64 pkeumr;
	reg64 pkeuksr;
	reg64 pkeudsr;
	reg64 pkeurcr;
	byte _reserved33[0x08];
	reg64 pkeusr;
	reg64 pkeuisr;
	reg64 pkeuicr;
	reg64 pkeuabs;
	byte _reserved34[0x08];
	reg64 pkeueug;
	byte _reserved35[0x1A8];

	reg64 pkeupma0[0x08];
	reg64 pkeupma1[0x08];
	reg64 pkeupma2[0x08];
	reg64 pkeupma3[0x08];
	reg64 pkeupmb0[0x08];
	reg64 pkeupmb1[0x08];
	reg64 pkeupmb2[0x08];
	reg64 pkeupmb3[0x08];
	reg08 pkeupme[0x100];
	byte _reserved36[0x300];
	reg08 pkeupmn[0x100];
	byte _reserved37[0x3700];
}
_PackedType mpq_se;

