/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/headers/mpq_pic.h 0.1.1.4 2004/08/13 16:08:14 jdabbraccio Exp $
*
* Copyright Freescale Semiconductor, Inc. 2003-2004.  All rights reserved.
*
* Description:	Programmable Interrupt Controller (PIC) Registers.
*
*----------------------------------------------------------------------------*/


typedef _Packed struct {
	byte _reserved0[0x40];
	reg32 ipidr0;
	byte _reserved1[0x0C];
	reg32 ipidr1;
	byte _reserved2[0x0C];
	reg32 ipidr2;
	byte _reserved3[0x0C];
	reg32 ipidr3;
	byte _reserved4[0x0C];
	reg32 ctpr;
	byte _reserved5[0x0C];
	reg32 whoami;
	byte _reserved6[0x0C];
	reg32 iack;
	byte _reserved7[0x0C];
	reg32 eoi;
	byte _reserved8[0xF4C];
	reg32 frr;
	byte _reserved9[0x1C];
	reg32 gcr;
	byte _reserved10[0x5C];
	reg32 vir;
	byte _reserved11[0x0C];
	reg32 pir;
	byte _reserved12[0x0C];
	reg32 ipivpr0;
	byte _reserved13[0x0C];
	reg32 ipivpr1;
	byte _reserved14[0x0C];
	reg32 ipivpr2;
	byte _reserved15[0x0C];
	reg32 ipivpr3;
	byte _reserved16[0x0C];
	reg32 svr;
	byte _reserved17[0x0C];
	reg32 tfrr;
	byte _reserved18[0x0C];
	reg32 gtccr0;
	byte _reserved19[0x0C];
	reg32 gtbcr0;
	byte _reserved20[0x0C];
	reg32 gtvpr0;
	byte _reserved21[0x0C];
	reg32 gtdr0;
	byte _reserved22[0x0C];
	reg32 gtccr1;
	byte _reserved23[0x0C];
	reg32 gtbcr1;
	byte _reserved24[0x0C];
	reg32 gtvpr1;
	byte _reserved25[0x0C];
	reg32 gtdr1;
	byte _reserved26[0x0C];
	reg32 gtccr2;
	byte _reserved27[0x0C];
	reg32 gtbcr2;
	byte _reserved28[0x0C];
	reg32 gtvpr2;
	byte _reserved29[0x0C];
	reg32 gtdr2;
	byte _reserved30[0x0C];
	reg32 gtccr3;
	byte _reserved31[0x0C];
	reg32 gtbcr3;
	byte _reserved32[0x0C];
	reg32 gtvpr3;
	byte _reserved33[0x0C];
	reg32 gtdr3;
	byte _reserved34[0x10C];
	reg32 tcr;
	byte _reserved35[0x0C];
	reg32 irqsr0;
	byte _reserved36[0x0C];
	reg32 irqsr1;
	byte _reserved37[0x0C];
	reg32 cisr0;
	byte _reserved38[0x0C];
	reg32 cisr1;
	byte _reserved39[0xBC];
	reg32 msgr0;
	byte _reserved40[0x0C];
	reg32 msgr1;
	byte _reserved41[0x0C];
	reg32 msgr2;
	byte _reserved42[0x0C];
	reg32 msgr3;
	byte _reserved43[0xCC];
	reg32 mer;
	byte _reserved44[0x0C];
	reg32 msr;
	byte _reserved45[0xEAEC];
	reg32 eivpr0;
	byte _reserved46[0x0C];
	reg32 eidr0;
	byte _reserved47[0x0C];
	reg32 eivpr1;
	byte _reserved48[0x0C];
	reg32 eidr1;
	byte _reserved49[0x0C];
	reg32 eivpr2;
	byte _reserved50[0x0C];
	reg32 eidr2;
	byte _reserved51[0x0C];
	reg32 eivpr3;
	byte _reserved52[0x0C];
	reg32 eidr3;
	byte _reserved53[0x0C];
	reg32 eivpr4;
	byte _reserved54[0x0C];
	reg32 eidr4;
	byte _reserved55[0x0C];
	reg32 eivpr5;
	byte _reserved56[0x0C];
	reg32 eidr5;
	byte _reserved57[0x0C];
	reg32 eivpr6;
	byte _reserved58[0x0C];
	reg32 eidr6;
	byte _reserved59[0x0C];
	reg32 eivpr7;
	byte _reserved60[0x0C];
	reg32 eidr7;
	byte _reserved61[0x0C];
	reg32 eivpr8;
	byte _reserved62[0x0C];
	reg32 eidr8;
	byte _reserved63[0x0C];
	reg32 eivpr9;
	byte _reserved64[0x0C];
	reg32 eidr9;
	byte _reserved65[0x0C];
	reg32 eivpr10;
	byte _reserved66[0x0C];
	reg32 eidr10;
	byte _reserved67[0x0C];
	reg32 eivpr11;
	byte _reserved68[0x0C];
	reg32 eidr11;
	byte _reserved69[0x8C];
	reg32 iivpr0;
	byte _reserved70[0x0C];
	reg32 iidr0;
	byte _reserved71[0x0C];
	reg32 iivpr1;
	byte _reserved72[0x0C];
	reg32 iidr1;
	byte _reserved73[0x0C];
	reg32 iivpr2;
	byte _reserved74[0x0C];
	reg32 iidr2;
	byte _reserved75[0x0C];
	reg32 iivpr3;
	byte _reserved76[0x0C];
	reg32 iidr3;
	byte _reserved77[0x0C];
	reg32 iivpr4;
	byte _reserved78[0x0C];
	reg32 iidr4;
	byte _reserved79[0x0C];
	reg32 iivpr5;
	byte _reserved80[0x0C];
	reg32 iidr5;
	byte _reserved81[0x0C];
	reg32 iivpr6;
	byte _reserved82[0x0C];
	reg32 iidr6;
	byte _reserved83[0x0C];
	reg32 iivpr7;
	byte _reserved84[0x0C];
	reg32 iidr7;
	byte _reserved85[0x0C];
	reg32 iivpr8;
	byte _reserved86[0x0C];
	reg32 iidr8;
	byte _reserved87[0x0C];
	reg32 iivpr9;
	byte _reserved88[0x0C];
	reg32 iidr9;
	byte _reserved89[0x0C];
	reg32 iivpr10;
	byte _reserved90[0x0C];
	reg32 iidr10;
	byte _reserved91[0x0C];
	reg32 iivpr11;
	byte _reserved92[0x0C];
	reg32 iidr11;
	byte _reserved93[0x0C];
	reg32 iivpr12;
	byte _reserved94[0x0C];
	reg32 iidr12;
	byte _reserved95[0x0C];
	reg32 iivpr13;
	byte _reserved96[0x0C];
	reg32 iidr13;
	byte _reserved97[0x0C];
	reg32 iivpr14;
	byte _reserved98[0x0C];
	reg32 iidr14;
	byte _reserved99[0x0C];
	reg32 iivpr15;
	byte _reserved100[0x0C];
	reg32 iidr15;
	byte _reserved101[0x0C];
	reg32 iivpr16;
	byte _reserved102[0x0C];
	reg32 iidr16;
	byte _reserved103[0x0C];
	reg32 iivpr17;
	byte _reserved104[0x0C];
	reg32 iidr17;
	byte _reserved105[0x0C];
	reg32 iivpr18;
	byte _reserved106[0x0C];
	reg32 iidr18;
	byte _reserved107[0x0C];
	reg32 iivpr19;
	byte _reserved108[0x0C];
	reg32 iidr19;
	byte _reserved109[0x0C];
	reg32 iivpr20;
	byte _reserved110[0x0C];
	reg32 iidr20;
	byte _reserved111[0x0C];
	reg32 iivpr21;
	byte _reserved112[0x0C];
	reg32 iidr21;
	byte _reserved113[0x0C];
	reg32 iivpr22;
	byte _reserved114[0x0C];
	reg32 iidr22;
	byte _reserved115[0x0C];
	reg32 iivpr23;
	byte _reserved116[0x0C];
	reg32 iidr23;
	byte _reserved117[0x0C];
	reg32 iivpr24;
	byte _reserved118[0x0C];
	reg32 iidr24;
	byte _reserved119[0x0C];
	reg32 iivpr25;
	byte _reserved120[0x0C];
	reg32 iidr25;
	byte _reserved121[0x0C];
	reg32 iivpr26;
	byte _reserved122[0x0C];
	reg32 iidr26;
	byte _reserved123[0x0C];
	reg32 iivpr27;
	byte _reserved124[0x0C];
	reg32 iidr27;
	byte _reserved125[0x0C];
	reg32 iivpr28;
	byte _reserved126[0x0C];
	reg32 iidr28;
	byte _reserved127[0x0C];
	reg32 iivpr29;
	byte _reserved128[0x0C];
	reg32 iidr29;
	byte _reserved129[0x0C];
	reg32 iivpr30;
	byte _reserved130[0x0C];
	reg32 iidr30;
	byte _reserved131[0x0C];
	reg32 iivpr31;
	byte _reserved132[0x0C];
	reg32 iidr31;
	byte _reserved133[0x100C];
	reg32 mivpr0;
	byte _reserved134[0x0C];
	reg32 midr0;
	byte _reserved135[0x0C];
	reg32 mivpr1;
	byte _reserved136[0x0C];
	reg32 midr1;
	byte _reserved137[0x0C];
	reg32 mivpr2;
	byte _reserved138[0x0C];
	reg32 midr2;
	byte _reserved139[0x0C];
	reg32 mivpr3;
	byte _reserved140[0x0C];
	reg32 midr3;
	byte _reserved141[0xE9CC];
	reg32 ipi0dr0;
	byte _reserved142[0x0C];
	reg32 ipi0dr1;
	byte _reserved143[0x0C];
	reg32 ipi0dr2;
	byte _reserved144[0x0C];
	reg32 ipi0dr3;
	byte _reserved145[0x0C];
	reg32 ctpr0;
	byte _reserved146[0x0C];
	reg32 whoami0;
	byte _reserved147[0x0C];
	reg32 iack0;
	byte _reserved148[0x0C];
	reg32 eoi0;
	byte _reserved149[0x1FF4C];
}
_PackedType mpq_pic;

/* Internal interrupt sources - this does not include interrupts generated by the PIC unit */
#define MPC85xx_PIC_OFFSET					64
#define SIVEC_INTERNAL_L2_CACHE				((uint)0 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_ECM					((uint)1 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_DDR_DRAM				((uint)2 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_LBC					((uint)3 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_DMA_0				((uint)4 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_DMA_1				((uint)5 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_DMA_2				((uint)6 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_DMA_3				((uint)7 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_PCI_PCIX				((uint)8 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_RIO_PW_ERR			((uint)9 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_RIO_IN_DRB			((uint)10 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_RIO_OUT_MSG			((uint)11 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_RIO_IN_MSG			((uint)12 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_TSEC_1_TX			((uint)13 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_TSEC_1_RX			((uint)14 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_TSEC_1_ERR			((uint)18 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_TSEC_2_TX			((uint)19 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_TSEC_2_RX			((uint)20 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_TSEC_2_ERR			((uint)24 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_FEC					((uint)25 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_I2C					((uint)27 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_PMI					((uint)28 + MPC85xx_PIC_OFFSET)
#define SIVEC_INTERNAL_CPM					((uint)30 + MPC85xx_PIC_OFFSET)

