/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/headers/mpq_pcix.h 0.1.1.3 2004/07/26 15:36:59 jdabbraccio Exp $
*
* Copyright Freescale Semiconductor, Inc. 2003-2004.  All rights reserved.
*
* Description:	PCI/X Registers.
*
*----------------------------------------------------------------------------*/


typedef _Packed struct
{
	reg32 potar;
	reg32 potear;
	byte _reserved0[0x08];
	reg32 powar;
	byte _reserved1[0x0C];
}
_PackedType pci_obw_default;

typedef _Packed struct
{
	reg32 potar;
	reg32 potear;
	reg32 powbar;
	byte _reserved0[0x04];
	reg32 powar;
	byte _reserved1[0x0C];
}
_PackedType pci_obw;


typedef _Packed struct
{
	reg32 pitar;
	byte _reserved0[0x04];
	reg32 piwbar;
	reg32 piwbear;
	reg32 piwar;
	byte _reserved1[0x0C];
}
_PackedType pci_ibw;

typedef _Packed struct
{
	reg32 cfg_addr;
	reg32 cfg_data;
	reg32 int_ack;
	byte _reserved0[0xBF4];
	pci_obw_default obw_default;
	pci_obw obw[4];
	byte _reserved1[0x100];
	pci_ibw ibw[3];
	reg32 err_d;
	reg32 err_cap_d;
	reg32 err_en;
	reg32 err_attrib;
	reg32 err_addr;
	reg32 err_ext_addr;
	reg32 err_dl;
	reg32 err_dh;
	reg32 gas_tim;
#if MPC8540 || MPC8560
	reg32 pcix_tim;
	byte _reserved2[0x171D8];
#elif MPC8555
	byte _reserved2[0x1DC];
#endif
}
_PackedType mpq_pcix;

#define	mpq_pci	mpq_pcix
