/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/headers/mpq_fec.h 0.0 2004/08/13 16:12:55 jdabbraccio Exp $
*
* Copyright Freescale Semiconductor, Inc. 2004.  All rights reserved.
*
* Description:	Fast Ethernet (FEC) Registers.
*
*----------------------------------------------------------------------------*/


typedef _Packed struct
{
	byte _reserved0[0x10];
	reg32 ievent;
	reg32 imask;
	reg32 edis;
	byte _reserved1[0x08];
	reg32 minflr;
	reg32 ptv;
	reg32 dmactrl;
	byte _reserved2[0x5C];
	reg32 fifo_tx_thr;
	byte _reserved3[0x08];
	reg32 fifo_tx_starve;
	reg32 fifo_tx_starve_shutoff;
	byte _reserved4[0x60];
	reg32 tctrl;
	reg32 tstat;
	byte _reserved5[0x04];
	reg32 tbdlen;
	byte _reserved6[0x14];
	reg32 ctbptr;
	byte _reserved7[0x5C];
	reg32 tbptr;
	byte _reserved8[0x7C];
	reg32 tbase;
	byte _reserved9[0xA8];
	reg32 ostbd;
	reg32 ostbdp;
	byte _reserved10[0x48];
	reg32 rctrl;
	reg32 rstat;
	byte _reserved11[0x04];
	reg32 rbdlen;
	byte _reserved12[0x14];
	reg32 crbptr;
	byte _reserved13[0x18];
	reg32 mrblr;
	byte _reserved14[0x40];
	reg32 rbptr;
	byte _reserved15[124];
	reg32 rbase;
	byte _reserved16[0xF8];
	reg32 maccfg1;
	reg32 maccfg2;
	reg32 ipgifgi;
	reg32 hafdup;
	reg32 maxfrm;
	byte _reserved17[0x28];
	reg32 ifstat;
	reg32 macstnaddr1;
	reg32 macstnaddr2;
	byte _reserved18[0x2B8];
	reg32 iaddr[8];
	byte _reserved19[0x60];
	reg32 gaddr[8];
	byte _reserved20[0x358];
	reg32 attr;
	reg32 attreli;
	byte _reserved21[1 * KBYTES];
}
_PackedType mpq_fec;


#if 0

/* TSEC Rx BD Masks */
#define RXBD_TSEC_RO1		0x4000
#define RXBD_TSEC_F			0x0400
#define RXBD_TSEC_M			0x0100
#define RXBD_TSEC_BC		0x0080
#define RXBD_TSEC_MC		0x0040
#define RXBD_TSEC_LG		0x0020
#define RXBD_TSEC_NO		0x0010
#define RXBD_TSEC_SH		0x0008
#define RXBD_TSEC_CR		0x0004
#define RXBD_TSEC_OV		0x0002
#define RXBD_TSEC_TR		0x0001

/* TSEC Tx BD Masks */
#define TXBD_TSEC_PAD		0x4000
#define TXBD_TSEC_TC		0x0400
#define TXBD_TSEC_DEF		0x0200
#define TXBD_TSEC_LC		0x0080
#define TXBD_TSEC_RL		0x0040
#define TXBD_TSEC_RC		0x003C
#define TXBD_TSEC_UN		0x0002

/* Interrupt Event Register (IEVENT) */
#define IEVENT_BABR			0x80000000
#define IEVENT_RXC			0x40000000
#define IEVENT_BSY			0x20000000
#define IEVENT_EBERR		0x10000000
#define IEVENT_MSRO			0x04000000
#define IEVENT_GTSC			0x02000000
#define IEVENT_BABT			0x01000000
#define IEVENT_TXC			0x00800000
#define IEVENT_TXE			0x00400000
#define IEVENT_TXB			0x00200000
#define IEVENT_TXF			0x00100000
#define IEVENT_LC			0x00040000
#define IEVENT_CRL			0x00020000
#define IEVENT_XFUN			0x00010000
#define IEVENT_RXBO			0x00008000
#define IEVENT_GRSC			0x00000100
#define IEVENT_RXF			0x00000080

/* Interrupt Mask Register (IMASK) */
#define IMASK_BREN			0x80000000
#define IMASK_RXCEN			0x40000000
#define IMASK_BSYEN			0x20000000
#define IMASK_EBERREN		0x10000000
#define IMASK_MSROEN		0x04000000
#define IMASK_GTSCEN		0x02000000
#define IMASK_BTEN			0x01000000
#define IMASK_TXCEN			0x00800000
#define IMASK_TXEEN			0x00400000
#define IMASK_TXBEN			0x00200000
#define IMASK_TXFEN			0x00100000
#define IMASK_LCEN			0x00040000
#define IMASK_CRLEN			0x00020000
#define IMASK_XFUNEN		0x00010000
#define IMASK_RXBEN			0x00008000
#define IMASK_GRSCEN		0x00000100
#define IMASK_RXFEN			0x00000080

/* Ethernet Control Register (ECNTRL) */
#define ECNTRL_CLRCNT		0x00004000
#define ECNTRL_AUTOZ		0x00002000
#define ECNTRL_STEN			0x00001000
#define ECNTRL_TBIM			0x00000020
#define ECNTRL_RPM			0x00000010
#define ECNTRL_R100M		0x00000008

/* DMA Control Register (DMACTRL) */
#define DMACTRL_TDSEN		0x00000080
#define DMACTRL_TBDSEN		0x00000040
#define DMACTRL_GRS			0x00000010
#define DMACTRL_GTS			0x00000008
#define DMACTRL_TOD			0x00000004
#define DMACTRL_WWR			0x00000002
#define DMACTRL_WOP			0x00000001

/* Transmit Status Register (TSTAT) */
#define TSTAT_THLT			0x80000000

/* Transmit Interrupt Coalescing Configuration Register (TXIC) */
#define TXIC_ICEN			0x80000000
#define TXIC_ICFCT			0x1FE00000
#define TXIC_ICFCTs			(31-10)
#define TXIC_ICTT			0x0000FFFF
#define TXIC_ICTTs			(31-31)

/* Receive Control Register (RCTRL) */
#define RCTRL_BC_REJ		0x00000010
#define RCTRL_PROM			0x00000008
#define RCTRL_RSF			0x00000004

/* Receive Status Register (RSTAT) */
#define RSTAT_QHLT			0x00800000

/* Receive Interrupt Coalescing Configuration Register (RXIC) */
#define RXIC_ICEN			0x80000000
#define RXIC_ICFCT			0x1FE00000
#define RXIC_ICFCTs			(31-10)
#define RXIC_ICTT			0x0000FFFF
#define RXIC_ICTTs			(31-31)

/* MII Management Configuration Register (MIIMCFG) */
#define MIIMCFG_RESET			0x80000000
#define MIIMCFG_CLOCK_DIV_2		0x00000000
#define MIIMCFG_CLOCK_DIV_4		0x00000001
#define MIIMCFG_CLOCK_DIV_6		0x00000002
#define MIIMCFG_CLOCK_DIV_8		0x00000003
#define MIIMCFG_CLOCK_DIV_10	0x00000004
#define MIIMCFG_CLOCK_DIV_14	0x00000005
#define MIIMCFG_CLOCK_DIV_20	0x00000006
#define MIIMCFG_CLOCK_DIV_28	0x00000007

/* MII Management Indicator Register (MIIMIND) */
#define MIIMIND_NOT_VALID		0x00000004
#define MIIMIND_SCAN			0x00000002
#define MIIMIND_BUSY			0x00000001

/* MII Management Status Register (MIIMSTAT) */
#define MIIMSTAT_PHY_STATUS		0x0000FFFF

/* MII Management Command Register (MIIMCOM) */
#define MIIMCOM_READ			0x00000001

/* MAC Configuration Register #1 (MACCFG1) */
#define MACCFG1_SOFT_RESET		0x80000000
#define MACCFG1_RESET_RX_MC		0x00080000
#define MACCFG1_RESET_TX_MC		0x00040000
#define MACCFG1_RESET_RX_FUN	0x00020000
#define MACCFG1_RESET_TX_FUN	0x00010000
#define MACCFG1_LOOPBACK		0x00000100
#define MACCFG1_RXFLOW			0x00000020
#define MACCFG1_TXFLOW			0x00000010
#define MACCFG1_SYNC_RXEN		0x00000008
#define MACCFG1_RXEN			0x00000004
#define MACCFG1_SYNC_TXEN		0x00000002
#define MACCFG1_TXEN			0x00000001

/* MAC Configuration Register #2 (MACCFG2) */
#define MACCFG2_PRE7			0x00007000
#define MACCFG2_IF				0x00000300
#define MACCFG2_GMII_TBI_MODE	0x00000200
#define MACCFG2_MII_MODE		0x00000100
#define MACCFG2_HUGE_FRAME		0x00000020
#define MACCFG2_LENGTH_CHECK	0x00000010
#define MACCFG2_PAD_CRC			0x00000004
#define MACCFG2_CRC_ENABLE		0x00000002
#define MACCFG2_FULL_DUPLEX		0x00000001

/* Attribute Register (ATTR) */
#define ATTR_ELCWT_NONE			0x00000000
#define ATTR_ELCWT_ALLOC_L2		0x00004000
#define ATTR_ELCWT_ALLOC_LL2	0x00006000
#define ATTR_BDLWT_NONE			0x00000000
#define ATTR_BDLWT_ALLOC_L2		0x00000800
#define ATTR_BDLWT_ALLOC_LL2	0x00000c00
#define ATTR_RDSEN				0x00000080
#define ATTR_RBDSEN				0x00000040

/* Attribute Extract Length and Extract Index Register (ATTRELI) */
#define ATTRELI_EL				0x3FFF0000
#define ATTRELI_ELs				(31-15)
#define ATTRELI_EI				0x00003FFF
#define ATTRELI_EIs				(31-31)

#endif
