/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/headers/mpq_dma.h 0.1.1.2 2004/07/26 15:36:58 jdabbraccio Exp $
*
* Copyright Freescale Semiconductor, Inc. 2003-2004.  All rights reserved.
*
* Description:	DMA Registers.
*
*----------------------------------------------------------------------------*/


typedef _Packed struct
{
	reg32 mr;
	reg32 sr;
	byte _reserved0[0x04];
	reg32 clndar;
	reg32 satr;
	reg32 sar;
	reg32 datr;
	reg32 dar;
	reg32 bcr;
	byte _reserved1[0x04];
	reg32 nlndar;
	byte _reserved2[0x08];
	reg32 clsdar;
	byte _reserved3[0x04];
	reg32 nlsdar;
	reg32 ssr;
	reg32 dsr;
	byte _reserved4[0x38];
}
_PackedType dma_gr;


typedef _Packed struct
{
	dma_gr n[4];
	reg32 dgsr;
	byte _reserved0[0x2CFC];
}
_PackedType mpq_dma;


/* Mode Register (MR) */
#define MR_BWC				0x0f000000
#define MR_BWCs				(31-7)
#define MR_EMP_EN			0x00200000
#define MR_EMS_EN			0x00040000
#define MR_DAHTS			0x00030000
#define MR_DAHTSs			(31-15)
#define MR_SAHTS			0x0000c000
#define MR_SAHTSs			(31-17)
#define MR_DAHE				0x00002000
#define MR_SAHE				0x00001000
#define MR_SRW				0x00000400
#define MR_EOSIE			0x00000200
#define MR_EOLNIE			0x00000100
#define MR_EOLSIE			0x00000080
#define MR_PEIE				0x00000040
#define MR_XFE				0x00000020
#define MR_CDSM				0x00000010
#define MR_SWSM				0x00000010
#define MR_CA				0x00000008
#define MR_CTM				0x00000004
#define MR_CC				0x00000002
#define MR_CS				0x00000001

/* Status Register (SR) */
#define SR_TE				0x00000080
#define SR_CH				0x00000020
#define SR_PE				0x00000010
#define SR_EOLNI			0x00000008
#define SR_CB				0x00000004
#define SR_EOSI				0x00000002
#define SR_EOLSI			0x00000001

/* Current Link Descriptor Address Register (CLNDAR) */
#define CLNDAR_CLNDA		0xffffffe0
#define CLNDAR_CLNDAs		(31-26)
#define CLNDAR_CLNDA_EOSIE	0x00000008

/* Source Attributes Register (SATR) */
#define SATR_SBPATMU		0x20000000
#define SATR_STFLOWLVL		0x0c000000
#define SATR_STFLOWLVLs		(31-5)
#define SATR_SPCIORDER		0x02000000
#define SATR_SSME			0x01000000
#define SATR_STRANSINT		0x00f00000
#define SATR_STRANSINTs		(31-11)
#define SATR_SREADTTYPE		0x000f0000
#define SATR_SREADTTYPEs	(31-15)
#define SATR_ESAD			0x000003ff
#define SATR_ESADs			(31-31)

/* Source Address Register for RapidIO Maintenance Reads (SARM) */
#define SARM_HOP_COUNT		0xff000000
#define SARM_HOP_COUNTs		(31-7)
#define SARM_CONFIG_OFFSET	0x00fffffc
#define SARM_CONFIG_OFFSETs	(31-29)

/* Destination Attributes Register (DATR) */
#define DATR_DBPATMU		0x20000000
#define DATR_DTFLOWLVL		0x0c000000
#define DATR_DTFLOWLVLs		(31-5)
#define DATR_DPCI_ORDER		0x02000000
#define DATR_DSME			0x01000000
#define DATR_DTRANSINT		0x00f00000
#define DATR_DTRANSINTs		(31-11)
#define DATR_DWRITETTYPE	0x000f0000
#define DATR_DWRITETTYPEs	(31-15)
#define DATR_EDAD			0x000003ff
#define DATR_EDADs			(31-31)

/* Destination Address Register for RapidIO Maintenance Writes (DARM) */
#define DARM_HOP_COUNT		0xff000000
#define DARM_HOP_COUNTs		(31-7)
#define DARM_CONFIG_OFFSET	0x00fffffc
#define DARM_CONFIG_OFFSETs	(31-31)

/* Next Link Descriptor Address Register (NLNDAR) */
#define NLNDAR_NLNDA		0xffffffe0
#define NLNDAR_NLNDAs		(31-26)
#define NLNDAR_NDEOSIE		0x00000008
#define NLNDAR_EOLND		0x00000001
#define NLNDAR_EOLNDs		(31-31)

/* Next List Descriptor Address Register (NLSDAR) */
#define NLSDAR_NLSDA		0xffffffe0
#define NLSDAR_NLSDAs		(31-26)
#define NLSDAR_EOLSD		0x00000001

/* Source Stride Register (SSR) */
#define SSR_SSS				0x00fff000
#define SSR_SSSs			(31-19)
#define SSR_SSD				0x00000fff
#define SSR_SSDs			(31-31)

/* Destination Stride Register (DSR) */
#define DSR_DSS				0x00fff000
#define DSR_DSSs			(31-19)
#define DSR_DSD				0x00000fff
#define DSR_DSDs			(31-31)

/* DMA General Status Register (DGSR) */
#define DGSR_TE0			0x80000000
#define DGSR_CH0			0x20000000
#define DGSR_PEI0			0x10000000
#define DGSR_EOLNI0			0x08000000
#define DGSR_CB0			0x04000000
#define DGSR_EOSI0			0x02000000
#define DGSR_EOLSI0			0x01000000
#define DGSR_TE1			0x00800000
#define DGSR_CH1			0x00200000
#define DGSR_PEI1			0x00100000
#define DGSR_EOLNI1			0x00080000
#define DGSR_CB1			0x00040000
#define DGSR_EOSI1			0x00020000
#define DGSR_EOLSI1			0x00010000
#define DGSR_TE2			0x00008000
#define DGSR_CH2			0x00002000
#define DGSR_PEI2			0x00001000
#define DGSR_EOLNI2			0x00000800
#define DGSR_CB2			0x00000400
#define DGSR_EOSI2			0x00000200
#define DGSR_EOLSI2			0x00000100
#define DGSR_TE3			0x00000080
#define DGSR_CH3			0x00000020
#define DGSR_PEI3			0x00000010
#define DGSR_EOLNI3			0x00000008
#define DGSR_CB3			0x00000004
#define DGSR_EOSI3			0x00000002
#define DGSR_EOLSI3			0x00000001
