/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/headers/mpq_cpm_pram.h 0.1.1.6 2004/08/13 16:10:21 jdabbraccio Exp $
*
* Copyright Freescale Semiconductor, Inc. 2003-2004.  All rights reserved.
*
* Description:	Structures and registers used by the cpm protocols in the
*				PowerQUICC Family.
*
*----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
*		Serial Communications Controllers
*----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
*
*		SCC UART
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	byte _reserved0[0x08];
	reg16 max_idl;
	reg16 idlc;
	reg16 brkcr;
	reg16 parec;
	reg16 frmec;
	reg16 nosec;
	reg16 brkec;
	reg16 brkln;
	reg16 uaddr1;
	reg16 uaddr2;
	reg16 rtemp;
	reg16 toseq;
	reg16 cc[0x08];
	reg16 rccm;
	reg16 rccr;
	reg16 rlbc;
	byte _reserved1[0x9A];
}
_PackedType scc_uart_pram;

/* UART Rx BD Masks */
#define RXBD_SUART_C	0x0800		/* Control character */
#define RXBD_SUART_A	0x0400		/* Address */
#define RXBD_SUART_CM	0x0200		/* Continuous mode */
#define RXBD_SUART_ID	0x0100		/* Buffer closed on reception of idles */
#define RXBD_SUART_AM	0x0080		/* Address match (automatic moultidrop mode) */
#define RXBD_SUART_BR	0x0020		/* Break received */
#define RXBD_SUART_FR	0x0010		/* Framing error */
#define RXBD_SUART_PR	0x0008		/* Parity error */
#define RXBD_SUART_OV	0x0002		/* Overrun */
#define RXBD_SUART_CD	0x0001		/* Carrier detect lost */

/* UART Tx BD Masks */
#define TXBD_SUART_CR	0x0800		/* Clear-to-send report */
#define TXBD_SUART_A	0x0400		/* Address. Multidrop automatic or manual */
#define TXBD_SUART_CM	0x0200		/* Continuos mode */
#define TXBD_SUART_P	0x0100		/* Preamble */
#define TXBD_SUART_NS	0x0080		/* No stop bit or shaved stop bit sent */
#define TXBD_SUART_CT	0x0001		/* Clear-to-send lost */

/*-----------------------------------------------------------------------------
*
*		SCC HDLC
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	byte _reserved0[4];
	reg32 c_mask;
	reg32 c_pres;
	reg16 disfc;
	reg16 crcec;
	reg16 abtsc;
	reg16 nmarc;
	reg16 retrc;
	reg16 mflr;
	reg16 max_cnt;
	reg16 rfthr;
	reg16 rfcnt;
	reg16 hmask;
	reg16 haddr[0x04];
	reg16 tmp;
	reg16 tmp_mb;
	byte _reserved1[0xA4];
}
_PackedType scc_hdlc_pram;


/*-----------------------------------------------------------------------------
*
*		SCC BISYNC
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	byte _reserved0[0x04];
	reg32 crcc;
	reg16 prcrc;
	reg16 ptcrc;
	reg16 parec;
	reg16 bsync;
	reg16 bdle;
	reg16 cchar[8];
	reg16 rccm;
	byte _reserved1[0xAC];
}
_PackedType scc_bisync_pram;


/*-----------------------------------------------------------------------------
*
*		SCC Transparent
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg32 crc_p;
	reg32 crc_c;
	byte _reserved0[0xC8];
}
_PackedType scc_trans_pram;


/*-----------------------------------------------------------------------------
*
*		SCC Ethernet
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg32 c_pres;
	reg32 c_mask;
	reg32 crcec;
	reg32 alec;
	reg32 disfc;
	reg16 pads;
	reg16 ret_lim;
	reg16 ret_cnt;
	reg16 mflr;
	reg16 minflr;
	reg16 maxd1;
	reg16 maxd2;
	reg16 maxd;
	reg16 dma_cnt;
	reg16 max_b;
	reg16 gaddr[0x04];
	reg32 tbuf0_data[0x02];
	reg32 tbuf0_rba0;
	reg32 tbuf0_crc;
	reg16 tbuf0_bcnt;
	reg16 paddr1_h;
	reg16 paddr1_m;
	reg16 paddr1_l;
	reg16 p_per;
	reg16 rfbd_ptr;
	reg16 tfbd_ptr;
	reg16 tlbd_ptr;
	reg32 tbuf1_data[0x02];
	reg32 tbuf1_rba0;
	reg32 tbuf1_crc;
	reg16 tbuf1_bcnt;
	reg16 tx_len;
	reg16 iaddr[0x04];
	reg16 boff_cnt;
	reg16 taddr_h;
	reg16 taddr_m;
	reg16 taddr_l;
	byte _reserved0[0x5C];
}
_PackedType scc_enet_pram;


/*-----------------------------------------------------------------------------
*
*		SCC Apple Talk
*
*----------------------------------------------------------------------------*/

/* tbd */


/*-----------------------------------------------------------------------------
*
*		SCC
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg16 rbase;
	reg16 tbase;
	reg08 rfcr;
	reg08 tfcr;
	reg16 mrblr;
	reg32 rstate;
	reg32 _riptr;
	reg16 rbptr;
	reg16 _ricount;
	reg32 _rtemp;
	reg32 tstate;
	reg32 _tiptr;
	reg16 tbptr;
	reg16 _ticount;
	reg32 _ttemp;
	reg32 rcrc;
	reg32 tcrc;
	_Packed union
	{
		scc_uart_pram uart;
		scc_hdlc_pram hdlc;
		scc_bisync_pram bisync;
		scc_trans_pram trans;
		scc_enet_pram enet;
	}
	_PackedType ps;	/* protocol specific */

}
_PackedType scc_pram;

/* Common RFCR/TFCR Masks */
#define RFCR_GBL	0x20
#define RFCR_GBLs	(7-2)
#define RFCR_BO		0x18
#define RFCR_BOs	(7-4)
#define RFCR_TC2	0x18
#define RFCR_TC2s	(7-5)
#define RFCR_DTB	0x02
#define RFCR_DTBs	(7-6)
#define TFCR_GBL	0x20
#define TFCR_GBLs	(7-2)
#define TFCR_BO		0x18
#define TFCR_BOs	(7-4)
#define TFCR_TC2	0x18
#define TFCR_TC2s	(7-5)
#define TFCR_DTB	0x02
#define TFCR_DTBs	(7-6)


/*-----------------------------------------------------------------------------
*		Serial Management Controllers
*----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
*
*		SMC
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	byte _reserved0[0x100];	/* tbd */
}
_PackedType smc_pram;


/*-----------------------------------------------------------------------------
*		Multi-Channel Controllers
*----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
*
*		MCC
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg32 base;
	reg32 ptr;
}
_PackedType mcc_int;

typedef _Packed struct
{
	reg32 mccbase;
	reg16 mccstate;
	reg16 mrblr;
	reg16 grfthr;
	reg16 grfcnt;
	reg32 rinttmp;
	reg32 _data[0x02];
	mcc_int tint;
	reg32 tinttmp;
	reg16 sctpbase;
	byte _reserved0[0x02];
	reg32 c_mask32;
	reg16 xtrabase;
	reg16 c_mask16;
	reg32 _rinttmp[0x04];
	mcc_int rint[0x04];
	reg32 _ts_tmp;
	byte _reserved1[0x9C];
}
_PackedType mcc_pram;

typedef _Packed struct
{
	reg16 tbase;
	reg16 tbptr;
	reg16 rbase;
	reg16 rbptr;
}
_PackedType mcc_chxparam;

typedef reg16 mcc_superchannel_entry;
typedef mcc_superchannel_entry	mcc_superchannel_table[256];

typedef _Packed struct
{
	reg32 tstate;
	reg32 zistate;
	reg32 zidata0;
	reg32 zidata1;
	reg16 _tbdflags;
	reg16 _tbdcnt;
	reg32 _tbdptr;
	reg16 intmask;
	reg16 chamr;
	reg32 _tcrc;		/* in HDLC mode, reserved in Tranparent mode */
	reg32 rstate;
	reg32 zdstate;
	reg32 zddata0;
	reg32 zddata1;
	reg16 _rbdflags;
	reg16 _rbdcnt;
	reg32 _rbdptr;
	reg16 mflr;			/* in HDLC mode, tmrblr in Tranparent mode */
	reg16 _max_cnt;		/* in HDLC mode, rcvsync in Tranparent mode */
	reg32 _rcrc;		/* in HDLC mode, reserved in Tranparent mode */
}
_PackedType mcc_chan_param;

#define rcvsync	_max_cnt
#define tmrblr	mflr

/* MCC Rx BD Masks */
#define RXBD_MCC_CM		0x0200
#define RXBD_MCC_UB		0x0020

#define RXBD_MHDLC_LG		0x0020
#define RXBD_MHDLC_NO		0x0010
#define RXBD_MHDLC_AB		0x0008
#define RXBD_MHDLC_CR		0x0004

#define RXBD_MSS7_SF		0x0002

/* MCC Interrupt Circular Table Entry Fields */
#define MCC_INTQ_V		0x80000000
#define MCC_INTQ_W		0x40000000
#define MCC_INTQ_UN		0x02000000
#define MCC_INTQ_TXB	0x01000000
#define MCC_INTQ_NID	0x00200000
#define MCC_INTQ_IDL	0x00100000
#define MCC_INTQ_MRF	0x00080000
#define MCC_INTQ_RXF	0x00040000
#define MCC_INTQ_BSY	0x00020000
#define MCC_INTQ_RXB	0x00010000
#define MCC_INTQ_CN		0x00003FC0
#define MCC_INTQ_CNs	(31-25)


/*-----------------------------------------------------------------------------
*		Fast Communications Controllers
*----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
*
*		FCC ATM
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg32 pt_base;
	reg32 ct_base;
	reg32 pt1_base;
	reg32 ct1_base;
	reg16 p_mask;
}
_PackedType v_lu;

typedef _Packed struct
{
	reg32 base;
	byte _reserved0[0x04];
	reg32 base1;
	byte _reserved1[0x06];
}
_PackedType ext_cam_lu;

typedef _Packed struct
{
	byte _reserved0[0x04];
	reg16 rcell_tmp_base;
	reg16 tcell_tmp_base;
	reg16 udc_tmp_base;
	reg16 int_rct_base;
	reg16 int_tct_base;
	reg16 int_tcte_base;
	byte _reserved1[0x04];
	reg32 ext_rct_base;
	reg32 ext_tct_base;
	reg32 ext_tcte_base;
	reg16 uead_offset;
	byte _reserved2[0x02];
	reg16 pmt_base;
	reg16 apcp_base;
	reg16 fbt_base;
	reg16 intt_base;
	reg16 msp_base;
	reg16 uni_statt_base;
	reg32 bd_base_ext;
	_Packed union
	{
		v_lu v;
		ext_cam_lu ext_cam;
	}
	_PackedType al;
	reg16 vcif;
	reg16 gmode;
	reg16 comm_info[0x03];
	byte _reserved4[0x04];
	reg32 crc32_pres;
	reg32 crc32_mask;
	reg16 aal1_snpt_base;
	byte _reserved5[0x02];
	reg32 srts_base;
	reg16 idle_unassigned_base;
	reg16 idle_unassigned_size;
	reg32 epayload;
	reg32 trm;
	reg16 nrm;
	reg16 mrm;
	reg16 tcr;
	reg16 abr_rx_tcte;
	byte _reserved6[0x4A];
	reg16 policer_base;
}
_PackedType fcc_atm_pram;


/*-----------------------------------------------------------
* ATM Generic structure used by all AALx protocol modes.
*-----------------------------------------------------------*/
/*-------------------------------------------*/
/* Receive Connection Table (RCT) structure  */
/*-------------------------------------------*/

typedef _Packed struct
{
	unsigned reserved1:2;
	unsigned gbl:1;				/* Global - enable snooping */
	unsigned bo:2;				/* Byte ordering            */
	unsigned reserved2:1;
	unsigned dtb:1;				/* Data Buffer bus selection */
	unsigned bib:1;				/* BD/Int queue bus selection */
	unsigned reserved3:1;
	unsigned bufm:1;
	unsigned segf:1;			/* F5 segment filtering      */
	unsigned endf:1;			/* F5 end-to-end segment filtering */
	unsigned cpuu:1;			/* CPUU copying - enable     */
	unsigned reserved4:1;
	unsigned intq:2;			/* Int. queue selection.     */
	unsigned reserved5:1;
	unsigned inf:1;				/* In-frame indication.      */
	unsigned reserved6:10;
	unsigned abrf:1;			/* ABR Flow control.         */
	unsigned aal:3;				/* AAL selection.            */
}
_PackedType rct_stat;

typedef _Packed struct
{
	union						/* RCT Status Fields */
	{
		reg32 word;				/* RCT status/control word */
		rct_stat field;			/* RCT status/control word data structure */
	}
	rctstatus;

	reg32 rxbdptr;				/* Rx data buffer pointer */
	reg32 celltimestamp;		/* Cell time stamp */
	reg16 rbd_offset;			/* Rx BD offset from Rx BD base address */
	reg08 protocolspecific[12];
	reg16 mrblr;				/* Maximum receive buffer length */
	reg32 rbd_base;				/* Rx BD base address */

}
_PackedType rct;

/*-------------------------------------------*/
/* Transmit Connection Table (TCT) structure */
/*-------------------------------------------*/

typedef _Packed struct
{
	unsigned reserved1:2;
	unsigned gbl:1;				/* Global - enable snooping */
	unsigned bo:2;				/* Byte ordering.           */
	unsigned reserved2:1;
	unsigned dtb:1;				/* Data buffer bus - local/ppc   */
	unsigned bib:1;				/* BD/int. queue bus - local/ppc */
	unsigned avcf:1;			/* Auto VC                       */
	unsigned reserved3:1;
	unsigned att:2;				/* ATM traffic type - e.g. CBR   */
	unsigned cpuu:1;			/* CPUU insertion.               */
	unsigned vcon:1;			/* Virtual Channel On            */
	unsigned intq:2;			/* Interrupt queue selection.    */
	unsigned reserved4:1;
	unsigned inf:1;				/* In-frame, xmit state.         */
	unsigned reserved5:10;
	unsigned abrf:1;			/* ABR Flow control.             */
	unsigned aal:3;				/* AAL selection.                */
}
_PackedType tct_stat;

typedef _Packed struct
{
	union						/* TCT Status Fields */
	{
		reg32 word;				/* TCT status/control word. */
		tct_stat field;			/* TCT status/control data structure */
	}
	tctstatus;

	reg32 txbdptr;				/* Tx data buffer pointer */
	reg16 tbdcnt;				/* Tx BD count */
	reg16 tbd_offset;			/* Tx BD offset from TBD_BASE */
	reg08 rateremainder;		/* Rate reminder */
	reg08 pcrfraction;			/* Peak cell rate fraction */
	reg16 pcr;					/* Peak cell rate */
	reg08 protocolspecific[6];	/* Protocol Specific */
	reg16 apclc;				/* APC linked channel */
	reg32 cellheader;			/* ATM cell header */
	reg32 tbd_base;				/* Holds the PMT number Tx BD base address
								   and interrupt masks */
}
_PackedType tct;

/*--------------------------------------------*/
/* Transmit Connection Table (TCTE) structure */
/*--------------------------------------------*/

typedef _Packed struct
{
	reg16 scr;					/* Sustain cell rate */
	reg16 bt;					/* Burst Tolerance */
	reg16 oobr;					/* Out of buffer rate */
	reg08 srr;					/* Sustain rate remainder */
	reg08 scrf;					/* Sustain cell rate fraction */
	reg32 sr;					/* Sustain rate used by APC */
	reg16 vbr2;					/* VBR2 in msb */
	byte _reserved[0x12];
}
_PackedType tcte_vbr;

/*--------------------------------------------*/
/* TCTE for UBR+ sect 29.10.2.3.5 structure   */
/*--------------------------------------------*/

typedef _Packed struct
{
	reg16 mcr;					/* Mininum cell rate */
	byte _reserved0;
	reg08 mcrf;					/* Mininum cell rate fraction */
	reg16 mda;					/* Mininum Delay allowed */
	byte _reserved[0x1A];
}
_PackedType tcte_ubrplus;

#define SIZEOF_RCT	sizeof(rct)
#define SIZEOF_TCT	sizeof(rct)
#define SIZEOF_TCTE	sizeof(tcte_vbr)

/*----------------------*/
/* APC Parameter Table  */
/*----------------------*/

typedef _Packed struct
{
	reg16 apcl_first;			/* Address of first APC priority level */
	reg16 apcl_last;			/* Address of last APC priority level */
	reg16 apcl_ptr;				/* Address of current APC priority level */
	reg08 cps;					/* Number of cells sent per APC slot */
	reg08 cps_cnt;				/* Cells per APC slot counter */
	reg08 max_iteration;		/* Max iteration allowed */
	reg08 cps_abr;				/* Cells per APC slot for ABR protocol only */
	reg16 line_rate_abr;		/* The line rate of the port for ABR protocol only */
	reg32 real_tstp;			/* Real time stamp pointer */
	reg32 apc_state;
	byte _reserved1[0xA];
	reg16 scheduler_mode;
}
_PackedType apcparametertbl;


/*---------------------*/
/* APC Priority table  */
/*---------------------*/

typedef _Packed struct
{
	reg16 apc_lev_base;			/* APC level i base address */
	reg16 apc_lev_end;			/* APC level i end address */
	reg16 apc_lev_rptr;			/* APC level i real-time pointer */
	reg16 apc_lev_sptr;			/* APC level i service pointer */
}
_PackedType apcprioritytbl;


/*----------------------------------------*/
/* Interrupt Queue (INTQ) Parameter Table.*/
/*----------------------------------------*/

typedef _Packed struct
{
	reg32 intq_base;			/* Base address of interrupt queue */
	reg32 intq_ptr;				/* Pointer to interrupt queue entry */
	reg16 intq_cnt;				/* Interrupt counter */
	reg16 intq_icnt;			/* Interrupt counter initial value */
	reg32 intq_entry;			/* Pointer to interrupt queue entry */
}
_PackedType intqparametertbl;

/*----------------------------------------*/
/* Interrupt Queue Entry.                 */
/*----------------------------------------*/

typedef _Packed struct
{
	reg16 status;
	reg16 channelcode;
}
_PackedType intqentry;

/*-----------------------*/
/* Interrupt entry mask */
/*-----------------------*/
#define ATM_INTQ_V    0x80000000	/* Interrupt Queue entry valid bit */
#define ATM_INTQ_W    0x20000000	/* ATM Interrupt Queue entry wrap bit  */
#define ATM_INTQ_TBNR 0x00100000
#define ATM_INTQ_RXF  0x00080000
#define ATM_INTQ_BSY  0x00040000
#define ATM_INTQ_TXB  0x00020000
#define ATM_INTQ_RXB  0x00010000


/*-----------------------------------------------------------------------------
*
*		FCC Ethernet
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg32 stat_buf;
	reg32 cam_ptr;
	reg32 c_mask;
	reg32 c_pres;
	reg32 crcec;
	reg32 alec;
	reg32 disfc;
	reg16 ret_lim;
	reg16 ret_cnt;
	reg16 p_per;
	reg16 boff_cnt;
	reg32 gaddr_h;
	reg32 gaddr_l;
	reg16 tfcstat;
	reg16 tfclen;
	reg32 tfcptr;
	reg16 mflr;
	reg16 paddr1_h;
	reg16 paddr1_m;
	reg16 paddr1_l;
	reg16 ibd_cnt;
	reg16 ibd_start;
	reg16 ibd_end;
	reg16 tx_len;
	reg08 _ibd_base[0x20];
	reg32 iaddr_h;
	reg32 iaddr_l;
	reg16 minflr;
	reg16 taddr_h;
	reg16 taddr_m;
	reg16 taddr_l;
	reg16 pad_ptr;
	byte _reserved0[0x02];
	reg16 _cf_range;
	reg16 _max_b;
	reg16 maxd1;
	reg16 maxd2;
	reg16 maxd;
	reg16 dma_cnt;
	reg32 octc;
	reg32 colc;
	reg32 broc;
	reg32 mulc;
	reg32 uspc;
	reg32 frgc;
	reg32 ospc;
	reg32 jbrc;
	reg32 p64c;
	reg32 p65c;
	reg32 p128c;
	reg32 p256c;
	reg32 p512c;
	reg32 p1024c;
	reg32 cam_buf;
	byte _reserved1[0x04];
}
_PackedType fcc_enet_pram;

#define C_PRES_FCC_ENET		0xFFFFFFFF	/* CRC Preset Ethernet*/
#define C_MASK_FCC_ENET		0xDEBB20E3	/* Constant MASK for CRC */


/*-----------------------------------------------------------------------------
*
*		FCC HDLC
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	byte _reserved0[0x08];
	reg32 c_mask;
	reg32 c_pres;
	reg16 disfc;
	reg16 crcec;
	reg16 abtsc;
	reg16 nmarc;
	reg32 max_cnt;
	reg16 mflr;
	reg16 rfthr;
	reg16 rfcnt;
	reg16 hmask;
	reg16 haddr[0x04];
	reg16 _ts_tmp;
	reg16 _tmp_mb;
	byte _reserved1[0x94];
}
_PackedType fcc_hdlc_pram;


/*-----------------------------------------------------------------------------
*
*		FCC Transparent
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	byte _reserved0[0xC4];	/* tbd */
}
_PackedType fcc_trans_pram;


/*-----------------------------------------------------------------------------
*
*		FCC
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg16 riptr;
	reg16 tiptr;
	byte _reserved0[0x02];
	reg16 mrblr;
	reg32 rstate;
	reg32 rbase;
	reg16 _rbdstat;
	reg16 _rbdlen;
	reg32 _rdptr;
	reg32 tstate;
	reg32 tbase;
	reg16 _tbdstat;
	reg16 _tbdlen;
	reg32 _tdptr;
	reg32 rbptr;
	reg32 tbptr;
	reg32 _rcrc;
	byte _reserved1[0x04];
	reg32 _tcrc;
	_Packed union				/* Protocol-Specific parameter ram */
	{
		fcc_atm_pram atm;
		fcc_enet_pram enet;
		fcc_hdlc_pram hdlc;
		fcc_trans_pram trans;
	}
	_PackedType ps;
}
_PackedType fcc_pram;


/*-----------------------------------------------------------------------------
*		Serial Peripheral Interface
*----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
*
*		SPI
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg16 rbase;
	reg16 tbase;
	reg08 rfcr;	
	reg08 tfcr;	
	reg16 mrblr;
	reg32 _rstate;
	reg32 _rptr;
	reg16 rbptr;
	reg16 _rcount;
	reg32 _rtemp;
	reg32 tstate;
	reg32 _tptr;
	reg16 tbptr;
	reg16 _tcount;
	reg32 _ttemp;
	reg32 _sdmatemp;
	byte _reserved0[0x08];	/* to occupy a 64 byte block */
}
_PackedType spi_pram;


/*-----------------------------------------------------------------------------
*		Inter-Integrated Circuit Controller
*----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
*
*		I2C 
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	reg16 rbase;
	reg16 tbase;
	reg08 rfcr;	
	reg08 tfcr;	
	reg16 mrblr;
	reg32 _rstate;
	reg32 _rptr;	
	reg16 rbptr;
	reg16 _rcount;
	reg32 _rtemp;
	reg32 _tstate;
	reg32 _tptr;
	reg16 tbptr;
	reg16 _tcount;
	reg32 _ttemp;
	byte _reserved0[0x0C];
	reg32 _sdmatmp;
}
_PackedType i2c_pram;

#define TXBD_I2C_NAK	0x0004		/* No acknowledge */
#define TXBD_I2C_UN		0x0002		/* underrun */
#define TXBD_I2C_CL		0x0001		/* collision */
#define RXBD_I2C_OV		0x0002		/* overrun */

