/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/headers/mpq_bd.h 0.0.1.2 2004/12/13 16:39:53 mreiss Exp $
*
* Copyright Freescale Semiconductor, Inc. 2004.  All rights reserved.
*
* Description:	The PowerQUICC Buffer Descriptor (BD) structure and related
*				definitions.  Generic BD structure used by all protocols.
*
*----------------------------------------------------------------------------*/


typedef _Packed struct
{
	reg16 ctrlstat;			/* control and status */
	reg16 dlength;			/* Data length */
	volatile byte *dptr;	/* Data buffer pointer */
}
_PackedType bd, *pbd;

/* Common Rx BD Masks */
#define RXBD_E		0x8000		/* Empty */
#define RXBD_W		0x2000		/* Wrap */
#define RXBD_I		0x1000		/* Interrupt */
#define RXBD_L		0x0800		/* last buffer of a frame */
#define RXBD_F		0x0400		/* first buffer of a frame */

/* Common Tx BD Masks */
#define TXBD_R		0x8000		/* Ready */
#define TXBD_W		0x2000		/* Wrap */
#define TXBD_I		0x1000		/* Interrupt */
#define TXBD_L		0x0800		/* Last buffer */

/* Masks Common to all Ethernet controller's BD */
/* Ethernet Rx BD Masks */
#define RXBD_FENET_F	0x0400		/* first in frame */
#define RXBD_FENET_CMR	0x0200		/* CAM match result */
#define RXBD_FENET_M	0x0100		/* miss, in promiscuos mode */
#define RXBD_FENET_BC	0x0080		/* broadcast frame */
#define RXBD_FENET_MC	0x0040		/* multicast frame */
#define RXBD_FENET_LG	0x0020		/* Rx frame length > MFLR */
#define RXBD_FENET_NO	0x0010		/* nonoctet aligned frame */
#define RXBD_FENET_SH	0x0008		/* short frame (short frame is not used if RSH of psmr = 0) */
#define RXBD_FENET_CR	0x0004		/* CRC error */
#define RXBD_FENET_OV	0x0002		/* overrun */
#define RXBD_FENET_CL	0x0001		/* collision */

/* Ethernet Tx BD Masks */
#define TXBD_FENET_PAD	0x4000		/* Pad short frame */
#define TXBD_FENET_TC	0x0400		/* Tx CRC */
#define TXBD_FENET_DEF	0x0200		/* Defer indication */
#define TXBD_FENET_HB	0x0100		/* Heartbeat */
#define TXBD_FENET_LC	0x0080		/* late collision */
#define TXBD_FENET_RL	0x0040		/* retransmission limit */
#define TXBD_FENET_RC	0x003C		/* retry count */
#define TXBD_FENET_UN	0x0002		/* underrun */
#define TXBD_FENET_CSL	0x0001		/* carrier sense lost */

