/*-----------------------------------------------------------------------               
*
* File:  mcc.h
*
* Description:  
*
*       Constants and Definitions for MPC8560 MCC Example.
*
*
* History:
*
* 15 NOV 98    ggh     	Initial version
* 29 JUL 99    ggh     	Updated for new web release
* NOV 1999     jms     	Modified code for PILOT Rev boards.  The code now 
*						reads BCSR2 for the board revision and then 
*						chooses the correct bit positionings for BCSR0 
*						and BCSR1.
* JUL 2002     ddc	Modified code to use 24 channels (channels 64-87) 
* AUG 2007     mj	Modified for 8560ADS and to run 128 channels in HDLC supperchannel mode
*
*-----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/*            APPLICATION-SPECIFIC CONSTANTS AND DEFINITIONS            */
/*----------------------------------------------------------------------*/
#define CCSRBAR_ADDR 	0x40000000
#define CPM_DP1_ADDR 	0x40080000
#define CPM_DP2_ADDR 	0x40088000
#define CPM_MCC1_ADDR 	0x40088700
                                 
#define NUMBER_OF_CHANNELS 8   /* how many logical channels (MCNs) for this example */
                                                                
#define MCCXTRABASE 0x9000	/* offset from channel specific PRAM base that marks the
					beginning of the extra channel-specific
					parameters for the MCC */

#define BUFFER_SIZE 256		/* size of buffers for this example */

#define MCC_MRBLR BUFFER_SIZE+32	/* arbitrarily set the max receive 
					buffer length to be 32 bytes more
					than that of the expected buffer 
					length */

#define CRC16 0xf0b8		/* mask for 16 bit crc */
#define CRC32 0xdebb20e3	/* mask for 32 bit crc */
#define SUPERCHAN_TABLE 0x1900	/* address offset for superchannel table */

#define CH0BDOFFSET 0   
#define CH16BDOFFSET 8   
#define CH32BDOFFSET 16
#define CH48BDOFFSET 24
#define CH64BDOFFSET 32  
#define CH80BDOFFSET 40 
#define CH96BDOFFSET 48
#define CH112BDOFFSET 56

#define CONTINUOUS 0    /* used to set if this test runs continuously or not */
#define RUN_ONCE 1

#define SI1     0           /* Index into SI Register Array */
#define SI2     1           /* Index into SI Register Array */  

#define MCC1    0           /* MCC1 Index into MCC PRAM Array */
#define MCC2    1           /* MCC2 Index into MCC PRAM Array */

#define TDMA    0           /* Index into TDM Mode Register Array */
#define TDMB    1           /* Index into TDM Mode Register Array */
#define TDMC    2           /* Index into TDM Mode Register Array */
#define TDMD    3           /* Index into TDM Mode Register Array */

/* Time Slot Assigner configuration */
#define	SIxRAM_MCC	        0x8000
#define	SIxRAM_SUPER	    	0x2000
#define SIxRAM_CNT_1		(0 << 2)
#define SIxRAM_CNT_2		(1 << 2)
#define SIxRAM_CNT_3		(2 << 2)
#define SIxRAM_CNT_4		(3 << 2)
#define SIxRAM_CNT_5		(4 << 2)
#define SIxRAM_CNT_6		(5 << 2)
#define SIxRAM_CNT_7		(6 << 2)
#define SIxRAM_CNT_8		(7 << 2)
#define SIxRAM_BYT_FIRST    	0x0002
#define	SIxRAM_BYT	        0x0000
#define	SIxRAM_LST	        0x0001

/*-------------------------------*/
/* Data structure bus selection. */ 
/*-------------------------------*/

#define PPC 0
#define LOCAL 1

#define BD_BUS     PPC     /* IMPORTANT: Select what bus you will be placing */
#define BUFFER_BUS PPC   /* your BDs and data on for this example */


#if BD_BUS == PPC
#define BDRING_BASE 0x00110000
#define TX_INTCQ 0x120000	/* base of MCC's Tx interrupt circular queue */
#define RX_INTCQ 0x120600	/* base of MCC's Rx interrupt circular queue */
#else
#define BDRING_BASE 0xC0010000
#define TX_INTCQ 0xC0020000	/* base of MCC's Tx interrupt circular queue */
#define RX_INTCQ 0xC0020600	/* base of MCC's Rx interrupt circular queue */
#endif
							   
#if BUFFER_BUS == PPC
#define BUFFERPOOLBASE 0x400000    /*  base of data area for this example */
#else
#define BUFFERPOOLBASE 0xC0400000  /* base of data area for this example */
#endif			 
									  

/*----------------------------------------------*/
/* Board Control and Status Register (for ADS) */
/*----------------------------------------------*/
typedef struct bcsr 
{
	UWORD  bcsr0; /* Board Control and Status Register */
	UWORD  bcsr1;
	UWORD  bcsr2;
	UWORD  bcsr3;
} t_BCSR;


/*---------------------------------------------------------------*/
/* Number of Receive and Transmit Buffer Descriptors per channel */
/*---------------------------------------------------------------*/
#define NUM_RXBDS 8
#define NUM_TXBDS 8


/*-------------------*/
/* Buffer components */
/*-------------------*/
typedef struct BufferDescriptor 
{
   VUHWORD bd_cstatus;     /* control and status */
   VUHWORD bd_length;      /* transfer length */
   VUBYTE  *bd_addr;       /* buffer address */
} BD;


typedef struct BufferDescRings 
{
    BD RxBD[NUMBER_OF_CHANNELS*NUM_RXBDS];    /* Rx BD ring */
    BD TxBD[NUMBER_OF_CHANNELS*NUM_TXBDS];    /* Tx BD ring */
} BDRINGS;

#define BD_RX_ERROR 0x002C    /* Mask for set of Receive Buffer Errors */
                               

/*------------------*/
/* Additional Masks */
/*------------------*/

/* CPM_CPCR MASKS */
#define CPCR_FLG                0x00010000
#define CPCR_MCC1_PSBC          0x1f800000
#define CPCR_MCC2_PSBC          0x23A00000
#define CPCR_STOP_TX            0x00000004
#define CPCR_GRSTOP_TX          0x00000005
#define CPCR_MCC_STOP_RX        0x00000009
#define CPCR_INIT_TX_RX_PARAMS  0x00000000
#define CPCR_MCN_MCH0           0x00000000
#define READY_TO_RX_CMD         0  /* Ready to receive a command */

/* INTERRUPT CONTROL */
#define SIMR_L_MCC1     0x08000000
#define SIMR_L_MCC2     0x04000000

/* GENERAL PURPOSE */
#define  ALL_ONES    0xFFFFFFFF
#define  ALL_ZEROS   0x00000000

//--------
// EOF
//--------
