/*-----------------------------------------------------------------------------
*
* $Header: n:/pcmrcs/NCdrivers/headers/MPC8560.h 0.1.1.5 2004/08/13 16:10:21 jdabbraccio Exp $
*
* Copyright Freescale Semiconductor, Inc. 2003-2004.  All rights reserved.
*
* Description:	Entire Internal Memory Map Structure for the MPC8560.
*
*----------------------------------------------------------------------------*/

#pragma pack(1)
#define _PackedType
#define _Packed

#ifndef MPC8560
#define MPC8560	1
#endif

#include "mpq_types.h"
#include "mpq_lar.h"
#include "mpq_ecm.h"
#include "mpq_ddr.h"
#include "mpq_i2c.h"
#include "mpq_lbc.h"
#include "mpq_pcix.h"
#include "mpq_l2sram.h"
#include "mpq_dma.h"
#include "mpq_bd.h"
#include "mpq_tsec.h"
#include "mpq_pic.h"
#include "mpq_cpm.h"
#include "mpq_rio.h"
#include "mpq_gur.h"
#include "mpq_debug.h"


/*-----------------------------------------------------------------------------
*
*		CPM Memory Map Structure
*
*----------------------------------------------------------------------------*/

typedef _Packed struct
{
	cpm_dpram1 dpram1;
	cpm_dpram2 dpram2;
	cpm_e500core e500core;
	cpm_siu siu;
	cpm_ic ic;
	cpm_iop iop[4];
	cpm_timers timers;
	cpm_sdma sdma;
	byte _reserved2[0x2E0];
	cpm_fcc fcc[3];
	byte _reserved3[0x20];
	cpm_fccir fccir[3];
	byte _reserved4[0x20];
	cpm_tc tc[8];
	cpm_tcgen tcgen;
	reg32 brgc5[4];
	byte _reserved5[0x260];
	cpm_i2c i2c;
	cpm_cp cp;
	reg32 brgc1[4];
	cpm_scc scc[4];
	byte _reserved6[0x20];
	cpm_spi spi;
	cpm_mux mux;
	cpm_simcc simcc[2];
	byte _reserved7[0x4A0];
	cpm_siram siram[2];
	byte _reserved8[0xD000];
	cpm_dpramuc dpramuc;
}
_PackedType mpq_cpm, *pmpq_cpm;

/* index into parallel IO register array, i.e. iop[4] */
#define PORTA	0
#define PORTB	1
#define PORTC	2
#define PORTD	3


typedef _Packed struct
{
	mpq_lar lar;
	mpq_ecm ecm;
	mpq_ddr ddr;
	mpq_i2c i2c;
	byte _reserved0[0xB00];
	mpq_lbc lbc;
	mpq_pcix pcix;
	mpq_l2sram l2sram;
	mpq_dma dma;
	mpq_tsec tsec[2];
	byte _reserved1[0x1A000];
	mpq_pic pic;
	mpq_cpm cpm;
	mpq_rio rio;
	mpq_gur gur;
	mpq_debug debug;
}
_PackedType mpc_imm, *pmpc_imm, mpc8560_ccsr, *pmpc8560_ccsr;

#define ACTUAL_SIZEOF_MPC8560_CCSR	0xE20B4
#define ACTUAL_SIZEOF_MPC_IMM		ACTUAL_SIZEOF_MPC8560_CCSR

#include "mpq_untypes.h"

