
/***************************************************************************
 *     Copyright Motorola, Inc. 1989-2003 ALL RIGHTS RESERVED
 *
 *  $Id: main.c.rca 1.1 Mon Dec  1 14:11:07 2003 r9aahw Experimental $
 *
 * You are hereby granted a copyright license to use, modify, and
 * distribute the SOFTWARE, also know as DINK32 (Dynamic Interactive Nano 
 * Kernel for 32-bit processors) solely in conjunction with the development 
 * and marketing of your products which use and incorporate microprocessors 
 * which implement the PowerPC(TM) architecture manufactured by 
 * Motorola and provided you comply with all of the following restrictions 
 * i) this entire notice is retained without alteration in any
 * modified and/or redistributed versions, and 
 * ii) that such modified versions are clearly identified as such. 
 * No licenses are granted by implication, estoppel or
 * otherwise under any patents or trademarks of Motorola, Inc.
 * 
 * The SOFTWARE is provided on an "AS IS" basis and without warranty. To
 * the maximum extent permitted by applicable law, MOTOROLA DISCLAIMS ALL
 * WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING IMPLIED WARRANTIES OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE AND ANY WARRANTY 
 * AGAINST INFRINGEMENT WITH REGARD TO THE SOFTWARE 
 * (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY ACCOMPANYING 
 * WRITTEN MATERIALS.
 * 
 * To the maximum extent permitted by applicable law, IN NO EVENT SHALL
 * MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING WITHOUT 
 * LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 * INTERRUPTION, LOSS OF BUSINESS INFORMATION,
 * OR OTHER PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE
 * SOFTWARE.
 * Motorola assumes no responsibility for the maintenance and support of
 * the SOFTWARE.
 ************************************************************************/

#include "dink.h"
#include <string.h>
#include "errors.h"
#include "reg_tb.h"
#include "duart.h"
#include "par_tb.h"
#include "pciLib.h"
#include "asm_dsm.h"
#include "i2o.h"
#include "atu.h"
#include "epic.h"
#include "config.h"


#ifdef ISS
#include "appPortal.h"
#endif /* ISS */


#define PCI_REG_BASE  0x80000000
#define PCI_MEM_ADR   0x80000000
#define PCI_LMBAR_REG 0x10



extern unsigned long target_mode, target_addr, target_type;

#ifdef ON_BOARD
extern void   config_kahlua_agent( );
#pragma Alias( config_kahlua_agent, "config_kahlua_agent" )
extern unsigned int get_kahlua_pcsrbar( );
extern unsigned int get_eumbbar( );
extern unsigned int load_runtime_reg( unsigned int eumbbar, unsigned int reg );
extern int pciAgentProbe( unsigned long *dev_addr );
extern STATUS read_from_memory( ULONG address, ULONG *data );
extern STATUS write_to_memory( INTEGER address, INTEGER data );

extern void     winbond_initialize();
extern void     via_initialize();
extern void     via_superio_init();
extern void     via_postinit();
extern void     ns308defaults();
extern STATUS   PCIEnum();
extern STATUS   mem_check( int DoCorrect, int verbose );
extern unsigned long pvr_read();
extern int 	    GetBusPeriod();
extern int 	    NetSetup();
extern char    *GetEnv( char *name, char *tmp );
extern int      ENVLoad();
extern int      InitWithEnv();
extern STATUS   AutoBoot();

extern void   GetIdentity();
extern STATUS breakpoint_initialize();
extern int    gp_register_init();
extern int    fp_register_init();
extern int    sp_register_init();
extern int    vp_register_init();
extern void epicInit( unsigned int IRQType, unsigned int clkRatio);

#ifdef SREC_COMPRESS_SUPPORT
extern STATUS compression_initialize();
#endif
#ifdef STANDALONE_PMC
extern int GetStandaloneBusSpeed();
#endif
extern void   get_SP_version();
extern STATUS about();
extern STATUS about_cache();
extern STATUS dink_identify();
extern void   simple_leap();
extern void sysEUMBBARWrite ( unsigned long regNum, unsigned long regVal);
extern unsigned long sysEUMBBARRead( unsigned long regNum);
extern long strtoul( char *, char **, int );

#else //ON_BOARD

extern void vdink_uninit();

#endif //ON_BOARD

extern int shell_init( int do_auto );
extern int dink_loop( int exitable );
extern int pcibridge_initialize();

extern long		board_type;
extern long		board_version;
extern long		dink_type;
extern ULONG	memSpeed;		// Mem Bus Speed
extern ULONG	memSize;
extern ULONG	memCL;
extern ULONG 	BusProtocol;
extern int		SpecBusSpeed;
extern unsigned int  ns;


// 
extern int			RTC_isvalid();
extern ULONG		read_pid();
extern	MACINFO		MAC_nos;			// Global Enet MAC # data




#ifdef MVPBOARD
extern void 	     GT_CPUSetup( ULONG f, ULONG m );
extern unsigned long MVP_I2C_init();
extern unsigned long MVP_get_GTOPT();
extern unsigned long MVP_enable_PCI();

#ifdef DUALVGER
extern void       init_cpu1();  // --AAB
extern int        MP_launch();  // --AAB
extern void       hang();  // --AAB
extern int        cpu_counter; 
extern int        pause_other_cpu_flag;
extern int IDProcessor( int brief );
extern void GpicExtIntEnable();
#endif /* DUALVGER */

char  MVP_uart_mode = MVP_X3;

#endif /* MVPBOARD */

#ifdef ISS
short sim_echo = 1;  // used to turn character input echo on or off
#endif /* ISS */

INTEGER	benchmark_in_progress = FALSE;	/* This global is used to determine 
					   whether we are in the process of 
					   running the benchmark command */
ULONG  	flush_cache_cmd = TRUE; /* A hack to suppress flushing the caches 
					   on go_trace and exception_return.  Want to experiment
					   with benchmarking "warm" caches.  CJC 011109 */
INTEGER	timebase_base_run_l = 0;	/* This global is used to hold
					   the value of the timebase register
					   on the 1st pass through the user
					   code.  The upper value will be
					   0 because we initialize the timebase
					   on each pass and it will not have had
					   time to increment that far!! */
INTEGER	benchmark_addr = 0x100;		/* This global is used to store the address
					   of the beginning of the benchmark.  It
					   will be used to replace the real opcode
					   when we begin the second pass. */
INTEGER benchmark_pass = 0;			/* Global that determines which part of
						   bench_mark() routine should be run
						   0 - Benchmark command just issued
						   1 - Returning from 1st pass
2 - Returning from 2nd pass */
INTEGER benchmark_loop = 0;			/* Global that determines which pass of
						   bench_mark() routine should be run
						   0 - Init value
						   1 - No caches 
						   2 - Icache
						   3 - Dcache
						   4 - Icache,Dcache*/
/* These are the globals that we store the current values in during exception
   handling */
INTEGER current_msr = 0; 
INTEGER current_hid0 = 0;
INTEGER current_srr0 = 0;
INTEGER current_lr = 0;
INTEGER current_cr = 0;
INTEGER current_r3 = 0;
INTEGER current_r4 = 0;
INTEGER current_r5 = 0;
INTEGER Push_reset_button=0;


// These globals are used for continuous tracing CJC

ULONG trace_count = 0;
ULONG instruction_count = 1;


unsigned long IO_Index;
unsigned long IO_Data;
unsigned long IO_Base;

short           GlobalPVR;					// CPU #0 PVR (ID portion)
// Note: NOT unsigned due to
// GCC bugs.

int   	Lines      		= 0;				// Display lines
char	regdisp_opt		= DO_VERBOSE;		// RD/RM global options
char	Verbose			= 0;				// Global verbose level.
ULONG	DinkOpts		= 0;				// Global misc. options.
char	process_type;	// Processor type
char	address_map[2];
int     agent_device_number = 0;			// PCI Agent Device number
int     skip_init 		= 0;				// If set, skip optional
// initialization code.

char	CPUName[12];						// Processor Name
char	CPUNick[12];						// Processor Nickname

char    misc_tmp[40];

/* For a host, pmcIntLine is a 
   global to hold the IRQ line (0-3) of an agent
   depending on what PMC slot the agent is in. This
   value is use by the host EPIC unit to set up the 
   correct interrupt vector. 
	pmcIntLine = 0xff	- no agent detected
	pmcIntLine = 0		- agent at IRQ0 
	pmcIntLine = 1		- agent at IRQ1 
	pmcIntLine = 2		- agent at IRQ2 
	pmcIntLine = 3		- agent at IRQ3

   For an agent, pmcIntLine is a flag that will be
   set to AGENT_DETECTED = 23 to let EPIC unit know
   to set up the Message Unit interrupt vector 23 */ 

int   pmcIntLine = 0xff; 
#define AGENT_DETECTED 23


int (*start)( int exitable );


//-------------------------------------------------------------------------
//	MCAPS is a small 'database' of the capabilities of each board type.
//	Due to the (increasing) number of boards, it is no longer as
//	simple as detecting an MPC107 and assuming capabilities are a given.
//-------------------------------------------------------------------------
MCAPS caps[] = {
//                            M  W  P  H  I               R
//                             A  N  C  S  2               T
//BOARD    NAME                 P  B  I  T  C  DRIVERS      C  NVRAM_TYPE
{ YK_X2,   "Yellowknife/X2",	1, 1, 1, 1, 0, M_SUPERIO,   1, M_ENVNVRAM },
{ YK_X4,   "Yellowknife/X4",	1, 1, 1, 1, 0, M_SUPERIO,   1, M_ENVNVRAM },
{ EXCIMER, "Excimer",			0, 0, 0, 1, 0, M_DUART,     0, M_ENVSRAM  },
{ PMCSA,   "MPMC8245 Module",   1, 0, 0, 0, 1, M_PMCUART,   0, M_ENVSRAM  },
{ SP_8240, "Sandpoint/MPC824X",	1, 1, 1, 1, 1, M_SUPERIO,   1, M_ENVNVRAM },
{ SP_107,  "Sandpoint/MPC107",	1, 1, 1, 1, 1, M_SUPERIO,   1, M_ENVNVRAM },
{ VIRTUAL, "Virtual emulation",	0, 0, 0, 1, 0, M_VIRTUAL_IO,1, M_ENVNVRAM },
{ MVP,     "MVP/Dual V'Ger",	0, 0, 1, 0, 1, M_DISCO,     1, M_ENVRTC   },

//  for ISS simulator uses simulated I/O so duart type is M_UNKNOWN

{ SIM,     "ISS",         		0, 0, 0, 0, 0, M_UNKNOWN,   0, M_ENVNONE  },
{ MARS,    "MARS/e500",         0, 0, 0, 0, 0, M_PMCUART,   0, M_ENVNONE  },
{ ARC_CTL, "mars:Arcadia",      0, 0, 1, 1, 1, M_VIA,       1, M_ENVRTC   },
{ MARS_ELY,"mars:Elysium",      0, 0, 1, 1, 1, M_DRACOM_IO, 1,  M_ENVNONE },
{ ADS_PQ3 ,"MPC8560ADS",        0, 0, 1, 1, 1, M_DRACOM_IO, 1,  M_ENVNONE }	
};

MCAPS *mach_info = &caps[0];		// The baseline default is YK X2



//---------------------------------------------------------------------------
//	cdb -- various collected data on this CPU.
//---------------------------------------------------------------------------

CPUINFO cdb[] = {

  // PVR    REV     NAME      NICKNAME     GEN    CLASS
  // L1I  L1D  L2    L2X  L3    L3X   XBSEN
  // #BATS  #TLBS FP AV AVe PCI RIO ENET

  // dummy
  { 0x0000, 0x0000, "???",    "TBD",       "1",	PPC603,
    0,   0,    0,    0,    0,    0, 0,
    0,      0,   0, 0, 0,  0,  0,  0 },

  // MPC601
  { 0x0001, 0x0000, "601",    "TBD",       "1",	PPC601,
    32,  32,    0,    0,    0,    0, 0,
    4,     32,   1, 0, 0,  0,  0,  0 },
  
  // MPC603
  { 0x0003, 0x0000, "603",    "Wart",      "1",	PPC603,
    8,   8,    0,    0,    0,    0, 0,
    4,     32,   1, 0, 0,  0,  0,  0 },
  
  // MPC603e
  { 0x0006, 0x0000, "603e",   "Stretch",   "1",	PPC603,
    16,  16,    0,    0,    0,    0, 0,
    4,     32,   1, 0, 0,  0,  0,  0 },

  // MPC603ev
  { 0x0007, 0x0000, "603ev",  "Valiant",   "1",	PPC603,
    16,  16,    0,    0,    0,    0, 0,
    4,     32,   1, 0, 0,  0,  0,  0 },

  // MPC603r
  { 0x0007, 0x1200, "603r",   "Goldeneye", "2",	PPC603,
    16,  16,    0,    0,    0,    0, 0,
    4,     32,   1, 0, 0,  0,  0,  0 },

  // MPC604
  { 0x0004, 0x0000, "604",    "Zephyr",    "1",   PPC604,
    16,  16,    0,    0,    0,    0, 0,
    4,     64,   1, 0, 0,  0,  0,  0 },

  // MPC604e
  { 0x0009, 0x0000, "604e",   "Sirocco",   "1",   PPC604,
    32,  32,    0,    0,    0,    0, 0,
    4,     64,   1, 0, 0,  0,  0,  0 },

  // MPC604e
  { 0x000A, 0x0000, "604e",   "MachV",     "2",   PPC604,
    32,  32,    0,    0,    0,    0, 0,
    4,     64,   1, 0, 0,  0,  0,  0 },

  // MPC750
  { 0x0008, 0x0000, "750",    "Arthur",    "3",   PPCART,
    32,  32,    0, 1024,    0,    0, 0,
    4,     64,   1, 0, 0,  0,  0,  0 },

  // MPC755
  { 0x0008, 0x3000, "755",    "Goldfinger","3",   PPC755,
    32,  32,    0, 1024,    0,    0, 0,
    8,     64,   1, 0, 0,  0,  0,  0 },

  // MPC7400
  { 0x000C, 0x0000, "7400",   "Max",       "4",   PPCMAX,
    32,  32,    0, 1024,    0,    0, 0,
    4,     64,   1, 1, 0,  0,  0,  0 },

  // MPC7410
  { 0x800C, 0x0000, "7410",   "Nitro",     "4",   PPCNITRO,
    32,  32,    0, 2048,    0,    0, 0,
    4,     64,   1, 1, 0,  0,  0,  0 },

  // MPC7450
  { 0x8000, 0x0000, "7450",   "V'ger",     "4+",  PPCVGER,
    32,  32,  256,    0, 0,  2048, 0,
    4,    128,   1, 1, 0,  0,  0,  0 },

  // MPC7455
  { 0x8001, 0x0000, "7455",   "Apollo",    "4+",  PPCAPOLLO,
    32,  32,  256,    0, 0,  2048, 1,
    8,    128,   1, 1, 0,  0,  0,  0 },

  // MPC7457
  { 0x8002, 0x0000, "7457",   "Apollo7",   "4+",  PPCAPOLLO7,
    32,  32,  512,    0, 0,  2048, 1,
    8,    128,   1, 1, 0,  0,  0,  0 },

  // MPC8240
  { 0x0081, 0x0000, "8240",   "Kahlua",     "2",	PPC603,
    16,  16,    0,    0,    0,    0, 0,
    4,     32,   1, 0, 0,  1,  0,  0 },

  // MPC8245
  { 0x8081, 0x0000, "8245",   "KahluaII",    "2",	PPC603,
    16,  16,    0,    0,    0,    0, 0,
    4,     32,   1, 0, 0,  1,  0,  0 },

  // MPC8560
  { 0x8020, 0x0000, "8560",   "Dracom",      "5",	PPCDRACO,
    32,  32,  256,    0,    0,    0, 0,
    0,     64,   0, 0, 1,  1,  1,  3 },

  // MPC8540
  { 0x8020, 0x0000, "8540",   "Draco",       "5",	PPCDRACO,
    32,  32,  256,    0,    0,    0, 0,
    0,     64,   0, 0, 1,  1,  1,  3 }
};

CPUINFO *cpu_info = &cdb[0];		// Default = DUMMY


//---------------------------------------------------------------------------
//	CPUINFO_match -- match PVR to the CPUINFO database.
//---------------------------------------------------------------------------
CPUINFO *CPUINFO_match( ULONG full_pvr )
{
	USHORT   pvr, rev;
	CPUINFO *best;
	int      i;

	pvr = (full_pvr >> 16) & 0xFFFF;
	rev =  full_pvr        & 0xFFFF;

// Keep matching even when something found; last is the best.

	best = NULL;
	for (i = 0; i < sizeof(cdb)/sizeof(CPUINFO); i++) {
		if ((cdb[i].pvr == pvr)  &&  (rev >= cdb[i].rev_min)) {
			best = &cdb[i];
		}
	}

// TBD: for Draco match, see if this is 'really' Dracom.  

// something here: if Dracom, point best to prior (best--)

	return( best );
}


//---------------------------------------------------------------------------
//	stubs -- used to #define away unused routines.
//---------------------------------------------------------------------------
int istub()
{
	return( 0 );
}
void vstub()
{
	return;
}


//--------------------------------------------------------------------------
//	delay -- cheap delay for various (inaccurate) purposes.
//--------------------------------------------------------------------------
void delay( int deciseconds )		// Not deciseconds at all!
{
	int	j,k;

	k = 0xfffff;

#ifndef ICACHEON
	deciseconds /= 10;				// Non ICACHE much slower.
#endif

	for (j = 0; j < deciseconds; j++) {
		while (k) {					// Note bug - k is never reloaded.  Rather
			k = k-1;				// than fix this, someone decided to
		}							// increase all the timing values.
	}
}


//---------------------------------------------------------------------------
//	init_IO_values -- set up IO values based on board type and selected
//					  IO drivers (could change dynamically).
//---------------------------------------------------------------------------
void init_IO_values()
{
	ULONG tmp_addr;


// For the YK and SP  systems, setup pointers to SuperI/O and
// initialize it. 

	if (mach_info->IODrivers == M_SUPERIO) { 		// YK, SP
		tmp_addr = config_addr;
		tmp_addr = tmp_addr >> 16;
		if (tmp_addr == CHRP_REG_ADDR) {
			IO_Index = (unsigned long) 0xFE00015C;
			IO_Data  = (unsigned long) 0xFE00015D;
			IO_Base  = (unsigned long) 0xFE000000;
			strcpy(address_map, "B");             	// CHRP is map B
		}
		else {
			IO_Index = (unsigned long) 0x8000015C;
			IO_Data  = (unsigned long) 0x8000015D;
			IO_Base  = (unsigned long) 0x80000000;
			strcpy(address_map, "A");             	// PREP is map A
		}

		ns308defaults();							// Initialize the SuperIO
	}

// DUART using the Excimer/Maximer address map.

	else if (mach_info->IODrivers == M_DUART) {
		IO_Base  = 0x40000000;					// Base of DUART
		IO_Index = 0;							// No PnP
		IO_Data  = 0;							// No PnP
		strcpy(address_map, "-");				// No Map
	}

// Internal UART

	else if (mach_info->IODrivers == M_PMCUART) {
		IO_Base  = 0xFE000000;					// General PCI-IO base
		IO_Index = 0xFE00015C;					// External Pnp, if any
		IO_Data  = 0xFE00015D;
		strcpy(address_map, "B");             	// CHRP is Map B
	}

// MVP : little flexibility, so most of these are unused.

	else if (mach_info->IODrivers == M_DISCO) {
		IO_Base  = 0x1E000000;					// PCI @ 1E00_0000
		IO_Index = IO_Base + 0x000003F0;		// VIA PnP
		IO_Data  = IO_Base + 0x000003F1;
		strcpy(address_map, "-");				// No Map
	}

// VIA : used on MARS:Arcadia.  Could be activated for MVP.

	else if (mach_info->IODrivers == M_VIA) {
		IO_Base  = 0xFE000000;
		IO_Index = IO_Base + 0x000003F0;		// VIA PnP
		IO_Data  = IO_Base + 0x000003F1;
		strcpy(address_map, "-");				// No Map
	}

	else if (mach_info->IODrivers == M_VIRTUAL_IO) {
		IO_Base  = 0;
		IO_Index = 0;
		IO_Data  = 0;
		strcpy(address_map, "B");
	}

// MPC85x0 DUART

	else if (mach_info->IODrivers == M_DRACOM_IO) {
		IO_Base  = 0;					// General PCI-IO base
		IO_Index = 0;					// External Pnp, if any
		IO_Data  = 0;
		strcpy(address_map, "B");             	// CHRP is Map B
	}
}


//--------------------------------------------------------------------------
//	init_MAC_nos -- initialize the MACINFO table.  Not required for
//					all platforms.
//--------------------------------------------------------------------------
void init_MAC_nos()
{
	int   i;
	ULONG f;


// If MOTMAC is set, load up defined #

	if (GetEnv( "MOTMAC", misc_tmp ) != NULL) {
	f = strtoul( misc_tmp, (char **) NULL, 10 );
		PRINT("do MOTMAC %d\n", f);
		MAC_nos.mac[0] = 'M';
		MAC_nos.mac[1] = 'O';
		MAC_nos.mac[2] = 'T';
		MAC_nos.mac[3] = 0;
		MAC_nos.mac[4] = 0;
		MAC_nos.mac[5] = f;
		MAC_nos.valid = 1;
		MAC_nos.qty   = 1;
	}


// Get MVP MAC #s.  MVP stores two MAC #'s in a special I2C EEPROM
// dedicated for that purpose.

	else if (mach_info->BoardID == MVP) {
		gme_SetDevAddr( 0x54 );
		for (i = 0; i < 12; i++) {
			gme_I2C_acc( i, &f, B_ACCESS, GME_R );
			//			PRINT("I2C[%d] = %x\n", i, f);
			delay( 0x50000 );
			MAC_nos.mac[i] = f & 0xFF;
		}
		MAC_nos.valid = 1;
		MAC_nos.qty   = 2;
	}

// Elysium -- forthcoming.

}


//--------------------------------------------------------------------------
//	dink_initialize_cpu1 -- init DINK for the second CPU (really just
//							register inits.
//--------------------------------------------------------------------------
void dink_initialize_cpu1()
{

	gp_register_init();
	fp_register_init();
	sp_register_init();
	vp_register_init();
}


//---------------------------------------------------------------------------
//	dink_initialize -- initialize devices.
//---------------------------------------------------------------------------
STATUS dink_initialize()
{
	int i;
#ifdef MVPBOARD
	ULONG f, m;
#endif


// Determine whether we are DINK or MDINK.  Do this early!

	dink_identify();


// Setup global information about the current CPU.

	process_type	= MAX_PROCESS_TYPE;	// Processor type
	GlobalPVR = ((pvr_read() >> 16) & 0xFFFF);

	if ((cpu_info = CPUINFO_match( pvr_read() )) != NULL) {
		strcpy( CPUName, "MPC" );
		strcat( CPUName, cpu_info->Name );
		strcpy( CPUNick, cpu_info->NickName );
		process_type = cpu_info->type;
	}


// Prepare to start IO operations, but not running quite yet -- the
// environment or board-detection code might change the selection of
// IO drivers.

	init_IO_values();
	iolib_prep();


// Standalone PMCs need to know the bus speed, which is kept in a special
// I2C entry.  This must be done before IO initialization.

#ifdef STANDALONE_PMC
	GetStandaloneBusSpeed();
#endif
#ifdef MVPBOARD
	MVP_uart_mode = (MVP_get_GTOPT() & 0x02) ? MVP_X2 : MVP_X3;
#endif


// Initialize bridge logic.

	if (board_type == ARC_CTL
	||  board_type == MARS_ELY) {
		pcibridge_initialize();
		via_initialize();
	}
	else if (board_type == MVP) {
		via_initialize();
	}


// Setup the IO system.  If this is a target-mode MPC8245, swap console and
// host port usage.

	iolib_initialize();

#ifdef ISS
	if (sim_echo == 1)
		dink_ioctl( FD_CONSOLE, IOC_CLEAR, IOC_ONLCR, 0 );
#endif /* ISS */

	if (target_mode != 0)  						// Agent mode
		iolib_swap( FD_CONSOLE, FD_HOST );


#ifdef SHOW_INIT_STATUS
	PRINT("\n\n\n\nI/O system initialized...\n");
#endif


// If enabled, re-configure using environment variables (which are
// stored in a persistent medium somewhere).

	PRINT("\nPIC initialization in progress...\n\n");
	epicInit(0,0);
	PRINT("\n\nEPIC initialization completed...\n");
	ENVLoad();						// Load from SRAM/flash if needed.
	InitWithEnv();
	if (DinkOpts & DO_MIN)			// Force minimal init.
		skip_init = 1;


// This is only needed until non-bus-speed baud clocks are working.

#ifdef MVPBOARD
	if (!SpecBusSpeed) {
		if (board_version == MVP_X2) {
			SpecBusSpeed = 100;
			PRINT("MVP_X2: default bus speed = %d.\n", SpecBusSpeed);
		}
		else {
			if (MVP_uart_mode == MVP_X2) {
				PRINT("MVP_X3: UART in legacy X2 mode\n" );
				SpecBusSpeed = 100;
				PRINT("        default bus speed = %d.\n", SpecBusSpeed);
			}
		}
	}
#endif //MVPBOARD


// Check that the RTC is working.

#ifdef RTC_SUPPORT
	if (!RTC_isvalid())
		PRINT( "RealTime Clock: not running/set.\n");
#endif


// Now, determine the bus speed.  We'll need this for many initialization
// parameters.

	GetBusPeriod();


// For MVP, initialize the I2C.  MemSpeed is not valid yet, so use 'ns'
// as a rough estimate.  Sufficient for I2C timing.

#ifdef MVPBOARD

//	PRINT("i2c ns = %d, %d\n", ns, (1000/ns)*1000000);
	f = MVP_I2C_init( (1000 / ns) * 1000000 );
//	PRINT("f = %d\n", f);
#endif


// Get information in I2C: Ethernet MAC numbers, CPU identity aliases, etc.

	init_MAC_nos();
	if (!skip_init)
		GetIdentity();


// Optimize the memory settings based on the DIMM/embedded I2C SPD EEPROM
// information.

#ifndef MDINK
	PRINT( "Memory Enabled: ");

	if (!skip_init)
		mem_check( 1, Verbose );

	PRINT( "[ %dMB at CL=%d ]\n", memSize/0x100000, memCL );
#endif

// Delayed setup for GT6426X -- seems to fail if performed early.

#ifdef MVPBOARD
	if (!skip_init) {
		PRINT(" GT64260 Setup: [ " );
		f = 0;
		m = 0xFFFFFFFF;

		//		if (BusProtocol == 1) {				// MPX
		f |= 0x00002000;				// (little-endian)
		PRINT("Pipelining ");
		//		}

		if (BusProtocol == 1) {				// MPX
			f |= 0x00010000;				// RdOOO
			PRINT("Read-out-of-order ");
		}

		m &= ~0x00800000;					// FASTCLK 
		PRINT("FastClk ");

		m &= ~0x02000000;					// AACK=2
		PRINT("AACK=2 ");

		GT_CPUSetup( f, m );
		PRINT("]\n");
	}
#endif /* MVPBOARD */


// Now that the ENV has possibly initialized the cache, indicate the
// current status.

#ifndef MDINK
	about_cache();
#endif  /* MDINK */

// Initialize the breakpoint toolbox.

	breakpoint_initialize();
	

//--------------------------------------------------------------------------
// Initialize the GPR/FPR/VPR/SPR register files.


	PRINT("Register Inits: [ ");

	i = gp_register_init();
	PRINT("%d GPRs", i);

	if ((i = fp_register_init()) != 0)
	PRINT(", %d FPRs", i);

	i = sp_register_init();
	PRINT(", %d SPRs", i);

	if ((i = vp_register_init()) != 0)
	PRINT(", %d VPRs", i);
	PRINT(" ]\n");   


// Sandpoint version check (X2 or X3).  Needed for EPIC interrupt setup.

	get_SP_version();


//---------------------------------------------------------------------------
// Networking setup.  The MACs should have been extracted prior to now,
// and the environment is otherwise setup.

	if ((!skip_init)  &&  (target_mode == 0))
		NetSetup();


// AutoBoot now, if possible.

#ifndef MDINK
	if (!skip_init)
		AutoBoot();
#endif  /* MDINK */


// The SRecord decompressor needs to be initialized too.

#ifdef SREC_COMPRESS_SUPPORT
	compression_initialize();
#endif


// If this restart was caused by dink or user taking a Reset Exception
// indicate it here.
 
	if (Push_reset_button != 0)
		PRINT("\nA Reset Exception '0x100' initiated this restart\n");
	else
		Push_reset_button = 1;


// Show the main menu.

	about();

	return( 1 );
}


#ifndef  EDINK 
#ifndef  ISS
/* **********************************************************
This function is designed to go out and:
	1. turn the ERROR_LED off - signifies that self test is in progress
	2. turn the ERROR_LED on  - signifies that DUART loop back test is in progress
	3. turn the ERROR_LED off - signifies that the loop back test passed
* ********************************************************** */
void excimer_bist()
{
  char	loop_char;

  PRINT("Performing self test ....\n");

  *(char *)(0x40600000) = 0x0A;		/* Turn off the ERR LED */

  /* Diagnostic #1 with ERR LED off means sufficient HW functional to
     talk to DUART (ie. MDINK is up which means FLASH-->RAM copy worked */

  delay( 100 );						// Wait 1 second
  *(char *)(0x40600000) = 0x1A;		/* Place in loop mode */
  delay( 100 );						// Wait 1 second
  *(char *)(0x40400000) = 0x2E;		/* Send '.' out duart */
  delay( 100 );						// Wait 1 second
  loop_char = *(char *)(0x40400000);
  if(loop_char == '.')
    {
      *(char *)(0x40200000) = 0x0A;	/* Turn off the STAT LED */
      *(char *)(0x40600000) = 0x0A;	/* Place in normal mode */
      PRINT("Duart loopback Success\n");
    }
  else
    {
      /* Leave the LED on */
      *(char *)(0x40600000) = 0x0A;	/* Place in normal mode */
      PRINT("Duart loopback Failure: Expected a: . got a:  ");
      *(char *)(0x40400000) = loop_char;
      PRINT("\n");
    }

  return;
}
#endif  /* ISS */
#endif  /* EDINK */



//---------------------------------------------------------------------------
//	main -- main DINK loop
//---------------------------------------------------------------------------
main( int argc, char *argv[] )
{
	int	countdown, status;
	int i;
	ULONG val;





//---------------------------------------------------------------------------
// Initialize all of DINK now.
//
// MVPBOARD - DUALVGER     :
// MVPBOARD - non-DUALVGER : normal init.
// EDINK				   : hardly anything (yet)
// other                   : normal init.


#ifndef EDINK
#ifndef ISS
#ifdef MVPBOARD
#ifdef DUALVGER
  /*****************************************************
   * in a dual v'ger system only cpu0 will continue
   * dink initialization.  cpu1 will do a minimal
   * dink_initialize() for gpr init etc and will go to hang
   *
   * if cpu0 running here, cpu1 is still uninitialized.
   * therefore, initialize cpu1 while we are at it. --AAB
   ****************************************************/

	if (read_pid()) {					// We are alternate CPU #1, wait
		while (pause_other_cpu_flag)	// until CPU #0 says we can go
			;

		pause_other_cpu_flag = 1;		// hold cpu0 from advancing

		//before we hang turn on external interrupts
		GpicExtIntEnable();

		//a minimal dink init for cpu1 continues (grp init etc..)
		dink_initialize_cpu1();
		PRINT("  CPU1: ");
		IDProcessor( 1 );

		//let cpu0 continue
		pause_other_cpu_flag = 0;

		//then hang
		hang();    
	}
	else {
		mach_info   = &caps[ board_type ];

		dink_initialize();

		PRINT("MultiProcessor Status:\n  CPU0: ");
		IDProcessor( 1 );

		if (BusProtocol == 0)
			init_cpu1();
		else
			PRINT("  CPU1: (disabled in MPXBus mode)\n");
	}

#else  //DUALVGER
	dink_initialize();
#endif //DUALVGER	

#else  //MVPBOARD

#ifndef ON_BOARD
	if(vdink_init( argc, argv )== FAILURE) return 0;
#endif //ON_BOARD

	mach_info   = &caps[ board_type ];
	dink_initialize();

#endif //MVPBOARD


//---------------------------------------------------------------------------

#ifdef MVPBOARD
#ifdef DUALVGER
	if (BusProtocol == 0) {				// 60X, required for MP

		// Let CPU1 do some more init

		pause_other_cpu_flag = 0;

		// and cpu1 will let cpu0 to continue once it has done its init
		// but make sure there REALLY is cpu1 by checking if cpu_counter is
		// greater than 1

		// delay( 50000 );		// GM: 20 hung at higher bus speeds...
		{
			int last;
			for (i = 0, last = 99; cpu_counter <= 1  &&  i < 3; i++)
				Wait1Second( &last );
		}

		// If "cpu_counter" is greater than 1, the second CPU finished
		// except2.S and should be in main() above.

		if (cpu_counter > 1) {

			//there REALLY is cpu1; wait for cpu1 to signal cpu0 to 'GO'
			while(pause_other_cpu_flag)
				;
			pause_other_cpu_flag = 1;   //restore to default
		}
		else {
			PRINT("  CPU1: Not responding\n");
			if (pause_other_cpu_flag)
				PRINT("  NOTE: CPU1 tried to halt CPU0 before dying\n");
			pause_other_cpu_flag = 1;
		}
	}
#endif	/* DUALVGER */
#endif	/* MVPBOARD */


//---------------------------------------------------------------------------
// Done with MP-init.

#ifdef ON_BOARD

	if (mach_info->HasWinbond) {
		if (target_mode == 0)
			winbond_initialize();
	}


// Once the system is setup, we know the bus speed.  If we are on an
// MPC107/MPC824x system, set the Timer Frequency Reporting Register.
// DINK doesn't make use of it, but Linux expects it to be set.

	if (3 <= board_type  &&  board_type <= 5) {
		i = memSpeed * 1000000;
		sysEUMBBARWrite( /* TFRR */ 0x410F0, i );
	}


//---------------------------------------------------------------------------
// Excimer BootSector check.
//
// We need to check to see if we are on Excimer.  If we are and this is
// a Minimum dink build then we need to check for a 'boot block' at the
// transfer address.  If present perform a countdown (3 seconds) to allow
// the user a specified amount of time to interrupt the automatic jump to
// this boot sector.  If the user performs a keyboard entry in this 3
// seconds then they will be placed at an Excimer prompt. 

	if ((board_type == EXCIMER) && (dink_type == 1)) {
		excimer_bist();

		status = read_from_memory(0xffc00100,&val);
		if (val != 0xffffffff) {
			PRINT("Auto boot in progress ... press any key to abort\n");
			for (countdown = 5; countdown != 0; countdown--) {
				delay( 100 );					// Wait 1 second
				if (dink_fpeekc( FD_CONSOLE )) {
					PRINT("\n... auto boot halted\n");
					break;
				}
				dink_putchar( '0' + countdown );
			}
			if (countdown <= 0) {
				PRINT("\n.........Jumping to boot Sector!\n");
				simple_leap(0xffc00100);
			}
		}
	}


//---------------------------------------------------------------------------
// PCI Bus setup.
// Enumerate the PCI bus devices.

	if (!skip_init  &&  !(DinkOpts & DO_NOPCIMAP)) {
		if (read_pid() == 0) {
			if (target_mode == 0)
				PCIEnum();

			if (board_type == ARC_CTL
			||  board_type == MVP)
				via_postinit();				// Requires PCI init'd
		}
	}
 

// Try to enable a target MPMC card to allow it to run DINK also.

#ifndef STANDALONE_PMC
#ifndef MDINK

	if ((!(DinkOpts & DO_NOAGENT))		// Not suppressed
	&&  (address_map[0] == 'B')) {		// Must be MAP B

		if (target_mode == 0) {			// We are the host, find and enable.

// Host: Look for an MPC8240-, MPC107- or MPC8245-based board.

			agent_device_number = pciAgentProbe( &target_addr );
			if (agent_device_number > -1) {
				PRINT("Enable target systems...\n");

				config_kahlua_agent( );

// Host: compute the PMC Interrupt Line using PCI Device Number 
// minus constant 13. The constant 13 is derived from
// the Sandpoint System Device Number / IDSEL lines
//			   13 - 16 being tied to PMC Interrupt Lines 0 -3.
//			   For example: device 13 will map to PMC line 0.
//			   If the PCI device is in slot 1 (second nearest
//			   to PPMC) its IDSEL is 13, its intA line will be
//			   connected to the PPMC IRQ0 line. The Interrupt
//			   Service Routine for IRQ0 will be installed to
//			   EPIC Interrupt Vector 0 when the EPIC unit is 
//			   initialized. Store the IRQ line to
//			   pmcIntLine global for host EPIC unit. tpeters */

				pmcIntLine = agent_device_number - 13;
				PRINT("  Agent in PCI Slot%d detected.\n", pmcIntLine+1);
			}
			else
				agent_device_number = 0;
		}

// Else we are the agent that was just enabled.

		else {

// Agent: Inbound address translation:
// To use, host will write or read to 0x80000000 to get to agent's local 
// memory at 0x100000.

			sysEUMBBARWrite( L_ATU_ITWR, ATU_BASE|ATU_IW_64K );
			PCI_WriteReg( 0, 0, PCI_LMBAR_REG, W_ACCESS, PCI_MEM_ADR );

// Agent: Outbound address translation */
// To use, agent will write or read to 0x81000000 to get to host's local
// memory at 0x200000.

			sysEUMBBARWrite( L_ATU_OTWR, 0x200000|ATU_IW_64K );
			sysEUMBBARWrite( L_ATU_OMBAR, 0x81000000 );

// Agent: set AGENT_DETECTED flag in pmcIntLine global for Agent EPIC unit.
// The Agent's Message Unit interrupt will be enabled when the EPIC
// unit is initialized.

			pmcIntLine = AGENT_DETECTED;
			agent_device_number = pmcIntLine;
		}
	}
#endif	// not MDINK
#endif 	// not STANDALONE_PMC

#endif	// ON_BOARD


#ifdef STANDALONE_PMC_PCI

	PRINT("PCI Probing enabled...\n");
	mach_info->HasPCI = TRUE;
	mach_info->HasRTC = TRUE;
	mach_info->EnvType = M_ENVRTC;
	target_mode = 0;
	
#endif /* STANDALONE_PMC_PCI */


//---------------------------------------------------------------------------
// Post-PCI setup initialization

// Now that PCI is setup, it is safe to stop disabling incoming PCI
// transactions.

#ifdef MVPBOARD
	MVP_enable_PCI();
#endif /* MVPBOARD */


// If initialization completes, reset the status LEDs.

	board_ctl( BDCTL_LED, 0 );	// 0 = off

#else /* not define ISS i.e. define ISS*/
	mach_info   = &caps[ board_type ];
#endif /* not define ISS */
#else /* not define EDINK i.e. define EDINK */
	mach_info   = &caps[ board_type ];
#endif /* not define EDINK */

#ifdef ISS 
	sim_fprintf(sim_stderr,"Hello sportal from sim_stderr\n");
	sim_printf("Hello sportal from sim_stdout\n");
	sim_printf("Do you desire echo on or off?");
	sim_printf("Typically off for sim terminal, on for sim file io\n");
	sim_printf("Please type in \"on\" or \"off\" >>");
	sim_scanf("%s",&misc_tmp);
	sim_getc(sim_stdin);
	sim_echo = strcasecmp( misc_tmp, "on" ) == 0 ? 1 : 0;
	sim_printf("\n  You have chosen \"%s\" = %d\n\n",misc_tmp, sim_echo);
	if (sim_echo == 1)
		dink_ioctl( FD_CONSOLE, IOC_CLEAR, IOC_ONLCR, 0 );
	sim_printf("\n");
#endif /* ISS */

#ifdef EDINK 

	mach_info   = &caps[ board_type ];
	dink_initialize();
#endif /* EDINK */

#ifdef ISS
	mach_info   = &caps[ board_type ];
	dink_initialize();
#endif /* ISS */


//---------------------------------------------------------------------------
// Start using DINK!

	shell_init( ~skip_init );
	start = &dink_loop;
	dink_loop( 0 );	


// Restore IO for non-board builds on exit.

	iolib_shutdown();

	return( 0 );
}



#ifdef EDINK
int SPU_register_init()
{
  //  initialize the e500 SPU vector register set
  //  will be done later
  return 0;                                     
}
#endif /* EDINK */
