
//includes 
#include "dink_asm.h"
			
//extern definitions

.extern  timebase_register_l
.extern  timebase_register_u
.extern  current_hid0
.extern  current_msr
.extern  current_srr0
.extern  current_lr
.extern  current_cr
.extern  current_r4
.extern  current_r3
.extern  current_r5
	
//equ definitions


//exception table set to start at 0xnnnn0100;  see section 2.6.1.7 of e500 Core
//complex implementation definition for a list of the interrupt types and
//the registers programmed to point to these addresses.  The IVORs and IVPR
//are programmed to point to 0x0000xxxx.
/*********************************************
 *  EH100S: critical interruppt uses the critical_exception_handler
*********************************************/
	
	.text
	.align	2
	.space	(0x100)			//  0x0 ---> 0x100	
// 	CRITICAL INPUT INTERRUPT (IVOR0)
// 	Critical Input Exception - 00100

	.set	pgval,0x100

// 	Store value of 0x100 into critical_ex_type variable
// 	and branch (open-ended) to critical_handle_ex.

EH100S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, critical_ex_type@h		//  get high order address  
	ori	r4,r4, critical_ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, critical_ex_addr@h		//  get high order address  
	ori	r4,r4, critical_ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	critical_handle_ex	//  branch to critical_handle_ex 
EH100E: 

	.space 0x100-(EH100E-EH100S)     //  skip to 0x200
//	MACHINE CHECK INTERRUPT (IVOR1)
/*********************************************
 *  EH200S: machine check interruppt uses the machine_exception_handler
*********************************************/
// 	Machine Check Exception - 00200

	.set	pgval,0x200

// 	Store value of 0x200 into machine_ex_type variable
// 	and branch (open-ended) to machine_handle_ex.

EH200S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, machine_ex_type@h		//  get high order address  
	ori	r4,r4, machine_ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, machine_ex_addr@h		//  get high order address  
	ori	r4,r4, machine_ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	machine_handle_ex	//  branch to machine_handle_ex 
EH200E: 
	
	.space 0x100-(EH200E-EH200S)     //  skip to 0x300
//	DSI DATA STORAGE INTERRUPT (IVOR2)
/*********************************************
 *  EH300S on:  all use the normal_exception_handler
*********************************************/
// 	Data Storage Exception - 00300

	.set	pgval,0x300

// 	Store value of 0x300 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EH300S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EH300E: 

	.space 0x100-(EH300E-EH300S)     //  skip to 0x400
//	ISI INSTRUCTION STORAGE INTERRUPT (IVOR3)
// 	Instruction Storage Exception - 00400

	.set	pgval,0x400

// 	Store value of 0x400 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EH400S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EH400E: 
	
	.space 0x100-(EH400E-EH400S)     //  skip to 0x500
//	EXTERNAL INPUT INTERRUPT (IVOR4)
// 	Data Storage Exception - 00500

	.set	pgval,0x500

// 	Store value of 0x500 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EH500S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	//b	normal_handle_ex		//  branch to normal_handle_ex 
	b	epic_exception		//  branch to normal_handle_ex 
EH500E: 
	
	.space 0x100-(EH500E-EH500S)     //  skip to 0x600
//	ALIGNMENT INTERRUPT (IVOR5)
EH600S: 
// 	Alignment Exception - 00600

	.set	pgval,0x600

// 	Store value of 0x600 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EH600S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EH600E: 

	.space 0x100-(EH600E-EH600S)     //  skip to 0x700
//	PROGRAM INTERRUPT (IVOR6)

// 	Program Exception - 00700

	.set	pgval,0x700

// 	Store value of 0x700 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EH700S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 

EH700E: 

	.space 0x100-(EH700E-EH700S)     //  skip to 0x800
//	FLOATING POINT UNAVAILABLE (not implemented on e500) (IVOR7)
// 	Floating Point unavailable Exception - 00800

	.set	pgval,0x800

// 	Store value of 0x800 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EH800S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EH800E: 

	.space 0x100-(EH800E-EH800S)     //  skip to 0x900
//	DECREMENTER INTERRUPT (IVOR10)
// 	Decrementer  - 00900

	.set	pgval,0x900

// 	Store value of 0x900 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EH900S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EH900E: 

	.space 0x100-(EH900E-EH900S)     //  skip to 0xA00
//	AUXILIARY PROCESSOR UNAVAILABLE (not implemented on e500) (IVOR9)
// 	Auxiliary Processor - 00a00

	.set	pgval,0xa00

// 	Store value of 0xa00 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EHA00S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EHA00E: 

	.space 0x100-(EHA00E-EHA00S)     //  skip to 0xB00
//	FIXED INTERVAL INTERRUPT (IVOR11)
// 	Fixed Interval Exception - 00b00

	.set	pgval,0xb00

// 	Store value of 0xb00 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EHB00S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EHB00E: 
	

	.space 0x100-(EHB00E-EHB00S)     //  skip to 0xC00
//	SYSTEM CALL INTERRUPT (IVOR8)
// 	System Call Exception - 00c00

	.set	pgval,0xc00

// 	Store value of 0xc00 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EHC00S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EHC00E: 

	.space 0x100-(EHC00E-EHC00S)     //  skip to 0xD00
//	WATCHDOG TIMER INTERRUPT (IVOR12)
// 	Watchdog Timer Exception - 00d00

	.set	pgval,0xd00

// 	Store value of 0xd00 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EHD00S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EHD00E: 

	.space 0x100-(EHD00E-EHD00S)     //  skip to 0xE00
//	Not Used
EHE00S: 
	b	EHE00S	// hang here - we should never get to this interrupt
EHE00E: 
	
	.space 0x100-(EHE00E-EHE00S)     //  skip to 0xF00
//	PERFORMANCE MONITOR INTERRUPT (IVOR35)
// 	Performance Monitor Exception - 00f00

	.set	pgval,0xf00

// 	Store value of 0xf00 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EHF00S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EHF00E: 

	.space 0x100-(EHF00E-EHF00S)     //  skip to 0x1000
//	INSTRUCTION TLB ERROR INTERRUPT (IVOR14)
// 	Instruction TLB error Exception - 01000

	.set	pgval,0x1000

// 	Store value of 0x1000 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EH1000S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EH1000E: 

	.space 0x100-(EH1000E-EH1000S)     //  skip to 0x1100
//	DATA TLB ERROR INTERRUPT (IVOR13)
// 	Data TLB error Exception - 01100

	.set	pgval,0x1100

// 	Store value of 0x1100 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EH1100S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EH1100E: 

	.space 0x100-(EH1100E-EH1100S)     //  skip to 0x1200
//	VECTOR FLOATING POINT DATA INTERRUPT (IVOR33)
// 	Vector Floating Point Data Exception - 01200

	.set	pgval,0x1200

// 	Store value of 0x1200 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EH1200S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EH1200E: 

	.space 0x100-(EH1200E-EH1200S)     //  skip to 0x1300
//	VECTOR FLOATING POINT ROUND INTERRUPT (IVOR34)
// 	Vector Floating Point Round Exception - 01300

	.set	pgval,0x1300

// 	Store value of 0x1300 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EH1300S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EH1300E: 

	.space 0x100-(EH1300E-EH1300S)     //  skip to 0x1400
//	NOT USED 
EH1400S:
	b   EH1400S		// hang here - should never get here
EH1400E: 

	.space 0x100-(EH1400E-EH1400S)     //  skip to 0x1500
//	DEBUG INTERRUPT (IVOR15)
// 	Debug Exception - 01500

	.set	pgval,0x1500

// 	Store value of 0x1500 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EH1500S:

//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EH1500E: 

	.space 0x100-(EH1500E-EH1500S)     //  skip to 0x1600
//	SPU INTERRUPT (IVOR32)
// 	SPU Exception - 001600

	.set	pgval,0x1600

// 	Store value of 0x1600 into ex_type variable
// 	and branch (open-ended) to normal_handle_ex.

EH1600S:


//  Save the values of r3 and r4 before you use them//  Trash sprg2 and sprg3 in order
//  to pull this off.

	mtspr	sprg3,r3
	sync
	mtspr	sprg2,r4
	sync


	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  


	addis	r3,0,0			//  load upper 16 bits with 0000  
	ori	r3,r3,pgval		//  load lower 16 bits with value  

	stwx	r3,0,r4			//  store into ex_type variable  


	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  


	mfsrr0	r3			//  get address of exception	
	stwx	r3,0,r4			//  store into ex_addr variable  

	b	normal_handle_ex		//  branch to normal_handle_ex 
EH1600E: 


//   reserve space for future exception handlers

	.space 0x100-(EH1600E-EH1600S)     //  skip to 0x1700
//	NOT USED 
EH1700S:
	b   EH1700S		// hang here - should never get here
EH1700E: 

	.space 0x100-(EH1700E-EH1700S)     //  skip to 0x1800
//	NOT USED 
EH1800S:
	b   EH1800S		// hang here - should never get here
EH1800E: 

	.space 0x100-(EH1800E-EH1800S)     //  skip to 0x1900
//	NOT USED 
EH1900S:
	b   EH1900S		// hang here - should never get here
EH1900E: 

	.space 0x100-(EH1900E-EH1900S)     //  skip to 0x1a00
//	NOT USED 
EH1A00S:
	b   EH1A00S		// hang here - should never get here
EH1A00E: 

	.space 0x100-(EH1A00E-EH1A00S)     //  skip to 0x1b00
//	NOT USED 
EH1B00S:
	b   EH1B00S		// hang here - should never get here
EH1B00E: 

	.space 0x100-(EH1B00E-EH1B00S)     //  skip to 0x1c00
//	NOT USED 
EH1C00S:
	b   EH1C00S		// hang here - should never get here
EH1C00E: 

	.space 0x100-(EH1C00E-EH1C00S)     //  skip to 0x1d00
//	NOT USED 
EH1D00S:
	b   EH1D00S		// hang here - should never get here
EH1D00E: 

	.space 0x100-(EH1D00E-EH1D00S)     //  skip to 0x1e00
//	NOT USED 
EH1E00S:
	b   EH1E00S		// hang here - should never get here
EH1E00E: 

	.space 0x100-(EH1E00E-EH1E00S)     //  skip to 0x1f00
//	NOT USED 
EH1F00S:
	b   EH1F00S		// hang here - should never get here
EH1F00E: 

	.space 0x100-(EH1F00E-EH1F00S)     //  skip to 0x2000

/************************************************************
/*   There are three types of exceptions
/*   1.  Normal exception which are handled by normal_handle_ex
/*   2.  Critical exceptions which are handled by critical_handle_ex
/*   3.  Machine check exception handled by machine_handle_ex
 ************************************************************/

.text	
.align	2
.global	normal_handle_ex

normal_handle_ex:					//  Begin Main Routine 
						//  Internal variables 
	.set	user_code_value,1		//  user code value for  
						//  in_which_code variable. 
	.set	duart_buf_check,1		//  duart-handled-char value 
						//  for is_char_in_duart result. 

//  Prolog -- store regs to be used

//  SPRG2 and SPRG3 have the original values of r3 and r4 in them. Here,
//  original means at the time the exception was taken. 

//  If this is a user exception (ie. an exception taken while running user code)
//  and they have not bothered to provide their own exception handlers then 
//  DINK will report the type exception and re-enter DINK.......  We will not 
//  report the exception and then return to the User code because they probably
//  haven't planned on this and we will continue to take exceptions.  Rather,
//  a more conservative approach is to record the type of exception and then 
//  enter DINK cleanly.  

//  Since the go and trace commands on DINK make certain that the link
//  register (lr) has a valid value to re-enter DINK one way for the User
//  to bypass all this exception handling is to branch to the link register
//  (provided they haven't modifed it or have restored it if they did modify
//  it).  If they rely on an illegal exception, or breakpoint to re-enter DINK
//  then we will manually jump to the go_trace routine re-entry point which 
//  will preform all of the breakpoint flush routines, cache disable_flush etc..
//  to re-enable proper dis-assembly and future breakpoint functionality.  
//  The label to jump to is 'exception_return'.

//  Added by tpeters Oct.'99
//  Modified the exception handler to recover from exceptions taken in EITHER
//  Dink or User code. This is handled by checking the in_which_code value 
//  (0 for Dink, 1 for User). If we were in Dink code, jump to the 
//  dinkException: code block to handle it. Also modified the state variables
//  user_xxxx to now read current_xxxx since they now can refer to both user
//  AND dink values. The handler now behaves as follows:
//    - All Kahlue-EPIC (0x500) exceptions are hanled by the epic_exception 
//	handler. This handler RFI's back to interrupted code whether it was in
//	Dink or User code.
//    -	All other exceptions are handled by handle_ex. Exceptions taken in user
//	code return to the Dink Prompt. Exceptions taken in Dink code RFI back 
// 	to where Dink was interrupted.

//  Since we have added the bench_mark capability we will save the time_base 
//  register into the time_base variable whenever we handle any exception.
//  This will allow us to just print the variable out when we make it 
//  to the bench_mark() routine. --- RGP 1/5/97

/************************
	save registers
**************************/

// 1.  Save the current CR

	mfcr	r4
	lis	r3,current_cr@h
	ori	r3,r3,current_cr@l
	stwx	r4,0,r3

#ifdef PERF_MONITOR
// 2.  Determine if this processor has performance counters
 
	lis	r3,process_type@h
	ori	r3,r3,process_type@l
	lbz     r4, 0(r3)
	cmpi    0,0,r4, 0x35
	blt     no_MMCR0_stop
	
// 3.  Freeze performance counter

	mfspr	r3,952			// Get MMCR0 register
	oris	r3,r3,0x8000	// Freeze performance monitor counting	
	mtspr	952,r3
no_MMCR0_stop:

#endif  // PERF_MONITOR

// 4.  Save r5 to have another available register

	lis	r3,current_r5@h
	ori	r3,r3,current_r5@l
	stwx	r5,0,r3



read_TB_stop:
	mfspr	r3,269		// Get TBU.
	mfspr	r4,268		// Get TBL.
	mfspr	r5,269		// Get TBU again.
	subf.	r3,r3,r5	// Did it increment between reading TBU and TBL?
	bgt-	read_TB_stop	// If so, read them again.  (Not likely)

	lis	r3,TBU_stop@h
	ori	r3,r3,TBU_stop@l      
	stw	r5,0(r3)	
	lis	r3,TBL_stop@h
	ori	r3,r3,TBL_stop@l      
	stw	r4,0(r3)

//  Lets get the current values of LR, CR, R3, R4, HID0, SRR0 and MSR
//  (from SRR1) before we do anything to it.

	mfspr	r4,hid0
	lis	r3,current_hid0@h
	ori	r3,r3,current_hid0@l
	stwx	r4,0,r3
	sync

	mfspr	r4,srr1			//  srr1 has value of MSR from when
	lis	r3,current_msr@h 	//  the exception was taken
	ori	r3,r3,current_msr@l
	stwx	r4,0,r3
	sync

	mfspr	r4,srr0			//  srr0 has the next instruction to
	lis	r3,current_srr0@h	//  be executed, save if we want to rfi
	ori	r3,r3,current_srr0@l	//  back to it
	stw	r4,0(r3)
	sync

	mfspr	r4,lr
	lis	r3,current_lr@h
	ori	r3,r3,current_lr@l
	stwx	r4,0,r3
	sync

	mfcr	r4
	lis	r3,current_cr@h
	ori	r3,r3,current_cr@l
	stwx	r4,0,r3
	sync

	mfspr	r4,sprg2	
	lis	r3,current_r4@h
	ori	r3,r3,current_r4@l
	stwx	r4,0,r3
	sync

	mfspr	r4,sprg3
	lis	r3,current_r3@h
	ori	r3,r3,current_r3@l
	stwx	r4,0,r3
	sync
        

//  Added by tpeters: the save_sprs routine called by save_to_user 
//  and save_to_dink expects sprg0/1 in these temp_sprg0/1 globals.
	mfspr	r4,sprg0
	lis	r3,temp_sprg0@h
	ori	r3,r3,temp_sprg0@l
	stw	r4,0(r3)

cont_handle_ex:

// We need to figure out if the exception took place in user code
// or dink code. If it happend in dink, we can simply save Dink state,
// call deal_w_exception, restore restore Dink state and RFI back to dink. If it
// happened in user code, we need to flush caches, save user state, restore
// dink, call deal_w_exception, restore caches and return to dink.

	lis	r3,in_which_code@h
	ori	r3,r3,in_which_code@l
	lwz	r3,0(r3)
	cmpi	0,0,r3,0x0		//  Were we in Dink code?

	beq	cr0,dinkException	//  If no, continue

//  We can now save the User's Programming model and restore the
//  DINK Programming model. We will save the User's registers
//  below using the common routines and then before we leave this
//  routine (since we know that we are in an exception handler)
//  we will load the 5 user values which have been stored above
//  into the user.locs in the register files.  This will show 
//  the programmer the correct values in those registers when 
//  they are using DINK.  So in summary, even though we have 
//  corrupted a few registers before the save_to routines are
//  called we can recover by using the values that
//  are already stored in the global variables.

//  I am about to call save_to_user which performs floating point operations.
//  In order to do that I must set the msr to enable the floating point...

	mfmsr	r4
	ori	r4,r4,0x2000	//  Set FP bit but do not turn on translation
	mtmsr	r4
	sync
					//  If no,
	bl	save_to_user		//  save user pgm model 
					//  Note: This function has additions
					//  to save the globals above
					//  (ie. current_msr, current_hid0,
					//  current_lr,current_r3-4,
					//  temp_sprg0-1)

//  Added by tpeters Oct.'99					
//  We are re-entering Dink, so we have reset the in_which_code
//  global back to the dink_code value 0.

	lis	r3,in_which_code@h	//  load variable address
	ori	r3,r3,in_which_code@l
	xor	r4,r4,r4		//  zero out r4, DINK=0
	stw	r4,0(r3)		//  store r4 to in_which_code global

	bl	restore_partial_dink
	ori	0,0,0
					//  restore the stack ptr
					//  and the bats so that 
					//  deal_with_exception won't 
					//  cause a memory fault and
					//  will use the right stack
					//  pointer.  

					//  always deal with exception. 
	bl	deal_w_exception	//  branch to d_w_e -- it gets 
	ori	0,0,0			//  ex_type from vector routines. 

	bl	restore_to_dink		//  restore dink pm 
	ori	0,0,0
	
//  It's time to re-enter DINK.......

	ori	0,0,0
	b	exception_return	//  re-enter DINK in common spot....

//  Added by tpeters Oct.'99 
//  to handle exceptions that occur while in dink code 
//  Dink is already running here, only the MSR was modified when we 
//  took the exception. We need to restore Dink's MSR (0x3930),
//  For e500 Dink's MSR is 0x0200_0000
//  save_to_dink so deal_w_exception's print routine calls don't
//  destroy any registers, restore_to_dink, restore state values saved
//  off when we took the exception, and then RFI back to dink code where
//  we took the exception.

dinkException:

#ifdef EDINK
	lis	r3,0x0200   // e500 set msr to 0x0200_0000
#else  /* EDINK */
	mfmsr	r3			// for save_to_dink to save FP
	ori	r3,r3,0x2000		// make sure to FP unit is on
#endif /*  EDINK */
	mtmsr	r3			
	sync
	bl	save_to_dink		// Save Dink state

#ifdef  EDINK
	lis	r3,0x0200   // e500 set msr to 0x0200_0000
#else  /* EDINK */
	lis	r3,0x0000		// restore MSR to 0x3930
	ori	r3,r3,0x3930		// turn translations on for I/O
#endif /*  EDINK */
	mtmsr	r3			
	sync

	bl	deal_w_exception	// print statements for all ex_types
	
	bl	restore_to_dink		// restore Dink state

	mfspr	r1,sprg1		// restore saved off current_registers
	mfspr	r2,sprg2		// that were saved off when the
					// exception was taken
	lis	r3,current_hid0@h	
	ori	r3,r3,current_hid0@l
	lwz	r3,0(r3)
	mtspr	hid0,r3
	sync

	lis	r3,current_msr@h
	ori	r3,r3,current_msr@l
	lwz	r3,0(r3)
	mtspr	srr1,r3
	sync

	lis	r3,current_srr0@h
	ori	r3,r3,current_srr0@l
	lwz	r3,0(r3)
	mtspr	srr0,r3
	sync

	lis	r3,current_lr@h
	ori	r3,r3,current_lr@l
	lwz	r3,0(r3)
	mtlr	r3
	sync

	lis	r3,current_cr@h
	ori	r3,r3,current_cr@l
	lwz	r3,0(r3)
	mtcr	r3
	sync

	lis	r3,temp_sprg0@h
	ori	r3,r3,temp_sprg0@l
	lwz	r3,0(r3)
	mtspr	sprg0,r3
	sync

	lis	r3,temp_sprg1@h
	ori	r3,r3,temp_sprg1@l
	lwz	r3,0(r3)
	mtspr	sprg1,r3
	sync

	lis	r3,current_r5@h
	ori	r3,r3,current_r5@l
	lwz	r5,0(r3)
	
	lis	r3,current_r3@h
	ori	r3,r3,current_r3@l
	lwz	r3,0(r3)

	lis	r4,current_r4@h
	ori	r4,r4,current_r4@l
	lwz	r4,0(r4)

	rfi			//  RFI back to interrupted dink process 

	.text
	.align	2
	.global	rfi_to_dinkloop

rfi_to_dinkloop:
	//the only way we got here was to take an exception in user code
	//or a clean return from user code. right now we just restore dink's
	//msr value blindly with 0x3930, but this is not correct if dink's
	//msr value was something else prior to the go command. 
	//save_to_dink saves dink's msr value in MSR_LOC when a go is performed.
// e500 msr is 0x0200_0000
	//restore_partial_dink sets the msr to 0x3930 for I/O and translations.
	//restore_to_dink sets srr1 to dink's MSR_LOC value. After this we use
	//to jump to dink_loop(), so the real msr value never gets restored.
	//instead of jumping to dink_loop(), let's rfi to it so the msr value
	//in srr1 is restored properly.

	//srr1 should have dink's msr value prior to the 'go' command

	mtspr	srr1,r3
	
	lis	r3,dink_loop@h
	ori	r3,r3,dink_loop@l
	mtspr	srr0,r3
	sync

	rfi	//  RFI back to dink_loop() with correct msr value in srr1



.global	critical_handle_ex

critical_handle_ex:					//  Begin Main Routine 
						//  Internal variables 
	.set	user_code_value,1		//  user code value for  
						//  in_which_code variable. 
	.set	duart_buf_check,1		//  duart-handled-char value 
						//  for is_char_in_duart result. 

//  Prolog -- store regs to be used

/*****************************************************
 *  We really don't know what to do here yet.
 *  this is a critical input and it can occur during
 *  machine check or normal exception processing
 *  so, we can't just save and restore registers using
 *  the same variables as normal exception processing.
 *  And, we really don't know what to do with this
 *  type of interrupt.
 *  Hence, we are just going to put the exception type in r10
 *  and the exception address in r11 and hang.
*****************************************************/
	lis	r3,in_which_code@h
	ori	r3,r3,in_which_code@l
	lwz	r3,0(r3)
	cmpi	0,0,r3,0x0		//  Were we in Dink code?
/**************
 *	For now, we want to go to dinkloop, because we don't
 *    have the code to return to dink
 *
 *	beq	cr0,dinkException	//  If no, continue
 *******************/	
/******************************************************
 *   For now, we don't have the framework of dink
 *    so don't do the rfi, just hang here and we can put 
 *    a breakpoint here in case we take a normal exception
******************************************************/
	li	r9,CRITICAL_EX
	bl      tempGetException  // set r10, r11, and r12
	.global	rfiCriticalEx
rfiCriticalEx:
	b	rfiCriticalEx	// hang here
/************ end of handle critical exceptions  ************/


.global	machine_handle_ex

machine_handle_ex:					//  Begin Main Routine 
						//  Internal variables 
	.set	user_code_value,1		//  user code value for  
						//  in_which_code variable. 
	.set	duart_buf_check,1		//  duart-handled-char value 
						//  for is_char_in_duart result. 

//  Prolog -- store regs to be used

/*****************************************************
 *  We really don't know what to do here yet.
 *  this is a machine input and it can occur during
 *  a normal exception processing
 *  so, we can't just save and restore registers using
 *  the same variables as normal exception processing.
 *  And, we really don't know what to do with this
 *  type of interrupt.
 *  Hence, we are just going to put the exception type in r10
 *  and the exception address in r11 and hang.
*****************************************************/
	lis	r3,in_which_code@h
	ori	r3,r3,in_which_code@l
	lwz	r3,0(r3)
	cmpi	0,0,r3,0x0		//  Were we in Dink code?
/**************
 *	For now, we want to go to dinkloop, because we don't
 *    have the code to return to dink
 *
 *	beq	cr0,dinkException	//  If no, continue
 *******************/	
/******************************************************
 *   For now, we don't have the framework of dink
 *    so don't do the rfi, just hang here and we can put 
 *    a breakpoint here in case we take a normal exception
******************************************************/
	li	r9,MACHINE_EX
	bl      tempGetException  // set r10, r11, and r12
	.global	rfiMachineEx
rfiMachineEx:
	b	rfiMachineEx	// hang here
/************ end of handle machine exceptions  ************/

	
/*
 *  get exception and address where exception occured and store in
 *  r10 and r11
 *  this is a temporary debug technique for returning from an 
 *  exception handler.
 *  It is easy in the debugger to look at r10 - exception number
 *  and r11 - address which caused the exception.
 */
tempGetException:
	.global tempGetException
/***********************************************
input:  r9 = NORMAL_EX, CRITICAL_EX, or MACHINE_EX type exception occured
output:
 * get the exception type and put in r10 
 * get the exception addr and put in r11 
 * get the user msr  and put in r12 
***********************************************/
	cmpwi	r9,NORMAL_EX
	bne     tryCritical
	lis	r4, ex_type@h		//  get high order address  
	ori	r4,r4, ex_type@l	//  get low order address  
	b	getTypeDone
tryCritical:
	cmpwi	r9,CRITICAL_EX
	bne     tryMachine
	lis	r4, critical_ex_type@h		//  get high order address  
	ori	r4,r4, critical_ex_type@l	//  get low order address  
	b	getTypeDone
tryMachine:
	lis	r4, machine_ex_type@h		//  get high order address  
	ori	r4,r4, machine_ex_type@l	//  get low order address  
getTypeDone:

	lwzx	r10,0,r4		//  load from ex_type variable  


	cmpwi	r9,NORMAL_EX
	bne     tryCriticala
	lis	r4, ex_addr@h		//  get high order address  
	ori	r4,r4, ex_addr@l	//  get low order address  
	b	getAddrDone
tryCriticala:
	cmpwi	r9,CRITICAL_EX
	bne     tryMachinea
	lis	r4, critical_ex_addr@h		//  get high order address  
	ori	r4,r4, critical_ex_addr@l	//  get low order address  
	b	getAddrDone
tryMachinea:
	lis	r4, machine_ex_addr@h		//  get high order address  
	ori	r4,r4, machine_ex_addr@l	//  get low order address  
getAddrDone:

	lwzx	r11,0,r4		//  store from ex_addr variable  

	// get user msr  from srr1 saved above
	lis	r4, current_msr@h		//  get high order address  
	ori	r4,r4, current_msr@l	//  get low order address  

	lwzx	r12,0,r4		//  store from current_msr variable  


	blr			// return to caller


//===========================================================================


/* Return routine so user code can return using blr,
   not the old "take an exception" method
   when a go command is issue at DINK command line, the
   address of user_return is put in the link register.
   when user code blr's to DINK, this routine sets up a
   smooth path through the exception handler back to DINK */

	.text
	.align 2
	.global	user_return
user_return:
	mtspr	sprg3,r3		//save off r3 and r4
	sync
	mtspr	sprg2,r4		//handle_ex expects them in
	sync
	lis	r3,usr_code_rtn@h	//sprg3 and 4
	ori	r3,r3,usr_code_rtn@l	//set global to let us know 
	li	r4,0x0001		//we're returning from user code
	stw	r4,0(r3)
	addis	r3,0,0			//load upper 16 bits with 0000  
	ori	r3,r3,0xaaaa	//load lower 16 bits with value  
					//0xAAAA for user code return
					//through deal_w_exception
	lis	r4,ex_type@h	//get high order address  
	ori	r4,r4,ex_type@l	//get low order address  
	stwx	r3,0,r4			//store into ex_type variable  
	b	normal_handle_ex		//branch to handle_ex 


