//---------------------------------------------------------------------
//support for PQ3 ADS board
//added by AK [06/19/03]
#define MPC8540ADS  //all PQ3-ADS board related stuffs will
                    //be picked up instead of elysium; in 
		    //order to work with elysium board comment
		    //out this definition

#define MPC8560ADS  //added for epic need
		    
/*
 * support for both the PQ3 Engineering board
 * and PILOT board are provided in ELYSIUM 
 * define either of the two following definitions
 * and comment out the other one. Default selection
 * is PILOT board. The only hardware difference 
 * between ENG and PILOT boards that affect software
 * is that in ENG board the Flash port size is 16-bit
 * and in PILOT board the port size is 32-bit
 */		    
//#define ADS_ENG_BOARD //Flash port size is 16-bit 
#define ADS_PILOT_BOARD //Flash port size is 32-bit


/*
 * if you want to add trace points in the boot 
 * rom that is in the startup.S file then uncomment
 * the following definitions
 */
#define ADS_DEBUG_BOOT_ROM

/*
 * if you want to run the edink out of the ddr 
 * memory instead of programming the FLASH then
 * uncomment the following definition
 */
#define ADS_BOOT_DDR


//if the PQ3 board is chosen the PQ3 DDR
//related parameters would be defined here
#ifdef MPC8540ADS
#define ADS_CFG_DDR_CS0_BNDS   0x00000007
#define ADS_CFG_DDR_CS0_CONFIG 0x80800001
#define ADS_CFG_DDR_TIMING_1   0x5763C332	
#define ADS_CFG_DDR_TIMING_2   0x00000800	
#define ADS_CFG_DDR_MODE       0x00000022
#define ADS_CFG_DDR_INTERVAL   0x04100000
#define ADS_CFG_DDR_DEBUG4     0x0000000D
#define ADS_CFG_DDR_CONTROL    0xC2000000
#endif


//#define	LOCAL_SDRAM_AS_SYS_MEM
#define DDR_AS_SYS_MEM



//---------------------------------------------------------------------------
// msync not recognized yet


//#define	msync 	.long 0x7c0004ac 

#define	msync 	sync


//---------------------------------------------------------------------------
// MAS/TLB definition.

#define bem0_TLB(b)	     ((b & 1) << 28)
#define bem0_ESEL(b)	     ((b & 0xf) << 16)
#define bem0_NV(b)	     ((b & 1) << 0)
#define bem_MAS0(t,e)	     (bem0_TLB(t) | bem0_ESEL(e))

#define bem1_VALID(b)	     ((b & 1) << 31)
#define bem1_IPROT(b)	     ((b & 1) << 30)
#define bem1_TID(b)	     ((b & 0xFF) << 16)
#define bem1_TS(b)	     ((b & 1) << 12)
#define TLB_SIZE_1M	     (0x0500)
#define TLB_SIZE_4M	     (0x0600)
#define TLB_SIZE_16M	     (0x0700)
#define TLB_SIZE_64M	     (0x0800)
#define TLB_SIZE_256M	     (0x0900)
#define TLB_SIZE_1G	     (0x0A00)
#define TLB_SIZE_4G	     (0x0B00)
#define bem_MAS1(s)	     (bem1_VALID(1)|bem1_IPROT(1)|bem1_TID(0)|s)

#define bem2_SHARE(b)	     ((b & 1) << 9)
#define bem2_W(b)	     ((b & 1) << 4)
#define bem2_I(b)	     ((b & 1) << 3)
#define bem2_M(b)	     ((b & 1) << 2)
#define bem2_G(b)	     ((b & 1) << 1)
#define bem2_E(b)	     ((b & 1) << 0)
#define bem2_WIMGE(w,i,m,g,e)(bem2_W(w)|bem2_I(i)|bem2_M(m)|bem2_G(g)|bem2_E(e))
#define bem2_EPN(v)	     (v & 0xFFFFF000)
#define bem_MAS2(a,s,wimge)  (bem2_EPN(a)|bem2_SHARE(s)|wimge)

#define bem3_RPN(v)	     (v & 0xFFFFF000)
#define PERM_ALL	     (0x3F)
#define PERM_SUPER	     (0x15)
#define PERM_USER	     (0x2A)
#define bem_MAS3(a,p)	     (bem3_RPN(a)| p)



//---------------------------------------------------------------------------
// LAW -- Local Access Window definitions

#define LAW_BAR0		0x0C08
#define LAW_BAR1		0x0C28
#define LAW_BAR2		0x0C48
#define LAW_BAR3		0x0C68
#define LAW_BAR4		0x0C88
#define LAW_BAR5		0x0CA8
#define LAW_BAR6		0x0CC8
#define LAW_BAR7		0x0CE8

#define LAW_AR0			0x0C10
#define LAW_AR1			0x0C30
#define LAW_AR2			0x0C50
#define LAW_AR3			0x0C70
#define LAW_AR4			0x0C90
#define LAW_AR5			0x0CB0
#define LAW_AR6			0x0CD0
#define LAW_AR7			0x0CF0


// LAW bit definitions

#define LAW_EN			0x8000


// LAW Targets

#define LAW_TGT_PCI		0x0000
#define LAW_TGT_LBUS		0x0040
#define LAW_TGT_RAPIDIO		0x00C0
#define LAW_TGT_DDR		0x00F0


// LAW Sizes.

#define LAW_SIZE_4K		0x0B
#define LAW_SIZE_8K		0x0C
#define LAW_SIZE_16K		0x0D
#define LAW_SIZE_32K		0x0E
#define LAW_SIZE_64K		0x0F
#define LAW_SIZE_128K		0x10
#define LAW_SIZE_256K		0x11
#define LAW_SIZE_512K		0x12
#define LAW_SIZE_1M		0x13
#define LAW_SIZE_2M		0x14
#define LAW_SIZE_4M		0x15
#define LAW_SIZE_8M		0x16
#define LAW_SIZE_16M		0x17
#define LAW_SIZE_32M		0x18
#define LAW_SIZE_64M		0x19
#define LAW_SIZE_128M		0x1A
#define LAW_SIZE_256M		0x1B
#define LAW_SIZE_512M		0x1C
#define LAW_SIZE_1G		0x1D
#define LAW_SIZE_2G		0x1E



//---------------------------------------------------------------------------
// LocalBus Base and Attribute Registers

#define BR0			0x05000
#define BR1			0x05008
#define BR2			0x05010
#define BR3			0x05018
#define BR4			0x05020
#define BR5			0x05028
#define BR6			0x05030
#define BR7			0x05038

#define BR_PS_8BIT		0x0800
#define BR_PS_16BIT		0x1000
#define BR_PS_32BIT		0x1800
#define BR_DECC_NONE		0x0000
#define BR_DECC_PARITY		0x0200
#define BR_DECC_RMW		0x0400
#define BR_WP			0x0100
#define BR_MSEL_GPCM		0x0000
#define BR_MSEL_SDRAM		0x0060
#define BR_MSEL_UPMA		0x0080
#define BR_MSEL_UPMB		0x00A0
#define BR_MSEL_UPMC		0x00C0
#define BR_ATOM_NO		0x0000
#define BR_ATOM_RAWA		0x0004
#define BR_ATOM_WARA		0x0008
#define BR_V			0x0001

#define OR0			0x05004
#define OR1			0x0500C
#define OR2			0x05014
#define OR3			0x0501C
#define OR4			0x05024
#define OR5			0x0502C
#define OR6			0x05034
#define OR7			0x0503C
#define LBCR			0x050D0

#define LCRR			0x050D4
#define LCRR_DBYP		0x8000
#define LCRR_ECL_4		0x0000
#define LCRR_EADC_4		0x0000
#define LCRR_EADC_1		0x0001
#define LCRR_EADC_2		0x0002
#define LCRR_EADC_3		0x0003
#define LCRR_CLKDIV_2		0x0002
#define LCRR_CLKDIV_4		0x0004
#define LCRR_CLKDIV_8		0x0008


//---------------------------------------------------------------------------
// DDR -- DDR definitions


#define DDR_CS0_BNDS		0x2000
#define DDR_CS1_BNDS		0x2008
#define DDR_CS2_BNDS		0x2010
#define DDR_CS3_BNDS		0x2018

//----
#define DDR_CS0_CONFIG					0x2080
#define DDR_CS1_CONFIG					0x2084
#define DDR_CS2_CONFIG					0x2088
#define DDR_CS3_CONFIG					0x208C

#define DDR_CSx_CONFIG_CS_x_EN				0x8000
#define DDR_CSx_CONFIG_AP_x_EN				0x0080
#define DDR_CSx_CONFIG_ROW_BITS_CS_12		0x0000
#define DDR_CSx_CONFIG_ROW_BITS_CS_13		0x0100
#define DDR_CSx_CONFIG_ROW_BITS_CS_14		0x0200
#define DDR_CSx_CONFIG_COL_BITS_CS_8 		0x0000
#define DDR_CSx_CONFIG_COL_BITS_CS_9 		0x0001
#define DDR_CSx_CONFIG_COL_BITS_CS_10 		0x0002
#define DDR_CSx_CONFIG_COL_BITS_CS_11 		0x0003


//----
#define DDR_TIMING_CFG_1				0x2108
#define DDR_TIMING_CFG_1_PRETOACT(v)		((v) << 12)
#define DDR_TIMING_CFG_1_ACTTOPRE(v)		((v) << 8)
#define DDR_TIMING_CFG_1_ACTTORW(v)			((v) << 4)
#define DDR_TIMING_CFG_1_CL_1				0x0001
#define DDR_TIMING_CFG_1_CL_1_5				0x0002
#define DDR_TIMING_CFG_1_CL_2				0x0003
#define DDR_TIMING_CFG_1_CL_2_5				0x0004
#define DDR_TIMING_CFG_1_CL_3				0x0005
#define DDR_TIMING_CFG_1_CL_3_5				0x0006
#define DDR_TIMING_CFG_1_CL_4				0x0007
#define DDR_TIMING_CFG_1_REFREC(v)			(((v-8) & 0xf) << 12)
#define DDR_TIMING_CFG_1_WRREC(v)			((v) << 8)
#define DDR_TIMING_CFG_1_ACTTOACT(v)		((v) << 4)
#define DDR_TIMING_CFG_1_WRTORD(v)			(v)


//----
#define DDR_TIMING_CFG_2				0x210C
#define DDR_TIMING_CFG_2_WR_DATA_DELAY(v)	(((v) >> 1) << 8)

#ifdef MAP

//----
#define DDR_SDRAM_MODE			0x2118

#define DDR_SDRAM_MODE_CL_2		0x0020
#define DDR_SDRAM_MODE_CL_2		0x0020
#ifdef DDR_CL_2
	li	r4,0x0020		//   CL=2
#endif
#ifdef DDR_CL_2_5
	li	r4,0x0060		//   CL=2.5
#endif
#ifdef DDR_32BIT_BUS
	ori	r4,r4,0x0003		//   8-BEAT BURST (32-bit)
#else
	ori	r4,r4,0x0002		//   4-BEAT BURST (32-bit)
#endif
	stw	r4,0(r3)

//-------------------------------
// DDR_SDRAM_INTERVAL

#define DDR_SDRAM_INTERVAL			0x2124
	addi	r3,r20,0x2124
	lis	r4,0x04D0		// Refresh interval
//	ori	r4,r4,0x04D0		// Open page interval
	stw	r4,0(r3)


//-------------------------------
// DEBUG
//
	addi	r3,r20,0x2F04		// DEBUG_2
	lis	r4,0x2000		// 8060
	ori	r4,r4,0x0000
	stw	r4,0(r3)

	addi	r3,r20,0x2F00		// DEBUG_1
	lis	r4,0xFF01
	ori	r4,r4,0x0000
	stw	r4,0(r3)

	addi	r3,r20,0x2F0C		// DEBUG_4
	lis	r4,0x0000
	ori	r4,r4,0x0000
	stw	r4,0(r3)

#endif

//----
#define DDR_SDRAM_CFG			0x2110

#define DDR_SDRAM_CFG_MEM_EN			0x8000
#define DDR_SDRAM_CFG_SREN			0x4000
#define DDR_SDRAM_CFG_ECC_EN			0x2000
#define DDR_SDRAM_CFG_RD_EN			0x1000
#define DDR_SDRAM_CFG_DDR_SDRAM			0x0200
#define DDR_SDRAM_CFG_DYN_POWER			0x0020
#define DDR_SDRAM_CFG_MEM_32BIT			0x000C


//---------------------------------------------------------------------------
// PCI -- PCI definitions

#define PCI_POTAR		0x8C00
#define PCI_POTAR1		0x8C20
#define PCI_POTAR2		0x8C40
#define PCI_POTAR3		0x8C60
#define PCI_POTAR4		0x8C80

#define PCI_POTEAR		0x8C04
#define PCI_POTEAR1		0x8C24
#define PCI_POTEAR2		0x8C44
#define PCI_POTEAR3		0x8C64
#define PCI_POTEAR4		0x8C84

#define PCI_POWBAR		0x8C08
#define PCI_POWBAR1		0x8C28
#define PCI_POWBAR2		0x8C48
#define PCI_POWBAR3		0x8C68
#define PCI_POWBAR4		0x8C88

#define PCI_POWAR		0x8C10
#define PCI_POWAR1		0x8C30
#define PCI_POWAR2		0x8C50
#define PCI_POWAR3		0x8C70
#define PCI_POWAR4		0x8C90


#define PCI_POWAR_EN		0x8000

#define PCI_POWAR_S_D		0x4000

#define PCI_POWAR_RTT_MEMR	0x0004
#define PCI_POWAR_RTT_IOR	0x0008

#define PCI_POWAR_WTT_MEMW	0x4000
#define PCI_POWAR_WTT_IOW	0x8000

#define PCI_POWAR_OWS_4K	0x0B
#define PCI_POWAR_OWS_8K	0x0C
#define PCI_POWAR_OWS_16K	0x0D
#define PCI_POWAR_OWS_32K	0x0E
#define PCI_POWAR_OWS_64K	0x0F
#define PCI_POWAR_OWS_128K	0x10
#define PCI_POWAR_OWS_256K	0x11
#define PCI_POWAR_OWS_512K	0x12
#define PCI_POWAR_OWS_1M	0x13
#define PCI_POWAR_OWS_2M	0x14
#define PCI_POWAR_OWS_4M	0x15
#define PCI_POWAR_OWS_8M	0x16
#define PCI_POWAR_OWS_16M	0x17
#define PCI_POWAR_OWS_32M	0x18
#define PCI_POWAR_OWS_64M	0x19
#define PCI_POWAR_OWS_128M	0x1A
#define PCI_POWAR_OWS_256M	0x1B
#define PCI_POWAR_OWS_512M	0x1C
#define PCI_POWAR_OWS_1G	0x1D
#define PCI_POWAR_OWS_2G	0x1E
#define PCI_POWAR_OWS_4G	0x1F


//---------------------------------------------------------------------------
// Global Utility Registers

#define POWIMPSCR		0xE0008

