;*******************************************************************************************
;       MAIN.ASM
;*******************************************************************************************
; Copyright (c) 2007 Nacuri 
; http://www.nacuri.com/
;*******************************************************************************************
;
; Single Phase Demo for DEMO9RS08KA2
; ---------------------------------------------------------------------------------
; This example controls a single phase motor through a PWM.
; The PWM is generated with the comparator (to detect zero crossing) 
; and the timer to generate duty cycle
;
; ACMP - is fed with a value approximate to 0
; ACMP + rectified wave
; PTA4 PWM output to feed the MOC, also connected to a LED to show the speed
; through LED's;intensity
; PTA5 push button to vary the speed
; RESET/PTA2 turns off the motor
;;
; ********* If you want the button to run free the comment values, button to comment
; ********* set cyc_per_check_b to the value wanted
; ********* notice that cyc_per_check_b also avoids bouncing.
; ********* understand RUN FREE as the button is checked every
; ********* cyc_per_check_b * 8.4 ms (120 ;hz) that is, if kept pressed it
; ********* changes duty or press and release the button in
; ********* order to change duty values
; ***************************************************************************

; export symbols
             XDEF _Startup, main
            ; we export both '_Startup' and 'main' as symbols. Either can
            ; be referenced in the linker .prm file or from C/C++ later on

; Include derivative-specific definitions
            INCLUDE 'derivative.inc'

D_X             equ   $0000000E
X_              equ   $0000000F  
CLKST           EQU   2
PTA4            EQU   4
PTA5            EQU   5
ACF             EQU   5
ACME            EQU   7
TOF             EQU   7
TSTP            EQU   4
BUTTON_PRESSED  EQU   0                              ;line for button pressed
; Variable/Data Section
MY_ZEROPAGE: SECTION  SHORT
speed_count:    DS.B  1                              ; this is a pointer to select which value is used in line_speed array
button_control  DS.B  1                              ; flag for button 
duty_cycle:     DS.B  1                              ; this value is how long (timer) will value stays up/down
cpcb_count      DS.B  1                              ; cycles to check button counter                                                    ; number of cycles it will wait to check the button again                                                    
; Const Section
ConstSection:  SECTION                               
cyc_per_check_b DC.B  $09                            ; number of counts (wave cycles) it takes to read button
size_speed      DC.B  $07                            ; number of elements in line speed array
line_speed      DC.B  $01,$20,$40,$80,$C0,$E0,$F0    ; if you change size of linespeed do not forget to modify Project.map
;line_speed      DC.B  $F0,$E0,$C0,$80,$40,$20,$01    ; if you change size of linespeed do not forget to modify Project.map
; Code Section
MyCode:     SECTION
;*******************************************************************************************
; Peripheral Initialization
;*******************************************************************************************
init:           

;CONFIGURES SYSTEM CONTROL
  MODE:         EQU 0                  ; MODE=0 Background Mode, MODE=1 Run Mode
  IFNE  MODE
    mov #HIGH_6_13(SOPT), PAGESEL  
    mov #$01, MAP_ADDR_6(SOPT)         ; Disables COP and enables RESET (PTA2) pin
  ELSE 
    mov #HIGH_6_13(SOPT), PAGESEL
    mov #$03, MAP_ADDR_6(SOPT)         ; Disables COP and enables BKGD (PTA3) and RESET (PTA2) pins
  ENDIF
                                                                                                 
;CONFIGURES CLOCK (FEI Operation Mode)         
    mov #HIGH_6_13(NV_ICSTRM),PAGESEL  
    lda MAP_ADDR_6(NV_ICSTRM)         
	  sta ICSTRM										     ; Sets trimming value
	  clr ICSC1                          ; Selects FLL as clock source and disables it in stop mode
	  clr ICSC2                          ; ICSOUT = DCO output frequency
wait_clock:
    brset CLKST,ICSSC,wait_clock       ; Waits until FLL is engaged
    
;CONFIGURES TIMER
    mov #$70, MTIMSC                   ; Enables interrupt, stops and resets timer counter
    mov #$08, MTIMCLK                  ; Selects fBUS as reference clock (8 MHz)
                                       ; prescaler = 256 (increments timer counter every  32 us) 
                                          
;CONFIGURES ACMP
    mov #$B0, ACMPSC                   ; Comparator Enabled, ACMP+ as external reference
                                       ; clear flag and enable interrupt,output disabled
                                       ; Comparator Falling Edge
;CONFIGURES PORT
    bset PTA4, PTADD                   ; set port A4  as output
    bclr PTA5,PTADD                    ; sets port A5 as input
    bclr PTA4, PTAD                    ; clears pint PTAD4
    
    rts

;*******************************************************************************************
; Entry Point
;*******************************************************************************************

_Startup:
main:
    bsr init
    mov #0, speed_count                ; this is a pointer to the main speed we want, first we set it to 0
    mov #0, duty_cycle                 ; this is a parameter for the timer to tell when it will stop counting 
    mov #0, cpcb_count                 ; reset cycles count for button check 
loop1:
    bset ACME,ACMPSC                   ; activates Analog Comparator 
check_cmp:
    ;wait                              ; sends controller to wait state    
    brclr ACF,ACMPSC,check_cmp         ; waits until there is a comparator event
    bclr ACME,ACMPSC                   ; deactivate comparator
    bset ACF,ACMPSC                    ; clear comparator flag      
    mov duty_cycle,MTIMMOD             ; set Modulo to max count, also reset counter and clears timer flag
    bclr PTA4, PTAD
    bclr TSTP,MTIMSC                   ; start timer   
    bsr check_button   
check_timer:                            
    ;wait                              ; sends controller to wait state 
    brclr 7,MTIMSC,check_timer         ; waits until there is a timer overflow
    bset TSTP,MTIMSC                   ; stop timer    
    bclr TOF,MTIMSC                    ; clears timer overflow flag    
    lda #$00                           ; tu turn it off completly if we point to the minimun speed
    cmp speed_count
    beq  end_main
    bset  PTA4, PTAD    
end_main:    
    jmp loop1
    
                      
check_button:
    brclr PTA5,PTAD,chb_cont           ; if button pressed then goes to check_button         
    mov #$00,cpcb_count                ; if realease button, reset counter for 
    bclr BUTTON_PRESSED,button_control ; bit 0 as flag for button already pressed
    jmp button_return                  ;  
chb_cont:
 ; check counter to wait to check button
    brset BUTTON_PRESSED,button_control,button_return ; BUTTON TO COMMENT 
                                        ;if button has not been released returns from subrutine   
    inc cpcb_count                     ; increments counter for push button
    lda cpcb_count                     ; compares cpcb_count value with defined constant value 
    mov #HIGH_6_13(cyc_per_check_b), PAGESEL
    cmp MAP_ADDR_6(cyc_per_check_b)    
    bhs chb_cont2                      ; if value is reached jumps chb_count2, else returns and continues counting
    jmp button_return
chb_cont2:
    bset BUTTON_PRESSED,button_control ; set it to mark button as already pressed
    mov #$00,cpcb_count                ; resets counter since the button has been pressed long enough
    inc speed_count                    ; increments pointer, (this value is used with X) 
    lda speed_count                    ; compares pointer value with array size
    mov #HIGH_6_13(size_speed), PAGESEL
    cmp MAP_ADDR_6(size_speed)    
    blo set_duty
    mov #0,speed_count                 ; if pointer > array size then reset 0
set_duty:    
    mov #HIGH_6_13(line_speed), PAGESEL;load duty value into duty_cycle variable
    lda #MAP_ADDR_6(line_speed)
    add speed_count
    sta X_
    mov D_X,duty_cycle
button_return:
    rts
    