/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : PWM1.C
**     Project   : PWM_Lab
**     Processor : MCF51QE128LQFP64
**     Beantype  : PWM
**     Version   : Bean 02.164, Driver 01.13, CPU db: 3.00.002
**     Compiler  : CodeWarrior ColdFireV1 C Compiler
**     Date/Time : 14/5/2007, 15:10
**     Abstract  :
**         This bean implements a pulse-width modulation generator
**         that generates signal with variable duty and fixed cycle. 
**     Settings  :
**         Used output pin             : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       26            |  PTC0_RGPIO8_TPM3CH0
**             ----------------------------------------------------
**
**         Timer name                  : TPM3 [16-bit]
**         Counter                     : TPM3CNT   [0xFFFF8061]
**         Mode register               : TPM3SC    [0xFFFF8060]
**         Run register                : TPM3SC    [0xFFFF8060]
**         Prescaler                   : TPM3SC    [0xFFFF8060]
**         Compare register            : TPM3C0V   [0xFFFF8066]
**         Flip-flop register          : TPM3C0SC  [0xFFFF8065]
**
**         Priority                    : 110
**         User handling procedure     : PWM1_OnEnd
**         This event is called when the 1 of cycles is generated
**
**         Port name                   : PTC
**         Bit number (in port)        : 0
**         Bit mask of the port        : 0x0001
**         Port data register          : PTCD      [0xFFFF8004]
**         Port control register       : PTCDD     [0xFFFF8005]
**
**         Initialization:
**              Output level           : low
**              Timer                  : Enabled
**              Event                  : Enabled
**         High speed mode
**             Prescaler               : divide-by-8
**             Clock                   : 3735552 Hz
**           Initial value of            period     pulse width
**             Xtal ticks              : 328        164
**             microseconds            : 10000      5000
**             milliseconds            : 10         5
**             seconds (real)          : 0.0100001  0.0050001
**
**     Contents  :
**         SetRatio16 - byte PWM1_SetRatio16(word Ratio);
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2006
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/


/* MODULE PWM1. */

#include "Events.h"
#include "PE_Error.h"
#include "PWM1.h"


static word RatioStore;                /* Ratio of L-level to H-level */

/* Internal method prototypes */

/*
** ===================================================================
**     Method      :  SetRatio (bean PWM)
**
**     Description :
**         The method stores duty value to compare register(s) and sets 
**         necessary bits or (in List mode) call SetReg method for duty 
**         value storing.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetRatio(void);

/* End of Internal methods declarations */

/*
** ===================================================================
**     Method      :  SetRatio (bean PWM)
**
**     Description :
**         The method stores duty value to compare register(s) and sets 
**         necessary bits or (in List mode) call SetReg method for duty 
**         value storing.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetRatio(void)
{
  if(RatioStore == 0xFFFF) {           /* Duty = 100%? */
    TPM3C0V = 0xFFFF;                  /* Store new value to the compare reg. */
  } else {
    TPM3C0V = (word)(((dword)0x91EB * (dword)RatioStore) >> 0x10); /* Calculate new compare value according to the given ratio */
  }
}

/*
** ===================================================================
**     Method      :  PWM1_SetRatio16 (bean PWM)
**
**     Description :
**         This method sets a new duty-cycle ratio.
**     Parameters  :
**         NAME       - DESCRIPTION
**         Ratio      - Ratio is expressed as an 16-bit unsigned integer
**                      number. 0 - 0xFFFF value is proportional
**                      to ratio 0 - 100%
**         Note: Calculated duty depends on the timer possibilities
**               and on the selected period.
**     Returns     :
**         ---        - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte PWM1_SetRatio16(word Ratio)
{
  RatioStore = Ratio;                  /* Store new value of the ratio */
  SetRatio();                          /* Calculate and set up new appropriate values of the compare and modulo registers */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  PWM1_Init (bean PWM)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PWM1_Init(void)
{
  /* TPM3SC: TOF=0,TOIE=0,CPWMS=0,CLKSB=0,CLKSA=0,PS2=0,PS1=0,PS0=0 */
  setReg8(TPM3SC, 0x00);               /* Disable device */ 
  /* TPM3C0SC: CH0F=0,CH0IE=0,MS0B=1,MS0A=1,ELS0B=1,ELS0A=1,??=0,??=0 */
  setReg8(TPM3C0SC, 0x3C);             /* Set up PWM mode with output signal level low */ 
  RatioStore = 0x8000;                 /* Store initial value of the ratio */
  /* TPM3MOD: BIT15=1,BIT14=0,BIT13=0,BIT12=1,BIT11=0,BIT10=0,BIT9=0,BIT8=1,BIT7=1,BIT6=1,BIT5=1,BIT4=0,BIT3=1,BIT2=0,BIT1=1,BIT0=1 */
  setReg16(TPM3MOD, 0x91EB);           /* Set modulo register */ 
  /* TPM3C0SC: CH0F=0,CH0IE=0,MS0B=1,MS0A=1,ELS0B=1,ELS0A=1,??=0,??=0 */
  setReg8(TPM3C0SC, 0x3C);             /* Set up PWM mode with output signal level low */ 
  SetRatio();                          /* Calculate and set up new values of the compare according to the selected speed CPU mode */
  /* TPM3SC: TOF=0,TOIE=1,CPWMS=0,CLKSB=0,CLKSA=1,PS2=0,PS1=1,PS0=1 */
  setReg8(TPM3SC, 0x4B);               /* Run the counter (set CLKSB:CLKSA) */ 
}


/*
** ===================================================================
**     Method      :  PWM1_Interrupt (bean PWM)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
ISR(PWM1_Interrupt)
{
  (void)getReg8(TPM3SC);               /* Dummy read of the TPM3SC register to reset flag */
  /* TPM3SC: TOF=0 */
  clrReg8Bits(TPM3SC, 0x80);           /*  Reset interrupt request flag */ 
  PWM1_OnEnd();                        /* Invoke user event */
}


/* END PWM1. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 3.00 [03.89]
**     for the Freescale ColdFireV1 series of microcontrollers.
**
** ###################################################################
*/
