/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : Cpu.C
**     Project   : PWM_Lab
**     Processor : MC9S08QE128CLK
**     Beantype  : MC9S08QE128_80
**     Version   : Bean 01.001, Driver 01.27, CPU db: 3.00.000
**     Datasheet : MC9S08QE128RM Rev. 1.0 Draft F
**     Compiler  : CodeWarrior HCS08 C Compiler
**     Date/Time : 14/5/2007, 15:14
**     Abstract  :
**         This bean "MC9S08QE128_80" contains initialization of the
**         CPU and provides basic methods and events for CPU core
**         settings.
**     Settings  :
**
**     Contents  :
**         EnableInt  - void Cpu_EnableInt(void);
**         DisableInt - void Cpu_DisableInt(void);
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2006
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

/* MODULE Cpu. */

#pragma MESSAGE DISABLE C4002 /* WARNING C4002: Result not used is ignored */

#include "PWM1.h"
#include "AD1.h"
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Events.h"
#include "Cpu.h"


/* Global variables */
volatile byte CCR_reg;                 /* Current CCR register */


/*
** ===================================================================
**     Method      :  Cpu_Interrupt (bean MC9S08QE128_80)
**
**     Description :
**         The method services unhandled interrupt vectors.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
ISR(Cpu_Interrupt)
{
}



/*
** ===================================================================
**     Method      :  Cpu_DisableInt (bean MC9S08QE128_80)
**
**     Description :
**         Disables maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_DisableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_EnableInt (bean MC9S08QE128_80)
**
**     Description :
**         Enables maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_EnableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  _EntryPoint (bean MC9S08QE128_80)
**
**     Description :
**         Initializes the whole system like timing and so on. At the end 
**         of this function, the C startup is invoked to initialize stack,
**         memory areas and so on.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
extern void _Startup(void);            /* Forward declaration of external startup function declared in file Start12.c */

#pragma NO_FRAME
#pragma NO_EXIT
void _EntryPoint(void)
{
  /* ### MC9S08QE128_80 "Cpu" init code ... */
  /*  PE initialization code after reset */
  /* Common initialization of the write once registers */
  /* SOPT1: COPE=0,COPT=1,STOPE=0,??=0,??=0,RSTOPE=0,BKGDPE=1,RSTPE=0 */
  setReg8(SOPT1, 0x42);                 
  /* SPMSC1: LVDF=0,LVDACK=0,LVDIE=0,LVDRE=1,LVDSE=1,LVDE=1,??=0,BGBE=1 */
  setReg8(SPMSC1, 0x1D);                
  /* SPMSC2: LPR=0,LPRS=0,LPWUI=0,??=0,PPDF=0,PPDACK=0,PPDE=1,PPDC=0 */
  setReg8(SPMSC2, 0x02);                
  /* SPMSC3: LVDV=0,LVWV=0,LVWIE=0 */
  clrReg8Bits(SPMSC3, 0x38);            
  /*  System clock initialization */
  /* ICSC1: CLKS=0,RDIV=0,IREFS=1,IRCLKEN=1,IREFSTEN=0 */
  setReg8(ICSC1, 0x06);                /* Initialization of the ICS control register 1 */ 
  /* ICSC2: BDIV=1,RANGE=0,HGO=0,LP=0,EREFS=0,ERCLKEN=0,EREFSTEN=0 */
  setReg8(ICSC2, 0x40);                /* Initialization of the ICS control register 2 */ 
  while(!ICSSC_IREFST) {               /* Wait until the source of reference clock is internal clock */
  }
  /* ICSSC: DRST_DRS=0,DMX32=0 */
  clrReg8Bits(ICSSC, 0xE0);            /* Initialization of the ICS status and control */ 
  while((ICSSC & 0xC4) != 0x00) {      /* Wait until the FLL switches to Low range DCO mode */
  }
  /*** End of PE initialization code after reset ***/

  __asm   jmp _Startup ;               /* Jump to C startup code */

}

/*
** ===================================================================
**     Method      :  PE_low_level_init (bean MC9S08QE128_80)
**
**     Description :
**         Initializes beans and provides common register initialization. 
**         The method is called automatically as a part of the 
**         application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PE_low_level_init(void)
{
  /* Common initialization of the CPU registers */
  /* PTCDD: PTCDD0=1 */
  setReg8Bits(PTCDD, 0x01);             
  /* PTCD: PTCD0=0 */
  clrReg8Bits(PTCD, 0x01);              
  /* APCTL1: ADPC0=1 */
  setReg8Bits(APCTL1, 0x01);            
  /* PTASE: PTASE7=1,PTASE6=1,PTASE4=1,PTASE3=1,PTASE2=1,PTASE1=1,PTASE0=1 */
  setReg8Bits(PTASE, 0xDF);             
  /* PTBSE: PTBSE7=1,PTBSE6=1,PTBSE5=1,PTBSE4=1,PTBSE3=1,PTBSE2=1,PTBSE1=1,PTBSE0=1 */
  setReg8(PTBSE, 0xFF);                 
  /* PTCSE: PTCSE7=1,PTCSE6=1,PTCSE5=1,PTCSE4=1,PTCSE3=1,PTCSE2=1,PTCSE1=1,PTCSE0=1 */
  setReg8(PTCSE, 0xFF);                 
  /* PTDSE: PTDSE7=1,PTDSE6=1,PTDSE5=1,PTDSE4=1,PTDSE3=1,PTDSE2=1,PTDSE1=1,PTDSE0=1 */
  setReg8(PTDSE, 0xFF);                 
  /* PTESE: PTESE7=1,PTESE6=1,PTESE5=1,PTESE4=1,PTESE3=1,PTESE2=1,PTESE1=1,PTESE0=1 */
  setReg8(PTESE, 0xFF);                 
  /* PTFSE: PTFSE7=1,PTFSE6=1,PTFSE5=1,PTFSE4=1,PTFSE3=1,PTFSE2=1,PTFSE1=1,PTFSE0=1 */
  setReg8(PTFSE, 0xFF);                 
  /* PTGSE: PTGSE7=1,PTGSE6=1,PTGSE5=1,PTGSE4=1,PTGSE3=1,PTGSE2=1,PTGSE1=1,PTGSE0=1 */
  setReg8(PTGSE, 0xFF);                 
  /* PTHSE: PTHSE7=1,PTHSE6=1,PTHSE5=1,PTHSE4=1,PTHSE3=1,PTHSE2=1,PTHSE1=1,PTHSE0=1 */
  setReg8(PTHSE, 0xFF);                 
  /* PTJSE: PTJSE7=1,PTJSE6=1,PTJSE5=1,PTJSE4=1,PTJSE3=1,PTJSE2=1,PTJSE1=1,PTJSE0=1 */
  setReg8(PTJSE, 0xFF);                 
  /* PTADS: PTADS7=0,PTADS6=0,PTADS5=0,PTADS4=0,PTADS3=0,PTADS2=0,PTADS1=0,PTADS0=0 */
  setReg8(PTADS, 0x00);                 
  /* PTBDS: PTBDS7=0,PTBDS6=0,PTBDS5=0,PTBDS4=0,PTBDS3=0,PTBDS2=0,PTBDS1=0,PTBDS0=0 */
  setReg8(PTBDS, 0x00);                 
  /* PTCDS: PTCDS7=0,PTCDS6=0,PTCDS5=0,PTCDS4=0,PTCDS3=0,PTCDS2=0,PTCDS1=0,PTCDS0=0 */
  setReg8(PTCDS, 0x00);                 
  /* PTDDS: PTDDS7=0,PTDDS6=0,PTDDS5=0,PTDDS4=0,PTDDS3=0,PTDDS2=0,PTDDS1=0,PTDDS0=0 */
  setReg8(PTDDS, 0x00);                 
  /* PTEDS: PTEDS7=0,PTEDS6=0,PTEDS5=0,PTEDS4=0,PTEDS3=0,PTEDS2=0,PTEDS1=0,PTEDS0=0 */
  setReg8(PTEDS, 0x00);                 
  /* PTFDS: PTFDS7=0,PTFDS6=0,PTFDS5=0,PTFDS4=0,PTFDS3=0,PTFDS2=0,PTFDS1=0,PTFDS0=0 */
  setReg8(PTFDS, 0x00);                 
  /* PTGDS: PTGDS7=0,PTGDS6=0,PTGDS5=0,PTGDS4=0,PTGDS3=0,PTGDS2=0,PTGDS1=0,PTGDS0=0 */
  setReg8(PTGDS, 0x00);                 
  /* PTHDS: PTHDS7=0,PTHDS6=0,PTHDS5=0,PTHDS4=0,PTHDS3=0,PTHDS2=0,PTHDS1=0,PTHDS0=0 */
  setReg8(PTHDS, 0x00);                 
  /* PTJDS: PTJDS7=0,PTJDS6=0,PTJDS5=0,PTJDS4=0,PTJDS3=0,PTJDS2=0,PTJDS1=0,PTJDS0=0 */
  setReg8(PTJDS, 0x00);                 
  /* SCGC1: TPM3=1,TPM2=1,TPM1=1,ADC=1,IIC2=1,IIC1=1,SCI2=1,SCI1=1 */
  setReg8(SCGC1, 0xFF);                 
  /* SCGC2: DBG=1,FLS=1,IRQ=1,KBI=1,ACMP=1,RTC=1,SPI2=1,SPI1=1 */
  setReg8(SCGC2, 0xFF);                 
  /* ### Shared modules init code ... */
  /* ### Programable pulse generation "PWM1" init code ... */
  PWM1_Init();
  /* ###  "AD1" init code ... */
  AD1_Init();
  __EI();                              /* Enable interrupts */
}

/* Initialization of the CPU registers in FLASH */

/* NVPROT: FPS6=1,FPS5=1,FPS4=1,FPS3=1,FPS2=1,FPS1=1,FPS0=1,FPOPEN=1 */
const unsigned char NVPROT_INIT @0x0000FFBD = 0xFF;

/* NVOPT: KEYEN1=0,KEYEN0=1,??=1,??=1,??=1,??=1,SEC1=1,SEC0=0 */
const unsigned char NVOPT_INIT @0x0000FFBF = 0x7E;

/* END Cpu. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 3.00 [03.89]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
