#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

/* Delay time needed in S08s for a software delay of 500ms */
#define dt500ms 0xF060

#define LED0    PTCD_PTCD0
#define LED1    PTCD_PTCD1
#define LED0DD  PTCDD_PTCDD0
#define LED1DD  PTCDD_PTCDD1

unsigned char delayflag;

void SoftwareDelay(unsigned int);
void HWDelay(void);

void main(void) {

  ICSTRM = NVICSTRM;
  LED0DD = 1;
  LED1DD = 1;
  
  /* Enable RTI interrupt Set Cl */
  RTCSC = RTCSC_RTIE_MASK | RTCSC_RTCPS1_MASK | RTCSC_RTCPS2_MASK | RTCSC_RTCPS3_MASK;
  /* Interrupt Every 1/2 Second */
  RTCMOD = 0;
  
  EnableInterrupts; /* enable interrupts */
  /* include your code here */

  for(;;) 
  {
    SoftwareDelay(dt500ms);
    __RESET_WATCHDOG(); /* feeds the dog */
    LED0 = ~LED0;
  } /* loop forever */
  /* please make sure that you never leave main */
}


void SoftwareDelay(unsigned int delaytime)
{
  while(delaytime--)
  {
    __RESET_WATCHDOG(); /* feeds the dog */
  }
  
}

interrupt VectorNumber_Vrtc void RTI_ISR(void)
{
  delayflag=0;
  RTCSC_RTIF = 1;
  LED1 = ~LED1;
}


  

