/******************************************************************************
 Copyright  1995-2003 Freescale Semiconductor Inc.
 All Rights Reserved

 This is unpublished proprietary source code of Freescale Semiconductor Inc.
 The copyright notice above does not evidence any actual or intended
 publication of such source code.
 ******************************************************************************/

#include "smartdsp_os_.h"
#include "os_init.h"

#include "os_config.h"
#include "app_config.h"
#include "msc814x_memmap.h"
#include "msc814x_dma.h"
#include "msc814x_init.h"
#include "msc814x_dma_init.h"
#include "msc814x_uec_init.h"
#include "msc814x_hwi.h"

platform_init_params_t platform_params =
{
	FALSE, /* Automatic Branch Target Buffer Flush */
	TRUE,  /* Enable Query Mechanism*/
	TRUE,  /* Capture Violation Address Enable */
	TRUE,  /* Data Non-aligned Memory Exception Enable */
	TRUE,  /* Write to Same Memory Byte Exception Enable*/
	TRUE,  /* Debug and Profiling Unit Enable */
	TRUE,  /* Memory Protection Enable */
	TRUE,  /* Address Translation Enable */
	TRUE,  /* Error Detection Code Exception Enable*/
};


#if (MSC814X_DMA == ON)

msc814x_dma_config_t msc814x_dma_config =
{
    GROUP_RR_ARBIRTATION,       /**< Either EDF or group RR */
    EDF_CLK_SRC_DMA_CLK_DIV_16, /**< Reference clock for EDF counter */
    0xFFFF,                     /**< Reference clock for EDF divider. */
    NULL,                       /**< Callback for DMA bus error. */
    NULL,	                    /**< Callback for DMA parity error. */
    NULL,	                    /**< Callback for DMA EDF violation. */
    NULL, 	                    /**< Callback for DMA BD size violation. */
    {
    	CORE0_ID, CORE1_ID, CORE2_ID, CORE3_ID,
		CORE0_ID, CORE1_ID, CORE2_ID, CORE3_ID,
		CORE0_ID, CORE1_ID, CORE2_ID, CORE3_ID,
		CORE0_ID, CORE1_ID, CORE2_ID, CORE3_ID
    }
};

#endif // MSC814X_DMA


#if (MSC814X_UEC0 == ON)

/* Note: if file_by_mac_address is set to FALSE, it is necessary to supply a filters array */

msc814x_uec_init_params_t msc814x_uec_init_params_0 =
{
    UEC_ID0,					/* UEC ID. */
    0xFEE02000,					/* Base address of UEC memory map. */
    UEC_IF_RGMII,					/* Ethernet physical interface type. */
#ifdef INTERNAL_LOOPBACK
	(UEC_DEF_FLAGS | UEC_CFG_LOOPBACK | UEC_CFG_ENABLE_STATISTICS | UEC_CFG_ENABLE_ADDITIONAL_STATISTICS),				/* UEC Configuration flags (UEC_CFG_...). */
#else
	(UEC_DEF_FLAGS | UEC_CFG_ENABLE_STATISTICS | UEC_CFG_ENABLE_ADDITIONAL_STATISTICS),				/* UEC Configuration flags (UEC_CFG_...). */
#endif
    OS_HWI_PRIORITY0,			/* IRQ Priority of UEC interrupts. */
    32,							/* Maximum Tx BD ring length. */
    16,							/* Maximum Rx BD ring length. */
    TEST_DATA_SIZE,				/* Maximum buffer length for Rx rings. */
    OS_NUM_OF_CORES*NUM_OF_CHANNELS_PER_UEC,/* Number of Tx BD rings */
    OS_NUM_OF_CORES*NUM_OF_CHANNELS_PER_UEC,/* Number of Rx BD rings */
    UEC_DEF_NUM_OF_THREADS,		/* use default number of threads according to the interface speed */
    UEC_DEF_NUM_OF_THREADS,		/* use default number of threads according to the interface speed */
    TRUE,						/* filing is done according to MAC destination address */
    NULL,						/* since file_by_mac_address is TRUE, there is no need for a filter array */
    NULL						/* Default Ethernet parameters. */
};

#endif // MSC814X_UEC0

#if (MSC814X_UEC1 == ON)

/* Note: if file_by_mac_address is set to FALSE, it is necessary to supply a filters array */

msc814x_uec_init_params_t msc814x_uec_init_params_1 =
{
    UEC_ID1,					/* UEC ID. */
    0xFEE02200,					/* Base address of UEC memory map. */
    UEC_IF_RGMII,					/* Ethernet physical interface type. */
#ifdef INTERNAL_LOOPBACK
	(UEC_DEF_FLAGS | UEC_CFG_LOOPBACK | UEC_CFG_ENABLE_STATISTICS | UEC_CFG_ENABLE_ADDITIONAL_STATISTICS),				/* UEC Configuration flags (UEC_CFG_...). */
#else
	(UEC_DEF_FLAGS  | UEC_CFG_ENABLE_STATISTICS | UEC_CFG_ENABLE_ADDITIONAL_STATISTICS),				/* UEC Configuration flags (UEC_CFG_...). */
#endif
    OS_HWI_PRIORITY0,			/* IRQ Priority of UEC interrupts. */
    32,							/* Maximum Tx BD ring length. */
    16,							/* Maximum Rx BD ring length. */
    TEST_DATA_SIZE,   			/* Maximum buffer length for Rx rings. */
    OS_NUM_OF_CORES*NUM_OF_CHANNELS_PER_UEC,/* Number of Tx BD rings */
    OS_NUM_OF_CORES*NUM_OF_CHANNELS_PER_UEC,/* Number of Rx BD rings */
    UEC_DEF_NUM_OF_THREADS,		/* use default number of threads according to the interface speed */
    UEC_DEF_NUM_OF_THREADS,		/* use default number of threads according to the interface speed */
    TRUE,						/* filing is done according to MAC destination address */
    NULL,						/* since file_by_mac_address is TRUE, there is no need for a filter array */
    NULL						/* Default Ethernet parameters. */
};

#endif // MSC814X_UEC1


