;*************************************************************************
;*                            DISCLAIMER                                 *
;* Services performed by FREESCALE in this matter are performed          *
;* AS IS and without any warranty. CUSTOMER retains the final decision   *
;* relative to the total design and functionality of the end product.    *
;* FREESCALE neither guarantees nor will be held liable by CUSTOMER      *
;* for the success of this project. FREESCALE disclaims all warranties,  *
;* express, implied or statutory including, but not limited to,          *
;* implied warranty of merchantability or fitness for a particular       *
;* purpose on any hardware, software ore advise supplied to the project  *
;* by FREESCALE, and or any product resulting from FREESCALE services.   *
;* In no event shall FREESCALE be liable for incidental or consequential *
;* damages arising out of this agreement. CUSTOMER agrees to hold        *
;* FREESCALE harmless against any and all claims demands or actions      *
;* by anyone on account of any damage, or injury, whether commercial,    *
;* contractual, or tortuous, rising directly or indirectly as a result   *
;* of the advise or assistance supplied CUSTOMER in connection with      *
;* product, services or goods supplied under this Agreement.             *
;*                                                                       *
;*************************************************************************

;*************************************************************************
;* Implementing a Low-Cost Digital Timer with a MC9RS08KA2               *
;* microcontroller.                                                      *
;*************************************************************************
;* Manuel Dvalos Rodrguez                                              *
;* Applications Engineer                                                 *
;* RTAC Americas                                                         *
;*************************************************************************


; Include derivative-specific definitions
            INCLUDE 'derivative.inc'

; export symbols

            XDEF _Startup
            ABSENTRY _Startup
                   
; variable/data section
                     
            
      ORG    RAMStart
      
;*****************************************************************************
;*                            ADC Constant                                   *
;*****************************************************************************
Table_Data EQU $3E00     

;*****************************************************************************
;*                            ADC definitions                                *
;*****************************************************************************
ACMP_ENABLE          SET   $92
ACMP_DISABLED        SET   $20
MTIM_ENABLE          SET   $40
MTIM_STOP_RESET      SET   $30
MTIM_128_DIV         SET   $07
FREE_RUN             SET   $00 

;*****************************************************************************
;*                           Time definitions                                *
;*****************************************************************************
RTIMES               SET   $F5
RTIMEM               SET   $3C
RTIMEH               SET   $3C


MAXlevel             EQU   1
MODE                 EQU   1         ; Operation Mode (1:Run Mode, 0:Background Mode)
;*****************************************************************************
;*                            ADC Variables                                  *
;*****************************************************************************
SensorReading        DS.B  1         ; Store ACMP read value
ConvertedValue       DS.B  1         ; This varible store converted value
Temp_Page            DS.B  1         ; Temporal backup Page

pcBuffer             DS.B  MAXlevel

;*****************************************************************************
;*                              Variables                                    *
;*****************************************************************************
time                 DS.B  1
timec                DS.B  1
seconds              DS.B  1
minutes              DS.B  1
hours                DS.B  1
temp                 DS.B  1
temp2                DS.B  1
counter              DS.B  1
      
      ; Insert your data definition here      


; code section

            ORG    ROMStart

;*****************************************************************************
;*                            MACRO declarations                             *
;*****************************************************************************
TRIM_ICS: MACRO                       ; Macro used to configure the ICS with TRIM
      mov   #$FF,PAGESEL              ; change to last page
      ldx   #$FA                      ; load the content which TRIM value is store
      lda   ,x                        ; read D[X]
      ;cbeqa #$FF,No_Trim              ; Omit the 0xFF value if $3FFA location content the value
      sta   ICSTRM                    ; Store TRIM value into ICSTRM register
      mov   #$00,ICSSC                ; Fine TRIM              
;No_Trim:                       
      ENDM
      
ENTRY_SUB: MACRO	              ;Macro for "stacking" SPC
	    sha
	    sta pcBuffer + 2*(\1)
	    sha
	    sla
	    sta pcBuffer + 2*(\1) +1
	    sla
      ENDM
      
      NOP                             ;needs to separate MACROS

EXIT_SUB: MACRO		              ;Macro for restore SPC
	    sha
	    lda pcBuffer + 2*(\1)
	    sha
	    sla
	    lda pcBuffer + 2*(\1) +1
	    sla
      ENDM      
      
MTIM1MS: MACRO
      mov #$70,MTIMSC
      mov #$7D,MTIMMOD
      mov #$06,MTIMCLK  
      ENDM
      
MTIM1SConfig: MACRO
      mov #$70,MTIMSC
      mov #$FE,MTIMMOD   
      mov #$07,MTIMCLK
      bclr 4,MTIMSC
      ENDM

MTIM1S: MACRO
      mov #RTIMES,seconds
MTIMIsr:
      brclr 7,MTIMSC,MTIMIsr  
      bset 5,MTIMSC         
      dbnz seconds,MTIMIsr
      brset 3,KBISC,reset
      clr temp
      bra e_
reset:
      mov #$01,temp
e_               
      ENDM     

;*****************************************************************************
;*                            Init Microcontroller                           *
;*****************************************************************************
Init_Conf: 
      IFNE  MODE
      mov #HIGH_6_13(SOPT), PAGESEL  
      mov #$20, MAP_ADDR_6(SOPT)        ; Disables COP and enables RESET (PTA2) pin                                
      ELSE 
      mov #HIGH_6_13(SOPT), PAGESEL  
      mov #$22, MAP_ADDR_6(SOPT)      ; Disables COP, enables BKGD (PTA3) and RESET (PTA2) pins                                  
      ENDIF
      clr  ICSC1                      ; FLL is selected as Bus Clock
      TRIM_ICS                        ; Trim MCU to work at 8MHz
      clr  ICSC2
      clr  temp
      rts
      
;*****************************************************************************
;*                                 Init PTA                                  *
;*****************************************************************************
Init_PTA:
      mov #HIGH_6_13(PTAPE),PAGESEL
      mov #$FE, MAP_ADDR_6(PTAPE)			; Enables internal Pulling device
       
      mov #HIGH_6_13(PTAPUD),PAGESEL
      clr MAP_ADDR_6(PTAPUD)			    ; Configures Internal pull up device in PTA 
      
      mov #$FA,PTADD 
      clr PTAD     
      rts

;*****************************************************************************
;*                                 Init KBI                                  *
;*****************************************************************************
Init_KBI:
      mov #(mKBIPE_KBIPE2),KBIPE
      mov #(mKBISC_KBIE | mKBISC_KBACK),KBISC      
      rts
      
;*****************************************************************************
;*                            ADC Receive Function                           *
;*****************************************************************************
ADC_RECEIVE:
      bra MTIM_ADC_Init                 ; Configure MITM
next:      
      bra Discharge_Cap                 ; Discharge Capacitor            
next2:      
      bra ACMP_Conf                     ; Configure ACMP+ and ACMP-
next3:      
      mov #MTIM_ENABLE,MTIMSC           ; Timer Counter Enabled
      wait                              ; Wait for ACMP interrupt
      bset 1,MTIMSC
      lda MTIMCNT                       ; read counter timer value
      sta SensorReading                 ; store counter value
      mov #HIGH_6_13(SIP1), PAGESEL     
      brset 3, MAP_ADDR_6(SIP1),ReadVal ; branch if ACMP interrupt arrives
      bra next	
ReadVal:
      MOV #MTIM_STOP_RESET,MTIMSC       ; Stop and reset counter
      MOV #ACMP_DISABLED, ACMPSC 
LookupTable:
      lda SensorReading 
      rola                              ; Getting 2 MSB
      rola 
      rola 
      and #$03                                                  
      add #(Table_Data>>6)              ; Page Calculating
      mov #PAGESEL,Temp_Page            ; Backup actual page
      sta PAGESEL                       ; Page Change
      lda SensorReading                    
      and #$3F                          ; Extract 6 LSB
      add #$C0                          ; Index to paging window
      tax                                 
      lda ,x                            ; Load table result 
      sta ConvertedValue                ; Store result
      mov #Temp_Page, PAGESEL           ; Back Page	
      rts 
MTIM_ADC_Init:
      mov #MTIM_128_DIV,MTIMCLK         ; Select bus clock as reference, Set prescaler with 64
      mov #FREE_RUN,MTIMMOD             ; Configure Timer as free running
      mov #MTIM_STOP_RESET,MTIMSC
      bra next
Discharge_Cap: 
      bset 1,PTADD                      ; Configure PTA1 as Output
      bclr 1,PTAD                       ; Start Capacitor discharging
      lda  #$FE                         ; Set delay time
waste_time:   
      dbnza waste_time                  ; wait until Delay = 0
      bra next2
ACMP_Conf: 
      MOV #ACMP_ENABLE,ACMPSC           ; ACMP Enabled, ACMP+ pin active, Interrupt enabled, Rising edges detections
      bra next3
      rts


;*****************************************************************************
;*                             Times Functions                               *
;*****************************************************************************
MINUTE:
      mov #RTIMEM,minutes
TimeIsrM:      
      lda temp
      cbeqa #$01,_en
      MTIM1S
      dbnz minutes,TimeIsrM
_en      
      rts
      
HOUR:
      mov #RTIMEH,hours      
TimeIsrH:      
      ENTRY_SUB 0
      jsr MINUTE
      EXIT_SUB 0
      lda temp
      cbeqa #$01,en_
      dbnz hours,TimeIsrH
en_      
      rts
      
;*****************************************************************************
;*                                TIME_HOURS                                 *
;*****************************************************************************
TIME_HOURS:
      lda ConvertedValue
      sub #241
      bhs One 
      lda ConvertedValue
      sub #220
      bhs Two
      lda ConvertedValue
      sub #199
      bhs Three
      lda ConvertedValue
      sub #178
      bhs Four      
      lda ConvertedValue
      sub #157
      bhs Five      
      lda ConvertedValue
      sub #136
      bhs Six      
      lda ConvertedValue
      sub #115
      bhs Seven      
      lda ConvertedValue
      sub #94
      bhs Eight      
      lda ConvertedValue
      sub #73
      bhs Nine      
      lda ConvertedValue
      sub #52
      bhs Ten      
      lda ConvertedValue
      sub #31
      bhs Eleven
      mov #12,timec
      bra _End
One:  
      mov #1,timec
      bra _End
Two:  
      mov #2,timec
      bra _End
Three:
      mov #3,timec
      bra _End
Four: 
      mov #4,timec
      bra _End
Five: 
      mov #5,timec
      bra _End
Six:  
      mov #6,timec
      bra _End
Seven:
      mov #7,timec
      bra _End
Eight:
      mov #8,timec
      bra _End
Nine: 
      mov #9,timec
      bra _End
Ten:  
      mov #10,timec
      bra _End   
Eleven: 
      mov #11,timec
_End          
      rts
     
;*****************************************************************************
;*                              TIME_MINUTES                                 *
;*****************************************************************************
TIME_MINUTES:
      lda ConvertedValue
      sub #241
      bhs One_ 
      lda ConvertedValue
      sub #220
      bhs Two_
      lda ConvertedValue
      sub #199
      bhs Three_
      lda ConvertedValue
      sub #178
      bhs Four_      
      lda ConvertedValue
      sub #157
      bhs Five_      
      lda ConvertedValue
      sub #136
      bhs Six_      
      lda ConvertedValue
      sub #115
      bhs Seven_      
      lda ConvertedValue
      sub #94
      bhs Eight_      
      lda ConvertedValue
      sub #73
      bhs Nine_      
      lda ConvertedValue
      sub #52
      bhs Ten_      
      lda ConvertedValue
      sub #31
      bhs Eleven_
      mov #60,timec
      bra End_
One_:  
      mov #5,timec
      bra End_
Two_:  
      mov #10,timec
      bra End_
Three_:
      mov #15,timec
      bra End_
Four_: 
      mov #20,timec
      bra End_
Five_: 
      mov #25,timec
      bra End_
Six_:  
      mov #30,timec
      bra End_
Seven_:
      mov #35,timec
      bra End_
Eight_:
      mov #40,timec
      bra End_
Nine_: 
      mov #45,timec
      bra End_
Ten_:  
      mov #50,timec
      bra End_   
Eleven_: 
      mov #55,timec
End_            
      rts

;*****************************************************************************
;*                            Main Program                                   *
;*****************************************************************************
_Startup:
      jsr Init_Conf
      jsr Init_PTA
      jsr Init_KBI
main:      
      mov #(mKBISC_KBACK | mKBISC_KBIE),KBISC
      clr PTAD
      jsr delay
      stop
      bset 3,PTAD
      mov #(mKBISC_KBACK | mKBISC_KBIE),KBISC
      
      jsr delay
      stop
      bset 4,PTAD
      mov #(mKBISC_KBACK | mKBISC_KBIE),KBISC
      jsr delay
      jsr ADC_RECEIVE
      jsr TIME_HOURS
      mov timec,temp
      stop
      bset 5,PTAD
      mov #(mKBISC_KBACK | mKBISC_KBIE),KBISC
      jsr delay
      jsr ADC_RECEIVE          
      jsr TIME_HOURS
      mov timec,temp2
      MTIM1SConfig                
            
loop:
      mov temp,timec     
      bclr 3,PTAD
loop1:      
      jsr HOUR
      lda temp
      cbeqa #$01,main
      dbnz timec,loop1
      
      mov temp2,timec      
      bset 3,PTAD
loop2:      
      jsr HOUR
      dbnz timec,loop2      
      bra loop
      
delay:
      mov #24,counter
      MTIM1MS
      bclr 4,MTIMSC 
        
MTIMIsr1ms:
      brclr 7,MTIMSC,MTIMIsr1ms  
      bset 5,MTIMSC         
      dbnz counter,MTIMIsr1ms 
      bset 4,MTIMSC 
      rts
         
;*****************************************************************************
;*                            Startup Vector                                 *
;*****************************************************************************
      
      ORG   $3FFD
      JMP _Startup          ; Reset
      
;*****************************************************************************
;*                            Data Table                                     *
;*****************************************************************************         
 ORG Table_Data 
 dc.b 0,5,10,14,19,23,28,32,36,40,44,48,52,56,60,63
 dc.b 67,71,74,78,81,84,87,91,94,97,100,103,106,108,111,114
 dc.b 117,119,122,124,127,129,132,134,136,139,141,143,145,147,149,151
 dc.b 153,155,157,159,161,162,164,166,168,169,171,173,174,176,177,179
 dc.b 180,182,183,184,186,187,188,190,191,192,193,194,196,197,198,199
 dc.b 200,201,202,203,204,205,206,207,208,209,210,211,211,212,213,214
 dc.b 215,215,216,217,218,218,219,220,221,221,222,222,223,224,224,225
 dc.b 226,226,227,227,228,228,229,229,230,230,231,231,232,232,233,233
 dc.b 234,234,234,235,235,236,236,236,237,237,237,238,238,238,239,239
 dc.b 239,240,240,240,241,241,241,241,242,242,242,243,243,243,243,244
 dc.b 244,244,244,244,245,245,245,245,245,246,246,246,246,246,247,247
 dc.b 247,247,247,247,248,248,248,248,248,248,249,249,249,249,249,249
 dc.b 249,249,250,250,250,250,250,250,250,250,250,251,251,251,251,251
 dc.b 251,251,251,251,251,252,252,252,252,252,252,252,252,252,252,252
 dc.b 252,252,253,253,253,253,253,253,253,253,253,253,253,253,253,253
 dc.b 253,253,253,253,254,254,254,254,254,254,254,254,254,254,254,254      