/* can.c */
/* Sending message to CAN bus using Can4Linux driver */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

#include "can.h"

/* Descriptor of CAN device */
static int can_fd = 0;

/* Opens CAN device */
int can_open() 
{
    can_fd = open(CAN_DEVICE, O_RDWR);
    if (can_fd == -1) {
	return -1;	
    }
    return 0;
}

/* Closes CAN device */
void can_close()
{
    if (can_fd>0) {
	close(can_fd);
	can_fd = 0;
    }
}

/* Reset CAN device */
void can_reset() 
{
    volatile Command_par_t cmd;
    cmd.cmd = CMD_RESET;
    ioctl(can_fd, COMMAND, cmd);    
}

/* Send the message to CAN bus */
int can_send_msg(canmsg_t* msg) 
{
    if (can_fd>0) {
	write(can_fd, msg, 1);
        return 0;
    }
    return -1;
}

/* Sets the bit rate using IOCTL call */
int can_set_bitrate(int baud) 
{
    Config_par_t cfg;
    volatile Command_par_t cmd;
    cmd.cmd = CMD_STOP;
    ioctl(can_fd, COMMAND, &cmd);
    cfg.target = CONF_TIMING;
    cfg.val1 = baud;
    ioctl(can_fd, CONFIG, &cfg);
    cmd.cmd = CMD_START;
    ioctl(can_fd, COMMAND, &cmd);
}
