/**************************************************************************
 * FILE NAME: $RCSfile: decimate_etpu_example.c,v $      COPYRIGHT (c) FREESCALE 2006 *
 * DESCRIPTION:                                     All Rights Reserved   *
 * This is the main file for the example Decimator project.               *
 *========================================================================*
 * ORIGINAL AUTHOR: Geoff Emerson (r47354)                                *
 * $Log: decimate_etpu_example.c,v $
 * Revision 1.1  2006/06/14 10:44:49  r47354
 * Initial revision.
 *
 *........................................................................*
 **************************************************************************/
#define _MAIN_
#include "decimator_project.h"

void init_dma_tcd( struct TCD_Init_Struct *TCD_Init, uint8_t Channel);

void pll_init_fcn()
{
   FMPLL.SYNCR.R = 0x03000000; /* 80MHz*/
}
void initEMIOS(void) {
  EMIOS.MCR.B.GPRE= 0;		/* Divide 80MHz sysclk by 1 for 80MHz eMIOS clk*/
  EMIOS.MCR.B.GPREN = 1;	/* Enable eMIOS clock */

  								/* Set up chan 0 for 200KHz output with IRQ */
  EMIOS.CH[10].CBDR.R = 400; 	/* Period is 400 eMIOS clocks (5us) */
  EMIOS.CH[10].CADR.R = 200; 	/* Duty cycle is 200 eMIOS clocks, 50% */
  EMIOS.CH[10].CCR.B.MODE = 0x18; /* Mode is Output pulse width + freq. modulation */
  EMIOS.CH[10].CCR.B.BSL = 0x3;	/* Use internal counter */
  EMIOS.CH[10].CCR.B.FEN=1;		/* Flag enables interrupt */
  EMIOS.CH[10].CCR.B.UCPREN = 1;	/* Enable prescaler; uses default divide by 1 */


}

void init_dma_tcd( struct TCD_Init_Struct *TCD_Init, uint8_t Channel){

/* Configure DMA Channel TCD */	
 EDMA.TCD[Channel].SADDR = TCD_Init->SADDR;
 EDMA.TCD[Channel].SMOD  = TCD_Init->SMOD;
 EDMA.TCD[Channel].SSIZE = TCD_Init->SSIZE;
 EDMA.TCD[Channel].DMOD  = TCD_Init->DMOD;
 EDMA.TCD[Channel].DSIZE = TCD_Init->DSIZE; 
 EDMA.TCD[Channel].SOFF  = TCD_Init->SOFF; 
 EDMA.TCD[Channel].NBYTES = TCD_Init->NBYTES;
 EDMA.TCD[Channel].SLAST  = TCD_Init->SLAST;
 EDMA.TCD[Channel].DADDR  = TCD_Init->DADDR; 
 EDMA.TCD[Channel].CITERE_LINK = TCD_Init->CITERE_LINK;
 EDMA.TCD[Channel].CITER  = TCD_Init->CITER;				        
 EDMA.TCD[Channel].DOFF   = TCD_Init->DOFF;				        
 EDMA.TCD[Channel].DLAST_SGA = TCD_Init->DLAST_SGA;
 EDMA.TCD[Channel].BITERE_LINK = TCD_Init->BITERE_LINK; 			       
 EDMA.TCD[Channel].BITER  = TCD_Init->BITER;			         
 EDMA.TCD[Channel].BWC    = TCD_Init->BWC;				       
 EDMA.TCD[Channel].MAJORLINKCH = TCD_Init->MAJORLINKCH;
 EDMA.TCD[Channel].DONE = TCD_Init->DONE;
 EDMA.TCD[Channel].ACTIVE = TCD_Init->ACTIVE;
 EDMA.TCD[Channel].MAJORE_LINK = TCD_Init->MAJORE_LINK;
 EDMA.TCD[Channel].E_SG = TCD_Init->E_SG;
 EDMA.TCD[Channel].D_REQ = TCD_Init->D_REQ;
 EDMA.TCD[Channel].INT_HALF = TCD_Init->INT_HALF;
 EDMA.TCD[Channel].INT_MAJ = TCD_Init->INT_MAJ;  	    
 EDMA.TCD[Channel].START = TCD_Init->START;
	
}/* end init_dma_tcd */

vuint32_t *Result_Queue_Ptr, *Decimator_Ram_Ptr, *Etpu_TCD_Daddr_Ptr; 
vuint32_t Decimator_Channel_Hsr_command;
uint32_t *fs_free_param, error_code;
void main(void)
{

   pll_init_fcn();
   
  /* initialze eTPU */
	fs_etpu_init (my_etpu_config, (uint32_t *) etpu_code,
                  sizeof (etpu_code), (uint32_t *) etpu_globals,
                  sizeof (etpu_globals));

  /* initialise decimator function */
	error_code =
		fs_etpu_decimate_init ( DECIMATOR_CHANNEL,
		                        FS_ETPU_PRIORITY_MIDDLE, 
		                        TCD_Q1.DADDR, 
		                        TCD_Q1.DOFF , 
		                        (vuint16_t *) &Decimator_Ping_Pong, 
		                        PING_PONG_LENGTH );
	
	/* create an HSR command in SRAM which can be DMA'd into the eTPU HSRR */
	Decimator_Channel_Hsr_command = FS_ETPU_DECIMATE_RUN; 

  /* derive the positions of various items in PRAM */
  Decimator_Ram_Ptr = fs_etpu_data_ram (DECIMATOR_CHANNEL); 
	Result_Queue_Ptr = Decimator_Ram_Ptr + (FS_ETPU_DECIMATE_INPUT_VALUES >>2);
	Etpu_TCD_Daddr_Ptr = Decimator_Ram_Ptr + (FS_ETPU_DECIMATE_TCD_DADDR >>2);
	TCD_Q1.SADDR = (vuint32_t)(Decimator_Ram_Ptr + (FS_ETPU_DECIMATE_DECIMATED_VALUE >>2));
	
	/* configure the DMA for eQADC configuartion */
	dma_init_for_eqadc_config();
	/* copy the TCD for eQADC into the DMA channel */
	init_dma_tcd(   &TCD_ADC_CQ_CONFIG, 0);
	
	/* initialise the eQADC ; achieved using DMA */
	eqadc_init_fcn();
	
	/* DMA Enable Request Register Low (Channels 31-0) */
	EDMA.ERQRL.R   = 0x00000003;  
	
	/* set Scatter gather address for TCD_P1 to be address if TCD_Q1 */
	TCD_P1.DLAST_SGA = (vint32_t) &TCD_Q1;
	
	/* set Source Address 0f TCD_R1 to be eTPU PRAM */
	TCD_R1.SADDR = (vint32_t) Etpu_TCD_Daddr_Ptr ;
	
	/* set Source Address 0f TCD_S1 to be  HSR command word */
	TCD_S1.SADDR = (vint32_t) &Decimator_Channel_Hsr_command;
	
	/* set Destination Address 0f TCD_P1 to be the Result Queue */
	TCD_P1.DADDR = (vint32_t) Result_Queue_Ptr;
	
	/* set Source Address 0f TCD_Q1 to be eTPU decimated value */
	TCD_Q1.SADDR = (vint32_t) Decimator_Ram_Ptr + (FS_ETPU_DECIMATE_DECIMATED_VALUE); 
	
	/* set Scatter gather address for TCD_Q1 to be address of TCD_R1 */
	TCD_Q1.DLAST_SGA = (vint32_t) &TCD_R1;
	   
	/* copy the TCD for eQADC results into the DMA channel */
	init_dma_tcd(   &TCD_P1, 1);
	
	/* copy the TCD for eQADC conversion commands into the DMA channel */
	init_dma_tcd(   &TCD_ADC_CQ, 0);
   
	/* create command queue; here we'll use a sequence 
   	of internal eqadc reference conversions */
	 Cqueue0[0] = 0x40022b00;	 Cqueue0[1] = 0x40022900;	 Cqueue0[2] = 0x40022b00;	
	 Cqueue0[3] = 0x40022b00;	 Cqueue0[4] = 0x40022a00;	 Cqueue0[5] = 0x40022c00;	
	 Cqueue0[6] = 0x40022900;	 Cqueue0[7] = 0x40022800;	 Cqueue0[8] = 0x40022a00;	 
	 Cqueue0[9] = 0x40022b00;	Cqueue0[10] = 0x40022c00;	Cqueue0[11] = 0x40022800;	
	Cqueue0[12] = 0x40022b00;	Cqueue0[13] = 0x40022b00;	Cqueue0[14] = 0x40022b00;	
	Cqueue0[15] = 0x40022900;	Cqueue0[16] = 0x40022c00;	Cqueue0[17] = 0x40022900;	
	Cqueue0[18] = 0x40022c00;	Cqueue0[19] = 0x40022800;	Cqueue0[20] = 0x40022800;	
	Cqueue0[21] = 0x40022a00;	Cqueue0[22] = 0x40022b00;	Cqueue0[23] = 0x40022b00;	
	Cqueue0[24] = 0x40022900;	Cqueue0[25] = 0x40022b00;	Cqueue0[26] = 0x40022b00;	
	Cqueue0[27] = 0x40022a00;	Cqueue0[28] = 0x40022c00;	Cqueue0[29] = 0x40022800;	
	Cqueue0[30] = 0x40022a00;	Cqueue0[31] = 0x40022b00;	Cqueue0[32] = 0x40022c00;	
	Cqueue0[33] = 0x40022900;	Cqueue0[34] = 0x40022b00;	Cqueue0[35] = 0x40022a00;	
	Cqueue0[36] = 0x40022c00;	Cqueue0[37] = 0x40022c00;	Cqueue0[38] = 0x40022a00;	
	Cqueue0[39] = 0x40022b00;	Cqueue0[40] = 0x40022800;	Cqueue0[41] = 0x40022b00;	
	Cqueue0[42] = 0x40022a00;	Cqueue0[43] = 0x40022c00;	Cqueue0[44] = 0x40022a00;	
	Cqueue0[45] = 0x40022a00;	Cqueue0[46] = 0x40022900;	Cqueue0[47] = 0x40022c00;	
	Cqueue0[48] = 0x40022c00;	Cqueue0[49] = 0x40022b00;	Cqueue0[50] = 0x40022a00;	
	Cqueue0[51] = 0x40022c00;	Cqueue0[52] = 0x40022800;	Cqueue0[53] = 0x40022900;	
	Cqueue0[54] = 0x40022b00;	Cqueue0[55] = 0x40022c00;	Cqueue0[56] = 0x40022a00;	
	Cqueue0[57] = 0x40022b00;	Cqueue0[58] = 0x40022b00;	Cqueue0[59] = 0x40022b00;	
	Cqueue0[60] = 0x40022800;	Cqueue0[61] = 0x40022c00;	Cqueue0[62] = 0x40022a00;	
	Cqueue0[63] = 0x40022a00;	

   /* Enable DMA transfers for Command Queue0 and  Result queue */
   EQADC.IDCR[0].R = 0x0303;

   /* Coversion will be trriggered in rising edge of external trigger */
   EQADC.CFCR[0].B.MODE = RISING_EXT_CS;
   /* set up eMIOS channel to be the trigeer */
   initEMIOS();
   
   /* enable all timebases */
	 fs_timer_start ();


main_loop:   
   while (1){ 
   } ;		/* This is just an example, so wait here. */

}
/*********************************************************************
 *
 * Copyright:
 *	Freescale Semiconductor, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Freescale
 *  Semiconductor, Inc. This software is provided on an "AS IS"
 *  basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, Freescale
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH
 *  REGARD TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF)
 *  AND ANY ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale Semiconductor assumes no responsibility for the
 *  maintenance and support of this software
 ********************************************************************/













































