/******************************************************************************
 Copyright  1995-2003 Metrowerks Corporation. 
 All Rights Reserved
 
 This is unpublished proprietary source code of Metrowerks.
 The copyright notice above does not evidence any actual or intended
 publication of such source code.
  
 $Date: 2006/02/01 12:12:06 $
 $Id: os_datatypes.h,v 1.13 2006/02/01 12:12:06 lironk Exp $
 $Source: /home/swproj/sw/REPOSITORY/dsp/SmartDSP/include/common/os_datatypes.h,v $
 $Revision: 1.13 $
 **************************************************************************//**
 
 @File          os_datatypes.h

 @Description   OS data types and public structures.

 @Cautions      None.
   
*//***************************************************************************/

#ifndef __OS_DATATYPES_H
#define __OS_DATATYPES_H


/* uncomment the next line if you are including C99 headers */
/* #define HAVE_C99_DATATYPES */

/* uncomment the next line if you do not need old datatypes */
#define USING_OLD_DATATYPES


#ifndef VERILOG
#define INLINE                          static inline
#else
#define INLINE                          static __inline
#endif // VERILOG

/* OS native data type mappings. This can be architecture specific. */
#if defined(SC1XX) || defined(STARCORE) || defined (SC3X00)
  #define OS_BYTE_TYPE                  char
  #define OS_SHORT_TYPE                 short
  #define OS_LONG_TYPE                  long
  #define OS_FLOAT_TYPE                 float
  #define OS_DOUBLE_TYPE                double
#else
  #define OS_BYTE_TYPE                  char
  #define OS_SHORT_TYPE                 short
  #define OS_LONG_TYPE                  long
  #define OS_FLOAT_TYPE                 float
  #define OS_DOUBLE_TYPE                double
#endif


#ifdef HAVE_C99_DATATYPES

#include <stdint.h>     /* for integer types */
#include <math.h>       /* for floating-point types */

#else /* not HAVE_C99_DATATYPES */

/* type definitions */
typedef unsigned OS_BYTE_TYPE           uint8_t;    /* Unsigned  8-bit integer */
typedef unsigned OS_SHORT_TYPE          uint16_t;   /* Unsigned 16-bit integer */
typedef unsigned OS_LONG_TYPE           uint32_t;   /* Unsigned 32-bit integer */

typedef signed OS_BYTE_TYPE             int8_t;     /* Signed  8-bit integer */
typedef signed OS_SHORT_TYPE            int16_t;    /* Signed 16-bit integer */
typedef signed OS_LONG_TYPE             int32_t;    /* Signed 32-bit integer */

typedef OS_FLOAT_TYPE                   float_t;    /* Single precision floating point */
typedef OS_DOUBLE_TYPE                  double_t;   /* Double precision floating point */	    

#endif /* HAVE_C99_DATATYPES */

typedef int                             bool;

#if !defined(FALSE)
#define FALSE                           (0)
#endif
#if !defined(TRUE)
#define TRUE                            (1)
#endif

#if !defined(NULL)
#define NULL                            ((void*)0)
#endif


#define VAR_UNUSED(var)                 var = var


/**************************************************************************//**
 @Description   OS status; See %os_error.h for detailed error values.
                
*//***************************************************************************/
typedef uint32_t                        os_status;

typedef void*                           arch_specific;

typedef uint16_t                        os_user_id;

typedef uint16_t                        os_hwi_handle,
                                        os_hwi_object;      /* DEPRECATED */
                                        
typedef uint16_t                        os_hwi_priority;
typedef uint32_t                        os_hwi_status;
typedef uint8_t                         os_hwi_mode;
typedef uint32_t                        os_hwi_arg;

typedef uint16_t                        os_swi_handle,
                                        os_swi_object;      /* DEPRECATED */
                                        
typedef uint16_t                        os_swi_priority;
typedef uint16_t                        os_swi_status;
typedef uint32_t                        os_swi_count;

typedef uint32_t                        os_dma_xfer;

typedef uint32_t 						os_watchdog_handle;


/**************************************************************************//**
 @Description   Byte order type.
                
*//***************************************************************************/
typedef enum { OS_BO_LITTLE_ENDIAN = 0,
               OS_BO_BIG_ENDIAN }       os_byte_order;


typedef uint16_t                        os_timer_handle,
                                        os_timer_object;    /* DEPRECATED */
                                        
typedef uint32_t                        os_timer_interval;
typedef uint32_t                        os_timer_mode;

/* Available modes for software and hardware timers */
#define OS_TIMER_ONE_SHOT               1
#define OS_TIMER_PERIODIC               2
#define OS_TIMER_FREE_RUN               3

typedef uint32_t                        os_hw_timer_source;

typedef uint16_t                        os_msg_handle,
                                        os_msg_object;      /* DEPRECATED */



/**************************************************************************//**
 @Description   Hardware Interrupt function prototype.
                
*//***************************************************************************/
typedef void (*os_hwi_function)(os_hwi_arg);

/**************************************************************************//**
 @Description   Software Interrupt function prototype.
                
*//***************************************************************************/
typedef void (*os_swi_function)(os_swi_count);

/**************************************************************************//**
 @Description   Software Timer function prototype.
                
*//***************************************************************************/
typedef void (*os_timer_function)(void);

/**************************************************************************//**
 @Description   Task function prototype.
                
*//***************************************************************************/
typedef void (*os_task_function)(void);


/* The definitions below are obsolete, but are still here for compatibility */
#ifdef USING_OLD_DATATYPES

/* type definitions */
typedef unsigned OS_BYTE_TYPE           uint8;  /* Unsigned  8-bit integer */
typedef unsigned OS_SHORT_TYPE          uint16; /* Unsigned 16-bit integer */
typedef unsigned OS_LONG_TYPE           uint32; /* Unsigned 32-bit integer */

typedef signed OS_BYTE_TYPE             int8;   /* Signed  8-bit integer */
typedef signed OS_SHORT_TYPE            int16;  /* Signed 16-bit integer */
typedef signed OS_LONG_TYPE             int32;  /* Signed 32-bit integer */

typedef OS_FLOAT_TYPE                   fp32;   /* Single precision floating point */
typedef OS_DOUBLE_TYPE                  fp64;   /* Double precision floating point */	    

#endif USING_OLD_DATATYPES



#endif // __OS_DATATYPES_H
