#include "os_datatypes.h"

// CONFIG_ADDR bits
#define ENABLE				0x80000000


// Configuration Access Registers for 8144
#define	REG_VENDORID		0x0000
#define	REG_DEVID			0x0002

#define	REG_BUSCMD			0x0004
#define	REG_BUSSTATUS		0x0006
#define	REG_REVID			0x0008
#define	REG_BUSPROGIF		0x0009
#define	REG_SUBCLASS		0x000A
#define	REG_BASECLASS		0x000B
#define	REG_CACHELINESZ		0x000C
#define	REG_BUSLATENCY		0x000D
#define	REG_HDRTYPE			0x000E
#define	REG_BISTCTL			0x000F
#define	REG_PIMMRBACR		0x0010
#define	REG_GPLBAR0			0x0014
#define	REG_GPLBAR1			0x0018
#define	REG_GPLEXTBAR1		0x001C
#define	REG_GPLBAR2			0x0020
#define	REG_GPLEXTBAR2		0x0024
#define	REG_SUBSYSVENDORID	0x002C
#define	REG_SUBSYSID		0x002E
#define	REG_CAPABILITYPTR	0x0034
#define	REG_INTERRLINE		0x003C
#define	REG_INTERRPIN		0x003D
#define	REG_MINGNT			0x003E
#define	REG_MAXLAT			0x003F
#define	REG_FUNCTION		0x0044
#define	REG_ARBITER			0x0046


#define	SIZE_4KB 	0x0B
#define	SIZE_8KB 	0x0C
#define	SIZE_16KB 	0x0D
#define	SIZE_32KB 	0x0E
#define	SIZE_64KB 	0x0F
#define	SIZE_128KB 	0x10
#define	SIZE_256KB 	0x11
#define	SIZE_512KB 	0x12
#define	SIZE_1MB 	0x13
#define	SIZE_2MB 	0x14
#define	SIZE_4MB 	0x15
#define	SIZE_8MB 	0x16
#define	SIZE_16MB 	0x17
#define	SIZE_32MB 	0x18
#define	SIZE_64MB 	0x19
#define	SIZE_128MB 	0x1A
#define	SIZE_256MB 	0x1B
#define	SIZE_512MB 	0x1C
#define	SIZE_1GB 	0x1D
#define	SIZE_2GB 	0x1E
#define	SIZE_4GB 	0x1F




typedef struct
{		
	volatile uint32_t	config_addr;	
    volatile uint32_t	config_data;		
    volatile uint32_t	int_ack;		
   	volatile uint8_t	reserved[0xBF4];
		
	volatile uint32_t	potar0;	
    volatile uint32_t	potear0;
    volatile uint32_t	powbar0;
   	volatile uint8_t	reserved0[0x4];
    volatile uint32_t	powar0;
   	volatile uint8_t	reserved1[0xC];
   	
	volatile uint32_t	potar1;	
    volatile uint32_t	potear1;
    volatile uint32_t	powbar1;
   	volatile uint8_t	reserved2[0x4];
    volatile uint32_t	powar1;
   	volatile uint8_t	reserved3[0xC];
 
 	volatile uint32_t	potar2;	
    volatile uint32_t	potear2;
    volatile uint32_t	powbar2;
   	volatile uint8_t	reserved4[0x4];
    volatile uint32_t	powar2;
   	volatile uint8_t	reserved5[0xC];

 	volatile uint32_t	potar3;	
    volatile uint32_t	potear3;
    volatile uint32_t	powbar3;
  	volatile uint8_t	reserved6[0x4];
    volatile uint32_t	powar3;
   	volatile uint8_t	reserved7[0xC];
  	
 	volatile uint32_t	potar4;	
    volatile uint32_t	potear4;
    volatile uint32_t	powbar4;
   	volatile uint8_t	reserved8[0x4];
    volatile uint32_t	powar4;
   	volatile uint8_t	reserved9[0x10C];

 	volatile uint32_t	pitar3;	
   	volatile uint8_t	reserved10[0x4];
    volatile uint32_t	piwbar3;
   	volatile uint32_t	piwbear3;
   	volatile uint32_t	piwar3;
   	volatile uint8_t	reserved11[0xC];
   	
 	volatile uint32_t	pitar2;	
   	volatile uint8_t	reserved12[0x4];
    volatile uint32_t	piwbar2;
   	volatile uint32_t	piwbear2;
   	volatile uint32_t	piwar2;
   	volatile uint8_t	reserved13[0xC];
   	
 	volatile uint32_t	pitar1;	
   	volatile uint8_t	reserved14[0x4];
    volatile uint32_t	piwbar1;
   	volatile uint32_t	piwbear1;
   	volatile uint32_t	piwar1;
  	volatile uint8_t	reserved15[0xC];
 		
} mpc8560_pci_regs;



typedef struct
{
    volatile uint32_t potar;            /* PCI Outbound Translation Address Register */
    volatile uint8_t  reserved1[0x4];
    volatile uint32_t pobar;            /* PCI Outbound Base Address Register */
    volatile uint8_t  reserved2[0x4];
    volatile uint32_t pocmr;            /* PCI Outbound Comparison Mask Register */
    volatile uint8_t  reserved3[0x4];    
} pci_outbound_window_t;

typedef struct
{
    volatile uint32_t pitar;            /* PCI Inbound Translation Address Register */
	volatile uint8_t  reserved1[0x4];
    volatile uint32_t pibar;            /* PCI Inbound Base Address Register */
    volatile uint32_t piebar;           /* PCI Inbound Extended Base Address Register */
    volatile uint32_t piwar;            /* PCI Inbound Window Attributes Register */
	volatile uint8_t  reserved2[0x4];
} pci_inbound_window_t;

typedef struct
{
    /* PCI Error Management Registers */
    volatile uint32_t pci_esr;       	/* PCI error status register */
    volatile uint32_t pci_ecdr;     	/* PCI error capture disable register */
    volatile uint32_t pci_err;        	/* PCI error enable register */
    volatile uint32_t pci_eatcr;    	/* PCI error attributes capture register */
    volatile uint32_t pci_eacr;    		/* PCI error address capture register */
    volatile uint32_t pci_eeacr;   		/* PCI error extended address capture register */
    volatile uint32_t pci_edcr;     	/* PCI error data capture register */
    volatile uint8_t  reserved1[0x038 - 0x01C];    

    /* PCI Inbound Registers */
    pci_inbound_window_t inbound2;
    pci_inbound_window_t inbound1;
    pci_inbound_window_t inbound0;
    volatile uint8_t   	 reserved2[0x100 - 0x080];

    /* PCI Outbound Registers */
    pci_outbound_window_t outbound[6];
    volatile uint8_t   	  reserved3[0x1F8 - 0x190];
    
    /* PCI Control Registers */
    volatile uint32_t dtcr;             /* Discard Timer Control Register */
    volatile uint8_t  reserved4[0x200 - 0x1FC];
} msc8144_pci_regs;

