/*
#######################################
#FILE
#8560Pacsun_init.c
#DESCRIPTION
#	initialization file for MSC8144ADS board
#COPYRIGHT	
#	Freescale Corporation
#	All rights reserved.
########################################
*/

#pragma section code_type ".init"

#ifdef __cplusplus
extern "C" {
#endif

asm void __reset(void);
asm void usr_init();
extern void __start();
extern unsigned long gInterruptVectorTable;
extern unsigned long gInterruptVectorTableEnd;

#ifdef __cplusplus
}
#endif


asm void __reset(void)
{
	//
	//   Enable machine check exceptions, SPE, debug interrupts
	//
	lis		r3, 0x0200
	ori		r3, r3, 0x1200
	mtmsr	r3
		
	b		__start
}

asm void usr_init()
{
	nofralloc


#ifdef ROM_VERSION

	// init mmu
	////////////////////
	

	// 1MB TLB1 entry 1 - CCSR: 0x40000000 - 0x400FFFFF
	lis		r5, 0x1001
	ori		r5, r5, 0x0000
	mtspr	624, r5

	lis		r5, 0x8000
	ori		r5, r5, 0x0500
	mtspr	625, r5

	lis		r5, 0x4000
	ori		r5, r5, 0x0008
	mtspr	626, r5

	lis		r5, 0x4000
	ori		r5, r5, 0x003f
	mtspr	627, r5
	
	lis		r5, 0x0000
	ori		r5, r5, 0x0000
	mtspr	628, r5

	tlbwe
	isync
	msync
	

	// 64MB TLB1 entry 2 - SDRAM: 0xC0000000 - 0xC3FFFFFF
	lis		r5, 0x1002
	ori		r5, r5, 0x0000
	mtspr	624, r5

	lis		r5, 0x8000
	ori		r5, r5, 0x0800
	mtspr	625, r5

	lis		r5, 0xC000
	ori		r5, r5, 0x0000 
	mtspr	626, r5

	lis		r5, 0xC000
	ori		r5, r5, 0x003f
	mtspr	627, r5

	tlbwe
	msync
	isync

	// 256MB TLB1 entry 3 - DDR: 0x00000000 - 0x0FFFFFFF
	lis		r5, 0x1003
	ori		r5, r5, 0x0000
	mtspr	624, r5

	lis		r5, 0x8000
	ori		r5, r5, 0x0900
	mtspr	625, r5

	lis		r5, 0x0000
	ori		r5, r5, 0x0000	// cacheable
	mtspr	626, r5

	lis		r5, 0x0000
	ori		r5, r5, 0x003f
	mtspr	627, r5

	tlbwe
	msync
	isync
	
	//TLB entry 4 - BCSR: 0xF8000000 - 0xF83FFFFF
	lis		r5, 0x1004
	ori		r5, r5, 0x0000
	mtspr	624, r5
	
	lis		r5, 0x8000
	ori		r5, r5, 0x0600
	mtspr	625, r5
	
	lis		r5, 0xF800
	ori		r5, r5, 0x0008
	mtspr	626, r5
	
	lis		r5, 0xF800
	ori		r5, r5, 0x003F
	mtspr	627, r5
	
	tlbwe
	msync
	isync
	
	// TLB entry 5 - FLASH: 0xFF000000 - 0xFFFFFFFF
	lis		r5, 0x1005
	ori		r5, r5, 0x0000
	mtspr	624, r5

	lis		r5, 0x8000
	ori		r5, r5, 0x0700
	mtspr	625, r5

	lis		r5, 0xFF00
	ori		r5, r5, 0x0008
	mtspr	626, r5

	lis		r5, 0xFF00
	ori		r5, r5, 0x003f
	mtspr	627, r5

	tlbwe
	msync
	isync


	// TLB entry 6 for PCI: 0x80000000 
	lis		r5, 0x1006
	ori		r5, r5, 0x0000
	mtspr	624, r5
	
	lis		r5, 0xC000
	ori		r5, r5, 0x0900
	mtspr	625, r5
	
	lis		r5, 0x8000
	ori		r5, r5, 0x003f
	mtspr	626, r5
	
	lis		r5, 0x8000
	ori		r5, r5, 0x003f
	mtspr	627, r5

	tlbwe
	msync
	isync

	
	// TLB entry 7 for PCI: 0x90000000 
	lis		r5, 0x1007
	ori		r5, r5, 0x0000
	mtspr	624, r5
	
	lis		r5, 0xC000
	ori		r5, r5, 0x0900
	mtspr	625, r5
	
	lis		r5, 0x9000
	ori		r5, r5, 0x003f
	mtspr	626, r5
	
	lis		r5, 0x9000
	ori		r5, r5, 0x003f
	mtspr	627, r5

	tlbwe
	msync
	isync
	
	
	// move CCSRBAR at 0x40000000	
	lis		r5, 0x0004
	ori		r5, r5, 0x0000
	lis		r4, 0xFF700000@ha
	stw		r5, 0xFF700000@l(r4)
	
	// local access window 0 - DDR
	lis		r5, 0x0000			//0x00000000
	ori		r5, r5, 0x0000	
	lis		r4, 0x40000c08@ha
	stw		r5, 0x40000c08@l(r4)
	
	lis		r5, 0x80f0
	ori		r5, r5, 0x001b		// 256MB
	lis		r4, 0x40000c10@ha
	stw		r5, 0x40000c10@l(r4)
	
	// local access window 1 - local bus
	lis		r5, 0x000c			// 0xc0000000
	ori		r5, r5, 0x0000
	lis		r4, 0x40000c28@ha
	stw		r5, 0x40000c28@l(r4)
	
	lis		r5, 0x8040
	ori		r5, r5, 0x001d		//1GB
	lis		r4, 0x40000c30@ha
	stw		r5, 0x40000c30@l(r4)
	
	// ddr initialization///////////////////
	//CS0_BNDS
	lis		r5, 0x0000
	ori		r5, r5, 0x0007
	lis		r4, 0x40002000@ha
	stw		r5, 0x40002000@l(r4)
	
	//CS0_CONFIG
	lis		r5, 0x8000
	ori		r5, r5, 0x0101
	lis		r4, 0x40002080@ha
	stw		r5, 0x40002080@l(r4)
	
	//TIMING_CONFIG_1
	lis		r5, 0x3734
	ori		r5, r5, 0x4321
	lis		r4, 0x40002108@ha
	stw		r5, 0x40002108@l(r4)
	
	//TIMING_CONFIG_2
	lis		r5, 0x0000
	ori		r5, r5, 0x0800
	lis		r4, 0x4000210C@ha
	stw		r5, 0x4000210C@l(r4)
	
	//DDR_SDRAM_CFG
	lis		r5, 0x4200
	ori		r5, r5, 0x0000
	lis		r4, 0x40002110@ha
	stw		r5, 0x40002110@l(r4)
	
	//DDR_SDRAM_MODE
	lis		r5, 0x0000
	ori		r5, r5, 0x0062
	lis		r4, 0x40002118@ha
	stw		r5, 0x40002118@l(r4)
	
	//DDR_SDRAM_INTERVAL
	lis		r5, 0x0520
	ori		r5, r5, 0x0100
	lis		r4, 0x40002124@ha
	stw		r5, 0x40002124@l(r4)
	
	// wait 200
	addi  r5,0,0x0200
	mtspr CTR,r5
wait_loop:
    bc    16,0,wait_loop  // Decrement CTR, then branch if CTR is not 0      

	//DDR_SDRAM_CFG
	lis		r5, 0xc200
	ori		r5, r5, 0x0000
	lis		r4, 0x40002110@ha
	stw		r5, 0x40002110@l(r4)
	
	// configure local bus memory controller////////////////////////////////
	//BR0 
	lis		r5, 0xff00
	ori		r5, r5, 0x1001
	lis		r4, 0x40005000@ha
	stw		r5, 0x40005000@l(r4)
	
	//OR0
	lis		r5, 0xff00
	ori		r5, r5, 0x6ff7
	lis		r4, 0x40005004@ha
	stw		r5, 0x40005004@l(r4)
	
	//cs2
	lis		r5, 0xffff
	ori		r5, r5, 0x84c5
	lis		r4, 0x40005014@ha
	stw		r5, 0x40005014@l(r4)
	
	lis		r5, 0xf800
	ori		r5, r5, 0x8801
	lis		r4, 0x40005010@ha
	stw		r5, 0x40005010@l(r4)
	//LBCR
	lis		r5, 0x0000
	ori		r5, r5, 0x0000
	lis		r4, 0x400050d0@ha
	stw		r5, 0x400050d0@l(r4)
	//LCRR
	lis		r5, 0x8003
	ori		r5, r5, 0x0008
	lis		r4, 0x400050d4@ha
	stw		r5, 0x400050d4@l(r4)
	//LSRT
	lis		r5, 0x2000
	ori		r5, r5, 0x0000
	lis		r4, 0x400050a4@ha
	stw		r5, 0x400050a4@l(r4)
	//MPTPR
	lis		r5, 0x2000
	ori		r5, r5, 0x0000
	lis		r4, 0x40005084@ha
	stw		r5, 0x40005084@l(r4)
	//LSDMR
	lis		r5, 0x0061
	ori		r5, r5, 0xb723
	lis		r4, 0x40005094@ha
	stw		r5, 0x40005094@l(r4)
	//LSDMR
	lis		r5, 0x2861
	ori		r5, r5, 0xb723
	lis		r4, 0x40005094@ha
	stw		r5, 0x40005094@l(r4)
	//
	lis		r5, 0x0000
	ori		r5, r5, 0x00ff
	lis		r4, 0xC0000000@ha
	stw		r5, 0xC0000000@l(r4)
	
	lis		r5, 0x0861
	ori		r5, r5, 0xb723
	lis		r4, 0x40005094@ha
	stw		r5, 0x40005094@l(r4)
	
	addi  r6,0,0x0008
	mtspr CTR,r6
	lis		r5, 0x0000
	ori		r5, r5, 0x00ff
	lis		r4, 0xC0000000@ha
write_loop:
	stw		r5, 0xC0000000@l(r4)
    bc    16,0,write_loop  // Decrement CTR, then branch if CTR is not 0      

	
	lis		r5, 0x1861
	ori		r5, r5, 0xB723
	lis		r4, 0x40005094@ha
	stw		r5, 0x40005094@l(r4)
	
	lis		r5, 0x0000
	ori		r5, r5, 0x00ff
	lis		r4, 0xC00000cc@ha
	stw		r5, 0xC00000cc@l(r4)
	
	lis		r5, 0x4061
	ori		r5, r5, 0xB723
	lis		r4, 0x40005094@ha
	stw		r5, 0x40005094@l(r4)
	
	//BCSR initialization
	lis		r5, 0xF800
	ori		r5, r5, 0x0801
	lis		r4, 0x40005008@ha
	stw		r5, 0x40005008@l(r4)
	
	lis		r5, 0xFFFF
	ori		r5, r5, 0x8023
	lis		r4, 0x4000500C@ha
	stw		r5, 0x4000500Cl(r4)
		
	// interrupt vectors initialization
	lis		r4, 0x0000
	lis		r5, 0x0000
	ori		r5, r5, 0x0000
	mtspr	IVPR, r5

	ori		r4, r5, 0x0100
	mtspr	IVOR0, r4
	ori		r4, r5, 0x0200
	mtspr	IVOR1, r4
	ori		r4, r5, 0x0300
	mtspr	IVOR2, r4
	ori		r4, r5, 0x0400
	mtspr	IVOR3, r4
	ori		r4, r5, 0x0500
	mtspr	IVOR4, r4
	ori		r4, r5, 0x0600
	mtspr	IVOR5, r4
	ori		r4, r5, 0x0700
	mtspr	IVOR6, r4
	ori		r4, r5, 0x0c00
	mtspr	IVOR8, r4
	ori		r4, r5, 0x0900
	mtspr	IVOR10, r4
	ori		r4, r5, 0x0f00
	mtspr	IVOR11, r4
	ori		r4, r5, 0x0b00
	mtspr	IVOR12, r4
	ori		r4, r5, 0x1100
	mtspr	IVOR13, r4
	ori		r4, r5, 0x1000
	mtspr	IVOR14, r4
	ori		r4, r5, 0x1500
	mtspr	IVOR15, r4
	ori		r4, r5, 0x1600
	mtspr	IVOR32, r4
	ori		r4, r5, 0x1700
	mtspr	IVOR33, r4
	ori		r4, r5, 0x1800
	mtspr	IVOR34, r4
	ori		r4, r5, 0x1900
	mtspr	IVOR35, r4

	// map CS4 for the 8560ADS board control registers
	lis		r5, 0xF050
	ori		r5, r5, 0x8801
	lis		r4, 0x40005020@ha
	stw		r5, 0x40005020@l(r4)
	
	lis		r5, 0xFFFF
	ori		r5, r5, 0xE9F7
	lis		r4, 0x40005024@ha
	stw		r5, 0x40005024@l(r4)
	
	

	//enable trap debug event in DBCR0
	mfspr	r5, 308
	oris	r5, r5, 0x4100
	ori		r5, r5, 0x0000
	mtspr	308, r5
	

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Copy the exception vectors from ROM to RAM
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	lis			r3, gInterruptVectorTable@h
	ori			r3, r3, gInterruptVectorTable@l
	subi		r3,r3,0x0004
	
	lis			r4, gInterruptVectorTableEnd@h
	ori			r4, r4, gInterruptVectorTableEnd@l
	
	lis			r5, 0xFFFF
	ori			r5,r5,0xFFFC
	
loop:
	lwzu		r6, 4(r3)
	stwu		r6, 4(r5)
	
	cmpw		r3,r4
	blt			loop
#endif  

#ifdef CACHE_VERSION
	mfspr	r3,L1CSR0	/* enable d-cache */
	ori		r3, r3, 0x0001
	mtspr	L1CSR0,r3

	mfspr	r3,L1CSR1	/* enable i-cache */
	ori		r3, r3, 0x0001
	mtspr	L1CSR1,r3

	mfspr	r3,BUCSR 	/* enable branch prediction in BUCSR */
	ori		r3, r3, 0x0001
	mtspr	BUCSR,r3 

	isync		
	msync		
#endif
  
   blr 
}
