;
; Define configuration specific values
;

;; core 0
.unit c0,""

.set _ID_CORE, 0
.include "mmu_attributes.txt"
.include "common.txt"

;; SHARED MEMORY SPACE
.space m2_shared, _M2_SHARED_start, _M2_end, "m2_shared_data" ,"m2_shared_text"
.space m3_shared, _M3_start, _M3_end, "task1_text"
.space ddr_shared, _DDR_start, _DDR_end, ".oskernel_text_initialization","ddr_shared_rom"
.export "m2_shared", "m3_shared", "ddr_shared"


;#####################################  System part   ###########################################

.att_mmu .local_data, _LocalData_b, _LocalData_e, \
		"local_data", attribute : SYSTEM_DATA_MMU_DEF, \
		physical_address: _LocalData_Phys_start

; Shared Data Memory (Non cachable)
; Put all the shared data memory sections to "m2_shared_data" 
.concatenate "m2_shared_data" ,"reserved_crt_mutex", ".os_shared_data"  

; System Progran Memory
; Put all the system memory sections to "m2_shared_text" 
.concatenate "m2_shared_text", ".osvecb",".intvec",".text", ".oskernel_text_run_time", ".oskernel_text_run_time_critical", ".default" 


.att_mmu "M2_mmu",  _M2_SHARED_start, _M2_end,\
	"m2_shared_text", \
			base_address:_M2_SHARED_start, \
			attribute: SYSTEM_PROG_MMU_DEF, \
			physical_address: _M2_SHARED_start, \
	"m2_shared_data",\
			attribute: SHARED_DATA_MMU_DEF, \
			base_address: @vsecend("m2_shared_text"), \
			physical_address: @secend("m2_shared_text")

; System ROM Data Memory
; Put all the shared data memory sections to "ddr_shared_rom" 
.concatenate "ddr_shared_rom",".oskernel_rom", ".rom", ".init_table", ".rom_init"

.att_mmu DDR_mmu, _DDR_start,_DDR_end, \
		".oskernel_text_initialization", \
				attribute : SYSTEM_PROG_MMU_DEF,\
				base_address: _DDR_start, \
				physical_address: _DDR_start, \
		"ddr_shared_rom", \
				attribute : SYSTEM_DATA_MMU_DEF, \
				after_physical_address: _DDR_start
				
.concatenate "pci_seg", ".pci_sec"
				
.att_mmu PCI_mmu, _PCI_start, _PCI_end, \
	"pci_seg",\
			attribute: SHARED_DATA_MMU_DEF, \
			base_address: _PCI_start, \
			physical_address: _PCI_start
				

;################################  End of System part   ########################################

;################################  User's tasks part   #########################################

; Task 1 Data Memory
; Put all the data memory sections to "tast1_data" 
.concatenate "tast1_data", "task_1_data", "task_1_bss"

.att_mmu TASK_ID_1_data, _User_LocalData_b, _User_LocalData_e, \
		task_id: 1,\
		"tast1_data", attribute : (1<<24) | USER_DATA_MMU_DEF, \
				physical_address: _User_LocalData_Phys_start
				
.att_mmu TASK_ID1_code, _VIRTUAL_MEM_start, _VIRTUAL_MEM_end, \
		 task_id: 1, \
		"task1_text", attribute : (1<<24) | USER_PROG_MMU_DEF, \
				after_physical_address: _M3_start


;############################  End of User's tasks part   #####################################

.entry ___crt0_start


;;core 1
.unit c1

.set _ID_CORE, 1

.include "mmu_attributes.txt"
.include "common.txt"
.import "c0`m2_shared","c0`m3_shared", "c0`ddr_shared"

;#################################  System part   ############################################
.att_mmu .local_data, _LocalData_b, _LocalData_e, \
		"local_data", attribute : SYSTEM_DATA_MMU_DEF, \
		physical_address: _LocalData_Phys_start

;##############################  End of System part   ########################################

;##############################  User's tasks part   #########################################

; Task 1 Data Memory
; Put all the data memory sections to "tast1_data" 
.concatenate "tast1_data", "task_1_data", "task_1_bss"

.att_mmu TASK_ID_1_data, _User_LocalData_b, _User_LocalData_e, \
		task_id: 1,\
		"tast1_data", attribute : (1<<24) | USER_DATA_MMU_DEF, \
				physical_address: _User_LocalData_Phys_start

;############################  End of User's tasks part   ###################################

.entry ___crt0_start

;;core 2
.unit c2

.set _ID_CORE, 2
.include "mmu_attributes.txt"
.include "common.txt"
.import "c0`m2_shared","c0`m3_shared", "c0`ddr_shared"

;#################################  System part   ############################################
.att_mmu .local_data, _LocalData_b, _LocalData_e, \
		"local_data", attribute : SYSTEM_DATA_MMU_DEF, \
		physical_address: _LocalData_Phys_start


;##############################  End of System part   ########################################

;##############################  User's tasks part   #########################################

; Task 1 Data Memory
; Put all the data memory sections to "tast1_data" 
.concatenate "tast1_data", "task_1_data", "task_1_bss"

.att_mmu TASK_ID_1_data, _User_LocalData_b, _User_LocalData_e, \
		task_id: 1,\
		"tast1_data", attribute : (1<<24) | USER_DATA_MMU_DEF, \
				physical_address: _User_LocalData_Phys_start
;############################  End of User's tasks part   ###################################

.entry ___crt0_start

;;core 3
.unit c3

.set _ID_CORE, 3
.include "mmu_attributes.txt"
.include "common.txt"
.import "c0`m2_shared","c0`m3_shared", "c0`ddr_shared"

;#################################  System part   ############################################
.att_mmu .local_data, _LocalData_b, _LocalData_e, \
		"local_data", attribute : SYSTEM_DATA_MMU_DEF, \
		physical_address: _LocalData_Phys_start

;##############################  End of System part   ########################################

;##############################  User's tasks part   #########################################

; Task 1
;Define all related sections as overlays
.define_overlay "task_1_data", "task_1_bss"
; Task 1 Data Memory
; Put all the data memory sections to "tast1_data" 
.concatenate "tast1_data", "task_1_data", "task_1_bss"


.att_mmu TASK_ID_1_data, _User_LocalData_b, _User_LocalData_e, \
		task_id: 1,\
		"tast1_data", attribute : (1<<24) | USER_DATA_MMU_DEF, \
				physical_address: _User_LocalData_Phys_start

;; PRIVATE SEGMENTS
.org _User_LocalData_Phys_start
.segment .tast1_data, "tast1_data"
;############################  End of User's tasks part   ###################################

.entry ___crt0_start


;.org _PCI_start
;.segment pci_seg, ".pci_sec"
