/*********************************************************************
 *
 * Copyright:
 *	MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/

/**************************************************************************/
/* FILE NAME: tpu_mcpwm_example1.c            COPYRIGHT (c) MOTOROLA 2002 */
/* VERSION: 1.1                                   All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION: This sample program shows a MCPWM example in Edge-Aligned */
/* mode that generates two PWM pulses with a period of 256 TCR1 clocks,   */
/* one with a duty cycle of 50%, the other 25%.  It will use channel 0 as */
/* the master and channels 1 and 2 as the slaves.  It also generates a    */
/* periodic interrupt every five PWM periods.							  */
/*                                                                        */
/* The program is targeted for the MPC555 but should work on any MPC500   */
/* device with a TPU. For other devices the setup routines will also need */
/* to be changed.                                                         */
/*========================================================================*/
/* HISTORY           ORIGINAL AUTHOR: Mario Ramiro Perez II               */
/*                                                                        */
/* REV      AUTHOR         DATE       DESCRIPTION OF CHANGE               */
/* ---   -----------     ---------    ---------------------               */
/* 1.0   Mario R. Perez  25 Sep 02    Initial version of function.        */
/**************************************************************************/

#include "mpc555.h"         /* Define MPC555 registers, this needs to be  */
                            /* changed if other MPC500 devices are used.  */
#include "mpc500_util.h"    /* Utility routines for using MPC500 devices  */
#include "tpu_mcpwm.h"      /* TPU MCPWM functions 						  */


void main ()
{
    struct TPU3_tag *tpua = &TPU_A;         /* pointer for TPU routines */

    setup_555();


    /* Initialize MCPWM Master Init function with:  */
    /*    - TPU A Channel 0 set        				*/
    /*    - Priority set to High                    */
    /*    - Period set to 0x100 					*/
    /*    - IRQ Rate set to 0x5                   	*/
tpu_mcpwm_master_init(tpua, 0, TPU_PRIORITY_HIGH, 0x100, 0x5); 


    /* Initialize Slave Edge Mode function with:    */
    /*    - TPU A Channel 1 set        				*/
    /*    - Priority set to High                    */
    /*    - Period set to 0x100 					*/
    /*    - High Time set to 0x80                 	*/
    /*    - High Time Pointer set to 0x12			*/
    /*	  - Master Channel is on TPU ch 0           */
tpu_mcpwm_slave_edgemode_init (tpua, 1, TPU_PRIORITY_HIGH, 0x100, 0x80, 0x12, 0);


    /* Initialize Slave Edge Mode function with:    */
    /*    - TPU A Channel 2 set        				*/
    /*    - Priority set to High                    */
    /*    - Period set to 0x100 					*/
    /*    - High Time set to 0x40                 	*/
    /*    - High Time Pointer set to 0x22			*/
    /*	  - Master Channel is on TPU ch 0           */    
tpu_mcpwm_slave_edgemode_init (tpua, 2, TPU_PRIORITY_HIGH, 0x100, 0x40, 0x22, 0);
							

tpu_interrupt_enable(tpua, 0);          /* enable MCPWM interrupts */


    while (1) {                             /* loop and measure */
    }
}

