/*********************************************************************
 *
 * Copyright: MOTOROLA, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY
 *  ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/

#include "mpc555.h"
#include "m_tpu3.h"

void setup_555(void)
    {

    struct TPU3_tag *tpua = &TPU_A;         /* pointer for TPU_A */
    struct TPU3_tag *tpub = &TPU_B;         /* pointer for TPU_B */
    struct UIMB_tag *uimb = &UIMB;          /* pointer for UIMB */

/* setup TPUMCR: clear SUPV bit, setup TCR1P and TCR2P prescalers */

    tpua->TPUMCR.R = (tpua->TPUMCR.R & 0xFF7F) | 0x4040;    /* set TPUMCR for TPU3_A                                            */

    tpub->TPUMCR.R = (tpub->TPUMCR.R & 0xFF7F) | 0x4040;    /* set TPUMCR for TPU3_B                                            */

/* derive TCR1 input of 1MHz from a 40MHz system clock as follows: */
/*      setup TPUMCR3: EPSCK and EPSCKE bits for TPU_A and TPU_B   */

    tpua->TPUMCR3.R = 0x0044;   /* set TPU A enhanced prescalar to divide by 40 */

    tpub->TPUMCR3.R = 0x0044;   /* set TPU B enhanced prescalar to divide by 40 */

    uimb->UMCR.R = 0x0;         /* set IMB3 BUS speed = U BUS speed (MPC555 default is 1/2) */

    setup_ext_int();            /* set up MPC555 external interrupts */

    tpua->TICR.R = 0x0230;      /* set up IRQ level 2 in TPU Interrupt Config Reg */

    }