/**************************************************************************/
/* FILE NAME: example3_oc_nitc.c              COPYRIGHT (c) MOTOROLA 2002 */
/* VERSION: 4.0                                   All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION: This sample program shows a simple example of a program   */
/* that uses the OC API to control an output pin.                         */
/* The program is targeted for the MPC555 but should work on any MPC500   */
/* device with a TPU. For other devices the setup routines will also need */
/* to be changed.                                                         */
/*========================================================================*/
/* HISTORY           ORIGINAL AUTHOR: John Honnold                        */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 1.0   J. Honnold  30/Aug/02    Initial version of function.            */
/* 2.0               30/Sep/02    Update of original version.             */
/* 4.0               08/Oct/02    Add disclaimer.  Fix bug where initial  */
/*                                value is stored.                        *
/**************************************************************************/

#include "mpc555.h"
#include "tpu_oc.h"
#include "updated_tpu_nitc.h"
#include "mpc500_util.h"
#include "m_tpu3.h"

// Uncomment next line if you want to turn interrupts on.
//#define	int_on 

void init_TPU(void)
{
	/*	enable tpu clocks( stop = 0 ) 
		tcr1 divide by 1( tcr1p = 0b00 )
		tcr2 divide by 1( tcr2p = 0b00 )
		no emulation( emu = 0 )
		tcr2 pin used as gate of DIV8 clock for TCR2( t2cg = 1 )
		stop flag
		supervisor and user space( supv = 0 )
		tpu prescaler div 4( psck = 0 )
		tpu3 mode( tpu3 = 1 )
		gated imb clock( t2csl = 0 )
	*/
	TPU_A.TPUMCR.R = 0x0220 ;

	TPU_A.TICR.B.CIRL = 1 ; // Interrupt request level 1.
	TPU_A.TICR.B.ILBS = 0 ; // Interrupt levels 0 to 7 selected.

//	USIU.SIMASK.B.LVM1 = 1 ; // Enable level 1; others disabled
}

void init555(void)				// Simple MPC555 Initialization
{
	
	USIU.SYPCR.R = 0xffffff03; // Disable watchdog timer 
	USIU.PLPRCR.B.MF = 0x009; // Run at 40MHz for 4MHz crystal
	while(USIU.PLPRCR.B.SPLS == 0) // Wait for PLL to lock	
	{
	}	
	UIMB.UMCR.B.HSPEED = 0;	// Run IMB at full clock speed				       
}

void main(void)
{
	UINT16		loopctr = 0, offset = 0, max_count = 1 ;
	UINT8		oc_ch = 1, nitc_ch = 0, link_ch_count = 1 ;
	UINT8		nitc_priority = 3, oc_priority = 3, ratio = 0 ;
	UINT8		ref_addr1 = 0, ref_addr2 = 0, ref_addr3 = 0 ;

	struct TPU3_tag *tpua = &TPU_A;   /* pointer for TPU routines */

	init555();				// Perform a simple 555 initialzation
	init_TPU();			// Initialize the TPU
	
	offset = 0x2000 ;	// 0x2000 causes an offset time of 1.6 ms,
						// This value must be less than 0x8000
	ref_addr1 = 0 ; 	// REF_ADDR1 is a don't care since only one link 
						// is received after initialization
	ref_addr2 = 0x0E ;	// Location of initial value of period in unused pram
	// Set ref_addr3 of the OC to look at the NITC FINAL_TRANS_TIME 
	ref_addr3 = (nitc_ch * 0x10) + (TPU_NITC_FINAL_TRANS_TIME * 0x2) ;
	ratio = 0x80 ;		// This creates about a duty cycle of 50%
	tpua->PARM.R[nitc_ch][7] = 0x2000 ; // Initial value of period
	

#ifdef int_on
	tpu_interrupt_enable(tpua, channel);
	asm(" mtspr EIE, r3");	// FINAL STEP: SET MSR[EE], MSR[RI] BITS
#endif	

	// TPU_OC_TCR_ONLY will cause an interrupt( if enabled ) at the 
	// end of the execution of the Host Initiated Pulse Mode.
	tpu_oc_continuous(tpua, oc_ch, ratio, ref_addr1, ref_addr2, ref_addr3, \
		TPU_OC_ALL_CODE, TPU_OC_FORCE_LO, TPU_OC_FORCE_LO, TCR1, oc_priority ) ;

	tpu_nitc_init_tcr_mode(tpua, nitc_ch, nitc_priority, \
		TPU_NITC_RISING, max_count, TPU_NITC_SINGLE, TPU_NITC_TCR1, \
		TPU_NITC_LINK, oc_ch, TPU_NITC_LINK_ONE, TPU_NITC_NOINTERRUPT) ;

	while(1)
	{
   		loopctr++;
   	}			     
}

/*********************************************************************
 *
 * Copyright:
 *	MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/

