/**************************************************************************/
/* FILE NAME: tpu_fqd.h                       COPYRIGHT (c) MOTOROLA 2002 */
/* VERSION: 1.0                                   All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION: This file defines the interface to the TPU FQD functions  */
/* and provides useful #defines.                                          */
/*                                                                        */
/*========================================================================*/
/* HISTORY           ORIGINAL AUTHOR Ken Terry                            */
/* REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  */
/* ---   -----------  ---------    ---------------------                  */
/* 1.0   K Terry      14/8/02    Initial version of function.             */
/**************************************************************************/
#ifndef _TPU_HALLD_H
#define _TPU_HALLD_H


#include "m_common.h"
#include "m_tpu3.h"


/* Define HSQ values */
#define HALLD_CHANNEL_A 0x0
#define HALLD_CHANNEL_B 0x1
#define HALLD_CHANNEL_C 0x3

/* Define HSR values */
#define HALLD_TWO_CHANNEL_MODE 0x02
#define HALLD_THREE_CHANNEL_MODE 0x03


/* defines for parameter RAM variables */
#define HALLD_DIRECTION_0 0x0000
#define HALLD_DIRECTION_1 0x0001

/* Define Parameter RAM Locations */
#define HALLD_DIRECTION 3
#define HALLD_STATE_NO_ADDRESS 4
#define HALLD_PINSTATE 5
#define HALLD_STORE_MODE 2


	
/* TPU HALLD function prototypes */
void tpu_halld_init(struct TPU3_tag *tpu, UINT8 channel, INT16 direction, 
                   INT16 state_no_address, UINT8 mode);
void tpu_halld_set_direction(struct TPU3_tag *tpu, UINT8 channel, INT16 direction);
void tpu_halld_disable(struct TPU3_tag *tpu, UINT8 channel);
void tpu_halld_enable(struct TPU3_tag *tpu, UINT8 channel, UINT8 priority);
void tpu_halld_set_state_no_address(struct TPU3_tag *tpu, UINT8 channel,
                   INT16 state_no_address);
INT16 tpu_halld_get_state_no(struct TPU3_tag *tpu, UINT8 channel);
INT16 tpu_halld_get_pinstate(struct TPU3_tag *tpu, UINT8 channel);



#endif
/* ifndef _TPU_HALLD_H  */


/*********************************************************************
 *
 * Copyright:
 *	MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/