; Based on CPU DB MC13233C, version 3.00.000 (RegistersPrg V2.31)

; ###################################################################
;     Filename  : mc13233c.inc
;     Processor : MC13233C
;     FileFormat: V2.31
;     DataSheet : MC1323xRM Rev. 0.0 11/2009
;     Compiler  : CodeWarrior compiler
;     Date/Time : 3.2.2010, 9:56
;     Abstract  :
;         This header implements the mapping of I/O devices.
;
;     Copyright : 1997 - 2010 Freescale Semiconductor, Inc. All Rights Reserved.
;     
;     http      : www.freescale.com
;     mail      : support@freescale.com
;
;     CPU Registers Revisions:
;               - none
;
;     File-Format-Revisions:
;               - none
;
;     Not all general-purpose I/O pins are available on all packages or on all mask sets of a specific
;     derivative device. To avoid extra current drain from floating input pins, the users reset
;     initialization routine in the application program must either enable on-chip pull-up devices
;     or change the direction of unconnected pins to outputs so the pins do not float.
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
ROMStart:           equ   $00002080
ROMEnd:             equ   $00007FFF
Z_RAMStart:         equ   $00000080
Z_RAMEnd:           equ   $000000FF
RAMStart:           equ   $00000100
RAMEnd:             equ   $0000147F
ROM1Start:          equ   $0000C000
ROM1End:            equ   $0000FFAD
ROM2Start:          equ   $0000FFC0
ROM2End:            equ   $0000FFCB
PPAGE_0Start:       equ   $00008000
PPAGE_0End:         equ   $0000A07F
PPAGE_2Start:       equ   $00028000
PPAGE_2End:         equ   $0002BFFF
PPAGE_4Start:       equ   $00048000
PPAGE_4End:         equ   $0004BFFF
;
Vrtc:               equ   $0000FFCC
Vkeyboard1:         equ   $0000FFCE
Vkeyboard2:         equ   $0000FFD0
Viic:               equ   $0000FFD2
Vcmt:               equ   $0000FFD4
Vscitx:             equ   $0000FFD6
Vscirx:             equ   $0000FFD8
Vscierr:            equ   $0000FFDA
Vspi:               equ   $0000FFDC
Vtpm4ovf:           equ   $0000FFDE
Vtpm4ch0:           equ   $0000FFE0
Vtpm3ovf:           equ   $0000FFE2
Vtpm3ch0:           equ   $0000FFE4
Vtpm2ovf:           equ   $0000FFE6
Vtpm2ch0:           equ   $0000FFE8
Vtpm1ovf:           equ   $0000FFEA
Vtpm1ch0:           equ   $0000FFEC
Vaes128:            equ   $0000FFEE
Vrx_watermark_802_15_4: equ   $0000FFF0
Vtimers_802_15_4:   equ   $0000FFF2
Vtx_802_15_4:       equ   $0000FFF4
Vrx_802_15_4:       equ   $0000FFF6
Vlvd:               equ   $0000FFF8
Virq:               equ   $0000FFFA
Vswi:               equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PTAD - Port A Data Register; 0x00000000 ***
PTAD:               equ    $00000000                                ;*** PTAD - Port A Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAD_PTAD0:         equ    0                                         ; Port A Data Register Bit 0
PTAD_PTAD1:         equ    1                                         ; Port A Data Register Bit 1
PTAD_PTAD2:         equ    2                                         ; Port A Data Register Bit 2
PTAD_PTAD3:         equ    3                                         ; Port A Data Register Bit 3
PTAD_PTAD4:         equ    4                                         ; Port A Data Register Bit 4
PTAD_PTAD5:         equ    5                                         ; Port A Data Register Bit 5
PTAD_PTAD6:         equ    6                                         ; Port A Data Register Bit 6
PTAD_PTAD7:         equ    7                                         ; Port A Data Register Bit 7
; bit position masks
mPTAD_PTAD0:        equ    %00000001
mPTAD_PTAD1:        equ    %00000010
mPTAD_PTAD2:        equ    %00000100
mPTAD_PTAD3:        equ    %00001000
mPTAD_PTAD4:        equ    %00010000
mPTAD_PTAD5:        equ    %00100000
mPTAD_PTAD6:        equ    %01000000
mPTAD_PTAD7:        equ    %10000000


;*** PTADD - Port A Data Direction Register; 0x00000001 ***
PTADD:              equ    $00000001                                ;*** PTADD - Port A Data Direction Register; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTADD_PTADD0:       equ    0                                         ; Data Direction for Port A Bit 0
PTADD_PTADD1:       equ    1                                         ; Data Direction for Port A Bit 1
PTADD_PTADD2:       equ    2                                         ; Data Direction for Port A Bit 2
PTADD_PTADD3:       equ    3                                         ; Data Direction for Port A Bit 3
PTADD_PTADD4:       equ    4                                         ; Data Direction for Port A Bit 4
PTADD_PTADD5:       equ    5                                         ; Data Direction for Port A Bit 5
PTADD_PTADD6:       equ    6                                         ; Data Direction for Port A Bit 6
PTADD_PTADD7:       equ    7                                         ; Data Direction for Port A Bit 7
; bit position masks
mPTADD_PTADD0:      equ    %00000001
mPTADD_PTADD1:      equ    %00000010
mPTADD_PTADD2:      equ    %00000100
mPTADD_PTADD3:      equ    %00001000
mPTADD_PTADD4:      equ    %00010000
mPTADD_PTADD5:      equ    %00100000
mPTADD_PTADD6:      equ    %01000000
mPTADD_PTADD7:      equ    %10000000


;*** PTBD - Port B Data Register; 0x00000002 ***
PTBD:               equ    $00000002                                ;*** PTBD - Port B Data Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBD_PTBD0:         equ    0                                         ; Port B Data Register Bit 0
PTBD_PTBD1:         equ    1                                         ; Port B Data Register Bit 1
PTBD_PTBD2:         equ    2                                         ; Port B Data Register Bit 2
PTBD_PTBD3:         equ    3                                         ; Port B Data Register Bit 3
PTBD_PTBD4:         equ    4                                         ; Port B Data Register Bit 4
PTBD_PTBD5:         equ    5                                         ; Port B Data Register Bit 5
PTBD_PTBD6:         equ    6                                         ; Port B Data Register Bit 6
PTBD_PTBD7:         equ    7                                         ; Port B Data Register Bit 7
; bit position masks
mPTBD_PTBD0:        equ    %00000001
mPTBD_PTBD1:        equ    %00000010
mPTBD_PTBD2:        equ    %00000100
mPTBD_PTBD3:        equ    %00001000
mPTBD_PTBD4:        equ    %00010000
mPTBD_PTBD5:        equ    %00100000
mPTBD_PTBD6:        equ    %01000000
mPTBD_PTBD7:        equ    %10000000


;*** PTBDD - Port B Data Direction Register; 0x00000003 ***
PTBDD:              equ    $00000003                                ;*** PTBDD - Port B Data Direction Register; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBDD_PTBDD0:       equ    0                                         ; Data Direction for Port B Bit 0
PTBDD_PTBDD1:       equ    1                                         ; Data Direction for Port B Bit 1
PTBDD_PTBDD2:       equ    2                                         ; Data Direction for Port B Bit 2
PTBDD_PTBDD3:       equ    3                                         ; Data Direction for Port B Bit 3
PTBDD_PTBDD4:       equ    4                                         ; Data Direction for Port B Bit 4
PTBDD_PTBDD5:       equ    5                                         ; Data Direction for Port B Bit 5
PTBDD_PTBDD6:       equ    6                                         ; Data Direction for Port B Bit 6
PTBDD_PTBDD7:       equ    7                                         ; Data Direction for Port B Bit 7
; bit position masks
mPTBDD_PTBDD0:      equ    %00000001
mPTBDD_PTBDD1:      equ    %00000010
mPTBDD_PTBDD2:      equ    %00000100
mPTBDD_PTBDD3:      equ    %00001000
mPTBDD_PTBDD4:      equ    %00010000
mPTBDD_PTBDD5:      equ    %00100000
mPTBDD_PTBDD6:      equ    %01000000
mPTBDD_PTBDD7:      equ    %10000000


;*** PTCD - Port C Data Register; 0x00000004 ***
PTCD:               equ    $00000004                                ;*** PTCD - Port C Data Register; 0x00000004 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCD_PTCD0:         equ    0                                         ; Port C Data Register Bit 0
PTCD_PTCD1:         equ    1                                         ; Port C Data Register Bit 1
PTCD_PTCD2:         equ    2                                         ; Port C Data Register Bit 2
PTCD_PTCD3:         equ    3                                         ; Port C Data Register Bit 3
PTCD_PTCD4:         equ    4                                         ; Port C Data Register Bit 4
PTCD_PTCD5:         equ    5                                         ; Port C Data Register Bit 5
PTCD_PTCD6:         equ    6                                         ; Port C Data Register Bit 6
PTCD_PTCD7:         equ    7                                         ; Port C Data Register Bit 7
; bit position masks
mPTCD_PTCD0:        equ    %00000001
mPTCD_PTCD1:        equ    %00000010
mPTCD_PTCD2:        equ    %00000100
mPTCD_PTCD3:        equ    %00001000
mPTCD_PTCD4:        equ    %00010000
mPTCD_PTCD5:        equ    %00100000
mPTCD_PTCD6:        equ    %01000000
mPTCD_PTCD7:        equ    %10000000


;*** PTCDD - Port C Data Direction Register; 0x00000005 ***
PTCDD:              equ    $00000005                                ;*** PTCDD - Port C Data Direction Register; 0x00000005 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCDD_PTCDD0:       equ    0                                         ; Data Direction for Port C Bit 0
PTCDD_PTCDD1:       equ    1                                         ; Data Direction for Port C Bit 1
PTCDD_PTCDD2:       equ    2                                         ; Data Direction for Port C Bit 2
PTCDD_PTCDD3:       equ    3                                         ; Data Direction for Port C Bit 3
PTCDD_PTCDD4:       equ    4                                         ; Data Direction for Port C Bit 4
PTCDD_PTCDD5:       equ    5                                         ; Data Direction for Port C Bit 5
PTCDD_PTCDD6:       equ    6                                         ; Data Direction for Port C Bit 6
PTCDD_PTCDD7:       equ    7                                         ; Data Direction for Port C Bit 7
; bit position masks
mPTCDD_PTCDD0:      equ    %00000001
mPTCDD_PTCDD1:      equ    %00000010
mPTCDD_PTCDD2:      equ    %00000100
mPTCDD_PTCDD3:      equ    %00001000
mPTCDD_PTCDD4:      equ    %00010000
mPTCDD_PTCDD5:      equ    %00100000
mPTCDD_PTCDD6:      equ    %01000000
mPTCDD_PTCDD7:      equ    %10000000


;*** PTDD - Port D Data Register; 0x00000006 ***
PTDD:               equ    $00000006                                ;*** PTDD - Port D Data Register; 0x00000006 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDD_PTDD0:         equ    0                                         ; Port D Data Register Bit 0
PTDD_PTDD1:         equ    1                                         ; Port D Data Register Bit 1
PTDD_PTDD2:         equ    2                                         ; Port D Data Register Bit 2
PTDD_PTDD3:         equ    3                                         ; Port D Data Register Bit 3
PTDD_PTDD4:         equ    4                                         ; Port D Data Register Bit 4
PTDD_PTDD5:         equ    5                                         ; Port D Data Register Bit 5
PTDD_PTDD6:         equ    6                                         ; Port D Data Register Bit 6
PTDD_PTDD7:         equ    7                                         ; Port D Data Register Bit 7
; bit position masks
mPTDD_PTDD0:        equ    %00000001
mPTDD_PTDD1:        equ    %00000010
mPTDD_PTDD2:        equ    %00000100
mPTDD_PTDD3:        equ    %00001000
mPTDD_PTDD4:        equ    %00010000
mPTDD_PTDD5:        equ    %00100000
mPTDD_PTDD6:        equ    %01000000
mPTDD_PTDD7:        equ    %10000000


;*** PTDDD - Port D Data Direction Register; 0x00000007 ***
PTDDD:              equ    $00000007                                ;*** PTDDD - Port D Data Direction Register; 0x00000007 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDDD_PTDDD0:       equ    0                                         ; Data Direction for Port D Bit 0
PTDDD_PTDDD1:       equ    1                                         ; Data Direction for Port D Bit 1
PTDDD_PTDDD2:       equ    2                                         ; Data Direction for Port D Bit 2
PTDDD_PTDDD3:       equ    3                                         ; Data Direction for Port D Bit 3
PTDDD_PTDDD4:       equ    4                                         ; Data Direction for Port D Bit 4
PTDDD_PTDDD5:       equ    5                                         ; Data Direction for Port D Bit 5
PTDDD_PTDDD6:       equ    6                                         ; Data Direction for Port D Bit 6
PTDDD_PTDDD7:       equ    7                                         ; Data Direction for Port D Bit 7
; bit position masks
mPTDDD_PTDDD0:      equ    %00000001
mPTDDD_PTDDD1:      equ    %00000010
mPTDDD_PTDDD2:      equ    %00000100
mPTDDD_PTDDD3:      equ    %00001000
mPTDDD_PTDDD4:      equ    %00010000
mPTDDD_PTDDD5:      equ    %00100000
mPTDDD_PTDDD6:      equ    %01000000
mPTDDD_PTDDD7:      equ    %10000000


;*** TPM1SC - TPM1 Status and Control Register; 0x00000008 ***
TPM1SC:             equ    $00000008                                ;*** TPM1SC - TPM1 Status and Control Register; 0x00000008 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM1SC_PS0:         equ    0                                         ; Prescale Divisor Select Bit 0
TPM1SC_PS1:         equ    1                                         ; Prescale Divisor Select Bit 1
TPM1SC_PS2:         equ    2                                         ; Prescale Divisor Select Bit 2
TPM1SC_CLKSA:       equ    3                                         ; Clock Source Select A
TPM1SC_CLKSB:       equ    4                                         ; Clock Source Select B
TPM1SC_CPWMS:       equ    5                                         ; Center-Aligned PWM Select
TPM1SC_TOIE:        equ    6                                         ; Timer Overflow Interrupt Enable
TPM1SC_TOF:         equ    7                                         ; Timer Overflow Flag
; bit position masks
mTPM1SC_PS0:        equ    %00000001
mTPM1SC_PS1:        equ    %00000010
mTPM1SC_PS2:        equ    %00000100
mTPM1SC_CLKSA:      equ    %00001000
mTPM1SC_CLKSB:      equ    %00010000
mTPM1SC_CPWMS:      equ    %00100000
mTPM1SC_TOIE:       equ    %01000000
mTPM1SC_TOF:        equ    %10000000


;*** TPM1CNT - TPM1 Timer Counter Register; 0x00000009 ***
TPM1CNT:            equ    $00000009                                ;*** TPM1CNT - TPM1 Timer Counter Register; 0x00000009 ***


;*** TPM1CNTH - TPM1 Timer Counter Register High; 0x00000009 ***
TPM1CNTH:           equ    $00000009                                ;*** TPM1CNTH - TPM1 Timer Counter Register High; 0x00000009 ***


;*** TPM1CNTL - TPM1 Timer Counter Register Low; 0x0000000A ***
TPM1CNTL:           equ    $0000000A                                ;*** TPM1CNTL - TPM1 Timer Counter Register Low; 0x0000000A ***


;*** TPM1MOD - TPM1 Timer Counter Modulo Register; 0x0000000B ***
TPM1MOD:            equ    $0000000B                                ;*** TPM1MOD - TPM1 Timer Counter Modulo Register; 0x0000000B ***


;*** TPM1MODH - TPM1 Timer Counter Modulo Register High; 0x0000000B ***
TPM1MODH:           equ    $0000000B                                ;*** TPM1MODH - TPM1 Timer Counter Modulo Register High; 0x0000000B ***


;*** TPM1MODL - TPM1 Timer Counter Modulo Register Low; 0x0000000C ***
TPM1MODL:           equ    $0000000C                                ;*** TPM1MODL - TPM1 Timer Counter Modulo Register Low; 0x0000000C ***


;*** TPM1C0SC - TPM1 Timer Channel 0 Status and Control Register; 0x0000000D ***
TPM1C0SC:           equ    $0000000D                                ;*** TPM1C0SC - TPM1 Timer Channel 0 Status and Control Register; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM1C0SC_ELS0A:     equ    2                                         ; Edge/Level Select Bit A
TPM1C0SC_ELS0B:     equ    3                                         ; Edge/Level Select Bit B
TPM1C0SC_MS0A:      equ    4                                         ; Mode Select A for TPM Channel 0
TPM1C0SC_MS0B:      equ    5                                         ; Mode Select B for TPM Channel 0
TPM1C0SC_CH0IE:     equ    6                                         ; Channel 0 Interrupt Enable
TPM1C0SC_CH0F:      equ    7                                         ; Channel 0 Flag
; bit position masks
mTPM1C0SC_ELS0A:    equ    %00000100
mTPM1C0SC_ELS0B:    equ    %00001000
mTPM1C0SC_MS0A:     equ    %00010000
mTPM1C0SC_MS0B:     equ    %00100000
mTPM1C0SC_CH0IE:    equ    %01000000
mTPM1C0SC_CH0F:     equ    %10000000


;*** TPM1C0V - TPM1 Timer Channel 0 Value Register; 0x0000000E ***
TPM1C0V:            equ    $0000000E                                ;*** TPM1C0V - TPM1 Timer Channel 0 Value Register; 0x0000000E ***


;*** TPM1C0VH - TPM1 Timer Channel 0 Value Register High; 0x0000000E ***
TPM1C0VH:           equ    $0000000E                                ;*** TPM1C0VH - TPM1 Timer Channel 0 Value Register High; 0x0000000E ***


;*** TPM1C0VL - TPM1 Timer Channel 0 Value Register Low; 0x0000000F ***
TPM1C0VL:           equ    $0000000F                                ;*** TPM1C0VL - TPM1 Timer Channel 0 Value Register Low; 0x0000000F ***


;*** TPM2SC - TPM2 Status and Control Register; 0x00000010 ***
TPM2SC:             equ    $00000010                                ;*** TPM2SC - TPM2 Status and Control Register; 0x00000010 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM2SC_PS0:         equ    0                                         ; Prescale Divisor Select Bit 0
TPM2SC_PS1:         equ    1                                         ; Prescale Divisor Select Bit 1
TPM2SC_PS2:         equ    2                                         ; Prescale Divisor Select Bit 2
TPM2SC_CLKSA:       equ    3                                         ; Clock Source Select A
TPM2SC_CLKSB:       equ    4                                         ; Clock Source Select B
TPM2SC_CPWMS:       equ    5                                         ; Center-Aligned PWM Select
TPM2SC_TOIE:        equ    6                                         ; Timer Overflow Interrupt Enable
TPM2SC_TOF:         equ    7                                         ; Timer Overflow Flag
; bit position masks
mTPM2SC_PS0:        equ    %00000001
mTPM2SC_PS1:        equ    %00000010
mTPM2SC_PS2:        equ    %00000100
mTPM2SC_CLKSA:      equ    %00001000
mTPM2SC_CLKSB:      equ    %00010000
mTPM2SC_CPWMS:      equ    %00100000
mTPM2SC_TOIE:       equ    %01000000
mTPM2SC_TOF:        equ    %10000000


;*** TPM2CNT - TPM2 Timer Counter Register; 0x00000011 ***
TPM2CNT:            equ    $00000011                                ;*** TPM2CNT - TPM2 Timer Counter Register; 0x00000011 ***


;*** TPM2CNTH - TPM2 Timer Counter Register High; 0x00000011 ***
TPM2CNTH:           equ    $00000011                                ;*** TPM2CNTH - TPM2 Timer Counter Register High; 0x00000011 ***


;*** TPM2CNTL - TPM2 Timer Counter Register Low; 0x00000012 ***
TPM2CNTL:           equ    $00000012                                ;*** TPM2CNTL - TPM2 Timer Counter Register Low; 0x00000012 ***


;*** TPM2MOD - TPM2 Timer Counter Modulo Register; 0x00000013 ***
TPM2MOD:            equ    $00000013                                ;*** TPM2MOD - TPM2 Timer Counter Modulo Register; 0x00000013 ***


;*** TPM2MODH - TPM2 Timer Counter Modulo Register High; 0x00000013 ***
TPM2MODH:           equ    $00000013                                ;*** TPM2MODH - TPM2 Timer Counter Modulo Register High; 0x00000013 ***


;*** TPM2MODL - TPM2 Timer Counter Modulo Register Low; 0x00000014 ***
TPM2MODL:           equ    $00000014                                ;*** TPM2MODL - TPM2 Timer Counter Modulo Register Low; 0x00000014 ***


;*** TPM2C0SC - TPM2 Timer Channel 0 Status and Control Register; 0x00000015 ***
TPM2C0SC:           equ    $00000015                                ;*** TPM2C0SC - TPM2 Timer Channel 0 Status and Control Register; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM2C0SC_ELS0A:     equ    2                                         ; Edge/Level Select Bit A
TPM2C0SC_ELS0B:     equ    3                                         ; Edge/Level Select Bit B
TPM2C0SC_MS0A:      equ    4                                         ; Mode Select A for TPM Channel 0
TPM2C0SC_MS0B:      equ    5                                         ; Mode Select B for TPM Channel 0
TPM2C0SC_CH0IE:     equ    6                                         ; Channel 0 Interrupt Enable
TPM2C0SC_CH0F:      equ    7                                         ; Channel 0 Flag
; bit position masks
mTPM2C0SC_ELS0A:    equ    %00000100
mTPM2C0SC_ELS0B:    equ    %00001000
mTPM2C0SC_MS0A:     equ    %00010000
mTPM2C0SC_MS0B:     equ    %00100000
mTPM2C0SC_CH0IE:    equ    %01000000
mTPM2C0SC_CH0F:     equ    %10000000


;*** TPM2C0V - TPM2 Timer Channel 0 Value Register; 0x00000016 ***
TPM2C0V:            equ    $00000016                                ;*** TPM2C0V - TPM2 Timer Channel 0 Value Register; 0x00000016 ***


;*** TPM2C0VH - TPM2 Timer Channel 0 Value Register High; 0x00000016 ***
TPM2C0VH:           equ    $00000016                                ;*** TPM2C0VH - TPM2 Timer Channel 0 Value Register High; 0x00000016 ***


;*** TPM2C0VL - TPM2 Timer Channel 0 Value Register Low; 0x00000017 ***
TPM2C0VL:           equ    $00000017                                ;*** TPM2C0VL - TPM2 Timer Channel 0 Value Register Low; 0x00000017 ***


;*** TPM3SC - TPM3 Status and Control Register; 0x00000018 ***
TPM3SC:             equ    $00000018                                ;*** TPM3SC - TPM3 Status and Control Register; 0x00000018 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM3SC_PS0:         equ    0                                         ; Prescale Divisor Select Bit 0
TPM3SC_PS1:         equ    1                                         ; Prescale Divisor Select Bit 1
TPM3SC_PS2:         equ    2                                         ; Prescale Divisor Select Bit 2
TPM3SC_CLKSA:       equ    3                                         ; Clock Source Select A
TPM3SC_CLKSB:       equ    4                                         ; Clock Source Select B
TPM3SC_CPWMS:       equ    5                                         ; Center-Aligned PWM Select
TPM3SC_TOIE:        equ    6                                         ; Timer Overflow Interrupt Enable
TPM3SC_TOF:         equ    7                                         ; Timer Overflow Flag
; bit position masks
mTPM3SC_PS0:        equ    %00000001
mTPM3SC_PS1:        equ    %00000010
mTPM3SC_PS2:        equ    %00000100
mTPM3SC_CLKSA:      equ    %00001000
mTPM3SC_CLKSB:      equ    %00010000
mTPM3SC_CPWMS:      equ    %00100000
mTPM3SC_TOIE:       equ    %01000000
mTPM3SC_TOF:        equ    %10000000


;*** TPM3CNT - TPM3 Timer Counter Register; 0x00000019 ***
TPM3CNT:            equ    $00000019                                ;*** TPM3CNT - TPM3 Timer Counter Register; 0x00000019 ***


;*** TPM3CNTH - TPM3 Timer Counter Register High; 0x00000019 ***
TPM3CNTH:           equ    $00000019                                ;*** TPM3CNTH - TPM3 Timer Counter Register High; 0x00000019 ***


;*** TPM3CNTL - TPM3 Timer Counter Register Low; 0x0000001A ***
TPM3CNTL:           equ    $0000001A                                ;*** TPM3CNTL - TPM3 Timer Counter Register Low; 0x0000001A ***


;*** TPM3MOD - TPM3 Timer Counter Modulo Register; 0x0000001B ***
TPM3MOD:            equ    $0000001B                                ;*** TPM3MOD - TPM3 Timer Counter Modulo Register; 0x0000001B ***


;*** TPM3MODH - TPM3 Timer Counter Modulo Register High; 0x0000001B ***
TPM3MODH:           equ    $0000001B                                ;*** TPM3MODH - TPM3 Timer Counter Modulo Register High; 0x0000001B ***


;*** TPM3MODL - TPM3 Timer Counter Modulo Register Low; 0x0000001C ***
TPM3MODL:           equ    $0000001C                                ;*** TPM3MODL - TPM3 Timer Counter Modulo Register Low; 0x0000001C ***


;*** TPM3C0SC - TPM3 Timer Channel 0 Status and Control Register; 0x0000001D ***
TPM3C0SC:           equ    $0000001D                                ;*** TPM3C0SC - TPM3 Timer Channel 0 Status and Control Register; 0x0000001D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM3C0SC_ELS0A:     equ    2                                         ; Edge/Level Select Bit A
TPM3C0SC_ELS0B:     equ    3                                         ; Edge/Level Select Bit B
TPM3C0SC_MS0A:      equ    4                                         ; Mode Select A for TPM Channel 0
TPM3C0SC_MS0B:      equ    5                                         ; Mode Select B for TPM Channel 0
TPM3C0SC_CH0IE:     equ    6                                         ; Channel 0 Interrupt Enable
TPM3C0SC_CH0F:      equ    7                                         ; Channel 0 Flag
; bit position masks
mTPM3C0SC_ELS0A:    equ    %00000100
mTPM3C0SC_ELS0B:    equ    %00001000
mTPM3C0SC_MS0A:     equ    %00010000
mTPM3C0SC_MS0B:     equ    %00100000
mTPM3C0SC_CH0IE:    equ    %01000000
mTPM3C0SC_CH0F:     equ    %10000000


;*** TPM3C0V - TPM3 Timer Channel 0 Value Register; 0x0000001E ***
TPM3C0V:            equ    $0000001E                                ;*** TPM3C0V - TPM3 Timer Channel 0 Value Register; 0x0000001E ***


;*** TPM3C0VH - TPM3 Timer Channel 0 Value Register High; 0x0000001E ***
TPM3C0VH:           equ    $0000001E                                ;*** TPM3C0VH - TPM3 Timer Channel 0 Value Register High; 0x0000001E ***


;*** TPM3C0VL - TPM3 Timer Channel 0 Value Register Low; 0x0000001F ***
TPM3C0VL:           equ    $0000001F                                ;*** TPM3C0VL - TPM3 Timer Channel 0 Value Register Low; 0x0000001F ***


;*** AES_CONTROL1 - AES 128 Control 1 Register; 0x00000020 ***
AES_CONTROL1:       equ    $00000020                                ;*** AES_CONTROL1 - AES 128 Control 1 Register; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
AES_CONTROL1_AES_MSK: equ    0                                       ; AES128 Interrupt Mask
AES_CONTROL1_LOAD_MAC: equ    1                                      ; MAC preload
AES_CONTROL1_AES:   equ    2                                         ; AES mode
AES_CONTROL1_CBC:   equ    3                                         ; CBC-MAC generation
AES_CONTROL1_CTR:   equ    4                                         ; Counter encryption mode
AES_CONTROL1_SELFTST: equ    5                                       ; Self test mode
AES_CONTROL1_START: equ    6                                         ; CBC or CTR or CCM or AES mode encryption start
AES_CONTROL1_CLEAR: equ    7                                         ; ASM memory clear
; bit position masks
mAES_CONTROL1_AES_MSK: equ    %00000001
mAES_CONTROL1_LOAD_MAC: equ    %00000010
mAES_CONTROL1_AES:  equ    %00000100
mAES_CONTROL1_CBC:  equ    %00001000
mAES_CONTROL1_CTR:  equ    %00010000
mAES_CONTROL1_SELFTST: equ    %00100000
mAES_CONTROL1_START: equ    %01000000
mAES_CONTROL1_CLEAR: equ    %10000000


;*** AES_CONTROL2 - AES 128 Control Register 2; 0x00000021 ***
AES_CONTROL2:       equ    $00000021                                ;*** AES_CONTROL2 - AES 128 Control Register 2; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
AES_CONTROL2_TSTPAS: equ    1                                        ; Self test passed
AES_CONTROL2_IRQ_FLAG: equ    2                                      ; AES Interrupt flag
AES_CONTROL2_DATA_REG_TYPE_SELECT0: equ    5                         ; This register selects the type of data to be written to or read from the 16x8 Data, bit 0
AES_CONTROL2_DATA_REG_TYPE_SELECT1: equ    6                         ; This register selects the type of data to be written to or read from the 16x8 Data, bit 1
AES_CONTROL2_DATA_REG_TYPE_SELECT2: equ    7                         ; This register selects the type of data to be written to or read from the 16x8 Data, bit 2
; bit position masks
mAES_CONTROL2_TSTPAS: equ    %00000010
mAES_CONTROL2_IRQ_FLAG: equ    %00000100
mAES_CONTROL2_DATA_REG_TYPE_SELECT0: equ    %00100000
mAES_CONTROL2_DATA_REG_TYPE_SELECT1: equ    %01000000
mAES_CONTROL2_DATA_REG_TYPE_SELECT2: equ    %10000000


;*** ASM_Data_0 - AES 128 Data Register 0; 0x00000022 ***
ASM_Data_0:         equ    $00000022                                ;*** ASM_Data_0 - AES 128 Data Register 0; 0x00000022 ***


;*** ASM_Data_1 - AES 128 Data Register 1; 0x00000023 ***
ASM_Data_1:         equ    $00000023                                ;*** ASM_Data_1 - AES 128 Data Register 1; 0x00000023 ***


;*** ASM_Data_2 - AES 128 Data Register 2; 0x00000024 ***
ASM_Data_2:         equ    $00000024                                ;*** ASM_Data_2 - AES 128 Data Register 2; 0x00000024 ***


;*** ASM_Data_3 - AES 128 Data Register 3; 0x00000025 ***
ASM_Data_3:         equ    $00000025                                ;*** ASM_Data_3 - AES 128 Data Register 3; 0x00000025 ***


;*** ASM_Data_4 - AES 128 Data Register 4; 0x00000026 ***
ASM_Data_4:         equ    $00000026                                ;*** ASM_Data_4 - AES 128 Data Register 4; 0x00000026 ***


;*** ASM_Data_5 - AES 128 Data Register 5; 0x00000027 ***
ASM_Data_5:         equ    $00000027                                ;*** ASM_Data_5 - AES 128 Data Register 5; 0x00000027 ***


;*** ASM_Data_6 - AES 128 Data Register 6; 0x00000028 ***
ASM_Data_6:         equ    $00000028                                ;*** ASM_Data_6 - AES 128 Data Register 6; 0x00000028 ***


;*** ASM_Data_7 - AES 128 Data Register 7; 0x00000029 ***
ASM_Data_7:         equ    $00000029                                ;*** ASM_Data_7 - AES 128 Data Register 7; 0x00000029 ***


;*** ASM_Data_8 - AES 128 Data Register 8; 0x0000002A ***
ASM_Data_8:         equ    $0000002A                                ;*** ASM_Data_8 - AES 128 Data Register 8; 0x0000002A ***


;*** ASM_Data_9 - AES 128 Data Register 9; 0x0000002B ***
ASM_Data_9:         equ    $0000002B                                ;*** ASM_Data_9 - AES 128 Data Register 9; 0x0000002B ***


;*** ASM_Data_A - AES 128 Data Register A; 0x0000002C ***
ASM_Data_A:         equ    $0000002C                                ;*** ASM_Data_A - AES 128 Data Register A; 0x0000002C ***


;*** ASM_Data_B - AES 128 Data Register B; 0x0000002D ***
ASM_Data_B:         equ    $0000002D                                ;*** ASM_Data_B - AES 128 Data Register B; 0x0000002D ***


;*** ASM_Data_C - AES 128 Data Register C; 0x0000002E ***
ASM_Data_C:         equ    $0000002E                                ;*** ASM_Data_C - AES 128 Data Register C; 0x0000002E ***


;*** ASM_Data_D - AES 128 Data Register D; 0x0000002F ***
ASM_Data_D:         equ    $0000002F                                ;*** ASM_Data_D - AES 128 Data Register D; 0x0000002F ***


;*** ASM_Data_E - AES 128 Data Register E; 0x00000030 ***
ASM_Data_E:         equ    $00000030                                ;*** ASM_Data_E - AES 128 Data Register E; 0x00000030 ***


;*** ASM_Data_F - AES 128 Data Register F; 0x00000031 ***
ASM_Data_F:         equ    $00000031                                ;*** ASM_Data_F - AES 128 Data Register F; 0x00000031 ***


;*** KBI1SC - KBI1 Status and Control Register; 0x00000032 ***
KBI1SC:             equ    $00000032                                ;*** KBI1SC - KBI1 Status and Control Register; 0x00000032 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBI1SC_KBIMOD:      equ    0                                         ; Keyboard Detection Mode
KBI1SC_KBIE:        equ    1                                         ; Keyboard Interrupt Enable
KBI1SC_KBACK:       equ    2                                         ; Keyboard Interrupt Acknowledge
KBI1SC_KBF:         equ    3                                         ; Keyboard Interrupt Flag
; bit position masks
mKBI1SC_KBIMOD:     equ    %00000001
mKBI1SC_KBIE:       equ    %00000010
mKBI1SC_KBACK:      equ    %00000100
mKBI1SC_KBF:        equ    %00001000


;*** KBI1PE - KBI1 Pin Enable Register; 0x00000033 ***
KBI1PE:             equ    $00000033                                ;*** KBI1PE - KBI1 Pin Enable Register; 0x00000033 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBI1PE_KBIPE0:      equ    0                                         ; Keyboard Pin Enable for KBI Port Bit 0
KBI1PE_KBIPE1:      equ    1                                         ; Keyboard Pin Enable for KBI Port Bit 1
KBI1PE_KBIPE2:      equ    2                                         ; Keyboard Pin Enable for KBI Port Bit 2
KBI1PE_KBIPE3:      equ    3                                         ; Keyboard Pin Enable for KBI Port Bit 3
KBI1PE_KBIPE4:      equ    4                                         ; Keyboard Pin Enable for KBI Port Bit 4
KBI1PE_KBIPE5:      equ    5                                         ; Keyboard Pin Enable for KBI Port Bit 5
KBI1PE_KBIPE6:      equ    6                                         ; Keyboard Pin Enable for KBI Port Bit 6
KBI1PE_KBIPE7:      equ    7                                         ; Keyboard Pin Enable for KBI Port Bit 7
; bit position masks
mKBI1PE_KBIPE0:     equ    %00000001
mKBI1PE_KBIPE1:     equ    %00000010
mKBI1PE_KBIPE2:     equ    %00000100
mKBI1PE_KBIPE3:     equ    %00001000
mKBI1PE_KBIPE4:     equ    %00010000
mKBI1PE_KBIPE5:     equ    %00100000
mKBI1PE_KBIPE6:     equ    %01000000
mKBI1PE_KBIPE7:     equ    %10000000


;*** KBI1ES - KBI1 Edge Select Register; 0x00000034 ***
KBI1ES:             equ    $00000034                                ;*** KBI1ES - KBI1 Edge Select Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBI1ES_KBEDG0:      equ    0                                         ; Keyboard Edge Select Bit 0
KBI1ES_KBEDG1:      equ    1                                         ; Keyboard Edge Select Bit 1
KBI1ES_KBEDG2:      equ    2                                         ; Keyboard Edge Select Bit 2
KBI1ES_KBEDG3:      equ    3                                         ; Keyboard Edge Select Bit 3
KBI1ES_KBEDG4:      equ    4                                         ; Keyboard Edge Select Bit 4
KBI1ES_KBEDG5:      equ    5                                         ; Keyboard Edge Select Bit 5
KBI1ES_KBEDG6:      equ    6                                         ; Keyboard Edge Select Bit 6
KBI1ES_KBEDG7:      equ    7                                         ; Keyboard Edge Select Bit 7
; bit position masks
mKBI1ES_KBEDG0:     equ    %00000001
mKBI1ES_KBEDG1:     equ    %00000010
mKBI1ES_KBEDG2:     equ    %00000100
mKBI1ES_KBEDG3:     equ    %00001000
mKBI1ES_KBEDG4:     equ    %00010000
mKBI1ES_KBEDG5:     equ    %00100000
mKBI1ES_KBEDG6:     equ    %01000000
mKBI1ES_KBEDG7:     equ    %10000000


;*** KBI2SC - KBI2 Status and Control Register; 0x00000035 ***
KBI2SC:             equ    $00000035                                ;*** KBI2SC - KBI2 Status and Control Register; 0x00000035 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBI2SC_KBIMOD:      equ    0                                         ; Keyboard Detection Mode
KBI2SC_KBIE:        equ    1                                         ; Keyboard Interrupt Enable
KBI2SC_KBACK:       equ    2                                         ; Keyboard Interrupt Acknowledge
KBI2SC_KBF:         equ    3                                         ; Keyboard Interrupt Flag
; bit position masks
mKBI2SC_KBIMOD:     equ    %00000001
mKBI2SC_KBIE:       equ    %00000010
mKBI2SC_KBACK:      equ    %00000100
mKBI2SC_KBF:        equ    %00001000


;*** KBI2PE - KBI2 Pin Enable Register; 0x00000036 ***
KBI2PE:             equ    $00000036                                ;*** KBI2PE - KBI2 Pin Enable Register; 0x00000036 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBI2PE_KBIPE0:      equ    0                                         ; Keyboard Pin Enable for KBI Port Bit 0
KBI2PE_KBIPE1:      equ    1                                         ; Keyboard Pin Enable for KBI Port Bit 1
KBI2PE_KBIPE2:      equ    2                                         ; Keyboard Pin Enable for KBI Port Bit 2
KBI2PE_KBIPE3:      equ    3                                         ; Keyboard Pin Enable for KBI Port Bit 3
; bit position masks
mKBI2PE_KBIPE0:     equ    %00000001
mKBI2PE_KBIPE1:     equ    %00000010
mKBI2PE_KBIPE2:     equ    %00000100
mKBI2PE_KBIPE3:     equ    %00001000


;*** KBI2ES - KBI2 Edge Select Register; 0x00000037 ***
KBI2ES:             equ    $00000037                                ;*** KBI2ES - KBI2 Edge Select Register; 0x00000037 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBI2ES_KBEDG0:      equ    0                                         ; Keyboard Edge Select Bit 0
KBI2ES_KBEDG1:      equ    1                                         ; Keyboard Edge Select Bit 1
KBI2ES_KBEDG2:      equ    2                                         ; Keyboard Edge Select Bit 2
KBI2ES_KBEDG3:      equ    3                                         ; Keyboard Edge Select Bit 3
; bit position masks
mKBI2ES_KBEDG0:     equ    %00000001
mKBI2ES_KBEDG1:     equ    %00000010
mKBI2ES_KBEDG2:     equ    %00000100
mKBI2ES_KBEDG3:     equ    %00001000


;*** SCIBD - SCI Baud Rate Register; 0x00000038 ***
SCIBD:              equ    $00000038                                ;*** SCIBD - SCI Baud Rate Register; 0x00000038 ***


;*** SCIBDH - SCI Baud Rate Register High; 0x00000038 ***
SCIBDH:             equ    $00000038                                ;*** SCIBDH - SCI Baud Rate Register High; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBDH_SBR8:        equ    0                                         ; Baud Rate Modulo Divisor Bit 8
SCIBDH_SBR9:        equ    1                                         ; Baud Rate Modulo Divisor Bit 9
SCIBDH_SBR10:       equ    2                                         ; Baud Rate Modulo Divisor Bit 10
SCIBDH_SBR11:       equ    3                                         ; Baud Rate Modulo Divisor Bit 11
SCIBDH_SBR12:       equ    4                                         ; Baud Rate Modulo Divisor Bit 12
SCIBDH_RXEDGIE:     equ    6                                         ; RxD Input Active Edge Interrupt Enable (for RXEDGIF)
SCIBDH_LBKDIE:      equ    7                                         ; LIN Break Detect Interrupt Enable (for LBKDIF)
; bit position masks
mSCIBDH_SBR8:       equ    %00000001
mSCIBDH_SBR9:       equ    %00000010
mSCIBDH_SBR10:      equ    %00000100
mSCIBDH_SBR11:      equ    %00001000
mSCIBDH_SBR12:      equ    %00010000
mSCIBDH_RXEDGIE:    equ    %01000000
mSCIBDH_LBKDIE:     equ    %10000000


;*** SCIBDL - SCI Baud Rate Register Low; 0x00000039 ***
SCIBDL:             equ    $00000039                                ;*** SCIBDL - SCI Baud Rate Register Low; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBDL_SBR0:        equ    0                                         ; Baud Rate Modulo Divisor Bit 0
SCIBDL_SBR1:        equ    1                                         ; Baud Rate Modulo Divisor Bit 1
SCIBDL_SBR2:        equ    2                                         ; Baud Rate Modulo Divisor Bit 2
SCIBDL_SBR3:        equ    3                                         ; Baud Rate Modulo Divisor Bit 3
SCIBDL_SBR4:        equ    4                                         ; Baud Rate Modulo Divisor Bit 4
SCIBDL_SBR5:        equ    5                                         ; Baud Rate Modulo Divisor Bit 5
SCIBDL_SBR6:        equ    6                                         ; Baud Rate Modulo Divisor Bit 6
SCIBDL_SBR7:        equ    7                                         ; Baud Rate Modulo Divisor Bit 7
; bit position masks
mSCIBDL_SBR0:       equ    %00000001
mSCIBDL_SBR1:       equ    %00000010
mSCIBDL_SBR2:       equ    %00000100
mSCIBDL_SBR3:       equ    %00001000
mSCIBDL_SBR4:       equ    %00010000
mSCIBDL_SBR5:       equ    %00100000
mSCIBDL_SBR6:       equ    %01000000
mSCIBDL_SBR7:       equ    %10000000


;*** SCIC1 - SCI Control Register 1; 0x0000003A ***
SCIC1:              equ    $0000003A                                ;*** SCIC1 - SCI Control Register 1; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIC1_PT:           equ    0                                         ; Parity Type
SCIC1_PE:           equ    1                                         ; Parity Enable
SCIC1_ILT:          equ    2                                         ; Idle Line Type Select
SCIC1_WAKE:         equ    3                                         ; Receiver Wakeup Method Select
SCIC1_M:            equ    4                                         ; 9-Bit or 8-Bit Mode Select
SCIC1_RSRC:         equ    5                                         ; Receiver Source Select
SCIC1_SCISWAI:      equ    6                                         ; SCI Stops in Wait Mode
SCIC1_LOOPS:        equ    7                                         ; Loop Mode Select
; bit position masks
mSCIC1_PT:          equ    %00000001
mSCIC1_PE:          equ    %00000010
mSCIC1_ILT:         equ    %00000100
mSCIC1_WAKE:        equ    %00001000
mSCIC1_M:           equ    %00010000
mSCIC1_RSRC:        equ    %00100000
mSCIC1_SCISWAI:     equ    %01000000
mSCIC1_LOOPS:       equ    %10000000


;*** SCIC2 - SCI Control Register 2; 0x0000003B ***
SCIC2:              equ    $0000003B                                ;*** SCIC2 - SCI Control Register 2; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIC2_SBK:          equ    0                                         ; Send Break
SCIC2_RWU:          equ    1                                         ; Receiver Wakeup Control
SCIC2_RE:           equ    2                                         ; Receiver Enable
SCIC2_TE:           equ    3                                         ; Transmitter Enable
SCIC2_ILIE:         equ    4                                         ; Idle Line Interrupt Enable (for IDLE)
SCIC2_RIE:          equ    5                                         ; Receiver Interrupt Enable (for RDRF)
SCIC2_TCIE:         equ    6                                         ; Transmission Complete Interrupt Enable (for TC)
SCIC2_TIE:          equ    7                                         ; Transmit Interrupt Enable (for TDRE)
; bit position masks
mSCIC2_SBK:         equ    %00000001
mSCIC2_RWU:         equ    %00000010
mSCIC2_RE:          equ    %00000100
mSCIC2_TE:          equ    %00001000
mSCIC2_ILIE:        equ    %00010000
mSCIC2_RIE:         equ    %00100000
mSCIC2_TCIE:        equ    %01000000
mSCIC2_TIE:         equ    %10000000


;*** SCIS1 - SCI Status Register 1; 0x0000003C ***
SCIS1:              equ    $0000003C                                ;*** SCIS1 - SCI Status Register 1; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIS1_PF:           equ    0                                         ; Parity Error Flag
SCIS1_FE:           equ    1                                         ; Framing Error Flag
SCIS1_NF:           equ    2                                         ; Noise Flag
SCIS1_OR:           equ    3                                         ; Receiver Overrun Flag
SCIS1_IDLE:         equ    4                                         ; Idle Line Flag
SCIS1_RDRF:         equ    5                                         ; Receive Data Register Full Flag
SCIS1_TC:           equ    6                                         ; Transmission Complete Flag
SCIS1_TDRE:         equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCIS1_PF:          equ    %00000001
mSCIS1_FE:          equ    %00000010
mSCIS1_NF:          equ    %00000100
mSCIS1_OR:          equ    %00001000
mSCIS1_IDLE:        equ    %00010000
mSCIS1_RDRF:        equ    %00100000
mSCIS1_TC:          equ    %01000000
mSCIS1_TDRE:        equ    %10000000


;*** SCIS2 - SCI Status Register 2; 0x0000003D ***
SCIS2:              equ    $0000003D                                ;*** SCIS2 - SCI Status Register 2; 0x0000003D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIS2_RAF:          equ    0                                         ; Receiver Active Flag
SCIS2_LBKDE:        equ    1                                         ; LIN Break Detection Enable
SCIS2_BRK13:        equ    2                                         ; Break Character Generation Length
SCIS2_RWUID:        equ    3                                         ; Receive Wake Up Idle Detect
SCIS2_RXINV:        equ    4                                         ; Receive Data Inversion
SCIS2_RXEDGIF:      equ    6                                         ; RxD Pin Active Edge Interrupt Flag
SCIS2_LBKDIF:       equ    7                                         ; LIN Break Detect Interrupt Flag
; bit position masks
mSCIS2_RAF:         equ    %00000001
mSCIS2_LBKDE:       equ    %00000010
mSCIS2_BRK13:       equ    %00000100
mSCIS2_RWUID:       equ    %00001000
mSCIS2_RXINV:       equ    %00010000
mSCIS2_RXEDGIF:     equ    %01000000
mSCIS2_LBKDIF:      equ    %10000000


;*** SCIC3 - SCI Control Register 3; 0x0000003E ***
SCIC3:              equ    $0000003E                                ;*** SCIC3 - SCI Control Register 3; 0x0000003E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIC3_PEIE:         equ    0                                         ; Parity Error Interrupt Enable
SCIC3_FEIE:         equ    1                                         ; Framing Error Interrupt Enable
SCIC3_NEIE:         equ    2                                         ; Noise Error Interrupt Enable
SCIC3_ORIE:         equ    3                                         ; Overrun Interrupt Enable
SCIC3_TXINV:        equ    4                                         ; Transmit Data Inversion
SCIC3_TXDIR:        equ    5                                         ; TxD Pin Direction in Single-Wire Mode
SCIC3_T8:           equ    6                                         ; Ninth Data Bit for Transmitter
SCIC3_R8:           equ    7                                         ; Ninth Data Bit for Receiver
; bit position masks
mSCIC3_PEIE:        equ    %00000001
mSCIC3_FEIE:        equ    %00000010
mSCIC3_NEIE:        equ    %00000100
mSCIC3_ORIE:        equ    %00001000
mSCIC3_TXINV:       equ    %00010000
mSCIC3_TXDIR:       equ    %00100000
mSCIC3_T8:          equ    %01000000
mSCIC3_R8:          equ    %10000000


;*** SCID - SCI Data Register; 0x0000003F ***
SCID:               equ    $0000003F                                ;*** SCID - SCI Data Register; 0x0000003F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCID_R0_T0:         equ    0                                         ; Receive/Transmit Data Bit 0
SCID_R1_T1:         equ    1                                         ; Receive/Transmit Data Bit 1
SCID_R2_T2:         equ    2                                         ; Receive/Transmit Data Bit 2
SCID_R3_T3:         equ    3                                         ; Receive/Transmit Data Bit 3
SCID_R4_T4:         equ    4                                         ; Receive/Transmit Data Bit 4
SCID_R5_T5:         equ    5                                         ; Receive/Transmit Data Bit 5
SCID_R6_T6:         equ    6                                         ; Receive/Transmit Data Bit 6
SCID_R7_T7:         equ    7                                         ; Receive/Transmit Data Bit 7
; bit position masks
mSCID_R0_T0:        equ    %00000001
mSCID_R1_T1:        equ    %00000010
mSCID_R2_T2:        equ    %00000100
mSCID_R3_T3:        equ    %00001000
mSCID_R4_T4:        equ    %00010000
mSCID_R5_T5:        equ    %00100000
mSCID_R6_T6:        equ    %01000000
mSCID_R7_T7:        equ    %10000000


;*** PHY_TXD_ADR_PNTR0 - ; 0x00000040 ***
PHY_TXD_ADR_PNTR0:  equ    $00000040                                ;*** PHY_TXD_ADR_PNTR0 - ; 0x00000040 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PHY_TXD_ADR_PNTR0_TXD_ADR_PNTR: equ    0             
; bit position masks
mPHY_TXD_ADR_PNTR0_TXD_ADR_PNTR: equ    %00011111


;*** PHY_TXD_ADR_PNTR1 - ; 0x00000041 ***
PHY_TXD_ADR_PNTR1:  equ    $00000041                                ;*** PHY_TXD_ADR_PNTR1 - ; 0x00000041 ***


;*** PHY_RXD_ADR_PNTR0 - ; 0x00000042 ***
PHY_RXD_ADR_PNTR0:  equ    $00000042                                ;*** PHY_RXD_ADR_PNTR0 - ; 0x00000042 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PHY_RXD_ADR_PNTR0_RXD_ADR_PNTR0: equ    0             
; bit position masks
mPHY_RXD_ADR_PNTR0_RXD_ADR_PNTR0: equ    %00011111


;*** PHY_RXD_ADR_PNTR1 - ; 0x00000043 ***
PHY_RXD_ADR_PNTR1:  equ    $00000043                                ;*** PHY_RXD_ADR_PNTR1 - ; 0x00000043 ***


;*** PHY_CNTRL1 - ; 0x00000044 ***
PHY_CNTRL1:         equ    $00000044                                ;*** PHY_CNTRL1 - ; 0x00000044 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PHY_CNTRL1_XCVSEQ0: equ    0                                         ; , bit 0
PHY_CNTRL1_XCVSEQ1: equ    1                                         ; , bit 1
PHY_CNTRL1_XCVSEQ2: equ    2                                         ; , bit 2
PHY_CNTRL1_AUTOACK: equ    3             
PHY_CNTRL1_RXACKRQD: equ    4             
PHY_CNTRL1_CCABFRTX: equ    5             
PHY_CNTRL1_SLOTTED: equ    6             
PHY_CNTRL1_TMRTRIGEN: equ    7             
; bit position masks
mPHY_CNTRL1_XCVSEQ0: equ    %00000001
mPHY_CNTRL1_XCVSEQ1: equ    %00000010
mPHY_CNTRL1_XCVSEQ2: equ    %00000100
mPHY_CNTRL1_AUTOACK: equ    %00001000
mPHY_CNTRL1_RXACKRQD: equ    %00010000
mPHY_CNTRL1_CCABFRTX: equ    %00100000
mPHY_CNTRL1_SLOTTED: equ    %01000000
mPHY_CNTRL1_TMRTRIGEN: equ    %10000000


;*** PHY_CNTRL2 - ; 0x00000045 ***
PHY_CNTRL2:         equ    $00000045                                ;*** PHY_CNTRL2 - ; 0x00000045 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PHY_CNTRL2_TC2EN:   equ    0             
PHY_CNTRL2_PROMISCUOUS: equ    1             
PHY_CNTRL2_TMRLOAD: equ    2             
PHY_CNTRL2_CCATYPE0: equ    3                                        ; , bit 0
PHY_CNTRL2_CCATYPE1: equ    4                                        ; , bit 1
PHY_CNTRL2_PANCORDNTR: equ    5             
PHY_CNTRL2_TC3TMOUT: equ    6             
PHY_CNTRL2_TRCV_RST: equ    7             
; bit position masks
mPHY_CNTRL2_TC2EN:  equ    %00000001
mPHY_CNTRL2_PROMISCUOUS: equ    %00000010
mPHY_CNTRL2_TMRLOAD: equ    %00000100
mPHY_CNTRL2_CCATYPE0: equ    %00001000
mPHY_CNTRL2_CCATYPE1: equ    %00010000
mPHY_CNTRL2_PANCORDNTR: equ    %00100000
mPHY_CNTRL2_TC3TMOUT: equ    %01000000
mPHY_CNTRL2_TRCV_RST: equ    %10000000


;*** PHY_CNTRL3 - ; 0x00000046 ***
PHY_CNTRL3:         equ    $00000046                                ;*** PHY_CNTRL3 - ; 0x00000046 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PHY_CNTRL3_SEQMSK:  equ    0             
PHY_CNTRL3_TXMSK:   equ    1             
PHY_CNTRL3_RXMSK:   equ    2             
PHY_CNTRL3_CCAMSK:  equ    3             
PHY_CNTRL3_RX_WMRK_MSK: equ    4             
PHY_CNTRL3_FILTERFAIL_MSK: equ    5             
PHY_CNTRL3_LO1_UNLOCK_MSK: equ    6             
PHY_CNTRL3_CRC_MSK: equ    7             
; bit position masks
mPHY_CNTRL3_SEQMSK: equ    %00000001
mPHY_CNTRL3_TXMSK:  equ    %00000010
mPHY_CNTRL3_RXMSK:  equ    %00000100
mPHY_CNTRL3_CCAMSK: equ    %00001000
mPHY_CNTRL3_RX_WMRK_MSK: equ    %00010000
mPHY_CNTRL3_FILTERFAIL_MSK: equ    %00100000
mPHY_CNTRL3_LO1_UNLOCK_MSK: equ    %01000000
mPHY_CNTRL3_CRC_MSK: equ    %10000000


;*** PHY_CNTRL4 - ; 0x00000047 ***
PHY_CNTRL4:         equ    $00000047                                ;*** PHY_CNTRL4 - ; 0x00000047 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PHY_CNTRL4_TMR1CMP_EN: equ    0             
PHY_CNTRL4_TMR2CMP_EN: equ    1             
PHY_CNTRL4_TMR3CMP_EN: equ    2             
PHY_CNTRL4_TMR4CMP_EN: equ    3             
PHY_CNTRL4_TMR1MSK: equ    4             
PHY_CNTRL4_TMR2MSK: equ    5             
PHY_CNTRL4_TMR3MSK: equ    6             
PHY_CNTRL4_TMR4MSK: equ    7             
; bit position masks
mPHY_CNTRL4_TMR1CMP_EN: equ    %00000001
mPHY_CNTRL4_TMR2CMP_EN: equ    %00000010
mPHY_CNTRL4_TMR3CMP_EN: equ    %00000100
mPHY_CNTRL4_TMR4CMP_EN: equ    %00001000
mPHY_CNTRL4_TMR1MSK: equ    %00010000
mPHY_CNTRL4_TMR2MSK: equ    %00100000
mPHY_CNTRL4_TMR3MSK: equ    %01000000
mPHY_CNTRL4_TMR4MSK: equ    %10000000


;*** PHY_SRC_CNTRL - ; 0x00000048 ***
PHY_SRC_CNTRL:      equ    $00000048                                ;*** PHY_SRC_CNTRL - ; 0x00000048 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PHY_SRC_CNTRL_INDEX_DISABLE: equ    0             
PHY_SRC_CNTRL_INDEX_EN: equ    1             
PHY_SRC_CNTRL_SRCADDR_EN: equ    2             
PHY_SRC_CNTRL_ACK_FRM_PND: equ    3             
PHY_SRC_CNTRL_INDEX0: equ    4                                       ; , bit 0
PHY_SRC_CNTRL_INDEX1: equ    5                                       ; , bit 1
PHY_SRC_CNTRL_INDEX2: equ    6                                       ; , bit 2
PHY_SRC_CNTRL_INDEX3: equ    7                                       ; , bit 3
; bit position masks
mPHY_SRC_CNTRL_INDEX_DISABLE: equ    %00000001
mPHY_SRC_CNTRL_INDEX_EN: equ    %00000010
mPHY_SRC_CNTRL_SRCADDR_EN: equ    %00000100
mPHY_SRC_CNTRL_ACK_FRM_PND: equ    %00001000
mPHY_SRC_CNTRL_INDEX0: equ    %00010000
mPHY_SRC_CNTRL_INDEX1: equ    %00100000
mPHY_SRC_CNTRL_INDEX2: equ    %01000000
mPHY_SRC_CNTRL_INDEX3: equ    %10000000


;*** PHY_SRC_ADDRS_SUM_DATA0 - ; 0x00000049 ***
PHY_SRC_ADDRS_SUM_DATA0: equ    $00000049                           ;*** PHY_SRC_ADDRS_SUM_DATA0 - ; 0x00000049 ***


;*** PHY_SRC_ADDRS_SUM_DATA1 - ; 0x0000004A ***
PHY_SRC_ADDRS_SUM_DATA1: equ    $0000004A                           ;*** PHY_SRC_ADDRS_SUM_DATA1 - ; 0x0000004A ***


;*** PHY_RX_WTR_MARK - ; 0x0000004B ***
PHY_RX_WTR_MARK:    equ    $0000004B                                ;*** PHY_RX_WTR_MARK - ; 0x0000004B ***


;*** PHY_RX_BYTE_COUNT - ; 0x0000004C ***
PHY_RX_BYTE_COUNT:  equ    $0000004C                                ;*** PHY_RX_BYTE_COUNT - ; 0x0000004C ***


;*** PHY_STATUS1 - ; 0x0000004D ***
PHY_STATUS1:        equ    $0000004D                                ;*** PHY_STATUS1 - ; 0x0000004D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PHY_STATUS1_TMR1IRQ: equ    0             
PHY_STATUS1_TMR2IRQ: equ    1             
PHY_STATUS1_TMR3IRQ: equ    2             
PHY_STATUS1_TMR4IRQ: equ    3             
PHY_STATUS1_PI:     equ    4             
PHY_STATUS1_SRCADDR: equ    5             
PHY_STATUS1_CCA:    equ    6             
PHY_STATUS1_CRCVALID: equ    7             
; bit position masks
mPHY_STATUS1_TMR1IRQ: equ    %00000001
mPHY_STATUS1_TMR2IRQ: equ    %00000010
mPHY_STATUS1_TMR3IRQ: equ    %00000100
mPHY_STATUS1_TMR4IRQ: equ    %00001000
mPHY_STATUS1_PI:    equ    %00010000
mPHY_STATUS1_SRCADDR: equ    %00100000
mPHY_STATUS1_CCA:   equ    %01000000
mPHY_STATUS1_CRCVALID: equ    %10000000


;*** PHY_STATUS2 - ; 0x0000004E ***
PHY_STATUS2:        equ    $0000004E                                ;*** PHY_STATUS2 - ; 0x0000004E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PHY_STATUS2_SEQIRQ: equ    0             
PHY_STATUS2_TXIRQ:  equ    1             
PHY_STATUS2_RXIRQ:  equ    2             
PHY_STATUS2_CCAIRQ: equ    3             
PHY_STATUS2_RXWTRMRKIRQ: equ    4             
PHY_STATUS2_FILTERFAIL_IRQ: equ    5             
PHY_STATUS2_LO1_UNLOCK_IRQ: equ    6             
PHY_STATUS2_RX_FRM_PEND: equ    7             
; bit position masks
mPHY_STATUS2_SEQIRQ: equ    %00000001
mPHY_STATUS2_TXIRQ: equ    %00000010
mPHY_STATUS2_RXIRQ: equ    %00000100
mPHY_STATUS2_CCAIRQ: equ    %00001000
mPHY_STATUS2_RXWTRMRKIRQ: equ    %00010000
mPHY_STATUS2_FILTERFAIL_IRQ: equ    %00100000
mPHY_STATUS2_LO1_UNLOCK_IRQ: equ    %01000000
mPHY_STATUS2_RX_FRM_PEND: equ    %10000000


;*** PHY_CCAFNL - ; 0x00000050 ***
PHY_CCAFNL:         equ    $00000050                                ;*** PHY_CCAFNL - ; 0x00000050 ***


;*** PHY_EVENT_TMR0 - ; 0x00000051 ***
PHY_EVENT_TMR0:     equ    $00000051                                ;*** PHY_EVENT_TMR0 - ; 0x00000051 ***


;*** PHY_EVENT_TMR1 - ; 0x00000052 ***
PHY_EVENT_TMR1:     equ    $00000052                                ;*** PHY_EVENT_TMR1 - ; 0x00000052 ***


;*** PHY_EVENT_TMR2 - ; 0x00000053 ***
PHY_EVENT_TMR2:     equ    $00000053                                ;*** PHY_EVENT_TMR2 - ; 0x00000053 ***


;*** PHY_TIMESTAMP0 - ; 0x00000054 ***
PHY_TIMESTAMP0:     equ    $00000054                                ;*** PHY_TIMESTAMP0 - ; 0x00000054 ***


;*** PHY_TIMESTAMP1 - ; 0x00000055 ***
PHY_TIMESTAMP1:     equ    $00000055                                ;*** PHY_TIMESTAMP1 - ; 0x00000055 ***


;*** PHY_TIMESTAMP2 - ; 0x00000056 ***
PHY_TIMESTAMP2:     equ    $00000056                                ;*** PHY_TIMESTAMP2 - ; 0x00000056 ***


;*** PHY_T3CMP0 - ; 0x00000057 ***
PHY_T3CMP0:         equ    $00000057                                ;*** PHY_T3CMP0 - ; 0x00000057 ***


;*** PHY_T3CMP1 - ; 0x00000058 ***
PHY_T3CMP1:         equ    $00000058                                ;*** PHY_T3CMP1 - ; 0x00000058 ***


;*** PHY_T3CMP2 - ; 0x00000059 ***
PHY_T3CMP2:         equ    $00000059                                ;*** PHY_T3CMP2 - ; 0x00000059 ***


;*** PHY_TC2_PRIME0 - ; 0x0000005A ***
PHY_TC2_PRIME0:     equ    $0000005A                                ;*** PHY_TC2_PRIME0 - ; 0x0000005A ***


;*** PHY_TC2_PRIME1 - ; 0x0000005B ***
PHY_TC2_PRIME1:     equ    $0000005B                                ;*** PHY_TC2_PRIME1 - ; 0x0000005B ***


;*** PHY_MACSHORTADDRS0 - ; 0x0000005C ***
PHY_MACSHORTADDRS0: equ    $0000005C                                ;*** PHY_MACSHORTADDRS0 - ; 0x0000005C ***


;*** PHY_MACSHORTADDRS1 - ; 0x0000005D ***
PHY_MACSHORTADDRS1: equ    $0000005D                                ;*** PHY_MACSHORTADDRS1 - ; 0x0000005D ***


;*** PHY_MACPANID0 - ; 0x0000005E ***
PHY_MACPANID0:      equ    $0000005E                                ;*** PHY_MACPANID0 - ; 0x0000005E ***


;*** PHY_MACPANID1 - ; 0x0000005F ***
PHY_MACPANID1:      equ    $0000005F                                ;*** PHY_MACPANID1 - ; 0x0000005F ***


;*** CMTCG1 - Carrier Generator Data Register 1; 0x00000060 ***
CMTCG1:             equ    $00000060                                ;*** CMTCG1 - Carrier Generator Data Register 1; 0x00000060 ***


;*** CMTCGH1 - CMT Carrier Generator Data Register 1 High Byte; 0x00000060 ***
CMTCGH1:            equ    $00000060                                ;*** CMTCGH1 - CMT Carrier Generator Data Register 1 High Byte; 0x00000060 ***


;*** CMTCGL1 - CMT Carrier Generator Data Register 1 Low Byte; 0x00000061 ***
CMTCGL1:            equ    $00000061                                ;*** CMTCGL1 - CMT Carrier Generator Data Register 1 Low Byte; 0x00000061 ***


;*** CMTCG2 - Carrier Generator Data Register 2; 0x00000062 ***
CMTCG2:             equ    $00000062                                ;*** CMTCG2 - Carrier Generator Data Register 2; 0x00000062 ***


;*** CMTCGH2 - CMT Carrier Generator Data Register 2 High Byte; 0x00000062 ***
CMTCGH2:            equ    $00000062                                ;*** CMTCGH2 - CMT Carrier Generator Data Register 2 High Byte; 0x00000062 ***


;*** CMTCGL2 - CMT Carrier Generator Data Register 2 Low Byte; 0x00000063 ***
CMTCGL2:            equ    $00000063                                ;*** CMTCGL2 - CMT Carrier Generator Data Register 2 Low Byte; 0x00000063 ***


;*** CMTOC - CMT Output Control Register; 0x00000064 ***
CMTOC:              equ    $00000064                                ;*** CMTOC - CMT Output Control Register; 0x00000064 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CMTOC_CMTDIV2:      equ    4                                         ; CMT Clock Divide Prescaler Bit 2
CMTOC_IROPEN:       equ    5                                         ; IRO pin enable
CMTOC_CMTPOL:       equ    6                                         ; CMT output polarity
CMTOC_IROL:         equ    7                                         ; IRO latch control
; bit position masks
mCMTOC_CMTDIV2:     equ    %00010000
mCMTOC_IROPEN:      equ    %00100000
mCMTOC_CMTPOL:      equ    %01000000
mCMTOC_IROL:        equ    %10000000


;*** CMTMSC - CMT Modulator Status and Control Register; 0x00000065 ***
CMTMSC:             equ    $00000065                                ;*** CMTMSC - CMT Modulator Status and Control Register; 0x00000065 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CMTMSC_MCGEN:       equ    0                                         ; Modulator and Carrier Generator Enable
CMTMSC_EOCIE:       equ    1                                         ; End of Cycle Interrupt Enable
CMTMSC_FSK:         equ    2                                         ; FSK Mode Select
CMTMSC_BASE:        equ    3                                         ; Baseband Mode Enable
CMTMSC_EXSPC:       equ    4                                         ; Extended Space Enable
CMTMSC_CMTDIV0:     equ    5                                         ; CMT Clock Divide Prescaler Bit 0
CMTMSC_CMTDIV1:     equ    6                                         ; CMT Clock Divide Prescaler Bit 1
CMTMSC_EOCF:        equ    7                                         ; End of Cycle Status Flag
; bit position masks
mCMTMSC_MCGEN:      equ    %00000001
mCMTMSC_EOCIE:      equ    %00000010
mCMTMSC_FSK:        equ    %00000100
mCMTMSC_BASE:       equ    %00001000
mCMTMSC_EXSPC:      equ    %00010000
mCMTMSC_CMTDIV0:    equ    %00100000
mCMTMSC_CMTDIV1:    equ    %01000000
mCMTMSC_EOCF:       equ    %10000000


;*** CMTCMD12 - CMT Modulator Data Register 12; 0x00000066 ***
CMTCMD12:           equ    $00000066                                ;*** CMTCMD12 - CMT Modulator Data Register 12; 0x00000066 ***


;*** CMTCMD1 - CMT Modulator Data Register 1; 0x00000066 ***
CMTCMD1:            equ    $00000066                                ;*** CMTCMD1 - CMT Modulator Data Register 1; 0x00000066 ***


;*** CMTCMD2 - CMT Modulator Data Register 2; 0x00000067 ***
CMTCMD2:            equ    $00000067                                ;*** CMTCMD2 - CMT Modulator Data Register 2; 0x00000067 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CMTCMD2_MB0:        equ    0                                         ; Data Value Bit 0
CMTCMD2_MB1:        equ    1                                         ; Data Value Bit 1
CMTCMD2_MB2:        equ    2                                         ; Data Value Bit 2
CMTCMD2_MB3:        equ    3                                         ; Data Value Bit 3
CMTCMD2_MB4:        equ    4                                         ; Data Value Bit 4
CMTCMD2_MB5:        equ    5                                         ; Data Value Bit 5
CMTCMD2_MB6:        equ    6                                         ; Data Value Bit 6
CMTCMD2_MB7:        equ    7                                         ; Data Value Bit 7
; bit position masks
mCMTCMD2_MB0:       equ    %00000001
mCMTCMD2_MB1:       equ    %00000010
mCMTCMD2_MB2:       equ    %00000100
mCMTCMD2_MB3:       equ    %00001000
mCMTCMD2_MB4:       equ    %00010000
mCMTCMD2_MB5:       equ    %00100000
mCMTCMD2_MB6:       equ    %01000000
mCMTCMD2_MB7:       equ    %10000000


;*** CMTCMD34 - CMT Modulator Data Register 34; 0x00000068 ***
CMTCMD34:           equ    $00000068                                ;*** CMTCMD34 - CMT Modulator Data Register 34; 0x00000068 ***


;*** CMTCMD3 - CMT Modulator Data Register 3; 0x00000068 ***
CMTCMD3:            equ    $00000068                                ;*** CMTCMD3 - CMT Modulator Data Register 3; 0x00000068 ***


;*** CMTCMD4 - CMT Modulator Data Register 4; 0x00000069 ***
CMTCMD4:            equ    $00000069                                ;*** CMTCMD4 - CMT Modulator Data Register 4; 0x00000069 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
CMTCMD4_SB0:        equ    0                                         ; Data Value Bit 0
CMTCMD4_SB1:        equ    1                                         ; Data Value Bit 1
CMTCMD4_SB2:        equ    2                                         ; Data Value Bit 2
CMTCMD4_SB3:        equ    3                                         ; Data Value Bit 3
CMTCMD4_SB4:        equ    4                                         ; Data Value Bit 4
CMTCMD4_SB5:        equ    5                                         ; Data Value Bit 5
CMTCMD4_SB6:        equ    6                                         ; Data Value Bit 6
CMTCMD4_SB7:        equ    7                                         ; Data Value Bit 7
; bit position masks
mCMTCMD4_SB0:       equ    %00000001
mCMTCMD4_SB1:       equ    %00000010
mCMTCMD4_SB2:       equ    %00000100
mCMTCMD4_SB3:       equ    %00001000
mCMTCMD4_SB4:       equ    %00010000
mCMTCMD4_SB5:       equ    %00100000
mCMTCMD4_SB6:       equ    %01000000
mCMTCMD4_SB7:       equ    %10000000


;*** IICA - IIC Address Register; 0x0000006A ***
IICA:               equ    $0000006A                                ;*** IICA - IIC Address Register; 0x0000006A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICA_AD1:           equ    1                                         ; Slave Address Bit 1
IICA_AD2:           equ    2                                         ; Slave Address Bit 2
IICA_AD3:           equ    3                                         ; Slave Address Bit 3
IICA_AD4:           equ    4                                         ; Slave Address Bit 4
IICA_AD5:           equ    5                                         ; Slave Address Bit 5
IICA_AD6:           equ    6                                         ; Slave Address Bit 6
IICA_AD7:           equ    7                                         ; Slave Address Bit 7
; bit position masks
mIICA_AD1:          equ    %00000010
mIICA_AD2:          equ    %00000100
mIICA_AD3:          equ    %00001000
mIICA_AD4:          equ    %00010000
mIICA_AD5:          equ    %00100000
mIICA_AD6:          equ    %01000000
mIICA_AD7:          equ    %10000000


;*** IICF - IIC Frequency Divider Register; 0x0000006B ***
IICF:               equ    $0000006B                                ;*** IICF - IIC Frequency Divider Register; 0x0000006B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICF_ICR0:          equ    0                                         ; IIC Clock Rate Bit 0
IICF_ICR1:          equ    1                                         ; IIC Clock Rate Bit 1
IICF_ICR2:          equ    2                                         ; IIC Clock Rate Bit 2
IICF_ICR3:          equ    3                                         ; IIC Clock Rate Bit 3
IICF_ICR4:          equ    4                                         ; IIC Clock Rate Bit 4
IICF_ICR5:          equ    5                                         ; IIC Clock Rate Bit 5
IICF_MULT0:         equ    6                                         ; Multiplier Factor Bit 0
IICF_MULT1:         equ    7                                         ; Multiplier Factor Bit 1
; bit position masks
mIICF_ICR0:         equ    %00000001
mIICF_ICR1:         equ    %00000010
mIICF_ICR2:         equ    %00000100
mIICF_ICR3:         equ    %00001000
mIICF_ICR4:         equ    %00010000
mIICF_ICR5:         equ    %00100000
mIICF_MULT0:        equ    %01000000
mIICF_MULT1:        equ    %10000000


;*** IICC1 - IIC Control Register 1; 0x0000006C ***
IICC1:              equ    $0000006C                                ;*** IICC1 - IIC Control Register 1; 0x0000006C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICC1_RSTA:         equ    2                                         ; Repeat START
IICC1_TXAK:         equ    3                                         ; Transmit Acknowledge Enable
IICC1_TX:           equ    4                                         ; Transmit Mode Select
IICC1_MST:          equ    5                                         ; Master Mode Select
IICC1_IICIE:        equ    6                                         ; IIC Interrupt Enable
IICC1_IICEN:        equ    7                                         ; IIC Enable
; bit position masks
mIICC1_RSTA:        equ    %00000100
mIICC1_TXAK:        equ    %00001000
mIICC1_TX:          equ    %00010000
mIICC1_MST:         equ    %00100000
mIICC1_IICIE:       equ    %01000000
mIICC1_IICEN:       equ    %10000000


;*** IICC - IIC Control Register; 0x0000006C ***
IICC:               equ    $0000006C                                ;*** IICC - IIC Control Register; 0x0000006C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICC_RSTA:          equ    2                                         ; Repeat START
IICC_TXAK:          equ    3                                         ; Transmit Acknowledge Enable
IICC_TX:            equ    4                                         ; Transmit Mode Select
IICC_MST:           equ    5                                         ; Master Mode Select
IICC_IICIE:         equ    6                                         ; IIC Interrupt Enable
IICC_IICEN:         equ    7                                         ; IIC Enable
; bit position masks
mIICC_RSTA:         equ    %00000100
mIICC_TXAK:         equ    %00001000
mIICC_TX:           equ    %00010000
mIICC_MST:          equ    %00100000
mIICC_IICIE:        equ    %01000000
mIICC_IICEN:        equ    %10000000


;*** IICS - IIC Status Register; 0x0000006D ***
IICS:               equ    $0000006D                                ;*** IICS - IIC Status Register; 0x0000006D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICS_RXAK:          equ    0                                         ; Receive Acknowledge
IICS_IICIF:         equ    1                                         ; IIC Interrupt Flag
IICS_SRW:           equ    2                                         ; Slave Read/Write
IICS_ARBL:          equ    4                                         ; Arbitration Lost
IICS_BUSY:          equ    5                                         ; Bus Busy
IICS_IAAS:          equ    6                                         ; Addressed as a Slave
IICS_TCF:           equ    7                                         ; Transfer Complete Flag
; bit position masks
mIICS_RXAK:         equ    %00000001
mIICS_IICIF:        equ    %00000010
mIICS_SRW:          equ    %00000100
mIICS_ARBL:         equ    %00010000
mIICS_BUSY:         equ    %00100000
mIICS_IAAS:         equ    %01000000
mIICS_TCF:          equ    %10000000


;*** IICD - IIC Data I/O Register; 0x0000006E ***
IICD:               equ    $0000006E                                ;*** IICD - IIC Data I/O Register; 0x0000006E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICD_DATA0:         equ    0                                         ; IIC Data Bit 0
IICD_DATA1:         equ    1                                         ; IIC Data Bit 1
IICD_DATA2:         equ    2                                         ; IIC Data Bit 2
IICD_DATA3:         equ    3                                         ; IIC Data Bit 3
IICD_DATA4:         equ    4                                         ; IIC Data Bit 4
IICD_DATA5:         equ    5                                         ; IIC Data Bit 5
IICD_DATA6:         equ    6                                         ; IIC Data Bit 6
IICD_DATA7:         equ    7                                         ; IIC Data Bit 7
; bit position masks
mIICD_DATA0:        equ    %00000001
mIICD_DATA1:        equ    %00000010
mIICD_DATA2:        equ    %00000100
mIICD_DATA3:        equ    %00001000
mIICD_DATA4:        equ    %00010000
mIICD_DATA5:        equ    %00100000
mIICD_DATA6:        equ    %01000000
mIICD_DATA7:        equ    %10000000


;*** IICC2 - IIC Control Register 2; 0x0000006F ***
IICC2:              equ    $0000006F                                ;*** IICC2 - IIC Control Register 2; 0x0000006F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICC2_AD8:          equ    0                                         ; Slave Address Bit 8
IICC2_AD9:          equ    1                                         ; Slave Address Bit 9
IICC2_AD10:         equ    2                                         ; Slave Address Bit 10
IICC2_ADEXT:        equ    6                                         ; Address Extension
IICC2_GCAEN:        equ    7                                         ; General Call Address Enable
; bit position masks
mIICC2_AD8:         equ    %00000001
mIICC2_AD9:         equ    %00000010
mIICC2_AD10:        equ    %00000100
mIICC2_ADEXT:       equ    %01000000
mIICC2_GCAEN:       equ    %10000000


;*** SPIC1 - SPI Control Register 1; 0x00000070 ***
SPIC1:              equ    $00000070                                ;*** SPIC1 - SPI Control Register 1; 0x00000070 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIC1_LSBFE:        equ    0                                         ; LSB First (Shifter Direction)
SPIC1_SSOE:         equ    1                                         ; Slave Select Output Enable
SPIC1_CPHA:         equ    2                                         ; Clock Phase
SPIC1_CPOL:         equ    3                                         ; Clock Polarity
SPIC1_MSTR:         equ    4                                         ; Master/Slave Mode Select
SPIC1_SPTIE:        equ    5                                         ; SPI Transmit Interrupt Enable
SPIC1_SPE:          equ    6                                         ; SPI System Enable
SPIC1_SPIE:         equ    7                                         ; SPI Interrupt Enable (for SPRF and MODF)
; bit position masks
mSPIC1_LSBFE:       equ    %00000001
mSPIC1_SSOE:        equ    %00000010
mSPIC1_CPHA:        equ    %00000100
mSPIC1_CPOL:        equ    %00001000
mSPIC1_MSTR:        equ    %00010000
mSPIC1_SPTIE:       equ    %00100000
mSPIC1_SPE:         equ    %01000000
mSPIC1_SPIE:        equ    %10000000


;*** SPIC2 - SPI Control Register 2; 0x00000071 ***
SPIC2:              equ    $00000071                                ;*** SPIC2 - SPI Control Register 2; 0x00000071 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIC2_SPC0:         equ    0                                         ; SPI Pin Control 0
SPIC2_SPISWAI:      equ    1                                         ; SPI Stop in Wait Mode
SPIC2_BIDIROE:      equ    3                                         ; Bidirectional Mode Output Enable
SPIC2_MODFEN:       equ    4                                         ; Master Mode-Fault Function Enable
; bit position masks
mSPIC2_SPC0:        equ    %00000001
mSPIC2_SPISWAI:     equ    %00000010
mSPIC2_BIDIROE:     equ    %00001000
mSPIC2_MODFEN:      equ    %00010000


;*** SPIBR - SPI Baud Rate Register; 0x00000072 ***
SPIBR:              equ    $00000072                                ;*** SPIBR - SPI Baud Rate Register; 0x00000072 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIBR_SPR0:         equ    0                                         ; SPI Baud Rate Divisor Bit 0
SPIBR_SPR1:         equ    1                                         ; SPI Baud Rate Divisor Bit 1
SPIBR_SPR2:         equ    2                                         ; SPI Baud Rate Divisor Bit 2
SPIBR_SPPR0:        equ    4                                         ; SPI Baud Rate Prescale Divisor Bit 0
SPIBR_SPPR1:        equ    5                                         ; SPI Baud Rate Prescale Divisor Bit 1
SPIBR_SPPR2:        equ    6                                         ; SPI Baud Rate Prescale Divisor Bit 2
; bit position masks
mSPIBR_SPR0:        equ    %00000001
mSPIBR_SPR1:        equ    %00000010
mSPIBR_SPR2:        equ    %00000100
mSPIBR_SPPR0:       equ    %00010000
mSPIBR_SPPR1:       equ    %00100000
mSPIBR_SPPR2:       equ    %01000000


;*** SPIS - SPI Status Register; 0x00000073 ***
SPIS:               equ    $00000073                                ;*** SPIS - SPI Status Register; 0x00000073 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIS_MODF:          equ    4                                         ; Master Mode Fault Flag
SPIS_SPTEF:         equ    5                                         ; SPI Transmit Buffer Empty Flag
SPIS_SPRF:          equ    7                                         ; SPI Read Buffer Full Flag
; bit position masks
mSPIS_MODF:         equ    %00010000
mSPIS_SPTEF:        equ    %00100000
mSPIS_SPRF:         equ    %10000000


;*** SPID - SPI Data Register; 0x00000075 ***
SPID:               equ    $00000075                                ;*** SPID - SPI Data Register; 0x00000075 ***


;*** IRQSC - Interrupt request status and control register; 0x00000076 ***
IRQSC:              equ    $00000076                                ;*** IRQSC - Interrupt request status and control register; 0x00000076 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IRQSC_IRQMOD:       equ    0                                         ; IRQ Detection Mode
IRQSC_IRQIE:        equ    1                                         ; IRQ Interrupt Enable
IRQSC_IRQACK:       equ    2                                         ; IRQ Acknowledge
IRQSC_IRQF:         equ    3                                         ; IRQ Flag
IRQSC_IRQPE:        equ    4                                         ; IRQ Pin Enable
IRQSC_IRQEDG:       equ    5                                         ; IRQ Edge Select
IRQSC_IRQPDD:       equ    6                                         ; IRQ Pull Device Disable
; bit position masks
mIRQSC_IRQMOD:      equ    %00000001
mIRQSC_IRQIE:       equ    %00000010
mIRQSC_IRQACK:      equ    %00000100
mIRQSC_IRQF:        equ    %00001000
mIRQSC_IRQPE:       equ    %00010000
mIRQSC_IRQEDG:      equ    %00100000
mIRQSC_IRQPDD:      equ    %01000000


;*** PPAGE - Program Page Register; 0x00000078 ***
PPAGE:              equ    $00000078                                ;*** PPAGE - Program Page Register; 0x00000078 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PPAGE_XA14:         equ    0                                         ; Extended address, bit 14
PPAGE_XA15:         equ    1                                         ; Extended address, bit 15
PPAGE_XA16:         equ    2                                         ; Extended address, bit 16
; bit position masks
mPPAGE_XA14:        equ    %00000001
mPPAGE_XA15:        equ    %00000010
mPPAGE_XA16:        equ    %00000100


;*** LAP2 - Linear Address Pointer Register 2; 0x00000079 ***
LAP2:               equ    $00000079                                ;*** LAP2 - Linear Address Pointer Register 2; 0x00000079 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LAP2_LA16:          equ    0                                         ; Linear address pointer, bit 16
; bit position masks
mLAP2_LA16:         equ    %00000001


;*** LAP1 - Linear Address Pointer Register 1; 0x0000007A ***
LAP1:               equ    $0000007A                                ;*** LAP1 - Linear Address Pointer Register 1; 0x0000007A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LAP1_LA8:           equ    0                                         ; Linear address pointer, bit 8
LAP1_LA9:           equ    1                                         ; Linear address pointer, bit 9
LAP1_LA10:          equ    2                                         ; Linear address pointer, bit 10
LAP1_LA11:          equ    3                                         ; Linear address pointer, bit 11
LAP1_LA12:          equ    4                                         ; Linear address pointer, bit 12
LAP1_LA13:          equ    5                                         ; Linear address pointer, bit 13
LAP1_LA14:          equ    6                                         ; Linear address pointer, bit 14
LAP1_LA15:          equ    7                                         ; Linear address pointer, bit 15
; bit position masks
mLAP1_LA8:          equ    %00000001
mLAP1_LA9:          equ    %00000010
mLAP1_LA10:         equ    %00000100
mLAP1_LA11:         equ    %00001000
mLAP1_LA12:         equ    %00010000
mLAP1_LA13:         equ    %00100000
mLAP1_LA14:         equ    %01000000
mLAP1_LA15:         equ    %10000000


;*** LAP0 - Linear Address Pointer Register 0; 0x0000007B ***
LAP0:               equ    $0000007B                                ;*** LAP0 - Linear Address Pointer Register 0; 0x0000007B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LAP0_LA0:           equ    0                                         ; Linear address pointer, bit 0
LAP0_LA1:           equ    1                                         ; Linear address pointer, bit 1
LAP0_LA2:           equ    2                                         ; Linear address pointer, bit 2
LAP0_LA3:           equ    3                                         ; Linear address pointer, bit 3
LAP0_LA4:           equ    4                                         ; Linear address pointer, bit 4
LAP0_LA5:           equ    5                                         ; Linear address pointer, bit 5
LAP0_LA6:           equ    6                                         ; Linear address pointer, bit 6
LAP0_LA7:           equ    7                                         ; Linear address pointer, bit 7
; bit position masks
mLAP0_LA0:          equ    %00000001
mLAP0_LA1:          equ    %00000010
mLAP0_LA2:          equ    %00000100
mLAP0_LA3:          equ    %00001000
mLAP0_LA4:          equ    %00010000
mLAP0_LA5:          equ    %00100000
mLAP0_LA6:          equ    %01000000
mLAP0_LA7:          equ    %10000000


;*** LWP - Linear Word Post Increment Register; 0x0000007C ***
LWP:                equ    $0000007C                                ;*** LWP - Linear Word Post Increment Register; 0x0000007C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LWP_D0:             equ    0                                         ; Data value bit 0
LWP_D1:             equ    1                                         ; Data value bit 1
LWP_D2:             equ    2                                         ; Data value bit 2
LWP_D3:             equ    3                                         ; Data value bit 3
LWP_D4:             equ    4                                         ; Data value bit 4
LWP_D5:             equ    5                                         ; Data value bit 5
LWP_D6:             equ    6                                         ; Data value bit 6
LWP_D7:             equ    7                                         ; Data value bit 7
; bit position masks
mLWP_D0:            equ    %00000001
mLWP_D1:            equ    %00000010
mLWP_D2:            equ    %00000100
mLWP_D3:            equ    %00001000
mLWP_D4:            equ    %00010000
mLWP_D5:            equ    %00100000
mLWP_D6:            equ    %01000000
mLWP_D7:            equ    %10000000


;*** LBP - Linear Byte Post Increment Register; 0x0000007D ***
LBP:                equ    $0000007D                                ;*** LBP - Linear Byte Post Increment Register; 0x0000007D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LBP_D0:             equ    0                                         ; Data value bit 0
LBP_D1:             equ    1                                         ; Data value bit 1
LBP_D2:             equ    2                                         ; Data value bit 2
LBP_D3:             equ    3                                         ; Data value bit 3
LBP_D4:             equ    4                                         ; Data value bit 4
LBP_D5:             equ    5                                         ; Data value bit 5
LBP_D6:             equ    6                                         ; Data value bit 6
LBP_D7:             equ    7                                         ; Data value bit 7
; bit position masks
mLBP_D0:            equ    %00000001
mLBP_D1:            equ    %00000010
mLBP_D2:            equ    %00000100
mLBP_D3:            equ    %00001000
mLBP_D4:            equ    %00010000
mLBP_D5:            equ    %00100000
mLBP_D6:            equ    %01000000
mLBP_D7:            equ    %10000000


;*** LB - Linear Byte Register; 0x0000007E ***
LB:                 equ    $0000007E                                ;*** LB - Linear Byte Register; 0x0000007E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LB_D0:              equ    0                                         ; Data value bit 0
LB_D1:              equ    1                                         ; Data value bit 1
LB_D2:              equ    2                                         ; Data value bit 2
LB_D3:              equ    3                                         ; Data value bit 3
LB_D4:              equ    4                                         ; Data value bit 4
LB_D5:              equ    5                                         ; Data value bit 5
LB_D6:              equ    6                                         ; Data value bit 6
LB_D7:              equ    7                                         ; Data value bit 7
; bit position masks
mLB_D0:             equ    %00000001
mLB_D1:             equ    %00000010
mLB_D2:             equ    %00000100
mLB_D3:             equ    %00001000
mLB_D4:             equ    %00010000
mLB_D5:             equ    %00100000
mLB_D6:             equ    %01000000
mLB_D7:             equ    %10000000


;*** LAPAB - Linear Address Pointer Add Byte Register; 0x0000007F ***
LAPAB:              equ    $0000007F                                ;*** LAPAB - Linear Address Pointer Add Byte Register; 0x0000007F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
LAPAB_D0:           equ    0                                         ; Data value bit 0
LAPAB_D1:           equ    1                                         ; Data value bit 1
LAPAB_D2:           equ    2                                         ; Data value bit 2
LAPAB_D3:           equ    3                                         ; Data value bit 3
LAPAB_D4:           equ    4                                         ; Data value bit 4
LAPAB_D5:           equ    5                                         ; Data value bit 5
LAPAB_D6:           equ    6                                         ; Data value bit 6
LAPAB_D7:           equ    7                                         ; Data value bit 7
; bit position masks
mLAPAB_D0:          equ    %00000001
mLAPAB_D1:          equ    %00000010
mLAPAB_D2:          equ    %00000100
mLAPAB_D3:          equ    %00001000
mLAPAB_D4:          equ    %00010000
mLAPAB_D5:          equ    %00100000
mLAPAB_D6:          equ    %01000000
mLAPAB_D7:          equ    %10000000


;*** SRS - System Reset Status Register; 0x00001800 ***
SRS:                equ    $00001800                                ;*** SRS - System Reset Status Register; 0x00001800 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRS_LVD:            equ    1                                         ; Low Voltage Detect
SRS_ILAD:           equ    3                                         ; Illegal Address
SRS_ILOP:           equ    4                                         ; Illegal Opcode
SRS_COP:            equ    5                                         ; Computer Operating Properly (COP) Watchdog
SRS_PIN:            equ    6                                         ; External Reset Pin
SRS_POR:            equ    7                                         ; Power-On Reset
; bit position masks
mSRS_LVD:           equ    %00000010
mSRS_ILAD:          equ    %00001000
mSRS_ILOP:          equ    %00010000
mSRS_COP:           equ    %00100000
mSRS_PIN:           equ    %01000000
mSRS_POR:           equ    %10000000


;*** SBDFR - System Background Debug Force Reset Register; 0x00001801 ***
SBDFR:              equ    $00001801                                ;*** SBDFR - System Background Debug Force Reset Register; 0x00001801 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SBDFR_BDFR:         equ    0                                         ; Background Debug Force Reset
; bit position masks
mSBDFR_BDFR:        equ    %00000001


;*** SOPT1 - System Options Register 1; 0x00001802 ***
SOPT1:              equ    $00001802                                ;*** SOPT1 - System Options Register 1; 0x00001802 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SOPT1_BKGDPE:       equ    1                                         ; Background Debug Mode Pin Enable
SOPT1_STOPE:        equ    5                                         ; Stop Mode Enable
SOPT1_COPT:         equ    6                                         ; COP Watchdog Timeout
SOPT1_COPE:         equ    7                                         ; COP Watchdog Enable
; bit position masks
mSOPT1_BKGDPE:      equ    %00000010
mSOPT1_STOPE:       equ    %00100000
mSOPT1_COPT:        equ    %01000000
mSOPT1_COPE:        equ    %10000000


;*** SOPT2 - System Options Register 2; 0x00001803 ***
SOPT2:              equ    $00001803                                ;*** SOPT2 - System Options Register 2; 0x00001803 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SOPT2_COPCLKS:      equ    7                                         ; COP Watchdog Clock Select
; bit position masks
mSOPT2_COPCLKS:     equ    %10000000


;*** SCIC4 - SCI Control Register 4; 0x00001804 ***
SCIC4:              equ    $00001804                                ;*** SCIC4 - SCI Control Register 4; 0x00001804 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIC4_BRFA0:        equ    0                                         ; Baud rate fine adjust, bit 0
SCIC4_BRFA1:        equ    1                                         ; Baud rate fine adjust, bit 1
SCIC4_BRFA2:        equ    2                                         ; Baud rate fine adjust, bit 2
SCIC4_BRFA3:        equ    3                                         ; Baud rate fine adjust, bit 3
SCIC4_BRFA4:        equ    4                                         ; Baud rate fine adjust, bit 4
; bit position masks
mSCIC4_BRFA0:       equ    %00000001
mSCIC4_BRFA1:       equ    %00000010
mSCIC4_BRFA2:       equ    %00000100
mSCIC4_BRFA3:       equ    %00001000
mSCIC4_BRFA4:       equ    %00010000


;*** SDID - System Device Identification Register; 0x00001806 ***
SDID:               equ    $00001806                                ;*** SDID - System Device Identification Register; 0x00001806 ***


;*** SDIDH - System Device Identification Register High; 0x00001806 ***
SDIDH:              equ    $00001806                                ;*** SDIDH - System Device Identification Register High; 0x00001806 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDIDH_ID8:          equ    0                                         ; Part Identification Number, bit 8
SDIDH_ID9:          equ    1                                         ; Part Identification Number, bit 9
SDIDH_ID10:         equ    2                                         ; Part Identification Number, bit 10
SDIDH_ID11:         equ    3                                         ; Part Identification Number, bit 11
; bit position masks
mSDIDH_ID8:         equ    %00000001
mSDIDH_ID9:         equ    %00000010
mSDIDH_ID10:        equ    %00000100
mSDIDH_ID11:        equ    %00001000


;*** SDIDL - System Device Identification Register Low; 0x00001807 ***
SDIDL:              equ    $00001807                                ;*** SDIDL - System Device Identification Register Low; 0x00001807 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDIDL_ID0:          equ    0                                         ; Part Identification Number, bit 0
SDIDL_ID1:          equ    1                                         ; Part Identification Number, bit 1
SDIDL_ID2:          equ    2                                         ; Part Identification Number, bit 2
SDIDL_ID3:          equ    3                                         ; Part Identification Number, bit 3
SDIDL_ID4:          equ    4                                         ; Part Identification Number, bit 4
SDIDL_ID5:          equ    5                                         ; Part Identification Number, bit 5
SDIDL_ID6:          equ    6                                         ; Part Identification Number, bit 6
SDIDL_ID7:          equ    7                                         ; Part Identification Number, bit 7
; bit position masks
mSDIDL_ID0:         equ    %00000001
mSDIDL_ID1:         equ    %00000010
mSDIDL_ID2:         equ    %00000100
mSDIDL_ID3:         equ    %00001000
mSDIDL_ID4:         equ    %00010000
mSDIDL_ID5:         equ    %00100000
mSDIDL_ID6:         equ    %01000000
mSDIDL_ID7:         equ    %10000000


;*** SPMSC1 - System Power Management Status and Control 1 Register; 0x00001808 ***
SPMSC1:             equ    $00001808                                ;*** SPMSC1 - System Power Management Status and Control 1 Register; 0x00001808 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPMSC1_BGBE:        equ    0                                         ; Bandgap Buffer Enable
SPMSC1_LVDE:        equ    2                                         ; Low-Voltage Detect Enable
SPMSC1_LVDSE:       equ    3                                         ; Low-Voltage Detect Stop Enable
SPMSC1_LVDRE:       equ    4                                         ; Low-Voltage Detect Reset Enable
SPMSC1_LVDIE:       equ    5                                         ; Low-Voltage Detect Interrupt Enable
SPMSC1_LVDACK:      equ    6                                         ; Low-Voltage Detect Acknowledge
SPMSC1_LVDF:        equ    7                                         ; Low-Voltage Detect Flag
; bit position masks
mSPMSC1_BGBE:       equ    %00000001
mSPMSC1_LVDE:       equ    %00000100
mSPMSC1_LVDSE:      equ    %00001000
mSPMSC1_LVDRE:      equ    %00010000
mSPMSC1_LVDIE:      equ    %00100000
mSPMSC1_LVDACK:     equ    %01000000
mSPMSC1_LVDF:       equ    %10000000


;*** SPMSC2 - System Power Management Status and Control 2 Register; 0x00001809 ***
SPMSC2:             equ    $00001809                                ;*** SPMSC2 - System Power Management Status and Control 2 Register; 0x00001809 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPMSC2_PPDC:        equ    0                                         ; Partial Power Down Control
SPMSC2_PPDE:        equ    1                                         ; Partial Power Down Enable
SPMSC2_PPDACK:      equ    2                                         ; Partial Power Down Acknowledge
SPMSC2_PPDF:        equ    3                                         ; Partial Power Down Flag
SPMSC2_LPWUI:       equ    5                                         ; Low Power Wake Up on Interrupt
SPMSC2_LPRS:        equ    6                                         ; Low Power Regulator Status
SPMSC2_LPR:         equ    7                                         ; Low Power Regulator Control
; bit position masks
mSPMSC2_PPDC:       equ    %00000001
mSPMSC2_PPDE:       equ    %00000010
mSPMSC2_PPDACK:     equ    %00000100
mSPMSC2_PPDF:       equ    %00001000
mSPMSC2_LPWUI:      equ    %00100000
mSPMSC2_LPRS:       equ    %01000000
mSPMSC2_LPR:        equ    %10000000


;*** SPMSC3 - System Power Management Status and Control 3 Register; 0x0000180B ***
SPMSC3:             equ    $0000180B                                ;*** SPMSC3 - System Power Management Status and Control 3 Register; 0x0000180B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPMSC3_LVWIE:       equ    3                                         ; Low-Voltage Warning Interrupt Enable
SPMSC3_LVWV:        equ    4                                         ; Low-Voltage Warning Voltage Select
SPMSC3_LVDV:        equ    5                                         ; Low-Voltage Detect Voltage Select
SPMSC3_LVWACK:      equ    6                                         ; Low-Voltage Warning Acknowledge
SPMSC3_LVWF:        equ    7                                         ; Low-Voltage Warning Flag
; bit position masks
mSPMSC3_LVWIE:      equ    %00001000
mSPMSC3_LVWV:       equ    %00010000
mSPMSC3_LVDV:       equ    %00100000
mSPMSC3_LVWACK:     equ    %01000000
mSPMSC3_LVWF:       equ    %10000000


;*** SOMC1 - ; 0x0000180C ***
SOMC1:              equ    $0000180C                                ;*** SOMC1 - ; 0x0000180C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SOMC1_XTAL0_TST_OUT: equ    0                                        ; Crystal 0 Test Out (32kHz) Enable
SOMC1_XTAL1_TST_OUT: equ    1                                        ; Crystal 1 Test Out (32MHz) Enable
SOMC1_XTAL1STEN:    equ    2                                         ; Crystal 1 Oscillator (32MHz) STOP Mode Enable
SOMC1_XTAL0STEN:    equ    3                                         ; Crystal 0 Oscillator (32.768KHz) STOP Mode Enable
SOMC1_XTAL0EN:      equ    4                                         ; Crystal 0 Oscillator (32.768KHz) Enable
SOMC1_RDIV0:        equ    5                                         ; Reference Divider, bit 0
SOMC1_RDIV1:        equ    6                                         ; Reference Divider, bit 1
SOMC1_RDIV2:        equ    7                                         ; Reference Divider, bit 2
; bit position masks
mSOMC1_XTAL0_TST_OUT: equ    %00000001
mSOMC1_XTAL1_TST_OUT: equ    %00000010
mSOMC1_XTAL1STEN:   equ    %00000100
mSOMC1_XTAL0STEN:   equ    %00001000
mSOMC1_XTAL0EN:     equ    %00010000
mSOMC1_RDIV0:       equ    %00100000
mSOMC1_RDIV1:       equ    %01000000
mSOMC1_RDIV2:       equ    %10000000


;*** SOMC2 - ; 0x0000180D ***
SOMC2:              equ    $0000180D                                ;*** SOMC2 - ; 0x0000180D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SOMC2_XTAL1_TRIM0:  equ    0                                         ; XTAL1_TRIM, bit 0
SOMC2_XTAL1_TRIM1:  equ    1                                         ; XTAL1_TRIM, bit 1
SOMC2_XTAL1_TRIM2:  equ    2                                         ; XTAL1_TRIM, bit 2
SOMC2_XTAL1_TRIM3:  equ    3                                         ; XTAL1_TRIM, bit 3
SOMC2_XTAL1_TRIM4:  equ    4                                         ; XTAL1_TRIM, bit 4
SOMC2_XTAL1_TRIM5:  equ    5                                         ; XTAL1_TRIM, bit 5
SOMC2_XTAL1_TRIM6:  equ    6                                         ; XTAL1_TRIM, bit 6
SOMC2_XTAL1_TRIM7:  equ    7                                         ; XTAL1_TRIM, bit 7
; bit position masks
mSOMC2_XTAL1_TRIM0: equ    %00000001
mSOMC2_XTAL1_TRIM1: equ    %00000010
mSOMC2_XTAL1_TRIM2: equ    %00000100
mSOMC2_XTAL1_TRIM3: equ    %00001000
mSOMC2_XTAL1_TRIM4: equ    %00010000
mSOMC2_XTAL1_TRIM5: equ    %00100000
mSOMC2_XTAL1_TRIM6: equ    %01000000
mSOMC2_XTAL1_TRIM7: equ    %10000000


;*** SCGC1 - System Clock Gating Control 1 Register; 0x0000180E ***
SCGC1:              equ    $0000180E                                ;*** SCGC1 - System Clock Gating Control 1 Register; 0x0000180E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCGC1_SCI:          equ    0                                         ; SCI Clock Gate Control
SCGC1_IIC:          equ    1                                         ; IIC Clock Gate Control
SCGC1_CMT:          equ    2                                         ; CMT Clock Gate Control
SCGC1_TPM1:         equ    3                                         ; TPM1 Clock Gate Control
SCGC1_TPM2:         equ    4                                         ; TPM2 Clock Gate Control
SCGC1_TPM3:         equ    5                                         ; TPM3 Clock Gate Control
SCGC1_TPM4:         equ    6                                         ; TPM4 Clock Gate Control
; bit position masks
mSCGC1_SCI:         equ    %00000001
mSCGC1_IIC:         equ    %00000010
mSCGC1_CMT:         equ    %00000100
mSCGC1_TPM1:        equ    %00001000
mSCGC1_TPM2:        equ    %00010000
mSCGC1_TPM3:        equ    %00100000
mSCGC1_TPM4:        equ    %01000000


;*** SCGC2 - System Clock Gating Control 2 Register; 0x0000180F ***
SCGC2:              equ    $0000180F                                ;*** SCGC2 - System Clock Gating Control 2 Register; 0x0000180F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCGC2_SPI:          equ    0                                         ; SPI Clock Gate Control
SCGC2_RTC:          equ    1                                         ; RTC Clock Gate Control
SCGC2_KBI2:         equ    2                                         ; KBI2 Clock Gate Control
SCGC2_KBI1:         equ    3                                         ; KBI1 Clock Gate Control
SCGC2_IRQ:          equ    4                                         ; IRQ Clock Gate Control
SCGC2_FLS:          equ    5                                         ; FLS Clock Gate Control
SCGC2_DBG:          equ    6                                         ; DBG Clock Gate Control
; bit position masks
mSCGC2_SPI:         equ    %00000001
mSCGC2_RTC:         equ    %00000010
mSCGC2_KBI2:        equ    %00000100
mSCGC2_KBI1:        equ    %00001000
mSCGC2_IRQ:         equ    %00010000
mSCGC2_FLS:         equ    %00100000
mSCGC2_DBG:         equ    %01000000


;*** DBGCA - Debug Comparator A Register; 0x00001810 ***
DBGCA:              equ    $00001810                                ;*** DBGCA - Debug Comparator A Register; 0x00001810 ***


;*** DBGCAH - Debug Comparator A High Register; 0x00001810 ***
DBGCAH:             equ    $00001810                                ;*** DBGCAH - Debug Comparator A High Register; 0x00001810 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAH_Bit8:        equ    0                                         ; Comparator A High Compare Bit 8
DBGCAH_Bit9:        equ    1                                         ; Comparator A High Compare Bit 9
DBGCAH_Bit10:       equ    2                                         ; Comparator A High Compare Bit 10
DBGCAH_Bit11:       equ    3                                         ; Comparator A High Compare Bit 11
DBGCAH_Bit12:       equ    4                                         ; Comparator A High Compare Bit 12
DBGCAH_Bit13:       equ    5                                         ; Comparator A High Compare Bit 13
DBGCAH_Bit14:       equ    6                                         ; Comparator A High Compare Bit 14
DBGCAH_Bit15:       equ    7                                         ; Comparator A High Compare Bit 15
; bit position masks
mDBGCAH_Bit8:       equ    %00000001
mDBGCAH_Bit9:       equ    %00000010
mDBGCAH_Bit10:      equ    %00000100
mDBGCAH_Bit11:      equ    %00001000
mDBGCAH_Bit12:      equ    %00010000
mDBGCAH_Bit13:      equ    %00100000
mDBGCAH_Bit14:      equ    %01000000
mDBGCAH_Bit15:      equ    %10000000


;*** DBGCAL - Debug Comparator A Low Register; 0x00001811 ***
DBGCAL:             equ    $00001811                                ;*** DBGCAL - Debug Comparator A Low Register; 0x00001811 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAL_Bit0:        equ    0                                         ; Comparator A Low Compare Bit 0
DBGCAL_Bit1:        equ    1                                         ; Comparator A Low Compare Bit 1
DBGCAL_Bit2:        equ    2                                         ; Comparator A Low Compare Bit 2
DBGCAL_Bit3:        equ    3                                         ; Comparator A Low Compare Bit 3
DBGCAL_Bit4:        equ    4                                         ; Comparator A Low Compare Bit 4
DBGCAL_Bit5:        equ    5                                         ; Comparator A Low Compare Bit 5
DBGCAL_Bit6:        equ    6                                         ; Comparator A Low Compare Bit 6
DBGCAL_Bit7:        equ    7                                         ; Comparator A Low Compare Bit 7
; bit position masks
mDBGCAL_Bit0:       equ    %00000001
mDBGCAL_Bit1:       equ    %00000010
mDBGCAL_Bit2:       equ    %00000100
mDBGCAL_Bit3:       equ    %00001000
mDBGCAL_Bit4:       equ    %00010000
mDBGCAL_Bit5:       equ    %00100000
mDBGCAL_Bit6:       equ    %01000000
mDBGCAL_Bit7:       equ    %10000000


;*** DBGCB - Debug Comparator B Register; 0x00001812 ***
DBGCB:              equ    $00001812                                ;*** DBGCB - Debug Comparator B Register; 0x00001812 ***


;*** DBGCBH - Debug Comparator B High Register; 0x00001812 ***
DBGCBH:             equ    $00001812                                ;*** DBGCBH - Debug Comparator B High Register; 0x00001812 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBH_Bit8:        equ    0                                         ; Comparator B High Compare Bit 8
DBGCBH_Bit9:        equ    1                                         ; Comparator B High Compare Bit 9
DBGCBH_Bit10:       equ    2                                         ; Comparator B High Compare Bit 10
DBGCBH_Bit11:       equ    3                                         ; Comparator B High Compare Bit 11
DBGCBH_Bit12:       equ    4                                         ; Comparator B High Compare Bit 12
DBGCBH_Bit13:       equ    5                                         ; Comparator B High Compare Bit 13
DBGCBH_Bit14:       equ    6                                         ; Comparator B High Compare Bit 14
DBGCBH_Bit15:       equ    7                                         ; Comparator B High Compare Bit 15
; bit position masks
mDBGCBH_Bit8:       equ    %00000001
mDBGCBH_Bit9:       equ    %00000010
mDBGCBH_Bit10:      equ    %00000100
mDBGCBH_Bit11:      equ    %00001000
mDBGCBH_Bit12:      equ    %00010000
mDBGCBH_Bit13:      equ    %00100000
mDBGCBH_Bit14:      equ    %01000000
mDBGCBH_Bit15:      equ    %10000000


;*** DBGCBL - Debug Comparator B Low Register; 0x00001813 ***
DBGCBL:             equ    $00001813                                ;*** DBGCBL - Debug Comparator B Low Register; 0x00001813 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBL_Bit0:        equ    0                                         ; Comparator B Low Compare Bit 0
DBGCBL_Bit1:        equ    1                                         ; Comparator B Low Compare Bit 1
DBGCBL_Bit2:        equ    2                                         ; Comparator B Low Compare Bit 2
DBGCBL_Bit3:        equ    3                                         ; Comparator B Low Compare Bit 3
DBGCBL_Bit4:        equ    4                                         ; Comparator B Low Compare Bit 4
DBGCBL_Bit5:        equ    5                                         ; Comparator B Low Compare Bit 5
DBGCBL_Bit6:        equ    6                                         ; Comparator B Low Compare Bit 6
DBGCBL_Bit7:        equ    7                                         ; Comparator B Low Compare Bit 7
; bit position masks
mDBGCBL_Bit0:       equ    %00000001
mDBGCBL_Bit1:       equ    %00000010
mDBGCBL_Bit2:       equ    %00000100
mDBGCBL_Bit3:       equ    %00001000
mDBGCBL_Bit4:       equ    %00010000
mDBGCBL_Bit5:       equ    %00100000
mDBGCBL_Bit6:       equ    %01000000
mDBGCBL_Bit7:       equ    %10000000


;*** DBGCC - Debug Comparator C Register; 0x00001814 ***
DBGCC:              equ    $00001814                                ;*** DBGCC - Debug Comparator C Register; 0x00001814 ***


;*** DBGCCH - Debug Comparator C High Register; 0x00001814 ***
DBGCCH:             equ    $00001814                                ;*** DBGCCH - Debug Comparator C High Register; 0x00001814 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCH_Bit8:        equ    0                                         ; Comparator C High Compare Bit 8
DBGCCH_Bit9:        equ    1                                         ; Comparator C High Compare Bit 9
DBGCCH_Bit10:       equ    2                                         ; Comparator C High Compare Bit 10
DBGCCH_Bit11:       equ    3                                         ; Comparator C High Compare Bit 11
DBGCCH_Bit12:       equ    4                                         ; Comparator C High Compare Bit 12
DBGCCH_Bit13:       equ    5                                         ; Comparator C High Compare Bit 13
DBGCCH_Bit14:       equ    6                                         ; Comparator C High Compare Bit 14
DBGCCH_Bit15:       equ    7                                         ; Comparator C High Compare Bit 15
; bit position masks
mDBGCCH_Bit8:       equ    %00000001
mDBGCCH_Bit9:       equ    %00000010
mDBGCCH_Bit10:      equ    %00000100
mDBGCCH_Bit11:      equ    %00001000
mDBGCCH_Bit12:      equ    %00010000
mDBGCCH_Bit13:      equ    %00100000
mDBGCCH_Bit14:      equ    %01000000
mDBGCCH_Bit15:      equ    %10000000


;*** DBGCCL - Debug Comparator C Low Register; 0x00001815 ***
DBGCCL:             equ    $00001815                                ;*** DBGCCL - Debug Comparator C Low Register; 0x00001815 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCL_Bit0:        equ    0                                         ; Comparator C Low Compare Bit 0
DBGCCL_Bit1:        equ    1                                         ; Comparator C Low Compare Bit 1
DBGCCL_Bit2:        equ    2                                         ; Comparator C Low Compare Bit 2
DBGCCL_Bit3:        equ    3                                         ; Comparator C Low Compare Bit 3
DBGCCL_Bit4:        equ    4                                         ; Comparator C Low Compare Bit 4
DBGCCL_Bit5:        equ    5                                         ; Comparator C Low Compare Bit 5
DBGCCL_Bit6:        equ    6                                         ; Comparator C Low Compare Bit 6
DBGCCL_Bit7:        equ    7                                         ; Comparator C Low Compare Bit 7
; bit position masks
mDBGCCL_Bit0:       equ    %00000001
mDBGCCL_Bit1:       equ    %00000010
mDBGCCL_Bit2:       equ    %00000100
mDBGCCL_Bit3:       equ    %00001000
mDBGCCL_Bit4:       equ    %00010000
mDBGCCL_Bit5:       equ    %00100000
mDBGCCL_Bit6:       equ    %01000000
mDBGCCL_Bit7:       equ    %10000000


;*** DBGF - Debug FIFO Register; 0x00001816 ***
DBGF:               equ    $00001816                                ;*** DBGF - Debug FIFO Register; 0x00001816 ***


;*** DBGFH - Debug FIFO High Register; 0x00001816 ***
DBGFH:              equ    $00001816                                ;*** DBGFH - Debug FIFO High Register; 0x00001816 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGFH_Bit8:         equ    0                                         ; FIFO High Data Bit 8
DBGFH_Bit9:         equ    1                                         ; FIFO High Data Bit 9
DBGFH_Bit10:        equ    2                                         ; FIFO High Data Bit 10
DBGFH_Bit11:        equ    3                                         ; FIFO High Data Bit 11
DBGFH_Bit12:        equ    4                                         ; FIFO High Data Bit 12
DBGFH_Bit13:        equ    5                                         ; FIFO High Data Bit 13
DBGFH_Bit14:        equ    6                                         ; FIFO High Data Bit 14
DBGFH_Bit15:        equ    7                                         ; FIFO High Data Bit 15
; bit position masks
mDBGFH_Bit8:        equ    %00000001
mDBGFH_Bit9:        equ    %00000010
mDBGFH_Bit10:       equ    %00000100
mDBGFH_Bit11:       equ    %00001000
mDBGFH_Bit12:       equ    %00010000
mDBGFH_Bit13:       equ    %00100000
mDBGFH_Bit14:       equ    %01000000
mDBGFH_Bit15:       equ    %10000000


;*** DBGFL - Debug FIFO Low Register; 0x00001817 ***
DBGFL:              equ    $00001817                                ;*** DBGFL - Debug FIFO Low Register; 0x00001817 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGFL_Bit0:         equ    0                                         ; FIFO Low Data Bit 0
DBGFL_Bit1:         equ    1                                         ; FIFO Low Data Bit 1
DBGFL_Bit2:         equ    2                                         ; FIFO Low Data Bit 2
DBGFL_Bit3:         equ    3                                         ; FIFO Low Data Bit 3
DBGFL_Bit4:         equ    4                                         ; FIFO Low Data Bit 4
DBGFL_Bit5:         equ    5                                         ; FIFO Low Data Bit 5
DBGFL_Bit6:         equ    6                                         ; FIFO Low Data Bit 6
DBGFL_Bit7:         equ    7                                         ; FIFO Low Data Bit 7
; bit position masks
mDBGFL_Bit0:        equ    %00000001
mDBGFL_Bit1:        equ    %00000010
mDBGFL_Bit2:        equ    %00000100
mDBGFL_Bit3:        equ    %00001000
mDBGFL_Bit4:        equ    %00010000
mDBGFL_Bit5:        equ    %00100000
mDBGFL_Bit6:        equ    %01000000
mDBGFL_Bit7:        equ    %10000000


;*** DBGCAX - Debug Comparator A Extension Register; 0x00001818 ***
DBGCAX:             equ    $00001818                                ;*** DBGCAX - Debug Comparator A Extension Register; 0x00001818 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAX_Bit16:       equ    0                                         ; omparator A Extended Address Bit 16 Compare Bit
DBGCAX_PAGSEL:      equ    5                                         ; Comparator A Page Select Bit
DBGCAX_RWA:         equ    6                                         ; Read/Write Comparator A Value Bit
DBGCAX_RWAEN:       equ    7                                         ; Read/Write Comparator A Enable Bit
; bit position masks
mDBGCAX_Bit16:      equ    %00000001
mDBGCAX_PAGSEL:     equ    %00100000
mDBGCAX_RWA:        equ    %01000000
mDBGCAX_RWAEN:      equ    %10000000


;*** DBGCBX - Debug Comparator B Extension Register; 0x00001819 ***
DBGCBX:             equ    $00001819                                ;*** DBGCBX - Debug Comparator B Extension Register; 0x00001819 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBX_Bit16:       equ    0                                         ; omparator B Extended Address Bit 16 Compare Bit
DBGCBX_PAGSEL:      equ    5                                         ; Comparator B Page Select Bit
DBGCBX_RWB:         equ    6                                         ; Read/Write Comparator B Value Bit
DBGCBX_RWBEN:       equ    7                                         ; Read/Write Comparator B Enable Bit
; bit position masks
mDBGCBX_Bit16:      equ    %00000001
mDBGCBX_PAGSEL:     equ    %00100000
mDBGCBX_RWB:        equ    %01000000
mDBGCBX_RWBEN:      equ    %10000000


;*** DBGCCX - Debug Comparator C Extension Register; 0x0000181A ***
DBGCCX:             equ    $0000181A                                ;*** DBGCCX - Debug Comparator C Extension Register; 0x0000181A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCCX_Bit16:       equ    0                                         ; omparator C Extended Address Bit 16 Compare Bit
DBGCCX_PAGSEL:      equ    5                                         ; Comparator C Page Select Bit
DBGCCX_RWC:         equ    6                                         ; Read/Write Comparator C Value Bit
DBGCCX_RWCEN:       equ    7                                         ; Read/Write Comparator C Enable Bit
; bit position masks
mDBGCCX_Bit16:      equ    %00000001
mDBGCCX_PAGSEL:     equ    %00100000
mDBGCCX_RWC:        equ    %01000000
mDBGCCX_RWCEN:      equ    %10000000


;*** DBGFX - Debug FIFO Extended Information Register; 0x0000181B ***
DBGFX:              equ    $0000181B                                ;*** DBGFX - Debug FIFO Extended Information Register; 0x0000181B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGFX_Bit16:        equ    0                                         ; Extended Address Bit 16
DBGFX_PPACC:        equ    7                                         ; PPAGE Access Indicator Bit
; bit position masks
mDBGFX_Bit16:       equ    %00000001
mDBGFX_PPACC:       equ    %10000000


;*** DBGC - Debug Control Register; 0x0000181C ***
DBGC:               equ    $0000181C                                ;*** DBGC - Debug Control Register; 0x0000181C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC_LOOP1:         equ    0                                         ; Select LOOP1 Capture Mode
DBGC_BRKEN:         equ    4                                         ; Break Enable Bit
DBGC_TAG:           equ    5                                         ; Tag or Force Bit
DBGC_ARM:           equ    6                                         ; Arm Bit
DBGC_DBGEN:         equ    7                                         ; DBG Module Enable Bit
; bit position masks
mDBGC_LOOP1:        equ    %00000001
mDBGC_BRKEN:        equ    %00010000
mDBGC_TAG:          equ    %00100000
mDBGC_ARM:          equ    %01000000
mDBGC_DBGEN:        equ    %10000000


;*** DBGT - Debug Trigger Register; 0x0000181D ***
DBGT:               equ    $0000181D                                ;*** DBGT - Debug Trigger Register; 0x0000181D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGT_TRG0:          equ    0                                         ; Trigger Mode Bit 0
DBGT_TRG1:          equ    1                                         ; Trigger Mode Bit 1
DBGT_TRG2:          equ    2                                         ; Trigger Mode Bit 2
DBGT_TRG3:          equ    3                                         ; Trigger Mode Bit 3
DBGT_BEGIN:         equ    6                                         ; Begin/End Trigger Bit
DBGT_TRGSEL:        equ    7                                         ; Trigger Selection Bit
; bit position masks
mDBGT_TRG0:         equ    %00000001
mDBGT_TRG1:         equ    %00000010
mDBGT_TRG2:         equ    %00000100
mDBGT_TRG3:         equ    %00001000
mDBGT_BEGIN:        equ    %01000000
mDBGT_TRGSEL:       equ    %10000000


;*** DBGS - Debug Status Register; 0x0000181E ***
DBGS:               equ    $0000181E                                ;*** DBGS - Debug Status Register; 0x0000181E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGS_ARMF:          equ    0                                         ; Arm Flag Bit
DBGS_CF:            equ    5                                         ; Trigger C Match Bit
DBGS_BF:            equ    6                                         ; Trigger B Match Bit
DBGS_AF:            equ    7                                         ; Trigger A Match Bit
; bit position masks
mDBGS_ARMF:         equ    %00000001
mDBGS_CF:           equ    %00100000
mDBGS_BF:           equ    %01000000
mDBGS_AF:           equ    %10000000


;*** DBGCNT - Debug Count Status Register; 0x0000181F ***
DBGCNT:             equ    $0000181F                                ;*** DBGCNT - Debug Count Status Register; 0x0000181F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCNT_CNT0:        equ    0                                         ; FIFO Valid Count Bits, bit 0
DBGCNT_CNT1:        equ    1                                         ; FIFO Valid Count Bits, bit 1
DBGCNT_CNT2:        equ    2                                         ; FIFO Valid Count Bits, bit 2
DBGCNT_CNT3:        equ    3                                         ; FIFO Valid Count Bits, bit 3
; bit position masks
mDBGCNT_CNT0:       equ    %00000001
mDBGCNT_CNT1:       equ    %00000010
mDBGCNT_CNT2:       equ    %00000100
mDBGCNT_CNT3:       equ    %00001000


;*** FCDIV - FLASH Clock Divider Register; 0x00001820 ***
FCDIV:              equ    $00001820                                ;*** FCDIV - FLASH Clock Divider Register; 0x00001820 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCDIV_FDIV0:        equ    0                                         ; Divisor for FLASH Clock Divider, bit 0
FCDIV_FDIV1:        equ    1                                         ; Divisor for FLASH Clock Divider, bit 1
FCDIV_FDIV2:        equ    2                                         ; Divisor for FLASH Clock Divider, bit 2
FCDIV_FDIV3:        equ    3                                         ; Divisor for FLASH Clock Divider, bit 3
FCDIV_FDIV4:        equ    4                                         ; Divisor for FLASH Clock Divider, bit 4
FCDIV_FDIV5:        equ    5                                         ; Divisor for FLASH Clock Divider, bit 5
FCDIV_PRDIV8:       equ    6                                         ; Prescale (Divide) FLASH Clock by 8
FCDIV_FDIVLD:       equ    7                                         ; Divisor Loaded Status Flag
; bit position masks
mFCDIV_FDIV0:       equ    %00000001
mFCDIV_FDIV1:       equ    %00000010
mFCDIV_FDIV2:       equ    %00000100
mFCDIV_FDIV3:       equ    %00001000
mFCDIV_FDIV4:       equ    %00010000
mFCDIV_FDIV5:       equ    %00100000
mFCDIV_PRDIV8:      equ    %01000000
mFCDIV_FDIVLD:      equ    %10000000


;*** FOPT - Flash Options Register; 0x00001821 ***
FOPT:               equ    $00001821                                ;*** FOPT - Flash Options Register; 0x00001821 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FOPT_SEC0:          equ    0                                         ; Flash Security Bit 0
FOPT_SEC1:          equ    1                                         ; Flash Security Bit 1
FOPT_KEYEN0:        equ    6                                         ; Backdoor Key Security Enable Bit 0
FOPT_KEYEN1:        equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mFOPT_SEC0:         equ    %00000001
mFOPT_SEC1:         equ    %00000010
mFOPT_KEYEN0:       equ    %01000000
mFOPT_KEYEN1:       equ    %10000000


;*** FCNFG - Flash Configuration Register; 0x00001823 ***
FCNFG:              equ    $00001823                                ;*** FCNFG - Flash Configuration Register; 0x00001823 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_KEYACC:       equ    5                                         ; Enable Security Key Writing
; bit position masks
mFCNFG_KEYACC:      equ    %00100000


;*** FPROT - Flash Protection Register; 0x00001824 ***
FPROT:              equ    $00001824                                ;*** FPROT - Flash Protection Register; 0x00001824 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPOPEN:       equ    0                                         ; Flash Protection Open
FPROT_FPS0:         equ    1                                         ; Flash Protection Size, bit 0
FPROT_FPS1:         equ    2                                         ; Flash Protection Size, bit 1
FPROT_FPS2:         equ    3                                         ; Flash Protection Size, bit 2
FPROT_FPS3:         equ    4                                         ; Flash Protection Size, bit 3
FPROT_FPS4:         equ    5                                         ; Flash Protection Size, bit 4
FPROT_FPS5:         equ    6                                         ; Flash Protection Size, bit 5
FPROT_FPS6:         equ    7                                         ; Flash Protection Size, bit 6
; bit position masks
mFPROT_FPOPEN:      equ    %00000001
mFPROT_FPS0:        equ    %00000010
mFPROT_FPS1:        equ    %00000100
mFPROT_FPS2:        equ    %00001000
mFPROT_FPS3:        equ    %00010000
mFPROT_FPS4:        equ    %00100000
mFPROT_FPS5:        equ    %01000000
mFPROT_FPS6:        equ    %10000000


;*** FSTAT - Flash Status Register; 0x00001825 ***
FSTAT:              equ    $00001825                                ;*** FSTAT - Flash Status Register; 0x00001825 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_FBLANK:       equ    2                                         ; FLASH Flag Indicating the Erase Verify Operation Status
FSTAT_FACCERR:      equ    4                                         ; FLASH Access Error Flag
FSTAT_FPVIOL:       equ    5                                         ; FLASH Protection Violation Flag
FSTAT_FCCF:         equ    6                                         ; FLASH Command Complete Interrupt Flag
FSTAT_FCBEF:        equ    7                                         ; FLASH Command Buffer Empty Flag
; bit position masks
mFSTAT_FBLANK:      equ    %00000100
mFSTAT_FACCERR:     equ    %00010000
mFSTAT_FPVIOL:      equ    %00100000
mFSTAT_FCCF:        equ    %01000000
mFSTAT_FCBEF:       equ    %10000000


;*** FCMD - Flash Command Register; 0x00001826 ***
FCMD:               equ    $00001826                                ;*** FCMD - Flash Command Register; 0x00001826 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCMD_FCMD0:         equ    0                                         ; Flash Command, bit 0
FCMD_FCMD1:         equ    1                                         ; Flash Command, bit 1
FCMD_FCMD2:         equ    2                                         ; Flash Command, bit 2
FCMD_FCMD3:         equ    3                                         ; Flash Command, bit 3
FCMD_FCMD4:         equ    4                                         ; Flash Command, bit 4
FCMD_FCMD5:         equ    5                                         ; Flash Command, bit 5
FCMD_FCMD6:         equ    6                                         ; Flash Command, bit 6
; bit position masks
mFCMD_FCMD0:        equ    %00000001
mFCMD_FCMD1:        equ    %00000010
mFCMD_FCMD2:        equ    %00000100
mFCMD_FCMD3:        equ    %00001000
mFCMD_FCMD4:        equ    %00010000
mFCMD_FCMD5:        equ    %00100000
mFCMD_FCMD6:        equ    %01000000


;*** RTCSC - RTC Status and Control Register; 0x00001828 ***
RTCSC:              equ    $00001828                                ;*** RTCSC - RTC Status and Control Register; 0x00001828 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
RTCSC_RTCPS0:       equ    0                                         ; Real-Time Clock Prescaler Select, bit 0
RTCSC_RTCPS1:       equ    1                                         ; Real-Time Clock Prescaler Select, bit 1
RTCSC_RTCPS2:       equ    2                                         ; Real-Time Clock Prescaler Select, bit 2
RTCSC_RTCPS3:       equ    3                                         ; Real-Time Clock Prescaler Select, bit 3
RTCSC_RTIE:         equ    4                                         ; Real-Time Interrupt Enable
RTCSC_RTCLKS0:      equ    5                                         ; Real-Time Clock Source Select, bit 0
RTCSC_RTCLKS1:      equ    6                                         ; Real-Time Clock Source Select, bit 1
RTCSC_RTIF:         equ    7                                         ; Real-Time Interrupt Flag
; bit position masks
mRTCSC_RTCPS0:      equ    %00000001
mRTCSC_RTCPS1:      equ    %00000010
mRTCSC_RTCPS2:      equ    %00000100
mRTCSC_RTCPS3:      equ    %00001000
mRTCSC_RTIE:        equ    %00010000
mRTCSC_RTCLKS0:     equ    %00100000
mRTCSC_RTCLKS1:     equ    %01000000
mRTCSC_RTIF:        equ    %10000000


;*** RTCCNT - RTC Counter Register; 0x00001829 ***
RTCCNT:             equ    $00001829                                ;*** RTCCNT - RTC Counter Register; 0x00001829 ***


;*** RTCCNTH - RTC Counter Register High; 0x00001829 ***
RTCCNTH:            equ    $00001829                                ;*** RTCCNTH - RTC Counter Register High; 0x00001829 ***


;*** RTCCNTL - RTC Counter Register Low; 0x0000182A ***
RTCCNTL:            equ    $0000182A                                ;*** RTCCNTL - RTC Counter Register Low; 0x0000182A ***


;*** RTCMOD - RTC Modulo Register; 0x0000182B ***
RTCMOD:             equ    $0000182B                                ;*** RTCMOD - RTC Modulo Register; 0x0000182B ***


;*** RTCMODH - RTC Modulo Register High; 0x0000182B ***
RTCMODH:            equ    $0000182B                                ;*** RTCMODH - RTC Modulo Register High; 0x0000182B ***


;*** RTCMODL - RTC Modulo Register Low; 0x0000182C ***
RTCMODL:            equ    $0000182C                                ;*** RTCMODL - RTC Modulo Register Low; 0x0000182C ***


;*** PTAPE - Port A Pull Enable Register; 0x00001830 ***
PTAPE:              equ    $00001830                                ;*** PTAPE - Port A Pull Enable Register; 0x00001830 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAPE_PTAPE0:       equ    0                                         ; Internal Pull Enable for Port A Bit 0
PTAPE_PTAPE1:       equ    1                                         ; Internal Pull Enable for Port A Bit 1
PTAPE_PTAPE2:       equ    2                                         ; Internal Pull Enable for Port A Bit 2
PTAPE_PTAPE3:       equ    3                                         ; Internal Pull Enable for Port A Bit 3
PTAPE_PTAPE4:       equ    4                                         ; Internal Pull Enable for Port A Bit 4
PTAPE_PTAPE5:       equ    5                                         ; Internal Pull Enable for Port A Bit 5
PTAPE_PTAPE6:       equ    6                                         ; Internal Pull Enable for Port A Bit 6
PTAPE_PTAPE7:       equ    7                                         ; Internal Pull Enable for Port A Bit 7
; bit position masks
mPTAPE_PTAPE0:      equ    %00000001
mPTAPE_PTAPE1:      equ    %00000010
mPTAPE_PTAPE2:      equ    %00000100
mPTAPE_PTAPE3:      equ    %00001000
mPTAPE_PTAPE4:      equ    %00010000
mPTAPE_PTAPE5:      equ    %00100000
mPTAPE_PTAPE6:      equ    %01000000
mPTAPE_PTAPE7:      equ    %10000000


;*** PTASE - Port A Slew Rate Enable Register; 0x00001831 ***
PTASE:              equ    $00001831                                ;*** PTASE - Port A Slew Rate Enable Register; 0x00001831 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTASE_PTASE0:       equ    0                                         ; Output Slew Rate Enable for Port A Bit 0
PTASE_PTASE1:       equ    1                                         ; Output Slew Rate Enable for Port A Bit 1
PTASE_PTASE2:       equ    2                                         ; Output Slew Rate Enable for Port A Bit 2
PTASE_PTASE3:       equ    3                                         ; Output Slew Rate Enable for Port A Bit 3
PTASE_PTASE4:       equ    4                                         ; Output Slew Rate Enable for Port A Bit 4
PTASE_PTASE5:       equ    5                                         ; Output Slew Rate Enable for Port A Bit 5
PTASE_PTASE6:       equ    6                                         ; Output Slew Rate Enable for Port A Bit 6
PTASE_PTASE7:       equ    7                                         ; Output Slew Rate Enable for Port A Bit 7
; bit position masks
mPTASE_PTASE0:      equ    %00000001
mPTASE_PTASE1:      equ    %00000010
mPTASE_PTASE2:      equ    %00000100
mPTASE_PTASE3:      equ    %00001000
mPTASE_PTASE4:      equ    %00010000
mPTASE_PTASE5:      equ    %00100000
mPTASE_PTASE6:      equ    %01000000
mPTASE_PTASE7:      equ    %10000000


;*** PTADS - Port A Drive Strength Selection Register; 0x00001832 ***
PTADS:              equ    $00001832                                ;*** PTADS - Port A Drive Strength Selection Register; 0x00001832 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTADS_PTADS0:       equ    0                                         ; Output Drive Strength Selection for Port A Bit 0
PTADS_PTADS1:       equ    1                                         ; Output Drive Strength Selection for Port A Bit 1
PTADS_PTADS2:       equ    2                                         ; Output Drive Strength Selection for Port A Bit 2
PTADS_PTADS3:       equ    3                                         ; Output Drive Strength Selection for Port A Bit 3
PTADS_PTADS4:       equ    4                                         ; Output Drive Strength Selection for Port A Bit 4
PTADS_PTADS5:       equ    5                                         ; Output Drive Strength Selection for Port A Bit 5
PTADS_PTADS6:       equ    6                                         ; Output Drive Strength Selection for Port A Bit 6
PTADS_PTADS7:       equ    7                                         ; Output Drive Strength Selection for Port A Bit 7
; bit position masks
mPTADS_PTADS0:      equ    %00000001
mPTADS_PTADS1:      equ    %00000010
mPTADS_PTADS2:      equ    %00000100
mPTADS_PTADS3:      equ    %00001000
mPTADS_PTADS4:      equ    %00010000
mPTADS_PTADS5:      equ    %00100000
mPTADS_PTADS6:      equ    %01000000
mPTADS_PTADS7:      equ    %10000000


;*** PTBPE - Port B Pull Enable Register; 0x00001833 ***
PTBPE:              equ    $00001833                                ;*** PTBPE - Port B Pull Enable Register; 0x00001833 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBPE_PTBPE0:       equ    0                                         ; Internal Pull Enable for Port B Bit 0
PTBPE_PTBPE1:       equ    1                                         ; Internal Pull Enable for Port B Bit 1
PTBPE_PTBPE2:       equ    2                                         ; Internal Pull Enable for Port B Bit 2
PTBPE_PTBPE3:       equ    3                                         ; Internal Pull Enable for Port B Bit 3
PTBPE_PTBPE4:       equ    4                                         ; Internal Pull Enable for Port B Bit 4
PTBPE_PTBPE5:       equ    5                                         ; Internal Pull Enable for Port B Bit 5
PTBPE_PTBPE6:       equ    6                                         ; Internal Pull Enable for Port B Bit 6
PTBPE_PTBPE7:       equ    7                                         ; Internal Pull Enable for Port B Bit 7
; bit position masks
mPTBPE_PTBPE0:      equ    %00000001
mPTBPE_PTBPE1:      equ    %00000010
mPTBPE_PTBPE2:      equ    %00000100
mPTBPE_PTBPE3:      equ    %00001000
mPTBPE_PTBPE4:      equ    %00010000
mPTBPE_PTBPE5:      equ    %00100000
mPTBPE_PTBPE6:      equ    %01000000
mPTBPE_PTBPE7:      equ    %10000000


;*** PTBSE - Port B Slew Rate Enable Register; 0x00001834 ***
PTBSE:              equ    $00001834                                ;*** PTBSE - Port B Slew Rate Enable Register; 0x00001834 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBSE_PTBSE0:       equ    0                                         ; Output Slew Rate Enable for Port B Bit 0
PTBSE_PTBSE1:       equ    1                                         ; Output Slew Rate Enable for Port B Bit 1
PTBSE_PTBSE2:       equ    2                                         ; Output Slew Rate Enable for Port B Bit 2
PTBSE_PTBSE3:       equ    3                                         ; Output Slew Rate Enable for Port B Bit 3
PTBSE_PTBSE4:       equ    4                                         ; Output Slew Rate Enable for Port B Bit 4
PTBSE_PTBSE5:       equ    5                                         ; Output Slew Rate Enable for Port B Bit 5
PTBSE_PTBSE6:       equ    6                                         ; Output Slew Rate Enable for Port B Bit 6
PTBSE_PTBSE7:       equ    7                                         ; Output Slew Rate Enable for Port B Bit 7
; bit position masks
mPTBSE_PTBSE0:      equ    %00000001
mPTBSE_PTBSE1:      equ    %00000010
mPTBSE_PTBSE2:      equ    %00000100
mPTBSE_PTBSE3:      equ    %00001000
mPTBSE_PTBSE4:      equ    %00010000
mPTBSE_PTBSE5:      equ    %00100000
mPTBSE_PTBSE6:      equ    %01000000
mPTBSE_PTBSE7:      equ    %10000000


;*** PTBDS - Port B Drive Strength Selection Register; 0x00001835 ***
PTBDS:              equ    $00001835                                ;*** PTBDS - Port B Drive Strength Selection Register; 0x00001835 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBDS_PTBDS0:       equ    0                                         ; Output Drive Strength Selection for Port B Bit 0
PTBDS_PTBDS1:       equ    1                                         ; Output Drive Strength Selection for Port B Bit 1
PTBDS_PTBDS2:       equ    2                                         ; Output Drive Strength Selection for Port B Bit 2
PTBDS_PTBDS3:       equ    3                                         ; Output Drive Strength Selection for Port B Bit 3
PTBDS_PTBDS4:       equ    4                                         ; Output Drive Strength Selection for Port B Bit 4
PTBDS_PTBDS5:       equ    5                                         ; Output Drive Strength Selection for Port B Bit 5
PTBDS_PTBDS6:       equ    6                                         ; Output Drive Strength Selection for Port B Bit 6
PTBDS_PTBDS7:       equ    7                                         ; Output Drive Strength Selection for Port B Bit 7
; bit position masks
mPTBDS_PTBDS0:      equ    %00000001
mPTBDS_PTBDS1:      equ    %00000010
mPTBDS_PTBDS2:      equ    %00000100
mPTBDS_PTBDS3:      equ    %00001000
mPTBDS_PTBDS4:      equ    %00010000
mPTBDS_PTBDS5:      equ    %00100000
mPTBDS_PTBDS6:      equ    %01000000
mPTBDS_PTBDS7:      equ    %10000000


;*** PTCPE - Port C Pull Enable Register; 0x00001837 ***
PTCPE:              equ    $00001837                                ;*** PTCPE - Port C Pull Enable Register; 0x00001837 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCPE_PTCPE0:       equ    0                                         ; Internal Pull Enable for Port C Bit 0
PTCPE_PTCPE1:       equ    1                                         ; Internal Pull Enable for Port C Bit 1
PTCPE_PTCPE2:       equ    2                                         ; Internal Pull Enable for Port C Bit 2
PTCPE_PTCPE3:       equ    3                                         ; Internal Pull Enable for Port C Bit 3
PTCPE_PTCPE4:       equ    4                                         ; Internal Pull Enable for Port C Bit 4
PTCPE_PTCPE5:       equ    5                                         ; Internal Pull Enable for Port C Bit 5
PTCPE_PTCPE6:       equ    6                                         ; Internal Pull Enable for Port C Bit 6
PTCPE_PTCPE7:       equ    7                                         ; Internal Pull Enable for Port C Bit 7
; bit position masks
mPTCPE_PTCPE0:      equ    %00000001
mPTCPE_PTCPE1:      equ    %00000010
mPTCPE_PTCPE2:      equ    %00000100
mPTCPE_PTCPE3:      equ    %00001000
mPTCPE_PTCPE4:      equ    %00010000
mPTCPE_PTCPE5:      equ    %00100000
mPTCPE_PTCPE6:      equ    %01000000
mPTCPE_PTCPE7:      equ    %10000000


;*** PTCSE - Port C Slew Rate Enable Register; 0x00001838 ***
PTCSE:              equ    $00001838                                ;*** PTCSE - Port C Slew Rate Enable Register; 0x00001838 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCSE_PTCSE0:       equ    0                                         ; Output Slew Rate Enable for Port C Bit 0
PTCSE_PTCSE1:       equ    1                                         ; Output Slew Rate Enable for Port C Bit 1
PTCSE_PTCSE2:       equ    2                                         ; Output Slew Rate Enable for Port C Bit 2
PTCSE_PTCSE3:       equ    3                                         ; Output Slew Rate Enable for Port C Bit 3
PTCSE_PTCSE4:       equ    4                                         ; Output Slew Rate Enable for Port C Bit 4
PTCSE_PTCSE5:       equ    5                                         ; Output Slew Rate Enable for Port C Bit 5
PTCSE_PTCSE6:       equ    6                                         ; Output Slew Rate Enable for Port C Bit 6
PTCSE_PTCSE7:       equ    7                                         ; Output Slew Rate Enable for Port C Bit 7
; bit position masks
mPTCSE_PTCSE0:      equ    %00000001
mPTCSE_PTCSE1:      equ    %00000010
mPTCSE_PTCSE2:      equ    %00000100
mPTCSE_PTCSE3:      equ    %00001000
mPTCSE_PTCSE4:      equ    %00010000
mPTCSE_PTCSE5:      equ    %00100000
mPTCSE_PTCSE6:      equ    %01000000
mPTCSE_PTCSE7:      equ    %10000000


;*** PTCDS - Port C Drive Strength Selection Register; 0x00001839 ***
PTCDS:              equ    $00001839                                ;*** PTCDS - Port C Drive Strength Selection Register; 0x00001839 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTCDS_PTCDS0:       equ    0                                         ; Output Drive Strength Selection for Port C Bit 0
PTCDS_PTCDS1:       equ    1                                         ; Output Drive Strength Selection for Port C Bit 1
PTCDS_PTCDS2:       equ    2                                         ; Output Drive Strength Selection for Port C Bit 2
PTCDS_PTCDS3:       equ    3                                         ; Output Drive Strength Selection for Port C Bit 3
PTCDS_PTCDS4:       equ    4                                         ; Output Drive Strength Selection for Port C Bit 4
PTCDS_PTCDS5:       equ    5                                         ; Output Drive Strength Selection for Port C Bit 5
PTCDS_PTCDS6:       equ    6                                         ; Output Drive Strength Selection for Port C Bit 6
PTCDS_PTCDS7:       equ    7                                         ; Output Drive Strength Selection for Port C Bit 7
; bit position masks
mPTCDS_PTCDS0:      equ    %00000001
mPTCDS_PTCDS1:      equ    %00000010
mPTCDS_PTCDS2:      equ    %00000100
mPTCDS_PTCDS3:      equ    %00001000
mPTCDS_PTCDS4:      equ    %00010000
mPTCDS_PTCDS5:      equ    %00100000
mPTCDS_PTCDS6:      equ    %01000000
mPTCDS_PTCDS7:      equ    %10000000


;*** PTDPE - Port D Pull Enable Register; 0x0000183B ***
PTDPE:              equ    $0000183B                                ;*** PTDPE - Port D Pull Enable Register; 0x0000183B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDPE_PTDPE0:       equ    0                                         ; Internal Pull Enable for Port D Bit 0
PTDPE_PTDPE1:       equ    1                                         ; Internal Pull Enable for Port D Bit 1
PTDPE_PTDPE2:       equ    2                                         ; Internal Pull Enable for Port D Bit 2
PTDPE_PTDPE3:       equ    3                                         ; Internal Pull Enable for Port D Bit 3
PTDPE_PTDPE4:       equ    4                                         ; Internal Pull Enable for Port D Bit 4
PTDPE_PTDPE5:       equ    5                                         ; Internal Pull Enable for Port D Bit 5
PTDPE_PTDPE6:       equ    6                                         ; Internal Pull Enable for Port D Bit 6
PTDPE_PTDPE7:       equ    7                                         ; Internal Pull Enable for Port D Bit 7
; bit position masks
mPTDPE_PTDPE0:      equ    %00000001
mPTDPE_PTDPE1:      equ    %00000010
mPTDPE_PTDPE2:      equ    %00000100
mPTDPE_PTDPE3:      equ    %00001000
mPTDPE_PTDPE4:      equ    %00010000
mPTDPE_PTDPE5:      equ    %00100000
mPTDPE_PTDPE6:      equ    %01000000
mPTDPE_PTDPE7:      equ    %10000000


;*** PTDSE - Port D Slew Rate Enable Register; 0x0000183C ***
PTDSE:              equ    $0000183C                                ;*** PTDSE - Port D Slew Rate Enable Register; 0x0000183C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDSE_PTDSE0:       equ    0                                         ; Output Slew Rate Enable for Port D Bit 0
PTDSE_PTDSE1:       equ    1                                         ; Output Slew Rate Enable for Port D Bit 1
PTDSE_PTDSE2:       equ    2                                         ; Output Slew Rate Enable for Port D Bit 2
PTDSE_PTDSE3:       equ    3                                         ; Output Slew Rate Enable for Port D Bit 3
PTDSE_PTDSE4:       equ    4                                         ; Output Slew Rate Enable for Port D Bit 4
PTDSE_PTDSE5:       equ    5                                         ; Output Slew Rate Enable for Port D Bit 5
PTDSE_PTDSE6:       equ    6                                         ; Output Slew Rate Enable for Port D Bit 6
PTDSE_PTDSE7:       equ    7                                         ; Output Slew Rate Enable for Port D Bit 7
; bit position masks
mPTDSE_PTDSE0:      equ    %00000001
mPTDSE_PTDSE1:      equ    %00000010
mPTDSE_PTDSE2:      equ    %00000100
mPTDSE_PTDSE3:      equ    %00001000
mPTDSE_PTDSE4:      equ    %00010000
mPTDSE_PTDSE5:      equ    %00100000
mPTDSE_PTDSE6:      equ    %01000000
mPTDSE_PTDSE7:      equ    %10000000


;*** PTDDS - Port D Drive Strength Selection Register; 0x0000183D ***
PTDDS:              equ    $0000183D                                ;*** PTDDS - Port D Drive Strength Selection Register; 0x0000183D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTDDS_PTDDS0:       equ    0                                         ; Output Drive Strength Selection for Port D Bit 0
PTDDS_PTDDS1:       equ    1                                         ; Output Drive Strength Selection for Port D Bit 1
PTDDS_PTDDS2:       equ    2                                         ; Output Drive Strength Selection for Port D Bit 2
PTDDS_PTDDS3:       equ    3                                         ; Output Drive Strength Selection for Port D Bit 3
PTDDS_PTDDS4:       equ    4                                         ; Output Drive Strength Selection for Port D Bit 4
PTDDS_PTDDS5:       equ    5                                         ; Output Drive Strength Selection for Port D Bit 5
PTDDS_PTDDS6:       equ    6                                         ; Output Drive Strength Selection for Port D Bit 6
PTDDS_PTDDS7:       equ    7                                         ; Output Drive Strength Selection for Port D Bit 7
; bit position masks
mPTDDS_PTDDS0:      equ    %00000001
mPTDDS_PTDDS1:      equ    %00000010
mPTDDS_PTDDS2:      equ    %00000100
mPTDDS_PTDDS3:      equ    %00001000
mPTDDS_PTDDS4:      equ    %00010000
mPTDDS_PTDDS5:      equ    %00100000
mPTDDS_PTDDS6:      equ    %01000000
mPTDDS_PTDDS7:      equ    %10000000


;*** PHY_T1CMP0 - ; 0x00001840 ***
PHY_T1CMP0:         equ    $00001840                                ;*** PHY_T1CMP0 - ; 0x00001840 ***


;*** PHY_T1CMP1 - ; 0x00001841 ***
PHY_T1CMP1:         equ    $00001841                                ;*** PHY_T1CMP1 - ; 0x00001841 ***


;*** PHY_T1CMP2 - ; 0x00001842 ***
PHY_T1CMP2:         equ    $00001842                                ;*** PHY_T1CMP2 - ; 0x00001842 ***


;*** PHY_T2CMP0 - ; 0x00001843 ***
PHY_T2CMP0:         equ    $00001843                                ;*** PHY_T2CMP0 - ; 0x00001843 ***


;*** PHY_T2CMP1 - ; 0x00001844 ***
PHY_T2CMP1:         equ    $00001844                                ;*** PHY_T2CMP1 - ; 0x00001844 ***


;*** PHY_T2CMP2 - ; 0x00001845 ***
PHY_T2CMP2:         equ    $00001845                                ;*** PHY_T2CMP2 - ; 0x00001845 ***


;*** PHY_T4CMP0 - ; 0x00001846 ***
PHY_T4CMP0:         equ    $00001846                                ;*** PHY_T4CMP0 - ; 0x00001846 ***


;*** PHY_T4CMP1 - ; 0x00001847 ***
PHY_T4CMP1:         equ    $00001847                                ;*** PHY_T4CMP1 - ; 0x00001847 ***


;*** PHY_T4CMP2 - ; 0x00001848 ***
PHY_T4CMP2:         equ    $00001848                                ;*** PHY_T4CMP2 - ; 0x00001848 ***


;*** PHY_LO1_FRAC0 - ; 0x00001849 ***
PHY_LO1_FRAC0:      equ    $00001849                                ;*** PHY_LO1_FRAC0 - ; 0x00001849 ***


;*** PHY_LO1_FRAC1 - ; 0x0000184A ***
PHY_LO1_FRAC1:      equ    $0000184A                                ;*** PHY_LO1_FRAC1 - ; 0x0000184A ***


;*** PHY_LO1_INT - ; 0x0000184B ***
PHY_LO1_INT:        equ    $0000184B                                ;*** PHY_LO1_INT - ; 0x0000184B ***


;*** PHY_PA_PWR_CNTL - ; 0x0000184C ***
PHY_PA_PWR_CNTL:    equ    $0000184C                                ;*** PHY_PA_PWR_CNTL - ; 0x0000184C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PHY_PA_PWR_CNTL_PADFINE0: equ    0             
PHY_PA_PWR_CNTL_PADFINE1: equ    1             
PHY_PA_PWR_CNTL_PADCRS0: equ    2             
PHY_PA_PWR_CNTL_PADCRS1: equ    3             
PHY_PA_PWR_CNTL_PALFINE0: equ    4             
PHY_PA_PWR_CNTL_PALFINE1: equ    5             
PHY_PA_PWR_CNTL_PALCRS0: equ    6             
PHY_PA_PWR_CNTL_PALCRS1: equ    7             
; bit position masks
mPHY_PA_PWR_CNTL_PADFINE0: equ    %00000001
mPHY_PA_PWR_CNTL_PADFINE1: equ    %00000010
mPHY_PA_PWR_CNTL_PADCRS0: equ    %00000100
mPHY_PA_PWR_CNTL_PADCRS1: equ    %00001000
mPHY_PA_PWR_CNTL_PALFINE0: equ    %00010000
mPHY_PA_PWR_CNTL_PALFINE1: equ    %00100000
mPHY_PA_PWR_CNTL_PALCRS0: equ    %01000000
mPHY_PA_PWR_CNTL_PALCRS1: equ    %10000000


;*** PHY_MACLONGADDRS0 - ; 0x0000184D ***
PHY_MACLONGADDRS0:  equ    $0000184D                                ;*** PHY_MACLONGADDRS0 - ; 0x0000184D ***


;*** PHY_MACLONGADDRS1 - ; 0x0000184E ***
PHY_MACLONGADDRS1:  equ    $0000184E                                ;*** PHY_MACLONGADDRS1 - ; 0x0000184E ***


;*** PHY_MACLONGADDRS2 - ; 0x0000184F ***
PHY_MACLONGADDRS2:  equ    $0000184F                                ;*** PHY_MACLONGADDRS2 - ; 0x0000184F ***


;*** PHY_MACLONGADDRS3 - ; 0x00001850 ***
PHY_MACLONGADDRS3:  equ    $00001850                                ;*** PHY_MACLONGADDRS3 - ; 0x00001850 ***


;*** PHY_MACLONGADDRS4 - ; 0x00001851 ***
PHY_MACLONGADDRS4:  equ    $00001851                                ;*** PHY_MACLONGADDRS4 - ; 0x00001851 ***


;*** PHY_MACLONGADDRS5 - ; 0x00001852 ***
PHY_MACLONGADDRS5:  equ    $00001852                                ;*** PHY_MACLONGADDRS5 - ; 0x00001852 ***


;*** PHY_MACLONGADDRS6 - ; 0x00001853 ***
PHY_MACLONGADDRS6:  equ    $00001853                                ;*** PHY_MACLONGADDRS6 - ; 0x00001853 ***


;*** PHY_MACLONGADDRS7 - ; 0x00001854 ***
PHY_MACLONGADDRS7:  equ    $00001854                                ;*** PHY_MACLONGADDRS7 - ; 0x00001854 ***


;*** PHY_MAXFRAMELENGTH - ; 0x00001855 ***
PHY_MAXFRAMELENGTH: equ    $00001855                                ;*** PHY_MAXFRAMELENGTH - ; 0x00001855 ***


;*** PHY_RX_FRAME_FILTER - ; 0x00001856 ***
PHY_RX_FRAME_FILTER: equ    $00001856                               ;*** PHY_RX_FRAME_FILTER - ; 0x00001856 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PHY_RX_FRAME_FILTER_BEACON_FT: equ    0             
PHY_RX_FRAME_FILTER_DATA_FT: equ    1             
PHY_RX_FRAME_FILTER_ACK_FT: equ    2             
PHY_RX_FRAME_FILTER_CMD_FT: equ    3             
PHY_RX_FRAME_FILTER_NS_FT: equ    4             
; bit position masks
mPHY_RX_FRAME_FILTER_BEACON_FT: equ    %00000001
mPHY_RX_FRAME_FILTER_DATA_FT: equ    %00000010
mPHY_RX_FRAME_FILTER_ACK_FT: equ    %00000100
mPHY_RX_FRAME_FILTER_CMD_FT: equ    %00001000
mPHY_RX_FRAME_FILTER_NS_FT: equ    %00010000


;*** PHY_MACFRAMEVER - ; 0x00001857 ***
PHY_MACFRAMEVER:    equ    $00001857                                ;*** PHY_MACFRAMEVER - ; 0x00001857 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PHY_MACFRAMEVER_FRM_VER0: equ    0                                   ; , bit 0
PHY_MACFRAMEVER_FRM_VER1: equ    1                                   ; , bit 1
PHY_MACFRAMEVER_TMR_PRESCALE0: equ    5                              ; , bit 0
PHY_MACFRAMEVER_TMR_PRESCALE1: equ    6                              ; , bit 1
PHY_MACFRAMEVER_TMR_PRESCALE2: equ    7                              ; , bit 2
; bit position masks
mPHY_MACFRAMEVER_FRM_VER0: equ    %00000001
mPHY_MACFRAMEVER_FRM_VER1: equ    %00000010
mPHY_MACFRAMEVER_TMR_PRESCALE0: equ    %00100000
mPHY_MACFRAMEVER_TMR_PRESCALE1: equ    %01000000
mPHY_MACFRAMEVER_TMR_PRESCALE2: equ    %10000000


;*** PHY_CCA_THRESHOLD - ; 0x00001858 ***
PHY_CCA_THRESHOLD:  equ    $00001858                                ;*** PHY_CCA_THRESHOLD - ; 0x00001858 ***


;*** PHY_CCA_OFFSET_CMP - ; 0x00001859 ***
PHY_CCA_OFFSET_CMP: equ    $00001859                                ;*** PHY_CCA_OFFSET_CMP - ; 0x00001859 ***


;*** PHY_FSM - ; 0x0000185A ***
PHY_FSM:            equ    $0000185A                                ;*** PHY_FSM - ; 0x0000185A ***


;*** PHY_INDIRECT_ACCESS_INDEX - ; 0x0000185B ***
PHY_INDIRECT_ACCESS_INDEX: equ    $0000185B                         ;*** PHY_INDIRECT_ACCESS_INDEX - ; 0x0000185B ***


;*** PHY_INDIRECT_ACCESS_REG - ; 0x0000185C ***
PHY_INDIRECT_ACCESS_REG: equ    $0000185C                           ;*** PHY_INDIRECT_ACCESS_REG - ; 0x0000185C ***


;*** TPM4SC - TPM4 Status and Control Register; 0x00001860 ***
TPM4SC:             equ    $00001860                                ;*** TPM4SC - TPM4 Status and Control Register; 0x00001860 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM4SC_PS0:         equ    0                                         ; Prescale Divisor Select Bit 0
TPM4SC_PS1:         equ    1                                         ; Prescale Divisor Select Bit 1
TPM4SC_PS2:         equ    2                                         ; Prescale Divisor Select Bit 2
TPM4SC_CLKSA:       equ    3                                         ; Clock Source Select A
TPM4SC_CLKSB:       equ    4                                         ; Clock Source Select B
TPM4SC_CPWMS:       equ    5                                         ; Center-Aligned PWM Select
TPM4SC_TOIE:        equ    6                                         ; Timer Overflow Interrupt Enable
TPM4SC_TOF:         equ    7                                         ; Timer Overflow Flag
; bit position masks
mTPM4SC_PS0:        equ    %00000001
mTPM4SC_PS1:        equ    %00000010
mTPM4SC_PS2:        equ    %00000100
mTPM4SC_CLKSA:      equ    %00001000
mTPM4SC_CLKSB:      equ    %00010000
mTPM4SC_CPWMS:      equ    %00100000
mTPM4SC_TOIE:       equ    %01000000
mTPM4SC_TOF:        equ    %10000000


;*** TPM4CNT - TPM4 Timer Counter Register; 0x00001861 ***
TPM4CNT:            equ    $00001861                                ;*** TPM4CNT - TPM4 Timer Counter Register; 0x00001861 ***


;*** TPM4CNTH - TPM4 Timer Counter Register High; 0x00001861 ***
TPM4CNTH:           equ    $00001861                                ;*** TPM4CNTH - TPM4 Timer Counter Register High; 0x00001861 ***


;*** TPM4CNTL - TPM4 Timer Counter Register Low; 0x00001862 ***
TPM4CNTL:           equ    $00001862                                ;*** TPM4CNTL - TPM4 Timer Counter Register Low; 0x00001862 ***


;*** TPM4MOD - TPM4 Timer Counter Modulo Register; 0x00001863 ***
TPM4MOD:            equ    $00001863                                ;*** TPM4MOD - TPM4 Timer Counter Modulo Register; 0x00001863 ***


;*** TPM4MODH - TPM4 Timer Counter Modulo Register High; 0x00001863 ***
TPM4MODH:           equ    $00001863                                ;*** TPM4MODH - TPM4 Timer Counter Modulo Register High; 0x00001863 ***


;*** TPM4MODL - TPM4 Timer Counter Modulo Register Low; 0x00001864 ***
TPM4MODL:           equ    $00001864                                ;*** TPM4MODL - TPM4 Timer Counter Modulo Register Low; 0x00001864 ***


;*** TPM4C0SC - TPM4 Timer Channel 0 Status and Control Register; 0x00001865 ***
TPM4C0SC:           equ    $00001865                                ;*** TPM4C0SC - TPM4 Timer Channel 0 Status and Control Register; 0x00001865 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPM4C0SC_ELS0A:     equ    2                                         ; Edge/Level Select Bit A
TPM4C0SC_ELS0B:     equ    3                                         ; Edge/Level Select Bit B
TPM4C0SC_MS0A:      equ    4                                         ; Mode Select A for TPM Channel 0
TPM4C0SC_MS0B:      equ    5                                         ; Mode Select B for TPM Channel 0
TPM4C0SC_CH0IE:     equ    6                                         ; Channel 0 Interrupt Enable
TPM4C0SC_CH0F:      equ    7                                         ; Channel 0 Flag
; bit position masks
mTPM4C0SC_ELS0A:    equ    %00000100
mTPM4C0SC_ELS0B:    equ    %00001000
mTPM4C0SC_MS0A:     equ    %00010000
mTPM4C0SC_MS0B:     equ    %00100000
mTPM4C0SC_CH0IE:    equ    %01000000
mTPM4C0SC_CH0F:     equ    %10000000


;*** TPM4C0V - TPM4 Timer Channel 0 Value Register; 0x00001866 ***
TPM4C0V:            equ    $00001866                                ;*** TPM4C0V - TPM4 Timer Channel 0 Value Register; 0x00001866 ***


;*** TPM4C0VH - TPM4 Timer Channel 0 Value Register High; 0x00001866 ***
TPM4C0VH:           equ    $00001866                                ;*** TPM4C0VH - TPM4 Timer Channel 0 Value Register High; 0x00001866 ***


;*** TPM4C0VL - TPM4 Timer Channel 0 Value Register Low; 0x00001867 ***
TPM4C0VL:           equ    $00001867                                ;*** TPM4C0VL - TPM4 Timer Channel 0 Value Register Low; 0x00001867 ***


;*** NVBACKKEY0 - Backdoor Comparison Key 0; 0x0000FFB0 ***
NVBACKKEY0:         equ    $0000FFB0                                ;*** NVBACKKEY0 - Backdoor Comparison Key 0; 0x0000FFB0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY0_KEY0:    equ    0                                         ; Backdoor Comparison Key 0 Bits, bit 0
NVBACKKEY0_KEY1:    equ    1                                         ; Backdoor Comparison Key 0 Bits, bit 1
NVBACKKEY0_KEY2:    equ    2                                         ; Backdoor Comparison Key 0 Bits, bit 2
NVBACKKEY0_KEY3:    equ    3                                         ; Backdoor Comparison Key 0 Bits, bit 3
NVBACKKEY0_KEY4:    equ    4                                         ; Backdoor Comparison Key 0 Bits, bit 4
NVBACKKEY0_KEY5:    equ    5                                         ; Backdoor Comparison Key 0 Bits, bit 5
NVBACKKEY0_KEY6:    equ    6                                         ; Backdoor Comparison Key 0 Bits, bit 6
NVBACKKEY0_KEY7:    equ    7                                         ; Backdoor Comparison Key 0 Bits, bit 7
; bit position masks
mNVBACKKEY0_KEY0:   equ    %00000001
mNVBACKKEY0_KEY1:   equ    %00000010
mNVBACKKEY0_KEY2:   equ    %00000100
mNVBACKKEY0_KEY3:   equ    %00001000
mNVBACKKEY0_KEY4:   equ    %00010000
mNVBACKKEY0_KEY5:   equ    %00100000
mNVBACKKEY0_KEY6:   equ    %01000000
mNVBACKKEY0_KEY7:   equ    %10000000


;*** NVBACKKEY1 - Backdoor Comparison Key 1; 0x0000FFB1 ***
NVBACKKEY1:         equ    $0000FFB1                                ;*** NVBACKKEY1 - Backdoor Comparison Key 1; 0x0000FFB1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY1_KEY0:    equ    0                                         ; Backdoor Comparison Key 1 Bits, bit 0
NVBACKKEY1_KEY1:    equ    1                                         ; Backdoor Comparison Key 1 Bits, bit 1
NVBACKKEY1_KEY2:    equ    2                                         ; Backdoor Comparison Key 1 Bits, bit 2
NVBACKKEY1_KEY3:    equ    3                                         ; Backdoor Comparison Key 1 Bits, bit 3
NVBACKKEY1_KEY4:    equ    4                                         ; Backdoor Comparison Key 1 Bits, bit 4
NVBACKKEY1_KEY5:    equ    5                                         ; Backdoor Comparison Key 1 Bits, bit 5
NVBACKKEY1_KEY6:    equ    6                                         ; Backdoor Comparison Key 1 Bits, bit 6
NVBACKKEY1_KEY7:    equ    7                                         ; Backdoor Comparison Key 1 Bits, bit 7
; bit position masks
mNVBACKKEY1_KEY0:   equ    %00000001
mNVBACKKEY1_KEY1:   equ    %00000010
mNVBACKKEY1_KEY2:   equ    %00000100
mNVBACKKEY1_KEY3:   equ    %00001000
mNVBACKKEY1_KEY4:   equ    %00010000
mNVBACKKEY1_KEY5:   equ    %00100000
mNVBACKKEY1_KEY6:   equ    %01000000
mNVBACKKEY1_KEY7:   equ    %10000000


;*** NVBACKKEY2 - Backdoor Comparison Key 2; 0x0000FFB2 ***
NVBACKKEY2:         equ    $0000FFB2                                ;*** NVBACKKEY2 - Backdoor Comparison Key 2; 0x0000FFB2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY2_KEY0:    equ    0                                         ; Backdoor Comparison Key 2 Bits, bit 0
NVBACKKEY2_KEY1:    equ    1                                         ; Backdoor Comparison Key 2 Bits, bit 1
NVBACKKEY2_KEY2:    equ    2                                         ; Backdoor Comparison Key 2 Bits, bit 2
NVBACKKEY2_KEY3:    equ    3                                         ; Backdoor Comparison Key 2 Bits, bit 3
NVBACKKEY2_KEY4:    equ    4                                         ; Backdoor Comparison Key 2 Bits, bit 4
NVBACKKEY2_KEY5:    equ    5                                         ; Backdoor Comparison Key 2 Bits, bit 5
NVBACKKEY2_KEY6:    equ    6                                         ; Backdoor Comparison Key 2 Bits, bit 6
NVBACKKEY2_KEY7:    equ    7                                         ; Backdoor Comparison Key 2 Bits, bit 7
; bit position masks
mNVBACKKEY2_KEY0:   equ    %00000001
mNVBACKKEY2_KEY1:   equ    %00000010
mNVBACKKEY2_KEY2:   equ    %00000100
mNVBACKKEY2_KEY3:   equ    %00001000
mNVBACKKEY2_KEY4:   equ    %00010000
mNVBACKKEY2_KEY5:   equ    %00100000
mNVBACKKEY2_KEY6:   equ    %01000000
mNVBACKKEY2_KEY7:   equ    %10000000


;*** NVBACKKEY3 - Backdoor Comparison Key 3; 0x0000FFB3 ***
NVBACKKEY3:         equ    $0000FFB3                                ;*** NVBACKKEY3 - Backdoor Comparison Key 3; 0x0000FFB3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY3_KEY0:    equ    0                                         ; Backdoor Comparison Key 3 Bits, bit 0
NVBACKKEY3_KEY1:    equ    1                                         ; Backdoor Comparison Key 3 Bits, bit 1
NVBACKKEY3_KEY2:    equ    2                                         ; Backdoor Comparison Key 3 Bits, bit 2
NVBACKKEY3_KEY3:    equ    3                                         ; Backdoor Comparison Key 3 Bits, bit 3
NVBACKKEY3_KEY4:    equ    4                                         ; Backdoor Comparison Key 3 Bits, bit 4
NVBACKKEY3_KEY5:    equ    5                                         ; Backdoor Comparison Key 3 Bits, bit 5
NVBACKKEY3_KEY6:    equ    6                                         ; Backdoor Comparison Key 3 Bits, bit 6
NVBACKKEY3_KEY7:    equ    7                                         ; Backdoor Comparison Key 3 Bits, bit 7
; bit position masks
mNVBACKKEY3_KEY0:   equ    %00000001
mNVBACKKEY3_KEY1:   equ    %00000010
mNVBACKKEY3_KEY2:   equ    %00000100
mNVBACKKEY3_KEY3:   equ    %00001000
mNVBACKKEY3_KEY4:   equ    %00010000
mNVBACKKEY3_KEY5:   equ    %00100000
mNVBACKKEY3_KEY6:   equ    %01000000
mNVBACKKEY3_KEY7:   equ    %10000000


;*** NVBACKKEY4 - Backdoor Comparison Key 4; 0x0000FFB4 ***
NVBACKKEY4:         equ    $0000FFB4                                ;*** NVBACKKEY4 - Backdoor Comparison Key 4; 0x0000FFB4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY4_KEY0:    equ    0                                         ; Backdoor Comparison Key 4 Bits, bit 0
NVBACKKEY4_KEY1:    equ    1                                         ; Backdoor Comparison Key 4 Bits, bit 1
NVBACKKEY4_KEY2:    equ    2                                         ; Backdoor Comparison Key 4 Bits, bit 2
NVBACKKEY4_KEY3:    equ    3                                         ; Backdoor Comparison Key 4 Bits, bit 3
NVBACKKEY4_KEY4:    equ    4                                         ; Backdoor Comparison Key 4 Bits, bit 4
NVBACKKEY4_KEY5:    equ    5                                         ; Backdoor Comparison Key 4 Bits, bit 5
NVBACKKEY4_KEY6:    equ    6                                         ; Backdoor Comparison Key 4 Bits, bit 6
NVBACKKEY4_KEY7:    equ    7                                         ; Backdoor Comparison Key 4 Bits, bit 7
; bit position masks
mNVBACKKEY4_KEY0:   equ    %00000001
mNVBACKKEY4_KEY1:   equ    %00000010
mNVBACKKEY4_KEY2:   equ    %00000100
mNVBACKKEY4_KEY3:   equ    %00001000
mNVBACKKEY4_KEY4:   equ    %00010000
mNVBACKKEY4_KEY5:   equ    %00100000
mNVBACKKEY4_KEY6:   equ    %01000000
mNVBACKKEY4_KEY7:   equ    %10000000


;*** NVBACKKEY5 - Backdoor Comparison Key 5; 0x0000FFB5 ***
NVBACKKEY5:         equ    $0000FFB5                                ;*** NVBACKKEY5 - Backdoor Comparison Key 5; 0x0000FFB5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY5_KEY0:    equ    0                                         ; Backdoor Comparison Key 5 Bits, bit 0
NVBACKKEY5_KEY1:    equ    1                                         ; Backdoor Comparison Key 5 Bits, bit 1
NVBACKKEY5_KEY2:    equ    2                                         ; Backdoor Comparison Key 5 Bits, bit 2
NVBACKKEY5_KEY3:    equ    3                                         ; Backdoor Comparison Key 5 Bits, bit 3
NVBACKKEY5_KEY4:    equ    4                                         ; Backdoor Comparison Key 5 Bits, bit 4
NVBACKKEY5_KEY5:    equ    5                                         ; Backdoor Comparison Key 5 Bits, bit 5
NVBACKKEY5_KEY6:    equ    6                                         ; Backdoor Comparison Key 5 Bits, bit 6
NVBACKKEY5_KEY7:    equ    7                                         ; Backdoor Comparison Key 5 Bits, bit 7
; bit position masks
mNVBACKKEY5_KEY0:   equ    %00000001
mNVBACKKEY5_KEY1:   equ    %00000010
mNVBACKKEY5_KEY2:   equ    %00000100
mNVBACKKEY5_KEY3:   equ    %00001000
mNVBACKKEY5_KEY4:   equ    %00010000
mNVBACKKEY5_KEY5:   equ    %00100000
mNVBACKKEY5_KEY6:   equ    %01000000
mNVBACKKEY5_KEY7:   equ    %10000000


;*** NVBACKKEY6 - Backdoor Comparison Key 6; 0x0000FFB6 ***
NVBACKKEY6:         equ    $0000FFB6                                ;*** NVBACKKEY6 - Backdoor Comparison Key 6; 0x0000FFB6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY6_KEY0:    equ    0                                         ; Backdoor Comparison Key 6 Bits, bit 0
NVBACKKEY6_KEY1:    equ    1                                         ; Backdoor Comparison Key 6 Bits, bit 1
NVBACKKEY6_KEY2:    equ    2                                         ; Backdoor Comparison Key 6 Bits, bit 2
NVBACKKEY6_KEY3:    equ    3                                         ; Backdoor Comparison Key 6 Bits, bit 3
NVBACKKEY6_KEY4:    equ    4                                         ; Backdoor Comparison Key 6 Bits, bit 4
NVBACKKEY6_KEY5:    equ    5                                         ; Backdoor Comparison Key 6 Bits, bit 5
NVBACKKEY6_KEY6:    equ    6                                         ; Backdoor Comparison Key 6 Bits, bit 6
NVBACKKEY6_KEY7:    equ    7                                         ; Backdoor Comparison Key 6 Bits, bit 7
; bit position masks
mNVBACKKEY6_KEY0:   equ    %00000001
mNVBACKKEY6_KEY1:   equ    %00000010
mNVBACKKEY6_KEY2:   equ    %00000100
mNVBACKKEY6_KEY3:   equ    %00001000
mNVBACKKEY6_KEY4:   equ    %00010000
mNVBACKKEY6_KEY5:   equ    %00100000
mNVBACKKEY6_KEY6:   equ    %01000000
mNVBACKKEY6_KEY7:   equ    %10000000


;*** NVBACKKEY7 - Backdoor Comparison Key 7; 0x0000FFB7 ***
NVBACKKEY7:         equ    $0000FFB7                                ;*** NVBACKKEY7 - Backdoor Comparison Key 7; 0x0000FFB7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY7_KEY0:    equ    0                                         ; Backdoor Comparison Key 7 Bits, bit 0
NVBACKKEY7_KEY1:    equ    1                                         ; Backdoor Comparison Key 7 Bits, bit 1
NVBACKKEY7_KEY2:    equ    2                                         ; Backdoor Comparison Key 7 Bits, bit 2
NVBACKKEY7_KEY3:    equ    3                                         ; Backdoor Comparison Key 7 Bits, bit 3
NVBACKKEY7_KEY4:    equ    4                                         ; Backdoor Comparison Key 7 Bits, bit 4
NVBACKKEY7_KEY5:    equ    5                                         ; Backdoor Comparison Key 7 Bits, bit 5
NVBACKKEY7_KEY6:    equ    6                                         ; Backdoor Comparison Key 7 Bits, bit 6
NVBACKKEY7_KEY7:    equ    7                                         ; Backdoor Comparison Key 7 Bits, bit 7
; bit position masks
mNVBACKKEY7_KEY0:   equ    %00000001
mNVBACKKEY7_KEY1:   equ    %00000010
mNVBACKKEY7_KEY2:   equ    %00000100
mNVBACKKEY7_KEY3:   equ    %00001000
mNVBACKKEY7_KEY4:   equ    %00010000
mNVBACKKEY7_KEY5:   equ    %00100000
mNVBACKKEY7_KEY6:   equ    %01000000
mNVBACKKEY7_KEY7:   equ    %10000000


;*** NVPROT - Nonvolatile Flash Protection Register; 0x0000FFBD ***
NVPROT:             equ    $0000FFBD                                ;*** NVPROT - Nonvolatile Flash Protection Register; 0x0000FFBD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVPROT_FPOPEN:      equ    0                                         ; Flash Protection Open
NVPROT_FPS0:        equ    1                                         ; Flash Protection Size, bit 0
NVPROT_FPS1:        equ    2                                         ; Flash Protection Size, bit 1
NVPROT_FPS2:        equ    3                                         ; Flash Protection Size, bit 2
NVPROT_FPS3:        equ    4                                         ; Flash Protection Size, bit 3
NVPROT_FPS4:        equ    5                                         ; Flash Protection Size, bit 4
NVPROT_FPS5:        equ    6                                         ; Flash Protection Size, bit 5
NVPROT_FPS6:        equ    7                                         ; Flash Protection Size, bit 6
; bit position masks
mNVPROT_FPOPEN:     equ    %00000001
mNVPROT_FPS0:       equ    %00000010
mNVPROT_FPS1:       equ    %00000100
mNVPROT_FPS2:       equ    %00001000
mNVPROT_FPS3:       equ    %00010000
mNVPROT_FPS4:       equ    %00100000
mNVPROT_FPS5:       equ    %01000000
mNVPROT_FPS6:       equ    %10000000


;*** NVOPT - Nonvolatile Flash Options Register; 0x0000FFBF ***
NVOPT:              equ    $0000FFBF                                ;*** NVOPT - Nonvolatile Flash Options Register; 0x0000FFBF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVOPT_SEC0:         equ    0                                         ; Flash Security Bit 0
NVOPT_SEC1:         equ    1                                         ; Flash Security Bit 1
NVOPT_KEYEN0:       equ    6                                         ; Backdoor Key Security Enable Bit 0
NVOPT_KEYEN1:       equ    7                                         ; Backdoor Key Security Enable Bit 1
; bit position masks
mNVOPT_SEC0:        equ    %00000001
mNVOPT_SEC1:        equ    %00000010
mNVOPT_KEYEN0:      equ    %01000000
mNVOPT_KEYEN1:      equ    %10000000



; Flash commands
mBlank:             equ     $05
mBurstProg:         equ     $25
mByteProg:          equ     $20
mMassErase:         equ     $41
mPageErase:         equ     $40


;***********************************************
;**   D E P R E C I A T E D   S Y M B O L S   **
;***********************************************
        IFNDEF  __GENERATE_APPLICATION__                            ; not supported for absolute assembler
                    XREF    This_symb_has_been_depreciated
        ENDIF

; EOF
