/*
 * Copyright 2019 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
 

#include "smartdma_keyscan.h"
#include "stdint.h"


/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define KEY_ROW_1_OFFSET 0
#define KEY_ROW_2_OFFSET 1
#define KEY_ROW_3_OFFSET 2
#define KEY_ROW_4_OFFSET 3
#define KEY_ROW_5_OFFSET 4
#define KEY_ROW_6_OFFSET 5
#define KEY_COLUMN_1_OFFSET (KEY_ROW_COUNT + 0)
#define KEY_COLUMN_2_OFFSET (KEY_ROW_COUNT + 1)
#define KEY_COLUMN_3_OFFSET (KEY_ROW_COUNT + 2)
#define KEY_COLUMN_4_OFFSET (KEY_ROW_COUNT + 3)
#define KEY_COLUMN_5_OFFSET (KEY_ROW_COUNT + 4)
#define KEY_COLUMN_6_OFFSET (KEY_ROW_COUNT + 5)
#define KEY_COLUMN_7_OFFSET (KEY_ROW_COUNT + 6)
#define KEY_COLUMN_8_OFFSET (KEY_ROW_COUNT + 7)
#define KEY_COLUMN_9_OFFSET (KEY_ROW_COUNT + 8)
#define KEY_COLUMN_10_OFFSET (KEY_ROW_COUNT + 9)
#define KEY_COLUMN_11_OFFSET (KEY_ROW_COUNT + 10)
#define KEY_COLUMN_12_OFFSET (KEY_ROW_COUNT + 11)
#define KEY_COLUMN_13_OFFSET (KEY_ROW_COUNT + 12)
#define KEY_COLUMN_14_OFFSET (KEY_ROW_COUNT + 13)
#define KEY_COLUMN_15_OFFSET (KEY_ROW_COUNT + 14)

/* SmartDMA_PIO0: P1_4*/
#define PIN_SMARTDMAIO0_DEBUG          0

/*******************************************************************************
 * Prototypes
 ******************************************************************************/
#define NEED_DELAY 1

/************************************************************************************************/
#if USE_6X15_KEYBOARD == 1

const uint8_t s_smartdmaKeyscanFirmware_6x15[] = {
    0x45, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x80, 0xB4, 0x00, 0xAF, 0x12, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00,
    0x12, 0x00, 0x00, 0x00, 0x04, 0x18, 0x04, 0x33, 0x10, 0x18, 0x68, 0x02, 0x10, 0x18, 0x60, 0x02,
    0x01, 0xB0, 0x05, 0x00, 0x01, 0x9C, 0x05, 0x02, 0x01, 0x80, 0x05, 0x03, 0x01, 0x00, 0x04, 0x00,
    0x32, 0x02, 0x00, 0x00, 0x01, 0x98, 0x05, 0x01, 0x18, 0x64, 0x02, 0xCB, 0x01, 0xBC, 0x05, 0x06,
    0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x07, 0x00, 0x2C, 0x14, 0x00,
    0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x08, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00,
    0x01, 0xBC, 0x05, 0x09, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x0A,
    0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x0B, 0x00, 0x2C, 0x14, 0x00,
    0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x0C, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00,
    0x01, 0xBC, 0x05, 0x0D, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x0E,
    0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x0F, 0x00, 0x2C, 0x14, 0x00,
    0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x10, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00,
    0x01, 0xBC, 0x05, 0x11, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x12,
    0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x13, 0x00, 0x2C, 0x14, 0x00,
    0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x14, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00,
    0x00, 0x50, 0x03, 0x00, 0x06, 0x74, 0x47, 0x00, 0x40, 0x01, 0x00, 0x04, 0xD4, 0x08, 0x00, 0x04,
    0x18, 0x20, 0x02, 0xEB, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x08, 0x04, 0x00,
    0x00, 0x0C, 0x04, 0x00, 0x00, 0x14, 0x14, 0x00, 0x01, 0xBC, 0x05, 0x06, 0x00, 0x2C, 0x04, 0x00,
    0x02, 0xC0, 0xB3, 0x00, 0x72, 0x00, 0x00, 0x00, 0x01, 0xBC, 0x05, 0x00, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x2C, 0x00, 0x50, 0x00, 0x01, 0xBC, 0x05, 0x01, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x4F, 0x01, 0xBC, 0x05, 0x02, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x40, 0x01, 0xBC, 0x05, 0x03, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x4F, 0x01, 0xBC, 0x05, 0x04, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x40, 0x01, 0xBC, 0x05, 0x05, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x4F, 0x01, 0xBC, 0x05, 0x06, 0x00, 0x2C, 0x14, 0x00,
    0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x07, 0x00, 0x2C, 0x04, 0x00, 0x02, 0xC0, 0xB3, 0x00,
    0x72, 0x00, 0x00, 0x00, 0x01, 0xBC, 0x05, 0x00, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x00, 0x50, 0x41, 0x01, 0xBC, 0x05, 0x01, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x00, 0x50, 0x50, 0x01, 0xBC, 0x05, 0x02, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x44, 0x50, 0x41, 0x01, 0xBC, 0x05, 0x03, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x44, 0x50, 0x50, 0x01, 0xBC, 0x05, 0x04, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x88, 0x50, 0x41, 0x01, 0xBC, 0x05, 0x05, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x88, 0x50, 0x50, 0x01, 0xBC, 0x05, 0x07, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00,
    0x01, 0xBC, 0x05, 0x08, 0x00, 0x2C, 0x04, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x72, 0x00, 0x00, 0x00,
    0x01, 0xBC, 0x05, 0x00, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x42,
    0x01, 0xBC, 0x05, 0x01, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x51,
    0x01, 0xBC, 0x05, 0x02, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x42,
    0x01, 0xBC, 0x05, 0x03, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x51,
    0x01, 0xBC, 0x05, 0x04, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x42,
    0x01, 0xBC, 0x05, 0x05, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x51,
    0x01, 0xBC, 0x05, 0x08, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x09,
    0x00, 0x2C, 0x04, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x72, 0x00, 0x00, 0x00, 0x01, 0xBC, 0x05, 0x00,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x43, 0x01, 0xBC, 0x05, 0x01,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x52, 0x01, 0xBC, 0x05, 0x02,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x43, 0x01, 0xBC, 0x05, 0x03,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x52, 0x01, 0xBC, 0x05, 0x04,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x43, 0x01, 0xBC, 0x05, 0x05,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x52, 0x01, 0xBC, 0x05, 0x09,
    0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x0A, 0x00, 0x2C, 0x04, 0x00,
    0x02, 0xC0, 0xB3, 0x00, 0x72, 0x00, 0x00, 0x00, 0x01, 0xBC, 0x05, 0x00, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x44, 0x01, 0xBC, 0x05, 0x01, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x53, 0x01, 0xBC, 0x05, 0x02, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x44, 0x01, 0xBC, 0x05, 0x03, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x53, 0x01, 0xBC, 0x05, 0x04, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x44, 0x01, 0xBC, 0x05, 0x05, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x53, 0x01, 0xBC, 0x05, 0x0A, 0x00, 0x2C, 0x14, 0x00,
    0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x0B, 0x00, 0x2C, 0x04, 0x00, 0x02, 0xC0, 0xB3, 0x00,
    0x72, 0x00, 0x00, 0x00, 0x01, 0xBC, 0x05, 0x00, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x00, 0x50, 0x45, 0x01, 0xBC, 0x05, 0x01, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x00, 0x50, 0x54, 0x01, 0xBC, 0x05, 0x02, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x44, 0x50, 0x45, 0x01, 0xBC, 0x05, 0x03, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x44, 0x50, 0x54, 0x01, 0xBC, 0x05, 0x04, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x88, 0x50, 0x45, 0x01, 0xBC, 0x05, 0x05, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x88, 0x50, 0x54, 0x01, 0xBC, 0x05, 0x0B, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00,
    0x01, 0xBC, 0x05, 0x0C, 0x00, 0x2C, 0x04, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x72, 0x00, 0x00, 0x00,
    0x01, 0xBC, 0x05, 0x00, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x46,
    0x01, 0xBC, 0x05, 0x01, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x55,
    0x01, 0xBC, 0x05, 0x02, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x46,
    0x01, 0xBC, 0x05, 0x03, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x55,
    0x01, 0xBC, 0x05, 0x04, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x46,
    0x01, 0xBC, 0x05, 0x05, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x55,
    0x01, 0xBC, 0x05, 0x0C, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x0D,
    0x00, 0x2C, 0x04, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x72, 0x00, 0x00, 0x00, 0x01, 0xBC, 0x05, 0x00,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x47, 0x01, 0xBC, 0x05, 0x01,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x56, 0x01, 0xBC, 0x05, 0x02,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x47, 0x01, 0xBC, 0x05, 0x03,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x56, 0x01, 0xBC, 0x05, 0x04,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x47, 0x01, 0xBC, 0x05, 0x05,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x56, 0x01, 0xBC, 0x05, 0x0D,
    0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x0E, 0x00, 0x2C, 0x04, 0x00,
    0x02, 0xC0, 0xB3, 0x00, 0x72, 0x00, 0x00, 0x00, 0x01, 0xBC, 0x05, 0x00, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x48, 0x01, 0xBC, 0x05, 0x01, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x57, 0x01, 0xBC, 0x05, 0x02, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x48, 0x01, 0xBC, 0x05, 0x03, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x57, 0x01, 0xBC, 0x05, 0x04, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x48, 0x01, 0xBC, 0x05, 0x05, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x57, 0x01, 0xBC, 0x05, 0x0E, 0x00, 0x2C, 0x14, 0x00,
    0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x0F, 0x00, 0x2C, 0x04, 0x00, 0x02, 0xC0, 0xB3, 0x00,
    0x72, 0x00, 0x00, 0x00, 0x01, 0xBC, 0x05, 0x00, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x00, 0x50, 0x49, 0x01, 0xBC, 0x05, 0x01, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x00, 0x50, 0x58, 0x01, 0xBC, 0x05, 0x02, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x44, 0x50, 0x49, 0x01, 0xBC, 0x05, 0x03, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x44, 0x50, 0x58, 0x01, 0xBC, 0x05, 0x04, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x88, 0x50, 0x49, 0x01, 0xBC, 0x05, 0x05, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x88, 0x50, 0x58, 0x01, 0xBC, 0x05, 0x0F, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00,
    0x01, 0xBC, 0x05, 0x10, 0x00, 0x2C, 0x04, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x72, 0x00, 0x00, 0x00,
    0x01, 0xBC, 0x05, 0x00, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x4A,
    0x01, 0xBC, 0x05, 0x01, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x59,
    0x01, 0xBC, 0x05, 0x02, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x4A,
    0x01, 0xBC, 0x05, 0x03, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x59,
    0x01, 0xBC, 0x05, 0x04, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x4A,
    0x01, 0xBC, 0x05, 0x05, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x59,
    0x01, 0xBC, 0x05, 0x10, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x11,
    0x00, 0x2C, 0x04, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x72, 0x00, 0x00, 0x00, 0x01, 0xBC, 0x05, 0x00,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x4B, 0x01, 0xBC, 0x05, 0x01,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x5A, 0x01, 0xBC, 0x05, 0x02,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x4B, 0x01, 0xBC, 0x05, 0x03,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x5A, 0x01, 0xBC, 0x05, 0x04,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x4B, 0x01, 0xBC, 0x05, 0x05,
    0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x5A, 0x01, 0xBC, 0x05, 0x11,
    0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x12, 0x00, 0x2C, 0x04, 0x00,
    0x02, 0xC0, 0xB3, 0x00, 0x72, 0x00, 0x00, 0x00, 0x01, 0xBC, 0x05, 0x00, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x4C, 0x01, 0xBC, 0x05, 0x01, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x5B, 0x01, 0xBC, 0x05, 0x02, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x4C, 0x01, 0xBC, 0x05, 0x03, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x5B, 0x01, 0xBC, 0x05, 0x04, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x4C, 0x01, 0xBC, 0x05, 0x05, 0x01, 0xFC, 0x03, 0x00,
    0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x5B, 0x01, 0xBC, 0x05, 0x12, 0x00, 0x2C, 0x14, 0x00,
    0x02, 0xC0, 0xB3, 0x00, 0x01, 0xBC, 0x05, 0x13, 0x00, 0x2C, 0x04, 0x00, 0x02, 0xC0, 0xB3, 0x00,
    0x72, 0x00, 0x00, 0x00, 0x01, 0xBC, 0x05, 0x00, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x00, 0x50, 0x4D, 0x01, 0xBC, 0x05, 0x01, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x00, 0x50, 0x5C, 0x01, 0xBC, 0x05, 0x02, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x44, 0x50, 0x4D, 0x01, 0xBC, 0x05, 0x03, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x44, 0x50, 0x5C, 0x01, 0xBC, 0x05, 0x04, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x88, 0x50, 0x4D, 0x01, 0xBC, 0x05, 0x05, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0,
    0x30, 0x88, 0x50, 0x5C, 0x01, 0xBC, 0x05, 0x13, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00,
    0x01, 0xBC, 0x05, 0x14, 0x00, 0x2C, 0x04, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x72, 0x00, 0x00, 0x00,
    0x01, 0xBC, 0x05, 0x00, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x4E,
    0x01, 0xBC, 0x05, 0x01, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x00, 0x50, 0x5D,
    0x01, 0xBC, 0x05, 0x02, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x4E,
    0x01, 0xBC, 0x05, 0x03, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x44, 0x50, 0x5D,
    0x01, 0xBC, 0x05, 0x04, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x4E,
    0x01, 0xBC, 0x05, 0x05, 0x01, 0xFC, 0x03, 0x00, 0x18, 0xFE, 0x03, 0xA0, 0x30, 0x88, 0x50, 0x5D,
    0x01, 0xBC, 0x05, 0x14, 0x00, 0x2C, 0x14, 0x00, 0x02, 0xC0, 0xB3, 0x00, 0x18, 0x20, 0x02, 0xEB,
    0xE1, 0x35, 0x05, 0x00, 0x01, 0xD4, 0x05, 0x00, 0x01, 0xFC, 0x05, 0x01, 0x0E, 0x16, 0x50, 0x00,
    0x41, 0x34, 0x05, 0x01, 0x01, 0xD4, 0x05, 0x02, 0x0E, 0x7E, 0xF0, 0x00, 0x41, 0x34, 0x05, 0x01,
    0x01, 0xFC, 0x05, 0x03, 0x0E, 0x96, 0x50, 0x00, 0x41, 0x34, 0x05, 0x01, 0x0E, 0xFE, 0xF0, 0x00,
    0x21, 0x34, 0x05, 0x00, 0x02, 0xC0, 0x05, 0x00, 0x02, 0xC0, 0x15, 0x01, 0x02, 0xC0, 0x25, 0x02,
    0x02, 0xC0, 0x35, 0x03, 0x14, 0x34, 0x12, 0x00, 0x43, 0x01, 0x00, 0x04, 0x00, 0xBF, 0xBD, 0x46,
    0x5D, 0xF8, 0x04, 0x7B, 0x70, 0x47, 0x00, 0xBF
};

const uint32_t s_smartdmaKeyscanFirmwareSize_6x15 = sizeof(s_smartdmaKeyscanFirmware_6x15);
#endif





