/*
 * Copyright 2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef LIGHT_EFFECT_H
#define LIGHT_EFFECT_H

#include "stdint.h"
#include "stdio.h"
#include "string.h"


typedef enum _lighe_effect
{
    kLIGHT_EFFECT_0     = 0,       /***/
	kLIGHT_EFFECT_1,               /***/
	kLIGHT_EFFECT_2,               /***/
	kLIGHT_EFFECT_3,               /***/
	kLIGHT_EFFECT_BREATHING,       /***/
	kLIGHT_EFFECT_COUNT,
	kLIGHT_EFFECT_DISABLE = 0xFF,  /***/

} lighe_effect_t;

void light_rendering(uint8_t *rgbData, uint8_t keyNum, uint8_t * spiData);
void light_solid_rendering(uint8_t *rgbData, uint8_t keyNum, uint8_t * spiData);
void show_light_effects(uint8_t *rgbData, uint8_t keyNum, uint8_t index, uint8_t * spiData);
void __led_strip_spi_bit(uint8_t data, uint8_t *buf);

#endif
