/*
 * Copyright 2024 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v16.0
processor: MCXN947
package_id: MCXN947VDF
mcu_data: ksdk2_0
processor_version: 16.3.0
board: FRDM-MCXN947
pin_labels:
- {pin_num: E10, pin_signal: PIO0_27/FC1_P3/CT0_MAT3/ADC0_B19, label: 'P0_27/SJ6[1]', identifier: LED_GREEN}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_port.h"
#include "fsl_gpio.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: A1, peripheral: LP_FLEXCOMM4, signal: LPFLEXCOMM_P0, pin_signal: PIO1_8/WUU0_IN10/LPTMR1_ALT3/TRACE_DATA0/FC4_P0/FC5_P4/CT_INP8/SCT0_OUT2/FLEXIO0_D16/EZH_PIO4/PLU_OUT0/ENET0_TXD2/I3C1_SDA/TSI0_CH17/ADC1_A8,
    slew_rate: fast, open_drain: disable, drive_strength: low, pull_select: down, pull_enable: disable, passive_filter: disable, pull_value: low, input_buffer: enable,
    invert_input: normal}
  - {pin_num: B1, peripheral: LP_FLEXCOMM4, signal: LPFLEXCOMM_P1, pin_signal: PIO1_9/TRACE_DATA1/FC4_P1/FC5_P5/CT_INP9/SCT0_OUT3/FLEXIO0_D17/EZH_PIO5/PLU_OUT1/ENET0_TXD3/I3C1_SCL/TSI0_CH18/ADC1_A9,
    slew_rate: fast, open_drain: disable, drive_strength: low, pull_select: down, pull_enable: disable, passive_filter: disable, input_buffer: enable, invert_input: normal}
  - {pin_num: B16, peripheral: SWD, signal: SWO, pin_signal: PIO0_2/TDO/SWO/FC1_P2/CT0_MAT0/UTICK_CAP0/I3C0_PUR, slew_rate: fast, open_drain: disable, drive_strength: high,
    pull_select: down, pull_enable: disable, input_buffer: enable, invert_input: normal}
  - {pin_num: B12, peripheral: GPIO0, signal: 'GPIO, 10', pin_signal: PIO0_10/FC0_P6/CT0_MAT0/FLEXIO0_D2/ADC0_B10, direction: OUTPUT, gpio_init_state: 'true'}
  - {pin_num: E10, peripheral: CTIMER0, signal: 'MATCH, 3', pin_signal: PIO0_27/FC1_P3/CT0_MAT3/ADC0_B19}
  - {pin_num: P3, peripheral: ADC0, signal: 'A, 0', pin_signal: ADC0_A0}
  - {pin_num: B8, peripheral: ADC0, signal: 'A, 14', pin_signal: PIO0_22/EWM0_IN/FC0_P6/FC1_P2/CT_INP2/FLEXIO0_D6/I3C0_PUR/ADC0_A14/CMP1_IN2}
  - {pin_num: C4, peripheral: GPIO1, signal: 'GPIO, 2', pin_signal: PIO1_2/TRIG_OUT0/FC3_P2/FC4_P6/CT1_MAT0/SCT0_IN6/FLEXIO0_D10/ENET0_MDC/SAI1_TXD0/CAN0_TXD/TSI0_CH2/ADC0_A18/CMP2_IN0,
    direction: OUTPUT, gpio_init_state: 'true'}
  - {pin_num: D2, peripheral: ADC1, signal: 'A, 12', pin_signal: PIO1_12/WUU0_IN12/TRACE_CLK/FC4_P4/FC3_P0/CT2_MAT2/SCT0_OUT4/FLEXIO0_D20/EZH_PIO8/PLU_OUT2/ENET0_RXER/CAN1_RXD/TSI0_CH21/ADC1_A12}
  - {pin_num: D2, peripheral: TSI0, signal: 'CH, 21', pin_signal: PIO1_12/WUU0_IN12/TRACE_CLK/FC4_P4/FC3_P0/CT2_MAT2/SCT0_OUT4/FLEXIO0_D20/EZH_PIO8/PLU_OUT2/ENET0_RXER/CAN1_RXD/TSI0_CH21/ADC1_A12}
  - {pin_num: D1, peripheral: ADC1, signal: 'A, 13', pin_signal: PIO1_13/TRIG_IN3/FC4_P5/FC3_P1/CT2_MAT3/SCT0_OUT5/FLEXIO0_D21/EZH_PIO9/PLU_OUT3/ENET0_RXDV/CAN1_TXD/TSI0_CH22/ADC1_A13}
  - {pin_num: D1, peripheral: TSI0, signal: 'CH, 22', pin_signal: PIO1_13/TRIG_IN3/FC4_P5/FC3_P1/CT2_MAT3/SCT0_OUT5/FLEXIO0_D21/EZH_PIO9/PLU_OUT3/ENET0_RXDV/CAN1_TXD/TSI0_CH22/ADC1_A13}
  - {pin_num: D4, peripheral: ADC1, signal: 'A, 14', pin_signal: PIO1_14/FC4_P6/FC3_P2/CT_INP10/SCT0_IN4/FLEXIO0_D22/EZH_PIO10/PLU_IN2/ENET0_RXD0/TSI0_CH23/ADC1_A14}
  - {pin_num: D4, peripheral: TSI0, signal: 'CH, 23', pin_signal: PIO1_14/FC4_P6/FC3_P2/CT_INP10/SCT0_IN4/FLEXIO0_D22/EZH_PIO10/PLU_IN2/ENET0_RXD0/TSI0_CH23/ADC1_A14}
  - {pin_num: E4, peripheral: ADC1, signal: 'A, 15', pin_signal: PIO1_15/WUU0_IN13/FC3_P3/CT_INP11/SCT0_IN5/FLEXIO0_D23/EZH_PIO11/PLU_IN3/ENET0_RXD1/I3C1_PUR/TSI0_CH24/ADC1_A15}
  - {pin_num: E4, peripheral: TSI0, signal: 'CH, 24', pin_signal: PIO1_15/WUU0_IN13/FC3_P3/CT_INP11/SCT0_IN5/FLEXIO0_D23/EZH_PIO11/PLU_IN3/ENET0_RXD1/I3C1_PUR/TSI0_CH24/ADC1_A15}
  - {pin_num: E11, peripheral: ADC0, signal: 'B, 14', pin_signal: PIO0_14/FC1_P6/FC0_P2/CT_INP2/UTICK_CAP0/FLEXIO0_D6/ADC0_B14}
  - {pin_num: R3, peripheral: ADC0, signal: 'B, 0', pin_signal: ADC0_B0}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPins(void)
{
    /* Enables the clock for GPIO0: Enables clock */
    CLOCK_EnableClock(kCLOCK_Gpio0);
    /* Enables the clock for GPIO1: Enables clock */
    CLOCK_EnableClock(kCLOCK_Gpio1);
    /* Enables the clock for PORT0 controller: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port0);
    /* Enables the clock for PORT1: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port1);

    gpio_pin_config_t LED_RED_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO0_10 (pin B12)  */
    GPIO_PinInit(BOARD_INITPINS_LED_RED_GPIO, BOARD_INITPINS_LED_RED_PIN, &LED_RED_config);

    gpio_pin_config_t LED_BLUE_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO1_2 (pin C4)  */
    GPIO_PinInit(BOARD_INITPINS_LED_BLUE_GPIO, BOARD_INITPINS_LED_BLUE_PIN, &LED_BLUE_config);

    /* PORT0_10 (pin B12) is configured as PIO0_10 */
    PORT_SetPinMux(BOARD_INITPINS_LED_RED_PORT, BOARD_INITPINS_LED_RED_PIN, kPORT_MuxAlt0);

    PORT0->PCR[10] = ((PORT0->PCR[10] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT0_14 (pin E11) is configured as ADC0_B14 */
    PORT_SetPinMux(PORT0, 14U, kPORT_MuxAlt0);

    PORT0->PCR[14] = ((PORT0->PCR[14] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Disables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe0));

    const port_pin_config_t DEBUG_SWD_SWO = {/* Internal pull-up/down resistor is disabled */
                                             .pullSelect = kPORT_PullDisable,
                                             /* Low internal pull resistor value is selected. */
                                             .pullValueSelect = kPORT_LowPullResistor,
                                             /* Fast slew rate is configured */
                                             .slewRate = kPORT_FastSlewRate,
                                             /* Passive input filter is disabled */
                                             .passiveFilterEnable = kPORT_PassiveFilterDisable,
                                             /* Open drain output is disabled */
                                             .openDrainEnable = kPORT_OpenDrainDisable,
                                             /* High drive strength is configured */
                                             .driveStrength = kPORT_HighDriveStrength,
                                             /* Pin is configured as SWO */
                                             .mux = kPORT_MuxAlt1,
                                             /* Digital input enabled */
                                             .inputBuffer = kPORT_InputBufferEnable,
                                             /* Digital input is not inverted */
                                             .invertInput = kPORT_InputNormal,
                                             /* Pin Control Register fields [15:0] are not locked */
                                             .lockRegister = kPORT_UnlockRegister};
    /* PORT0_2 (pin B16) is configured as SWO */
    PORT_SetPinConfig(BOARD_INITPINS_DEBUG_SWD_SWO_PORT, BOARD_INITPINS_DEBUG_SWD_SWO_PIN, &DEBUG_SWD_SWO);

    /* PORT0_22 (pin B8) is configured as ADC0_A14 */
    PORT_SetPinMux(PORT0, 22U, kPORT_MuxAlt0);

    PORT0->PCR[22] = ((PORT0->PCR[22] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Disables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe0));

    /* PORT0_27 (pin E10) is configured as CT0_MAT3 */
    PORT_SetPinMux(BOARD_INITPINS_LED_GREEN_PORT, BOARD_INITPINS_LED_GREEN_PIN, kPORT_MuxAlt4);

    PORT0->PCR[27] = ((PORT0->PCR[27] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT1_12 (pin D2) is configured as ADC1_A12, TSI0_CH21 */
    PORT_SetPinMux(PORT1, 12U, kPORT_MuxAlt0);

    PORT1->PCR[12] = ((PORT1->PCR[12] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Disables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe0));

    /* PORT1_13 (pin D1) is configured as ADC1_A13, TSI0_CH22 */
    PORT_SetPinMux(PORT1, 13U, kPORT_MuxAlt0);

    PORT1->PCR[13] = ((PORT1->PCR[13] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Disables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe0));

    /* PORT1_14 (pin D4) is configured as ADC1_A14, TSI0_CH23 */
    PORT_SetPinMux(PORT1, 14U, kPORT_MuxAlt0);

    PORT1->PCR[14] = ((PORT1->PCR[14] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Disables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe0));

    /* PORT1_15 (pin E4) is configured as ADC1_A15, TSI0_CH24 */
    PORT_SetPinMux(PORT1, 15U, kPORT_MuxAlt0);

    PORT1->PCR[15] = ((PORT1->PCR[15] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Disables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe0));

    /* PORT1_2 (pin C4) is configured as PIO1_2 */
    PORT_SetPinMux(BOARD_INITPINS_LED_BLUE_PORT, BOARD_INITPINS_LED_BLUE_PIN, kPORT_MuxAlt0);

    PORT1->PCR[2] = ((PORT1->PCR[2] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    const port_pin_config_t DEBUG_UART_RX = {/* Internal pull-up/down resistor is disabled */
                                             .pullSelect = kPORT_PullDisable,
                                             /* Low internal pull resistor value is selected. */
                                             .pullValueSelect = kPORT_LowPullResistor,
                                             /* Fast slew rate is configured */
                                             .slewRate = kPORT_FastSlewRate,
                                             /* Passive input filter is disabled */
                                             .passiveFilterEnable = kPORT_PassiveFilterDisable,
                                             /* Open drain output is disabled */
                                             .openDrainEnable = kPORT_OpenDrainDisable,
                                             /* Low drive strength is configured */
                                             .driveStrength = kPORT_LowDriveStrength,
                                             /* Pin is configured as FC4_P0 */
                                             .mux = kPORT_MuxAlt2,
                                             /* Digital input enabled */
                                             .inputBuffer = kPORT_InputBufferEnable,
                                             /* Digital input is not inverted */
                                             .invertInput = kPORT_InputNormal,
                                             /* Pin Control Register fields [15:0] are not locked */
                                             .lockRegister = kPORT_UnlockRegister};
    /* PORT1_8 (pin A1) is configured as FC4_P0 */
    PORT_SetPinConfig(BOARD_INITPINS_DEBUG_UART_RX_PORT, BOARD_INITPINS_DEBUG_UART_RX_PIN, &DEBUG_UART_RX);

    const port_pin_config_t DEBUG_UART_TX = {/* Internal pull-up/down resistor is disabled */
                                             .pullSelect = kPORT_PullDisable,
                                             /* Low internal pull resistor value is selected. */
                                             .pullValueSelect = kPORT_LowPullResistor,
                                             /* Fast slew rate is configured */
                                             .slewRate = kPORT_FastSlewRate,
                                             /* Passive input filter is disabled */
                                             .passiveFilterEnable = kPORT_PassiveFilterDisable,
                                             /* Open drain output is disabled */
                                             .openDrainEnable = kPORT_OpenDrainDisable,
                                             /* Low drive strength is configured */
                                             .driveStrength = kPORT_LowDriveStrength,
                                             /* Pin is configured as FC4_P1 */
                                             .mux = kPORT_MuxAlt2,
                                             /* Digital input enabled */
                                             .inputBuffer = kPORT_InputBufferEnable,
                                             /* Digital input is not inverted */
                                             .invertInput = kPORT_InputNormal,
                                             /* Pin Control Register fields [15:0] are not locked */
                                             .lockRegister = kPORT_UnlockRegister};
    /* PORT1_9 (pin B1) is configured as FC4_P1 */
    PORT_SetPinConfig(BOARD_INITPINS_DEBUG_UART_TX_PORT, BOARD_INITPINS_DEBUG_UART_TX_PIN, &DEBUG_UART_TX);
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
