/*
 * Copyright 2016 Freescale Semiconductor, Inc.
 * Copyright 2016-2022 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _FSL_IOMUXC_H_
#define _FSL_IOMUXC_H_

#include "fsl_common.h"

/*!
 * @addtogroup iomuxc_driver
 * @{
 */

/*! @file */

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/* Component ID definition, used by tools. */
#ifndef FSL_COMPONENT_ID
#define FSL_COMPONENT_ID "platform.drivers.iomuxc"
#endif

/*! @name Driver version */
/*@{*/
/*! @brief IOMUXC driver version 2.0.0. */
#define FSL_IOMUXC_DRIVER_VERSION (MAKE_VERSION(2, 0, 0))
/*@}*/

/*!
 * @name Pin function ID
 * The pin function ID is a tuple of \<muxRegister muxMode inputRegister inputDaisy configRegister\>
 *
 * @{
 */
#define IOMUXC_GPIO_EMC_B1_00_SEMC_DATA00 0x42A10010U, 0x0U, 0, 0, 0x42A10258U
#define IOMUXC_GPIO_EMC_B1_00_XBAR1_XBAR_INOUT04 0x42A10010U, 0x1U, 0, 0, 0x42A10258U
#define IOMUXC_GPIO_EMC_B1_00_SINC3_MOD_CLK0 0x42A10010U, 0x2U, 0, 0, 0x42A10258U
#define IOMUXC_GPIO_EMC_B1_00_LPUART3_CTS_B 0x42A10010U, 0x3U, 0x42A1067CU, 0x0U, 0x42A10258U
#define IOMUXC_GPIO_EMC_B1_00_NETC_PINMUX_ETH3_TXD03 0x42A10010U, 0x4U, 0, 0, 0x42A10258U
#define IOMUXC_GPIO_EMC_B1_00_GPIO2_IO00 0x42A10010U, 0x5U, 0, 0, 0x42A10258U
#define IOMUXC_GPIO_EMC_B1_00_KPP_ROW03 0x42A10010U, 0x6U, 0x42A105D4U, 0x0U, 0x42A10258U
#define IOMUXC_GPIO_EMC_B1_00_FLEXIO1_FLEXIO00 0x42A10010U, 0x8U, 0, 0, 0x42A10258U
#define IOMUXC_GPIO_EMC_B1_00_NETC_PINMUX_ETH4_TXD03 0x42A10010U, 0x9U, 0, 0, 0x42A10258U
#define IOMUXC_GPIO_EMC_B1_00_ECAT_TX_DATA3_0 0x42A10010U, 0xAU, 0, 0, 0x42A10258U
#define IOMUXC_GPIO_EMC_B1_00_AHB_SRAMC_DATA00 0x42A10010U, 0xCU, 0, 0, 0x42A10258U

#define IOMUXC_GPIO_EMC_B1_01_ECAT_TX_DATA2_0 0x42A10014U, 0xAU, 0, 0, 0x42A1025CU
#define IOMUXC_GPIO_EMC_B1_01_AHB_SRAMC_DATA01 0x42A10014U, 0xCU, 0, 0, 0x42A1025CU
#define IOMUXC_GPIO_EMC_B1_01_SEMC_DATA01 0x42A10014U, 0x0U, 0, 0, 0x42A1025CU
#define IOMUXC_GPIO_EMC_B1_01_XBAR1_XBAR_INOUT05 0x42A10014U, 0x1U, 0, 0, 0x42A1025CU
#define IOMUXC_GPIO_EMC_B1_01_SINC3_MOD_CLK1 0x42A10014U, 0x2U, 0, 0, 0x42A1025CU
#define IOMUXC_GPIO_EMC_B1_01_LPUART3_RTS_B 0x42A10014U, 0x3U, 0, 0, 0x42A1025CU
#define IOMUXC_GPIO_EMC_B1_01_NETC_PINMUX_ETH3_TXD02 0x42A10014U, 0x4U, 0, 0, 0x42A1025CU
#define IOMUXC_GPIO_EMC_B1_01_GPIO2_IO01 0x42A10014U, 0x5U, 0, 0, 0x42A1025CU
#define IOMUXC_GPIO_EMC_B1_01_KPP_COL03 0x42A10014U, 0x6U, 0x42A105B4U, 0x0U, 0x42A1025CU
#define IOMUXC_GPIO_EMC_B1_01_FLEXIO1_FLEXIO01 0x42A10014U, 0x8U, 0, 0, 0x42A1025CU
#define IOMUXC_GPIO_EMC_B1_01_NETC_PINMUX_ETH4_TXD02 0x42A10014U, 0x9U, 0, 0, 0x42A1025CU

#define IOMUXC_GPIO_EMC_B1_02_SEMC_DATA02 0x42A10018U, 0x0U, 0, 0, 0x42A10260U
#define IOMUXC_GPIO_EMC_B1_02_XBAR1_XBAR_INOUT06 0x42A10018U, 0x1U, 0, 0, 0x42A10260U
#define IOMUXC_GPIO_EMC_B1_02_SINC3_MOD_CLK2 0x42A10018U, 0x2U, 0, 0, 0x42A10260U
#define IOMUXC_GPIO_EMC_B1_02_LPUART3_RX 0x42A10018U, 0x3U, 0x42A10680U, 0x0U, 0x42A10260U
#define IOMUXC_GPIO_EMC_B1_02_NETC_PINMUX_ETH3_RX_CLK 0x42A10018U, 0x4U, 0x42A10818U, 0x0U, 0x42A10260U
#define IOMUXC_GPIO_EMC_B1_02_GPIO2_IO02 0x42A10018U, 0x5U, 0, 0, 0x42A10260U
#define IOMUXC_GPIO_EMC_B1_02_KPP_ROW02 0x42A10018U, 0x6U, 0x42A105D0U, 0x0U, 0x42A10260U
#define IOMUXC_GPIO_EMC_B1_02_FLEXIO1_FLEXIO02 0x42A10018U, 0x8U, 0, 0, 0x42A10260U
#define IOMUXC_GPIO_EMC_B1_02_NETC_PINMUX_ETH4_RX_CLK 0x42A10018U, 0x9U, 0x42A10838U, 0x0U, 0x42A10260U
#define IOMUXC_GPIO_EMC_B1_02_ECAT_RX_CLK_0 0x42A10018U, 0xAU, 0x42A104ACU, 0x0U, 0x42A10260U
#define IOMUXC_GPIO_EMC_B1_02_AHB_SRAMC_DATA02 0x42A10018U, 0xCU, 0, 0, 0x42A10260U

#define IOMUXC_GPIO_EMC_B1_03_SEMC_DATA03 0x42A1001CU, 0x0U, 0, 0, 0x42A10264U
#define IOMUXC_GPIO_EMC_B1_03_XBAR1_XBAR_INOUT07 0x42A1001CU, 0x1U, 0, 0, 0x42A10264U
#define IOMUXC_GPIO_EMC_B1_03_SINC3_EMCLK00 0x42A1001CU, 0x2U, 0, 0, 0x42A10264U
#define IOMUXC_GPIO_EMC_B1_03_LPUART3_TX 0x42A1001CU, 0x3U, 0x42A10684U, 0x0U, 0x42A10264U
#define IOMUXC_GPIO_EMC_B1_03_NETC_PINMUX_ETH3_RXD03 0x42A1001CU, 0x4U, 0x42A10830U, 0x0U, 0x42A10264U
#define IOMUXC_GPIO_EMC_B1_03_GPIO2_IO03 0x42A1001CU, 0x5U, 0, 0, 0x42A10264U
#define IOMUXC_GPIO_EMC_B1_03_KPP_COL02 0x42A1001CU, 0x6U, 0x42A105B0U, 0x0U, 0x42A10264U
#define IOMUXC_GPIO_EMC_B1_03_FLEXIO1_FLEXIO03 0x42A1001CU, 0x8U, 0, 0, 0x42A10264U
#define IOMUXC_GPIO_EMC_B1_03_NETC_PINMUX_ETH4_RXD03 0x42A1001CU, 0x9U, 0x42A10850U, 0x0U, 0x42A10264U
#define IOMUXC_GPIO_EMC_B1_03_ECAT_RX_DATA3_0 0x42A1001CU, 0xAU, 0x42A104CCU, 0x0U, 0x42A10264U
#define IOMUXC_GPIO_EMC_B1_03_AHB_SRAMC_DATA03 0x42A1001CU, 0xCU, 0, 0, 0x42A10264U

#define IOMUXC_GPIO_EMC_B1_04_ECAT_RX_DATA2_0 0x42A10020U, 0xAU, 0x42A104C4U, 0x0U, 0x42A10268U
#define IOMUXC_GPIO_EMC_B1_04_AHB_SRAMC_DATA04 0x42A10020U, 0xCU, 0, 0, 0x42A10268U
#define IOMUXC_GPIO_EMC_B1_04_SEMC_DATA04 0x42A10020U, 0x0U, 0, 0, 0x42A10268U
#define IOMUXC_GPIO_EMC_B1_04_XBAR1_XBAR_INOUT08 0x42A10020U, 0x1U, 0, 0, 0x42A10268U
#define IOMUXC_GPIO_EMC_B1_04_SINC3_EMBIT00 0x42A10020U, 0x2U, 0, 0, 0x42A10268U
#define IOMUXC_GPIO_EMC_B1_04_LPUART3_DSR_B 0x42A10020U, 0x3U, 0, 0, 0x42A10268U
#define IOMUXC_GPIO_EMC_B1_04_NETC_PINMUX_ETH3_RXD02 0x42A10020U, 0x4U, 0x42A1082CU, 0x0U, 0x42A10268U
#define IOMUXC_GPIO_EMC_B1_04_GPIO2_IO04 0x42A10020U, 0x5U, 0, 0, 0x42A10268U
#define IOMUXC_GPIO_EMC_B1_04_KPP_ROW01 0x42A10020U, 0x6U, 0x42A105CCU, 0x0U, 0x42A10268U
#define IOMUXC_GPIO_EMC_B1_04_FLEXIO1_FLEXIO04 0x42A10020U, 0x8U, 0, 0, 0x42A10268U
#define IOMUXC_GPIO_EMC_B1_04_NETC_PINMUX_ETH4_RXD02 0x42A10020U, 0x9U, 0x42A1084CU, 0x0U, 0x42A10268U

#define IOMUXC_GPIO_EMC_B1_05_SEMC_DATA05 0x42A10024U, 0x0U, 0, 0, 0x42A1026CU
#define IOMUXC_GPIO_EMC_B1_05_XBAR1_XBAR_INOUT09 0x42A10024U, 0x1U, 0, 0, 0x42A1026CU
#define IOMUXC_GPIO_EMC_B1_05_SINC3_EMCLK01 0x42A10024U, 0x2U, 0, 0, 0x42A1026CU
#define IOMUXC_GPIO_EMC_B1_05_LPUART3_DCD_B 0x42A10024U, 0x3U, 0, 0, 0x42A1026CU
#define IOMUXC_GPIO_EMC_B1_05_NETC_PINMUX_ETH3_TXD00 0x42A10024U, 0x4U, 0, 0, 0x42A1026CU
#define IOMUXC_GPIO_EMC_B1_05_GPIO2_IO05 0x42A10024U, 0x5U, 0, 0, 0x42A1026CU
#define IOMUXC_GPIO_EMC_B1_05_KPP_ROW07 0x42A10024U, 0x6U, 0x42A105E4U, 0x0U, 0x42A1026CU
#define IOMUXC_GPIO_EMC_B1_05_FLEXIO1_FLEXIO05 0x42A10024U, 0x8U, 0, 0, 0x42A1026CU
#define IOMUXC_GPIO_EMC_B1_05_NETC_PINMUX_ETH4_TXD00 0x42A10024U, 0x9U, 0, 0, 0x42A1026CU
#define IOMUXC_GPIO_EMC_B1_05_ECAT_TX_DATA0_0 0x42A10024U, 0xAU, 0, 0, 0x42A1026CU
#define IOMUXC_GPIO_EMC_B1_05_AHB_SRAMC_DATA05 0x42A10024U, 0xCU, 0, 0, 0x42A1026CU

#define IOMUXC_GPIO_EMC_B1_06_SEMC_DATA06 0x42A10028U, 0x0U, 0, 0, 0x42A10270U
#define IOMUXC_GPIO_EMC_B1_06_FLEXPWM4_PWMB03 0x42A10028U, 0x1U, 0, 0, 0x42A10270U
#define IOMUXC_GPIO_EMC_B1_06_SINC3_EMBIT01 0x42A10028U, 0x2U, 0, 0, 0x42A10270U
#define IOMUXC_GPIO_EMC_B1_06_LPUART3_RI_B 0x42A10028U, 0x3U, 0, 0, 0x42A10270U
#define IOMUXC_GPIO_EMC_B1_06_NETC_PINMUX_ETH3_TXD01 0x42A10028U, 0x4U, 0, 0, 0x42A10270U
#define IOMUXC_GPIO_EMC_B1_06_GPIO2_IO06 0x42A10028U, 0x5U, 0, 0, 0x42A10270U
#define IOMUXC_GPIO_EMC_B1_06_KPP_COL07 0x42A10028U, 0x6U, 0x42A105C4U, 0x0U, 0x42A10270U
#define IOMUXC_GPIO_EMC_B1_06_FLEXIO1_FLEXIO06 0x42A10028U, 0x8U, 0, 0, 0x42A10270U
#define IOMUXC_GPIO_EMC_B1_06_NETC_PINMUX_ETH4_TXD01 0x42A10028U, 0x9U, 0, 0, 0x42A10270U
#define IOMUXC_GPIO_EMC_B1_06_ECAT_TX_DATA1_0 0x42A10028U, 0xAU, 0, 0, 0x42A10270U
#define IOMUXC_GPIO_EMC_B1_06_AHB_SRAMC_DATA06 0x42A10028U, 0xCU, 0, 0, 0x42A10270U

#define IOMUXC_GPIO_EMC_B1_07_ECAT_TX_EN_0 0x42A1002CU, 0xAU, 0, 0, 0x42A10274U
#define IOMUXC_GPIO_EMC_B1_07_AHB_SRAMC_DATA07 0x42A1002CU, 0xCU, 0, 0, 0x42A10274U
#define IOMUXC_GPIO_EMC_B1_07_SEMC_DATA07 0x42A1002CU, 0x0U, 0, 0, 0x42A10274U
#define IOMUXC_GPIO_EMC_B1_07_FLEXPWM4_PWMA03 0x42A1002CU, 0x1U, 0, 0, 0x42A10274U
#define IOMUXC_GPIO_EMC_B1_07_SINC3_EMCLK02 0x42A1002CU, 0x2U, 0, 0, 0x42A10274U
#define IOMUXC_GPIO_EMC_B1_07_LPUART3_DTR_B 0x42A1002CU, 0x3U, 0, 0, 0x42A10274U
#define IOMUXC_GPIO_EMC_B1_07_NETC_PINMUX_ETH3_TX_EN 0x42A1002CU, 0x4U, 0, 0, 0x42A10274U
#define IOMUXC_GPIO_EMC_B1_07_GPIO2_IO07 0x42A1002CU, 0x5U, 0, 0, 0x42A10274U
#define IOMUXC_GPIO_EMC_B1_07_KPP_ROW06 0x42A1002CU, 0x6U, 0x42A105E0U, 0x0U, 0x42A10274U
#define IOMUXC_GPIO_EMC_B1_07_FLEXIO1_FLEXIO07 0x42A1002CU, 0x8U, 0, 0, 0x42A10274U
#define IOMUXC_GPIO_EMC_B1_07_NETC_PINMUX_ETH4_TX_EN 0x42A1002CU, 0x9U, 0, 0, 0x42A10274U

#define IOMUXC_GPIO_EMC_B1_08_SEMC_DM00 0x42A10030U, 0x0U, 0, 0, 0x42A10278U
#define IOMUXC_GPIO_EMC_B1_08_FLEXPWM2_PWMB03 0x42A10030U, 0x1U, 0, 0, 0x42A10278U
#define IOMUXC_GPIO_EMC_B1_08_SINC3_EMBIT02 0x42A10030U, 0x2U, 0, 0, 0x42A10278U
#define IOMUXC_GPIO_EMC_B1_08_LPUART4_DSR_B 0x42A10030U, 0x3U, 0, 0, 0x42A10278U
#define IOMUXC_GPIO_EMC_B1_08_NETC_PINMUX_ETH3_TX_CLK 0x42A10030U, 0x4U, 0x42A10834U, 0x0U, 0x42A10278U
#define IOMUXC_GPIO_EMC_B1_08_GPIO2_IO08 0x42A10030U, 0x5U, 0, 0, 0x42A10278U
#define IOMUXC_GPIO_EMC_B1_08_KPP_COL06 0x42A10030U, 0x6U, 0x42A105C0U, 0x0U, 0x42A10278U
#define IOMUXC_GPIO_EMC_B1_08_FLEXIO1_FLEXIO08 0x42A10030U, 0x8U, 0, 0, 0x42A10278U
#define IOMUXC_GPIO_EMC_B1_08_NETC_PINMUX_ETH4_TX_CLK 0x42A10030U, 0x9U, 0x42A10854U, 0x0U, 0x42A10278U
#define IOMUXC_GPIO_EMC_B1_08_ECAT_TX_CLK_0 0x42A10030U, 0xAU, 0x42A104E4U, 0x0U, 0x42A10278U
#define IOMUXC_GPIO_EMC_B1_08_AHB_SRAMC_LBB 0x42A10030U, 0xCU, 0, 0, 0x42A10278U

#define IOMUXC_GPIO_EMC_B1_09_SEMC_ADDR00 0x42A10034U, 0x0U, 0, 0, 0x42A1027CU
#define IOMUXC_GPIO_EMC_B1_09_FLEXPWM2_PWMA03 0x42A10034U, 0x1U, 0, 0, 0x42A1027CU
#define IOMUXC_GPIO_EMC_B1_09_SINC3_EMCLK03 0x42A10034U, 0x2U, 0, 0, 0x42A1027CU
#define IOMUXC_GPIO_EMC_B1_09_LPUART4_DCD_B 0x42A10034U, 0x3U, 0, 0, 0x42A1027CU
#define IOMUXC_GPIO_EMC_B1_09_NETC_PINMUX_ETH3_RXD00 0x42A10034U, 0x4U, 0x42A10824U, 0x0U, 0x42A1027CU
#define IOMUXC_GPIO_EMC_B1_09_GPIO2_IO09 0x42A10034U, 0x5U, 0, 0, 0x42A1027CU
#define IOMUXC_GPIO_EMC_B1_09_KPP_ROW05 0x42A10034U, 0x6U, 0x42A105DCU, 0x0U, 0x42A1027CU
#define IOMUXC_GPIO_EMC_B1_09_FLEXIO1_FLEXIO09 0x42A10034U, 0x8U, 0, 0, 0x42A1027CU
#define IOMUXC_GPIO_EMC_B1_09_NETC_PINMUX_ETH4_RXD00 0x42A10034U, 0x9U, 0x42A10844U, 0x0U, 0x42A1027CU
#define IOMUXC_GPIO_EMC_B1_09_ECAT_RX_DATA0_0 0x42A10034U, 0xAU, 0x42A104B4U, 0x0U, 0x42A1027CU
#define IOMUXC_GPIO_EMC_B1_09_AHB_SRAMC_ADDR00 0x42A10034U, 0xCU, 0, 0, 0x42A1027CU

#define IOMUXC_GPIO_EMC_B1_10_SEMC_ADDR01 0x42A10038U, 0x0U, 0, 0, 0x42A10280U
#define IOMUXC_GPIO_EMC_B1_10_FLEXPWM3_PWMB03 0x42A10038U, 0x1U, 0x42A10540U, 0x0U, 0x42A10280U
#define IOMUXC_GPIO_EMC_B1_10_SINC3_EMBIT03 0x42A10038U, 0x2U, 0, 0, 0x42A10280U
#define IOMUXC_GPIO_EMC_B1_10_LPUART4_RI_B 0x42A10038U, 0x3U, 0, 0, 0x42A10280U
#define IOMUXC_GPIO_EMC_B1_10_NETC_PINMUX_ETH3_RXD01 0x42A10038U, 0x4U, 0x42A10828U, 0x0U, 0x42A10280U
#define IOMUXC_GPIO_EMC_B1_10_GPIO2_IO10 0x42A10038U, 0x5U, 0, 0, 0x42A10280U
#define IOMUXC_GPIO_EMC_B1_10_KPP_COL05 0x42A10038U, 0x6U, 0x42A105BCU, 0x0U, 0x42A10280U
#define IOMUXC_GPIO_EMC_B1_10_FLEXIO1_FLEXIO10 0x42A10038U, 0x8U, 0, 0, 0x42A10280U
#define IOMUXC_GPIO_EMC_B1_10_NETC_PINMUX_ETH4_RXD01 0x42A10038U, 0x9U, 0x42A10848U, 0x0U, 0x42A10280U
#define IOMUXC_GPIO_EMC_B1_10_ECAT_RX_DATA1_0 0x42A10038U, 0xAU, 0x42A104BCU, 0x0U, 0x42A10280U
#define IOMUXC_GPIO_EMC_B1_10_AHB_SRAMC_ADDR01 0x42A10038U, 0xCU, 0, 0, 0x42A10280U

#define IOMUXC_GPIO_EMC_B1_11_ECAT_RX_DV_0 0x42A1003CU, 0xAU, 0x42A104D4U, 0x0U, 0x42A10284U
#define IOMUXC_GPIO_EMC_B1_11_AHB_SRAMC_ADDR02 0x42A1003CU, 0xCU, 0, 0, 0x42A10284U
#define IOMUXC_GPIO_EMC_B1_11_SEMC_ADDR02 0x42A1003CU, 0x0U, 0, 0, 0x42A10284U
#define IOMUXC_GPIO_EMC_B1_11_FLEXPWM3_PWMA03 0x42A1003CU, 0x1U, 0x42A10530U, 0x0U, 0x42A10284U
#define IOMUXC_GPIO_EMC_B1_11_SINC_FILTER_GLUE3_BREAK 0x42A1003CU, 0x2U, 0, 0, 0x42A10284U
#define IOMUXC_GPIO_EMC_B1_11_LPUART4_DTR_B 0x42A1003CU, 0x3U, 0, 0, 0x42A10284U
#define IOMUXC_GPIO_EMC_B1_11_NETC_PINMUX_ETH3_RX_DV 0x42A1003CU, 0x4U, 0x42A1081CU, 0x0U, 0x42A10284U
#define IOMUXC_GPIO_EMC_B1_11_GPIO2_IO11 0x42A1003CU, 0x5U, 0, 0, 0x42A10284U
#define IOMUXC_GPIO_EMC_B1_11_KPP_ROW04 0x42A1003CU, 0x6U, 0x42A105D8U, 0x0U, 0x42A10284U
#define IOMUXC_GPIO_EMC_B1_11_FLEXIO1_FLEXIO11 0x42A1003CU, 0x8U, 0, 0, 0x42A10284U
#define IOMUXC_GPIO_EMC_B1_11_NETC_PINMUX_ETH4_RX_DV 0x42A1003CU, 0x9U, 0x42A1083CU, 0x0U, 0x42A10284U

#define IOMUXC_GPIO_EMC_B1_12_SEMC_ADDR03 0x42A10040U, 0x0U, 0, 0, 0x42A10288U
#define IOMUXC_GPIO_EMC_B1_12_FLEXPWM4_PWMA00 0x42A10040U, 0x1U, 0, 0, 0x42A10288U
#define IOMUXC_GPIO_EMC_B1_12_LPUART4_TX 0x42A10040U, 0x2U, 0, 0, 0x42A10288U
#define IOMUXC_GPIO_EMC_B1_12_NETC_PINMUX_ETH3_RX_ER 0x42A10040U, 0x4U, 0x42A10820U, 0x0U, 0x42A10288U
#define IOMUXC_GPIO_EMC_B1_12_GPIO2_IO12 0x42A10040U, 0x5U, 0, 0, 0x42A10288U
#define IOMUXC_GPIO_EMC_B1_12_KPP_COL04 0x42A10040U, 0x6U, 0x42A105B8U, 0x0U, 0x42A10288U
#define IOMUXC_GPIO_EMC_B1_12_FLEXIO1_FLEXIO12 0x42A10040U, 0x8U, 0, 0, 0x42A10288U
#define IOMUXC_GPIO_EMC_B1_12_NETC_PINMUX_ETH4_RX_ER 0x42A10040U, 0x9U, 0x42A10840U, 0x0U, 0x42A10288U
#define IOMUXC_GPIO_EMC_B1_12_ECAT_PT0_RX_ER 0x42A10040U, 0xAU, 0x42A104DCU, 0x0U, 0x42A10288U
#define IOMUXC_GPIO_EMC_B1_12_AHB_SRAMC_ADDR03 0x42A10040U, 0xCU, 0, 0, 0x42A10288U

#define IOMUXC_GPIO_EMC_B1_13_SEMC_ADDR04 0x42A10044U, 0x0U, 0, 0, 0x42A1028CU
#define IOMUXC_GPIO_EMC_B1_13_FLEXPWM4_PWMB00 0x42A10044U, 0x1U, 0, 0, 0x42A1028CU
#define IOMUXC_GPIO_EMC_B1_13_LPUART4_RX 0x42A10044U, 0x2U, 0, 0, 0x42A1028CU
#define IOMUXC_GPIO_EMC_B1_13_NETC_PINMUX_ETH2_RX_DV 0x42A10044U, 0x3U, 0x42A107FCU, 0x0U, 0x42A1028CU
#define IOMUXC_GPIO_EMC_B1_13_NETC_PINMUX_ETH3_TX_ER 0x42A10044U, 0x4U, 0, 0, 0x42A1028CU
#define IOMUXC_GPIO_EMC_B1_13_GPIO2_IO13 0x42A10044U, 0x5U, 0, 0, 0x42A1028CU
#define IOMUXC_GPIO_EMC_B1_13_KPP_COL01 0x42A10044U, 0x6U, 0x42A105ACU, 0x0U, 0x42A1028CU
#define IOMUXC_GPIO_EMC_B1_13_FLEXIO1_FLEXIO13 0x42A10044U, 0x8U, 0, 0, 0x42A1028CU
#define IOMUXC_GPIO_EMC_B1_13_NETC_PINMUX_ETH4_TX_ER 0x42A10044U, 0x9U, 0, 0, 0x42A1028CU
#define IOMUXC_GPIO_EMC_B1_13_QTIMER1_TIMER1 0x42A10044U, 0xAU, 0x42A1085CU, 0x0U, 0x42A1028CU
#define IOMUXC_GPIO_EMC_B1_13_AHB_SRAMC_ADDR04 0x42A10044U, 0xCU, 0, 0, 0x42A1028CU

#define IOMUXC_GPIO_EMC_B1_14_LPUART4_CTS_B 0x42A10048U, 0xAU, 0x42A10688U, 0x0U, 0x42A10290U
#define IOMUXC_GPIO_EMC_B1_14_AHB_SRAMC_ADDR05 0x42A10048U, 0xCU, 0, 0, 0x42A10290U
#define IOMUXC_GPIO_EMC_B1_14_SEMC_ADDR05 0x42A10048U, 0x0U, 0, 0, 0x42A10290U
#define IOMUXC_GPIO_EMC_B1_14_FLEXPWM4_PWMA01 0x42A10048U, 0x1U, 0, 0, 0x42A10290U
#define IOMUXC_GPIO_EMC_B1_14_LPUART5_TX 0x42A10048U, 0x2U, 0x42A106A0U, 0x0U, 0x42A10290U
#define IOMUXC_GPIO_EMC_B1_14_NETC_PINMUX_ETH2_TX_EN 0x42A10048U, 0x3U, 0, 0, 0x42A10290U
#define IOMUXC_GPIO_EMC_B1_14_NETC_ETH3_CRS 0x42A10048U, 0x4U, 0x42A107B0U, 0x0U, 0x42A10290U
#define IOMUXC_GPIO_EMC_B1_14_GPIO2_IO14 0x42A10048U, 0x5U, 0, 0, 0x42A10290U
#define IOMUXC_GPIO_EMC_B1_14_KPP_ROW00 0x42A10048U, 0x6U, 0x42A105C8U, 0x0U, 0x42A10290U
#define IOMUXC_GPIO_EMC_B1_14_FLEXIO1_FLEXIO14 0x42A10048U, 0x8U, 0, 0, 0x42A10290U
#define IOMUXC_GPIO_EMC_B1_14_NETC_ETH4_CRS 0x42A10048U, 0x9U, 0x42A107C0U, 0x0U, 0x42A10290U

#define IOMUXC_GPIO_EMC_B1_15_SEMC_ADDR06 0x42A1004CU, 0x0U, 0, 0, 0x42A10294U
#define IOMUXC_GPIO_EMC_B1_15_FLEXPWM4_PWMB01 0x42A1004CU, 0x1U, 0, 0, 0x42A10294U
#define IOMUXC_GPIO_EMC_B1_15_LPUART5_RX 0x42A1004CU, 0x2U, 0x42A1069CU, 0x0U, 0x42A10294U
#define IOMUXC_GPIO_EMC_B1_15_NETC_PINMUX_ETH2_TX_CLK 0x42A1004CU, 0x3U, 0x42A10814U, 0x0U, 0x42A10294U
#define IOMUXC_GPIO_EMC_B1_15_NETC_ETH3_COL 0x42A1004CU, 0x4U, 0x42A107ACU, 0x0U, 0x42A10294U
#define IOMUXC_GPIO_EMC_B1_15_GPIO2_IO15 0x42A1004CU, 0x5U, 0, 0, 0x42A10294U
#define IOMUXC_GPIO_EMC_B1_15_KPP_COL00 0x42A1004CU, 0x6U, 0x42A105A8U, 0x0U, 0x42A10294U
#define IOMUXC_GPIO_EMC_B1_15_FLEXIO1_FLEXIO15 0x42A1004CU, 0x8U, 0, 0, 0x42A10294U
#define IOMUXC_GPIO_EMC_B1_15_NETC_ETH4_COL 0x42A1004CU, 0x9U, 0x42A107BCU, 0x0U, 0x42A10294U
#define IOMUXC_GPIO_EMC_B1_15_LPUART4_RTS_B 0x42A1004CU, 0xAU, 0, 0, 0x42A10294U
#define IOMUXC_GPIO_EMC_B1_15_AHB_SRAMC_ADDR06 0x42A1004CU, 0xCU, 0, 0, 0x42A10294U

#define IOMUXC_GPIO_EMC_B1_16_SEMC_ADDR07 0x42A10050U, 0x0U, 0, 0, 0x42A10298U
#define IOMUXC_GPIO_EMC_B1_16_FLEXPWM4_PWMB02 0x42A10050U, 0x1U, 0, 0, 0x42A10298U
#define IOMUXC_GPIO_EMC_B1_16_LPUART9_TX 0x42A10050U, 0x2U, 0x42A106CCU, 0x0U, 0x42A10298U
#define IOMUXC_GPIO_EMC_B1_16_NETC_PINMUX_ETH2_RXD00 0x42A10050U, 0x3U, 0x42A10804U, 0x0U, 0x42A10298U
#define IOMUXC_GPIO_EMC_B1_16_NETC_ETH3_SLV_MDC 0x42A10050U, 0x4U, 0x42A107B4U, 0x0U, 0x42A10298U
#define IOMUXC_GPIO_EMC_B1_16_GPIO2_IO16 0x42A10050U, 0x5U, 0, 0, 0x42A10298U
#define IOMUXC_GPIO_EMC_B1_16_NETC_ETH4_SLV_MDC 0x42A10050U, 0x6U, 0x42A107C4U, 0x0U, 0x42A10298U
#define IOMUXC_GPIO_EMC_B1_16_FLEXIO1_FLEXIO16 0x42A10050U, 0x8U, 0, 0, 0x42A10298U
#define IOMUXC_GPIO_EMC_B1_16_NETC_ETH2_SLV_MDC 0x42A10050U, 0x9U, 0x42A107A4U, 0x0U, 0x42A10298U
#define IOMUXC_GPIO_EMC_B1_16_LPSPI6_PCS2 0x42A10050U, 0xAU, 0x42A10658U, 0x0U, 0x42A10298U
#define IOMUXC_GPIO_EMC_B1_16_AHB_SRAMC_ADDR07 0x42A10050U, 0xCU, 0, 0, 0x42A10298U

#define IOMUXC_GPIO_EMC_B1_17_LPSPI6_PCS1 0x42A10054U, 0xAU, 0x42A10654U, 0x0U, 0x42A1029CU
#define IOMUXC_GPIO_EMC_B1_17_AHB_SRAMC_ADDR08 0x42A10054U, 0xCU, 0, 0, 0x42A1029CU
#define IOMUXC_GPIO_EMC_B1_17_SEMC_ADDR08 0x42A10054U, 0x0U, 0, 0, 0x42A1029CU
#define IOMUXC_GPIO_EMC_B1_17_FLEXPWM4_PWMA02 0x42A10054U, 0x1U, 0, 0, 0x42A1029CU
#define IOMUXC_GPIO_EMC_B1_17_LPUART9_RX 0x42A10054U, 0x2U, 0x42A106C8U, 0x0U, 0x42A1029CU
#define IOMUXC_GPIO_EMC_B1_17_NETC_PINMUX_ETH2_RXD01 0x42A10054U, 0x3U, 0x42A10808U, 0x0U, 0x42A1029CU
#define IOMUXC_GPIO_EMC_B1_17_NETC_ETH3_SLV_MDIO 0x42A10054U, 0x4U, 0x42A107B8U, 0x0U, 0x42A1029CU
#define IOMUXC_GPIO_EMC_B1_17_GPIO2_IO17 0x42A10054U, 0x5U, 0, 0, 0x42A1029CU
#define IOMUXC_GPIO_EMC_B1_17_NETC_ETH4_SLV_MDIO 0x42A10054U, 0x6U, 0x42A107C8U, 0x0U, 0x42A1029CU
#define IOMUXC_GPIO_EMC_B1_17_FLEXIO1_FLEXIO17 0x42A10054U, 0x8U, 0, 0, 0x42A1029CU
#define IOMUXC_GPIO_EMC_B1_17_NETC_ETH2_SLV_MDIO 0x42A10054U, 0x9U, 0x42A107A8U, 0x0U, 0x42A1029CU

#define IOMUXC_GPIO_EMC_B1_18_SEMC_ADDR09 0x42A10058U, 0x0U, 0, 0, 0x42A102A0U
#define IOMUXC_GPIO_EMC_B1_18_FLEXPWM2_PWMA00 0x42A10058U, 0x1U, 0x42A1050CU, 0x0U, 0x42A102A0U
#define IOMUXC_GPIO_EMC_B1_18_QTIMER1_TIMER0 0x42A10058U, 0x2U, 0x42A10858U, 0x0U, 0x42A102A0U
#define IOMUXC_GPIO_EMC_B1_18_LPSPI6_SCK 0x42A10058U, 0x3U, 0x42A10660U, 0x0U, 0x42A102A0U
#define IOMUXC_GPIO_EMC_B1_18_NETC_ETH2_CRS 0x42A10058U, 0x4U, 0x42A107A0U, 0x0U, 0x42A102A0U
#define IOMUXC_GPIO_EMC_B1_18_GPIO2_IO18 0x42A10058U, 0x5U, 0, 0, 0x42A102A0U
#define IOMUXC_GPIO_EMC_B1_18_FLEXIO1_FLEXIO18 0x42A10058U, 0x8U, 0, 0, 0x42A102A0U
#define IOMUXC_GPIO_EMC_B1_18_NETC_EMDC 0x42A10058U, 0xAU, 0, 0, 0x42A102A0U
#define IOMUXC_GPIO_EMC_B1_18_AHB_SRAMC_ADDR09 0x42A10058U, 0xCU, 0, 0, 0x42A102A0U

#define IOMUXC_GPIO_EMC_B1_19_SEMC_ADDR11 0x42A1005CU, 0x0U, 0, 0, 0x42A102A4U
#define IOMUXC_GPIO_EMC_B1_19_FLEXPWM2_PWMB00 0x42A1005CU, 0x1U, 0x42A10518U, 0x0U, 0x42A102A4U
#define IOMUXC_GPIO_EMC_B1_19_QTIMER2_TIMER0 0x42A1005CU, 0x2U, 0x42A10864U, 0x0U, 0x42A102A4U
#define IOMUXC_GPIO_EMC_B1_19_LPSPI6_SDI 0x42A1005CU, 0x3U, 0x42A10664U, 0x0U, 0x42A102A4U
#define IOMUXC_GPIO_EMC_B1_19_NETC_ETH2_COL 0x42A1005CU, 0x4U, 0x42A1079CU, 0x0U, 0x42A102A4U
#define IOMUXC_GPIO_EMC_B1_19_GPIO2_IO19 0x42A1005CU, 0x5U, 0, 0, 0x42A102A4U
#define IOMUXC_GPIO_EMC_B1_19_FLEXIO1_FLEXIO19 0x42A1005CU, 0x8U, 0, 0, 0x42A102A4U
#define IOMUXC_GPIO_EMC_B1_19_NETC_EMDIO 0x42A1005CU, 0xAU, 0x42A10798U, 0x0U, 0x42A102A4U
#define IOMUXC_GPIO_EMC_B1_19_AHB_SRAMC_ADDR11 0x42A1005CU, 0xCU, 0, 0, 0x42A102A4U

#define IOMUXC_GPIO_EMC_B1_20_SEMC_ADDR12 0x42A10060U, 0x0U, 0, 0, 0x42A102A8U
#define IOMUXC_GPIO_EMC_B1_20_FLEXPWM2_PWMA01 0x42A10060U, 0x1U, 0x42A10510U, 0x0U, 0x42A102A8U
#define IOMUXC_GPIO_EMC_B1_20_QTIMER3_TIMER0 0x42A10060U, 0x2U, 0x42A10870U, 0x0U, 0x42A102A8U
#define IOMUXC_GPIO_EMC_B1_20_LPSPI6_SDO 0x42A10060U, 0x3U, 0x42A10668U, 0x0U, 0x42A102A8U
#define IOMUXC_GPIO_EMC_B1_20_NETC_PINMUX_ETH2_TX_ER 0x42A10060U, 0x4U, 0, 0, 0x42A102A8U
#define IOMUXC_GPIO_EMC_B1_20_GPIO2_IO20 0x42A10060U, 0x5U, 0, 0, 0x42A102A8U
#define IOMUXC_GPIO_EMC_B1_20_FLEXIO1_FLEXIO20 0x42A10060U, 0x8U, 0, 0, 0x42A102A8U
#define IOMUXC_GPIO_EMC_B1_20_AHB_SRAMC_ADDR12 0x42A10060U, 0xCU, 0, 0, 0x42A102A8U

#define IOMUXC_GPIO_EMC_B1_21_FLEXSPI2_BUS2BIT_B_DQS 0x42A10064U, 0xAU, 0x42A10574U, 0x0U, 0x42A102ACU
#define IOMUXC_GPIO_EMC_B1_21_AHB_SRAMC_ADDR13 0x42A10064U, 0xCU, 0, 0, 0x42A102ACU
#define IOMUXC_GPIO_EMC_B1_21_SEMC_BA0 0x42A10064U, 0x0U, 0, 0, 0x42A102ACU
#define IOMUXC_GPIO_EMC_B1_21_FLEXPWM2_PWMB01 0x42A10064U, 0x1U, 0x42A1051CU, 0x0U, 0x42A102ACU
#define IOMUXC_GPIO_EMC_B1_21_QTIMER4_TIMER0 0x42A10064U, 0x2U, 0x42A1087CU, 0x0U, 0x42A102ACU
#define IOMUXC_GPIO_EMC_B1_21_LPSPI6_PCS0 0x42A10064U, 0x3U, 0x42A10650U, 0x0U, 0x42A102ACU
#define IOMUXC_GPIO_EMC_B1_21_NETC_PINMUX_ETH2_RX_CLK 0x42A10064U, 0x4U, 0x42A107F8U, 0x0U, 0x42A102ACU
#define IOMUXC_GPIO_EMC_B1_21_GPIO2_IO21 0x42A10064U, 0x5U, 0, 0, 0x42A102ACU
#define IOMUXC_GPIO_EMC_B1_21_FLEXIO1_FLEXIO21 0x42A10064U, 0x8U, 0, 0, 0x42A102ACU
#define IOMUXC_GPIO_EMC_B1_21_LPUART4_CTS_B 0x42A10064U, 0x9U, 0x42A10688U, 0x1U, 0x42A102ACU

#define IOMUXC_GPIO_EMC_B1_22_FLEXSPI2_BUS2BIT_B_DATA03 0x42A10068U, 0xAU, 0x42A10594U, 0x0U, 0x42A102B0U
#define IOMUXC_GPIO_EMC_B1_22_AHB_SRAMC_ADDR14 0x42A10068U, 0xCU, 0, 0, 0x42A102B0U
#define IOMUXC_GPIO_EMC_B1_22_SEMC_BA1 0x42A10068U, 0x0U, 0, 0, 0x42A102B0U
#define IOMUXC_GPIO_EMC_B1_22_FLEXPWM2_PWMB02 0x42A10068U, 0x1U, 0x42A10520U, 0x0U, 0x42A102B0U
#define IOMUXC_GPIO_EMC_B1_22_QTIMER5_TIMER0 0x42A10068U, 0x2U, 0x42A10888U, 0x0U, 0x42A102B0U
#define IOMUXC_GPIO_EMC_B1_22_LPSPI4_SCK 0x42A10068U, 0x3U, 0x42A10628U, 0x0U, 0x42A102B0U
#define IOMUXC_GPIO_EMC_B1_22_NETC_PINMUX_ETH2_RXD02 0x42A10068U, 0x4U, 0x42A1080CU, 0x0U, 0x42A102B0U
#define IOMUXC_GPIO_EMC_B1_22_GPIO2_IO22 0x42A10068U, 0x5U, 0, 0, 0x42A102B0U
#define IOMUXC_GPIO_EMC_B1_22_FLEXIO1_FLEXIO22 0x42A10068U, 0x8U, 0, 0, 0x42A102B0U
#define IOMUXC_GPIO_EMC_B1_22_LPUART4_RTS_B 0x42A10068U, 0x9U, 0, 0, 0x42A102B0U

#define IOMUXC_GPIO_EMC_B1_23_SEMC_ADDR10 0x42A1006CU, 0x0U, 0, 0, 0x42A102B4U
#define IOMUXC_GPIO_EMC_B1_23_FLEXPWM2_PWMA02 0x42A1006CU, 0x1U, 0x42A10514U, 0x0U, 0x42A102B4U
#define IOMUXC_GPIO_EMC_B1_23_QTIMER6_TIMER0 0x42A1006CU, 0x2U, 0x42A10894U, 0x0U, 0x42A102B4U
#define IOMUXC_GPIO_EMC_B1_23_LPSPI4_SDI 0x42A1006CU, 0x3U, 0x42A1062CU, 0x0U, 0x42A102B4U
#define IOMUXC_GPIO_EMC_B1_23_NETC_PINMUX_ETH2_RXD03 0x42A1006CU, 0x4U, 0x42A10810U, 0x0U, 0x42A102B4U
#define IOMUXC_GPIO_EMC_B1_23_GPIO2_IO23 0x42A1006CU, 0x5U, 0, 0, 0x42A102B4U
#define IOMUXC_GPIO_EMC_B1_23_FLEXIO1_FLEXIO23 0x42A1006CU, 0x8U, 0, 0, 0x42A102B4U
#define IOMUXC_GPIO_EMC_B1_23_FLEXSPI2_BUS2BIT_B_DATA02 0x42A1006CU, 0xAU, 0x42A10590U, 0x0U, 0x42A102B4U
#define IOMUXC_GPIO_EMC_B1_23_AHB_SRAMC_ADDR10 0x42A1006CU, 0xCU, 0, 0, 0x42A102B4U

#define IOMUXC_GPIO_EMC_B1_24_FLEXSPI2_BUS2BIT_B_DATA01 0x42A10070U, 0xAU, 0x42A1058CU, 0x0U, 0x42A102B8U
#define IOMUXC_GPIO_EMC_B1_24_AHB_SRAMC_ADDR15 0x42A10070U, 0xCU, 0, 0, 0x42A102B8U
#define IOMUXC_GPIO_EMC_B1_24_SEMC_CAS 0x42A10070U, 0x0U, 0, 0, 0x42A102B8U
#define IOMUXC_GPIO_EMC_B1_24_FLEXPWM1_PWMA00 0x42A10070U, 0x1U, 0x42A104F4U, 0x0U, 0x42A102B8U
#define IOMUXC_GPIO_EMC_B1_24_QTIMER7_TIMER0 0x42A10070U, 0x2U, 0x42A108A0U, 0x0U, 0x42A102B8U
#define IOMUXC_GPIO_EMC_B1_24_LPSPI4_SDO 0x42A10070U, 0x3U, 0x42A10630U, 0x0U, 0x42A102B8U
#define IOMUXC_GPIO_EMC_B1_24_NETC_PINMUX_ETH2_TXD03 0x42A10070U, 0x4U, 0, 0, 0x42A102B8U
#define IOMUXC_GPIO_EMC_B1_24_GPIO2_IO24 0x42A10070U, 0x5U, 0, 0, 0x42A102B8U
#define IOMUXC_GPIO_EMC_B1_24_FLEXIO1_FLEXIO24 0x42A10070U, 0x8U, 0, 0, 0x42A102B8U
#define IOMUXC_GPIO_EMC_B1_24_NETC_ETH3_SLV_MDC 0x42A10070U, 0x9U, 0x42A107B4U, 0x1U, 0x42A102B8U

#define IOMUXC_GPIO_EMC_B1_25_FLEXSPI2_BUS2BIT_B_DATA00 0x42A10074U, 0xAU, 0x42A10588U, 0x0U, 0x42A102BCU
#define IOMUXC_GPIO_EMC_B1_25_AHB_SRAMC_ADDR16 0x42A10074U, 0xCU, 0, 0, 0x42A102BCU
#define IOMUXC_GPIO_EMC_B1_25_SEMC_RAS 0x42A10074U, 0x0U, 0, 0, 0x42A102BCU
#define IOMUXC_GPIO_EMC_B1_25_FLEXPWM1_PWMB00 0x42A10074U, 0x1U, 0x42A10500U, 0x0U, 0x42A102BCU
#define IOMUXC_GPIO_EMC_B1_25_QTIMER8_TIMER0 0x42A10074U, 0x2U, 0x42A108A8U, 0x0U, 0x42A102BCU
#define IOMUXC_GPIO_EMC_B1_25_LPSPI4_PCS0 0x42A10074U, 0x3U, 0x42A10624U, 0x0U, 0x42A102BCU
#define IOMUXC_GPIO_EMC_B1_25_NETC_PINMUX_ETH2_TXD02 0x42A10074U, 0x4U, 0, 0, 0x42A102BCU
#define IOMUXC_GPIO_EMC_B1_25_GPIO2_IO25 0x42A10074U, 0x5U, 0, 0, 0x42A102BCU
#define IOMUXC_GPIO_EMC_B1_25_FLEXIO1_FLEXIO25 0x42A10074U, 0x8U, 0, 0, 0x42A102BCU
#define IOMUXC_GPIO_EMC_B1_25_NETC_ETH3_SLV_MDIO 0x42A10074U, 0x9U, 0x42A107B8U, 0x1U, 0x42A102BCU

#define IOMUXC_GPIO_EMC_B1_26_SEMC_CLK 0x42A10078U, 0x0U, 0, 0, 0x42A102C0U
#define IOMUXC_GPIO_EMC_B1_26_FLEXPWM1_PWMA01 0x42A10078U, 0x1U, 0x42A104F8U, 0x0U, 0x42A102C0U
#define IOMUXC_GPIO_EMC_B1_26_XBAR1_XBAR_INOUT10 0x42A10078U, 0x2U, 0, 0, 0x42A102C0U
#define IOMUXC_GPIO_EMC_B1_26_FLEXSPI2_BUS2BIT_A_SS1_B 0x42A10078U, 0x3U, 0, 0, 0x42A102C0U
#define IOMUXC_GPIO_EMC_B1_26_NETC_PINMUX_ETH2_TXD01 0x42A10078U, 0x4U, 0, 0, 0x42A102C0U
#define IOMUXC_GPIO_EMC_B1_26_GPIO2_IO26 0x42A10078U, 0x5U, 0, 0, 0x42A102C0U
#define IOMUXC_GPIO_EMC_B1_26_ECAT_TX_DATA1_1 0x42A10078U, 0x6U, 0, 0, 0x42A102C0U
#define IOMUXC_GPIO_EMC_B1_26_LPSPI6_SCK 0x42A10078U, 0xAU, 0x42A10660U, 0x1U, 0x42A102C0U
#define IOMUXC_GPIO_EMC_B1_26_AHB_SRAMC_WE 0x42A10078U, 0xCU, 0, 0, 0x42A102C0U

#define IOMUXC_GPIO_EMC_B1_27_LPSPI6_SDI 0x42A1007CU, 0xAU, 0x42A10664U, 0x1U, 0x42A102C4U
#define IOMUXC_GPIO_EMC_B1_27_AHB_SRAMC_OEB 0x42A1007CU, 0xCU, 0, 0, 0x42A102C4U
#define IOMUXC_GPIO_EMC_B1_27_SEMC_CKE 0x42A1007CU, 0x0U, 0, 0, 0x42A102C4U
#define IOMUXC_GPIO_EMC_B1_27_FLEXPWM1_PWMB01 0x42A1007CU, 0x1U, 0x42A10504U, 0x0U, 0x42A102C4U
#define IOMUXC_GPIO_EMC_B1_27_XBAR1_XBAR_INOUT11 0x42A1007CU, 0x2U, 0, 0, 0x42A102C4U
#define IOMUXC_GPIO_EMC_B1_27_FLEXSPI2_BUS2BIT_B_SS1_B 0x42A1007CU, 0x3U, 0, 0, 0x42A102C4U
#define IOMUXC_GPIO_EMC_B1_27_NETC_PINMUX_ETH2_TXD00 0x42A1007CU, 0x4U, 0, 0, 0x42A102C4U
#define IOMUXC_GPIO_EMC_B1_27_GPIO2_IO27 0x42A1007CU, 0x5U, 0, 0, 0x42A102C4U
#define IOMUXC_GPIO_EMC_B1_27_ECAT_TX_DATA0_1 0x42A1007CU, 0x6U, 0, 0, 0x42A102C4U
#define IOMUXC_GPIO_EMC_B1_27_LPUART6_RI_B 0x42A1007CU, 0x9U, 0x42A106B0U, 0x0U, 0x42A102C4U

#define IOMUXC_GPIO_EMC_B1_28_LPSPI6_SDO 0x42A10080U, 0xAU, 0x42A10668U, 0x1U, 0x42A102C8U
#define IOMUXC_GPIO_EMC_B1_28_AHB_SRAMC_ADV 0x42A10080U, 0xCU, 0, 0, 0x42A102C8U
#define IOMUXC_GPIO_EMC_B1_28_SEMC_WE 0x42A10080U, 0x0U, 0, 0, 0x42A102C8U
#define IOMUXC_GPIO_EMC_B1_28_FLEXPWM1_PWMB02 0x42A10080U, 0x1U, 0x42A10508U, 0x0U, 0x42A102C8U
#define IOMUXC_GPIO_EMC_B1_28_XBAR1_XBAR_INOUT12 0x42A10080U, 0x2U, 0, 0, 0x42A102C8U
#define IOMUXC_GPIO_EMC_B1_28_FLEXSPI2_BUS2BIT_B_SS0_B 0x42A10080U, 0x3U, 0, 0, 0x42A102C8U
#define IOMUXC_GPIO_EMC_B1_28_NETC_PINMUX_ETH2_TX_EN 0x42A10080U, 0x4U, 0, 0, 0x42A102C8U
#define IOMUXC_GPIO_EMC_B1_28_GPIO2_IO28 0x42A10080U, 0x5U, 0, 0, 0x42A102C8U
#define IOMUXC_GPIO_EMC_B1_28_ECAT_TX_EN_1 0x42A10080U, 0x6U, 0, 0, 0x42A102C8U
#define IOMUXC_GPIO_EMC_B1_28_LPUART6_DTR_B 0x42A10080U, 0x9U, 0, 0, 0x42A102C8U

#define IOMUXC_GPIO_EMC_B1_29_SEMC_CS0 0x42A10084U, 0x0U, 0, 0, 0x42A102CCU
#define IOMUXC_GPIO_EMC_B1_29_FLEXPWM1_PWMA02 0x42A10084U, 0x1U, 0x42A104FCU, 0x0U, 0x42A102CCU
#define IOMUXC_GPIO_EMC_B1_29_XBAR1_XBAR_INOUT13 0x42A10084U, 0x2U, 0, 0, 0x42A102CCU
#define IOMUXC_GPIO_EMC_B1_29_FLEXSPI2_BUS2BIT_B_DQS 0x42A10084U, 0x3U, 0x42A10574U, 0x1U, 0x42A102CCU
#define IOMUXC_GPIO_EMC_B1_29_NETC_PINMUX_ETH2_TX_CLK 0x42A10084U, 0x4U, 0x42A10814U, 0x1U, 0x42A102CCU
#define IOMUXC_GPIO_EMC_B1_29_GPIO2_IO29 0x42A10084U, 0x5U, 0, 0, 0x42A102CCU
#define IOMUXC_GPIO_EMC_B1_29_ECAT_TX_CLK_1 0x42A10084U, 0x6U, 0x42A104E8U, 0x0U, 0x42A102CCU
#define IOMUXC_GPIO_EMC_B1_29_LPUART6_DCD_B 0x42A10084U, 0x9U, 0x42A106A8U, 0x0U, 0x42A102CCU
#define IOMUXC_GPIO_EMC_B1_29_LPSPI6_PCS0 0x42A10084U, 0xAU, 0x42A10650U, 0x1U, 0x42A102CCU
#define IOMUXC_GPIO_EMC_B1_29_AHB_SRAMC_CS0 0x42A10084U, 0xCU, 0, 0, 0x42A102CCU

#define IOMUXC_GPIO_EMC_B1_30_SEMC_DATA08 0x42A10088U, 0x0U, 0, 0, 0x42A102D0U
#define IOMUXC_GPIO_EMC_B1_30_FLEXPWM3_PWMA00 0x42A10088U, 0x1U, 0x42A10524U, 0x0U, 0x42A102D0U
#define IOMUXC_GPIO_EMC_B1_30_XBAR1_XBAR_INOUT14 0x42A10088U, 0x2U, 0x42A10934U, 0x0U, 0x42A102D0U
#define IOMUXC_GPIO_EMC_B1_30_FLEXSPI2_BUS2BIT_B_DATA03 0x42A10088U, 0x3U, 0x42A10594U, 0x1U, 0x42A102D0U
#define IOMUXC_GPIO_EMC_B1_30_NETC_PINMUX_ETH2_RXD00 0x42A10088U, 0x4U, 0x42A10804U, 0x1U, 0x42A102D0U
#define IOMUXC_GPIO_EMC_B1_30_GPIO2_IO30 0x42A10088U, 0x5U, 0, 0, 0x42A102D0U
#define IOMUXC_GPIO_EMC_B1_30_ECAT_RX_DATA0_1 0x42A10088U, 0x6U, 0x42A104B8U, 0x0U, 0x42A102D0U
#define IOMUXC_GPIO_EMC_B1_30_LPUART6_DSR_B 0x42A10088U, 0x9U, 0x42A106ACU, 0x0U, 0x42A102D0U
#define IOMUXC_GPIO_EMC_B1_30_LPSPI6_PCS1 0x42A10088U, 0xAU, 0x42A10654U, 0x1U, 0x42A102D0U
#define IOMUXC_GPIO_EMC_B1_30_AHB_SRAMC_DATA08 0x42A10088U, 0xCU, 0, 0, 0x42A102D0U

#define IOMUXC_GPIO_EMC_B1_31_LPSPI6_PCS2 0x42A1008CU, 0xAU, 0x42A10658U, 0x1U, 0x42A102D4U
#define IOMUXC_GPIO_EMC_B1_31_AHB_SRAMC_DATA09 0x42A1008CU, 0xCU, 0, 0, 0x42A102D4U
#define IOMUXC_GPIO_EMC_B1_31_SEMC_DATA09 0x42A1008CU, 0x0U, 0, 0, 0x42A102D4U
#define IOMUXC_GPIO_EMC_B1_31_FLEXPWM3_PWMB00 0x42A1008CU, 0x1U, 0x42A10534U, 0x0U, 0x42A102D4U
#define IOMUXC_GPIO_EMC_B1_31_LPUART6_TX 0x42A1008CU, 0x2U, 0x42A106B8U, 0x0U, 0x42A102D4U
#define IOMUXC_GPIO_EMC_B1_31_FLEXSPI2_BUS2BIT_B_DATA02 0x42A1008CU, 0x3U, 0x42A10590U, 0x1U, 0x42A102D4U
#define IOMUXC_GPIO_EMC_B1_31_NETC_PINMUX_ETH2_RXD01 0x42A1008CU, 0x4U, 0x42A10808U, 0x1U, 0x42A102D4U
#define IOMUXC_GPIO_EMC_B1_31_GPIO2_IO31 0x42A1008CU, 0x5U, 0, 0, 0x42A102D4U
#define IOMUXC_GPIO_EMC_B1_31_ECAT_RX_DATA1_1 0x42A1008CU, 0x6U, 0x42A104C0U, 0x0U, 0x42A102D4U
#define IOMUXC_GPIO_EMC_B1_31_LPSPI5_SCK 0x42A1008CU, 0x9U, 0x42A10644U, 0x0U, 0x42A102D4U

#define IOMUXC_GPIO_EMC_B1_32_LPSPI6_PCS3 0x42A10090U, 0xAU, 0x42A1065CU, 0x0U, 0x42A102D8U
#define IOMUXC_GPIO_EMC_B1_32_AHB_SRAMC_DATA10 0x42A10090U, 0xCU, 0, 0, 0x42A102D8U
#define IOMUXC_GPIO_EMC_B1_32_SEMC_DATA10 0x42A10090U, 0x0U, 0, 0, 0x42A102D8U
#define IOMUXC_GPIO_EMC_B1_32_FLEXPWM3_PWMA01 0x42A10090U, 0x1U, 0x42A10528U, 0x0U, 0x42A102D8U
#define IOMUXC_GPIO_EMC_B1_32_LPUART6_RX 0x42A10090U, 0x2U, 0x42A106B4U, 0x0U, 0x42A102D8U
#define IOMUXC_GPIO_EMC_B1_32_FLEXSPI2_BUS2BIT_B_DATA01 0x42A10090U, 0x3U, 0x42A1058CU, 0x1U, 0x42A102D8U
#define IOMUXC_GPIO_EMC_B1_32_NETC_PINMUX_ETH2_RX_DV 0x42A10090U, 0x4U, 0x42A107FCU, 0x1U, 0x42A102D8U
#define IOMUXC_GPIO_EMC_B1_32_GPIO3_IO00 0x42A10090U, 0x5U, 0, 0, 0x42A102D8U
#define IOMUXC_GPIO_EMC_B1_32_ECAT_RX_DV_1 0x42A10090U, 0x6U, 0x42A104D8U, 0x0U, 0x42A102D8U
#define IOMUXC_GPIO_EMC_B1_32_LPSPI5_SDO 0x42A10090U, 0x9U, 0x42A1064CU, 0x0U, 0x42A102D8U

#define IOMUXC_GPIO_EMC_B1_33_SEMC_DATA11 0x42A10094U, 0x0U, 0, 0, 0x42A102DCU
#define IOMUXC_GPIO_EMC_B1_33_FLEXPWM3_PWMB01 0x42A10094U, 0x1U, 0x42A10538U, 0x0U, 0x42A102DCU
#define IOMUXC_GPIO_EMC_B1_33_LPUART6_CTS_B 0x42A10094U, 0x2U, 0x42A106A4U, 0x0U, 0x42A102DCU
#define IOMUXC_GPIO_EMC_B1_33_FLEXSPI2_BUS2BIT_B_DATA00 0x42A10094U, 0x3U, 0x42A10588U, 0x1U, 0x42A102DCU
#define IOMUXC_GPIO_EMC_B1_33_NETC_PINMUX_ETH2_RX_ER 0x42A10094U, 0x4U, 0x42A10800U, 0x0U, 0x42A102DCU
#define IOMUXC_GPIO_EMC_B1_33_GPIO3_IO01 0x42A10094U, 0x5U, 0, 0, 0x42A102DCU
#define IOMUXC_GPIO_EMC_B1_33_ECAT_RX_ER_1 0x42A10094U, 0x6U, 0x42A104E0U, 0x0U, 0x42A102DCU
#define IOMUXC_GPIO_EMC_B1_33_LPSPI5_SDI 0x42A10094U, 0x9U, 0x42A10648U, 0x0U, 0x42A102DCU
#define IOMUXC_GPIO_EMC_B1_33_NETC_PINMUX_ETH2_RX_CLK 0x42A10094U, 0xAU, 0x42A107F8U, 0x1U, 0x42A102DCU
#define IOMUXC_GPIO_EMC_B1_33_AHB_SRAMC_DATA11 0x42A10094U, 0xCU, 0, 0, 0x42A102DCU

#define IOMUXC_GPIO_EMC_B1_34_LPSPI5_PCS0 0x42A10098U, 0xAU, 0x42A10634U, 0x0U, 0x42A102E0U
#define IOMUXC_GPIO_EMC_B1_34_AHB_SRAMC_DATA12 0x42A10098U, 0xCU, 0, 0, 0x42A102E0U
#define IOMUXC_GPIO_EMC_B1_34_SEMC_DATA12 0x42A10098U, 0x0U, 0, 0, 0x42A102E0U
#define IOMUXC_GPIO_EMC_B1_34_FLEXPWM3_PWMB02 0x42A10098U, 0x1U, 0x42A1053CU, 0x0U, 0x42A102E0U
#define IOMUXC_GPIO_EMC_B1_34_LPUART6_RTS_B 0x42A10098U, 0x2U, 0, 0, 0x42A102E0U
#define IOMUXC_GPIO_EMC_B1_34_FLEXSPI2_BUS2BIT_B_SCLK 0x42A10098U, 0x3U, 0x42A1059CU, 0x0U, 0x42A102E0U
#define IOMUXC_GPIO_EMC_B1_34_NETC_PINMUX_ETH2_RXD02 0x42A10098U, 0x4U, 0x42A1080CU, 0x1U, 0x42A102E0U
#define IOMUXC_GPIO_EMC_B1_34_GPIO3_IO02 0x42A10098U, 0x5U, 0, 0, 0x42A102E0U
#define IOMUXC_GPIO_EMC_B1_34_ECAT_RX_DATA2_1 0x42A10098U, 0x6U, 0x42A104C8U, 0x0U, 0x42A102E0U
#define IOMUXC_GPIO_EMC_B1_34_NETC_PINMUX_ETH0_TXD00 0x42A10098U, 0x9U, 0, 0, 0x42A102E0U

#define IOMUXC_GPIO_EMC_B1_35_LPSPI5_PCS1 0x42A1009CU, 0xAU, 0x42A10638U, 0x0U, 0x42A102E4U
#define IOMUXC_GPIO_EMC_B1_35_AHB_SRAMC_DATA13 0x42A1009CU, 0xCU, 0, 0, 0x42A102E4U
#define IOMUXC_GPIO_EMC_B1_35_SEMC_DATA13 0x42A1009CU, 0x0U, 0, 0, 0x42A102E4U
#define IOMUXC_GPIO_EMC_B1_35_FLEXPWM3_PWMA02 0x42A1009CU, 0x1U, 0x42A1052CU, 0x0U, 0x42A102E4U
#define IOMUXC_GPIO_EMC_B1_35_LPUART5_TX 0x42A1009CU, 0x2U, 0x42A106A0U, 0x1U, 0x42A102E4U
#define IOMUXC_GPIO_EMC_B1_35_FLEXSPI2_BUS2BIT_A_DATA00 0x42A1009CU, 0x3U, 0x42A10578U, 0x0U, 0x42A102E4U
#define IOMUXC_GPIO_EMC_B1_35_NETC_PINMUX_ETH2_RXD03 0x42A1009CU, 0x4U, 0x42A10810U, 0x1U, 0x42A102E4U
#define IOMUXC_GPIO_EMC_B1_35_GPIO3_IO03 0x42A1009CU, 0x5U, 0, 0, 0x42A102E4U
#define IOMUXC_GPIO_EMC_B1_35_ECAT_RX_DATA3_1 0x42A1009CU, 0x6U, 0x42A104D0U, 0x0U, 0x42A102E4U
#define IOMUXC_GPIO_EMC_B1_35_NETC_PINMUX_ETH0_TXD01 0x42A1009CU, 0x9U, 0, 0, 0x42A102E4U

#define IOMUXC_GPIO_EMC_B1_36_SEMC_DATA14 0x42A100A0U, 0x0U, 0, 0, 0x42A102E8U
#define IOMUXC_GPIO_EMC_B1_36_FLEXPWM1_PWMA00 0x42A100A0U, 0x1U, 0x42A104F4U, 0x1U, 0x42A102E8U
#define IOMUXC_GPIO_EMC_B1_36_LPUART5_RX 0x42A100A0U, 0x2U, 0x42A1069CU, 0x1U, 0x42A102E8U
#define IOMUXC_GPIO_EMC_B1_36_FLEXSPI2_BUS2BIT_A_DATA01 0x42A100A0U, 0x3U, 0x42A1057CU, 0x0U, 0x42A102E8U
#define IOMUXC_GPIO_EMC_B1_36_NETC_PINMUX_ETH2_TXD03 0x42A100A0U, 0x4U, 0, 0, 0x42A102E8U
#define IOMUXC_GPIO_EMC_B1_36_GPIO3_IO04 0x42A100A0U, 0x5U, 0, 0, 0x42A102E8U
#define IOMUXC_GPIO_EMC_B1_36_ECAT_TX_DATA3_1 0x42A100A0U, 0x6U, 0, 0, 0x42A102E8U
#define IOMUXC_GPIO_EMC_B1_36_NETC_PINMUX_ETH0_TX_EN 0x42A100A0U, 0x9U, 0, 0, 0x42A102E8U
#define IOMUXC_GPIO_EMC_B1_36_AHB_SRAMC_DATA14 0x42A100A0U, 0xCU, 0, 0, 0x42A102E8U

#define IOMUXC_GPIO_EMC_B1_37_AHB_SRAMC_DATA15 0x42A100A4U, 0xCU, 0, 0, 0x42A102ECU
#define IOMUXC_GPIO_EMC_B1_37_SEMC_DATA15 0x42A100A4U, 0x0U, 0, 0, 0x42A102ECU
#define IOMUXC_GPIO_EMC_B1_37_FLEXPWM1_PWMB00 0x42A100A4U, 0x1U, 0x42A10500U, 0x1U, 0x42A102ECU
#define IOMUXC_GPIO_EMC_B1_37_LPUART5_CTS_B 0x42A100A4U, 0x2U, 0x42A1068CU, 0x0U, 0x42A102ECU
#define IOMUXC_GPIO_EMC_B1_37_FLEXSPI2_BUS2BIT_A_DATA02 0x42A100A4U, 0x3U, 0x42A10580U, 0x0U, 0x42A102ECU
#define IOMUXC_GPIO_EMC_B1_37_NETC_PINMUX_ETH2_TXD02 0x42A100A4U, 0x4U, 0, 0, 0x42A102ECU
#define IOMUXC_GPIO_EMC_B1_37_GPIO3_IO05 0x42A100A4U, 0x5U, 0, 0, 0x42A102ECU
#define IOMUXC_GPIO_EMC_B1_37_ECAT_TX_DATA2_1 0x42A100A4U, 0x6U, 0, 0, 0x42A102ECU
#define IOMUXC_GPIO_EMC_B1_37_NETC_PINMUX_ETH0_TX_CLK 0x42A100A4U, 0x9U, 0x42A107F4U, 0x0U, 0x42A102ECU

#define IOMUXC_GPIO_EMC_B1_38_AHB_SRAMC_UBB 0x42A100A8U, 0xCU, 0, 0, 0x42A102F0U
#define IOMUXC_GPIO_EMC_B1_38_SEMC_DM01 0x42A100A8U, 0x0U, 0, 0, 0x42A102F0U
#define IOMUXC_GPIO_EMC_B1_38_FLEXPWM1_PWMB03 0x42A100A8U, 0x1U, 0, 0, 0x42A102F0U
#define IOMUXC_GPIO_EMC_B1_38_LPUART5_RTS_B 0x42A100A8U, 0x2U, 0, 0, 0x42A102F0U
#define IOMUXC_GPIO_EMC_B1_38_FLEXSPI2_BUS2BIT_A_DATA03 0x42A100A8U, 0x3U, 0x42A10584U, 0x0U, 0x42A102F0U
#define IOMUXC_GPIO_EMC_B1_38_NETC_PINMUX_ETH2_RX_CLK 0x42A100A8U, 0x4U, 0x42A107F8U, 0x2U, 0x42A102F0U
#define IOMUXC_GPIO_EMC_B1_38_GPIO3_IO06 0x42A100A8U, 0x5U, 0, 0, 0x42A102F0U
#define IOMUXC_GPIO_EMC_B1_38_ECAT_RX_CLK_1 0x42A100A8U, 0x6U, 0x42A104B0U, 0x0U, 0x42A102F0U
#define IOMUXC_GPIO_EMC_B1_38_NETC_PINMUX_ETH0_RXD00 0x42A100A8U, 0x9U, 0x42A107E4U, 0x0U, 0x42A102F0U

#define IOMUXC_GPIO_EMC_B1_39_SEMC_DQS 0x42A100ACU, 0x0U, 0, 0, 0x42A102F4U
#define IOMUXC_GPIO_EMC_B1_39_FLEXPWM1_PWMA03 0x42A100ACU, 0x1U, 0, 0, 0x42A102F4U
#define IOMUXC_GPIO_EMC_B1_39_XBAR1_XBAR_INOUT15 0x42A100ACU, 0x2U, 0x42A10938U, 0x0U, 0x42A102F4U
#define IOMUXC_GPIO_EMC_B1_39_FLEXSPI2_BUS2BIT_A_SS0_B 0x42A100ACU, 0x3U, 0, 0, 0x42A102F4U
#define IOMUXC_GPIO_EMC_B1_39_NETC_PINMUX_ETH2_TX_ER 0x42A100ACU, 0x4U, 0, 0, 0x42A102F4U
#define IOMUXC_GPIO_EMC_B1_39_GPIO3_IO07 0x42A100ACU, 0x5U, 0, 0, 0x42A102F4U
#define IOMUXC_GPIO_EMC_B1_39_QTIMER2_TIMER1 0x42A100ACU, 0x6U, 0x42A10868U, 0x0U, 0x42A102F4U
#define IOMUXC_GPIO_EMC_B1_39_NETC_PINMUX_ETH0_RXD01 0x42A100ACU, 0x9U, 0x42A107E8U, 0x0U, 0x42A102F4U
#define IOMUXC_GPIO_EMC_B1_39_AHB_SRAMC_CS1 0x42A100ACU, 0xCU, 0, 0, 0x42A102F4U

#define IOMUXC_GPIO_EMC_B1_40_SEMC_RDY 0x42A100B0U, 0x0U, 0, 0, 0x42A102F8U
#define IOMUXC_GPIO_EMC_B1_40_NETC_EMDC 0x42A100B0U, 0x1U, 0, 0, 0x42A102F8U
#define IOMUXC_GPIO_EMC_B1_40_NETC_ETH2_SLV_MDC 0x42A100B0U, 0x2U, 0x42A107A4U, 0x1U, 0x42A102F8U
#define IOMUXC_GPIO_EMC_B1_40_FLEXSPI2_BUS2BIT_A_DQS 0x42A100B0U, 0x3U, 0x42A10570U, 0x0U, 0x42A102F8U
#define IOMUXC_GPIO_EMC_B1_40_NETC_ETH2_CRS 0x42A100B0U, 0x4U, 0x42A107A0U, 0x1U, 0x42A102F8U
#define IOMUXC_GPIO_EMC_B1_40_GPIO3_IO08 0x42A100B0U, 0x5U, 0, 0, 0x42A102F8U
#define IOMUXC_GPIO_EMC_B1_40_QTIMER3_TIMER1 0x42A100B0U, 0x6U, 0x42A10874U, 0x0U, 0x42A102F8U
#define IOMUXC_GPIO_EMC_B1_40_NETC_PINMUX_ETH0_RX_DV 0x42A100B0U, 0x9U, 0x42A107DCU, 0x0U, 0x42A102F8U
#define IOMUXC_GPIO_EMC_B1_40_AHB_SRAMC_CS2 0x42A100B0U, 0xCU, 0, 0, 0x42A102F8U

#define IOMUXC_GPIO_EMC_B1_41_AHB_SRAMC_CS3 0x42A100B4U, 0xCU, 0, 0, 0x42A102FCU
#define IOMUXC_GPIO_EMC_B1_41_SEMC_CSX00 0x42A100B4U, 0x0U, 0, 0, 0x42A102FCU
#define IOMUXC_GPIO_EMC_B1_41_NETC_EMDIO 0x42A100B4U, 0x1U, 0x42A10798U, 0x1U, 0x42A102FCU
#define IOMUXC_GPIO_EMC_B1_41_NETC_ETH2_SLV_MDIO 0x42A100B4U, 0x2U, 0x42A107A8U, 0x1U, 0x42A102FCU
#define IOMUXC_GPIO_EMC_B1_41_FLEXSPI2_BUS2BIT_A_SCLK 0x42A100B4U, 0x3U, 0x42A10598U, 0x0U, 0x42A102FCU
#define IOMUXC_GPIO_EMC_B1_41_NETC_ETH2_COL 0x42A100B4U, 0x4U, 0x42A1079CU, 0x1U, 0x42A102FCU
#define IOMUXC_GPIO_EMC_B1_41_GPIO3_IO09 0x42A100B4U, 0x5U, 0, 0, 0x42A102FCU
#define IOMUXC_GPIO_EMC_B1_41_QTIMER4_TIMER1 0x42A100B4U, 0x6U, 0x42A10880U, 0x0U, 0x42A102FCU
#define IOMUXC_GPIO_EMC_B1_41_NETC_PINMUX_ETH0_RX_ER 0x42A100B4U, 0x9U, 0x42A107E0U, 0x0U, 0x42A102FCU

#define IOMUXC_GPIO_EMC_B2_00_SEMC_DATA16 0x42A100B8U, 0x0U, 0, 0, 0x42A10300U
#define IOMUXC_GPIO_EMC_B2_00_CCM_ENET_REF_CLK_25M 0x42A100B8U, 0x1U, 0, 0, 0x42A10300U
#define IOMUXC_GPIO_EMC_B2_00_QTIMER5_TIMER1 0x42A100B8U, 0x2U, 0x42A1088CU, 0x0U, 0x42A10300U
#define IOMUXC_GPIO_EMC_B2_00_NETC_EMDC 0x42A100B8U, 0x3U, 0, 0, 0x42A10300U
#define IOMUXC_GPIO_EMC_B2_00_NETC_PINMUX_ETH0_RX_CLK 0x42A100B8U, 0x4U, 0x42A107D8U, 0x0U, 0x42A10300U
#define IOMUXC_GPIO_EMC_B2_00_GPIO3_IO10 0x42A100B8U, 0x5U, 0, 0, 0x42A10300U
#define IOMUXC_GPIO_EMC_B2_00_XBAR1_XBAR_INOUT20 0x42A100B8U, 0x6U, 0x42A10948U, 0x0U, 0x42A10300U
#define IOMUXC_GPIO_EMC_B2_00_LPSPI5_SCK 0x42A100B8U, 0x8U, 0x42A10644U, 0x1U, 0x42A10300U
#define IOMUXC_GPIO_EMC_B2_00_LPI2C3_SCL 0x42A100B8U, 0x9U, 0x42A105E8U, 0x0U, 0x42A10300U
#define IOMUXC_GPIO_EMC_B2_00_FLEXPWM3_PWMA00 0x42A100B8U, 0xAU, 0x42A10524U, 0x1U, 0x42A10300U
#define IOMUXC_GPIO_EMC_B2_00_ECAT_RX_CLK_0 0x42A100B8U, 0xCU, 0x42A104ACU, 0x1U, 0x42A10300U

#define IOMUXC_GPIO_EMC_B2_01_SEMC_DATA17 0x42A100BCU, 0x0U, 0, 0, 0x42A10304U
#define IOMUXC_GPIO_EMC_B2_01_USDHC2_CD_B 0x42A100BCU, 0x1U, 0x42A1092CU, 0x0U, 0x42A10304U
#define IOMUXC_GPIO_EMC_B2_01_QTIMER6_TIMER1 0x42A100BCU, 0x2U, 0x42A10898U, 0x0U, 0x42A10304U
#define IOMUXC_GPIO_EMC_B2_01_NETC_EMDIO 0x42A100BCU, 0x3U, 0x42A10798U, 0x2U, 0x42A10304U
#define IOMUXC_GPIO_EMC_B2_01_NETC_PINMUX_ETH0_RXD02 0x42A100BCU, 0x4U, 0x42A107ECU, 0x0U, 0x42A10304U
#define IOMUXC_GPIO_EMC_B2_01_GPIO3_IO11 0x42A100BCU, 0x5U, 0, 0, 0x42A10304U
#define IOMUXC_GPIO_EMC_B2_01_XBAR1_XBAR_INOUT21 0x42A100BCU, 0x6U, 0x42A1094CU, 0x0U, 0x42A10304U
#define IOMUXC_GPIO_EMC_B2_01_LPSPI5_PCS0 0x42A100BCU, 0x8U, 0x42A10634U, 0x1U, 0x42A10304U
#define IOMUXC_GPIO_EMC_B2_01_LPI2C3_SDA 0x42A100BCU, 0x9U, 0x42A105ECU, 0x0U, 0x42A10304U
#define IOMUXC_GPIO_EMC_B2_01_FLEXPWM3_PWMB00 0x42A100BCU, 0xAU, 0x42A10534U, 0x1U, 0x42A10304U
#define IOMUXC_GPIO_EMC_B2_01_ECAT_RX_DATA2_0 0x42A100BCU, 0xCU, 0x42A104C4U, 0x1U, 0x42A10304U

#define IOMUXC_GPIO_EMC_B2_02_SEMC_DATA18 0x42A100C0U, 0x0U, 0, 0, 0x42A10308U
#define IOMUXC_GPIO_EMC_B2_02_USDHC2_WP 0x42A100C0U, 0x1U, 0x42A10930U, 0x0U, 0x42A10308U
#define IOMUXC_GPIO_EMC_B2_02_QTIMER7_TIMER1 0x42A100C0U, 0x2U, 0x42A108A4U, 0x0U, 0x42A10308U
#define IOMUXC_GPIO_EMC_B2_02_NETC_PINMUX_ETH0_RXD03 0x42A100C0U, 0x4U, 0x42A107F0U, 0x0U, 0x42A10308U
#define IOMUXC_GPIO_EMC_B2_02_GPIO3_IO12 0x42A100C0U, 0x5U, 0, 0, 0x42A10308U
#define IOMUXC_GPIO_EMC_B2_02_XBAR1_XBAR_INOUT22 0x42A100C0U, 0x6U, 0x42A10950U, 0x0U, 0x42A10308U
#define IOMUXC_GPIO_EMC_B2_02_LPSPI5_SDO 0x42A100C0U, 0x8U, 0x42A1064CU, 0x1U, 0x42A10308U
#define IOMUXC_GPIO_EMC_B2_02_CCM_CLKO1 0x42A100C0U, 0x9U, 0, 0, 0x42A10308U
#define IOMUXC_GPIO_EMC_B2_02_FLEXPWM3_PWMA01 0x42A100C0U, 0xAU, 0x42A10528U, 0x1U, 0x42A10308U
#define IOMUXC_GPIO_EMC_B2_02_ECAT_RX_DATA3_0 0x42A100C0U, 0xCU, 0x42A104CCU, 0x1U, 0x42A10308U

#define IOMUXC_GPIO_EMC_B2_03_SEMC_DATA19 0x42A100C4U, 0x0U, 0, 0, 0x42A1030CU
#define IOMUXC_GPIO_EMC_B2_03_USDHC2_VSELECT 0x42A100C4U, 0x1U, 0, 0, 0x42A1030CU
#define IOMUXC_GPIO_EMC_B2_03_QTIMER8_TIMER1 0x42A100C4U, 0x2U, 0x42A108ACU, 0x0U, 0x42A1030CU
#define IOMUXC_GPIO_EMC_B2_03_NETC_PINMUX_ETH0_TXD02 0x42A100C4U, 0x4U, 0, 0, 0x42A1030CU
#define IOMUXC_GPIO_EMC_B2_03_GPIO3_IO13 0x42A100C4U, 0x5U, 0, 0, 0x42A1030CU
#define IOMUXC_GPIO_EMC_B2_03_XBAR1_XBAR_INOUT23 0x42A100C4U, 0x6U, 0x42A10954U, 0x0U, 0x42A1030CU
#define IOMUXC_GPIO_EMC_B2_03_LPSPI5_SDI 0x42A100C4U, 0x8U, 0x42A10648U, 0x1U, 0x42A1030CU
#define IOMUXC_GPIO_EMC_B2_03_NETC_ETH3_CRS 0x42A100C4U, 0x9U, 0x42A107B0U, 0x1U, 0x42A1030CU
#define IOMUXC_GPIO_EMC_B2_03_FLEXPWM3_PWMB01 0x42A100C4U, 0xAU, 0x42A10538U, 0x1U, 0x42A1030CU
#define IOMUXC_GPIO_EMC_B2_03_ECAT_TX_DATA2_0 0x42A100C4U, 0xCU, 0, 0, 0x42A1030CU

#define IOMUXC_GPIO_EMC_B2_04_SEMC_DATA20 0x42A100C8U, 0x0U, 0, 0, 0x42A10310U
#define IOMUXC_GPIO_EMC_B2_04_USDHC2_RESET_B 0x42A100C8U, 0x1U, 0, 0, 0x42A10310U
#define IOMUXC_GPIO_EMC_B2_04_SAI2_MCLK 0x42A100C8U, 0x2U, 0, 0, 0x42A10310U
#define IOMUXC_GPIO_EMC_B2_04_NETC_PINMUX_ETH0_TXD03 0x42A100C8U, 0x4U, 0, 0, 0x42A10310U
#define IOMUXC_GPIO_EMC_B2_04_GPIO3_IO14 0x42A100C8U, 0x5U, 0, 0, 0x42A10310U
#define IOMUXC_GPIO_EMC_B2_04_XBAR1_XBAR_INOUT24 0x42A100C8U, 0x6U, 0x42A10958U, 0x0U, 0x42A10310U
#define IOMUXC_GPIO_EMC_B2_04_LPSPI3_SCK 0x42A100C8U, 0x8U, 0x42A10618U, 0x0U, 0x42A10310U
#define IOMUXC_GPIO_EMC_B2_04_NETC_ETH3_COL 0x42A100C8U, 0x9U, 0x42A107ACU, 0x1U, 0x42A10310U
#define IOMUXC_GPIO_EMC_B2_04_FLEXPWM3_PWMB02 0x42A100C8U, 0xAU, 0x42A1053CU, 0x1U, 0x42A10310U
#define IOMUXC_GPIO_EMC_B2_04_ECAT_TX_DATA3_0 0x42A100C8U, 0xCU, 0, 0, 0x42A10310U

#define IOMUXC_GPIO_EMC_B2_05_SEMC_DATA21 0x42A100CCU, 0x0U, 0, 0, 0x42A10314U
#define IOMUXC_GPIO_EMC_B2_05_NETC_ETH4_SLV_MDC 0x42A100CCU, 0x1U, 0x42A107C4U, 0x1U, 0x42A10314U
#define IOMUXC_GPIO_EMC_B2_05_SAI2_RX_SYNC 0x42A100CCU, 0x2U, 0, 0, 0x42A10314U
#define IOMUXC_GPIO_EMC_B2_05_NETC_PINMUX_ETH0_TXD00 0x42A100CCU, 0x3U, 0, 0, 0x42A10314U
#define IOMUXC_GPIO_EMC_B2_05_NETC_ETH4_CRS 0x42A100CCU, 0x4U, 0x42A107C0U, 0x1U, 0x42A10314U
#define IOMUXC_GPIO_EMC_B2_05_GPIO3_IO15 0x42A100CCU, 0x5U, 0, 0, 0x42A10314U
#define IOMUXC_GPIO_EMC_B2_05_XBAR1_XBAR_INOUT25 0x42A100CCU, 0x6U, 0x42A1095CU, 0x0U, 0x42A10314U
#define IOMUXC_GPIO_EMC_B2_05_LPSPI3_PCS0 0x42A100CCU, 0x8U, 0x42A10608U, 0x0U, 0x42A10314U
#define IOMUXC_GPIO_EMC_B2_05_NETC_PINMUX_ETH3_TXD00 0x42A100CCU, 0x9U, 0, 0, 0x42A10314U
#define IOMUXC_GPIO_EMC_B2_05_FLEXPWM3_PWMA02 0x42A100CCU, 0xAU, 0x42A1052CU, 0x1U, 0x42A10314U
#define IOMUXC_GPIO_EMC_B2_05_ECAT_TX_DATA0_0 0x42A100CCU, 0xCU, 0, 0, 0x42A10314U

#define IOMUXC_GPIO_EMC_B2_06_SEMC_DATA22 0x42A100D0U, 0x0U, 0, 0, 0x42A10318U
#define IOMUXC_GPIO_EMC_B2_06_FLEXPWM3_PWMB03 0x42A100D0U, 0xAU, 0x42A10540U, 0x1U, 0x42A10318U
#define IOMUXC_GPIO_EMC_B2_06_NETC_ETH4_SLV_MDIO 0x42A100D0U, 0x1U, 0x42A107C8U, 0x1U, 0x42A10318U
#define IOMUXC_GPIO_EMC_B2_06_SAI2_RX_BCLK 0x42A100D0U, 0x2U, 0, 0, 0x42A10318U
#define IOMUXC_GPIO_EMC_B2_06_ECAT_TX_DATA1_0 0x42A100D0U, 0xCU, 0, 0, 0x42A10318U
#define IOMUXC_GPIO_EMC_B2_06_NETC_PINMUX_ETH0_TXD01 0x42A100D0U, 0x3U, 0, 0, 0x42A10318U
#define IOMUXC_GPIO_EMC_B2_06_NETC_ETH4_COL 0x42A100D0U, 0x4U, 0x42A107BCU, 0x1U, 0x42A10318U
#define IOMUXC_GPIO_EMC_B2_06_GPIO3_IO16 0x42A100D0U, 0x5U, 0, 0, 0x42A10318U
#define IOMUXC_GPIO_EMC_B2_06_XBAR1_XBAR_INOUT26 0x42A100D0U, 0x6U, 0x42A10960U, 0x0U, 0x42A10318U
#define IOMUXC_GPIO_EMC_B2_06_LPSPI3_SDO 0x42A100D0U, 0x8U, 0x42A10620U, 0x0U, 0x42A10318U
#define IOMUXC_GPIO_EMC_B2_06_NETC_PINMUX_ETH3_TXD01 0x42A100D0U, 0x9U, 0, 0, 0x42A10318U

#define IOMUXC_GPIO_EMC_B2_07_SEMC_DATA23 0x42A100D4U, 0x0U, 0, 0, 0x42A1031CU
#define IOMUXC_GPIO_EMC_B2_07_NETC_PINMUX_ETH4_TX_ER 0x42A100D4U, 0x1U, 0, 0, 0x42A1031CU
#define IOMUXC_GPIO_EMC_B2_07_SAI2_RX_DATA 0x42A100D4U, 0x2U, 0, 0, 0x42A1031CU
#define IOMUXC_GPIO_EMC_B2_07_NETC_PINMUX_ETH0_TX_EN 0x42A100D4U, 0x3U, 0, 0, 0x42A1031CU
#define IOMUXC_GPIO_EMC_B2_07_GPIO3_IO17 0x42A100D4U, 0x5U, 0, 0, 0x42A1031CU
#define IOMUXC_GPIO_EMC_B2_07_XBAR1_XBAR_INOUT27 0x42A100D4U, 0x6U, 0x42A10964U, 0x0U, 0x42A1031CU
#define IOMUXC_GPIO_EMC_B2_07_LPSPI3_SDI 0x42A100D4U, 0x8U, 0x42A1061CU, 0x0U, 0x42A1031CU
#define IOMUXC_GPIO_EMC_B2_07_NETC_PINMUX_ETH3_TX_EN 0x42A100D4U, 0x9U, 0, 0, 0x42A1031CU
#define IOMUXC_GPIO_EMC_B2_07_FLEXPWM3_PWMA03 0x42A100D4U, 0xAU, 0x42A10530U, 0x1U, 0x42A1031CU
#define IOMUXC_GPIO_EMC_B2_07_ECAT_TX_EN_0 0x42A100D4U, 0xCU, 0, 0, 0x42A1031CU

#define IOMUXC_GPIO_EMC_B2_08_SEMC_DM02 0x42A100D8U, 0x0U, 0, 0, 0x42A10320U
#define IOMUXC_GPIO_EMC_B2_08_NETC_PINMUX_ETH4_RX_CLK 0x42A100D8U, 0x1U, 0x42A10838U, 0x1U, 0x42A10320U
#define IOMUXC_GPIO_EMC_B2_08_SAI2_TX_DATA 0x42A100D8U, 0x2U, 0, 0, 0x42A10320U
#define IOMUXC_GPIO_EMC_B2_08_NETC_PINMUX_ETH0_TX_CLK 0x42A100D8U, 0x3U, 0x42A107F4U, 0x1U, 0x42A10320U
#define IOMUXC_GPIO_EMC_B2_08_GPIO3_IO18 0x42A100D8U, 0x5U, 0, 0, 0x42A10320U
#define IOMUXC_GPIO_EMC_B2_08_XBAR1_XBAR_INOUT28 0x42A100D8U, 0x6U, 0x42A10968U, 0x0U, 0x42A10320U
#define IOMUXC_GPIO_EMC_B2_08_LPSPI3_PCS3 0x42A100D8U, 0x8U, 0x42A10614U, 0x0U, 0x42A10320U
#define IOMUXC_GPIO_EMC_B2_08_NETC_PINMUX_ETH3_TX_CLK 0x42A100D8U, 0x9U, 0x42A10834U, 0x1U, 0x42A10320U
#define IOMUXC_GPIO_EMC_B2_08_CCM_CLKO2 0x42A100D8U, 0xAU, 0, 0, 0x42A10320U
#define IOMUXC_GPIO_EMC_B2_08_ECAT_TX_CLK_0 0x42A100D8U, 0xCU, 0x42A104E4U, 0x1U, 0x42A10320U

#define IOMUXC_GPIO_EMC_B2_09_QTIMER1_TIMER0 0x42A100DCU, 0xAU, 0x42A10858U, 0x1U, 0x42A10324U
#define IOMUXC_GPIO_EMC_B2_09_ECAT_RX_DATA0_0 0x42A100DCU, 0xCU, 0x42A104B4U, 0x1U, 0x42A10324U
#define IOMUXC_GPIO_EMC_B2_09_SEMC_DATA24 0x42A100DCU, 0x0U, 0, 0, 0x42A10324U
#define IOMUXC_GPIO_EMC_B2_09_NETC_PINMUX_ETH4_RXD03 0x42A100DCU, 0x1U, 0x42A10850U, 0x1U, 0x42A10324U
#define IOMUXC_GPIO_EMC_B2_09_SAI2_TX_BCLK 0x42A100DCU, 0x2U, 0, 0, 0x42A10324U
#define IOMUXC_GPIO_EMC_B2_09_NETC_PINMUX_ETH0_RXD00 0x42A100DCU, 0x3U, 0x42A107E4U, 0x1U, 0x42A10324U
#define IOMUXC_GPIO_EMC_B2_09_GPIO3_IO19 0x42A100DCU, 0x5U, 0, 0, 0x42A10324U
#define IOMUXC_GPIO_EMC_B2_09_XBAR1_XBAR_INOUT29 0x42A100DCU, 0x6U, 0x42A1096CU, 0x0U, 0x42A10324U
#define IOMUXC_GPIO_EMC_B2_09_LPSPI3_PCS2 0x42A100DCU, 0x8U, 0x42A10610U, 0x0U, 0x42A10324U
#define IOMUXC_GPIO_EMC_B2_09_NETC_PINMUX_ETH3_RXD00 0x42A100DCU, 0x9U, 0x42A10824U, 0x1U, 0x42A10324U

#define IOMUXC_GPIO_EMC_B2_10_QTIMER1_TIMER1 0x42A100E0U, 0xAU, 0x42A1085CU, 0x1U, 0x42A10328U
#define IOMUXC_GPIO_EMC_B2_10_ECAT_RX_DATA1_0 0x42A100E0U, 0xCU, 0x42A104BCU, 0x1U, 0x42A10328U
#define IOMUXC_GPIO_EMC_B2_10_SEMC_DATA25 0x42A100E0U, 0x0U, 0, 0, 0x42A10328U
#define IOMUXC_GPIO_EMC_B2_10_NETC_PINMUX_ETH4_RXD02 0x42A100E0U, 0x1U, 0x42A1084CU, 0x1U, 0x42A10328U
#define IOMUXC_GPIO_EMC_B2_10_SAI2_TX_SYNC 0x42A100E0U, 0x2U, 0, 0, 0x42A10328U
#define IOMUXC_GPIO_EMC_B2_10_NETC_PINMUX_ETH0_RXD01 0x42A100E0U, 0x3U, 0x42A107E8U, 0x1U, 0x42A10328U
#define IOMUXC_GPIO_EMC_B2_10_GPIO3_IO20 0x42A100E0U, 0x5U, 0, 0, 0x42A10328U
#define IOMUXC_GPIO_EMC_B2_10_XBAR1_XBAR_INOUT30 0x42A100E0U, 0x6U, 0x42A10970U, 0x0U, 0x42A10328U
#define IOMUXC_GPIO_EMC_B2_10_LPSPI3_PCS1 0x42A100E0U, 0x8U, 0x42A1060CU, 0x0U, 0x42A10328U
#define IOMUXC_GPIO_EMC_B2_10_NETC_PINMUX_ETH3_RXD01 0x42A100E0U, 0x9U, 0x42A10828U, 0x1U, 0x42A10328U

#define IOMUXC_GPIO_EMC_B2_11_SEMC_DATA26 0x42A100E4U, 0x0U, 0, 0, 0x42A1032CU
#define IOMUXC_GPIO_EMC_B2_11_NETC_PINMUX_ETH4_TXD03 0x42A100E4U, 0x1U, 0, 0, 0x42A1032CU
#define IOMUXC_GPIO_EMC_B2_11_SPDIF_OUT 0x42A100E4U, 0x2U, 0, 0, 0x42A1032CU
#define IOMUXC_GPIO_EMC_B2_11_NETC_PINMUX_ETH0_RX_DV 0x42A100E4U, 0x3U, 0x42A107DCU, 0x1U, 0x42A1032CU
#define IOMUXC_GPIO_EMC_B2_11_LPSPI5_PCS3 0x42A100E4U, 0x4U, 0x42A10640U, 0x0U, 0x42A1032CU
#define IOMUXC_GPIO_EMC_B2_11_GPIO3_IO21 0x42A100E4U, 0x5U, 0, 0, 0x42A1032CU
#define IOMUXC_GPIO_EMC_B2_11_XBAR1_XBAR_INOUT31 0x42A100E4U, 0x6U, 0x42A10974U, 0x0U, 0x42A1032CU
#define IOMUXC_GPIO_EMC_B2_11_SAI3_RX_SYNC 0x42A100E4U, 0x8U, 0, 0, 0x42A1032CU
#define IOMUXC_GPIO_EMC_B2_11_NETC_PINMUX_ETH3_RX_DV 0x42A100E4U, 0x9U, 0x42A1081CU, 0x1U, 0x42A1032CU
#define IOMUXC_GPIO_EMC_B2_11_QTIMER1_TIMER2 0x42A100E4U, 0xAU, 0x42A10860U, 0x0U, 0x42A1032CU
#define IOMUXC_GPIO_EMC_B2_11_ECAT_RX_DV_0 0x42A100E4U, 0xCU, 0x42A104D4U, 0x1U, 0x42A1032CU

#define IOMUXC_GPIO_EMC_B2_12_SEMC_DATA27 0x42A100E8U, 0x0U, 0, 0, 0x42A10330U
#define IOMUXC_GPIO_EMC_B2_12_NETC_PINMUX_ETH4_TXD02 0x42A100E8U, 0x1U, 0, 0, 0x42A10330U
#define IOMUXC_GPIO_EMC_B2_12_SPDIF_IN 0x42A100E8U, 0x2U, 0x42A10908U, 0x0U, 0x42A10330U
#define IOMUXC_GPIO_EMC_B2_12_NETC_PINMUX_ETH0_RX_ER 0x42A100E8U, 0x3U, 0x42A107E0U, 0x1U, 0x42A10330U
#define IOMUXC_GPIO_EMC_B2_12_LPSPI5_PCS2 0x42A100E8U, 0x4U, 0x42A1063CU, 0x0U, 0x42A10330U
#define IOMUXC_GPIO_EMC_B2_12_GPIO3_IO22 0x42A100E8U, 0x5U, 0, 0, 0x42A10330U
#define IOMUXC_GPIO_EMC_B2_12_XBAR1_XBAR_INOUT32 0x42A100E8U, 0x6U, 0x42A10978U, 0x0U, 0x42A10330U
#define IOMUXC_GPIO_EMC_B2_12_SAI3_RX_BCLK 0x42A100E8U, 0x8U, 0, 0, 0x42A10330U
#define IOMUXC_GPIO_EMC_B2_12_NETC_PINMUX_ETH3_RX_ER 0x42A100E8U, 0x9U, 0x42A10820U, 0x1U, 0x42A10330U
#define IOMUXC_GPIO_EMC_B2_12_QTIMER1_TIMER3 0x42A100E8U, 0xAU, 0, 0, 0x42A10330U
#define IOMUXC_GPIO_EMC_B2_12_ECAT_PT0_RX_ER 0x42A100E8U, 0xCU, 0x42A104DCU, 0x1U, 0x42A10330U

#define IOMUXC_GPIO_EMC_B2_13_QTIMER2_TIMER0 0x42A100ECU, 0xAU, 0x42A10864U, 0x1U, 0x42A10334U
#define IOMUXC_GPIO_EMC_B2_13_ECAT_TX_DATA0_1 0x42A100ECU, 0xCU, 0, 0, 0x42A10334U
#define IOMUXC_GPIO_EMC_B2_13_SEMC_DATA28 0x42A100ECU, 0x0U, 0, 0, 0x42A10334U
#define IOMUXC_GPIO_EMC_B2_13_NETC_PINMUX_ETH4_TXD00 0x42A100ECU, 0x1U, 0, 0, 0x42A10334U
#define IOMUXC_GPIO_EMC_B2_13_LPUART11_TX 0x42A100ECU, 0x2U, 0x42A10678U, 0x0U, 0x42A10334U
#define IOMUXC_GPIO_EMC_B2_13_NETC_PINMUX_ETH0_TXD03 0x42A100ECU, 0x3U, 0, 0, 0x42A10334U
#define IOMUXC_GPIO_EMC_B2_13_LPSPI5_PCS1 0x42A100ECU, 0x4U, 0x42A10638U, 0x1U, 0x42A10334U
#define IOMUXC_GPIO_EMC_B2_13_GPIO3_IO23 0x42A100ECU, 0x5U, 0, 0, 0x42A10334U
#define IOMUXC_GPIO_EMC_B2_13_XBAR1_XBAR_INOUT33 0x42A100ECU, 0x6U, 0x42A1097CU, 0x0U, 0x42A10334U
#define IOMUXC_GPIO_EMC_B2_13_SAI3_RX_DATA 0x42A100ECU, 0x8U, 0, 0, 0x42A10334U
#define IOMUXC_GPIO_EMC_B2_13_NETC_PINMUX_ETH3_TXD03 0x42A100ECU, 0x9U, 0, 0, 0x42A10334U

#define IOMUXC_GPIO_EMC_B2_14_SEMC_DATA29 0x42A100F0U, 0x0U, 0, 0, 0x42A10338U
#define IOMUXC_GPIO_EMC_B2_14_NETC_PINMUX_ETH4_TXD01 0x42A100F0U, 0x1U, 0, 0, 0x42A10338U
#define IOMUXC_GPIO_EMC_B2_14_LPUART11_RX 0x42A100F0U, 0x2U, 0x42A10674U, 0x0U, 0x42A10338U
#define IOMUXC_GPIO_EMC_B2_14_NETC_PINMUX_ETH0_TXD02 0x42A100F0U, 0x3U, 0, 0, 0x42A10338U
#define IOMUXC_GPIO_EMC_B2_14_LPUART5_DSR_B 0x42A100F0U, 0x4U, 0x42A10694U, 0x0U, 0x42A10338U
#define IOMUXC_GPIO_EMC_B2_14_GPIO3_IO24 0x42A100F0U, 0x5U, 0, 0, 0x42A10338U
#define IOMUXC_GPIO_EMC_B2_14_XBAR1_XBAR_INOUT34 0x42A100F0U, 0x6U, 0x42A10980U, 0x0U, 0x42A10338U
#define IOMUXC_GPIO_EMC_B2_14_SAI3_TX_DATA 0x42A100F0U, 0x8U, 0, 0, 0x42A10338U
#define IOMUXC_GPIO_EMC_B2_14_NETC_PINMUX_ETH3_TXD02 0x42A100F0U, 0x9U, 0, 0, 0x42A10338U
#define IOMUXC_GPIO_EMC_B2_14_QTIMER2_TIMER1 0x42A100F0U, 0xAU, 0x42A10868U, 0x1U, 0x42A10338U
#define IOMUXC_GPIO_EMC_B2_14_ECAT_TX_DATA1_1 0x42A100F0U, 0xCU, 0, 0, 0x42A10338U

#define IOMUXC_GPIO_EMC_B2_15_SEMC_DATA30 0x42A100F4U, 0x0U, 0, 0, 0x42A1033CU
#define IOMUXC_GPIO_EMC_B2_15_NETC_PINMUX_ETH4_TX_EN 0x42A100F4U, 0x1U, 0, 0, 0x42A1033CU
#define IOMUXC_GPIO_EMC_B2_15_LPUART11_CTS_B 0x42A100F4U, 0x2U, 0, 0, 0x42A1033CU
#define IOMUXC_GPIO_EMC_B2_15_NETC_PINMUX_ETH0_RX_CLK 0x42A100F4U, 0x3U, 0x42A107D8U, 0x1U, 0x42A1033CU
#define IOMUXC_GPIO_EMC_B2_15_LPUART5_DCD_B 0x42A100F4U, 0x4U, 0x42A10690U, 0x0U, 0x42A1033CU
#define IOMUXC_GPIO_EMC_B2_15_GPIO3_IO25 0x42A100F4U, 0x5U, 0, 0, 0x42A1033CU
#define IOMUXC_GPIO_EMC_B2_15_XBAR1_XBAR_INOUT35 0x42A100F4U, 0x6U, 0x42A10984U, 0x0U, 0x42A1033CU
#define IOMUXC_GPIO_EMC_B2_15_SAI3_TX_BCLK 0x42A100F4U, 0x8U, 0, 0, 0x42A1033CU
#define IOMUXC_GPIO_EMC_B2_15_NETC_PINMUX_ETH3_RX_CLK 0x42A100F4U, 0x9U, 0x42A10818U, 0x1U, 0x42A1033CU
#define IOMUXC_GPIO_EMC_B2_15_QTIMER2_TIMER2 0x42A100F4U, 0xAU, 0x42A1086CU, 0x0U, 0x42A1033CU
#define IOMUXC_GPIO_EMC_B2_15_ECAT_TX_EN_1 0x42A100F4U, 0xCU, 0, 0, 0x42A1033CU

#define IOMUXC_GPIO_EMC_B2_16_QTIMER2_TIMER3 0x42A100F8U, 0xAU, 0, 0, 0x42A10340U
#define IOMUXC_GPIO_EMC_B2_16_ECAT_TX_CLK_1 0x42A100F8U, 0xCU, 0x42A104E8U, 0x1U, 0x42A10340U
#define IOMUXC_GPIO_EMC_B2_16_SEMC_DATA31 0x42A100F8U, 0x0U, 0, 0, 0x42A10340U
#define IOMUXC_GPIO_EMC_B2_16_NETC_PINMUX_ETH4_TX_CLK 0x42A100F8U, 0x1U, 0x42A10854U, 0x1U, 0x42A10340U
#define IOMUXC_GPIO_EMC_B2_16_LPUART11_RTS_B 0x42A100F8U, 0x2U, 0, 0, 0x42A10340U
#define IOMUXC_GPIO_EMC_B2_16_NETC_PINMUX_ETH0_RXD02 0x42A100F8U, 0x3U, 0x42A107ECU, 0x1U, 0x42A10340U
#define IOMUXC_GPIO_EMC_B2_16_LPUART5_DTR_B 0x42A100F8U, 0x4U, 0, 0, 0x42A10340U
#define IOMUXC_GPIO_EMC_B2_16_GPIO3_IO26 0x42A100F8U, 0x5U, 0, 0, 0x42A10340U
#define IOMUXC_GPIO_EMC_B2_16_XBAR1_XBAR_INOUT14 0x42A100F8U, 0x6U, 0x42A10934U, 0x1U, 0x42A10340U
#define IOMUXC_GPIO_EMC_B2_16_SAI3_TX_SYNC 0x42A100F8U, 0x8U, 0, 0, 0x42A10340U
#define IOMUXC_GPIO_EMC_B2_16_NETC_PINMUX_ETH3_RXD02 0x42A100F8U, 0x9U, 0x42A1082CU, 0x1U, 0x42A10340U

#define IOMUXC_GPIO_EMC_B2_17_SEMC_DM03 0x42A100FCU, 0x0U, 0, 0, 0x42A10344U
#define IOMUXC_GPIO_EMC_B2_17_NETC_PINMUX_ETH4_RXD00 0x42A100FCU, 0x1U, 0x42A10844U, 0x1U, 0x42A10344U
#define IOMUXC_GPIO_EMC_B2_17_LPUART5_TX 0x42A100FCU, 0x2U, 0x42A106A0U, 0x2U, 0x42A10344U
#define IOMUXC_GPIO_EMC_B2_17_NETC_PINMUX_ETH0_RXD03 0x42A100FCU, 0x3U, 0x42A107F0U, 0x1U, 0x42A10344U
#define IOMUXC_GPIO_EMC_B2_17_GPIO3_IO27 0x42A100FCU, 0x5U, 0, 0, 0x42A10344U
#define IOMUXC_GPIO_EMC_B2_17_XBAR1_XBAR_INOUT15 0x42A100FCU, 0x6U, 0x42A10938U, 0x1U, 0x42A10344U
#define IOMUXC_GPIO_EMC_B2_17_SAI3_MCLK 0x42A100FCU, 0x8U, 0, 0, 0x42A10344U
#define IOMUXC_GPIO_EMC_B2_17_NETC_PINMUX_ETH3_RXD03 0x42A100FCU, 0x9U, 0x42A10830U, 0x1U, 0x42A10344U
#define IOMUXC_GPIO_EMC_B2_17_QTIMER3_TIMER0 0x42A100FCU, 0xAU, 0x42A10870U, 0x1U, 0x42A10344U
#define IOMUXC_GPIO_EMC_B2_17_ECAT_RX_DATA0_1 0x42A100FCU, 0xCU, 0x42A104B8U, 0x1U, 0x42A10344U

#define IOMUXC_GPIO_EMC_B2_18_SEMC_DQS4 0x42A10100U, 0x0U, 0, 0, 0x42A10348U
#define IOMUXC_GPIO_EMC_B2_18_NETC_PINMUX_ETH4_RXD01 0x42A10100U, 0x1U, 0x42A10848U, 0x1U, 0x42A10348U
#define IOMUXC_GPIO_EMC_B2_18_LPUART5_RX 0x42A10100U, 0x2U, 0x42A1069CU, 0x2U, 0x42A10348U
#define IOMUXC_GPIO_EMC_B2_18_NETC_PINMUX_ETH0_TX_ER 0x42A10100U, 0x3U, 0, 0, 0x42A10348U
#define IOMUXC_GPIO_EMC_B2_18_GPIO3_IO28 0x42A10100U, 0x5U, 0, 0, 0x42A10348U
#define IOMUXC_GPIO_EMC_B2_18_XBAR1_XBAR_INOUT16 0x42A10100U, 0x6U, 0, 0, 0x42A10348U
#define IOMUXC_GPIO_EMC_B2_18_EWM_EWM_OUT_B 0x42A10100U, 0x8U, 0, 0, 0x42A10348U
#define IOMUXC_GPIO_EMC_B2_18_NETC_PINMUX_ETH3_TX_ER 0x42A10100U, 0x9U, 0, 0, 0x42A10348U
#define IOMUXC_GPIO_EMC_B2_18_QTIMER3_TIMER1 0x42A10100U, 0xAU, 0x42A10874U, 0x1U, 0x42A10348U
#define IOMUXC_GPIO_EMC_B2_18_ECAT_RX_DATA1_1 0x42A10100U, 0xCU, 0x42A104C0U, 0x1U, 0x42A10348U

#define IOMUXC_GPIO_EMC_B2_19_QTIMER3_TIMER2 0x42A10104U, 0xAU, 0x42A10878U, 0x0U, 0x42A1034CU
#define IOMUXC_GPIO_EMC_B2_19_ECAT_RX_DV_1 0x42A10104U, 0xCU, 0x42A104D8U, 0x1U, 0x42A1034CU
#define IOMUXC_GPIO_EMC_B2_19_SEMC_CLKX00 0x42A10104U, 0x0U, 0, 0, 0x42A1034CU
#define IOMUXC_GPIO_EMC_B2_19_NETC_PINMUX_ETH4_RX_DV 0x42A10104U, 0x1U, 0x42A1083CU, 0x1U, 0x42A1034CU
#define IOMUXC_GPIO_EMC_B2_19_LPUART5_CTS_B 0x42A10104U, 0x2U, 0x42A1068CU, 0x1U, 0x42A1034CU
#define IOMUXC_GPIO_EMC_B2_19_NETC_ETH0_CRS 0x42A10104U, 0x3U, 0, 0, 0x42A1034CU
#define IOMUXC_GPIO_EMC_B2_19_NETC_EMDC 0x42A10104U, 0x4U, 0, 0, 0x42A1034CU
#define IOMUXC_GPIO_EMC_B2_19_GPIO3_IO29 0x42A10104U, 0x5U, 0, 0, 0x42A1034CU
#define IOMUXC_GPIO_EMC_B2_19_XBAR1_XBAR_INOUT36 0x42A10104U, 0x6U, 0x42A10988U, 0x0U, 0x42A1034CU
#define IOMUXC_GPIO_EMC_B2_19_LPI2C3_SCL 0x42A10104U, 0x8U, 0x42A105E8U, 0x1U, 0x42A1034CU
#define IOMUXC_GPIO_EMC_B2_19_NETC_ETH3_SLV_MDC 0x42A10104U, 0x9U, 0x42A107B4U, 0x2U, 0x42A1034CU

#define IOMUXC_GPIO_EMC_B2_20_QTIMER3_TIMER3 0x42A10108U, 0xAU, 0, 0, 0x42A10350U
#define IOMUXC_GPIO_EMC_B2_20_ECAT_RX_ER_1 0x42A10108U, 0xCU, 0x42A104E0U, 0x1U, 0x42A10350U
#define IOMUXC_GPIO_EMC_B2_20_SEMC_CLKX01 0x42A10108U, 0x0U, 0, 0, 0x42A10350U
#define IOMUXC_GPIO_EMC_B2_20_NETC_PINMUX_ETH4_RX_ER 0x42A10108U, 0x1U, 0x42A10840U, 0x1U, 0x42A10350U
#define IOMUXC_GPIO_EMC_B2_20_LPUART5_RTS_B 0x42A10108U, 0x2U, 0, 0, 0x42A10350U
#define IOMUXC_GPIO_EMC_B2_20_NETC_ETH0_COL 0x42A10108U, 0x3U, 0, 0, 0x42A10350U
#define IOMUXC_GPIO_EMC_B2_20_NETC_EMDIO 0x42A10108U, 0x4U, 0x42A10798U, 0x3U, 0x42A10350U
#define IOMUXC_GPIO_EMC_B2_20_GPIO3_IO30 0x42A10108U, 0x5U, 0, 0, 0x42A10350U
#define IOMUXC_GPIO_EMC_B2_20_XBAR1_XBAR_INOUT37 0x42A10108U, 0x6U, 0x42A1098CU, 0x0U, 0x42A10350U
#define IOMUXC_GPIO_EMC_B2_20_LPI2C3_SDA 0x42A10108U, 0x8U, 0x42A105ECU, 0x1U, 0x42A10350U
#define IOMUXC_GPIO_EMC_B2_20_NETC_ETH3_SLV_MDIO 0x42A10108U, 0x9U, 0x42A107B8U, 0x2U, 0x42A10350U

#define IOMUXC_GPIO_AD_00_CAN2_TX 0x42A1010CU, 0x1U, 0, 0, 0x42A10354U
#define IOMUXC_GPIO_AD_00_MIC_CLK 0x42A1010CU, 0x2U, 0, 0, 0x42A10354U
#define IOMUXC_GPIO_AD_00_GPT2_CAPTURE1 0x42A1010CU, 0x3U, 0, 0, 0x42A10354U
#define IOMUXC_GPIO_AD_00_FLEXPWM1_PWMA00 0x42A1010CU, 0x4U, 0x42A104F4U, 0x2U, 0x42A10354U
#define IOMUXC_GPIO_AD_00_GPIO4_IO00 0x42A1010CU, 0x5U, 0, 0, 0x42A10354U
#define IOMUXC_GPIO_AD_00_SINC1_MOD_CLK0 0x42A1010CU, 0x6U, 0, 0, 0x42A10354U
#define IOMUXC_GPIO_AD_00_FLEXIO2_FLEXIO00 0x42A1010CU, 0x8U, 0, 0, 0x42A10354U
#define IOMUXC_GPIO_AD_00_QTIMER4_TIMER0 0x42A1010CU, 0x9U, 0x42A1087CU, 0x1U, 0x42A10354U

#define IOMUXC_GPIO_AD_01_CAN2_RX 0x42A10110U, 0x1U, 0x42A104A4U, 0x0U, 0x42A10358U
#define IOMUXC_GPIO_AD_01_MIC_BITSTREAM00 0x42A10110U, 0x2U, 0x42A106D0U, 0x0U, 0x42A10358U
#define IOMUXC_GPIO_AD_01_GPT2_CAPTURE2 0x42A10110U, 0x3U, 0, 0, 0x42A10358U
#define IOMUXC_GPIO_AD_01_FLEXPWM1_PWMB00 0x42A10110U, 0x4U, 0x42A10500U, 0x2U, 0x42A10358U
#define IOMUXC_GPIO_AD_01_GPIO4_IO01 0x42A10110U, 0x5U, 0, 0, 0x42A10358U
#define IOMUXC_GPIO_AD_01_SINC1_MOD_CLK1 0x42A10110U, 0x6U, 0, 0, 0x42A10358U
#define IOMUXC_GPIO_AD_01_FLEXIO2_FLEXIO01 0x42A10110U, 0x8U, 0, 0, 0x42A10358U
#define IOMUXC_GPIO_AD_01_QTIMER4_TIMER1 0x42A10110U, 0x9U, 0x42A10880U, 0x1U, 0x42A10358U

#define IOMUXC_GPIO_AD_02_MIC_BITSTREAM01 0x42A10114U, 0x2U, 0x42A106D4U, 0x0U, 0x42A1035CU
#define IOMUXC_GPIO_AD_02_GPT2_COMPARE1 0x42A10114U, 0x3U, 0, 0, 0x42A1035CU
#define IOMUXC_GPIO_AD_02_FLEXPWM1_PWMA01 0x42A10114U, 0x4U, 0x42A104F8U, 0x1U, 0x42A1035CU
#define IOMUXC_GPIO_AD_02_GPIO4_IO02 0x42A10114U, 0x5U, 0, 0, 0x42A1035CU
#define IOMUXC_GPIO_AD_02_SINC1_MOD_CLK2 0x42A10114U, 0x6U, 0, 0, 0x42A1035CU
#define IOMUXC_GPIO_AD_02_FLEXIO2_FLEXIO02 0x42A10114U, 0x8U, 0, 0, 0x42A1035CU
#define IOMUXC_GPIO_AD_02_QTIMER4_TIMER2 0x42A10114U, 0x9U, 0x42A10884U, 0x0U, 0x42A1035CU

#define IOMUXC_GPIO_AD_03_MIC_BITSTREAM02 0x42A10118U, 0x2U, 0x42A106D8U, 0x0U, 0x42A10360U
#define IOMUXC_GPIO_AD_03_GPT2_COMPARE2 0x42A10118U, 0x3U, 0, 0, 0x42A10360U
#define IOMUXC_GPIO_AD_03_FLEXPWM1_PWMB01 0x42A10118U, 0x4U, 0x42A10504U, 0x1U, 0x42A10360U
#define IOMUXC_GPIO_AD_03_GPIO4_IO03 0x42A10118U, 0x5U, 0, 0, 0x42A10360U
#define IOMUXC_GPIO_AD_03_SINC1_EMCLK00 0x42A10118U, 0x6U, 0x42A108E4U, 0x0U, 0x42A10360U
#define IOMUXC_GPIO_AD_03_FLEXIO2_FLEXIO03 0x42A10118U, 0x8U, 0, 0, 0x42A10360U
#define IOMUXC_GPIO_AD_03_QTIMER4_TIMER3 0x42A10118U, 0x9U, 0, 0, 0x42A10360U

#define IOMUXC_GPIO_AD_04_MIC_BITSTREAM03 0x42A1011CU, 0x2U, 0x42A106DCU, 0x0U, 0x42A10364U
#define IOMUXC_GPIO_AD_04_GPT2_COMPARE3 0x42A1011CU, 0x3U, 0, 0, 0x42A10364U
#define IOMUXC_GPIO_AD_04_FLEXPWM1_PWMB02 0x42A1011CU, 0x4U, 0x42A10508U, 0x1U, 0x42A10364U
#define IOMUXC_GPIO_AD_04_GPIO4_IO04 0x42A1011CU, 0x5U, 0, 0, 0x42A10364U
#define IOMUXC_GPIO_AD_04_SINC1_EMBIT00 0x42A1011CU, 0x6U, 0x42A108D4U, 0x0U, 0x42A10364U
#define IOMUXC_GPIO_AD_04_FLEXIO2_FLEXIO04 0x42A1011CU, 0x8U, 0, 0, 0x42A10364U
#define IOMUXC_GPIO_AD_04_QTIMER5_TIMER0 0x42A1011CU, 0x9U, 0x42A10888U, 0x1U, 0x42A10364U

#define IOMUXC_GPIO_AD_05_GPT2_CLK 0x42A10120U, 0x3U, 0, 0, 0x42A10368U
#define IOMUXC_GPIO_AD_05_FLEXPWM1_PWMA02 0x42A10120U, 0x4U, 0x42A104FCU, 0x1U, 0x42A10368U
#define IOMUXC_GPIO_AD_05_GPIO4_IO05 0x42A10120U, 0x5U, 0, 0, 0x42A10368U
#define IOMUXC_GPIO_AD_05_SINC1_EMCLK01 0x42A10120U, 0x6U, 0x42A108E8U, 0x0U, 0x42A10368U
#define IOMUXC_GPIO_AD_05_CCM_ENET_REF_CLK_25M 0x42A10120U, 0x7U, 0, 0, 0x42A10368U
#define IOMUXC_GPIO_AD_05_FLEXIO2_FLEXIO05 0x42A10120U, 0x8U, 0, 0, 0x42A10368U
#define IOMUXC_GPIO_AD_05_QTIMER5_TIMER1 0x42A10120U, 0x9U, 0x42A1088CU, 0x1U, 0x42A10368U

#define IOMUXC_GPIO_AD_06_USB_OTG2_OC 0x42A10124U, 0x0U, 0x42A10914U, 0x0U, 0x42A1036CU
#define IOMUXC_GPIO_AD_06_CAN3_TX 0x42A10124U, 0x1U, 0, 0, 0x42A1036CU
#define IOMUXC_GPIO_AD_06_FLEXPWM1_PWMX00 0x42A10124U, 0x4U, 0, 0, 0x42A1036CU
#define IOMUXC_GPIO_AD_06_GPIO4_IO06 0x42A10124U, 0x5U, 0, 0, 0x42A1036CU
#define IOMUXC_GPIO_AD_06_SINC1_EMBIT01 0x42A10124U, 0x6U, 0x42A108D8U, 0x0U, 0x42A1036CU
#define IOMUXC_GPIO_AD_06_FLEXIO2_FLEXIO06 0x42A10124U, 0x8U, 0, 0, 0x42A1036CU
#define IOMUXC_GPIO_AD_06_QTIMER5_TIMER2 0x42A10124U, 0x9U, 0x42A10890U, 0x0U, 0x42A1036CU

#define IOMUXC_GPIO_AD_07_USB_OTG2_PWR 0x42A10128U, 0x0U, 0, 0, 0x42A10370U
#define IOMUXC_GPIO_AD_07_CAN3_RX 0x42A10128U, 0x1U, 0x42A104A8U, 0x0U, 0x42A10370U
#define IOMUXC_GPIO_AD_07_FLEXPWM1_PWMX01 0x42A10128U, 0x4U, 0, 0, 0x42A10370U
#define IOMUXC_GPIO_AD_07_GPIO4_IO07 0x42A10128U, 0x5U, 0, 0, 0x42A10370U
#define IOMUXC_GPIO_AD_07_SINC1_EMCLK02 0x42A10128U, 0x6U, 0x42A108ECU, 0x0U, 0x42A10370U
#define IOMUXC_GPIO_AD_07_FLEXIO2_FLEXIO07 0x42A10128U, 0x8U, 0, 0, 0x42A10370U
#define IOMUXC_GPIO_AD_07_QTIMER5_TIMER3 0x42A10128U, 0x9U, 0, 0, 0x42A10370U

#define IOMUXC_GPIO_AD_08_USBPHY2_OTG_ID 0x42A1012CU, 0x0U, 0x42A10920U, 0x0U, 0x42A10374U
#define IOMUXC_GPIO_AD_08_LPI2C5_SCL 0x42A1012CU, 0x1U, 0x42A105F8U, 0x0U, 0x42A10374U
#define IOMUXC_GPIO_AD_08_FLEXPWM1_PWMX02 0x42A1012CU, 0x4U, 0, 0, 0x42A10374U
#define IOMUXC_GPIO_AD_08_GPIO4_IO08 0x42A1012CU, 0x5U, 0, 0, 0x42A10374U
#define IOMUXC_GPIO_AD_08_SINC1_EMBIT02 0x42A1012CU, 0x6U, 0x42A108DCU, 0x0U, 0x42A10374U
#define IOMUXC_GPIO_AD_08_FLEXIO2_FLEXIO08 0x42A1012CU, 0x8U, 0, 0, 0x42A10374U
#define IOMUXC_GPIO_AD_08_QTIMER6_TIMER0 0x42A1012CU, 0x9U, 0x42A10894U, 0x1U, 0x42A10374U

#define IOMUXC_GPIO_AD_09_USBPHY1_OTG_ID 0x42A10130U, 0x0U, 0x42A1091CU, 0x0U, 0x42A10378U
#define IOMUXC_GPIO_AD_09_LPI2C5_SDA 0x42A10130U, 0x1U, 0x42A105FCU, 0x0U, 0x42A10378U
#define IOMUXC_GPIO_AD_09_FLEXPWM1_PWMX03 0x42A10130U, 0x4U, 0, 0, 0x42A10378U
#define IOMUXC_GPIO_AD_09_GPIO4_IO09 0x42A10130U, 0x5U, 0, 0, 0x42A10378U
#define IOMUXC_GPIO_AD_09_SINC1_EMCLK03 0x42A10130U, 0x6U, 0x42A108F0U, 0x0U, 0x42A10378U
#define IOMUXC_GPIO_AD_09_FLEXIO2_FLEXIO09 0x42A10130U, 0x8U, 0, 0, 0x42A10378U
#define IOMUXC_GPIO_AD_09_QTIMER6_TIMER1 0x42A10130U, 0x9U, 0x42A10898U, 0x1U, 0x42A10378U

#define IOMUXC_GPIO_AD_10_USB_OTG1_PWR 0x42A10134U, 0x0U, 0, 0, 0x42A1037CU
#define IOMUXC_GPIO_AD_10_FLEXPWM2_PWMX00 0x42A10134U, 0x4U, 0, 0, 0x42A1037CU
#define IOMUXC_GPIO_AD_10_GPIO4_IO10 0x42A10134U, 0x5U, 0, 0, 0x42A1037CU
#define IOMUXC_GPIO_AD_10_SINC1_EMBIT03 0x42A10134U, 0x6U, 0x42A108E0U, 0x0U, 0x42A1037CU
#define IOMUXC_GPIO_AD_10_FLEXIO2_FLEXIO10 0x42A10134U, 0x8U, 0, 0, 0x42A1037CU
#define IOMUXC_GPIO_AD_10_QTIMER6_TIMER2 0x42A10134U, 0x9U, 0x42A1089CU, 0x0U, 0x42A1037CU

#define IOMUXC_GPIO_AD_11_USB_OTG1_OC 0x42A10138U, 0x0U, 0x42A10918U, 0x0U, 0x42A10380U
#define IOMUXC_GPIO_AD_11_FLEXPWM2_PWMX01 0x42A10138U, 0x4U, 0, 0, 0x42A10380U
#define IOMUXC_GPIO_AD_11_GPIO4_IO11 0x42A10138U, 0x5U, 0, 0, 0x42A10380U
#define IOMUXC_GPIO_AD_11_SINC_FILTER_GLUE1_BREAK 0x42A10138U, 0x6U, 0, 0, 0x42A10380U
#define IOMUXC_GPIO_AD_11_FLEXIO2_FLEXIO11 0x42A10138U, 0x8U, 0, 0, 0x42A10380U
#define IOMUXC_GPIO_AD_11_QTIMER6_TIMER3 0x42A10138U, 0x9U, 0, 0, 0x42A10380U

#define IOMUXC_GPIO_AD_12_SPDIF_LOCK 0x42A1013CU, 0x0U, 0, 0, 0x42A10384U
#define IOMUXC_GPIO_AD_12_LPI2C5_SCLS 0x42A1013CU, 0x1U, 0, 0, 0x42A10384U
#define IOMUXC_GPIO_AD_12_GPT1_CAPTURE1 0x42A1013CU, 0x2U, 0, 0, 0x42A10384U
#define IOMUXC_GPIO_AD_12_KPP_ROW07 0x42A1013CU, 0x3U, 0x42A105E4U, 0x1U, 0x42A10384U
#define IOMUXC_GPIO_AD_12_FLEXPWM2_PWMX02 0x42A1013CU, 0x4U, 0, 0, 0x42A10384U
#define IOMUXC_GPIO_AD_12_GPIO4_IO12 0x42A1013CU, 0x5U, 0, 0, 0x42A10384U
#define IOMUXC_GPIO_AD_12_XBAR1_XBAR_INOUT18 0x42A1013CU, 0x6U, 0x42A10940U, 0x0U, 0x42A10384U
#define IOMUXC_GPIO_AD_12_EWM_EWM_OUT_B 0x42A1013CU, 0x7U, 0, 0, 0x42A10384U
#define IOMUXC_GPIO_AD_12_FLEXIO2_FLEXIO12 0x42A1013CU, 0x8U, 0, 0, 0x42A10384U

#define IOMUXC_GPIO_AD_13_SPDIF_SR_CLK 0x42A10140U, 0x0U, 0, 0, 0x42A10388U
#define IOMUXC_GPIO_AD_13_LPI2C5_SDAS 0x42A10140U, 0x1U, 0, 0, 0x42A10388U
#define IOMUXC_GPIO_AD_13_GPT1_CAPTURE2 0x42A10140U, 0x2U, 0, 0, 0x42A10388U
#define IOMUXC_GPIO_AD_13_KPP_COL07 0x42A10140U, 0x3U, 0x42A105C4U, 0x1U, 0x42A10388U
#define IOMUXC_GPIO_AD_13_FLEXPWM2_PWMX03 0x42A10140U, 0x4U, 0, 0, 0x42A10388U
#define IOMUXC_GPIO_AD_13_GPIO4_IO13 0x42A10140U, 0x5U, 0, 0, 0x42A10388U
#define IOMUXC_GPIO_AD_13_LPUART3_TX 0x42A10140U, 0x6U, 0x42A10684U, 0x1U, 0x42A10388U
#define IOMUXC_GPIO_AD_13_USDHC2_CD_B 0x42A10140U, 0x7U, 0x42A1092CU, 0x1U, 0x42A10388U
#define IOMUXC_GPIO_AD_13_FLEXIO2_FLEXIO13 0x42A10140U, 0x8U, 0, 0, 0x42A10388U

#define IOMUXC_GPIO_AD_14_SPDIF_EXT_CLK 0x42A10144U, 0x0U, 0, 0, 0x42A1038CU
#define IOMUXC_GPIO_AD_14_LPI2C5_HREQ 0x42A10144U, 0x1U, 0, 0, 0x42A1038CU
#define IOMUXC_GPIO_AD_14_GPT1_COMPARE1 0x42A10144U, 0x2U, 0, 0, 0x42A1038CU
#define IOMUXC_GPIO_AD_14_KPP_ROW06 0x42A10144U, 0x3U, 0x42A105E0U, 0x1U, 0x42A1038CU
#define IOMUXC_GPIO_AD_14_FLEXPWM3_PWMX00 0x42A10144U, 0x4U, 0, 0, 0x42A1038CU
#define IOMUXC_GPIO_AD_14_GPIO4_IO14 0x42A10144U, 0x5U, 0, 0, 0x42A1038CU
#define IOMUXC_GPIO_AD_14_LPUART3_RX 0x42A10144U, 0x6U, 0x42A10680U, 0x1U, 0x42A1038CU
#define IOMUXC_GPIO_AD_14_USDHC2_WP 0x42A10144U, 0x7U, 0x42A10930U, 0x1U, 0x42A1038CU
#define IOMUXC_GPIO_AD_14_FLEXIO2_FLEXIO14 0x42A10144U, 0x8U, 0, 0, 0x42A1038CU

#define IOMUXC_GPIO_AD_15_ECAT_CLK_ECAT_CLK25 0x42A10148U, 0xCU, 0, 0, 0x42A10390U
#define IOMUXC_GPIO_AD_15_SPDIF_IN 0x42A10148U, 0x0U, 0x42A10908U, 0x1U, 0x42A10390U
#define IOMUXC_GPIO_AD_15_LPUART10_TX 0x42A10148U, 0x1U, 0x42A10670U, 0x0U, 0x42A10390U
#define IOMUXC_GPIO_AD_15_GPT1_COMPARE2 0x42A10148U, 0x2U, 0, 0, 0x42A10390U
#define IOMUXC_GPIO_AD_15_KPP_COL06 0x42A10148U, 0x3U, 0x42A105C0U, 0x1U, 0x42A10390U
#define IOMUXC_GPIO_AD_15_FLEXPWM3_PWMX01 0x42A10148U, 0x4U, 0, 0, 0x42A10390U
#define IOMUXC_GPIO_AD_15_GPIO4_IO15 0x42A10148U, 0x5U, 0, 0, 0x42A10390U
#define IOMUXC_GPIO_AD_15_LPUART3_CTS_B 0x42A10148U, 0x6U, 0x42A1067CU, 0x1U, 0x42A10390U
#define IOMUXC_GPIO_AD_15_LPSPI3_PCS1 0x42A10148U, 0x7U, 0x42A1060CU, 0x1U, 0x42A10390U
#define IOMUXC_GPIO_AD_15_FLEXIO2_FLEXIO15 0x42A10148U, 0x8U, 0, 0, 0x42A10390U
#define IOMUXC_GPIO_AD_15_CAN1_TX 0x42A10148U, 0x9U, 0, 0, 0x42A10390U

#define IOMUXC_GPIO_AD_16_SPDIF_OUT 0x42A1014CU, 0x0U, 0, 0, 0x42A10394U
#define IOMUXC_GPIO_AD_16_LPUART10_RX 0x42A1014CU, 0x1U, 0x42A1066CU, 0x0U, 0x42A10394U
#define IOMUXC_GPIO_AD_16_GPT1_COMPARE3 0x42A1014CU, 0x2U, 0, 0, 0x42A10394U
#define IOMUXC_GPIO_AD_16_KPP_ROW05 0x42A1014CU, 0x3U, 0x42A105DCU, 0x1U, 0x42A10394U
#define IOMUXC_GPIO_AD_16_FLEXPWM3_PWMX02 0x42A1014CU, 0x4U, 0, 0, 0x42A10394U
#define IOMUXC_GPIO_AD_16_GPIO4_IO16 0x42A1014CU, 0x5U, 0, 0, 0x42A10394U
#define IOMUXC_GPIO_AD_16_LPUART3_RTS_B 0x42A1014CU, 0x6U, 0, 0, 0x42A10394U
#define IOMUXC_GPIO_AD_16_LPSPI3_SCK 0x42A1014CU, 0x7U, 0x42A10618U, 0x1U, 0x42A10394U
#define IOMUXC_GPIO_AD_16_FLEXIO2_FLEXIO16 0x42A1014CU, 0x8U, 0, 0, 0x42A10394U
#define IOMUXC_GPIO_AD_16_CAN1_RX 0x42A1014CU, 0x9U, 0x42A104A0U, 0x0U, 0x42A10394U
#define IOMUXC_GPIO_AD_16_ECAT_LINK_0 0x42A1014CU, 0xCU, 0, 0, 0x42A10394U

#define IOMUXC_GPIO_AD_17_SAI4_MCLK 0x42A10150U, 0x0U, 0x42A108B0U, 0x0U, 0x42A10398U
#define IOMUXC_GPIO_AD_17_ACMP1_CMPO 0x42A10150U, 0x1U, 0, 0, 0x42A10398U
#define IOMUXC_GPIO_AD_17_GPT1_CLK 0x42A10150U, 0x2U, 0, 0, 0x42A10398U
#define IOMUXC_GPIO_AD_17_KPP_COL05 0x42A10150U, 0x3U, 0x42A105BCU, 0x1U, 0x42A10398U
#define IOMUXC_GPIO_AD_17_FLEXPWM3_PWMX03 0x42A10150U, 0x4U, 0, 0, 0x42A10398U
#define IOMUXC_GPIO_AD_17_GPIO4_IO17 0x42A10150U, 0x5U, 0, 0, 0x42A10398U
#define IOMUXC_GPIO_AD_17_I3C2_PUR 0x42A10150U, 0x6U, 0, 0, 0x42A10398U
#define IOMUXC_GPIO_AD_17_LPSPI3_PCS0 0x42A10150U, 0x7U, 0x42A10608U, 0x1U, 0x42A10398U
#define IOMUXC_GPIO_AD_17_FLEXIO2_FLEXIO17 0x42A10150U, 0x8U, 0, 0, 0x42A10398U
#define IOMUXC_GPIO_AD_17_LPI2C3_HREQ 0x42A10150U, 0x9U, 0, 0, 0x42A10398U
#define IOMUXC_GPIO_AD_17_ECAT_LINK_1 0x42A10150U, 0xCU, 0, 0, 0x42A10398U

#define IOMUXC_GPIO_AD_18_ECAT_PROM_CLK 0x42A10154U, 0xCU, 0, 0, 0x42A1039CU
#define IOMUXC_GPIO_AD_18_SAI4_RX_SYNC 0x42A10154U, 0x0U, 0x42A108C0U, 0x0U, 0x42A1039CU
#define IOMUXC_GPIO_AD_18_ACMP2_CMPO 0x42A10154U, 0x1U, 0, 0, 0x42A1039CU
#define IOMUXC_GPIO_AD_18_LPUART5_RI_B 0x42A10154U, 0x2U, 0x42A10698U, 0x0U, 0x42A1039CU
#define IOMUXC_GPIO_AD_18_KPP_ROW04 0x42A10154U, 0x3U, 0x42A105D8U, 0x1U, 0x42A1039CU
#define IOMUXC_GPIO_AD_18_FLEXPWM4_PWMX00 0x42A10154U, 0x4U, 0, 0, 0x42A1039CU
#define IOMUXC_GPIO_AD_18_GPIO4_IO18 0x42A10154U, 0x5U, 0, 0, 0x42A1039CU
#define IOMUXC_GPIO_AD_18_I3C2_SCL 0x42A10154U, 0x6U, 0x42A105A0U, 0x0U, 0x42A1039CU
#define IOMUXC_GPIO_AD_18_LPSPI3_SDO 0x42A10154U, 0x7U, 0x42A10620U, 0x1U, 0x42A1039CU
#define IOMUXC_GPIO_AD_18_FLEXIO2_FLEXIO18 0x42A10154U, 0x8U, 0, 0, 0x42A1039CU
#define IOMUXC_GPIO_AD_18_LPI2C3_SCL 0x42A10154U, 0x9U, 0x42A105E8U, 0x2U, 0x42A1039CU

#define IOMUXC_GPIO_AD_19_SAI4_RX_BCLK 0x42A10158U, 0x0U, 0x42A108B4U, 0x0U, 0x42A103A0U
#define IOMUXC_GPIO_AD_19_ACMP3_CMPO 0x42A10158U, 0x1U, 0, 0, 0x42A103A0U
#define IOMUXC_GPIO_AD_19_XBAR1_XBAR_INOUT19 0x42A10158U, 0x2U, 0x42A10944U, 0x0U, 0x42A103A0U
#define IOMUXC_GPIO_AD_19_KPP_COL04 0x42A10158U, 0x3U, 0x42A105B8U, 0x1U, 0x42A103A0U
#define IOMUXC_GPIO_AD_19_FLEXPWM4_PWMX01 0x42A10158U, 0x4U, 0, 0, 0x42A103A0U
#define IOMUXC_GPIO_AD_19_GPIO4_IO19 0x42A10158U, 0x5U, 0, 0, 0x42A103A0U
#define IOMUXC_GPIO_AD_19_I3C2_SDA 0x42A10158U, 0x6U, 0x42A105A4U, 0x0U, 0x42A103A0U
#define IOMUXC_GPIO_AD_19_LPSPI3_SDI 0x42A10158U, 0x7U, 0x42A1061CU, 0x1U, 0x42A103A0U
#define IOMUXC_GPIO_AD_19_FLEXIO2_FLEXIO19 0x42A10158U, 0x8U, 0, 0, 0x42A103A0U
#define IOMUXC_GPIO_AD_19_LPI2C3_SDA 0x42A10158U, 0x9U, 0x42A105ECU, 0x2U, 0x42A103A0U
#define IOMUXC_GPIO_AD_19_ECAT_PROM_DATA 0x42A10158U, 0xCU, 0x42A104F0U, 0x0U, 0x42A103A0U

#define IOMUXC_GPIO_AD_20_SAI4_RX_DATA00 0x42A1015CU, 0x0U, 0x42A108B8U, 0x0U, 0x42A103A4U
#define IOMUXC_GPIO_AD_20_ACMP4_CMPO 0x42A1015CU, 0x1U, 0, 0, 0x42A103A4U
#define IOMUXC_GPIO_AD_20_LPIT2_TRIGGER00 0x42A1015CU, 0x2U, 0, 0, 0x42A103A4U
#define IOMUXC_GPIO_AD_20_SINC1_EMCLK00 0x42A1015CU, 0x3U, 0x42A108E4U, 0x1U, 0x42A103A4U
#define IOMUXC_GPIO_AD_20_FLEXPWM4_PWMX02 0x42A1015CU, 0x4U, 0, 0, 0x42A103A4U
#define IOMUXC_GPIO_AD_20_GPIO4_IO20 0x42A1015CU, 0x5U, 0, 0, 0x42A103A4U
#define IOMUXC_GPIO_AD_20_NETC_TMR_TRIG1 0x42A1015CU, 0x6U, 0x42A107CCU, 0x0U, 0x42A103A4U
#define IOMUXC_GPIO_AD_20_NETC_1588_CLK 0x42A1015CU, 0x7U, 0x42A107D4U, 0x0U, 0x42A103A4U
#define IOMUXC_GPIO_AD_20_FLEXIO2_FLEXIO20 0x42A1015CU, 0x8U, 0, 0, 0x42A103A4U

#define IOMUXC_GPIO_AD_21_SAI4_TX_DATA00 0x42A10160U, 0x0U, 0, 0, 0x42A103A8U
#define IOMUXC_GPIO_AD_21_LPIT2_TRIGGER01 0x42A10160U, 0x2U, 0, 0, 0x42A103A8U
#define IOMUXC_GPIO_AD_21_SINC1_EMBIT00 0x42A10160U, 0x3U, 0x42A108D4U, 0x1U, 0x42A103A8U
#define IOMUXC_GPIO_AD_21_FLEXPWM4_PWMX03 0x42A10160U, 0x4U, 0, 0, 0x42A103A8U
#define IOMUXC_GPIO_AD_21_GPIO4_IO21 0x42A10160U, 0x5U, 0, 0, 0x42A103A8U
#define IOMUXC_GPIO_AD_21_NETC_TMR_TRIG2 0x42A10160U, 0x6U, 0x42A107D0U, 0x0U, 0x42A103A8U
#define IOMUXC_GPIO_AD_21_NETC_TMR_GCLK 0x42A10160U, 0x7U, 0, 0, 0x42A103A8U
#define IOMUXC_GPIO_AD_21_FLEXIO2_FLEXIO21 0x42A10160U, 0x8U, 0, 0, 0x42A103A8U
#define IOMUXC_GPIO_AD_21_ECAT_LED_RUN 0x42A10160U, 0xCU, 0, 0, 0x42A103A8U

#define IOMUXC_GPIO_AD_22_ECAT_LED_ERR 0x42A10164U, 0xCU, 0, 0, 0x42A103ACU
#define IOMUXC_GPIO_AD_22_SAI4_TX_BCLK 0x42A10164U, 0x0U, 0x42A108C4U, 0x0U, 0x42A103ACU
#define IOMUXC_GPIO_AD_22_LPIT2_TRIGGER02 0x42A10164U, 0x2U, 0, 0, 0x42A103ACU
#define IOMUXC_GPIO_AD_22_SINC1_EMCLK01 0x42A10164U, 0x3U, 0x42A108E8U, 0x1U, 0x42A103ACU
#define IOMUXC_GPIO_AD_22_GPIO4_IO22 0x42A10164U, 0x5U, 0, 0, 0x42A103ACU
#define IOMUXC_GPIO_AD_22_NETC_TMR_ALARM1 0x42A10164U, 0x7U, 0, 0, 0x42A103ACU
#define IOMUXC_GPIO_AD_22_FLEXIO2_FLEXIO22 0x42A10164U, 0x8U, 0, 0, 0x42A103ACU

#define IOMUXC_GPIO_AD_23_SAI4_TX_SYNC 0x42A10168U, 0x0U, 0x42A108C8U, 0x0U, 0x42A103B0U
#define IOMUXC_GPIO_AD_23_LPIT2_TRIGGER03 0x42A10168U, 0x2U, 0, 0, 0x42A103B0U
#define IOMUXC_GPIO_AD_23_SINC1_EMBIT01 0x42A10168U, 0x3U, 0x42A108D8U, 0x1U, 0x42A103B0U
#define IOMUXC_GPIO_AD_23_GPIO4_IO23 0x42A10168U, 0x5U, 0, 0, 0x42A103B0U
#define IOMUXC_GPIO_AD_23_NETC_TMR_ALARM2 0x42A10168U, 0x7U, 0, 0, 0x42A103B0U
#define IOMUXC_GPIO_AD_23_FLEXIO2_FLEXIO23 0x42A10168U, 0x8U, 0, 0, 0x42A103B0U
#define IOMUXC_GPIO_AD_23_ECAT_LED_STATE_RUN 0x42A10168U, 0xCU, 0, 0, 0x42A103B0U

#define IOMUXC_GPIO_AD_24_LPUART6_TX 0x42A1016CU, 0x0U, 0x42A106B8U, 0x1U, 0x42A103B4U
#define IOMUXC_GPIO_AD_24_LPI2C4_SCL 0x42A1016CU, 0x1U, 0x42A105F0U, 0x0U, 0x42A103B4U
#define IOMUXC_GPIO_AD_24_SINC2_MOD_CLK1 0x42A1016CU, 0x3U, 0, 0, 0x42A103B4U
#define IOMUXC_GPIO_AD_24_FLEXPWM2_PWMA00 0x42A1016CU, 0x4U, 0x42A1050CU, 0x1U, 0x42A103B4U
#define IOMUXC_GPIO_AD_24_GPIO4_IO24 0x42A1016CU, 0x5U, 0, 0, 0x42A103B4U
#define IOMUXC_GPIO_AD_24_NETC_TMR_TRIG1 0x42A1016CU, 0x7U, 0x42A107CCU, 0x1U, 0x42A103B4U
#define IOMUXC_GPIO_AD_24_FLEXIO2_FLEXIO24 0x42A1016CU, 0x8U, 0, 0, 0x42A103B4U
#define IOMUXC_GPIO_AD_24_ECAT_LINK_ACT00 0x42A1016CU, 0xCU, 0, 0, 0x42A103B4U

#define IOMUXC_GPIO_AD_25_ECAT_LINK_ACT01 0x42A10170U, 0xCU, 0, 0, 0x42A103B8U
#define IOMUXC_GPIO_AD_25_LPUART6_RX 0x42A10170U, 0x0U, 0x42A106B4U, 0x1U, 0x42A103B8U
#define IOMUXC_GPIO_AD_25_LPI2C4_SDA 0x42A10170U, 0x1U, 0x42A105F4U, 0x0U, 0x42A103B8U
#define IOMUXC_GPIO_AD_25_LPSPI5_PCS3 0x42A10170U, 0x2U, 0x42A10640U, 0x1U, 0x42A103B8U
#define IOMUXC_GPIO_AD_25_SINC2_MOD_CLK2 0x42A10170U, 0x3U, 0, 0, 0x42A103B8U
#define IOMUXC_GPIO_AD_25_FLEXPWM2_PWMB00 0x42A10170U, 0x4U, 0x42A10518U, 0x1U, 0x42A103B8U
#define IOMUXC_GPIO_AD_25_GPIO4_IO25 0x42A10170U, 0x5U, 0, 0, 0x42A103B8U
#define IOMUXC_GPIO_AD_25_NETC_TMR_TRIG2 0x42A10170U, 0x7U, 0x42A107D0U, 0x1U, 0x42A103B8U
#define IOMUXC_GPIO_AD_25_FLEXIO2_FLEXIO25 0x42A10170U, 0x8U, 0, 0, 0x42A103B8U

#define IOMUXC_GPIO_AD_26_LPUART6_CTS_B 0x42A10174U, 0x0U, 0x42A106A4U, 0x1U, 0x42A103BCU
#define IOMUXC_GPIO_AD_26_LPUART5_TX 0x42A10174U, 0x1U, 0x42A106A0U, 0x3U, 0x42A103BCU
#define IOMUXC_GPIO_AD_26_LPSPI5_PCS2 0x42A10174U, 0x2U, 0x42A1063CU, 0x1U, 0x42A103BCU
#define IOMUXC_GPIO_AD_26_SINC2_EMCLK00 0x42A10174U, 0x3U, 0x42A108FCU, 0x0U, 0x42A103BCU
#define IOMUXC_GPIO_AD_26_FLEXPWM2_PWMA01 0x42A10174U, 0x4U, 0x42A10510U, 0x1U, 0x42A103BCU
#define IOMUXC_GPIO_AD_26_GPIO4_IO26 0x42A10174U, 0x5U, 0, 0, 0x42A103BCU
#define IOMUXC_GPIO_AD_26_KPP_ROW00 0x42A10174U, 0x6U, 0x42A105C8U, 0x1U, 0x42A103BCU
#define IOMUXC_GPIO_AD_26_NETC_TMR_PP1 0x42A10174U, 0x7U, 0, 0, 0x42A103BCU
#define IOMUXC_GPIO_AD_26_FLEXIO2_FLEXIO26 0x42A10174U, 0x8U, 0, 0, 0x42A103BCU
#define IOMUXC_GPIO_AD_26_USDHC2_CD_B 0x42A10174U, 0x9U, 0x42A1092CU, 0x2U, 0x42A103BCU
#define IOMUXC_GPIO_AD_26_MIC_BITSTREAM02 0x42A10174U, 0xCU, 0x42A106D8U, 0x1U, 0x42A103BCU

#define IOMUXC_GPIO_AD_27_LPUART6_RTS_B 0x42A10178U, 0x0U, 0, 0, 0x42A103C0U
#define IOMUXC_GPIO_AD_27_LPUART5_RX 0x42A10178U, 0x1U, 0x42A1069CU, 0x3U, 0x42A103C0U
#define IOMUXC_GPIO_AD_27_LPSPI5_PCS1 0x42A10178U, 0x2U, 0x42A10638U, 0x2U, 0x42A103C0U
#define IOMUXC_GPIO_AD_27_SINC2_EMBIT00 0x42A10178U, 0x3U, 0, 0, 0x42A103C0U
#define IOMUXC_GPIO_AD_27_FLEXPWM2_PWMB01 0x42A10178U, 0x4U, 0x42A1051CU, 0x1U, 0x42A103C0U
#define IOMUXC_GPIO_AD_27_GPIO4_IO27 0x42A10178U, 0x5U, 0, 0, 0x42A103C0U
#define IOMUXC_GPIO_AD_27_KPP_COL00 0x42A10178U, 0x6U, 0x42A105A8U, 0x1U, 0x42A103C0U
#define IOMUXC_GPIO_AD_27_NETC_TMR_PP2 0x42A10178U, 0x7U, 0, 0, 0x42A103C0U
#define IOMUXC_GPIO_AD_27_FLEXIO2_FLEXIO27 0x42A10178U, 0x8U, 0, 0, 0x42A103C0U
#define IOMUXC_GPIO_AD_27_USDHC2_WP 0x42A10178U, 0x9U, 0x42A10930U, 0x2U, 0x42A103C0U
#define IOMUXC_GPIO_AD_27_MIC_CLK 0x42A10178U, 0xCU, 0, 0, 0x42A103C0U

#define IOMUXC_GPIO_AD_28_MIC_BITSTREAM00 0x42A1017CU, 0xCU, 0x42A106D0U, 0x1U, 0x42A103C4U
#define IOMUXC_GPIO_AD_28_LPSPI5_SCK 0x42A1017CU, 0x0U, 0x42A10644U, 0x2U, 0x42A103C4U
#define IOMUXC_GPIO_AD_28_I3C1_PUR 0x42A1017CU, 0x2U, 0, 0, 0x42A103C4U
#define IOMUXC_GPIO_AD_28_SINC2_EMCLK01 0x42A1017CU, 0x3U, 0, 0, 0x42A103C4U
#define IOMUXC_GPIO_AD_28_FLEXPWM2_PWMB02 0x42A1017CU, 0x4U, 0x42A10520U, 0x1U, 0x42A103C4U
#define IOMUXC_GPIO_AD_28_GPIO4_IO28 0x42A1017CU, 0x5U, 0, 0, 0x42A103C4U
#define IOMUXC_GPIO_AD_28_KPP_ROW03 0x42A1017CU, 0x6U, 0x42A105D4U, 0x1U, 0x42A103C4U
#define IOMUXC_GPIO_AD_28_NETC_TMR_PP3 0x42A1017CU, 0x7U, 0, 0, 0x42A103C4U
#define IOMUXC_GPIO_AD_28_FLEXIO2_FLEXIO28 0x42A1017CU, 0x8U, 0, 0, 0x42A103C4U
#define IOMUXC_GPIO_AD_28_USDHC2_RESET_B 0x42A1017CU, 0x9U, 0, 0, 0x42A103C4U

#define IOMUXC_GPIO_AD_29_LPSPI5_PCS0 0x42A10180U, 0x0U, 0x42A10634U, 0x2U, 0x42A103C8U
#define IOMUXC_GPIO_AD_29_USDHC2_CD_B 0x42A10180U, 0x2U, 0x42A1092CU, 0x3U, 0x42A103C8U
#define IOMUXC_GPIO_AD_29_SINC2_EMBIT01 0x42A10180U, 0x3U, 0, 0, 0x42A103C8U
#define IOMUXC_GPIO_AD_29_FLEXPWM2_PWMA02 0x42A10180U, 0x4U, 0x42A10514U, 0x1U, 0x42A103C8U
#define IOMUXC_GPIO_AD_29_GPIO4_IO29 0x42A10180U, 0x5U, 0, 0, 0x42A103C8U
#define IOMUXC_GPIO_AD_29_KPP_COL03 0x42A10180U, 0x6U, 0x42A105B4U, 0x1U, 0x42A103C8U
#define IOMUXC_GPIO_AD_29_EWM_EWM_OUT_B 0x42A10180U, 0x7U, 0, 0, 0x42A103C8U
#define IOMUXC_GPIO_AD_29_FLEXIO2_FLEXIO29 0x42A10180U, 0x8U, 0, 0, 0x42A103C8U
#define IOMUXC_GPIO_AD_29_USDHC2_VSELECT 0x42A10180U, 0x9U, 0, 0, 0x42A103C8U
#define IOMUXC_GPIO_AD_29_MIC_BITSTREAM01 0x42A10180U, 0xCU, 0x42A106D4U, 0x1U, 0x42A103C8U

#define IOMUXC_GPIO_AD_30_LPSPI5_SDO 0x42A10184U, 0x0U, 0x42A1064CU, 0x2U, 0x42A103CCU
#define IOMUXC_GPIO_AD_30_USB_OTG2_OC 0x42A10184U, 0x1U, 0x42A10914U, 0x1U, 0x42A103CCU
#define IOMUXC_GPIO_AD_30_CAN2_TX 0x42A10184U, 0x2U, 0, 0, 0x42A103CCU
#define IOMUXC_GPIO_AD_30_SINC2_EMCLK02 0x42A10184U, 0x3U, 0x42A10900U, 0x0U, 0x42A103CCU
#define IOMUXC_GPIO_AD_30_LPUART8_TX 0x42A10184U, 0x4U, 0x42A106C4U, 0x0U, 0x42A103CCU
#define IOMUXC_GPIO_AD_30_GPIO4_IO30 0x42A10184U, 0x5U, 0, 0, 0x42A103CCU
#define IOMUXC_GPIO_AD_30_KPP_ROW02 0x42A10184U, 0x6U, 0x42A105D0U, 0x1U, 0x42A103CCU
#define IOMUXC_GPIO_AD_30_NETC_EMDC 0x42A10184U, 0x7U, 0, 0, 0x42A103CCU
#define IOMUXC_GPIO_AD_30_FLEXIO2_FLEXIO30 0x42A10184U, 0x8U, 0, 0, 0x42A103CCU
#define IOMUXC_GPIO_AD_30_XBAR1_XBAR_INOUT24 0x42A10184U, 0x9U, 0x42A10958U, 0x1U, 0x42A103CCU
#define IOMUXC_GPIO_AD_30_ECAT_MCLK 0x42A10184U, 0xCU, 0, 0, 0x42A103CCU

#define IOMUXC_GPIO_AD_31_LPSPI5_SDI 0x42A10188U, 0x0U, 0x42A10648U, 0x2U, 0x42A103D0U
#define IOMUXC_GPIO_AD_31_USB_OTG2_PWR 0x42A10188U, 0x1U, 0, 0, 0x42A103D0U
#define IOMUXC_GPIO_AD_31_CAN2_RX 0x42A10188U, 0x2U, 0x42A104A4U, 0x1U, 0x42A103D0U
#define IOMUXC_GPIO_AD_31_SINC2_EMBIT02 0x42A10188U, 0x3U, 0x42A108F4U, 0x0U, 0x42A103D0U
#define IOMUXC_GPIO_AD_31_LPUART8_RX 0x42A10188U, 0x4U, 0x42A106C0U, 0x0U, 0x42A103D0U
#define IOMUXC_GPIO_AD_31_GPIO4_IO31 0x42A10188U, 0x5U, 0, 0, 0x42A103D0U
#define IOMUXC_GPIO_AD_31_KPP_COL02 0x42A10188U, 0x6U, 0x42A105B0U, 0x1U, 0x42A103D0U
#define IOMUXC_GPIO_AD_31_NETC_EMDIO 0x42A10188U, 0x7U, 0x42A10798U, 0x4U, 0x42A103D0U
#define IOMUXC_GPIO_AD_31_FLEXIO2_FLEXIO31 0x42A10188U, 0x8U, 0, 0, 0x42A103D0U
#define IOMUXC_GPIO_AD_31_XBAR1_XBAR_INOUT25 0x42A10188U, 0x9U, 0x42A1095CU, 0x1U, 0x42A103D0U
#define IOMUXC_GPIO_AD_31_ECAT_MDIO 0x42A10188U, 0xCU, 0x42A104ECU, 0x0U, 0x42A103D0U

#define IOMUXC_GPIO_AD_32_MIC_BITSTREAM03 0x42A1018CU, 0xCU, 0x42A106DCU, 0x1U, 0x42A103D4U
#define IOMUXC_GPIO_AD_32_LPI2C5_SCL 0x42A1018CU, 0x0U, 0x42A105F8U, 0x1U, 0x42A103D4U
#define IOMUXC_GPIO_AD_32_USBPHY2_OTG_ID 0x42A1018CU, 0x1U, 0x42A10920U, 0x1U, 0x42A103D4U
#define IOMUXC_GPIO_AD_32_GPC_PMIC_RDY 0x42A1018CU, 0x2U, 0, 0, 0x42A103D4U
#define IOMUXC_GPIO_AD_32_SINC2_EMCLK03 0x42A1018CU, 0x3U, 0x42A10904U, 0x0U, 0x42A103D4U
#define IOMUXC_GPIO_AD_32_USDHC1_CD_B 0x42A1018CU, 0x4U, 0x42A10924U, 0x0U, 0x42A103D4U
#define IOMUXC_GPIO_AD_32_GPIO5_IO00 0x42A1018CU, 0x5U, 0, 0, 0x42A103D4U
#define IOMUXC_GPIO_AD_32_KPP_ROW01 0x42A1018CU, 0x6U, 0x42A105CCU, 0x1U, 0x42A103D4U
#define IOMUXC_GPIO_AD_32_NETC_TMR_TRIG1 0x42A1018CU, 0x7U, 0x42A107CCU, 0x2U, 0x42A103D4U
#define IOMUXC_GPIO_AD_32_LPUART10_TX 0x42A1018CU, 0x8U, 0x42A10670U, 0x1U, 0x42A103D4U

#define IOMUXC_GPIO_AD_33_LPI2C5_SDA 0x42A10190U, 0x0U, 0x42A105FCU, 0x1U, 0x42A103D8U
#define IOMUXC_GPIO_AD_33_USBPHY1_OTG_ID 0x42A10190U, 0x1U, 0x42A1091CU, 0x1U, 0x42A103D8U
#define IOMUXC_GPIO_AD_33_XBAR1_XBAR_INOUT17 0x42A10190U, 0x2U, 0x42A1093CU, 0x0U, 0x42A103D8U
#define IOMUXC_GPIO_AD_33_SINC2_EMBIT03 0x42A10190U, 0x3U, 0x42A108F8U, 0x0U, 0x42A103D8U
#define IOMUXC_GPIO_AD_33_USDHC1_WP 0x42A10190U, 0x4U, 0x42A10928U, 0x0U, 0x42A103D8U
#define IOMUXC_GPIO_AD_33_GPIO5_IO01 0x42A10190U, 0x5U, 0, 0, 0x42A103D8U
#define IOMUXC_GPIO_AD_33_KPP_COL01 0x42A10190U, 0x6U, 0x42A105ACU, 0x1U, 0x42A103D8U
#define IOMUXC_GPIO_AD_33_NETC_TMR_TRIG2 0x42A10190U, 0x7U, 0x42A107D0U, 0x2U, 0x42A103D8U
#define IOMUXC_GPIO_AD_33_LPUART10_RX 0x42A10190U, 0x8U, 0x42A1066CU, 0x1U, 0x42A103D8U

#define IOMUXC_GPIO_AD_34_I3C2_SCL 0x42A10194U, 0x0U, 0x42A105A0U, 0x1U, 0x42A103DCU
#define IOMUXC_GPIO_AD_34_USB_OTG1_PWR 0x42A10194U, 0x1U, 0, 0, 0x42A103DCU
#define IOMUXC_GPIO_AD_34_XBAR1_XBAR_INOUT18 0x42A10194U, 0x2U, 0x42A10940U, 0x1U, 0x42A103DCU
#define IOMUXC_GPIO_AD_34_SINC_FILTER_GLUE2_BREAK 0x42A10194U, 0x3U, 0, 0, 0x42A103DCU
#define IOMUXC_GPIO_AD_34_USDHC1_VSELECT 0x42A10194U, 0x4U, 0, 0, 0x42A103DCU
#define IOMUXC_GPIO_AD_34_GPIO5_IO02 0x42A10194U, 0x5U, 0, 0, 0x42A103DCU
#define IOMUXC_GPIO_AD_34_NETC_TMR_ALARM1 0x42A10194U, 0x7U, 0, 0, 0x42A103DCU
#define IOMUXC_GPIO_AD_34_LPUART10_CTS_B 0x42A10194U, 0x8U, 0, 0, 0x42A103DCU

#define IOMUXC_GPIO_AD_35_I3C2_SDA 0x42A10198U, 0x0U, 0x42A105A4U, 0x1U, 0x42A103E0U
#define IOMUXC_GPIO_AD_35_USB_OTG1_OC 0x42A10198U, 0x1U, 0x42A10918U, 0x1U, 0x42A103E0U
#define IOMUXC_GPIO_AD_35_XBAR1_XBAR_INOUT19 0x42A10198U, 0x2U, 0x42A10944U, 0x1U, 0x42A103E0U
#define IOMUXC_GPIO_AD_35_SINC2_MOD_CLK0 0x42A10198U, 0x3U, 0, 0, 0x42A103E0U
#define IOMUXC_GPIO_AD_35_USDHC1_RESET_B 0x42A10198U, 0x4U, 0, 0, 0x42A103E0U
#define IOMUXC_GPIO_AD_35_GPIO5_IO03 0x42A10198U, 0x5U, 0, 0, 0x42A103E0U
#define IOMUXC_GPIO_AD_35_NETC_TMR_ALARM2 0x42A10198U, 0x7U, 0, 0, 0x42A103E0U
#define IOMUXC_GPIO_AD_35_LPUART10_RTS_B 0x42A10198U, 0x8U, 0, 0, 0x42A103E0U

#define IOMUXC_GPIO_SD_B1_00_USDHC1_CMD 0x42A1019CU, 0x0U, 0, 0, 0x42A103E4U
#define IOMUXC_GPIO_SD_B1_00_SINC1_EMCLK02 0x42A1019CU, 0x1U, 0x42A108ECU, 0x1U, 0x42A103E4U
#define IOMUXC_GPIO_SD_B1_00_XBAR1_XBAR_INOUT20 0x42A1019CU, 0x2U, 0x42A10948U, 0x1U, 0x42A103E4U
#define IOMUXC_GPIO_SD_B1_00_LPTMR2_ALT1 0x42A1019CU, 0x3U, 0, 0, 0x42A103E4U
#define IOMUXC_GPIO_SD_B1_00_XSPI_SLV_CS 0x42A1019CU, 0x4U, 0x42A10A00U, 0x0U, 0x42A103E4U
#define IOMUXC_GPIO_SD_B1_00_GPIO5_IO04 0x42A1019CU, 0x5U, 0, 0, 0x42A103E4U
#define IOMUXC_GPIO_SD_B1_00_LPSPI3_PCS0 0x42A1019CU, 0x6U, 0x42A10608U, 0x2U, 0x42A103E4U
#define IOMUXC_GPIO_SD_B1_00_KPP_ROW07 0x42A1019CU, 0x8U, 0x42A105E4U, 0x2U, 0x42A103E4U
#define IOMUXC_GPIO_SD_B1_00_CCM_CLKO1 0x42A1019CU, 0xCU, 0, 0, 0x42A103E4U

#define IOMUXC_GPIO_SD_B1_01_USDHC1_CLK 0x42A101A0U, 0x0U, 0, 0, 0x42A103E8U
#define IOMUXC_GPIO_SD_B1_01_SINC1_EMBIT02 0x42A101A0U, 0x1U, 0x42A108DCU, 0x1U, 0x42A103E8U
#define IOMUXC_GPIO_SD_B1_01_XBAR1_XBAR_INOUT21 0x42A101A0U, 0x2U, 0x42A1094CU, 0x1U, 0x42A103E8U
#define IOMUXC_GPIO_SD_B1_01_LPTMR2_ALT2 0x42A101A0U, 0x3U, 0, 0, 0x42A103E8U
#define IOMUXC_GPIO_SD_B1_01_XSPI_SLV_CLK 0x42A101A0U, 0x4U, 0x42A10A28U, 0x0U, 0x42A103E8U
#define IOMUXC_GPIO_SD_B1_01_GPIO5_IO05 0x42A101A0U, 0x5U, 0, 0, 0x42A103E8U
#define IOMUXC_GPIO_SD_B1_01_LPSPI3_SCK 0x42A101A0U, 0x6U, 0x42A10618U, 0x2U, 0x42A103E8U
#define IOMUXC_GPIO_SD_B1_01_KPP_COL07 0x42A101A0U, 0x8U, 0x42A105C4U, 0x2U, 0x42A103E8U
#define IOMUXC_GPIO_SD_B1_01_CCM_CLKO2 0x42A101A0U, 0xCU, 0, 0, 0x42A103E8U

#define IOMUXC_GPIO_SD_B1_02_ECAT_RESET_OUT 0x42A101A4U, 0xCU, 0, 0, 0x42A103ECU
#define IOMUXC_GPIO_SD_B1_02_USDHC1_DATA0 0x42A101A4U, 0x0U, 0, 0, 0x42A103ECU
#define IOMUXC_GPIO_SD_B1_02_SINC1_EMCLK03 0x42A101A4U, 0x1U, 0x42A108F0U, 0x1U, 0x42A103ECU
#define IOMUXC_GPIO_SD_B1_02_XBAR1_XBAR_INOUT22 0x42A101A4U, 0x2U, 0x42A10950U, 0x1U, 0x42A103ECU
#define IOMUXC_GPIO_SD_B1_02_LPTMR2_ALT3 0x42A101A4U, 0x3U, 0, 0, 0x42A103ECU
#define IOMUXC_GPIO_SD_B1_02_XSPI_SLV_DATA04 0x42A101A4U, 0x4U, 0x42A10A18U, 0x0U, 0x42A103ECU
#define IOMUXC_GPIO_SD_B1_02_GPIO5_IO06 0x42A101A4U, 0x5U, 0, 0, 0x42A103ECU
#define IOMUXC_GPIO_SD_B1_02_LPSPI3_SDO 0x42A101A4U, 0x6U, 0x42A10620U, 0x2U, 0x42A103ECU
#define IOMUXC_GPIO_SD_B1_02_KPP_ROW06 0x42A101A4U, 0x8U, 0x42A105E0U, 0x2U, 0x42A103ECU
#define IOMUXC_GPIO_SD_B1_02_FLEXSPI1_BUS2BIT_A_SS1_B 0x42A101A4U, 0x9U, 0, 0, 0x42A103ECU

#define IOMUXC_GPIO_SD_B1_03_USDHC1_DATA1 0x42A101A8U, 0x0U, 0, 0, 0x42A103F0U
#define IOMUXC_GPIO_SD_B1_03_SINC1_EMBIT03 0x42A101A8U, 0x1U, 0x42A108E0U, 0x1U, 0x42A103F0U
#define IOMUXC_GPIO_SD_B1_03_XBAR1_XBAR_INOUT23 0x42A101A8U, 0x2U, 0x42A10954U, 0x1U, 0x42A103F0U
#define IOMUXC_GPIO_SD_B1_03_LPTMR3_ALT1 0x42A101A8U, 0x3U, 0, 0, 0x42A103F0U
#define IOMUXC_GPIO_SD_B1_03_XSPI_SLV_DATA05 0x42A101A8U, 0x4U, 0x42A10A1CU, 0x0U, 0x42A103F0U
#define IOMUXC_GPIO_SD_B1_03_GPIO5_IO07 0x42A101A8U, 0x5U, 0, 0, 0x42A103F0U
#define IOMUXC_GPIO_SD_B1_03_LPSPI3_SDI 0x42A101A8U, 0x6U, 0x42A1061CU, 0x2U, 0x42A103F0U
#define IOMUXC_GPIO_SD_B1_03_KPP_COL06 0x42A101A8U, 0x8U, 0x42A105C0U, 0x2U, 0x42A103F0U
#define IOMUXC_GPIO_SD_B1_03_FLEXSPI1_BUS2BIT_B_SS1_B 0x42A101A8U, 0x9U, 0, 0, 0x42A103F0U

#define IOMUXC_GPIO_SD_B1_04_USDHC1_DATA2 0x42A101ACU, 0x0U, 0, 0, 0x42A103F4U
#define IOMUXC_GPIO_SD_B1_04_SINC_FILTER_GLUE1_BREAK 0x42A101ACU, 0x1U, 0, 0, 0x42A103F4U
#define IOMUXC_GPIO_SD_B1_04_SINC2_EMCLK02 0x42A101ACU, 0x2U, 0x42A10900U, 0x1U, 0x42A103F4U
#define IOMUXC_GPIO_SD_B1_04_LPTMR3_ALT2 0x42A101ACU, 0x3U, 0, 0, 0x42A103F4U
#define IOMUXC_GPIO_SD_B1_04_XSPI_SLV_DATA06 0x42A101ACU, 0x4U, 0x42A10A20U, 0x0U, 0x42A103F4U
#define IOMUXC_GPIO_SD_B1_04_GPIO5_IO08 0x42A101ACU, 0x5U, 0, 0, 0x42A103F4U
#define IOMUXC_GPIO_SD_B1_04_LPSPI3_PCS1 0x42A101ACU, 0x6U, 0x42A1060CU, 0x2U, 0x42A103F4U
#define IOMUXC_GPIO_SD_B1_04_FLEXSPI1_BUS2BIT_B_SS0_B 0x42A101ACU, 0x8U, 0, 0, 0x42A103F4U
#define IOMUXC_GPIO_SD_B1_04_FLEXSPI1_BUS2BIT_A_SS1_B 0x42A101ACU, 0x9U, 0, 0, 0x42A103F4U

#define IOMUXC_GPIO_SD_B1_05_USDHC1_DATA3 0x42A101B0U, 0x0U, 0, 0, 0x42A103F8U
#define IOMUXC_GPIO_SD_B1_05_SINC2_EMBIT02 0x42A101B0U, 0x2U, 0x42A108F4U, 0x1U, 0x42A103F8U
#define IOMUXC_GPIO_SD_B1_05_LPTMR3_ALT3 0x42A101B0U, 0x3U, 0, 0, 0x42A103F8U
#define IOMUXC_GPIO_SD_B1_05_XSPI_SLV_DATA07 0x42A101B0U, 0x4U, 0x42A10A24U, 0x0U, 0x42A103F8U
#define IOMUXC_GPIO_SD_B1_05_GPIO5_IO09 0x42A101B0U, 0x5U, 0, 0, 0x42A103F8U
#define IOMUXC_GPIO_SD_B1_05_LPSPI3_PCS2 0x42A101B0U, 0x6U, 0x42A10610U, 0x1U, 0x42A103F8U
#define IOMUXC_GPIO_SD_B1_05_FLEXSPI1_BUS2BIT_B_SS0_B 0x42A101B0U, 0x9U, 0, 0, 0x42A103F8U

#define IOMUXC_GPIO_SD_B2_00_MIC_BITSTREAM00 0x42A101B4U, 0xCU, 0x42A106D0U, 0x2U, 0x42A103FCU
#define IOMUXC_GPIO_SD_B2_00_USDHC2_DATA3 0x42A101B4U, 0x0U, 0, 0, 0x42A103FCU
#define IOMUXC_GPIO_SD_B2_00_FLEXSPI1_BUS2BIT_B_DATA04 0x42A101B4U, 0x1U, 0x42A1055CU, 0x0U, 0x42A103FCU
#define IOMUXC_GPIO_SD_B2_00_XSPI_SLV_DATA04 0x42A101B4U, 0x2U, 0x42A10A18U, 0x1U, 0x42A103FCU
#define IOMUXC_GPIO_SD_B2_00_XBAR1_XBAR_INOUT17 0x42A101B4U, 0x3U, 0x42A1093CU, 0x1U, 0x42A103FCU
#define IOMUXC_GPIO_SD_B2_00_KPP_ROW01 0x42A101B4U, 0x4U, 0x42A105CCU, 0x2U, 0x42A103FCU
#define IOMUXC_GPIO_SD_B2_00_GPIO5_IO10 0x42A101B4U, 0x5U, 0, 0, 0x42A103FCU
#define IOMUXC_GPIO_SD_B2_00_LPSPI3_PCS3 0x42A101B4U, 0x6U, 0x42A10614U, 0x1U, 0x42A103FCU
#define IOMUXC_GPIO_SD_B2_00_NETC_1588_CLK 0x42A101B4U, 0x8U, 0x42A107D4U, 0x1U, 0x42A103FCU
#define IOMUXC_GPIO_SD_B2_00_LPUART8_TX 0x42A101B4U, 0x9U, 0x42A106C4U, 0x1U, 0x42A103FCU

#define IOMUXC_GPIO_SD_B2_01_USDHC2_DATA2 0x42A101B8U, 0x0U, 0, 0, 0x42A10400U
#define IOMUXC_GPIO_SD_B2_01_FLEXSPI1_BUS2BIT_B_DATA05 0x42A101B8U, 0x1U, 0x42A10560U, 0x0U, 0x42A10400U
#define IOMUXC_GPIO_SD_B2_01_XSPI_SLV_DATA05 0x42A101B8U, 0x2U, 0x42A10A1CU, 0x1U, 0x42A10400U
#define IOMUXC_GPIO_SD_B2_01_QTIMER6_TIMER0 0x42A101B8U, 0x3U, 0x42A10894U, 0x2U, 0x42A10400U
#define IOMUXC_GPIO_SD_B2_01_KPP_COL01 0x42A101B8U, 0x4U, 0x42A105ACU, 0x2U, 0x42A10400U
#define IOMUXC_GPIO_SD_B2_01_GPIO5_IO11 0x42A101B8U, 0x5U, 0, 0, 0x42A10400U
#define IOMUXC_GPIO_SD_B2_01_NETC_TMR_GCLK 0x42A101B8U, 0x8U, 0, 0, 0x42A10400U
#define IOMUXC_GPIO_SD_B2_01_LPUART8_RX 0x42A101B8U, 0x9U, 0x42A106C0U, 0x1U, 0x42A10400U
#define IOMUXC_GPIO_SD_B2_01_MIC_BITSTREAM01 0x42A101B8U, 0xCU, 0x42A106D4U, 0x2U, 0x42A10400U

#define IOMUXC_GPIO_SD_B2_02_MIC_BITSTREAM02 0x42A101BCU, 0xCU, 0x42A106D8U, 0x2U, 0x42A10404U
#define IOMUXC_GPIO_SD_B2_02_USDHC2_DATA1 0x42A101BCU, 0x0U, 0, 0, 0x42A10404U
#define IOMUXC_GPIO_SD_B2_02_FLEXSPI1_BUS2BIT_B_DATA06 0x42A101BCU, 0x1U, 0x42A10564U, 0x0U, 0x42A10404U
#define IOMUXC_GPIO_SD_B2_02_XSPI_SLV_DATA06 0x42A101BCU, 0x2U, 0x42A10A20U, 0x1U, 0x42A10404U
#define IOMUXC_GPIO_SD_B2_02_QTIMER6_TIMER1 0x42A101BCU, 0x3U, 0x42A10898U, 0x2U, 0x42A10404U
#define IOMUXC_GPIO_SD_B2_02_KPP_ROW00 0x42A101BCU, 0x4U, 0x42A105C8U, 0x2U, 0x42A10404U
#define IOMUXC_GPIO_SD_B2_02_GPIO5_IO12 0x42A101BCU, 0x5U, 0, 0, 0x42A10404U
#define IOMUXC_GPIO_SD_B2_02_NETC_TMR_ALARM1 0x42A101BCU, 0x8U, 0, 0, 0x42A10404U
#define IOMUXC_GPIO_SD_B2_02_LPUART8_CTS_B 0x42A101BCU, 0x9U, 0x42A106BCU, 0x0U, 0x42A10404U

#define IOMUXC_GPIO_SD_B2_03_MIC_BITSTREAM03 0x42A101C0U, 0xCU, 0x42A106DCU, 0x2U, 0x42A10408U
#define IOMUXC_GPIO_SD_B2_03_USDHC2_DATA0 0x42A101C0U, 0x0U, 0, 0, 0x42A10408U
#define IOMUXC_GPIO_SD_B2_03_FLEXSPI1_BUS2BIT_B_DATA07 0x42A101C0U, 0x1U, 0x42A10568U, 0x0U, 0x42A10408U
#define IOMUXC_GPIO_SD_B2_03_XSPI_SLV_DATA07 0x42A101C0U, 0x2U, 0x42A10A24U, 0x1U, 0x42A10408U
#define IOMUXC_GPIO_SD_B2_03_QTIMER6_TIMER2 0x42A101C0U, 0x3U, 0x42A1089CU, 0x1U, 0x42A10408U
#define IOMUXC_GPIO_SD_B2_03_KPP_COL00 0x42A101C0U, 0x4U, 0x42A105A8U, 0x2U, 0x42A10408U
#define IOMUXC_GPIO_SD_B2_03_GPIO5_IO13 0x42A101C0U, 0x5U, 0, 0, 0x42A10408U
#define IOMUXC_GPIO_SD_B2_03_NETC_TMR_ALARM2 0x42A101C0U, 0x8U, 0, 0, 0x42A10408U
#define IOMUXC_GPIO_SD_B2_03_LPUART8_RTS_B 0x42A101C0U, 0x9U, 0, 0, 0x42A10408U

#define IOMUXC_GPIO_SD_B2_04_USDHC2_CLK 0x42A101C4U, 0x0U, 0, 0, 0x42A1040CU
#define IOMUXC_GPIO_SD_B2_04_FLEXSPI1_BUS2BIT_B_SS1_B 0x42A101C4U, 0x1U, 0, 0, 0x42A1040CU
#define IOMUXC_GPIO_SD_B2_04_QTIMER7_TIMER0 0x42A101C4U, 0x3U, 0x42A108A0U, 0x1U, 0x42A1040CU
#define IOMUXC_GPIO_SD_B2_04_KPP_ROW03 0x42A101C4U, 0x4U, 0x42A105D4U, 0x2U, 0x42A1040CU
#define IOMUXC_GPIO_SD_B2_04_GPIO5_IO14 0x42A101C4U, 0x5U, 0, 0, 0x42A1040CU
#define IOMUXC_GPIO_SD_B2_04_LPUART5_RI_B 0x42A101C4U, 0x6U, 0x42A10698U, 0x1U, 0x42A1040CU
#define IOMUXC_GPIO_SD_B2_04_NETC_TMR_PP1 0x42A101C4U, 0x8U, 0, 0, 0x42A1040CU
#define IOMUXC_GPIO_SD_B2_04_MIC_CLK 0x42A101C4U, 0xCU, 0, 0, 0x42A1040CU

#define IOMUXC_GPIO_SD_B2_05_USDHC2_CMD 0x42A101C8U, 0x0U, 0, 0, 0x42A10410U
#define IOMUXC_GPIO_SD_B2_05_FLEXSPI1_BUS2BIT_B_DQS 0x42A101C8U, 0x1U, 0x42A10548U, 0x0U, 0x42A10410U
#define IOMUXC_GPIO_SD_B2_05_XSPI_SLV_DQS 0x42A101C8U, 0x2U, 0x42A10A04U, 0x0U, 0x42A10410U
#define IOMUXC_GPIO_SD_B2_05_QTIMER7_TIMER1 0x42A101C8U, 0x3U, 0x42A108A4U, 0x1U, 0x42A10410U
#define IOMUXC_GPIO_SD_B2_05_LPSPI4_PCS3 0x42A101C8U, 0x4U, 0, 0, 0x42A10410U
#define IOMUXC_GPIO_SD_B2_05_GPIO5_IO15 0x42A101C8U, 0x5U, 0, 0, 0x42A10410U
#define IOMUXC_GPIO_SD_B2_05_LPUART5_DTR_B 0x42A101C8U, 0x6U, 0, 0, 0x42A10410U
#define IOMUXC_GPIO_SD_B2_05_NETC_TMR_PP2 0x42A101C8U, 0x8U, 0, 0, 0x42A10410U

#define IOMUXC_GPIO_SD_B2_06_USDHC2_RESET_B 0x42A101CCU, 0x0U, 0, 0, 0x42A10414U
#define IOMUXC_GPIO_SD_B2_06_FLEXSPI1_BUS2BIT_B_SS0_B 0x42A101CCU, 0x1U, 0, 0, 0x42A10414U
#define IOMUXC_GPIO_SD_B2_06_XSPI_SLV_CS 0x42A101CCU, 0x2U, 0x42A10A00U, 0x1U, 0x42A10414U
#define IOMUXC_GPIO_SD_B2_06_QTIMER7_TIMER2 0x42A101CCU, 0x3U, 0, 0, 0x42A10414U
#define IOMUXC_GPIO_SD_B2_06_LPSPI4_PCS2 0x42A101CCU, 0x4U, 0, 0, 0x42A10414U
#define IOMUXC_GPIO_SD_B2_06_GPIO5_IO16 0x42A101CCU, 0x5U, 0, 0, 0x42A10414U
#define IOMUXC_GPIO_SD_B2_06_LPUART5_CTS_B 0x42A101CCU, 0x6U, 0x42A1068CU, 0x2U, 0x42A10414U
#define IOMUXC_GPIO_SD_B2_06_NETC_TMR_PP3 0x42A101CCU, 0x8U, 0, 0, 0x42A10414U

#define IOMUXC_GPIO_SD_B2_07_USDHC2_STROBE 0x42A101D0U, 0x0U, 0, 0, 0x42A10418U
#define IOMUXC_GPIO_SD_B2_07_FLEXSPI1_BUS2BIT_B_SCLK 0x42A101D0U, 0x1U, 0x42A1056CU, 0x0U, 0x42A10418U
#define IOMUXC_GPIO_SD_B2_07_XSPI_SLV_CLK 0x42A101D0U, 0x2U, 0x42A10A28U, 0x1U, 0x42A10418U
#define IOMUXC_GPIO_SD_B2_07_QTIMER7_TIMER3 0x42A101D0U, 0x3U, 0, 0, 0x42A10418U
#define IOMUXC_GPIO_SD_B2_07_LPSPI4_PCS1 0x42A101D0U, 0x4U, 0, 0, 0x42A10418U
#define IOMUXC_GPIO_SD_B2_07_GPIO5_IO17 0x42A101D0U, 0x5U, 0, 0, 0x42A10418U
#define IOMUXC_GPIO_SD_B2_07_LPUART5_RTS_B 0x42A101D0U, 0x6U, 0, 0, 0x42A10418U
#define IOMUXC_GPIO_SD_B2_07_NETC_TMR_ALARM1 0x42A101D0U, 0x8U, 0, 0, 0x42A10418U

#define IOMUXC_GPIO_SD_B2_08_USDHC2_DATA4 0x42A101D4U, 0x0U, 0, 0, 0x42A1041CU
#define IOMUXC_GPIO_SD_B2_08_FLEXSPI1_BUS2BIT_B_DATA00 0x42A101D4U, 0x1U, 0x42A1054CU, 0x0U, 0x42A1041CU
#define IOMUXC_GPIO_SD_B2_08_XSPI_SLV_DATA00 0x42A101D4U, 0x2U, 0x42A10A08U, 0x0U, 0x42A1041CU
#define IOMUXC_GPIO_SD_B2_08_QTIMER8_TIMER0 0x42A101D4U, 0x3U, 0x42A108A8U, 0x1U, 0x42A1041CU
#define IOMUXC_GPIO_SD_B2_08_LPSPI4_SCK 0x42A101D4U, 0x4U, 0x42A10628U, 0x1U, 0x42A1041CU
#define IOMUXC_GPIO_SD_B2_08_GPIO5_IO18 0x42A101D4U, 0x5U, 0, 0, 0x42A1041CU
#define IOMUXC_GPIO_SD_B2_08_LPUART5_TX 0x42A101D4U, 0x6U, 0x42A106A0U, 0x4U, 0x42A1041CU
#define IOMUXC_GPIO_SD_B2_08_NETC_TMR_ALARM2 0x42A101D4U, 0x8U, 0, 0, 0x42A1041CU
#define IOMUXC_GPIO_SD_B2_08_NETC_TMR_PP2 0x42A101D4U, 0x9U, 0, 0, 0x42A1041CU

#define IOMUXC_GPIO_SD_B2_09_USDHC2_DATA5 0x42A101D8U, 0x0U, 0, 0, 0x42A10420U
#define IOMUXC_GPIO_SD_B2_09_FLEXSPI1_BUS2BIT_B_DATA01 0x42A101D8U, 0x1U, 0x42A10550U, 0x0U, 0x42A10420U
#define IOMUXC_GPIO_SD_B2_09_XSPI_SLV_DATA01 0x42A101D8U, 0x2U, 0x42A10A0CU, 0x0U, 0x42A10420U
#define IOMUXC_GPIO_SD_B2_09_QTIMER8_TIMER1 0x42A101D8U, 0x3U, 0x42A108ACU, 0x1U, 0x42A10420U
#define IOMUXC_GPIO_SD_B2_09_LPSPI4_PCS0 0x42A101D8U, 0x4U, 0x42A10624U, 0x1U, 0x42A10420U
#define IOMUXC_GPIO_SD_B2_09_GPIO5_IO19 0x42A101D8U, 0x5U, 0, 0, 0x42A10420U
#define IOMUXC_GPIO_SD_B2_09_LPUART5_RX 0x42A101D8U, 0x6U, 0x42A1069CU, 0x4U, 0x42A10420U
#define IOMUXC_GPIO_SD_B2_09_NETC_TMR_PP1 0x42A101D8U, 0x9U, 0, 0, 0x42A10420U

#define IOMUXC_GPIO_SD_B2_10_NETC_EMDIO 0x42A101DCU, 0xAU, 0x42A10798U, 0x5U, 0x42A10424U
#define IOMUXC_GPIO_SD_B2_10_ECAT_MDIO 0x42A101DCU, 0xCU, 0x42A104ECU, 0x1U, 0x42A10424U
#define IOMUXC_GPIO_SD_B2_10_USDHC2_DATA6 0x42A101DCU, 0x0U, 0, 0, 0x42A10424U
#define IOMUXC_GPIO_SD_B2_10_FLEXSPI1_BUS2BIT_B_DATA02 0x42A101DCU, 0x1U, 0x42A10554U, 0x0U, 0x42A10424U
#define IOMUXC_GPIO_SD_B2_10_XSPI_SLV_DATA02 0x42A101DCU, 0x2U, 0x42A10A10U, 0x0U, 0x42A10424U
#define IOMUXC_GPIO_SD_B2_10_QTIMER8_TIMER2 0x42A101DCU, 0x3U, 0, 0, 0x42A10424U
#define IOMUXC_GPIO_SD_B2_10_LPSPI4_SDO 0x42A101DCU, 0x4U, 0x42A10630U, 0x1U, 0x42A10424U
#define IOMUXC_GPIO_SD_B2_10_GPIO5_IO20 0x42A101DCU, 0x5U, 0, 0, 0x42A10424U
#define IOMUXC_GPIO_SD_B2_10_LPUART5_DCD_B 0x42A101DCU, 0x6U, 0x42A10690U, 0x1U, 0x42A10424U
#define IOMUXC_GPIO_SD_B2_10_NETC_TMR_TRIG2 0x42A101DCU, 0x8U, 0x42A107D0U, 0x3U, 0x42A10424U
#define IOMUXC_GPIO_SD_B2_10_NETC_TMR_PP3 0x42A101DCU, 0x9U, 0, 0, 0x42A10424U

#define IOMUXC_GPIO_SD_B2_11_USDHC2_DATA7 0x42A101E0U, 0x0U, 0, 0, 0x42A10428U
#define IOMUXC_GPIO_SD_B2_11_FLEXSPI1_BUS2BIT_B_DATA03 0x42A101E0U, 0x1U, 0x42A10558U, 0x0U, 0x42A10428U
#define IOMUXC_GPIO_SD_B2_11_XSPI_SLV_DATA03 0x42A101E0U, 0x2U, 0x42A10A14U, 0x0U, 0x42A10428U
#define IOMUXC_GPIO_SD_B2_11_QTIMER8_TIMER3 0x42A101E0U, 0x3U, 0, 0, 0x42A10428U
#define IOMUXC_GPIO_SD_B2_11_LPSPI4_SDI 0x42A101E0U, 0x4U, 0x42A1062CU, 0x1U, 0x42A10428U
#define IOMUXC_GPIO_SD_B2_11_GPIO5_IO21 0x42A101E0U, 0x5U, 0, 0, 0x42A10428U
#define IOMUXC_GPIO_SD_B2_11_LPUART5_DSR_B 0x42A101E0U, 0x6U, 0x42A10694U, 0x1U, 0x42A10428U
#define IOMUXC_GPIO_SD_B2_11_SFA_ATX_CLK_OUT 0x42A101E0U, 0x7U, 0, 0, 0x42A10428U
#define IOMUXC_GPIO_SD_B2_11_NETC_TMR_TRIG1 0x42A101E0U, 0x8U, 0x42A107CCU, 0x3U, 0x42A10428U
#define IOMUXC_GPIO_SD_B2_11_NETC_EMDC 0x42A101E0U, 0xAU, 0, 0, 0x42A10428U
#define IOMUXC_GPIO_SD_B2_11_ECAT_MCLK 0x42A101E0U, 0xCU, 0, 0, 0x42A10428U

#define IOMUXC_GPIO_SD_B2_12_DUMMY_FLEXSPI1_BUS2BIT_A_DQS 0x42A101E4U, 0x0U, 0x42A10544U, 0x0U, 0x42A1042CU
#define IOMUXC_GPIO_SD_B2_12_DUMMY_FLEXSPI1_BUS2BIT_B_DQS 0x42A101E4U, 0x1U, 0x42A10548U, 0x1U, 0x42A1042CU
#define IOMUXC_GPIO_SD_B2_12_DUMMY_GPIO5_IO22 0x42A101E4U, 0x5U, 0, 0, 0x42A1042CU

#define IOMUXC_GPIO_B1_00_NETC_PINMUX_ETH1_TXD00 0x42A101E8U, 0x0U, 0, 0, 0x42A10430U
#define IOMUXC_GPIO_B1_00_ADC2_CONV_D00 0x42A101E8U, 0x1U, 0, 0, 0x42A10430U
#define IOMUXC_GPIO_B1_00_SEMC_CSX01 0x42A101E8U, 0x2U, 0, 0, 0x42A10430U
#define IOMUXC_GPIO_B1_00_QTIMER1_TIMER0 0x42A101E8U, 0x3U, 0x42A10858U, 0x2U, 0x42A10430U
#define IOMUXC_GPIO_B1_00_XBAR1_XBAR_INOUT26 0x42A101E8U, 0x4U, 0x42A10960U, 0x1U, 0x42A10430U
#define IOMUXC_GPIO_B1_00_GPIO6_IO00 0x42A101E8U, 0x5U, 0, 0, 0x42A10430U
#define IOMUXC_GPIO_B1_00_TPM5_CH00 0x42A101E8U, 0x6U, 0, 0, 0x42A10430U
#define IOMUXC_GPIO_B1_00_NETC_PINMUX_ETH4_TXD00 0x42A101E8U, 0x8U, 0, 0, 0x42A10430U

#define IOMUXC_GPIO_B1_01_NETC_PINMUX_ETH1_TXD01 0x42A101ECU, 0x0U, 0, 0, 0x42A10434U
#define IOMUXC_GPIO_B1_01_ADC2_CONV_D01 0x42A101ECU, 0x1U, 0, 0, 0x42A10434U
#define IOMUXC_GPIO_B1_01_SEMC_CSX02 0x42A101ECU, 0x2U, 0, 0, 0x42A10434U
#define IOMUXC_GPIO_B1_01_QTIMER1_TIMER1 0x42A101ECU, 0x3U, 0x42A1085CU, 0x2U, 0x42A10434U
#define IOMUXC_GPIO_B1_01_XBAR1_XBAR_INOUT27 0x42A101ECU, 0x4U, 0x42A10964U, 0x1U, 0x42A10434U
#define IOMUXC_GPIO_B1_01_GPIO6_IO01 0x42A101ECU, 0x5U, 0, 0, 0x42A10434U
#define IOMUXC_GPIO_B1_01_TPM5_CH01 0x42A101ECU, 0x6U, 0, 0, 0x42A10434U
#define IOMUXC_GPIO_B1_01_NETC_PINMUX_ETH4_TXD01 0x42A101ECU, 0x8U, 0, 0, 0x42A10434U
#define IOMUXC_GPIO_B1_01_SAI4_RX_DATA00 0x42A101ECU, 0xCU, 0x42A108B8U, 0x1U, 0x42A10434U

#define IOMUXC_GPIO_B1_02_NETC_PINMUX_ETH1_TX_EN 0x42A101F0U, 0x0U, 0, 0, 0x42A10438U
#define IOMUXC_GPIO_B1_02_ADC2_CONV_D02 0x42A101F0U, 0x1U, 0, 0, 0x42A10438U
#define IOMUXC_GPIO_B1_02_LPI2C6_SCL 0x42A101F0U, 0x2U, 0x42A10600U, 0x0U, 0x42A10438U
#define IOMUXC_GPIO_B1_02_QTIMER1_TIMER2 0x42A101F0U, 0x3U, 0x42A10860U, 0x1U, 0x42A10438U
#define IOMUXC_GPIO_B1_02_XBAR1_XBAR_INOUT28 0x42A101F0U, 0x4U, 0x42A10968U, 0x1U, 0x42A10438U
#define IOMUXC_GPIO_B1_02_GPIO6_IO02 0x42A101F0U, 0x5U, 0, 0, 0x42A10438U
#define IOMUXC_GPIO_B1_02_TPM5_CH02 0x42A101F0U, 0x6U, 0, 0, 0x42A10438U
#define IOMUXC_GPIO_B1_02_FLEXSPI1_BUS2BIT_B_SS1_B 0x42A101F0U, 0x7U, 0, 0, 0x42A10438U
#define IOMUXC_GPIO_B1_02_NETC_PINMUX_ETH4_TX_EN 0x42A101F0U, 0x8U, 0, 0, 0x42A10438U
#define IOMUXC_GPIO_B1_02_LPUART11_TX 0x42A101F0U, 0x9U, 0x42A10678U, 0x1U, 0x42A10438U
#define IOMUXC_GPIO_B1_02_SAI4_RX_DATA01 0x42A101F0U, 0xCU, 0x42A108BCU, 0x0U, 0x42A10438U

#define IOMUXC_GPIO_B1_03_NETC_PINMUX_ETH1_TX_CLK 0x42A101F4U, 0x0U, 0, 0, 0x42A1043CU
#define IOMUXC_GPIO_B1_03_ADC2_CONV_D03 0x42A101F4U, 0x1U, 0, 0, 0x42A1043CU
#define IOMUXC_GPIO_B1_03_LPI2C6_SDA 0x42A101F4U, 0x2U, 0x42A10604U, 0x0U, 0x42A1043CU
#define IOMUXC_GPIO_B1_03_QTIMER2_TIMER0 0x42A101F4U, 0x3U, 0x42A10864U, 0x2U, 0x42A1043CU
#define IOMUXC_GPIO_B1_03_XBAR1_XBAR_INOUT29 0x42A101F4U, 0x4U, 0x42A1096CU, 0x1U, 0x42A1043CU
#define IOMUXC_GPIO_B1_03_GPIO6_IO03 0x42A101F4U, 0x5U, 0, 0, 0x42A1043CU
#define IOMUXC_GPIO_B1_03_TPM5_CH03 0x42A101F4U, 0x6U, 0, 0, 0x42A1043CU
#define IOMUXC_GPIO_B1_03_FLEXSPI1_BUS2BIT_B_DQS 0x42A101F4U, 0x7U, 0x42A10548U, 0x2U, 0x42A1043CU
#define IOMUXC_GPIO_B1_03_NETC_PINMUX_ETH4_TX_CLK 0x42A101F4U, 0x8U, 0x42A10854U, 0x2U, 0x42A1043CU
#define IOMUXC_GPIO_B1_03_LPUART11_RX 0x42A101F4U, 0x9U, 0x42A10674U, 0x1U, 0x42A1043CU
#define IOMUXC_GPIO_B1_03_SAI4_RX_DATA02 0x42A101F4U, 0xCU, 0, 0, 0x42A1043CU

#define IOMUXC_GPIO_B1_04_NETC_PINMUX_ETH1_RXD00 0x42A101F8U, 0x0U, 0, 0, 0x42A10440U
#define IOMUXC_GPIO_B1_04_ADC2_CONV_D04 0x42A101F8U, 0x1U, 0, 0, 0x42A10440U
#define IOMUXC_GPIO_B1_04_LPUART9_RX 0x42A101F8U, 0x2U, 0x42A106C8U, 0x1U, 0x42A10440U
#define IOMUXC_GPIO_B1_04_QTIMER2_TIMER1 0x42A101F8U, 0x3U, 0x42A10868U, 0x2U, 0x42A10440U
#define IOMUXC_GPIO_B1_04_XBAR1_XBAR_INOUT30 0x42A101F8U, 0x4U, 0x42A10970U, 0x1U, 0x42A10440U
#define IOMUXC_GPIO_B1_04_GPIO6_IO04 0x42A101F8U, 0x5U, 0, 0, 0x42A10440U
#define IOMUXC_GPIO_B1_04_TPM5_EXTCLK 0x42A101F8U, 0x6U, 0, 0, 0x42A10440U
#define IOMUXC_GPIO_B1_04_FLEXSPI1_BUS2BIT_B_SS0_B 0x42A101F8U, 0x7U, 0, 0, 0x42A10440U
#define IOMUXC_GPIO_B1_04_NETC_PINMUX_ETH4_RXD00 0x42A101F8U, 0x8U, 0x42A10844U, 0x2U, 0x42A10440U
#define IOMUXC_GPIO_B1_04_SAI4_RX_DATA03 0x42A101F8U, 0xCU, 0, 0, 0x42A10440U

#define IOMUXC_GPIO_B1_05_NETC_PINMUX_ETH1_RXD01 0x42A101FCU, 0x0U, 0, 0, 0x42A10444U
#define IOMUXC_GPIO_B1_05_ADC2_CONV_D05 0x42A101FCU, 0x1U, 0, 0, 0x42A10444U
#define IOMUXC_GPIO_B1_05_LPUART9_CTS_B 0x42A101FCU, 0x2U, 0, 0, 0x42A10444U
#define IOMUXC_GPIO_B1_05_QTIMER2_TIMER2 0x42A101FCU, 0x3U, 0x42A1086CU, 0x1U, 0x42A10444U
#define IOMUXC_GPIO_B1_05_XBAR1_XBAR_INOUT31 0x42A101FCU, 0x4U, 0x42A10974U, 0x1U, 0x42A10444U
#define IOMUXC_GPIO_B1_05_GPIO6_IO05 0x42A101FCU, 0x5U, 0, 0, 0x42A10444U
#define IOMUXC_GPIO_B1_05_TPM6_EXTCLK 0x42A101FCU, 0x6U, 0, 0, 0x42A10444U
#define IOMUXC_GPIO_B1_05_FLEXSPI1_BUS2BIT_B_SCLK 0x42A101FCU, 0x7U, 0x42A1056CU, 0x1U, 0x42A10444U
#define IOMUXC_GPIO_B1_05_NETC_PINMUX_ETH4_RXD01 0x42A101FCU, 0x8U, 0x42A10848U, 0x2U, 0x42A10444U
#define IOMUXC_GPIO_B1_05_SAI4_MCLK 0x42A101FCU, 0xCU, 0x42A108B0U, 0x1U, 0x42A10444U

#define IOMUXC_GPIO_B1_06_NETC_PINMUX_ETH1_RX_DV 0x42A10200U, 0x0U, 0, 0, 0x42A10448U
#define IOMUXC_GPIO_B1_06_ADC2_CONV_D06 0x42A10200U, 0x1U, 0, 0, 0x42A10448U
#define IOMUXC_GPIO_B1_06_LPUART9_TX 0x42A10200U, 0x2U, 0x42A106CCU, 0x1U, 0x42A10448U
#define IOMUXC_GPIO_B1_06_QTIMER3_TIMER0 0x42A10200U, 0x3U, 0x42A10870U, 0x2U, 0x42A10448U
#define IOMUXC_GPIO_B1_06_XBAR1_XBAR_INOUT32 0x42A10200U, 0x4U, 0x42A10978U, 0x1U, 0x42A10448U
#define IOMUXC_GPIO_B1_06_GPIO6_IO06 0x42A10200U, 0x5U, 0, 0, 0x42A10448U
#define IOMUXC_GPIO_B1_06_TPM6_CH00 0x42A10200U, 0x6U, 0, 0, 0x42A10448U
#define IOMUXC_GPIO_B1_06_FLEXSPI1_BUS2BIT_B_DATA07 0x42A10200U, 0x7U, 0x42A10568U, 0x1U, 0x42A10448U
#define IOMUXC_GPIO_B1_06_NETC_PINMUX_ETH4_RX_DV 0x42A10200U, 0x8U, 0x42A1083CU, 0x2U, 0x42A10448U
#define IOMUXC_GPIO_B1_06_SAI4_RX_BCLK 0x42A10200U, 0xCU, 0x42A108B4U, 0x1U, 0x42A10448U

#define IOMUXC_GPIO_B1_07_NETC_PINMUX_ETH1_TXD02 0x42A10204U, 0x0U, 0, 0, 0x42A1044CU
#define IOMUXC_GPIO_B1_07_ADC2_CONV_D07 0x42A10204U, 0x1U, 0, 0, 0x42A1044CU
#define IOMUXC_GPIO_B1_07_LPUART9_RTS_B 0x42A10204U, 0x2U, 0, 0, 0x42A1044CU
#define IOMUXC_GPIO_B1_07_QTIMER3_TIMER1 0x42A10204U, 0x3U, 0x42A10874U, 0x2U, 0x42A1044CU
#define IOMUXC_GPIO_B1_07_XBAR1_XBAR_INOUT33 0x42A10204U, 0x4U, 0x42A1097CU, 0x1U, 0x42A1044CU
#define IOMUXC_GPIO_B1_07_GPIO6_IO07 0x42A10204U, 0x5U, 0, 0, 0x42A1044CU
#define IOMUXC_GPIO_B1_07_TPM6_CH01 0x42A10204U, 0x6U, 0, 0, 0x42A1044CU
#define IOMUXC_GPIO_B1_07_FLEXSPI1_BUS2BIT_B_DATA06 0x42A10204U, 0x7U, 0x42A10564U, 0x1U, 0x42A1044CU
#define IOMUXC_GPIO_B1_07_NETC_PINMUX_ETH4_TXD02 0x42A10204U, 0x8U, 0x42A10840U, 0x2U, 0x42A1044CU
#define IOMUXC_GPIO_B1_07_LPSPI6_SDI 0x42A10204U, 0x9U, 0x42A10664U, 0x2U, 0x42A1044CU
#define IOMUXC_GPIO_B1_07_SAI4_RX_SYNC 0x42A10204U, 0xCU, 0x42A108C0U, 0x1U, 0x42A1044CU

#define IOMUXC_GPIO_B1_08_SAI4_TX_BCLK 0x42A10208U, 0xCU, 0x42A108C4U, 0x1U, 0x42A10450U
#define IOMUXC_GPIO_B1_08_NETC_PINMUX_ETH1_TXD03 0x42A10208U, 0x0U, 0, 0, 0x42A10450U
#define IOMUXC_GPIO_B1_08_ADC2_CONV_RDY_CLK 0x42A10208U, 0x1U, 0, 0, 0x42A10450U
#define IOMUXC_GPIO_B1_08_USDHC1_CD_B 0x42A10208U, 0x2U, 0x42A10924U, 0x1U, 0x42A10450U
#define IOMUXC_GPIO_B1_08_QTIMER3_TIMER2 0x42A10208U, 0x3U, 0x42A10878U, 0x1U, 0x42A10450U
#define IOMUXC_GPIO_B1_08_XBAR1_XBAR_INOUT36 0x42A10208U, 0x4U, 0x42A10988U, 0x1U, 0x42A10450U
#define IOMUXC_GPIO_B1_08_GPIO6_IO08 0x42A10208U, 0x5U, 0, 0, 0x42A10450U
#define IOMUXC_GPIO_B1_08_TPM6_CH02 0x42A10208U, 0x6U, 0, 0, 0x42A10450U
#define IOMUXC_GPIO_B1_08_FLEXSPI1_BUS2BIT_B_DATA05 0x42A10208U, 0x7U, 0x42A10560U, 0x1U, 0x42A10450U
#define IOMUXC_GPIO_B1_08_NETC_PINMUX_ETH4_TXD03 0x42A10208U, 0x8U, 0, 0, 0x42A10450U
#define IOMUXC_GPIO_B1_08_LPSPI6_SDO 0x42A10208U, 0x9U, 0x42A10668U, 0x2U, 0x42A10450U

#define IOMUXC_GPIO_B1_09_NETC_PINMUX_ETH1_RXD02 0x42A1020CU, 0x0U, 0, 0, 0x42A10454U
#define IOMUXC_GPIO_B1_09_USDHC1_WP 0x42A1020CU, 0x2U, 0x42A10928U, 0x1U, 0x42A10454U
#define IOMUXC_GPIO_B1_09_QTIMER4_TIMER0 0x42A1020CU, 0x3U, 0x42A1087CU, 0x2U, 0x42A10454U
#define IOMUXC_GPIO_B1_09_XBAR1_XBAR_INOUT37 0x42A1020CU, 0x4U, 0x42A1098CU, 0x1U, 0x42A10454U
#define IOMUXC_GPIO_B1_09_GPIO6_IO09 0x42A1020CU, 0x5U, 0, 0, 0x42A10454U
#define IOMUXC_GPIO_B1_09_TPM6_CH03 0x42A1020CU, 0x6U, 0, 0, 0x42A10454U
#define IOMUXC_GPIO_B1_09_FLEXSPI1_BUS2BIT_B_DATA04 0x42A1020CU, 0x7U, 0x42A1055CU, 0x1U, 0x42A10454U
#define IOMUXC_GPIO_B1_09_NETC_PINMUX_ETH4_RXD02 0x42A1020CU, 0x8U, 0x42A1084CU, 0x2U, 0x42A10454U
#define IOMUXC_GPIO_B1_09_LPSPI6_PCS1 0x42A1020CU, 0x9U, 0x42A10654U, 0x2U, 0x42A10454U
#define IOMUXC_GPIO_B1_09_SAI4_TX_SYNC 0x42A1020CU, 0xCU, 0x42A108C8U, 0x1U, 0x42A10454U

#define IOMUXC_GPIO_B1_10_NETC_PINMUX_ETH1_RXD03 0x42A10210U, 0x0U, 0, 0, 0x42A10458U
#define IOMUXC_GPIO_B1_10_USDHC1_RESET_B 0x42A10210U, 0x2U, 0, 0, 0x42A10458U
#define IOMUXC_GPIO_B1_10_QTIMER4_TIMER1 0x42A10210U, 0x3U, 0x42A10880U, 0x2U, 0x42A10458U
#define IOMUXC_GPIO_B1_10_XBAR1_XBAR_INOUT34 0x42A10210U, 0x4U, 0x42A10980U, 0x1U, 0x42A10458U
#define IOMUXC_GPIO_B1_10_GPIO6_IO10 0x42A10210U, 0x5U, 0, 0, 0x42A10458U
#define IOMUXC_GPIO_B1_10_FLEXSPI1_BUS2BIT_B_DATA03 0x42A10210U, 0x7U, 0x42A10558U, 0x1U, 0x42A10458U
#define IOMUXC_GPIO_B1_10_NETC_PINMUX_ETH4_RXD03 0x42A10210U, 0x8U, 0x42A10850U, 0x2U, 0x42A10458U
#define IOMUXC_GPIO_B1_10_LPSPI6_PCS2 0x42A10210U, 0x9U, 0x42A10658U, 0x2U, 0x42A10458U
#define IOMUXC_GPIO_B1_10_SAI4_TX_DATA00 0x42A10210U, 0xCU, 0, 0, 0x42A10458U

#define IOMUXC_GPIO_B1_11_NETC_PINMUX_ETH1_RX_CLK 0x42A10214U, 0x0U, 0, 0, 0x42A1045CU
#define IOMUXC_GPIO_B1_11_QTIMER4_TIMER2 0x42A10214U, 0x3U, 0x42A10884U, 0x1U, 0x42A1045CU
#define IOMUXC_GPIO_B1_11_XBAR1_XBAR_INOUT35 0x42A10214U, 0x4U, 0x42A10984U, 0x1U, 0x42A1045CU
#define IOMUXC_GPIO_B1_11_GPIO6_IO11 0x42A10214U, 0x5U, 0, 0, 0x42A1045CU
#define IOMUXC_GPIO_B1_11_FLEXSPI1_BUS2BIT_B_DATA02 0x42A10214U, 0x7U, 0x42A10554U, 0x1U, 0x42A1045CU
#define IOMUXC_GPIO_B1_11_NETC_PINMUX_ETH4_RX_CLK 0x42A10214U, 0x8U, 0x42A10838U, 0x2U, 0x42A1045CU
#define IOMUXC_GPIO_B1_11_LPSPI6_PCS3 0x42A10214U, 0x9U, 0x42A1065CU, 0x1U, 0x42A1045CU
#define IOMUXC_GPIO_B1_11_SAI4_TX_DATA01 0x42A10214U, 0xCU, 0, 0, 0x42A1045CU

#define IOMUXC_GPIO_B1_12_SAI4_TX_DATA02 0x42A10218U, 0xCU, 0, 0, 0x42A10460U
#define IOMUXC_GPIO_B1_12_NETC_PINMUX_ETH1_RX_ER 0x42A10218U, 0x0U, 0, 0, 0x42A10460U
#define IOMUXC_GPIO_B1_12_NETC_EMDIO 0x42A10218U, 0x1U, 0x42A10798U, 0x6U, 0x42A10460U
#define IOMUXC_GPIO_B1_12_GPIO6_IO12 0x42A10218U, 0x5U, 0, 0, 0x42A10460U
#define IOMUXC_GPIO_B1_12_FLEXSPI1_BUS2BIT_B_DATA01 0x42A10218U, 0x7U, 0x42A10550U, 0x1U, 0x42A10460U
#define IOMUXC_GPIO_B1_12_NETC_PINMUX_ETH4_RX_ER 0x42A10218U, 0x8U, 0, 0, 0x42A10460U
#define IOMUXC_GPIO_B1_12_LPSPI6_PCS0 0x42A10218U, 0x9U, 0x42A10650U, 0x2U, 0x42A10460U

#define IOMUXC_GPIO_B1_13_NETC_PINMUX_ETH1_TX_ER 0x42A1021CU, 0x0U, 0, 0, 0x42A10464U
#define IOMUXC_GPIO_B1_13_NETC_EMDC 0x42A1021CU, 0x1U, 0, 0, 0x42A10464U
#define IOMUXC_GPIO_B1_13_USDHC1_VSELECT 0x42A1021CU, 0x2U, 0, 0, 0x42A10464U
#define IOMUXC_GPIO_B1_13_CCM_ENET_REF_CLK_25M 0x42A1021CU, 0x3U, 0, 0, 0x42A10464U
#define IOMUXC_GPIO_B1_13_GPIO6_IO13 0x42A1021CU, 0x5U, 0, 0, 0x42A10464U
#define IOMUXC_GPIO_B1_13_FLEXSPI1_BUS2BIT_B_DATA00 0x42A1021CU, 0x7U, 0x42A1054CU, 0x1U, 0x42A10464U
#define IOMUXC_GPIO_B1_13_NETC_PINMUX_ETH4_TX_ER 0x42A1021CU, 0x8U, 0, 0, 0x42A10464U
#define IOMUXC_GPIO_B1_13_LPSPI6_SCK 0x42A1021CU, 0x9U, 0x42A10660U, 0x2U, 0x42A10464U
#define IOMUXC_GPIO_B1_13_SAI4_TX_DATA03 0x42A1021CU, 0xCU, 0, 0, 0x42A10464U

#define IOMUXC_GPIO_B2_00_NETC_ETH2_SLV_MDIO 0x42A10220U, 0xAU, 0x42A107A8U, 0x2U, 0x42A10468U
#define IOMUXC_GPIO_B2_00_ECAT_CLK_ECAT_CLK25 0x42A10220U, 0xCU, 0, 0, 0x42A10468U
#define IOMUXC_GPIO_B2_00_NETC_ETH1_CRS 0x42A10220U, 0x0U, 0, 0, 0x42A10468U
#define IOMUXC_GPIO_B2_00_SEMC_CSX03 0x42A10220U, 0x1U, 0, 0, 0x42A10468U
#define IOMUXC_GPIO_B2_00_LPIT3_TRIGGER00 0x42A10220U, 0x2U, 0, 0, 0x42A10468U
#define IOMUXC_GPIO_B2_00_SAI4_MCLK 0x42A10220U, 0x4U, 0x42A108B0U, 0x2U, 0x42A10468U
#define IOMUXC_GPIO_B2_00_GPIO6_IO14 0x42A10220U, 0x5U, 0, 0, 0x42A10468U
#define IOMUXC_GPIO_B2_00_NETC_ETH4_CRS 0x42A10220U, 0x8U, 0x42A107C0U, 0x2U, 0x42A10468U
#define IOMUXC_GPIO_B2_00_LPSPI6_SDI 0x42A10220U, 0x9U, 0x42A10664U, 0x3U, 0x42A10468U

#define IOMUXC_GPIO_B2_01_NETC_ETH2_SLV_MDC 0x42A10224U, 0xAU, 0x42A107A4U, 0x2U, 0x42A1046CU
#define IOMUXC_GPIO_B2_01_NETC_PINMUX_ETH2_RX_ER 0x42A10224U, 0xBU, 0x42A10800U, 0x1U, 0x42A1046CU
#define IOMUXC_GPIO_B2_01_ECAT_RX_ER_1 0x42A10224U, 0xCU, 0x42A104E0U, 0x2U, 0x42A1046CU
#define IOMUXC_GPIO_B2_01_NETC_ETH1_COL 0x42A10224U, 0x0U, 0, 0, 0x42A1046CU
#define IOMUXC_GPIO_B2_01_LPIT3_TRIGGER01 0x42A10224U, 0x2U, 0, 0, 0x42A1046CU
#define IOMUXC_GPIO_B2_01_SAI4_TX_BCLK 0x42A10224U, 0x4U, 0x42A108C4U, 0x2U, 0x42A1046CU
#define IOMUXC_GPIO_B2_01_GPIO6_IO15 0x42A10224U, 0x5U, 0, 0, 0x42A1046CU
#define IOMUXC_GPIO_B2_01_FLEXSPI1_BUS2BIT_A_SS1_B 0x42A10224U, 0x6U, 0, 0, 0x42A1046CU
#define IOMUXC_GPIO_B2_01_NETC_ETH4_COL 0x42A10224U, 0x8U, 0x42A107BCU, 0x2U, 0x42A1046CU
#define IOMUXC_GPIO_B2_01_LPSPI6_SDO 0x42A10224U, 0x9U, 0x42A10668U, 0x3U, 0x42A1046CU

#define IOMUXC_GPIO_B2_02_EWM_EWM_OUT_B 0x42A10228U, 0xAU, 0, 0, 0x42A10470U
#define IOMUXC_GPIO_B2_02_NETC_PINMUX_ETH2_RXD02 0x42A10228U, 0xBU, 0x42A1080CU, 0x2U, 0x42A10470U
#define IOMUXC_GPIO_B2_02_ECAT_RX_DATA2_1 0x42A10228U, 0xCU, 0x42A104C8U, 0x1U, 0x42A10470U
#define IOMUXC_GPIO_B2_02_LPIT3_TRIGGER02 0x42A10228U, 0x2U, 0, 0, 0x42A10470U
#define IOMUXC_GPIO_B2_02_NETC_EMDIO 0x42A10228U, 0x3U, 0x42A10798U, 0x7U, 0x42A10470U
#define IOMUXC_GPIO_B2_02_SAI4_TX_SYNC 0x42A10228U, 0x4U, 0x42A108C8U, 0x2U, 0x42A10470U
#define IOMUXC_GPIO_B2_02_GPIO6_IO16 0x42A10228U, 0x5U, 0, 0, 0x42A10470U
#define IOMUXC_GPIO_B2_02_FLEXSPI1_BUS2BIT_B_SCLK 0x42A10228U, 0x6U, 0x42A1056CU, 0x2U, 0x42A10470U
#define IOMUXC_GPIO_B2_02_CCM_ENET_REF_CLK_25M 0x42A10228U, 0x9U, 0, 0, 0x42A10470U

#define IOMUXC_GPIO_B2_03_XSPI_SLV_DATA04 0x42A1022CU, 0xAU, 0x42A10A18U, 0x2U, 0x42A10474U
#define IOMUXC_GPIO_B2_03_NETC_PINMUX_ETH2_RXD03 0x42A1022CU, 0xBU, 0x42A10810U, 0x2U, 0x42A10474U
#define IOMUXC_GPIO_B2_03_ECAT_RX_DATA3_1 0x42A1022CU, 0xCU, 0x42A104D0U, 0x1U, 0x42A10474U
#define IOMUXC_GPIO_B2_03_LPIT3_TRIGGER03 0x42A1022CU, 0x2U, 0, 0, 0x42A10474U
#define IOMUXC_GPIO_B2_03_NETC_EMDC 0x42A1022CU, 0x3U, 0, 0, 0x42A10474U
#define IOMUXC_GPIO_B2_03_SAI4_TX_DATA00 0x42A1022CU, 0x4U, 0, 0, 0x42A10474U
#define IOMUXC_GPIO_B2_03_GPIO6_IO17 0x42A1022CU, 0x5U, 0, 0, 0x42A10474U
#define IOMUXC_GPIO_B2_03_FLEXSPI1_BUS2BIT_A_DATA04 0x42A1022CU, 0x7U, 0, 0, 0x42A10474U

#define IOMUXC_GPIO_B2_04_XSPI_SLV_DATA05 0x42A10230U, 0xAU, 0x42A10A1CU, 0x2U, 0x42A10478U
#define IOMUXC_GPIO_B2_04_NETC_PINMUX_ETH2_TXD02 0x42A10230U, 0xBU, 0, 0, 0x42A10478U
#define IOMUXC_GPIO_B2_04_ECAT_TX_DATA2_1 0x42A10230U, 0xCU, 0, 0, 0x42A10478U
#define IOMUXC_GPIO_B2_04_SINC1_MOD_CLK0 0x42A10230U, 0x0U, 0, 0, 0x42A10478U
#define IOMUXC_GPIO_B2_04_SINC2_MOD_CLK0 0x42A10230U, 0x1U, 0, 0, 0x42A10478U
#define IOMUXC_GPIO_B2_04_SINC3_MOD_CLK0 0x42A10230U, 0x2U, 0, 0, 0x42A10478U
#define IOMUXC_GPIO_B2_04_SAI4_RX_SYNC 0x42A10230U, 0x4U, 0x42A108C0U, 0x2U, 0x42A10478U
#define IOMUXC_GPIO_B2_04_GPIO6_IO18 0x42A10230U, 0x5U, 0, 0, 0x42A10478U
#define IOMUXC_GPIO_B2_04_FLEXSPI1_BUS2BIT_A_DATA05 0x42A10230U, 0x7U, 0, 0, 0x42A10478U
#define IOMUXC_GPIO_B2_04_TPM3_EXTCLK 0x42A10230U, 0x8U, 0, 0, 0x42A10478U

#define IOMUXC_GPIO_B2_05_XSPI_SLV_DATA06 0x42A10234U, 0xAU, 0x42A10A20U, 0x2U, 0x42A1047CU
#define IOMUXC_GPIO_B2_05_NETC_PINMUX_ETH2_TXD03 0x42A10234U, 0xBU, 0, 0, 0x42A1047CU
#define IOMUXC_GPIO_B2_05_ECAT_TX_DATA3_1 0x42A10234U, 0xCU, 0, 0, 0x42A1047CU
#define IOMUXC_GPIO_B2_05_SINC1_MOD_CLK1 0x42A10234U, 0x0U, 0, 0, 0x42A1047CU
#define IOMUXC_GPIO_B2_05_SINC2_MOD_CLK1 0x42A10234U, 0x1U, 0, 0, 0x42A1047CU
#define IOMUXC_GPIO_B2_05_SINC3_MOD_CLK1 0x42A10234U, 0x2U, 0, 0, 0x42A1047CU
#define IOMUXC_GPIO_B2_05_SAI4_RX_BCLK 0x42A10234U, 0x4U, 0x42A108B4U, 0x2U, 0x42A1047CU
#define IOMUXC_GPIO_B2_05_GPIO6_IO19 0x42A10234U, 0x5U, 0, 0, 0x42A1047CU
#define IOMUXC_GPIO_B2_05_MIC_CLK 0x42A10234U, 0x6U, 0, 0, 0x42A1047CU
#define IOMUXC_GPIO_B2_05_FLEXSPI1_BUS2BIT_A_DATA06 0x42A10234U, 0x7U, 0, 0, 0x42A1047CU
#define IOMUXC_GPIO_B2_05_TPM3_CH00 0x42A10234U, 0x8U, 0, 0, 0x42A1047CU

#define IOMUXC_GPIO_B2_06_XSPI_SLV_DATA07 0x42A10238U, 0xAU, 0x42A10A24U, 0x2U, 0x42A10480U
#define IOMUXC_GPIO_B2_06_NETC_PINMUX_ETH2_TXD00 0x42A10238U, 0xBU, 0, 0, 0x42A10480U
#define IOMUXC_GPIO_B2_06_ECAT_TX_DATA0_1 0x42A10238U, 0xCU, 0, 0, 0x42A10480U
#define IOMUXC_GPIO_B2_06_SINC1_MOD_CLK2 0x42A10238U, 0x0U, 0, 0, 0x42A10480U
#define IOMUXC_GPIO_B2_06_SINC2_MOD_CLK2 0x42A10238U, 0x1U, 0, 0, 0x42A10480U
#define IOMUXC_GPIO_B2_06_SINC3_MOD_CLK2 0x42A10238U, 0x2U, 0, 0, 0x42A10480U
#define IOMUXC_GPIO_B2_06_LPUART6_DSR_B 0x42A10238U, 0x3U, 0x42A106ACU, 0x1U, 0x42A10480U
#define IOMUXC_GPIO_B2_06_SAI4_RX_DATA00 0x42A10238U, 0x4U, 0x42A108B8U, 0x2U, 0x42A10480U
#define IOMUXC_GPIO_B2_06_GPIO6_IO20 0x42A10238U, 0x5U, 0, 0, 0x42A10480U
#define IOMUXC_GPIO_B2_06_FLEXSPI1_BUS2BIT_A_DATA07 0x42A10238U, 0x7U, 0, 0, 0x42A10480U
#define IOMUXC_GPIO_B2_06_TPM3_CH01 0x42A10238U, 0x8U, 0, 0, 0x42A10480U
#define IOMUXC_GPIO_B2_06_LPUART11_TX 0x42A10238U, 0x9U, 0x42A10678U, 0x2U, 0x42A10480U

#define IOMUXC_GPIO_B2_07_XSPI_SLV_DQS 0x42A1023CU, 0xAU, 0x42A10A04U, 0x1U, 0x42A10484U
#define IOMUXC_GPIO_B2_07_NETC_PINMUX_ETH2_TXD01 0x42A1023CU, 0xBU, 0, 0, 0x42A10484U
#define IOMUXC_GPIO_B2_07_ECAT_TX_DATA1_1 0x42A1023CU, 0xCU, 0, 0, 0x42A10484U
#define IOMUXC_GPIO_B2_07_QTIMER5_TIMER0 0x42A1023CU, 0x0U, 0x42A10888U, 0x2U, 0x42A10484U
#define IOMUXC_GPIO_B2_07_LPUART6_DCD_B 0x42A1023CU, 0x3U, 0x42A106A8U, 0x1U, 0x42A10484U
#define IOMUXC_GPIO_B2_07_SAI4_TX_DATA01 0x42A1023CU, 0x4U, 0, 0, 0x42A10484U
#define IOMUXC_GPIO_B2_07_GPIO6_IO21 0x42A1023CU, 0x5U, 0, 0, 0x42A10484U
#define IOMUXC_GPIO_B2_07_SAI4_RX_DATA01 0x42A1023CU, 0x6U, 0x42A108BCU, 0x1U, 0x42A10484U
#define IOMUXC_GPIO_B2_07_FLEXSPI1_BUS2BIT_A_DQS 0x42A1023CU, 0x7U, 0x42A10544U, 0x1U, 0x42A10484U
#define IOMUXC_GPIO_B2_07_TPM3_CH02 0x42A1023CU, 0x8U, 0, 0, 0x42A10484U
#define IOMUXC_GPIO_B2_07_LPUART11_RX 0x42A1023CU, 0x9U, 0x42A10674U, 0x2U, 0x42A10484U

#define IOMUXC_GPIO_B2_08_XSPI_SLV_CLK 0x42A10240U, 0xAU, 0x42A10A28U, 0x2U, 0x42A10488U
#define IOMUXC_GPIO_B2_08_NETC_PINMUX_ETH2_TX_EN 0x42A10240U, 0xBU, 0, 0, 0x42A10488U
#define IOMUXC_GPIO_B2_08_ECAT_TX_EN_1 0x42A10240U, 0xCU, 0, 0, 0x42A10488U
#define IOMUXC_GPIO_B2_08_QTIMER5_TIMER1 0x42A10240U, 0x0U, 0x42A1088CU, 0x2U, 0x42A10488U
#define IOMUXC_GPIO_B2_08_SINC2_EMCLK02 0x42A10240U, 0x1U, 0x42A10900U, 0x2U, 0x42A10488U
#define IOMUXC_GPIO_B2_08_LPUART6_RI_B 0x42A10240U, 0x4U, 0x42A106B0U, 0x1U, 0x42A10488U
#define IOMUXC_GPIO_B2_08_GPIO6_IO22 0x42A10240U, 0x5U, 0, 0, 0x42A10488U
#define IOMUXC_GPIO_B2_08_LPI2C6_SCL 0x42A10240U, 0x6U, 0x42A10600U, 0x1U, 0x42A10488U
#define IOMUXC_GPIO_B2_08_FLEXSPI1_BUS2BIT_A_SCLK 0x42A10240U, 0x7U, 0, 0, 0x42A10488U
#define IOMUXC_GPIO_B2_08_TPM3_CH03 0x42A10240U, 0x8U, 0, 0, 0x42A10488U
#define IOMUXC_GPIO_B2_08_SPDIF_IN 0x42A10240U, 0x9U, 0x42A10908U, 0x2U, 0x42A10488U

#define IOMUXC_GPIO_B2_09_XSPI_SLV_CS 0x42A10244U, 0xAU, 0x42A10A00U, 0x2U, 0x42A1048CU
#define IOMUXC_GPIO_B2_09_NETC_PINMUX_ETH2_TX_CLK 0x42A10244U, 0xBU, 0x42A10814U, 0x2U, 0x42A1048CU
#define IOMUXC_GPIO_B2_09_ECAT_TX_CLK_1 0x42A10244U, 0xCU, 0x42A104E8U, 0x2U, 0x42A1048CU
#define IOMUXC_GPIO_B2_09_QTIMER5_TIMER2 0x42A10244U, 0x0U, 0x42A10890U, 0x1U, 0x42A1048CU
#define IOMUXC_GPIO_B2_09_SINC2_EMBIT02 0x42A10244U, 0x1U, 0x42A108F4U, 0x2U, 0x42A1048CU
#define IOMUXC_GPIO_B2_09_LPUART6_DTR_B 0x42A10244U, 0x4U, 0, 0, 0x42A1048CU
#define IOMUXC_GPIO_B2_09_GPIO6_IO23 0x42A10244U, 0x5U, 0, 0, 0x42A1048CU
#define IOMUXC_GPIO_B2_09_LPI2C6_SDA 0x42A10244U, 0x6U, 0x42A10604U, 0x1U, 0x42A1048CU
#define IOMUXC_GPIO_B2_09_FLEXSPI1_BUS2BIT_A_SS0_B 0x42A10244U, 0x7U, 0, 0, 0x42A1048CU
#define IOMUXC_GPIO_B2_09_TPM4_EXTCLK 0x42A10244U, 0x8U, 0, 0, 0x42A1048CU
#define IOMUXC_GPIO_B2_09_SPDIF_OUT 0x42A10244U, 0x9U, 0, 0, 0x42A1048CU

#define IOMUXC_GPIO_B2_10_XSPI_SLV_DATA00 0x42A10248U, 0xAU, 0x42A10A08U, 0x1U, 0x42A10490U
#define IOMUXC_GPIO_B2_10_NETC_PINMUX_ETH2_RXD00 0x42A10248U, 0xBU, 0x42A10804U, 0x2U, 0x42A10490U
#define IOMUXC_GPIO_B2_10_ECAT_RX_DATA0_1 0x42A10248U, 0xCU, 0x42A104B8U, 0x2U, 0x42A10490U
#define IOMUXC_GPIO_B2_10_MIC_BITSTREAM00 0x42A10248U, 0x0U, 0x42A106D0U, 0x3U, 0x42A10490U
#define IOMUXC_GPIO_B2_10_SINC2_EMCLK03 0x42A10248U, 0x1U, 0x42A10904U, 0x1U, 0x42A10490U
#define IOMUXC_GPIO_B2_10_CAN3_TX 0x42A10248U, 0x2U, 0, 0, 0x42A10490U
#define IOMUXC_GPIO_B2_10_LPUART8_CTS_B 0x42A10248U, 0x3U, 0x42A106BCU, 0x1U, 0x42A10490U
#define IOMUXC_GPIO_B2_10_LPUART6_TX 0x42A10248U, 0x4U, 0x42A106B8U, 0x2U, 0x42A10490U
#define IOMUXC_GPIO_B2_10_GPIO6_IO24 0x42A10248U, 0x5U, 0, 0, 0x42A10490U
#define IOMUXC_GPIO_B2_10_LPI2C4_SCL 0x42A10248U, 0x6U, 0x42A105F0U, 0x1U, 0x42A10490U
#define IOMUXC_GPIO_B2_10_FLEXSPI1_BUS2BIT_A_DATA00 0x42A10248U, 0x7U, 0, 0, 0x42A10490U
#define IOMUXC_GPIO_B2_10_TPM4_CH00 0x42A10248U, 0x8U, 0, 0, 0x42A10490U
#define IOMUXC_GPIO_B2_10_LPSPI4_SCK 0x42A10248U, 0x9U, 0x42A10628U, 0x2U, 0x42A10490U

#define IOMUXC_GPIO_B2_11_XSPI_SLV_DATA01 0x42A1024CU, 0xAU, 0x42A10A0CU, 0x1U, 0x42A10494U
#define IOMUXC_GPIO_B2_11_NETC_PINMUX_ETH2_RXD01 0x42A1024CU, 0xBU, 0x42A10808U, 0x2U, 0x42A10494U
#define IOMUXC_GPIO_B2_11_ECAT_RX_DATA1_1 0x42A1024CU, 0xCU, 0x42A104C0U, 0x2U, 0x42A10494U
#define IOMUXC_GPIO_B2_11_MIC_BITSTREAM01 0x42A1024CU, 0x0U, 0x42A106D4U, 0x3U, 0x42A10494U
#define IOMUXC_GPIO_B2_11_SINC2_EMBIT03 0x42A1024CU, 0x1U, 0x42A108F8U, 0x1U, 0x42A10494U
#define IOMUXC_GPIO_B2_11_CAN3_RX 0x42A1024CU, 0x2U, 0x42A104A8U, 0x1U, 0x42A10494U
#define IOMUXC_GPIO_B2_11_LPUART8_RTS_B 0x42A1024CU, 0x3U, 0, 0, 0x42A10494U
#define IOMUXC_GPIO_B2_11_LPUART6_RX 0x42A1024CU, 0x4U, 0x42A106B4U, 0x2U, 0x42A10494U
#define IOMUXC_GPIO_B2_11_GPIO6_IO25 0x42A1024CU, 0x5U, 0, 0, 0x42A10494U
#define IOMUXC_GPIO_B2_11_LPI2C4_SDA 0x42A1024CU, 0x6U, 0x42A105F4U, 0x1U, 0x42A10494U
#define IOMUXC_GPIO_B2_11_FLEXSPI1_BUS2BIT_A_DATA01 0x42A1024CU, 0x7U, 0, 0, 0x42A10494U
#define IOMUXC_GPIO_B2_11_TPM4_CH01 0x42A1024CU, 0x8U, 0, 0, 0x42A10494U
#define IOMUXC_GPIO_B2_11_LPSPI4_SDI 0x42A1024CU, 0x9U, 0x42A1062CU, 0x2U, 0x42A10494U

#define IOMUXC_GPIO_B2_12_MIC_BITSTREAM02 0x42A10250U, 0x0U, 0x42A106D8U, 0x3U, 0x42A10498U
#define IOMUXC_GPIO_B2_12_SINC_FILTER_GLUE2_BREAK 0x42A10250U, 0x1U, 0, 0, 0x42A10498U
#define IOMUXC_GPIO_B2_12_LPUART8_TX 0x42A10250U, 0x2U, 0x42A106C4U, 0x2U, 0x42A10498U
#define IOMUXC_GPIO_B2_12_LPUART6_CTS_B 0x42A10250U, 0x4U, 0x42A106A4U, 0x2U, 0x42A10498U
#define IOMUXC_GPIO_B2_12_GPIO6_IO26 0x42A10250U, 0x5U, 0, 0, 0x42A10498U
#define IOMUXC_GPIO_B2_12_CAN3_TX 0x42A10250U, 0x6U, 0, 0, 0x42A10498U
#define IOMUXC_GPIO_B2_12_FLEXSPI1_BUS2BIT_A_DATA02 0x42A10250U, 0x7U, 0, 0, 0x42A10498U
#define IOMUXC_GPIO_B2_12_TPM4_CH02 0x42A10250U, 0x8U, 0, 0, 0x42A10498U
#define IOMUXC_GPIO_B2_12_LPSPI4_SDO 0x42A10250U, 0x9U, 0x42A10630U, 0x2U, 0x42A10498U
#define IOMUXC_GPIO_B2_12_XSPI_SLV_DATA02 0x42A10250U, 0xAU, 0x42A10A10U, 0x1U, 0x42A10498U
#define IOMUXC_GPIO_B2_12_NETC_PINMUX_ETH2_RX_DV 0x42A10250U, 0xBU, 0x42A107FCU, 0x2U, 0x42A10498U
#define IOMUXC_GPIO_B2_12_ECAT_RX_DV_1 0x42A10250U, 0xCU, 0x42A104D8U, 0x2U, 0x42A10498U

#define IOMUXC_GPIO_B2_13_MIC_BITSTREAM03 0x42A10254U, 0x0U, 0x42A106DCU, 0x3U, 0x42A1049CU
#define IOMUXC_GPIO_B2_13_SINC2_EMCLK00 0x42A10254U, 0x1U, 0x42A108FCU, 0x1U, 0x42A1049CU
#define IOMUXC_GPIO_B2_13_LPUART8_RX 0x42A10254U, 0x2U, 0x42A106C0U, 0x2U, 0x42A1049CU
#define IOMUXC_GPIO_B2_13_LPUART6_RTS_B 0x42A10254U, 0x4U, 0, 0, 0x42A1049CU
#define IOMUXC_GPIO_B2_13_GPIO6_IO27 0x42A10254U, 0x5U, 0, 0, 0x42A1049CU
#define IOMUXC_GPIO_B2_13_CAN3_RX 0x42A10254U, 0x6U, 0x42A104A8U, 0x2U, 0x42A1049CU
#define IOMUXC_GPIO_B2_13_FLEXSPI1_BUS2BIT_A_DATA03 0x42A10254U, 0x7U, 0, 0, 0x42A1049CU
#define IOMUXC_GPIO_B2_13_TPM4_CH03 0x42A10254U, 0x8U, 0, 0, 0x42A1049CU
#define IOMUXC_GPIO_B2_13_LPSPI4_PCS0 0x42A10254U, 0x9U, 0x42A10624U, 0x2U, 0x42A1049CU
#define IOMUXC_GPIO_B2_13_XSPI_SLV_DATA03 0x42A10254U, 0xAU, 0x42A10A14U, 0x1U, 0x42A1049CU
#define IOMUXC_GPIO_B2_13_NETC_PINMUX_ETH2_RX_CLK 0x42A10254U, 0xBU, 0x42A107F8U, 0x3U, 0x42A1049CU
#define IOMUXC_GPIO_B2_13_ECAT_RX_CLK_1 0x42A10254U, 0xCU, 0x42A104B0U, 0x1U, 0x42A1049CU

#define IOMUXC_GPIO_AON_00_SRC_BOOT_MODE00 0x443C0000U, 0x0U, 0, 0, 0x443C0074U
#define IOMUXC_GPIO_AON_00_CAN1_TX 0x443C0000U, 0x1U, 0, 0, 0x443C0074U
#define IOMUXC_GPIO_AON_00_LPTMR1_ALT1 0x443C0000U, 0x4U, 0x443C012CU, 0x0U, 0x443C0074U
#define IOMUXC_GPIO_AON_00_GPIO1_IO00 0x443C0000U, 0x5U, 0, 0, 0x443C0074U
#define IOMUXC_GPIO_AON_00_LPUART2_TX 0x443C0000U, 0x6U, 0x443C0158U, 0x0U, 0x443C0074U
#define IOMUXC_GPIO_AON_00_TPM1_EXTCLK 0x443C0000U, 0x8U, 0, 0, 0x443C0074U

#define IOMUXC_GPIO_AON_01_SRC_BOOT_MODE01 0x443C0004U, 0x0U, 0, 0, 0x443C0078U
#define IOMUXC_GPIO_AON_01_CAN1_RX 0x443C0004U, 0x1U, 0x42A104A0U, 0x1U, 0x443C0078U
#define IOMUXC_GPIO_AON_01_LPTMR1_ALT2 0x443C0004U, 0x4U, 0x443C0130U, 0x0U, 0x443C0078U
#define IOMUXC_GPIO_AON_01_GPIO1_IO01 0x443C0004U, 0x5U, 0, 0, 0x443C0078U
#define IOMUXC_GPIO_AON_01_LPUART2_RX 0x443C0004U, 0x6U, 0x443C0154U, 0x0U, 0x443C0078U
#define IOMUXC_GPIO_AON_01_TPM1_CH00 0x443C0004U, 0x8U, 0, 0, 0x443C0078U

#define IOMUXC_GPIO_AON_02_SRC_BOOT_MODE02 0x443C0008U, 0x0U, 0, 0, 0x443C007CU
#define IOMUXC_GPIO_AON_02_CAN3_TX 0x443C0008U, 0x1U, 0, 0, 0x443C007CU
#define IOMUXC_GPIO_AON_02_LPSPI2_PCS3 0x443C0008U, 0x2U, 0x443C011CU, 0x0U, 0x443C007CU
#define IOMUXC_GPIO_AON_02_LPSPI2_SDO 0x443C0008U, 0x3U, 0x443C0128U, 0x0U, 0x443C007CU
#define IOMUXC_GPIO_AON_02_LPTMR1_ALT3 0x443C0008U, 0x4U, 0x443C0134U, 0x0U, 0x443C007CU
#define IOMUXC_GPIO_AON_02_GPIO1_IO02 0x443C0008U, 0x5U, 0, 0, 0x443C007CU
#define IOMUXC_GPIO_AON_02_LPUART2_RTS_B 0x443C0008U, 0x6U, 0, 0, 0x443C007CU
#define IOMUXC_GPIO_AON_02_TPM1_CH01 0x443C0008U, 0x8U, 0, 0, 0x443C007CU
#define IOMUXC_GPIO_AON_02_ECAT_CLK_ECAT_CLK25 0x443C0008U, 0xCU, 0, 0, 0x443C007CU

#define IOMUXC_GPIO_AON_03_CAN3_RX 0x443C000CU, 0x1U, 0x42A104A8U, 0x3U, 0x443C0080U
#define IOMUXC_GPIO_AON_03_LPSPI1_PCS1 0x443C000CU, 0x2U, 0x443C0104U, 0x0U, 0x443C0080U
#define IOMUXC_GPIO_AON_03_LPSPI2_SDI 0x443C000CU, 0x3U, 0x443C0124U, 0x0U, 0x443C0080U
#define IOMUXC_GPIO_AON_03_LPSPI1_PCS3 0x443C000CU, 0x4U, 0, 0, 0x443C0080U
#define IOMUXC_GPIO_AON_03_GPIO1_IO03 0x443C000CU, 0x5U, 0, 0, 0x443C0080U
#define IOMUXC_GPIO_AON_03_LPUART2_CTS_B 0x443C000CU, 0x6U, 0x443C0150U, 0x0U, 0x443C0080U
#define IOMUXC_GPIO_AON_03_TPM1_CH02 0x443C000CU, 0x8U, 0, 0, 0x443C0080U
#define IOMUXC_GPIO_AON_03_ECAT_LED_STATE_RUN 0x443C000CU, 0xCU, 0, 0, 0x443C0080U

#define IOMUXC_GPIO_AON_04_ECAT_LED_RUN 0x443C0010U, 0xCU, 0, 0, 0x443C0084U
#define IOMUXC_GPIO_AON_04_LPSPI1_SCK 0x443C0010U, 0x0U, 0x443C0108U, 0x0U, 0x443C0084U
#define IOMUXC_GPIO_AON_04_SAI1_TX_DATA00 0x443C0010U, 0x2U, 0, 0, 0x443C0084U
#define IOMUXC_GPIO_AON_04_SAI1_RX_DATA01 0x443C0010U, 0x3U, 0x443C0174U, 0x0U, 0x443C0084U
#define IOMUXC_GPIO_AON_04_GPIO1_IO04 0x443C0010U, 0x5U, 0, 0, 0x443C0084U
#define IOMUXC_GPIO_AON_04_LPUART7_CTS_B 0x443C0010U, 0x6U, 0x443C015CU, 0x0U, 0x443C0084U
#define IOMUXC_GPIO_AON_04_TPM1_CH03 0x443C0010U, 0x8U, 0, 0, 0x443C0084U

#define IOMUXC_GPIO_AON_05_LPSPI1_PCS0 0x443C0014U, 0x0U, 0x443C0100U, 0x0U, 0x443C0088U
#define IOMUXC_GPIO_AON_05_SAI1_TX_SYNC 0x443C0014U, 0x2U, 0x443C0180U, 0x0U, 0x443C0088U
#define IOMUXC_GPIO_AON_05_GPIO1_IO05 0x443C0014U, 0x5U, 0, 0, 0x443C0088U
#define IOMUXC_GPIO_AON_05_LPUART7_RTS_B 0x443C0014U, 0x6U, 0, 0, 0x443C0088U
#define IOMUXC_GPIO_AON_05_NMI_GLUE_NMI 0x443C0014U, 0x7U, 0, 0, 0x443C0088U
#define IOMUXC_GPIO_AON_05_ECAT_LED_ERR 0x443C0014U, 0xCU, 0, 0, 0x443C0088U

#define IOMUXC_GPIO_AON_06_LPSPI1_SDO 0x443C0018U, 0x0U, 0x443C0110U, 0x0U, 0x443C008CU
#define IOMUXC_GPIO_AON_06_I3C1_PUR 0x443C0018U, 0x1U, 0, 0, 0x443C008CU
#define IOMUXC_GPIO_AON_06_SAI1_TX_BCLK 0x443C0018U, 0x2U, 0x443C017CU, 0x0U, 0x443C008CU
#define IOMUXC_GPIO_AON_06_LPI2C1_SDA 0x443C0018U, 0x3U, 0x443C00F4U, 0x0U, 0x443C008CU
#define IOMUXC_GPIO_AON_06_GPIO1_IO06 0x443C0018U, 0x5U, 0, 0, 0x443C008CU
#define IOMUXC_GPIO_AON_06_CAN1_TX 0x443C0018U, 0x6U, 0, 0, 0x443C008CU
#define IOMUXC_GPIO_AON_06_ECAT_SDA 0x443C0018U, 0xCU, 0x42A104F0U, 0x1U, 0x443C008CU

#define IOMUXC_GPIO_AON_07_ECAT_SCL 0x443C001CU, 0xCU, 0, 0, 0x443C0090U
#define IOMUXC_GPIO_AON_07_LPSPI1_SDI 0x443C001CU, 0x0U, 0x443C010CU, 0x0U, 0x443C0090U
#define IOMUXC_GPIO_AON_07_SAI1_MCLK 0x443C001CU, 0x2U, 0x443C0168U, 0x0U, 0x443C0090U
#define IOMUXC_GPIO_AON_07_LPI2C1_SCL 0x443C001CU, 0x3U, 0x443C00F0U, 0x0U, 0x443C0090U
#define IOMUXC_GPIO_AON_07_GPIO1_IO07 0x443C001CU, 0x5U, 0, 0, 0x443C0090U
#define IOMUXC_GPIO_AON_07_CAN1_RX 0x443C001CU, 0x6U, 0x42A104A0U, 0x2U, 0x443C0090U

#define IOMUXC_GPIO_AON_08_LPUART1_TX 0x443C0020U, 0x0U, 0, 0, 0x443C0094U
#define IOMUXC_GPIO_AON_08_S400_TX 0x443C0020U, 0x1U, 0, 0, 0x443C0094U
#define IOMUXC_GPIO_AON_08_SAI1_RX_DATA00 0x443C0020U, 0x2U, 0x443C0170U, 0x0U, 0x443C0094U
#define IOMUXC_GPIO_AON_08_SAI1_TX_DATA01 0x443C0020U, 0x3U, 0, 0, 0x443C0094U
#define IOMUXC_GPIO_AON_08_GPIO1_IO08 0x443C0020U, 0x5U, 0, 0, 0x443C0094U
#define IOMUXC_GPIO_AON_08_LPI2C1_SDA 0x443C0020U, 0x6U, 0x443C00F4U, 0x1U, 0x443C0094U
#define IOMUXC_GPIO_AON_08_LPSPI1_PCS1 0x443C0020U, 0x8U, 0x443C0104U, 0x1U, 0x443C0094U
#define IOMUXC_GPIO_AON_08_ECAT_LINK_ACT00 0x443C0020U, 0xCU, 0, 0, 0x443C0094U

#define IOMUXC_GPIO_AON_09_LPUART1_RX 0x443C0024U, 0x0U, 0, 0, 0x443C0098U
#define IOMUXC_GPIO_AON_09_S400_RX 0x443C0024U, 0x1U, 0, 0, 0x443C0098U
#define IOMUXC_GPIO_AON_09_SAI1_RX_BCLK 0x443C0024U, 0x2U, 0x443C016CU, 0x0U, 0x443C0098U
#define IOMUXC_GPIO_AON_09_LPIT1_TRIGGER00 0x443C0024U, 0x3U, 0, 0, 0x443C0098U
#define IOMUXC_GPIO_AON_09_GPIO1_IO09 0x443C0024U, 0x5U, 0, 0, 0x443C0098U
#define IOMUXC_GPIO_AON_09_LPI2C1_SCL 0x443C0024U, 0x6U, 0x443C00F0U, 0x1U, 0x443C0098U
#define IOMUXC_GPIO_AON_09_LPSPI1_PCS2 0x443C0024U, 0x8U, 0, 0, 0x443C0098U
#define IOMUXC_GPIO_AON_09_ECAT_LINK_ACT01 0x443C0024U, 0xCU, 0, 0, 0x443C0098U

#define IOMUXC_GPIO_AON_10_JTAG_MUX_TRSTB 0x443C0028U, 0x0U, 0, 0, 0x443C009CU
#define IOMUXC_GPIO_AON_10_LPSPI2_PCS0 0x443C0028U, 0x1U, 0x443C0114U, 0x0U, 0x443C009CU
#define IOMUXC_GPIO_AON_10_SAI1_RX_SYNC 0x443C0028U, 0x2U, 0x443C0178U, 0x0U, 0x443C009CU
#define IOMUXC_GPIO_AON_10_LPIT1_TRIGGER01 0x443C0028U, 0x3U, 0, 0, 0x443C009CU
#define IOMUXC_GPIO_AON_10_TPM2_EXTCLK 0x443C0028U, 0x4U, 0, 0, 0x443C009CU
#define IOMUXC_GPIO_AON_10_GPIO1_IO10 0x443C0028U, 0x5U, 0, 0, 0x443C009CU
#define IOMUXC_GPIO_AON_10_LPI2C1_SCLS 0x443C0028U, 0x6U, 0, 0, 0x443C009CU

#define IOMUXC_GPIO_AON_11_JTAG_MUX_TDO 0x443C002CU, 0x0U, 0, 0, 0x443C00A0U
#define IOMUXC_GPIO_AON_11_LPUART1_CTS_B 0x443C002CU, 0x2U, 0x443C0138U, 0x0U, 0x443C00A0U
#define IOMUXC_GPIO_AON_11_LPIT1_TRIGGER02 0x443C002CU, 0x3U, 0, 0, 0x443C00A0U
#define IOMUXC_GPIO_AON_11_TPM2_CH00 0x443C002CU, 0x4U, 0, 0, 0x443C00A0U
#define IOMUXC_GPIO_AON_11_GPIO1_IO11 0x443C002CU, 0x5U, 0, 0, 0x443C00A0U
#define IOMUXC_GPIO_AON_11_LPI2C1_SDAS 0x443C002CU, 0x6U, 0, 0, 0x443C00A0U

#define IOMUXC_GPIO_AON_12_JTAG_MUX_TDI 0x443C0030U, 0x0U, 0, 0, 0x443C00A4U
#define IOMUXC_GPIO_AON_12_LPUART1_RTS_B 0x443C0030U, 0x2U, 0, 0, 0x443C00A4U
#define IOMUXC_GPIO_AON_12_LPIT1_TRIGGER03 0x443C0030U, 0x3U, 0, 0, 0x443C00A4U
#define IOMUXC_GPIO_AON_12_TPM2_CH01 0x443C0030U, 0x4U, 0, 0, 0x443C00A4U
#define IOMUXC_GPIO_AON_12_GPIO1_IO12 0x443C0030U, 0x5U, 0, 0, 0x443C00A4U
#define IOMUXC_GPIO_AON_12_LPI2C1_HREQ 0x443C0030U, 0x6U, 0, 0, 0x443C00A4U
#define IOMUXC_GPIO_AON_12_LPSPI1_SCK 0x443C0030U, 0x8U, 0x443C0108U, 0x1U, 0x443C00A4U

#define IOMUXC_GPIO_AON_13_JTAG_MUX_TCK 0x443C0034U, 0x0U, 0, 0, 0x443C00A8U
#define IOMUXC_GPIO_AON_13_LPUART12_CTS_B 0x443C0034U, 0x2U, 0x443C0144U, 0x0U, 0x443C00A8U
#define IOMUXC_GPIO_AON_13_LPUART1_DSR_B 0x443C0034U, 0x3U, 0x443C0140U, 0x0U, 0x443C00A8U
#define IOMUXC_GPIO_AON_13_TPM2_CH02 0x443C0034U, 0x4U, 0, 0, 0x443C00A8U
#define IOMUXC_GPIO_AON_13_GPIO1_IO13 0x443C0034U, 0x5U, 0, 0, 0x443C00A8U
#define IOMUXC_GPIO_AON_13_LPTMR1_ALT1 0x443C0034U, 0x6U, 0x443C012CU, 0x1U, 0x443C00A8U
#define IOMUXC_GPIO_AON_13_LPSPI1_PCS0 0x443C0034U, 0x8U, 0x443C0100U, 0x1U, 0x443C00A8U

#define IOMUXC_GPIO_AON_14_JTAG_MUX_TMS 0x443C0038U, 0x0U, 0, 0, 0x443C00ACU
#define IOMUXC_GPIO_AON_14_LPUART12_RTS_B 0x443C0038U, 0x2U, 0, 0, 0x443C00ACU
#define IOMUXC_GPIO_AON_14_LPUART1_DCD_B 0x443C0038U, 0x3U, 0x443C013CU, 0x0U, 0x443C00ACU
#define IOMUXC_GPIO_AON_14_TPM2_CH03 0x443C0038U, 0x4U, 0, 0, 0x443C00ACU
#define IOMUXC_GPIO_AON_14_GPIO1_IO14 0x443C0038U, 0x5U, 0, 0, 0x443C00ACU
#define IOMUXC_GPIO_AON_14_LPTMR1_ALT2 0x443C0038U, 0x6U, 0x443C0130U, 0x1U, 0x443C00ACU
#define IOMUXC_GPIO_AON_14_LPSPI1_SDO 0x443C0038U, 0x8U, 0x443C0110U, 0x1U, 0x443C00ACU

#define IOMUXC_GPIO_AON_15_FLEXSPI2_BUS2BIT_B_DATA03 0x443C003CU, 0x0U, 0x42A10594U, 0x2U, 0x443C00B0U
#define IOMUXC_GPIO_AON_15_LPSPI2_PCS1 0x443C003CU, 0x1U, 0x443C0118U, 0x0U, 0x443C00B0U
#define IOMUXC_GPIO_AON_15_LPUART12_TX 0x443C003CU, 0x2U, 0x443C014CU, 0x0U, 0x443C00B0U
#define IOMUXC_GPIO_AON_15_LPUART1_RI_B 0x443C003CU, 0x3U, 0, 0, 0x443C00B0U
#define IOMUXC_GPIO_AON_15_LPI2C2_SDA 0x443C003CU, 0x4U, 0x443C00FCU, 0x0U, 0x443C00B0U
#define IOMUXC_GPIO_AON_15_GPIO1_IO15 0x443C003CU, 0x5U, 0, 0, 0x443C00B0U
#define IOMUXC_GPIO_AON_15_LPTMR1_ALT3 0x443C003CU, 0x6U, 0x443C0134U, 0x1U, 0x443C00B0U
#define IOMUXC_GPIO_AON_15_LPSPI1_SDI 0x443C003CU, 0x8U, 0x443C010CU, 0x1U, 0x443C00B0U
#define IOMUXC_GPIO_AON_15_I3C1_SDA 0x443C003CU, 0x9U, 0x443C00ECU, 0x0U, 0x443C00B0U

#define IOMUXC_GPIO_AON_16_FLEXSPI2_BUS2BIT_B_DATA02 0x443C0040U, 0x0U, 0x42A10590U, 0x2U, 0x443C00B4U
#define IOMUXC_GPIO_AON_16_LPSPI2_PCS0 0x443C0040U, 0x1U, 0x443C0114U, 0x1U, 0x443C00B4U
#define IOMUXC_GPIO_AON_16_LPUART12_RX 0x443C0040U, 0x2U, 0x443C0148U, 0x0U, 0x443C00B4U
#define IOMUXC_GPIO_AON_16_LPUART1_DTR_B 0x443C0040U, 0x3U, 0, 0, 0x443C00B4U
#define IOMUXC_GPIO_AON_16_LPI2C2_SCL 0x443C0040U, 0x4U, 0x443C00F8U, 0x0U, 0x443C00B4U
#define IOMUXC_GPIO_AON_16_GPIO1_IO16 0x443C0040U, 0x5U, 0, 0, 0x443C00B4U
#define IOMUXC_GPIO_AON_16_CAN1_TX 0x443C0040U, 0x6U, 0, 0, 0x443C00B4U
#define IOMUXC_GPIO_AON_16_LPUART7_CTS_B 0x443C0040U, 0x8U, 0x443C015CU, 0x1U, 0x443C00B4U
#define IOMUXC_GPIO_AON_16_I3C1_SCL 0x443C0040U, 0x9U, 0x443C00E8U, 0x0U, 0x443C00B4U

#define IOMUXC_GPIO_AON_17_FLEXSPI2_BUS2BIT_B_DATA01 0x443C0044U, 0x0U, 0x42A1058CU, 0x2U, 0x443C00B8U
#define IOMUXC_GPIO_AON_17_LPSPI2_SDI 0x443C0044U, 0x1U, 0x443C0124U, 0x1U, 0x443C00B8U
#define IOMUXC_GPIO_AON_17_LPUART7_TX 0x443C0044U, 0x2U, 0x443C0164U, 0x0U, 0x443C00B8U
#define IOMUXC_GPIO_AON_17_LPI2C2_SDA 0x443C0044U, 0x3U, 0x443C00FCU, 0x1U, 0x443C00B8U
#define IOMUXC_GPIO_AON_17_LPUART1_DSR_B 0x443C0044U, 0x4U, 0x443C0140U, 0x1U, 0x443C00B8U
#define IOMUXC_GPIO_AON_17_GPIO1_IO17 0x443C0044U, 0x5U, 0, 0, 0x443C00B8U
#define IOMUXC_GPIO_AON_17_CAN1_RX 0x443C0044U, 0x6U, 0x42A104A0U, 0x3U, 0x443C00B8U

#define IOMUXC_GPIO_AON_18_FLEXSPI2_BUS2BIT_B_DATA00 0x443C0048U, 0x0U, 0x42A10588U, 0x2U, 0x443C00BCU
#define IOMUXC_GPIO_AON_18_LPSPI2_SDO 0x443C0048U, 0x1U, 0x443C0128U, 0x1U, 0x443C00BCU
#define IOMUXC_GPIO_AON_18_LPUART7_RX 0x443C0048U, 0x2U, 0x443C0160U, 0x0U, 0x443C00BCU
#define IOMUXC_GPIO_AON_18_LPI2C2_SCL 0x443C0048U, 0x3U, 0x443C00F8U, 0x1U, 0x443C00BCU
#define IOMUXC_GPIO_AON_18_LPUART1_DCD_B 0x443C0048U, 0x4U, 0x443C013CU, 0x1U, 0x443C00BCU
#define IOMUXC_GPIO_AON_18_GPIO1_IO18 0x443C0048U, 0x5U, 0, 0, 0x443C00BCU
#define IOMUXC_GPIO_AON_18_CAN3_TX 0x443C0048U, 0x6U, 0, 0, 0x443C00BCU

#define IOMUXC_GPIO_AON_19_FLEXSPI2_BUS2BIT_B_SCLK 0x443C004CU, 0x0U, 0x42A1059CU, 0x1U, 0x443C00C0U
#define IOMUXC_GPIO_AON_19_LPSPI2_SCK 0x443C004CU, 0x1U, 0x443C0120U, 0x0U, 0x443C00C0U
#define IOMUXC_GPIO_AON_19_FLEXSPI2_BUS2BIT_A_SS1_B 0x443C004CU, 0x3U, 0, 0, 0x443C00C0U
#define IOMUXC_GPIO_AON_19_LPUART1_CTS_B 0x443C004CU, 0x4U, 0x443C0138U, 0x1U, 0x443C00C0U
#define IOMUXC_GPIO_AON_19_GPIO1_IO19 0x443C004CU, 0x5U, 0, 0, 0x443C00C0U
#define IOMUXC_GPIO_AON_19_CAN3_RX 0x443C004CU, 0x6U, 0x42A104A8U, 0x4U, 0x443C00C0U
#define IOMUXC_GPIO_AON_19_LPUART7_RTS_B 0x443C004CU, 0x8U, 0, 0, 0x443C00C0U
#define IOMUXC_GPIO_AON_19_LPUART12_TX 0x443C004CU, 0x9U, 0x443C014CU, 0x1U, 0x443C00C0U
#define IOMUXC_GPIO_AON_19_ADC1_CONV_D00 0x443C004CU, 0xCU, 0, 0, 0x443C00C0U

#define IOMUXC_GPIO_AON_20_FLEXSPI2_BUS2BIT_B_DQS 0x443C0050U, 0x0U, 0x42A10574U, 0x2U, 0x443C00C4U
#define IOMUXC_GPIO_AON_20_FLEXSPI2_BUS2BIT_A_SS1_B 0x443C0050U, 0x1U, 0, 0, 0x443C00C4U
#define IOMUXC_GPIO_AON_20_LPI2C1_SDA 0x443C0050U, 0x2U, 0x443C00F4U, 0x2U, 0x443C00C4U
#define IOMUXC_GPIO_AON_20_I3C1_SDA 0x443C0050U, 0x3U, 0x443C00ECU, 0x1U, 0x443C00C4U
#define IOMUXC_GPIO_AON_20_LPUART1_RTS_B 0x443C0050U, 0x4U, 0, 0, 0x443C00C4U
#define IOMUXC_GPIO_AON_20_GPIO1_IO20 0x443C0050U, 0x5U, 0, 0, 0x443C00C4U
#define IOMUXC_GPIO_AON_20_LPUART12_RX 0x443C0050U, 0x9U, 0x443C0148U, 0x1U, 0x443C00C4U
#define IOMUXC_GPIO_AON_20_ADC1_CONV_D01 0x443C0050U, 0xCU, 0, 0, 0x443C00C4U

#define IOMUXC_GPIO_AON_21_ADC1_CONV_D02 0x443C0054U, 0xCU, 0, 0, 0x443C00C8U
#define IOMUXC_GPIO_AON_21_FLEXSPI2_BUS2BIT_B_SS0_B 0x443C0054U, 0x0U, 0, 0, 0x443C00C8U
#define IOMUXC_GPIO_AON_21_LPSPI2_PCS1 0x443C0054U, 0x1U, 0x443C0118U, 0x1U, 0x443C00C8U
#define IOMUXC_GPIO_AON_21_LPI2C1_SCL 0x443C0054U, 0x2U, 0x443C00F0U, 0x2U, 0x443C00C8U
#define IOMUXC_GPIO_AON_21_I3C1_SCL 0x443C0054U, 0x3U, 0x443C00E8U, 0x1U, 0x443C00C8U
#define IOMUXC_GPIO_AON_21_SAI1_TX_DATA00 0x443C0054U, 0x4U, 0, 0, 0x443C00C8U
#define IOMUXC_GPIO_AON_21_GPIO1_IO21 0x443C0054U, 0x5U, 0, 0, 0x443C00C8U
#define IOMUXC_GPIO_AON_21_FLEXSPI2_BUS2BIT_A_DQS 0x443C0054U, 0x8U, 0x42A10570U, 0x1U, 0x443C00C8U
#define IOMUXC_GPIO_AON_21_SAI1_RX_DATA01 0x443C0054U, 0x9U, 0x443C0174U, 0x1U, 0x443C00C8U

#define IOMUXC_GPIO_AON_22_CCMSRCGPC_CCMOBS1 0x443C0058U, 0xAU, 0, 0, 0x443C00CCU
#define IOMUXC_GPIO_AON_22_ADC1_CONV_D03 0x443C0058U, 0xCU, 0, 0, 0x443C00CCU
#define IOMUXC_GPIO_AON_22_FLEXSPI2_BUS2BIT_A_SS0_B 0x443C0058U, 0x0U, 0, 0, 0x443C00CCU
#define IOMUXC_GPIO_AON_22_LPI2C2_SDA 0x443C0058U, 0x1U, 0x443C00FCU, 0x2U, 0x443C00CCU
#define IOMUXC_GPIO_AON_22_LPUART7_TX 0x443C0058U, 0x2U, 0x443C0164U, 0x1U, 0x443C00CCU
#define IOMUXC_GPIO_AON_22_LPUART12_CTS_B 0x443C0058U, 0x3U, 0x443C0144U, 0x1U, 0x443C00CCU
#define IOMUXC_GPIO_AON_22_SAI1_TX_SYNC 0x443C0058U, 0x4U, 0x443C0180U, 0x1U, 0x443C00CCU
#define IOMUXC_GPIO_AON_22_GPIO1_IO22 0x443C0058U, 0x5U, 0, 0, 0x443C00CCU
#define IOMUXC_GPIO_AON_22_LPSPI2_SCK 0x443C0058U, 0x6U, 0x443C0120U, 0x1U, 0x443C00CCU

#define IOMUXC_GPIO_AON_23_FLEXSPI2_BUS2BIT_A_SCLK 0x443C005CU, 0x0U, 0x42A10598U, 0x1U, 0x443C00D0U
#define IOMUXC_GPIO_AON_23_LPI2C2_SCL 0x443C005CU, 0x1U, 0x443C00F8U, 0x2U, 0x443C00D0U
#define IOMUXC_GPIO_AON_23_LPUART7_RX 0x443C005CU, 0x2U, 0x443C0160U, 0x1U, 0x443C00D0U
#define IOMUXC_GPIO_AON_23_LPUART12_RTS_B 0x443C005CU, 0x3U, 0, 0, 0x443C00D0U
#define IOMUXC_GPIO_AON_23_SAI1_TX_BCLK 0x443C005CU, 0x4U, 0x443C017CU, 0x1U, 0x443C00D0U
#define IOMUXC_GPIO_AON_23_GPIO1_IO23 0x443C005CU, 0x5U, 0, 0, 0x443C00D0U
#define IOMUXC_GPIO_AON_23_LPSPI2_SDO 0x443C005CU, 0x6U, 0x443C0128U, 0x2U, 0x443C00D0U
#define IOMUXC_GPIO_AON_23_CCMSRCGPC_CCMOBS2 0x443C005CU, 0xAU, 0, 0, 0x443C00D0U
#define IOMUXC_GPIO_AON_23_ADC1_CONV_D04 0x443C005CU, 0xCU, 0, 0, 0x443C00D0U

#define IOMUXC_GPIO_AON_24_ADC1_CONV_D05 0x443C0060U, 0xCU, 0, 0, 0x443C00D4U
#define IOMUXC_GPIO_AON_24_FLEXSPI2_BUS2BIT_A_DATA00 0x443C0060U, 0x0U, 0x42A10578U, 0x1U, 0x443C00D4U
#define IOMUXC_GPIO_AON_24_LPI2C1_SDA 0x443C0060U, 0x1U, 0x443C00F4U, 0x3U, 0x443C00D4U
#define IOMUXC_GPIO_AON_24_LPUART2_RTS_B 0x443C0060U, 0x2U, 0, 0, 0x443C00D4U
#define IOMUXC_GPIO_AON_24_LPUART7_CTS_B 0x443C0060U, 0x3U, 0x443C015CU, 0x2U, 0x443C00D4U
#define IOMUXC_GPIO_AON_24_SAI1_MCLK 0x443C0060U, 0x4U, 0x443C0168U, 0x1U, 0x443C00D4U
#define IOMUXC_GPIO_AON_24_GPIO1_IO24 0x443C0060U, 0x5U, 0, 0, 0x443C00D4U
#define IOMUXC_GPIO_AON_24_LPSPI2_SDI 0x443C0060U, 0x6U, 0x443C0124U, 0x2U, 0x443C00D4U

#define IOMUXC_GPIO_AON_25_ADC1_CONV_D06 0x443C0064U, 0xCU, 0, 0, 0x443C00D8U
#define IOMUXC_GPIO_AON_25_FLEXSPI2_BUS2BIT_A_DATA01 0x443C0064U, 0x0U, 0x42A1057CU, 0x1U, 0x443C00D8U
#define IOMUXC_GPIO_AON_25_LPI2C1_SCL 0x443C0064U, 0x1U, 0x443C00F0U, 0x3U, 0x443C00D8U
#define IOMUXC_GPIO_AON_25_LPUART2_CTS_B 0x443C0064U, 0x2U, 0x443C0150U, 0x1U, 0x443C00D8U
#define IOMUXC_GPIO_AON_25_LPUART7_RTS_B 0x443C0064U, 0x3U, 0, 0, 0x443C00D8U
#define IOMUXC_GPIO_AON_25_SAI1_RX_DATA00 0x443C0064U, 0x4U, 0x443C0170U, 0x1U, 0x443C00D8U
#define IOMUXC_GPIO_AON_25_GPIO1_IO25 0x443C0064U, 0x5U, 0, 0, 0x443C00D8U
#define IOMUXC_GPIO_AON_25_LPSPI2_PCS0 0x443C0064U, 0x6U, 0x443C0114U, 0x2U, 0x443C00D8U
#define IOMUXC_GPIO_AON_25_SAI1_TX_DATA01 0x443C0064U, 0x7U, 0, 0, 0x443C00D8U

#define IOMUXC_GPIO_AON_26_FLEXSPI2_BUS2BIT_A_DATA02 0x443C0068U, 0x0U, 0x42A10580U, 0x1U, 0x443C00DCU
#define IOMUXC_GPIO_AON_26_LPSPI2_PCS2 0x443C0068U, 0x1U, 0, 0, 0x443C00DCU
#define IOMUXC_GPIO_AON_26_LPUART2_TX 0x443C0068U, 0x2U, 0x443C0158U, 0x1U, 0x443C00DCU
#define IOMUXC_GPIO_AON_26_SAI1_RX_BCLK 0x443C0068U, 0x4U, 0x443C016CU, 0x1U, 0x443C00DCU
#define IOMUXC_GPIO_AON_26_GPIO1_IO26 0x443C0068U, 0x5U, 0, 0, 0x443C00DCU
#define IOMUXC_GPIO_AON_26_ADC1_CONV_D07 0x443C0068U, 0xCU, 0, 0, 0x443C00DCU

#define IOMUXC_GPIO_AON_27_ADC1_CONV_RDY_CLK 0x443C006CU, 0xCU, 0, 0, 0x443C00E0U
#define IOMUXC_GPIO_AON_27_FLEXSPI2_BUS2BIT_A_DATA03 0x443C006CU, 0x0U, 0x42A10584U, 0x1U, 0x443C00E0U
#define IOMUXC_GPIO_AON_27_LPSPI2_PCS3 0x443C006CU, 0x1U, 0x443C011CU, 0x1U, 0x443C00E0U
#define IOMUXC_GPIO_AON_27_LPUART2_RX 0x443C006CU, 0x2U, 0x443C0154U, 0x1U, 0x443C00E0U
#define IOMUXC_GPIO_AON_27_SAI1_RX_SYNC 0x443C006CU, 0x4U, 0x443C0178U, 0x1U, 0x443C00E0U
#define IOMUXC_GPIO_AON_27_GPIO1_IO27 0x443C006CU, 0x5U, 0, 0, 0x443C00E0U
#define IOMUXC_GPIO_AON_27_EWM_EWM_OUT_B 0x443C006CU, 0x7U, 0, 0, 0x443C00E0U

#define IOMUXC_GPIO_AON_28_DUMMY_FLEXSPI2_BUS2BIT_A_DQS 0x443C0070U, 0x0U, 0x42A10570U, 0x2U, 0x443C00E4U
#define IOMUXC_GPIO_AON_28_DUMMY_FLEXSPI2_BUS2BIT_B_DQS 0x443C0070U, 0x1U, 0x42A10574U, 0x3U, 0x443C00E4U
#define IOMUXC_GPIO_AON_28_DUMMY_GPIO1_IO28 0x443C0070U, 0x5U, 0, 0, 0x443C00E4U

/*@}*/

#define IOMUXC_GPR_SAIMCLK_LOWBITMASK (0x7U)
#define IOMUXC_GPR_SAIMCLK_HIGHBITMASK (0x3U)

typedef enum _iomuxc_mqs_pwm_oversample_rate
{
    kIOMUXC_MqsPwmOverSampleRate32 = 0, /* MQS PWM over sampling rate 32. */
    kIOMUXC_MqsPwmOverSampleRate64 = 1  /* MQS PWM over sampling rate 64. */
} iomuxc_mqs_pwm_oversample_rate_t;

#if defined(__cplusplus)
extern "C" {
#endif /*_cplusplus */

/*! @name Configuration */
/*@{*/

/*!
 * @brief Sets the IOMUXC pin mux mode.
 * @note The first five parameters can be filled with the pin function ID macros.
 *
 * This is an example to set the PTA6 as the lpuart0_tx:
 * @code
 * IOMUXC_SetPinMux(IOMUXC_PTA6_LPUART0_TX, 0);
 * @endcode
 *
 * This is an example to set the PTA0 as GPIOA0:
 * @code
 * IOMUXC_SetPinMux(IOMUXC_PTA0_GPIOA0, 0);
 * @endcode
 *
 * @param muxRegister  The pin mux register.
 * @param muxMode      The pin mux mode.
 * @param inputRegister The select input register.
 * @param inputDaisy   The input daisy.
 * @param configRegister  The config register.
 * @param inputOnfield   Software input on field.
 */
static inline void IOMUXC_SetPinMux(uint32_t muxRegister,
                                    uint32_t muxMode,
                                    uint32_t inputRegister,
                                    uint32_t inputDaisy,
                                    uint32_t configRegister,
                                    uint32_t inputOnfield)
{
    *((volatile uint32_t *)muxRegister) =
        IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(muxMode) | IOMUXC_SW_MUX_CTL_PAD_SION(inputOnfield);

    if (inputRegister != 0UL)
    {
        *((volatile uint32_t *)inputRegister) = inputDaisy;
    }
}

/*!
 * @brief Sets the IOMUXC pin configuration.
 * @note The previous five parameters can be filled with the pin function ID macros.
 *
 * This is an example to set pin configuration for IOMUXC_PTA3_LPI2C0_SCLS:
 * @code
 * IOMUXC_SetPinConfig(IOMUXC_PTA3_LPI2C0_SCLS,IOMUXC_SW_PAD_CTL_PAD_PUS_MASK|IOMUXC_SW_PAD_CTL_PAD_PUS(2U))
 * @endcode
 *
 * @param muxRegister  The pin mux register.
 * @param muxMode      The pin mux mode.
 * @param inputRegister The select input register.
 * @param inputDaisy   The input daisy.
 * @param configRegister  The config register.
 * @param configValue   The pin config value.
 */
static inline void IOMUXC_SetPinConfig(uint32_t muxRegister,
                                       uint32_t muxMode,
                                       uint32_t inputRegister,
                                       uint32_t inputDaisy,
                                       uint32_t configRegister,
                                       uint32_t configValue)
{
    if (configRegister != 0UL)
    {
        *((volatile uint32_t *)configRegister) = configValue;
    }
}

/*@}*/

#if defined(__cplusplus)
}
#endif /*_cplusplus */

/*! @}*/

#endif /* _FSL_IOMUXC_H_ */