/*
 * Copyright 2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _LWIPOPTS_GEN_H_
#define _LWIPOPTS_GEN_H_

// #define LWIP_STATS 0
#define LWIP_DEBUG 1
#define LWIP_DBG_MIN_LEVEL LWIP_DBG_LEVEL_ALL
#define LWIP_DBG_TYPES_ON LWIP_DBG_ON
#define ETHARP_DEBUG LWIP_DBG_OFF
#define NETIF_DEBUG LWIP_DBG_OFF
#define PBUF_DEBUG LWIP_DBG_OFF
#define API_LIB_DEBUG LWIP_DBG_OFF
#define API_MSG_DEBUG LWIP_DBG_OFF
#define SOCKETS_DEBUG LWIP_DBG_OFF
#define ICMP_DEBUG LWIP_DBG_OFF
#define IGMP_DEBUG LWIP_DBG_OFF
#define INET_DEBUG LWIP_DBG_OFF
#define IP_DEBUG LWIP_DBG_OFF
#define IP_REASS_DEBUG LWIP_DBG_OFF
#define RAW_DEBUG LWIP_DBG_OFF
#define MEM_DEBUG LWIP_DBG_OFF
#define MEMP_DEBUG LWIP_DBG_OFF
#define SYS_DEBUG LWIP_DBG_OFF
#define TIMERS_DEBUG LWIP_DBG_OFF
#define TCP_DEBUG LWIP_DBG_OFF
#define TCP_INPUT_DEBUG LWIP_DBG_OFF
#define TCP_FR_DEBUG LWIP_DBG_OFF
#define TCP_RTO_DEBUG LWIP_DBG_OFF
#define TCP_CWND_DEBUG LWIP_DBG_OFF
#define TCP_WND_DEBUG LWIP_DBG_OFF
#define TCP_OUTPUT_DEBUG LWIP_DBG_OFF
#define TCP_RST_DEBUG LWIP_DBG_OFF
#define TCP_QLEN_DEBUG LWIP_DBG_OFF
#define UDP_DEBUG LWIP_DBG_OFF
#define TCPIP_DEBUG LWIP_DBG_OFF
#define SLIP_DEBUG LWIP_DBG_OFF
#define DHCP_DEBUG LWIP_DBG_OFF
#define AUTOIP_DEBUG LWIP_DBG_OFF
#define ACD_DEBUG LWIP_DBG_OFF
#define DNS_DEBUG LWIP_DBG_OFF
#define IP6_DEBUG LWIP_DBG_OFF
#define DHCP6_DEBUG LWIP_DBG_OFF
#define ND6_DEBUG LWIP_DBG_OFF
#define MLD6_DEBUG LWIP_DBG_OFF
// #define LWIP_PERF 0
// #define NO_SYS 0
#define LWIP_TIMERS 1
// #define LWIP_TIMERS_CUSTOM 0
#define MEMCPY(dst,src,len) memcpy(dst,src,len)
#define SMEMCPY(dst,src,len) memcpy(dst,src,len)
#define MEMMOVE(dst,src,len) memmove(dst,src,len)
// #define LWIP_MPU_COMPATIBLE 0
// #define LWIP_TCPIP_CORE_LOCKING 0
// #define LWIP_TCPIP_CORE_LOCKING_INPUT 0
#define SYS_LIGHTWEIGHT_PROT 1
#define LWIP_ASSERT_CORE_LOCKED( ) 
#define LWIP_MARK_TCPIP_THREAD( ) 
// #define MEM_LIBC_MALLOC 0
// #define MEM_CUSTOM_ALLOCATOR 0
// #define MEMP_MEM_MALLOC 0
// #define MEMP_MEM_INIT 0
#define MEM_ALIGNMENT 4U
#define MEM_SIZE 22528U
#define MEMP_OVERFLOW_CHECK 0U
// #define MEMP_SANITY_CHECK 0
#define MEM_OVERFLOW_CHECK 0U
// #define MEM_SANITY_CHECK 0
// #define MEM_USE_POOLS 0
// #define MEM_USE_POOLS_TRY_BIGGER_POOL 0
// #define MEMP_USE_CUSTOM_POOLS 0
// #define LWIP_ALLOW_MEM_FREE_FROM_OTHER_CONTEXT 0
#define MEMP_NUM_PBUF 15U
#define MEMP_NUM_RAW_PCB 4U
#define MEMP_NUM_UDP_PCB 6U
#define MEMP_NUM_TCP_PCB 10U
#define MEMP_NUM_TCP_PCB_LISTEN 6U
#define MEMP_NUM_TCP_SEG 22U
#define MEMP_NUM_ALTCP_PCB 10U
#define MEMP_NUM_REASSDATA 5U
#define MEMP_NUM_FRAG_PBUF 15U
#define MEMP_NUM_ARP_QUEUE 30U
#define MEMP_NUM_IGMP_GROUP 8U
#define LWIP_NUM_SYS_TIMEOUT_INTERNAL (LWIP_TCP + IP_REASSEMBLY + LWIP_ARP + (2*LWIP_DHCP) + LWIP_ACD + LWIP_IGMP + LWIP_DNS + PPP_NUM_TIMEOUTS + (LWIP_IPV6 * (1 + LWIP_IPV6_REASS + LWIP_IPV6_MLD + LWIP_IPV6_DHCP6)))
#define MEMP_NUM_SYS_TIMEOUT 10
#define MEMP_NUM_NETBUF 2U
#define MEMP_NUM_NETCONN 4U
#define MEMP_NUM_SELECT_CB 4U
#define MEMP_NUM_TCPIP_MSG_API 8U
#define MEMP_NUM_TCPIP_MSG_INPKT 8U
#define MEMP_NUM_NETDB 1U
#define MEMP_NUM_LOCALHOSTLIST 1U
#define PBUF_POOL_SIZE 9U
#define MEMP_NUM_API_MSG 8U
#define MEMP_NUM_DNS_API_MSG 8U
#define MEMP_NUM_SOCKET_SETGETSOCKOPT_DATA 8U
#define MEMP_NUM_NETIFAPI_MSG 8U
// #define LWIP_MIB2_CALLBACKS 0
// #define LWIP_MULTICAST_TX_OPTIONS 0
#define TCPIP_THREAD_NAME "tcpip_thread"
#define TCPIP_THREAD_STACKSIZE 1024U
#define TCPIP_THREAD_PRIO 8
#define TCPIP_MBOX_SIZE 32U
#define LWIP_TCPIP_THREAD_ALIVE( ) 
#define SLIPIF_THREAD_NAME "slipif_loop"
#define SLIPIF_THREAD_STACKSIZE 0U
#define SLIPIF_THREAD_PRIO 1
#define DEFAULT_THREAD_NAME "lwIP"
#define DEFAULT_THREAD_STACKSIZE 1000U
#define DEFAULT_THREAD_PRIO 4
#define DEFAULT_RAW_RECVMBOX_SIZE 12U
#define DEFAULT_UDP_RECVMBOX_SIZE 12U
#define DEFAULT_TCP_RECVMBOX_SIZE 12U
#define DEFAULT_ACCEPTMBOX_SIZE 12U
// #define LWIP_CHECKSUM_CTRL_PER_NETIF 0
#define CHECKSUM_GEN_IP 1
#define CHECKSUM_GEN_UDP 1
#define CHECKSUM_GEN_TCP 1
#define CHECKSUM_GEN_ICMP 1
#define CHECKSUM_GEN_ICMP6 1
#define CHECKSUM_CHECK_IP 1
#define CHECKSUM_CHECK_UDP 1
#define CHECKSUM_CHECK_TCP 1
#define CHECKSUM_CHECK_ICMP 1
#define CHECKSUM_CHECK_ICMP6 1
// #define LWIP_CHECKSUM_ON_COPY 0
#define LWIP_HOOK_FILENAME_CUSTOM 
#define LWIP_HOOK_TCP_ISN_CUSTOM(local_ip, local_port, remote_ip, remote_port) 
#define LWIP_HOOK_TCP_INPACKET_PCB_CUSTOM(pcb, hdr, optlen, opt1len, opt2, p) 
#define LWIP_HOOK_TCP_OUT_TCPOPT_LENGTH_CUSTOM(pcb, internal_len) 
#define LWIP_HOOK_TCP_OUT_ADD_TCPOPTS_CUSTOM(p, hdr, pcb, opts) 
#define LWIP_HOOK_IP4_INPUT_CUSTOM(pbuf, input_netif) 
#define LWIP_HOOK_IP4_ROUTE_CUSTOM( ) 
#define LWIP_HOOK_IP4_ROUTE_SRC_CUSTOM(src, dest) 
#define LWIP_HOOK_IP4_CANFORWARD_CUSTOM(src, dest) 
#define LWIP_HOOK_ETHARP_GET_GW_CUSTOM(netif, dest) 
#define LWIP_HOOK_IP6_INPUT_CUSTOM(pbuf, input_netif) 
#define LWIP_HOOK_IP6_CANFORWARD_CUSTOM(src, dest, p, netif) 
#define LWIP_HOOK_IP6_ROUTE_CUSTOM(src, dest) 
#define LWIP_HOOK_ND6_GET_GW_CUSTOM(netif, dest) 
#define LWIP_HOOK_VLAN_CHECK_CUSTOM(netif, eth_hdr, vlan_hdr) 
#define LWIP_HOOK_VLAN_SET_CUSTOM(netif, p, src, dst, eth_type) 
#define LWIP_HOOK_MEMP_AVAILABLE_CUSTOM(memp_t_type) 
#define LWIP_HOOK_UNKNOWN_ETH_PROTOCOL_CUSTOM(pbuf, netif) 
#define LWIP_HOOK_DHCP_APPEND_OPTIONS_CUSTOM(netif, dhcp, state, msg, msg_type, options_len_ptr) 
#define LWIP_HOOK_DHCP_PARSE_OPTION_CUSTOM(netif, dhcp, state, msg, msg_type, option, len, pbuf, offset) 
#define LWIP_HOOK_DHCP6_APPEND_OPTIONS_CUSTOM(netif, dhcp6, state, msg, msg_type, options_len_ptr, max_len) 
#define LWIP_HOOK_SOCKETS_SETSOCKOPT_CUSTOM(s, sock, level, optname, optval, optlen, err) 
#define LWIP_HOOK_SOCKETS_GETSOCKOPT_CUSTOM(s, sock, level, optname, optval, optlen, err) 
#define LWIP_HOOK_NETCONN_EXTERNAL_RESOLVE_CUSTOM(name, addr, addrtype, err) 
#define LWIP_RAW 1
#define RAW_TTL 255U
#define LWIP_DNS 1
#define DNS_TABLE_SIZE 4U
#define DNS_MAX_NAME_LENGTH 256U
#define DNS_MAX_SERVERS 2U
#define DNS_MAX_RETRIES 4U
#define DNS_DOES_NAME_CHECK 1
#define LWIP_DNS_SECURE (LWIP_DNS_SECURE_RAND_XID | LWIP_DNS_SECURE_NO_MULTIPLE_OUTSTANDING | LWIP_DNS_SECURE_RAND_SRC_PORT)
// #define DNS_LOCAL_HOSTLIST 0
// #define DNS_LOCAL_HOSTLIST_IS_DYNAMIC 0
// #define LWIP_DNS_SUPPORT_MDNS_QUERIES 0
#define LWIP_UDP 1
// #define LWIP_UDPLITE 0
#define UDP_TTL 255U
// #define LWIP_NETBUF_RECVINFO 0
#define LWIP_TCP 1
#define TCP_TTL 255U
#define TCP_WND (2 * TCP_MSS)
#define TCP_MAXRTX 12U
#define TCP_SYNMAXRTX 6U
// #define TCP_QUEUE_OOSEQ 0
// #define LWIP_TCP_SACK_OUT 0
#define LWIP_TCP_MAX_SACK_NUM 4U
#define TCP_MSS 1460U
#define TCP_CALCULATE_EFF_SEND_MSS 1
#define LWIP_TCP_RTO_TIME 3000U
#define TCP_SND_BUF (6 * TCP_MSS)
#define TCP_SND_QUEUELEN ((3 * TCP_SND_BUF) / TCP_MSS)
#define TCP_SNDLOWAT LWIP_MIN(LWIP_MAX(((TCP_SND_BUF)/2), (2 * TCP_MSS) + 1), (TCP_SND_BUF) - 1)
#define TCP_SNDQUEUELOWAT LWIP_MAX(((TCP_SND_QUEUELEN)/2), 5)
#define TCP_OOSEQ_MAX_PBUFS 0U
#define TCP_LISTEN_BACKLOG 1
#define TCP_DEFAULT_LISTEN_BACKLOG 0xffU
#define TCP_OVERSIZE 1460U
// #define LWIP_TCP_TIMESTAMPS 0
#define TCP_WND_UPDATE_THRESHOLD LWIP_MIN((TCP_WND / 4), (TCP_MSS * 4))
#define LWIP_CALLBACK_API 1
// #define LWIP_WND_SCALE 0
#define LWIP_TCP_PCB_NUM_EXT_ARGS 0U
// #define LWIP_ALTCP 0
#define LWIP_NETCONN 1
// #define LWIP_TCPIP_TIMEOUT 0
// #define LWIP_NETCONN_SEM_PER_THREAD 0
// #define LWIP_NETCONN_FULLDUPLEX 0
#define LWIP_SOCKET 1
#define LWIP_COMPAT_SOCKETS 1U
#define LWIP_POSIX_SOCKETS_IO_NAMES 1
#define LWIP_SOCKET_OFFSET 0
// #define LWIP_SOCKET_EXTERNAL_HEADERS 0
// #define LWIP_TCP_KEEPALIVE 0
// #define LWIP_SO_SNDTIMEO 0
#define LWIP_SO_RCVTIMEO 1
// #define LWIP_TCP_USER_TIMEOUT 0
// #define LWIP_SO_SNDRCVTIMEO_NONSTANDARD 0
// #define LWIP_SO_RCVBUF 0
// #define LWIP_SIOCOUTQ 0
// #define LWIP_SO_LINGER 0
#define RECV_BUFSIZE_DEFAULT INT_MAX
#define LWIP_TCP_CLOSE_TIMEOUT_MS_DEFAULT 20000U
// #define SO_REUSE 0
// #define SO_REUSE_RXTOALL 0
#define LWIP_FIONREAD_LINUXMODE 0U
#define LWIP_SOCKET_SELECT 1
#define LWIP_SOCKET_POLL 1
#define LWIP_ARP 1
#define ARP_TABLE_SIZE 10U
#define ARP_MAXAGE 300U
// #define ARP_QUEUEING 0
#define ARP_QUEUE_LEN 3U
// #define ETHARP_SUPPORT_VLAN 0
// #define LWIP_VLAN_PCP 0
#define LWIP_ETHERNET 1
#define ETH_PAD_SIZE 0U
// #define ETHARP_SUPPORT_STATIC_ENTRIES 0
#define ETHARP_TABLE_MATCH_NETIF 1
#define LWIP_ICMP 1
#define ICMP_TTL 255U
// #define LWIP_BROADCAST_PING 0
// #define LWIP_MULTICAST_PING 0
#define LWIP_DHCP 1
// #define LWIP_DHCP_DOES_ACD_CHECK 0
// #define LWIP_DHCP_BOOTP_FILE 0
// #define LWIP_DHCP_GET_NTP_SRV 0
#define LWIP_DHCP_MAX_NTP_SERVERS 1U
#define LWIP_DHCP_MAX_DNS_SERVERS 2U
#define LWIP_DHCP_DISCOVER_ADD_HOSTNAME 1
// #define LWIP_AUTOIP 0
// #define LWIP_DHCP_AUTOIP_COOP 0
#define LWIP_DHCP_AUTOIP_COOP_TRIES 9U
// #define LWIP_ACD 0
// #define LWIP_IGMP 0
#define LWIP_IPV4 1
// #define IP_FORWARD 0
#define IP_REASSEMBLY 1
#define IP_FRAG 1
#define IP_OPTIONS_ALLOWED 1
#define IP_REASS_MAXAGE 15U
#define IP_REASS_MAX_PBUFS 10U
#define IP_DEFAULT_TTL 255U
// #define IP_SOF_BROADCAST 0
// #define IP_FORWARD_ALLOW_TX_ON_RX_NETIF 0
#define PBUF_LINK_HLEN (18 + ETH_PAD_SIZE)
#define PBUF_LINK_ENCAPSULATION_HLEN 0U
#define PBUF_POOL_BUFSIZE LWIP_MEM_ALIGN_SIZE(TCP_MSS+PBUF_IP_HLEN+PBUF_TRANSPORT_HLEN+PBUF_LINK_ENCAPSULATION_HLEN+PBUF_LINK_HLEN)
#define LWIP_PBUF_REF_T u8_t
#define LWIP_PBUF_CUSTOM_DATA 
#define LWIP_PBUF_CUSTOM_DATA_INIT(p) 
#define LWIP_SUPPORT_CUSTOM_PBUF 1
// #define LWIP_HAVE_LOOPIF 0
// #define LWIP_LOOPIF_MULTICAST 0
// #define LWIP_NETIF_LOOPBACK 0
#define LWIP_LOOPBACK_MAX_PBUFS 0U
#define LWIP_NETIF_LOOPBACK_MULTITHREADING 1
// #define LWIP_SINGLE_NETIF 0
// #define LWIP_NETIF_HOSTNAME 0
#define LWIP_NETIF_API 1
// #define LWIP_NETIF_STATUS_CALLBACK 0
// #define LWIP_NETIF_EXT_STATUS_CALLBACK 0U
// #define LWIP_NETIF_LINK_CALLBACK 0
// #define LWIP_NETIF_REMOVE_CALLBACK 0
// #define LWIP_NETIF_HWADDRHINT 0
// #define LWIP_NETIF_TX_SINGLE_PBUF 0
#define LWIP_NUM_NETIF_CLIENT_DATA 0U
#define NETIF_MAX_HWADDR_LEN 6U
// #define LWIP_ICMP6 0
#define LWIP_ICMP6_DATASIZE 0U
#define LWIP_ICMP6_HL 255U
// #define LWIP_IPV6_MLD 0
#define MEMP_NUM_MLD6_GROUP 4U
// #define LWIP_ND6_QUEUEING 0
#define MEMP_NUM_ND6_QUEUE 20U
#define LWIP_ND6_NUM_NEIGHBORS 10U
#define LWIP_ND6_NUM_DESTINATIONS 10U
#define LWIP_ND6_NUM_PREFIXES 5U
#define LWIP_ND6_NUM_ROUTES 8U
#define LWIP_ND6_MAX_MULTICAST_SOLICIT 3U
#define LWIP_ND6_MAX_UNICAST_SOLICIT 3U
#define LWIP_ND6_MAX_ANYCAST_DELAY_TIME 1000U
#define LWIP_ND6_MAX_NEIGHBOR_ADVERTISEMENT 3U
#define LWIP_ND6_REACHABLE_TIME 30000U
#define LWIP_ND6_RETRANS_TIMER 1000U
#define LWIP_ND6_DELAY_FIRST_PROBE_TIME 5000U
#define LWIP_ND6_ALLOW_RA_UPDATES 1
#define LWIP_ND6_TCP_REACHABILITY_HINTS 1
#define LWIP_ND6_RDNSS_MAX_DNS_SERVERS 0U
// #define LWIP_IPV6_DHCP6 0
// #define LWIP_IPV6_DHCP6_PD 0
// #define LWIP_IPV6_DHCP6_STATEFUL 0
// #define LWIP_IPV6_DHCP6_STATELESS 0
// #define LWIP_DHCP6_GET_NTP_SRV 0
#define LWIP_DHCP6_MAX_NTP_SERVERS 1U
#define LWIP_DHCP6_MAX_DNS_SERVERS 2U
// #define LWIP_IPV6 0
#define IPV6_REASS_MAXAGE 60U
// #define LWIP_IPV6_SCOPES 0
// #define LWIP_IPV6_SCOPES_DEBUG 0
#define LWIP_IPV6_NUM_ADDRESSES 3U
// #define LWIP_IPV6_FORWARD 0
#define LWIP_IPV6_FRAG 1
// #define LWIP_IPV6_REASS 0
#define LWIP_IPV6_RA_NUM_ROUTE_INFOS 0U
// #define LWIP_IPV6_SEND_ROUTER_SOLICIT 0
// #define LWIP_IPV6_SEND_ROUTER_ADVERTISE 0
// #define LWIP_IPV6_AUTOCONFIG 0
// #define LWIP_IPV6_ADDRESS_LIFETIMES 0
#define LWIP_IPV6_DUP_DETECT_ATTEMPTS 1U
// #define PING_USE_SOCKETS 0
#define PING_DEBUG LWIP_DBG_ON
#define PING_RCV_TIMEO 1000U
#define PING_DELAY 1000U
#define PING_ID 0xAFAFU
#define PING_DATA_SIZE 32U
#define PING_RESULT(ping_ok) 
// #define LWIP_TESTMODE 0
#define LWIP_PROVIDE_ERRNO 1

#endif /* _LWIPOPTS_GEN_H_ */
