/*
** ###################################################################
**     Processors:          MIMXRT1171AVM8A
**                          MIMXRT1171AVM8B
**                          MIMXRT1171CVM8A
**                          MIMXRT1171CVM8B
**                          MIMXRT1171DVMAA
**                          MIMXRT1171DVMAB
**                          MIMXRT1172AVM8A
**                          MIMXRT1172AVM8B
**                          MIMXRT1172CVM8A
**                          MIMXRT1172CVM8B
**                          MIMXRT1172DVMAA
**                          MIMXRT1172DVMAB
**                          MIMXRT1173CVM8A_cm4
**                          MIMXRT1173CVM8A_cm7
**                          MIMXRT1173CVM8B_cm4
**                          MIMXRT1173CVM8B_cm7
**                          MIMXRT1175AVM8A_cm4
**                          MIMXRT1175AVM8A_cm7
**                          MIMXRT1175AVM8B_cm4
**                          MIMXRT1175AVM8B_cm7
**                          MIMXRT1175CVM8A_cm4
**                          MIMXRT1175CVM8A_cm7
**                          MIMXRT1175CVM8B_cm4
**                          MIMXRT1175CVM8B_cm7
**                          MIMXRT1175DVMAA_cm4
**                          MIMXRT1175DVMAA_cm7
**                          MIMXRT1175DVMAB_cm4
**                          MIMXRT1175DVMAB_cm7
**                          MIMXRT1176AVM8A_cm4
**                          MIMXRT1176AVM8A_cm7
**                          MIMXRT1176AVM8B_cm4
**                          MIMXRT1176AVM8B_cm7
**                          MIMXRT1176CVM8A_cm4
**                          MIMXRT1176CVM8A_cm7
**                          MIMXRT1176CVM8B_cm4
**                          MIMXRT1176CVM8B_cm7
**                          MIMXRT1176DVMAA_cm4
**                          MIMXRT1176DVMAA_cm7
**                          MIMXRT1176DVMAB_cm4
**                          MIMXRT1176DVMAB_cm7
**                          MIMXRT117HAVM8A_cm4
**                          MIMXRT117HAVM8A_cm7
**                          MIMXRT117HAVM8B_cm4
**                          MIMXRT117HAVM8B_cm7
**                          MIMXRT117HCVM8A_cm4
**                          MIMXRT117HCVM8A_cm7
**                          MIMXRT117HCVM8B_cm4
**                          MIMXRT117HCVM8B_cm7
**                          MIMXRT117HDVMAA_cm4
**                          MIMXRT117HDVMAA_cm7
**                          MIMXRT117HDVMAB_cm4
**                          MIMXRT117HDVMAB_cm7
**
**     Version:             rev. 2.0, 2024-10-29
**     Build:               b250520
**
**     Abstract:
**         CMSIS Peripheral Access Layer for ANADIG_PMU
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2025 NXP
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 0.1 (2018-03-05)
**         Initial version.
**     - rev. 1.0 (2020-12-29)
**         Update header files to align with IMXRT1170RM Rev.0.
**     - rev. 2.0 (2024-10-29)
**         Change the device header file from single flat file to multiple files based on peripherals,
**         each peripheral with dedicated header file located in periphN folder.
**
** ###################################################################
*/

/*!
 * @file PERI_ANADIG_PMU.h
 * @version 2.0
 * @date 2024-10-29
 * @brief CMSIS Peripheral Access Layer for ANADIG_PMU
 *
 * CMSIS Peripheral Access Layer for ANADIG_PMU
 */

#if !defined(PERI_ANADIG_PMU_H_)
#define PERI_ANADIG_PMU_H_                       /**< Symbol preventing repeated inclusion */

#if (defined(CPU_MIMXRT1171AVM8A) || defined(CPU_MIMXRT1171AVM8B) || defined(CPU_MIMXRT1171CVM8A) || defined(CPU_MIMXRT1171CVM8B) || defined(CPU_MIMXRT1171DVMAA) || defined(CPU_MIMXRT1171DVMAB))
#include "MIMXRT1171_COMMON.h"
#elif (defined(CPU_MIMXRT1172AVM8A) || defined(CPU_MIMXRT1172AVM8B) || defined(CPU_MIMXRT1172CVM8A) || defined(CPU_MIMXRT1172CVM8B) || defined(CPU_MIMXRT1172DVMAA) || defined(CPU_MIMXRT1172DVMAB))
#include "MIMXRT1172_COMMON.h"
#elif (defined(CPU_MIMXRT1173CVM8A_cm4) || defined(CPU_MIMXRT1173CVM8B_cm4))
#include "MIMXRT1173_cm4_COMMON.h"
#elif (defined(CPU_MIMXRT1173CVM8A_cm7) || defined(CPU_MIMXRT1173CVM8B_cm7))
#include "MIMXRT1173_cm7_COMMON.h"
#elif (defined(CPU_MIMXRT1175AVM8A_cm4) || defined(CPU_MIMXRT1175AVM8B_cm4) || defined(CPU_MIMXRT1175CVM8A_cm4) || defined(CPU_MIMXRT1175CVM8B_cm4) || defined(CPU_MIMXRT1175DVMAA_cm4) || defined(CPU_MIMXRT1175DVMAB_cm4))
#include "MIMXRT1175_cm4_COMMON.h"
#elif (defined(CPU_MIMXRT1175AVM8A_cm7) || defined(CPU_MIMXRT1175AVM8B_cm7) || defined(CPU_MIMXRT1175CVM8A_cm7) || defined(CPU_MIMXRT1175CVM8B_cm7) || defined(CPU_MIMXRT1175DVMAA_cm7) || defined(CPU_MIMXRT1175DVMAB_cm7))
#include "MIMXRT1175_cm7_COMMON.h"
#elif (defined(CPU_MIMXRT1176AVM8A_cm4) || defined(CPU_MIMXRT1176AVM8B_cm4) || defined(CPU_MIMXRT1176CVM8A_cm4) || defined(CPU_MIMXRT1176CVM8B_cm4) || defined(CPU_MIMXRT1176DVMAA_cm4) || defined(CPU_MIMXRT1176DVMAB_cm4))
#include "MIMXRT1176_cm4_COMMON.h"
#elif (defined(CPU_MIMXRT1176AVM8A_cm7) || defined(CPU_MIMXRT1176AVM8B_cm7) || defined(CPU_MIMXRT1176CVM8A_cm7) || defined(CPU_MIMXRT1176CVM8B_cm7) || defined(CPU_MIMXRT1176DVMAA_cm7) || defined(CPU_MIMXRT1176DVMAB_cm7))
#include "MIMXRT1176_cm7_COMMON.h"
#elif (defined(CPU_MIMXRT117HAVM8A_cm4) || defined(CPU_MIMXRT117HAVM8B_cm4) || defined(CPU_MIMXRT117HCVM8A_cm4) || defined(CPU_MIMXRT117HCVM8B_cm4) || defined(CPU_MIMXRT117HDVMAA_cm4) || defined(CPU_MIMXRT117HDVMAB_cm4))
#include "MIMXRT117H_cm4_COMMON.h"
#elif (defined(CPU_MIMXRT117HAVM8A_cm7) || defined(CPU_MIMXRT117HAVM8B_cm7) || defined(CPU_MIMXRT117HCVM8A_cm7) || defined(CPU_MIMXRT117HCVM8B_cm7) || defined(CPU_MIMXRT117HDVMAA_cm7) || defined(CPU_MIMXRT117HDVMAB_cm7))
#include "MIMXRT117H_cm7_COMMON.h"
#else
  #error "No valid CPU defined!"
#endif

/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__CWCC__)
  #pragma push
  #pragma cpp_extensions on
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ANADIG_PMU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_PMU_Peripheral_Access_Layer ANADIG_PMU Peripheral Access Layer
 * @{
 */

/** ANADIG_PMU - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[1280];
  __IO uint32_t PMU_LDO_PLL;                       /**< PMU_LDO_PLL_REGISTER, offset: 0x500 */
       uint8_t RESERVED_1[76];
  __IO uint32_t PMU_BIAS_CTRL;                     /**< PMU_BIAS_CTRL_REGISTER, offset: 0x550 */
       uint8_t RESERVED_2[12];
  __IO uint32_t PMU_BIAS_CTRL2;                    /**< PMU_BIAS_CTRL2_REGISTER, offset: 0x560 */
       uint8_t RESERVED_3[12];
  __IO uint32_t PMU_REF_CTRL;                      /**< PMU_REF_CTRL_REGISTER, offset: 0x570 */
       uint8_t RESERVED_4[12];
  __IO uint32_t PMU_POWER_DETECT_CTRL;             /**< PMU_POWER_DETECT_CTRL_REGISTER, offset: 0x580 */
       uint8_t RESERVED_5[124];
  __IO uint32_t LDO_PLL_ENABLE_SP;                 /**< LDO_PLL_ENABLE_SP_REGISTER, offset: 0x600 */
       uint8_t RESERVED_6[12];
  __IO uint32_t LDO_LPSR_ANA_ENABLE_SP;            /**< LDO_LPSR_ANA_ENABLE_SP_REGISTER, offset: 0x610 */
       uint8_t RESERVED_7[12];
  __IO uint32_t LDO_LPSR_ANA_LP_MODE_SP;           /**< LDO_LPSR_ANA_LP_MODE_SP_REGISTER, offset: 0x620 */
       uint8_t RESERVED_8[12];
  __IO uint32_t LDO_LPSR_ANA_TRACKING_EN_SP;       /**< LDO_LPSR_ANA_TRACKING_EN_SP_REGISTER, offset: 0x630 */
       uint8_t RESERVED_9[12];
  __IO uint32_t LDO_LPSR_ANA_BYPASS_EN_SP;         /**< LDO_LPSR_ANA_BYPASS_EN_SP_REGISTER, offset: 0x640 */
       uint8_t RESERVED_10[12];
  __IO uint32_t LDO_LPSR_ANA_STBY_EN_SP;           /**< LDO_LPSR_ANA_STBY_EN_SP_REGISTER, offset: 0x650 */
       uint8_t RESERVED_11[12];
  __IO uint32_t LDO_LPSR_DIG_ENABLE_SP;            /**< LDO_LPSR_DIG_ENABLE_SP_REGISTER, offset: 0x660 */
       uint8_t RESERVED_12[12];
  __IO uint32_t LDO_LPSR_DIG_TRG_SP0;              /**< LDO_LPSR_DIG_TRG_SP0_REGISTER, offset: 0x670 */
       uint8_t RESERVED_13[12];
  __IO uint32_t LDO_LPSR_DIG_TRG_SP1;              /**< LDO_LPSR_DIG_TRG_SP1_REGISTER, offset: 0x680 */
       uint8_t RESERVED_14[12];
  __IO uint32_t LDO_LPSR_DIG_TRG_SP2;              /**< LDO_LPSR_DIG_TRG_SP2_REGISTER, offset: 0x690 */
       uint8_t RESERVED_15[12];
  __IO uint32_t LDO_LPSR_DIG_TRG_SP3;              /**< LDO_LPSR_DIG_TRG_SP3_REGISTER, offset: 0x6A0 */
       uint8_t RESERVED_16[12];
  __IO uint32_t LDO_LPSR_DIG_LP_MODE_SP;           /**< LDO_LPSR_DIG_LP_MODE_SP_REGISTER, offset: 0x6B0 */
       uint8_t RESERVED_17[12];
  __IO uint32_t LDO_LPSR_DIG_TRACKING_EN_SP;       /**< LDO_LPSR_DIG_TRACKING_EN_SP_REGISTER, offset: 0x6C0 */
       uint8_t RESERVED_18[12];
  __IO uint32_t LDO_LPSR_DIG_BYPASS_EN_SP;         /**< LDO_LPSR_DIG_BYPASS_EN_SP_REGISTER, offset: 0x6D0 */
       uint8_t RESERVED_19[12];
  __IO uint32_t LDO_LPSR_DIG_STBY_EN_SP;           /**< LDO_LPSR_DIG_STBY_EN_SP_REGISTER, offset: 0x6E0 */
       uint8_t RESERVED_20[12];
  __IO uint32_t BANDGAP_ENABLE_SP;                 /**< BANDGAP_ENABLE_SP_REGISTER, offset: 0x6F0 */
       uint8_t RESERVED_21[12];
  __IO uint32_t FBB_M7_ENABLE_SP;                  /**< FBB_M7_ENABLE_SP_REGISTER, offset: 0x700 */
       uint8_t RESERVED_22[12];
  __IO uint32_t RBB_SOC_ENABLE_SP;                 /**< RBB_SOC_ENABLE_SP_REGISTER, offset: 0x710 */
       uint8_t RESERVED_23[12];
  __IO uint32_t RBB_LPSR_ENABLE_SP;                /**< RBB_LPSR_ENABLE_SP_REGISTER, offset: 0x720 */
       uint8_t RESERVED_24[12];
  __IO uint32_t BANDGAP_STBY_EN_SP;                /**< BANDGAP_STBY_EN_SP_REGISTER, offset: 0x730 */
       uint8_t RESERVED_25[12];
  __IO uint32_t PLL_LDO_STBY_EN_SP;                /**< PLL_LDO_STBY_EN_SP_REGISTER, offset: 0x740 */
       uint8_t RESERVED_26[12];
  __IO uint32_t FBB_M7_STBY_EN_SP;                 /**< FBB_M7_STBY_EN_SP_REGISTER, offset: 0x750 */
       uint8_t RESERVED_27[12];
  __IO uint32_t RBB_SOC_STBY_EN_SP;                /**< RBB_SOC_STBY_EN_SP_REGISTER, offset: 0x760 */
       uint8_t RESERVED_28[12];
  __IO uint32_t RBB_LPSR_STBY_EN_SP;               /**< RBB_LPSR_STBY_EN_SP_REGISTER, offset: 0x770 */
       uint8_t RESERVED_29[12];
  __IO uint32_t FBB_M7_CONFIGURE;                  /**< FBB_M7_CONFIGURE_REGISTER, offset: 0x780 */
       uint8_t RESERVED_30[12];
  __IO uint32_t RBB_LPSR_CONFIGURE;                /**< RBB_LPSR_CONFIGURE_REGISTER, offset: 0x790 */
       uint8_t RESERVED_31[12];
  __IO uint32_t RBB_SOC_CONFIGURE;                 /**< RBB_SOC_CONFIGURE_REGISTER, offset: 0x7A0 */
       uint8_t RESERVED_32[12];
  __I  uint32_t REFTOP_OTP_TRIM_VALUE;             /**< REFTOP_OTP_TRIM_VALUE_REGISTER, offset: 0x7B0 */
       uint8_t RESERVED_33[28];
  __I  uint32_t LPSR_1P8_LDO_OTP_TRIM_VALUE;       /**< LPSR_1P8_LDO_OTP_TRIM_VALUE_REGISTER, offset: 0x7D0 */
} ANADIG_PMU_Type;

/* ----------------------------------------------------------------------------
   -- ANADIG_PMU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_PMU_Register_Masks ANADIG_PMU Register Masks
 * @{
 */

/*! @name PMU_LDO_PLL - PMU_LDO_PLL_REGISTER */
/*! @{ */

#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_ENABLE_MASK (0x1U)
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_ENABLE_SHIFT (0U)
/*! LDO_PLL_ENABLE - LDO_PLL_ENABLE */
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_ENABLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_ENABLE_SHIFT)) & ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_ENABLE_MASK)

#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_CONTROL_MODE_MASK (0x2U)
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_CONTROL_MODE_SHIFT (1U)
/*! LDO_PLL_CONTROL_MODE - LDO_PLL_CONTROL_MODE
 *  0b0..SW Control
 *  0b1..HW Control
 */
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_CONTROL_MODE_SHIFT)) & ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_CONTROL_MODE_MASK)

#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_TOGGLE_MASK (0x10000U)
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_TOGGLE_SHIFT (16U)
/*! LDO_PLL_AI_TOGGLE - ldo_pll_ai_toggle */
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_TOGGLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_TOGGLE_SHIFT)) & ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_TOGGLE_MASK)

#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_BUSY_MASK (0x40000000U)
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_BUSY_SHIFT (30U)
/*! LDO_PLL_AI_BUSY - ldo_pll_busy */
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_BUSY(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_BUSY_SHIFT)) & ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_BUSY_MASK)
/*! @} */

/*! @name PMU_BIAS_CTRL - PMU_BIAS_CTRL_REGISTER */
/*! @{ */

#define ANADIG_PMU_PMU_BIAS_CTRL_WB_CFG_1P8_MASK (0x1FFFU)
#define ANADIG_PMU_PMU_BIAS_CTRL_WB_CFG_1P8_SHIFT (0U)
/*! WB_CFG_1P8 - wb_cfg_1p8 */
#define ANADIG_PMU_PMU_BIAS_CTRL_WB_CFG_1P8(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL_WB_CFG_1P8_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL_WB_CFG_1P8_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL_WB_VDD_SEL_1P8_MASK (0x4000U)
#define ANADIG_PMU_PMU_BIAS_CTRL_WB_VDD_SEL_1P8_SHIFT (14U)
/*! WB_VDD_SEL_1P8 - wb_vdd_sel_1p8
 *  0b0..VDD_LV1
 *  0b1..VDD_LV2
 */
#define ANADIG_PMU_PMU_BIAS_CTRL_WB_VDD_SEL_1P8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL_WB_VDD_SEL_1P8_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL_WB_VDD_SEL_1P8_MASK)
/*! @} */

/*! @name PMU_BIAS_CTRL2 - PMU_BIAS_CTRL2_REGISTER */
/*! @{ */

#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_MD_MASK (0x3FEU)
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_MD_SHIFT (1U)
/*! WB_TST_MD - TMOD_wb_tst_md_1p8 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_MD(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_MD_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_MD_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_PWR_SW_EN_1P8_MASK (0x1C00U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_PWR_SW_EN_1P8_SHIFT (10U)
/*! WB_PWR_SW_EN_1P8 - MODSEL_wb_tst_md_1p8
 *  0b001..No BB
 *  0b010..BB
 *  0b100..BB
 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_PWR_SW_EN_1P8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_WB_PWR_SW_EN_1P8_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_WB_PWR_SW_EN_1P8_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_ADJ_1P8_MASK (0x1FE000U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_ADJ_1P8_SHIFT (13U)
/*! WB_ADJ_1P8 - wb_adj_1p8
 *  0b00000000..Cref= 0fF Cspl= 0fF DeltaC= 0fF
 *  0b00000001..Cref= 0fF Cspl= 30fF DeltaC= -30fF
 *  0b00000010..Cref= 0fF Cspl= 43fF DeltaC= -43fF
 *  0b00000011..Cref= 0fF Cspl= 62fF DeltaC=-62fF
 *  0b00000100..Cref= 0fF Cspl=105fF DeltaC=-105fF
 *  0b00000101..Cref= 30fF Cspl= 0fF DeltaC= 30fF
 *  0b00000110..Cref= 30fF Cspl= 43fF DeltaC= -12fF
 *  0b00000111..Cref= 30fF Cspl=105fF DeltaC= -75fF
 *  0b00001000..Cref= 43fF Cspl= 0fF DeltaC= 43fF
 *  0b00001001..Cref= 43fF Cspl= 30fF DeltaC= 13fF
 *  0b00001010..Cref= 43fF Cspl= 62fF DeltaC= -19fF
 *  0b00001011..Cref= 62fF Cspl= 0fF DeltaC= 62fF
 *  0b00001100..Cref= 62fF Cspl= 43fF DeltaC= 19fF
 *  0b00001101..Cref=105fF Cspl= 0fF DeltaC= 105fF
 *  0b00001110..Cref=105fF Cspl=30fF DeltaC= 75fF
 *  0b00001111..Cref=0fF Cspl=0fF DeltaC= 0fF
 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_ADJ_1P8(x)  (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_WB_ADJ_1P8_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_WB_ADJ_1P8_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_FBB_M7_CONTROL_MODE_MASK (0x200000U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_FBB_M7_CONTROL_MODE_SHIFT (21U)
/*! FBB_M7_CONTROL_MODE - FBB_M7_CONTROL_MODE
 *  0b0..SW Control
 *  0b1..HW Control
 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_FBB_M7_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_FBB_M7_CONTROL_MODE_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_FBB_M7_CONTROL_MODE_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_RBB_SOC_CONTROL_MODE_MASK (0x400000U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_RBB_SOC_CONTROL_MODE_SHIFT (22U)
/*! RBB_SOC_CONTROL_MODE - RBB_SOC_CONTROL_MODE
 *  0b0..SW Control
 *  0b1..HW Control
 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_RBB_SOC_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_RBB_SOC_CONTROL_MODE_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_RBB_SOC_CONTROL_MODE_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_RBB_LPSR_CONTROL_MODE_MASK (0x800000U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_RBB_LPSR_CONTROL_MODE_SHIFT (23U)
/*! RBB_LPSR_CONTROL_MODE - RBB_LPSR_CONTROL_MODE
 *  0b0..SW Control
 *  0b1..HW Control
 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_RBB_LPSR_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_RBB_LPSR_CONTROL_MODE_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_RBB_LPSR_CONTROL_MODE_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_EN_MASK     (0x1000000U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_EN_SHIFT    (24U)
/*! WB_EN - wb_en */
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_EN(x)       (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_WB_EN_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_WB_EN_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_DIG_OUT_MASK (0x2000000U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_DIG_OUT_SHIFT (25U)
/*! WB_TST_DIG_OUT - Digital output */
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_DIG_OUT(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_DIG_OUT_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_DIG_OUT_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_OK_MASK     (0x4000000U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_OK_SHIFT    (26U)
/*! WB_OK - Digital Output pin. */
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_OK(x)       (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_WB_OK_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_WB_OK_MASK)
/*! @} */

/*! @name PMU_REF_CTRL - PMU_REF_CTRL_REGISTER */
/*! @{ */

#define ANADIG_PMU_PMU_REF_CTRL_REF_AI_TOGGLE_MASK (0x1U)
#define ANADIG_PMU_PMU_REF_CTRL_REF_AI_TOGGLE_SHIFT (0U)
/*! REF_AI_TOGGLE - ref_ai_toggle */
#define ANADIG_PMU_PMU_REF_CTRL_REF_AI_TOGGLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_REF_CTRL_REF_AI_TOGGLE_SHIFT)) & ANADIG_PMU_PMU_REF_CTRL_REF_AI_TOGGLE_MASK)

#define ANADIG_PMU_PMU_REF_CTRL_REF_AI_BUSY_MASK (0x2U)
#define ANADIG_PMU_PMU_REF_CTRL_REF_AI_BUSY_SHIFT (1U)
/*! REF_AI_BUSY - ref_ai_busy */
#define ANADIG_PMU_PMU_REF_CTRL_REF_AI_BUSY(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_REF_CTRL_REF_AI_BUSY_SHIFT)) & ANADIG_PMU_PMU_REF_CTRL_REF_AI_BUSY_MASK)

#define ANADIG_PMU_PMU_REF_CTRL_REF_ENABLE_MASK  (0x4U)
#define ANADIG_PMU_PMU_REF_CTRL_REF_ENABLE_SHIFT (2U)
/*! REF_ENABLE - REF_ENABLE */
#define ANADIG_PMU_PMU_REF_CTRL_REF_ENABLE(x)    (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_REF_CTRL_REF_ENABLE_SHIFT)) & ANADIG_PMU_PMU_REF_CTRL_REF_ENABLE_MASK)

#define ANADIG_PMU_PMU_REF_CTRL_REF_CONTROL_MODE_MASK (0x8U)
#define ANADIG_PMU_PMU_REF_CTRL_REF_CONTROL_MODE_SHIFT (3U)
/*! REF_CONTROL_MODE - REF_CONTROL_MODE
 *  0b0..SW Control
 *  0b1..HW Control
 */
#define ANADIG_PMU_PMU_REF_CTRL_REF_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_REF_CTRL_REF_CONTROL_MODE_SHIFT)) & ANADIG_PMU_PMU_REF_CTRL_REF_CONTROL_MODE_MASK)

#define ANADIG_PMU_PMU_REF_CTRL_EN_PLL_VOL_REF_BUFFER_MASK (0x10U)
#define ANADIG_PMU_PMU_REF_CTRL_EN_PLL_VOL_REF_BUFFER_SHIFT (4U)
/*! EN_PLL_VOL_REF_BUFFER - en_pll_vol_ref_buffer */
#define ANADIG_PMU_PMU_REF_CTRL_EN_PLL_VOL_REF_BUFFER(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_REF_CTRL_EN_PLL_VOL_REF_BUFFER_SHIFT)) & ANADIG_PMU_PMU_REF_CTRL_EN_PLL_VOL_REF_BUFFER_MASK)
/*! @} */

/*! @name PMU_POWER_DETECT_CTRL - PMU_POWER_DETECT_CTRL_REGISTER */
/*! @{ */

#define ANADIG_PMU_PMU_POWER_DETECT_CTRL_CKGB_LPSR1P0_MASK (0x100U)
#define ANADIG_PMU_PMU_POWER_DETECT_CTRL_CKGB_LPSR1P0_SHIFT (8U)
/*! CKGB_LPSR1P0 - ckgb_lpsr1p0 */
#define ANADIG_PMU_PMU_POWER_DETECT_CTRL_CKGB_LPSR1P0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_POWER_DETECT_CTRL_CKGB_LPSR1P0_SHIFT)) & ANADIG_PMU_PMU_POWER_DETECT_CTRL_CKGB_LPSR1P0_MASK)
/*! @} */

/*! @name LDO_PLL_ENABLE_SP - LDO_PLL_ENABLE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT (0U)
/*! ON_OFF_SETPOINT0 - ON_OFF_SETPOINT0
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT (1U)
/*! ON_OFF_SETPOINT1 - ON_OFF_SETPOINT1
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT (2U)
/*! ON_OFF_SETPOINT2 - ON_OFF_SETPOINT2
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT (3U)
/*! ON_OFF_SETPOINT3 - ON_OFF_SETPOINT3
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT (4U)
/*! ON_OFF_SETPOINT4 - ON_OFF_SETPOINT4
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT (5U)
/*! ON_OFF_SETPOINT5 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT (6U)
/*! ON_OFF_SETPOINT6 - ON_OFF_SETPOINT6
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT (7U)
/*! ON_OFF_SETPOINT7 - ON_OFF_SETPOINT7
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT (8U)
/*! ON_OFF_SETPOINT8 - ON_OFF_SETPOINT8
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT (9U)
/*! ON_OFF_SETPOINT9 - ON_OFF_SETPOINT9
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT (10U)
/*! ON_OFF_SETPOINT10 - ON_OFF_SETPOINT10
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT (11U)
/*! ON_OFF_SETPOINT11 - ON_OFF_SETPOINT11
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT (12U)
/*! ON_OFF_SETPOINT12 - ON_OFF_SETPOINT12
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT (13U)
/*! ON_OFF_SETPOINT13 - ON_OFF_SETPOINT13
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT (14U)
/*! ON_OFF_SETPOINT14 - ON_OFF_SETPOINT14
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT (15U)
/*! ON_OFF_SETPOINT15 - ON_OFF_SETPOINT15
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_ANA_ENABLE_SP - LDO_LPSR_ANA_ENABLE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT (0U)
/*! ON_OFF_SETPOINT0 - ON_OFF_SETPOINT0
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT (1U)
/*! ON_OFF_SETPOINT1 - ON_OFF_SETPOINT1
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT (2U)
/*! ON_OFF_SETPOINT2 - ON_OFF_SETPOINT2
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT (3U)
/*! ON_OFF_SETPOINT3 - ON_OFF_SETPOINT3
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT (4U)
/*! ON_OFF_SETPOINT4 - ON_OFF_SETPOINT4
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT (5U)
/*! ON_OFF_SETPOINT5 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT (6U)
/*! ON_OFF_SETPOINT6 - ON_OFF_SETPOINT6
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT (7U)
/*! ON_OFF_SETPOINT7 - ON_OFF_SETPOINT7
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT (8U)
/*! ON_OFF_SETPOINT8 - ON_OFF_SETPOINT8
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT (9U)
/*! ON_OFF_SETPOINT9 - ON_OFF_SETPOINT9
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT (10U)
/*! ON_OFF_SETPOINT10 - ON_OFF_SETPOINT10
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT (11U)
/*! ON_OFF_SETPOINT11 - ON_OFF_SETPOINT11
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT (12U)
/*! ON_OFF_SETPOINT12 - ON_OFF_SETPOINT12
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT (13U)
/*! ON_OFF_SETPOINT13 - ON_OFF_SETPOINT13
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT (14U)
/*! ON_OFF_SETPOINT14 - ON_OFF_SETPOINT14
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT (15U)
/*! ON_OFF_SETPOINT15 - ON_OFF_SETPOINT15
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_ANA_LP_MODE_SP - LDO_LPSR_ANA_LP_MODE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT0_SHIFT (0U)
/*! LP_MODE_SETPOINT0 - LP_MODE_SETPOINT0
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT1_SHIFT (1U)
/*! LP_MODE_SETPOINT1 - LP_MODE_SETPOINT1
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT2_SHIFT (2U)
/*! LP_MODE_SETPONIT2 - LP_MODE_SETPOINT2
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT2_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT3_SHIFT (3U)
/*! LP_MODE_SETPONIT3 - LP_MODE_SETPOINT3
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT3_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT4_SHIFT (4U)
/*! LP_MODE_SETPONIT4 - LP_MODE_SETPOINT4
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT4_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT5_SHIFT (5U)
/*! LP_MODE_SETPONIT5 - LP_MODE_SETPOINT5
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT5_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT6_SHIFT (6U)
/*! LP_MODE_SETPONIT6 - LP_MODE_SETPOINT6
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT6_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT7_SHIFT (7U)
/*! LP_MODE_SETPONIT7 - LP_MODE_SETPOINT7
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT7_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT8_SHIFT (8U)
/*! LP_MODE_SETPONIT8 - LP_MODE_SETPOINT8
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT8_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT9_SHIFT (9U)
/*! LP_MODE_SETPONIT9 - LP_MODE_SETPOINT9
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT9_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT10_SHIFT (10U)
/*! LP_MODE_SETPONIT10 - LP_MODE_SETPOINT10
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT10_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT11_SHIFT (11U)
/*! LP_MODE_SETPONIT11 - LP_MODE_SETPOINT11
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT11_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT12_SHIFT (12U)
/*! LP_MODE_SETPONIT12 - LP_MODE_SETPOINT12
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT12_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT13_SHIFT (13U)
/*! LP_MODE_SETPONIT13 - LP_MODE_SETPOINT13
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT13_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT14_SHIFT (14U)
/*! LP_MODE_SETPONIT14 - LP_MODE_SETPOINT14
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT14_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT15_SHIFT (15U)
/*! LP_MODE_SETPONIT15 - LP_MODE_SETPOINT15
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT15_MASK)
/*! @} */

/*! @name LDO_LPSR_ANA_TRACKING_EN_SP - LDO_LPSR_ANA_TRACKING_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_SHIFT (0U)
/*! TRACKING_EN_SETPOINT0 - TRACKING_EN_SETPOINT0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_SHIFT (1U)
/*! TRACKING_EN_SETPOINT1 - TRACKING_EN_SETPOINT1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_SHIFT (2U)
/*! TRACKING_EN_SETPOINT2 - TRACKING_EN_SETPOINT2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_SHIFT (3U)
/*! TRACKING_EN_SETPOINT3 - TRACKING_EN_SETPOINT3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_SHIFT (4U)
/*! TRACKING_EN_SETPOINT4 - TRACKING_EN_SETPOINT4
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_SHIFT (5U)
/*! TRACKING_EN_SETPOINT5 - TRACKING_EN_SETPOINT5
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_SHIFT (6U)
/*! TRACKING_EN_SETPOINT6 - TRACKING_EN_SETPOINT6
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_SHIFT (7U)
/*! TRACKING_EN_SETPOINT7 - TRACKING_EN_SETPOINT7
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_SHIFT (8U)
/*! TRACKING_EN_SETPOINT8 - TRACKING_EN_SETPOINT8
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_SHIFT (9U)
/*! TRACKING_EN_SETPOINT9 - TRACKING_EN_SETPOINT9
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_SHIFT (10U)
/*! TRACKING_EN_SETPOINT10 - TRACKING_EN_SETPOINT10
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_SHIFT (11U)
/*! TRACKING_EN_SETPOINT11 - TRACKING_EN_SETPOINT11
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_SHIFT (12U)
/*! TRACKING_EN_SETPOINT12 - TRACKING_EN_SETPOINT12
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_SHIFT (13U)
/*! TRACKING_EN_SETPOINT13 - TRACKING_EN_SETPOINT13
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_SHIFT (14U)
/*! TRACKING_EN_SETPOINT14 - TRACKING_EN_SETPOINT14
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_SHIFT (15U)
/*! TRACKING_EN_SETPOINT15 - TRACKING_EN_SETPOINT15
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_ANA_BYPASS_EN_SP - LDO_LPSR_ANA_BYPASS_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_SHIFT (0U)
/*! BYPASS_EN_SETPOINT0 - BYPASS_EN_SETPOINT0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_SHIFT (1U)
/*! BYPASS_EN_SETPOINT1 - BYPASS_EN_SETPOINT1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_SHIFT (2U)
/*! BYPASS_EN_SETPOINT2 - BYPASS_EN_SETPOINT2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_SHIFT (3U)
/*! BYPASS_EN_SETPOINT3 - BYPASS_EN_SETPOINT3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_SHIFT (4U)
/*! BYPASS_EN_SETPOINT4 - BYPASS_EN_SETPOINT4
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_SHIFT (5U)
/*! BYPASS_EN_SETPOINT5 - BYPASS_EN_SETPOINT5
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_SHIFT (6U)
/*! BYPASS_EN_SETPOINT6 - BYPASS_EN_SETPOINT6
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_SHIFT (7U)
/*! BYPASS_EN_SETPOINT7 - BYPASS_EN_SETPOINT7
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_SHIFT (8U)
/*! BYPASS_EN_SETPOINT8 - BYPASS_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_SHIFT (9U)
/*! BYPASS_EN_SETPOINT9 - BYPASS_EN_SETPOINT9
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_SHIFT (10U)
/*! BYPASS_EN_SETPOINT10 - BYPASS_EN_SETPOINT10
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_SHIFT (11U)
/*! BYPASS_EN_SETPOINT11 - BYPASS_EN_SETPOINT11
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_SHIFT (12U)
/*! BYPASS_EN_SETPOINT12 - BYPASS_EN_SETPOINT12
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_SHIFT (13U)
/*! BYPASS_EN_SETPOINT13 - BYPASS_EN_SETPOINT13
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_SHIFT (14U)
/*! BYPASS_EN_SETPOINT14 - BYPASS_EN_SETPOINT14
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_SHIFT (15U)
/*! BYPASS_EN_SETPOINT15 - BYPASS_EN_SETPOINT15
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_ANA_STBY_EN_SP - LDO_LPSR_ANA_STBY_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT (0U)
/*! STBY_EN_SETPOINT0 - STBY_EN_SETPOINT0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT (1U)
/*! STBY_EN_SETPOINT1 - STBY_EN_SETPOINT1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT (2U)
/*! STBY_EN_SETPOINT2 - STBY_EN_SETPOINT2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT (3U)
/*! STBY_EN_SETPOINT3 - STBY_EN_SETPOINT3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT (4U)
/*! STBY_EN_SETPOINT4 - STBY_EN_SETPOINT4
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT (5U)
/*! STBY_EN_SETPOINT5 - STBY_EN_SETPOINT5
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT (6U)
/*! STBY_EN_SETPOINT6 - STBY_EN_SETPOINT6
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT (7U)
/*! STBY_EN_SETPOINT7 - STBY_EN_SETPOINT7
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT (8U)
/*! STBY_EN_SETPOINT8 - STBY_EN_SETPOINT8
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT (9U)
/*! STBY_EN_SETPOINT9 - STBY_EN_SETPOINT9
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT (10U)
/*! STBY_EN_SETPOINT10 - STBY_EN_SETPOINT10
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT (11U)
/*! STBY_EN_SETPOINT11 - STBY_EN_SETPOINT11
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT (12U)
/*! STBY_EN_SETPOINT12 - STBY_EN_SETPOINT12
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT (13U)
/*! STBY_EN_SETPOINT13 - STBY_EN_SETPOINT13
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT (14U)
/*! STBY_EN_SETPOINT14 - STBY_EN_SETPOINT14
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT (15U)
/*! STBY_EN_SETPOINT15 - STBY_EN_SETPOINT15
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_ENABLE_SP - LDO_LPSR_DIG_ENABLE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT (0U)
/*! ON_OFF_SETPOINT0 - ON_OFF_SETPOINT0
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT (1U)
/*! ON_OFF_SETPOINT1 - ON_OFF_SETPOINT1
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT (2U)
/*! ON_OFF_SETPOINT2 - ON_OFF_SETPOINT2
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT (3U)
/*! ON_OFF_SETPOINT3 - ON_OFF_SETPOINT3
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT (4U)
/*! ON_OFF_SETPOINT4 - ON_OFF_SETPOINT4
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT (5U)
/*! ON_OFF_SETPOINT5 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT (6U)
/*! ON_OFF_SETPOINT6 - ON_OFF_SETPOINT6
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT (7U)
/*! ON_OFF_SETPOINT7 - ON_OFF_SETPOINT7
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT (8U)
/*! ON_OFF_SETPOINT8 - ON_OFF_SETPOINT8
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT (9U)
/*! ON_OFF_SETPOINT9 - ON_OFF_SETPOINT9
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT (10U)
/*! ON_OFF_SETPOINT10 - ON_OFF_SETPOINT10
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT (11U)
/*! ON_OFF_SETPOINT11 - ON_OFF_SETPOINT11
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT (12U)
/*! ON_OFF_SETPOINT12 - ON_OFF_SETPOINT12
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT (13U)
/*! ON_OFF_SETPOINT13 - ON_OFF_SETPOINT13
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT (14U)
/*! ON_OFF_SETPOINT14 - ON_OFF_SETPOINT14
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT (15U)
/*! ON_OFF_SETPOINT15 - ON_OFF_SETPOINT15
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_TRG_SP0 - LDO_LPSR_DIG_TRG_SP0_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT0_MASK (0xFFU)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT0_SHIFT (0U)
/*! VOLTAGE_SETPOINT0 - VOLTAGE_SETPOINT0 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT1_MASK (0xFF00U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT1_SHIFT (8U)
/*! VOLTAGE_SETPOINT1 - VOLTAGE_SETPOINT1 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT2_MASK (0xFF0000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT2_SHIFT (16U)
/*! VOLTAGE_SETPOINT2 - VOLTAGE_SETPOINT2 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT3_MASK (0xFF000000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT3_SHIFT (24U)
/*! VOLTAGE_SETPOINT3 - VOLTAGE_SETPOINT3 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT3_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_TRG_SP1 - LDO_LPSR_DIG_TRG_SP1_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT4_MASK (0xFFU)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT4_SHIFT (0U)
/*! VOLTAGE_SETPOINT4 - VOLTAGE_SETPOINT4 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT5_MASK (0xFF00U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT5_SHIFT (8U)
/*! VOLTAGE_SETPOINT5 - VOLTAGE_SETPOINT5 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT6_MASK (0xFF0000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT6_SHIFT (16U)
/*! VOLTAGE_SETPOINT6 - VOLTAGE_SETPOINT6 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT7_MASK (0xFF000000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT7_SHIFT (24U)
/*! VOLTAGE_SETPOINT7 - VOLTAGE_SETPOINT7 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT7_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_TRG_SP2 - LDO_LPSR_DIG_TRG_SP2_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT8_MASK (0xFFU)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT8_SHIFT (0U)
/*! VOLTAGE_SETPOINT8 - VOLTAGE_SETPOINT8 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT9_MASK (0xFF00U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT9_SHIFT (8U)
/*! VOLTAGE_SETPOINT9 - VOLTAGE_SETPOINT9 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT10_MASK (0xFF0000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT10_SHIFT (16U)
/*! VOLTAGE_SETPOINT10 - VOLTAGE_SETPOINT10 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT11_MASK (0xFF000000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT11_SHIFT (24U)
/*! VOLTAGE_SETPOINT11 - VOLTAGE_SETPOINT11 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT11_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_TRG_SP3 - LDO_LPSR_DIG_TRG_SP3_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT12_MASK (0xFFU)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT12_SHIFT (0U)
/*! VOLTAGE_SETPOINT12 - VOLTAGE_SETPOINT12 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT13_MASK (0xFF00U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT13_SHIFT (8U)
/*! VOLTAGE_SETPOINT13 - VOLTAGE_SETPOINT13 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT14_MASK (0xFF0000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT14_SHIFT (16U)
/*! VOLTAGE_SETPOINT14 - VOLTAGE_SETPOINT14 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT15_MASK (0xFF000000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT15_SHIFT (24U)
/*! VOLTAGE_SETPOINT15 - VOLTAGE_SETPOINT15 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_LP_MODE_SP - LDO_LPSR_DIG_LP_MODE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT0_SHIFT (0U)
/*! LP_MODE_SETPOINT0 - LP_MODE_SETPOINT0
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT1_SHIFT (1U)
/*! LP_MODE_SETPOINT1 - LP_MODE_SETPOINT1
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT2_SHIFT (2U)
/*! LP_MODE_SETPOINT2 - LP_MODE_SETPOINT2
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT3_SHIFT (3U)
/*! LP_MODE_SETPOINT3 - LP_MODE_SETPOINT3
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT4_SHIFT (4U)
/*! LP_MODE_SETPOINT4 - LP_MODE_SETPOINT4
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT5_SHIFT (5U)
/*! LP_MODE_SETPOINT5 - LP_MODE_SETPOINT5
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT6_SHIFT (6U)
/*! LP_MODE_SETPOINT6 - LP_MODE_SETPOINT6
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT7_SHIFT (7U)
/*! LP_MODE_SETPOINT7 - LP_MODE_SETPOINT7
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT8_SHIFT (8U)
/*! LP_MODE_SETPOINT8 - LP_MODE_SETPOINT8
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT9_SHIFT (9U)
/*! LP_MODE_SETPOINT9 - LP_MODE_SETPOINT9
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT10_SHIFT (10U)
/*! LP_MODE_SETPOINT10 - LP_MODE_SETPOINT10
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT11_SHIFT (11U)
/*! LP_MODE_SETPOINT11 - LP_MODE_SETPOINT11
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT12_SHIFT (12U)
/*! LP_MODE_SETPOINT12 - LP_MODE_SETPOINT12
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT13_SHIFT (13U)
/*! LP_MODE_SETPOINT13 - LP_MODE_SETPOINT13
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT14_SHIFT (14U)
/*! LP_MODE_SETPOINT14 - LP_MODE_SETPOINT14
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT15_SHIFT (15U)
/*! LP_MODE_SETPOINT15 - LP_MODE_SETPOINT15
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_TRACKING_EN_SP - LDO_LPSR_DIG_TRACKING_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_SHIFT (0U)
/*! TRACKING_EN_SETPOINT0 - TRACKING_EN_SETPOINT0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_SHIFT (1U)
/*! TRACKING_EN_SETPOINT1 - TRACKING_EN_SETPOINT1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_SHIFT (2U)
/*! TRACKING_EN_SETPOINT2 - TRACKING_EN_SETPOINT2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_SHIFT (3U)
/*! TRACKING_EN_SETPOINT3 - TRACKING_EN_SETPOINT3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_SHIFT (4U)
/*! TRACKING_EN_SETPOINT4 - TRACKING_EN_SETPOINT4
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_SHIFT (5U)
/*! TRACKING_EN_SETPOINT5 - TRACKING_EN_SETPOINT5
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_SHIFT (6U)
/*! TRACKING_EN_SETPOINT6 - TRACKING_EN_SETPOINT6
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_SHIFT (7U)
/*! TRACKING_EN_SETPOINT7 - TRACKING_EN_SETPOINT7
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_SHIFT (8U)
/*! TRACKING_EN_SETPOINT8 - TRACKING_EN_SETPOINT8
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_SHIFT (9U)
/*! TRACKING_EN_SETPOINT9 - TRACKING_EN_SETPOINT9
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_SHIFT (10U)
/*! TRACKING_EN_SETPOINT10 - TRACKING_EN_SETPOINT10
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_SHIFT (11U)
/*! TRACKING_EN_SETPOINT11 - TRACKING_EN_SETPOINT11
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_SHIFT (12U)
/*! TRACKING_EN_SETPOINT12 - TRACKING_EN_SETPOINT12
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_SHIFT (13U)
/*! TRACKING_EN_SETPOINT13 - TRACKING_EN_SETPOINT13
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_SHIFT (14U)
/*! TRACKING_EN_SETPOINT14 - TRACKING_EN_SETPOINT14
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_SHIFT (15U)
/*! TRACKING_EN_SETPOINT15 - TRACKING_EN_SETPOINT15
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_BYPASS_EN_SP - LDO_LPSR_DIG_BYPASS_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_SHIFT (0U)
/*! BYPASS_EN_SETPOINT0 - BYPASS_EN_SETPOINT0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_SHIFT (1U)
/*! BYPASS_EN_SETPOINT1 - BYPASS_EN_SETPOINT1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_SHIFT (2U)
/*! BYPASS_EN_SETPOINT2 - BYPASS_EN_SETPOINT2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_SHIFT (3U)
/*! BYPASS_EN_SETPOINT3 - BYPASS_EN_SETPOINT3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_SHIFT (4U)
/*! BYPASS_EN_SETPOINT4 - BYPASS_EN_SETPOINT4
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_SHIFT (5U)
/*! BYPASS_EN_SETPOINT5 - BYPASS_EN_SETPOINT5
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_SHIFT (6U)
/*! BYPASS_EN_SETPOINT6 - BYPASS_EN_SETPOINT6
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_SHIFT (7U)
/*! BYPASS_EN_SETPOINT7 - BYPASS_EN_SETPOINT7
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_SHIFT (8U)
/*! BYPASS_EN_SETPOINT8 - BYPASS_EN_SETPOINT8
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_SHIFT (9U)
/*! BYPASS_EN_SETPOINT9 - BYPASS_EN_SETPOINT9
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_SHIFT (10U)
/*! BYPASS_EN_SETPOINT10 - BYPASS_EN_SETPOINT10
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_SHIFT (11U)
/*! BYPASS_EN_SETPOINT11 - BYPASS_EN_SETPOINT11
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_SHIFT (12U)
/*! BYPASS_EN_SETPOINT12 - BYPASS_EN_SETPOINT12
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_SHIFT (13U)
/*! BYPASS_EN_SETPOINT13 - BYPASS_EN_SETPOINT13
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_SHIFT (14U)
/*! BYPASS_EN_SETPOINT14 - BYPASS_EN_SETPOINT14
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_SHIFT (15U)
/*! BYPASS_EN_SETPOINT15 - BYPASS_EN_SETPOINT15
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_STBY_EN_SP - LDO_LPSR_DIG_STBY_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT (0U)
/*! STBY_EN_SETPOINT0 - STBY_EN_SETPOINT0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT (1U)
/*! STBY_EN_SETPOINT1 - STBY_EN_SETPOINT1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT (2U)
/*! STBY_EN_SETPOINT2 - STBY_EN_SETPOINT2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT (3U)
/*! STBY_EN_SETPOINT3 - STBY_EN_SETPOINT3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT (4U)
/*! STBY_EN_SETPOINT4 - STBY_EN_SETPOINT4
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT (5U)
/*! STBY_EN_SETPOINT5 - STBY_EN_SETPOINT5
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT (6U)
/*! STBY_EN_SETPOINT6 - STBY_EN_SETPOINT6
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT (7U)
/*! STBY_EN_SETPOINT7 - STBY_EN_SETPOINT7
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT (8U)
/*! STBY_EN_SETPOINT8 - STBY_EN_SETPOINT8
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT (9U)
/*! STBY_EN_SETPOINT9 - STBY_EN_SETPOINT9
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT (10U)
/*! STBY_EN_SETPOINT10 - STBY_EN_SETPOINT10
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT (11U)
/*! STBY_EN_SETPOINT11 - STBY_EN_SETPOINT11
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT (12U)
/*! STBY_EN_SETPOINT12 - STBY_EN_SETPOINT12
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT (13U)
/*! STBY_EN_SETPOINT13 - STBY_EN_SETPOINT13
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT (14U)
/*! STBY_EN_SETPOINT14 - STBY_EN_SETPOINT14
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT (15U)
/*! STBY_EN_SETPOINT15 - STBY_EN_SETPOINT15
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT15_MASK)
/*! @} */

/*! @name BANDGAP_ENABLE_SP - BANDGAP_ENABLE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT (0U)
/*! ON_OFF_SETPOINT0 - ON_OFF_SETPOINT0
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT0_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT (1U)
/*! ON_OFF_SETPOINT1 - ON_OFF_SETPOINT1
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT1_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT (2U)
/*! ON_OFF_SETPOINT2 - ON_OFF_SETPOINT2
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT2_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT (3U)
/*! ON_OFF_SETPOINT3 - ON_OFF_SETPOINT3
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT3_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT (4U)
/*! ON_OFF_SETPOINT4 - ON_OFF_SETPOINT4
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT4_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT (5U)
/*! ON_OFF_SETPOINT5 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT5_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT (6U)
/*! ON_OFF_SETPOINT6 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT6_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT (7U)
/*! ON_OFF_SETPOINT7 - ON_OFF_SETPOINT7
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT7_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT (8U)
/*! ON_OFF_SETPOINT8 - ON_OFF_SETPOINT8
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT8_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT (9U)
/*! ON_OFF_SETPOINT9 - ON_OFF_SETPOINT9
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT9_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT (10U)
/*! ON_OFF_SETPOINT10 - ON_OFF_SETPOINT10
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT10_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT (11U)
/*! ON_OFF_SETPOINT11 - ON_OFF_SETPOINT11
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT11_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT (12U)
/*! ON_OFF_SETPOINT12 - ON_OFF_SETPOINT12
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT12_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT (13U)
/*! ON_OFF_SETPOINT13 - ON_OFF_SETPOINT13
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT13_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT (14U)
/*! ON_OFF_SETPOINT14 - ON_OFF_SETPOINT14
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT14_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT (15U)
/*! ON_OFF_SETPOINT15 - ON_OFF_SETPOINT15
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT15_MASK)
/*! @} */

/*! @name FBB_M7_ENABLE_SP - FBB_M7_ENABLE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT (0U)
/*! ON_OFF_SETPOINT0 - ON_OFF_SETPOINT0
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT0_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT (1U)
/*! ON_OFF_SETPOINT1 - ON_OFF_SETPOINT1
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT1_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT (2U)
/*! ON_OFF_SETPOINT2 - ON_OFF_SETPOINT2
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT2_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT (3U)
/*! ON_OFF_SETPOINT3 - ON_OFF_SETPOINT3
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT3_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT (4U)
/*! ON_OFF_SETPOINT4 - ON_OFF_SETPOINT4
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT4_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT (5U)
/*! ON_OFF_SETPOINT5 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT5_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT (6U)
/*! ON_OFF_SETPOINT6 - ON_OFF_SETPOINT6
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT6_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT (7U)
/*! ON_OFF_SETPOINT7 - ON_OFF_SETPOINT7
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT7_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT (8U)
/*! ON_OFF_SETPOINT8 - ON_OFF_SETPOINT8
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT8_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT (9U)
/*! ON_OFF_SETPOINT9 - ON_OFF_SETPOINT9
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT9_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT (10U)
/*! ON_OFF_SETPOINT10 - ON_OFF_SETPOINT10
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT10_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT (11U)
/*! ON_OFF_SETPOINT11 - ON_OFF_SETPOINT11
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT11_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT (12U)
/*! ON_OFF_SETPOINT12 - ON_OFF_SETPOINT12
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT12_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT (13U)
/*! ON_OFF_SETPOINT13 - ON_OFF_SETPOINT13
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT13_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT (14U)
/*! ON_OFF_SETPOINT14 - ON_OFF_SETPOINT14
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT14_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT (15U)
/*! ON_OFF_SETPOINT15 - ON_OFF_SETPOINT15
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT15_MASK)
/*! @} */

/*! @name RBB_SOC_ENABLE_SP - RBB_SOC_ENABLE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT (0U)
/*! ON_OFF_SETPOINT0 - ON_OFF_SETPOINT0
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT0_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT (1U)
/*! ON_OFF_SETPOINT1 - ON_OFF_SETPOINT1
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT1_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT (2U)
/*! ON_OFF_SETPOINT2 - ON_OFF_SETPOINT2
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT2_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT (3U)
/*! ON_OFF_SETPOINT3 - ON_OFF_SETPOINT3
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT3_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT (4U)
/*! ON_OFF_SETPOINT4 - ON_OFF_SETPOINT4
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT4_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT (5U)
/*! ON_OFF_SETPOINT5 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT5_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT (6U)
/*! ON_OFF_SETPOINT6 - ON_OFF_SETPOINT6
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT6_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT (7U)
/*! ON_OFF_SETPOINT7 - ON_OFF_SETPOINT7
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT7_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT (8U)
/*! ON_OFF_SETPOINT8 - ON_OFF_SETPOINT8
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT8_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT (9U)
/*! ON_OFF_SETPOINT9 - ON_OFF_SETPOINT9
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT9_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT (10U)
/*! ON_OFF_SETPOINT10 - ON_OFF_SETPOINT10
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT10_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT (11U)
/*! ON_OFF_SETPOINT11 - ON_OFF_SETPOINT11
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT11_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT (12U)
/*! ON_OFF_SETPOINT12 - ON_OFF_SETPOINT12
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT12_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT (13U)
/*! ON_OFF_SETPOINT13 - ON_OFF_SETPOINT13
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT13_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT (14U)
/*! ON_OFF_SETPOINT14 - ON_OFF_SETPOINT14
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT14_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT (15U)
/*! ON_OFF_SETPOINT15 - ON_OFF_SETPOINT15
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT15_MASK)
/*! @} */

/*! @name RBB_LPSR_ENABLE_SP - RBB_LPSR_ENABLE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT (0U)
/*! ON_OFF_SETPOINT0 - ON_OFF_SETPOINT0
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT0_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT (1U)
/*! ON_OFF_SETPOINT1 - ON_OFF_SETPOINT1
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT1_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT (2U)
/*! ON_OFF_SETPOINT2 - ON_OFF_SETPOINT2
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT2_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT (3U)
/*! ON_OFF_SETPOINT3 - ON_OFF_SETPOINT3
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT3_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT (4U)
/*! ON_OFF_SETPOINT4 - ON_OFF_SETPOINT4
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT4_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT (5U)
/*! ON_OFF_SETPOINT5 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT5_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT (6U)
/*! ON_OFF_SETPOINT6 - ON_OFF_SETPOINT6
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT6_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT (7U)
/*! ON_OFF_SETPOINT7 - ON_OFF_SETPOINT7
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT7_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT (8U)
/*! ON_OFF_SETPOINT8 - ON_OFF_SETPOINT8
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT8_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT (9U)
/*! ON_OFF_SETPOINT9 - ON_OFF_SETPOINT9
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT9_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT (10U)
/*! ON_OFF_SETPOINT10 - ON_OFF_SETPOINT10
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT10_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT (11U)
/*! ON_OFF_SETPOINT11 - ON_OFF_SETPOINT11
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT11_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT (12U)
/*! ON_OFF_SETPOINT12 - ON_OFF_SETPOINT12
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT12_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT (13U)
/*! ON_OFF_SETPOINT13 - ON_OFF_SETPOINT13
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT13_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT (14U)
/*! ON_OFF_SETPOINT14 - ON_OFF_SETPOINT14
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT14_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT (15U)
/*! ON_OFF_SETPOINT15 - ON_OFF_SETPOINT15
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT15_MASK)
/*! @} */

/*! @name BANDGAP_STBY_EN_SP - BANDGAP_STBY_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT (0U)
/*! STBY_EN_SETPOINT0 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT0_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT (1U)
/*! STBY_EN_SETPOINT1 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT1_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT (2U)
/*! STBY_EN_SETPOINT2 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT2_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT (3U)
/*! STBY_EN_SETPOINT3 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT3_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT (4U)
/*! STBY_EN_SETPOINT4 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT4_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT (5U)
/*! STBY_EN_SETPOINT5 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT5_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT (6U)
/*! STBY_EN_SETPOINT6 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT6_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT (7U)
/*! STBY_EN_SETPOINT7 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT7_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT (8U)
/*! STBY_EN_SETPOINT8 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT8_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT (9U)
/*! STBY_EN_SETPOINT9 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT9_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT (10U)
/*! STBY_EN_SETPOINT10 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT10_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT (11U)
/*! STBY_EN_SETPOINT11 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT11_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT (12U)
/*! STBY_EN_SETPOINT12 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT12_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT (13U)
/*! STBY_EN_SETPOINT13 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT13_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT (14U)
/*! STBY_EN_SETPOINT14 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT14_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT (15U)
/*! STBY_EN_SETPOINT15 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT15_MASK)
/*! @} */

/*! @name PLL_LDO_STBY_EN_SP - PLL_LDO_STBY_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT (0U)
/*! STBY_EN_SETPOINT0 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT0_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT (1U)
/*! STBY_EN_SETPOINT1 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT1_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT (2U)
/*! STBY_EN_SETPOINT2 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT2_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT (3U)
/*! STBY_EN_SETPOINT3 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT3_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT (4U)
/*! STBY_EN_SETPOINT4 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT4_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT (5U)
/*! STBY_EN_SETPOINT5 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT5_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT (6U)
/*! STBY_EN_SETPOINT6 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT6_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT (7U)
/*! STBY_EN_SETPOINT7 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT7_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT (8U)
/*! STBY_EN_SETPOINT8 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT8_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT (9U)
/*! STBY_EN_SETPOINT9 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT9_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT (10U)
/*! STBY_EN_SETPOINT10 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT10_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT (11U)
/*! STBY_EN_SETPOINT11 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT11_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT (12U)
/*! STBY_EN_SETPOINT12 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT12_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT (13U)
/*! STBY_EN_SETPOINT13 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT13_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT (14U)
/*! STBY_EN_SETPOINT14 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT14_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT (15U)
/*! STBY_EN_SETPOINT15 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT15_MASK)
/*! @} */

/*! @name FBB_M7_STBY_EN_SP - FBB_M7_STBY_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT (0U)
/*! STBY_EN_SETPOINT0 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT0_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT (1U)
/*! STBY_EN_SETPOINT1 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT1_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT (2U)
/*! STBY_EN_SETPOINT2 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT2_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT (3U)
/*! STBY_EN_SETPOINT3 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT3_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT (4U)
/*! STBY_EN_SETPOINT4 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT4_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT (5U)
/*! STBY_EN_SETPOINT5 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT5_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT (6U)
/*! STBY_EN_SETPOINT6 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT6_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT (7U)
/*! STBY_EN_SETPOINT7 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT7_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT (8U)
/*! STBY_EN_SETPOINT8 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT8_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT (9U)
/*! STBY_EN_SETPOINT9 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT9_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT (10U)
/*! STBY_EN_SETPOINT10 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT10_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT (11U)
/*! STBY_EN_SETPOINT11 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT11_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT (12U)
/*! STBY_EN_SETPOINT12 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT12_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT (13U)
/*! STBY_EN_SETPOINT13 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT13_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT (14U)
/*! STBY_EN_SETPOINT14 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT14_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT (15U)
/*! STBY_EN_SETPOINT15 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT15_MASK)
/*! @} */

/*! @name RBB_SOC_STBY_EN_SP - RBB_SOC_STBY_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT (0U)
/*! STBY_EN_SETPOINT0 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT0_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT (1U)
/*! STBY_EN_SETPOINT1 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT1_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT (2U)
/*! STBY_EN_SETPOINT2 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT2_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT (3U)
/*! STBY_EN_SETPOINT3 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT3_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT (4U)
/*! STBY_EN_SETPOINT4 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT4_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT (5U)
/*! STBY_EN_SETPOINT5 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT5_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT (6U)
/*! STBY_EN_SETPOINT6 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT6_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT (7U)
/*! STBY_EN_SETPOINT7 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT7_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT (8U)
/*! STBY_EN_SETPOINT8 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT8_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT (9U)
/*! STBY_EN_SETPOINT9 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT9_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT (10U)
/*! STBY_EN_SETPOINT10 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT10_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT (11U)
/*! STBY_EN_SETPOINT11 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT11_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT (12U)
/*! STBY_EN_SETPOINT12 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT12_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT (13U)
/*! STBY_EN_SETPOINT13 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT13_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT (14U)
/*! STBY_EN_SETPOINT14 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT14_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT (15U)
/*! STBY_EN_SETPOINT15 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT15_MASK)
/*! @} */

/*! @name RBB_LPSR_STBY_EN_SP - RBB_LPSR_STBY_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT (0U)
/*! STBY_EN_SETPOINT0 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT0_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT (1U)
/*! STBY_EN_SETPOINT1 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT1_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT (2U)
/*! STBY_EN_SETPOINT2 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT2_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT (3U)
/*! STBY_EN_SETPOINT3 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT3_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT (4U)
/*! STBY_EN_SETPOINT4 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT4_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT (5U)
/*! STBY_EN_SETPOINT5 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT5_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT (6U)
/*! STBY_EN_SETPOINT6 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT6_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT (7U)
/*! STBY_EN_SETPOINT7 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT7_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT (8U)
/*! STBY_EN_SETPOINT8 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT8_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT (9U)
/*! STBY_EN_SETPOINT9 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT9_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT (10U)
/*! STBY_EN_SETPOINT10 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT10_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT (11U)
/*! STBY_EN_SETPOINT11 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT11_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT (12U)
/*! STBY_EN_SETPOINT12 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT12_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT (13U)
/*! STBY_EN_SETPOINT13 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT13_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT (14U)
/*! STBY_EN_SETPOINT14 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT14_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT (15U)
/*! STBY_EN_SETPOINT15 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT15_MASK)
/*! @} */

/*! @name FBB_M7_CONFIGURE - FBB_M7_CONFIGURE_REGISTER */
/*! @{ */

#define ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_PW_MASK (0xFU)
#define ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_PW_SHIFT (0U)
/*! WB_CFG_PW - wb_cfg_pw */
#define ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_PW(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_PW_SHIFT)) & ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_PW_MASK)

#define ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_NW_MASK (0xF0U)
#define ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_NW_SHIFT (4U)
/*! WB_CFG_NW - wb_cfg_nw */
#define ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_NW(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_NW_SHIFT)) & ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_NW_MASK)

#define ANADIG_PMU_FBB_M7_CONFIGURE_OSCILLATOR_BITS_MASK (0x700U)
#define ANADIG_PMU_FBB_M7_CONFIGURE_OSCILLATOR_BITS_SHIFT (8U)
/*! OSCILLATOR_BITS - oscillator_bits */
#define ANADIG_PMU_FBB_M7_CONFIGURE_OSCILLATOR_BITS(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_CONFIGURE_OSCILLATOR_BITS_SHIFT)) & ANADIG_PMU_FBB_M7_CONFIGURE_OSCILLATOR_BITS_MASK)

#define ANADIG_PMU_FBB_M7_CONFIGURE_REGULATOR_STRENGTH_MASK (0x3800U)
#define ANADIG_PMU_FBB_M7_CONFIGURE_REGULATOR_STRENGTH_SHIFT (11U)
/*! REGULATOR_STRENGTH - regulator_strength */
#define ANADIG_PMU_FBB_M7_CONFIGURE_REGULATOR_STRENGTH(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_CONFIGURE_REGULATOR_STRENGTH_SHIFT)) & ANADIG_PMU_FBB_M7_CONFIGURE_REGULATOR_STRENGTH_MASK)
/*! @} */

/*! @name RBB_LPSR_CONFIGURE - RBB_LPSR_CONFIGURE_REGISTER */
/*! @{ */

#define ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_PW_MASK (0xFU)
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_PW_SHIFT (0U)
/*! WB_CFG_PW - wb_cfg_pw */
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_PW(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_PW_SHIFT)) & ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_PW_MASK)

#define ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_NW_MASK (0xF0U)
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_NW_SHIFT (4U)
/*! WB_CFG_NW - wb_cfg_nw */
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_NW(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_NW_SHIFT)) & ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_NW_MASK)

#define ANADIG_PMU_RBB_LPSR_CONFIGURE_OSCILLATOR_BITS_MASK (0x700U)
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_OSCILLATOR_BITS_SHIFT (8U)
/*! OSCILLATOR_BITS - oscillator_bits */
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_OSCILLATOR_BITS(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_CONFIGURE_OSCILLATOR_BITS_SHIFT)) & ANADIG_PMU_RBB_LPSR_CONFIGURE_OSCILLATOR_BITS_MASK)

#define ANADIG_PMU_RBB_LPSR_CONFIGURE_REGULATOR_STRENGTH_MASK (0x3800U)
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_REGULATOR_STRENGTH_SHIFT (11U)
/*! REGULATOR_STRENGTH - regulator_strength */
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_REGULATOR_STRENGTH(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_CONFIGURE_REGULATOR_STRENGTH_SHIFT)) & ANADIG_PMU_RBB_LPSR_CONFIGURE_REGULATOR_STRENGTH_MASK)
/*! @} */

/*! @name RBB_SOC_CONFIGURE - RBB_SOC_CONFIGURE_REGISTER */
/*! @{ */

#define ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_PW_MASK (0xFU)
#define ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_PW_SHIFT (0U)
/*! WB_CFG_PW - wb_cfg_pw */
#define ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_PW(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_PW_SHIFT)) & ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_PW_MASK)

#define ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_NW_MASK (0xF0U)
#define ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_NW_SHIFT (4U)
/*! WB_CFG_NW - wb_cfg_nw */
#define ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_NW(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_NW_SHIFT)) & ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_NW_MASK)

#define ANADIG_PMU_RBB_SOC_CONFIGURE_OSCILLATOR_BITS_MASK (0x700U)
#define ANADIG_PMU_RBB_SOC_CONFIGURE_OSCILLATOR_BITS_SHIFT (8U)
/*! OSCILLATOR_BITS - oscillator_bits */
#define ANADIG_PMU_RBB_SOC_CONFIGURE_OSCILLATOR_BITS(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_CONFIGURE_OSCILLATOR_BITS_SHIFT)) & ANADIG_PMU_RBB_SOC_CONFIGURE_OSCILLATOR_BITS_MASK)

#define ANADIG_PMU_RBB_SOC_CONFIGURE_REGULATOR_STRENGTH_MASK (0x3800U)
#define ANADIG_PMU_RBB_SOC_CONFIGURE_REGULATOR_STRENGTH_SHIFT (11U)
/*! REGULATOR_STRENGTH - regulator_strength */
#define ANADIG_PMU_RBB_SOC_CONFIGURE_REGULATOR_STRENGTH(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_CONFIGURE_REGULATOR_STRENGTH_SHIFT)) & ANADIG_PMU_RBB_SOC_CONFIGURE_REGULATOR_STRENGTH_MASK)
/*! @} */

/*! @name REFTOP_OTP_TRIM_VALUE - REFTOP_OTP_TRIM_VALUE_REGISTER */
/*! @{ */

#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_IBZTCADJ_MASK (0x7U)
#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_IBZTCADJ_SHIFT (0U)
/*! REFTOP_IBZTCADJ - REFTOP_IBZTCADJ */
#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_IBZTCADJ(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_IBZTCADJ_SHIFT)) & ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_IBZTCADJ_MASK)

#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_VBGADJ_MASK (0x38U)
#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_VBGADJ_SHIFT (3U)
/*! REFTOP_VBGADJ - REFTOP_VBGADJ */
#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_VBGADJ(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_VBGADJ_SHIFT)) & ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_VBGADJ_MASK)

#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_TRIM_EN_MASK (0x40U)
#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_TRIM_EN_SHIFT (6U)
/*! REFTOP_TRIM_EN - REFTOP_TRIM_EN */
#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_TRIM_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_TRIM_EN_SHIFT)) & ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_TRIM_EN_MASK)
/*! @} */

/*! @name LPSR_1P8_LDO_OTP_TRIM_VALUE - LPSR_1P8_LDO_OTP_TRIM_VALUE_REGISTER */
/*! @{ */

#define ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_MASK (0x3U)
#define ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_SHIFT (0U)
/*! LPSR_LDO_1P8_TRIM - LPSR_LDO_1P8_TRIM */
#define ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_SHIFT)) & ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_MASK)

#define ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_EN_MASK (0x4U)
#define ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_EN_SHIFT (2U)
/*! LPSR_LDO_1P8_TRIM_EN - LPSR_LDO_1P8_TRIM_EN */
#define ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_EN_SHIFT)) & ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_EN_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ANADIG_PMU_Register_Masks */


/*!
 * @}
 */ /* end of group ANADIG_PMU_Peripheral_Access_Layer */


/*
** End of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic pop
  #else
    #pragma pop
  #endif
#elif defined(__CWCC__)
  #pragma pop
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=default
#else
  #error Not supported compiler type
#endif

/*!
 * @}
 */ /* end of group Peripheral_access_layer */


#endif  /* PERI_ANADIG_PMU_H_ */

