#include "fsl_debug_console.h"
#include "board.h"
#include "app.h"
#include "fsl_common.h"
#include "pin_mux.h"
#include "fsl_port.h"

#include "memory.h"
#include "dimage.h"

// define GPIO for LED
#define PORT_LED           kCLOCK_PortE
#define BOARD_LED_GPIO     BOARD_LED_RED_GPIO
#define BOARD_LED_PORT     BOARD_LED_RED_GPIO_PORT
#define BOARD_LED_GPIO_PIN BOARD_LED_RED_GPIO_PIN

static void initLED(void)
{
    /* Port LED Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(PORT_LED);
    PORT_SetPinMux(BOARD_LED_PORT, BOARD_LED_GPIO_PIN, kPORT_MuxAsGpio);
    /* Define the init structure for the output LED pin */
    gpio_pin_config_t led_config = {
        kGPIO_DigitalOutput,
        1,
    };
    /* Init output LED GPIO. */
    GPIO_PinInit(BOARD_LED_GPIO, BOARD_LED_GPIO_PIN, &led_config);
}

static void toggleLED(void)
{
    GPIO_PortToggle(BOARD_LED_GPIO, 1U << BOARD_LED_GPIO_PIN);
}

static void JumpToImage(uint32_t addr)
{
    uint32_t *vectorTable = (uint32_t*)addr;
    uint32_t sp = vectorTable[0];
    uint32_t pc = vectorTable[1];
    
    typedef void(*app_entry_t)(void);

    uint32_t s_stackPointer = 0;
    uint32_t s_applicationEntry = 0;
    app_entry_t s_application = 0;

    s_stackPointer = sp;
    s_applicationEntry = pc;
    s_application = (app_entry_t)s_applicationEntry;

    // Change MSP and PSP
    __set_MSP(s_stackPointer);
    __set_PSP(s_stackPointer);
    
    SCB->VTOR = addr;
    
    // Jump to application
    s_application();

    // Should never reach here.
    __NOP();
}

int main()
{
    BOARD_InitHardware();
	memory_init();

	if(!image_check_and_boot())
    {
        JumpToImage(GOLDEN_REGION_START);
    }

    initLED();
    while(1)
    {
    	toggleLED();
        SDK_DelayAtLeastUs(100000, SDK_DEVICE_MAXIMUM_CPU_CLOCK_FREQUENCY);
    }
}


