/*
 * Copyright 2020-2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __USB_AUDIO_H__
#define __USB_AUDIO_H__ 1


#ifdef __cplusplus
extern "C"{
#endif



/*******************************************************************************
* Definitions
******************************************************************************/


#define AUDIO_SAMPLING_RATE_TO_10_14 (AUDIO_OUT_SAMPLING_RATE_KHZ << 10)
//#define AUDIO_SAMPLING_RATE_TO_16_16 ((AUDIO_OUT_SAMPLING_RATE_KHZ/8) << 13)

#define AUDIO_SAMPLING_RATE_TO_16_16 \
    ((AUDIO_OUT_SAMPLING_RATE_KHZ / (AUDIO_OUT_TRANSFER_LENGTH_ONE_FRAME / HS_ISO_OUT_ENDP_PACKET_SIZE)) << 13)


#if (USB_DEVICE_CONFIG_AUDIO_CLASS_2_0)
	#if defined(USB_DEVICE_WORKAROUND_AUDIO_20_WINDOWS) && (USB_DEVICE_WORKAROUND_AUDIO_20_WINDOWS > 0)
		/* change 10.10 data to 10.14 or 16.16 (12.13) */
		#define AUDIO_UPDATE_FEEDBACK_DATA(m, n)                  \
			{                                                     \
				m[0] = (((n & 0x000003FFu) << 3) & 0xFFu);        \
				m[1] = ((((n & 0x000003FFu) << 3) >> 8) & 0xFFu); \
				m[2] = (((n & 0x000FFC00u) >> 10) & 0xFFu);       \
				m[3] = (((n & 0x000FFC00u) >> 18) & 0xFFu);       \
			}
	#else
		/* change 10.10 data to 10.14 or 16.16 (12.13) */
		#define AUDIO_UPDATE_FEEDBACK_DATA(m, n)                  \
			if (USB_SPEED_HIGH == g_composite.speed)              \
			{                                                     \
				m[0] = (((n & 0x000003FFu) << 3) & 0xFFu);        \
				m[1] = ((((n & 0x000003FFu) << 3) >> 8) & 0xFFu); \
				m[2] = (((n & 0x000FFC00u) >> 10) & 0xFFu);       \
				m[3] = (((n & 0x000FFC00u) >> 18) & 0xFFu);       \
			}                                                     \
			else                                                  \
			{                                                     \
				m[0] = ((n << 4) & 0xFFU);                        \
				m[1] = (((n << 4) >> 8U) & 0xFFU);                \
				m[2] = (((n << 4) >> 16U) & 0xFFU);               \
			}
	#endif
#else
	/* change 10.10 data to 10.14 */
	#define AUDIO_UPDATE_FEEDBACK_DATA(m, n)                     \
		{                                                        \
			feedbackValueUpdating = 1;                           \
			m[0]                  = ((n << 4) & 0xFFU);          \
			m[1]                  = (((n << 4) >> 8U) & 0xFFU);  \
			m[2]                  = (((n << 4) >> 16U) & 0xFFU); \
			feedbackValueUpdating = 0;                           \
		}
#endif


#define AUDIO_SPEAKER_UsbDnBufLengthInMs  			(5)
#define AUDIO_SPEAKER_UsbDnBufCenterLevelInSamples  (AUDIO_SPEAKER_UsbDnBufLengthInMs*AUDIO_OUT_SAMPLING_RATE_KHZ/2)


#define TSAMFREQ2BYTES(f)                       (f & 0xFFU), ((f >> 8U) & 0xFFU), ((f >> 16U) & 0xFFU)
#define TSAMFREQ2BYTESHS(f)                     (f & 0xFFU), ((f >> 8U) & 0xFFU), ((f >> 16U) & 0xFFU), ((f >> 24U) & 0xFFU)
#define AUDIO_ADJUST_MIN_STEP                   (0x01)

//#define AUDIO_OUT_TRANSFER_LENGTH_ONE_FRAME 	(AUDIO_OUT_SAMPLING_RATE_KHZ * AUDIO_OUT_FORMAT_CHANNELS * AUDIO_OUT_FORMAT_SIZE)
#define AUDIO_PLAY_BUFFER_SIZE_ONE_FRAME 		AUDIO_OUT_TRANSFER_LENGTH_ONE_FRAME

#if defined(USB_DEVICE_AUDIO_USE_SYNC_MODE) && (USB_DEVICE_AUDIO_USE_SYNC_MODE > 0U)
/**********************************************************************
Audio PLL contants
      AUDIO_PLL_USB1_SOF_INTERVAL_COUNT
      The Audio PLL clock is 24.576Mhz, and the USB1_SOF_TOGGLE frequency is 4kHz when the device is attached,
      so AUDIO_PLL_USB1_SOF_INTERVAL_COUNT = (24576000 * 100 (stands for counter interval)) /4000 = 614400
      AUDIO_PLL_FRACTIONAL_CHANGE_STEP
      The Audio input clock is 24Mhz, and denominator is 4500, divider is 15 and PFD is 26.
      so AUDIO_PLL_FRACTIONAL_CHANGE_STEP = (24000000 * 100 (stands for counter interval) * 18) / (27000 * 26 * 15
*4000) + 1
**********************************************************************/
#define AUDIO_PLL_USB1_SOF_INTERVAL_COUNT  (614400) /* The USB1_SOF_TOGGLE's frequency is 4kHz. */
#define AUDIO_PLL_USB1_SOF_INTERVAL_COUNT1 (491520) /* The USB1_SOF_TOGGLE's frequency is 4kHz. */
#define AUDIO_PLL_FRACTIONAL_CHANGE_STEP   (2)
#else
#endif
	/* feedback calculate interval */
	#define AUDIO_CALCULATE_Ff_INTERVAL (16U)
	//#define AUDIO_CALCULATE_Ff_INTERVAL (256U)
	//#define AUDIO_CALCULATE_Ff_INTERVAL (512U)
	//#define AUDIO_CALCULATE_Ff_INTERVAL (1024U)		//doing the feedback once every 1024,512,256 ms doesn't seem to have any difference --- by watching the VCOM reported data
	/* the threshold transfer count that can tolerance by frame */
	#define USB_AUDIO_PLAY_BUFFER_FEEDBACK_TOLERANCE_THRESHOLD (4U)
	/* feedback value discard times, the first feedback vaules are discarded */
	#define AUDIO_SPEAKER_FEEDBACK_DISCARD_COUNT (4U)

#define MUTE_CODEC_TASK    (1UL << 0U)
#define UNMUTE_CODEC_TASK  (1UL << 1U)
#define VOLUME_CHANGE_TASK (1UL << 2U)

typedef struct _usb_audio_composite_struct
{
    usb_device_handle deviceHandle;    /* USB device handle.                   */
    class_handle_t audioSpeakerHandle; /* USB AUDIO GENERATOR class handle.    */
    uint32_t currentStreamOutMaxPacketSize;
    uint32_t currentFeedbackMaxPacketSize;
    class_handle_t audioRecorderHandle;
    uint8_t copyProtect;
    __attribute__((aligned(4)))
    uint8_t curMute;
    __attribute__((aligned(4)))
    uint8_t curVolume[2];
    __attribute__((aligned(4)))
    uint8_t minVolume[2];
    __attribute__((aligned(4)))
    uint8_t maxVolume[2];
    __attribute__((aligned(4)))
    uint8_t resVolume[2];
    uint8_t curBass;
    uint8_t minBass;
    uint8_t maxBass;
    uint8_t resBass;
    uint8_t curMid;
    uint8_t minMid;
    uint8_t maxMid;
    uint8_t resMid;
    uint8_t curTreble;
    uint8_t minTreble;
    uint8_t maxTreble;
    uint8_t resTreble;
    uint8_t curAutomaticGain;
#if (USB_DEVICE_CONFIG_AUDIO_CLASS_2_0)
    uint8_t curDelay[4];
    uint8_t minDelay[4];
    uint8_t maxDelay[4];
    uint8_t resDelay[4];
#else
    uint8_t curDelay[2];
    uint8_t minDelay[2];
    uint8_t maxDelay[2];
    uint8_t resDelay[2];
#endif
    uint8_t curLoudness;
    uint8_t curSamplingFrequency[3];
    uint8_t minSamplingFrequency[3];
    uint8_t maxSamplingFrequency[3];
    uint8_t resSamplingFrequency[3];
#if (USB_DEVICE_CONFIG_AUDIO_CLASS_2_0)
    uint8_t curMute20;
    uint8_t curClockValid;
    uint8_t curVolume20[2];
    uint32_t curSampleFrequency;
    usb_device_control_range_layout3_struct_t freqControlRange;
    usb_device_control_range_layout2_struct_t volumeControlRange;
#endif
    uint8_t currentConfiguration;
    uint8_t currentInterfaceAlternateSetting[USB_AUDIO_COMPOSITE_INTERFACE_COUNT];
    uint8_t speed;
    uint8_t attach;
    volatile uint8_t startPlay;
    volatile uint8_t startPlayHalfFull;
    //volatile uint32_t UsbDnStrmBuf_WrPosInByte;
    //volatile uint32_t UsbDnStrmBuf_RdPosInByte;
    volatile uint32_t audioSendCount;
    volatile uint32_t lastAudioSendCount;
    volatile uint32_t usbRecvCount;
    //volatile uint32_t audioSendTimes;
    //volatile uint32_t usbRecvTimes;
    volatile uint32_t speakerIntervalCount;
    volatile uint32_t UsbDnStrmBuf_OccupiedSpaceInByte;
    volatile uint32_t timesFeedbackCalculate;
    volatile uint32_t speakerDetachOrNoInput;
    volatile uint32_t codecTask;
    uint32_t audioPlayTransferSize;
    volatile uint16_t audioPlayBufferSize;

#if defined(USB_DEVICE_AUDIO_USE_SYNC_MODE) && (USB_DEVICE_AUDIO_USE_SYNC_MODE > 0U)
    volatile uint32_t curAudioPllFrac;
    volatile uint32_t audioPllTicksPrev;
    volatile int32_t audioPllTicksDiff;
    volatile int32_t audioPllTicksEma;
    volatile int32_t audioPllTickEmaFrac;
    volatile int32_t audioPllStep;
    volatile int32_t stopDataLengthAudioAdjust;
#else
    volatile uint32_t maxFrameCount;
    volatile uint32_t lastFrameCount;
    volatile uint32_t currentFrameCount;
    volatile uint8_t firstCalculateFeedback;
    volatile uint8_t stopFeedbackUpdate;
    volatile uint32_t lastFeedbackValue;
    volatile uint8_t feedbackDiscardFlag;
    volatile uint8_t feedbackDiscardTimes;
#endif
} usb_audio_composite_struct_t;

extern volatile int AsrcInputBufIsReady;



#ifdef __cplusplus
}
#endif

#endif /* __USB_AUDIO_GENERATOR_H__ */
