/*
 * Copyright 2020-2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */



#ifndef _NxpCm7SRCT_H_
#define _NxpCm7SRCT_H_




enum AsrcQualityLevel
{
	ASRC_QualityHigh,
	ASRC_QualityMidHigh,
	ASRC_QualityMidLow,
	ASRC_QualityLow
};

enum AsrcReturnStat
{
	ReturnStat_Success,
	ReturnStat_NotNxpChip,
	ReturnStat_BadInputArgument,
	ReturnStat_ApplyHeapSpaceFail,
};



typedef struct
{
	//public
	unsigned int InputFrameLengthInSample;      //should be always multiples of 6
	unsigned int InputFsInHz;
	unsigned int ChNumber;
	double AsrcRatio;
	//the reserved space CAN NOT be deleted!!!
	unsigned int reserved[24];					//MUST NOT be deleted!!!
} T_ASRCProcessor;



extern float Asm_DotProduct(float *PtrX, float *PtrY, int l);

extern int InitAsrcProcessor(T_ASRCProcessor *Asrc, int FsIn, float Drift_FsOutDivFsIn, int FrmSizeInSamples, enum AsrcQualityLevel QualityLvlIdx, int UseCubic, int ChNum);
extern void DeInitAsrcProcessor(T_ASRCProcessor *Asrc);

extern int AsrcConvertOneFrame(T_ASRCProcessor *Asrc,float *DstPtr, float *SrcPtr);
extern void UpdateAsrcRatio(T_ASRCProcessor *Asrc, double r);
extern void UpdateAsrcInterp(T_ASRCProcessor *Asrc, int ToUseCubic);

extern void MoveFloatSamplesToS32Buf_4SampleGrouped(int *DstPtr, float *SrcPtr, int LengthIn8SamplesBlock);
extern void MoveS32SamplesToFloatBuf_4SampleGrouped(float *DstPtr, int *SrcPtr, int LengthIn8SamplesBlock);
extern void MoveFloatSamplesToS32Buf_6SampleGrouped(int *DstPtr, float *SrcPtr, int LengthIn8SamplesBlock);
extern void MoveS32SamplesToFloatBuf_6SampleGrouped(float *DstPtr, int *SrcPtr, int LengthIn8SamplesBlock);
extern void MoveFloatSamplesToS32Buf_5SampleGrouped(int *DstPtr, float *SrcPtr, int LengthIn8SamplesBlock);
extern void MoveFloatSamplesToS32Buf_7SampleGrouped(int *DstPtr, float *SrcPtr, int LengthIn8SamplesBlock);

#endif






