/*
 * Copyright 2018-2025 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __SubFunc___
#define __SubFunc___


#define PinLedR		31
#define PinLedB		26

#define DbgPin1Idx		3
#define DbgPin2Idx		4
#define DbgPin3Idx		19
#define DbgPin4Idx		20

#define     LedOn_R()                   GPIO_PinWrite(GPIO, 0, PinLedR, 1)
#define     LedOff_R()                  GPIO_PinWrite(GPIO, 0, PinLedR, 0)
#define     LedOn_B()                   GPIO_PinWrite(GPIO, 0, PinLedB, 1)
#define     LedOff_B()                  GPIO_PinWrite(GPIO, 0, PinLedB, 0)

#define     DbgPin1Up                 GPIO_PinWrite(GPIO, 0, DbgPin1Idx, 1)
#define     DbgPin1Dn                 GPIO_PinWrite(GPIO, 0, DbgPin1Idx, 0)
#define     DbgPin2Up                 GPIO_PinWrite(GPIO, 0, DbgPin2Idx, 1)
#define     DbgPin2Dn                 GPIO_PinWrite(GPIO, 0, DbgPin2Idx, 0)
#define     DbgPin3Up                 GPIO_PinWrite(GPIO, 0, DbgPin3Idx, 1)
#define     DbgPin3Dn                 GPIO_PinWrite(GPIO, 0, DbgPin3Idx, 0)
#define     DbgPin4Up                 GPIO_PinWrite(GPIO, 0, DbgPin4Idx, 1)
#define     DbgPin4Dn                 GPIO_PinWrite(GPIO, 0, DbgPin4Idx, 0)


extern void OpeningBlink(unsigned int l);


extern void InitDbgPin(void);
extern void delay_us(unsigned int d);
extern void delay_ms(unsigned int d);



#endif

