/*
 * Copyright 2018-2025 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __AudioIoInit_h__
#define __AudioIoInit_h__

#include "GlobalDef.h"

#define DEMO_I2S_MASTER_CLOCK_FREQUENCY CLOCK_GetMclkClkFreq()

#define DEMO_I2S_TX0 (I2S1)	//FlexComm1
#define DEMO_I2S_RX0 (I2S2)	//FlexComm2
#define DEMO_I2S_TX1 (I2S3)	//FlexComm3

#define I2S_FlexComm1_DMA_CHANNEL (3)		//flexcomm1 tx0 P0.9
#define I2S_FlexComm2_DMA_CHANNEL (4)		//flexcomm2 rx0 P0.16
#define I2S_FlexComm3_DMA_CHANNEL (7)		//flexcomm3 tx1 P0.23	--- this is the audio to the on-board CODEC DAC

//JP7.1 JP7.2 should be closed --- this is to have I2S audio output to CODEC, write Tx1, I2SOutputCh2 and 3
//JP8.2 JP8.3 should be closed --- this is to have I2S audio output to AMP, write Tx0, I2SOutputCh0 and 1
//P0.16 (J47.7) is the I2S input, can route ADC input from onboard CODEC from JP8.1


#define DEMO_I2S_CLOCK_DIVIDER                                                                                 \
	(24576000U / 48000U / 32U / 2) /* I2S source clock 24.576MHZ, sample rate 48KHZ, bits width 16, 2 channel, \
								  so bitclock should be 48KHZ * 16 = 768KHZ, divider should be 24.576MHZ / 768KHZ */

#define DEMO_DMA (DMA0)			//DMA0 is for MCU side


#define DEMO_I2S_TX_MODE 		kI2S_MasterSlaveNormalSlave
#define DEMO_I2S_RX_MODE 		kI2S_MasterSlaveNormalSlave


//---------------var for I2S Rx0,Tx0,Tx1 DMA IO----------------- beg------
extern volatile int I2SRxBufCh0And1Mixed_A[AudioFrameSizeInSamplePerCh*2];
extern volatile int I2SRxBufCh0And1Mixed_B[AudioFrameSizeInSamplePerCh*2];
extern volatile int I2STxBufCh0And1Mixed_A[AudioFrameSizeInSamplePerCh*2];
extern volatile int I2STxBufCh0And1Mixed_B[AudioFrameSizeInSamplePerCh*2];
extern volatile int I2STxBufCh2And3Mixed_A[AudioFrameSizeInSamplePerCh*2];
extern volatile int I2STxBufCh2And3Mixed_B[AudioFrameSizeInSamplePerCh*2];
//---------------var for I2S Rx0,Tx0,Tx1 DMA IO----------------- end------

extern volatile unsigned char I2STxDmaTransferringIsUsingBufA;
extern volatile unsigned char OneFrameI2SAudioOutputTxIsFinished;

extern void BOARD_Init_DMA(void);
extern void BOARD_Init_I2S(void);
extern void CreateAndStartFlexcommTxAudioDMA(void);
extern void CreateAndStartFlexcomm2RxAudioDMA(void);



#endif
