/*
 * Copyright 2018-2025 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */



#ifndef __IIR_H_INCLUDED
#define __IIR_H_INCLUDED

#include "GlobalDef.h"


#define SineToneGeneratorIsDouble

typedef struct
{
	float	A,fBeg,fEnd;
	float	CycleLengthInS;
	unsigned int		Fs;
	unsigned int		CurrentI;
	unsigned int		FinalI;
	#ifdef SineToneGeneratorIsDouble
		double	k, p, fCurrent;
		double	tCurrent;
		double  PhaseOfPrevFrameLastSample;
	#else
		float	k, p, fCurrent;
		float	tCurrent;
		float   PhaseOfPrevFrameLastSample;
	#endif
	float	FbegDividedByFs;
}TSineToneGenerator;

extern TSineToneGenerator SineToneGenerator1,SineToneGenerator2;
extern void InitSineToneGenerator(TSineToneGenerator *PtrSinGen, float A, float fBeg, float fEnd, float TimeInS, unsigned int Fs);
extern void GenerateSineTone          (TSineToneGenerator *PtrSinGen, float *DstPtr, unsigned int SampleNumToGen, int PosNeg);
extern void GenerateSineToneSingleFreq(TSineToneGenerator* PtrSinGen, float* DstPtr, unsigned int SampleNumToGen, int PosNeg);

#ifdef __cplusplus
}
#endif
#endif
