/*
 * Copyright 2018-2025 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __GlobalDef_h__
#define __GlobalDef_h__

#define EnableAsrcLatencyTest		0


#define Pi_Value	3.1415926535897932384626

#define _Pow2_15_       (short int)32768
#define _Pow2_14_       (short int)16384

#define _Pow2_30_       1073741824
#define _Pow2_30_M1_ 	1073741823
#define _Pow2_31_       2147483648
#define _Pow2_31_M1_    2147483647


//#define DisableDbgPin

#define DbgPin1Idx		3
#define DbgPin2Idx		4
#define DbgPin3Idx		19
#define DbgPin4Idx		20

#define PinLedR		31
#define PinLedG		14
#define PinLedB		26

#define     LedOn_R()                   GPIO_PinWrite(GPIO, 0, PinLedR, 1)
#define     LedOff_R()                  GPIO_PinWrite(GPIO, 0, PinLedR, 0)
#define     LedOn_G()                   GPIO_PinWrite(GPIO, 0, PinLedG, 1)
#define     LedOff_G()                  GPIO_PinWrite(GPIO, 0, PinLedG, 0)
#define     LedOn_B()                   GPIO_PinWrite(GPIO, 0, PinLedB, 1)
#define     LedOff_B()                  GPIO_PinWrite(GPIO, 0, PinLedB, 0)

#ifdef DisableDbgPin
	#define     DbgPin1Up
	#define     DbgPin1Dn
	#define     DbgPin2Up
	#define     DbgPin2Dn
	#define     DbgPin3Up
	#define     DbgPin3Dn
	#define     DbgPin4Up
	#define     DbgPin4Dn
#else
	#define     DbgPin1Up                 GPIO_PinWrite(GPIO, 0, DbgPin1Idx, 1)
	#define     DbgPin1Dn                 GPIO_PinWrite(GPIO, 0, DbgPin1Idx, 0)
	#define     DbgPin2Up                 GPIO_PinWrite(GPIO, 0, DbgPin2Idx, 1)
	#define     DbgPin2Dn                 GPIO_PinWrite(GPIO, 0, DbgPin2Idx, 0)
	#define     DbgPin3Up                 GPIO_PinWrite(GPIO, 0, DbgPin3Idx, 1)
	#define     DbgPin3Dn                 GPIO_PinWrite(GPIO, 0, DbgPin3Idx, 0)
	#define     DbgPin4Up                 GPIO_PinWrite(GPIO, 0, DbgPin4Idx, 1)
	#define     DbgPin4Dn                 GPIO_PinWrite(GPIO, 0, DbgPin4Idx, 0)
#endif


#define APP_SEMA42		SEMA42
#define SEMA42_GATE		0U


#define APP_MU			MUB
#define CHN_MU_REG_NUM	0U
#define BOOT_FLAG		0x01U
#define APP_MU_IRQn		6

#include "..\..\Rt685_CadenceAsrc_McuPrg\source\DefForBothMcuAndDsp.h"


#endif
