/*
 * Copyright 2024 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


#define Pi_Value		3.1415926535897932384626
#define _Pow2_31_M1_   	2147483647

//In LPC55S69 prj, should never enable double here, LPC55S69 is not fast enough

//#define SineToneGeneratorIsDouble

typedef struct
{
	float	A,fBeg,fEnd;
	float	CycleLengthInS;
	unsigned int		Fs;
	unsigned int		CurrentI;
	unsigned int		FinalI;
	#ifdef SineToneGeneratorIsDouble
		double	k, p, fCurrent;
		double	tCurrent;
		double  PhaseOfPrevFrameLastSample;
	#else
		float	k, p, fCurrent;
		float	tCurrent;
		float   PhaseOfPrevFrameLastSample;
	#endif
	float	FbegDividedByFs;
}TSineToneGenerator;



extern TSineToneGenerator SineToneGenerator;
extern void InitSineToneGenerator(TSineToneGenerator *PtrSinGen, float A, float fBeg, float fEnd, float TimeInS, unsigned int Fs);
extern void GenerateSineTone(TSineToneGenerator *PtrSinGen, int *DstPtr, unsigned int SampleNumToGen, int PosNeg);
extern void GenerateSineToneSingleFreq(TSineToneGenerator* PtrSinGen, int* DstPtr, unsigned int SampleNumToGen, int PosNeg);


