/*
 * Copyright 2018-2020, 2024 NXP
 * SPDX-License-Identifier: BSD-3-Clause
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms.  By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms.  If you do not agree to
 * be bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef AUDIO_LATENCY_DEBUG_H_
#define AUDIO_LATENCY_DEBUG_H_

#include <stdbool.h>

/**
 * Initialization of AUDIO latency debug functionality.
 *
 * This is most likely BSP specific.
 * The default implementation of this is an empty function.
 */
__attribute__((weak)) void AUDIO_LatencyDebug_Init(void);

/**
 * Indicate audio is being send over I2S.
 *
 * This is most likely BSP specific.
 * The default implementation of this is an empty function.
 *
 * @param sending Flag indicating if audio is being sent
 */
__attribute__((weak)) void AUDIO_LatencyDebug_SendingAudioToI2s(bool sending);

/**
 * Indicate audio is being read from I2S.
 *
 * This is most likely BSP specific.
 * The default implementation of this is an empty function.
 *
 * @param receiving Flag indicating if audio is being received
 */
__attribute__((weak)) void AUDIO_LatencyDebug_ReceivingAudioFromI2s(bool receiving);

/**
 * Deinit of AUDIO latency debug functionality.
 *
 * This is most likely BSP specific.
 * The default implementation of this is an empty function.
 */
__attribute__((weak)) void AUDIO_LatencyDebug_Deinit(void);


__attribute__((weak)) void USB_LatencyDebug_Init(void);

__attribute__((weak)) void USB_LatencyDebug_ReceivingAudioFromHost(bool receiving);

__attribute__((weak)) void USB_LatencyDebug_SendingAudioToHost(bool transmitting);

__attribute__((weak)) void USB_LatencyDebug_Deinit(void);


#endif /* AUDIO_LATENCY_DEBUG_H_ */
