/****************************************************************************
**
** Copyright 2024 NXP
**
** SPDX-License-Identifier: BSD-3-Clause
**
****************************************************************************/

#include <pthread.h>
#include <mqueue.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include "gui_guider.h"
#include "../lvgl/src/core/lv_event.h"

#define WW_QUEUE_NAME "/wakeword_queue"
#define CMD_QUEUE_NAME "/command_queue"

#define MAX_SIZE            1024
#define MAX_MSG             10
#define MAX_MSG_SIZE        256
#define BUFFER_SIZE         10

#define VIT_WW_NUMBER       2
#define VIT_CMD_NUMBER      5

#define HANDLER_VERBOSE     0

typedef enum{
    HEY_NXP = 1,
    HEY_LED = 2,
}voice_ww_t;

typedef enum{
    UNKNOWN,
    NEXT,
    RETURN,
    TURN_ON,
    TURN_OFF,
}voice_cmd_t;

typedef struct {
    lv_obj_t ** obj;
    lv_event_code_t cmd;
}event_sender_t;

void start_command_handler(void);
void command_handler_link(voice_ww_t WW_Id, voice_cmd_t CMD, lv_obj_t** obj, lv_event_code_t event);
