/*
 * Copyright 2018-2020 NXP
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms.  By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms.  If you do not agree to
 * be bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef AUDIOCODEC_VOLUME_DA7212_H_
#define AUDIOCODEC_VOLUME_DA7212_H_

/**
 * These values are dependant on how the volume is controlled on the codec
 * F.e. If audio is controlled on ADC, input gain, output gain, DAC, ... different volume ranges may apply
 */

/**
 * DA7212 max input volume on input gain block
 */
#define AUDIOCODEC_MAX_INPUT_VOLUME_DB  (0u)
/**
 * DA7212 min input volume on input gain block
 */
#define AUDIOCODEC_MIN_INPUT_VOLUME_DB  (-83)
/**
 * Resolution of DA7212 input gain block
 */
#define AUDIOCODEC_INPUT_VOLUME_RES_DB  (1u)

/**
 * DA7212 max output volume on headphone output block
 */
#define AUDIOCODEC_MAX_OUTPUT_VOLUME_DB  (0u)
/**
 * DA7212 min output volume on headphone output block
 */
#define AUDIOCODEC_MIN_OUTPUT_VOLUME_DB  (-77)
/**
 * Resolution of DA7212 headphone output block
 * Smaller resolution is possible but took 1 dB for convenience reasons (USB service is equipped to handle whole numbers)
 */
#define AUDIOCODEC_OUTPUT_VOLUME_RES_DB  (1u)

#endif /* AUDIOCODEC_VOLUME_DA7212_H_ */
